/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.feature.FeatureVector;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.DoubleFV2FImage;
import org.openimaj.image.feature.FImage2DoubleFV;
import org.openimaj.io.IOUtils;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.math.matrix.algorithm.pca.PrincipalComponentAnalysis;
import org.openimaj.math.matrix.algorithm.pca.ThinSvdPrincipalComponentAnalysis;
import org.openimaj.ml.pca.FeatureVectorPCA;
import org.openimaj.ml.training.BatchTrainer;
import org.openimaj.util.array.ArrayUtils;

@Reference(type=ReferenceType.Inproceedings, author={"Turk, M.A.", "Pentland, A.P."}, title="Face recognition using eigenfaces", year="1991", booktitle="Computer Vision and Pattern Recognition, 1991. Proceedings CVPR '91., IEEE Computer Society Conference on", pages={"586 ", "591"}, month="jun", number="", volume="", customData={"keywords", "eigenfaces;eigenvectors;face images;face recognition system;face space;feature space;human faces;two-dimensional recognition;unsupervised learning;computerised pattern recognition;eigenvalues and eigenfunctions;", "doi", "10.1109/CVPR.1991.139758"})
public class EigenImages
implements BatchTrainer<FImage>,
FeatureExtractor<DoubleFV, FImage>,
ReadWriteableBinary {
    private FeatureVectorPCA pca;
    private int width;
    private int height;
    private int numComponents;

    protected EigenImages() {
    }

    public EigenImages(int numComponents) {
        this.numComponents = numComponents;
        this.pca = new FeatureVectorPCA((PrincipalComponentAnalysis)new ThinSvdPrincipalComponentAnalysis(numComponents));
    }

    public DoubleFV extractFeature(FImage img) {
        DoubleFV feature = FImage2DoubleFV.INSTANCE.extractFeature(img);
        return this.pca.project((FeatureVector)feature);
    }

    public void train(List<? extends FImage> data) {
        double[][] features = new double[data.size()][];
        this.width = data.get((int)0).width;
        this.height = data.get((int)0).height;
        for (int i = 0; i < features.length; ++i) {
            features[i] = (double[])FImage2DoubleFV.INSTANCE.extractFeature((FImage)data.get((int)i)).values;
        }
        this.pca.learnBasis((double[][])features);
    }

    public FImage reconstruct(DoubleFV weights) {
        return DoubleFV2FImage.extractFeature(this.pca.generate(weights), this.width, this.height);
    }

    public FImage reconstruct(double[] weights) {
        return new FImage(ArrayUtils.reshapeFloat((double[])this.pca.generate(weights), (int)this.width, (int)this.height));
    }

    public FImage visualisePC(int pc) {
        return new FImage(ArrayUtils.reshapeFloat((double[])this.pca.getPrincipalComponent(pc), (int)this.width, (int)this.height)).normalise();
    }

    public void readBinary(DataInput in) throws IOException {
        this.width = in.readInt();
        this.height = in.readInt();
        this.numComponents = in.readInt();
        this.pca = (FeatureVectorPCA)IOUtils.read((DataInput)in);
    }

    public byte[] binaryHeader() {
        return "EigI".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.width);
        out.writeInt(this.height);
        out.writeInt(this.numComponents);
        IOUtils.write((Object)this.pca, (DataOutput)out);
    }

    public String toString() {
        return String.format("EigenImages[width=%d; height=%d; pca=%s]", this.width, this.height, this.pca);
    }

    public int getNumComponents() {
        return this.numComponents;
    }
}

