/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;

@Reference(type=ReferenceType.Inproceedings, author={"Jose San Pedro", "Stefan Siersdorfer"}, title="Ranking and Classifying Attractiveness of Photos in Folksonomies", year="2009", booktitle="18th International World Wide Web Conference", pages={"771", "", "771"}, url="http://www2009.eprints.org/78/", month="April")
public class RMSContrast
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    double contrast;

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.contrast});
    }

    public void analyseImage(FImage image) {
        int x;
        int y;
        int width = image.width;
        int height = image.height;
        double avg = 0.0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                avg += (double)image.pixels[y][x];
            }
        }
        avg /= (double)(width * height);
        this.contrast = 0.0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                double delta = (double)image.pixels[y][x] - avg;
                this.contrast += delta * delta;
            }
        }
        this.contrast /= (double)(height * width - 1);
    }

    public double getContrast() {
        return this.contrast;
    }
}

