/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.pixel.statistics.MaskingHistogramModel;
import org.openimaj.image.saliency.LuoTangSubjectRegion;
import org.openimaj.math.statistics.distribution.MultidimensionalHistogram;

@Reference(type=ReferenceType.Inproceedings, author={"Luo, Yiwen", "Tang, Xiaoou"}, title="Photo and Video Quality Evaluation: Focusing on the Subject", year="2008", booktitle="Proceedings of the 10th European Conference on Computer Vision: Part III", pages={"386", "399"}, url="http://dx.doi.org/10.1007/978-3-540-88690-7_29", publisher="Springer-Verlag", series="ECCV '08", customData={"isbn", "978-3-540-88689-1", "location", "Marseille, France", "numpages", "14", "doi", "10.1007/978-3-540-88690-7_29", "acmid", "1478204", "address", "Berlin, Heidelberg"})
public class LuoSimplicity
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    LuoTangSubjectRegion extractor;
    int binsPerBand = 16;
    float gamma = 0.01f;
    double simplicity;

    public LuoSimplicity() {
        this.extractor = new LuoTangSubjectRegion();
    }

    public LuoSimplicity(int binsPerBand, float gamma, float alpha, int maxKernelSize, int kernelSizeStep, int nbins, int windowSize) {
        this.extractor = new LuoTangSubjectRegion(alpha, maxKernelSize, kernelSizeStep, nbins, windowSize);
        this.binsPerBand = binsPerBand;
        this.gamma = gamma;
    }

    public void analyseImage(MBFImage image) {
        Transforms.calculateIntensityNTSC((MBFImage)image).analyseWith((ImageAnalyser)this.extractor);
        FImage mask = this.extractor.getROIMap().inverse();
        MaskingHistogramModel hm = new MaskingHistogramModel(mask, this.binsPerBand, this.binsPerBand, this.binsPerBand);
        hm.estimateModel(image);
        MultidimensionalHistogram fv = hm.getFeatureVector();
        double thresh = (double)this.gamma * fv.max();
        int count = 0;
        for (double f : (double[])fv.values) {
            if (!(f >= thresh)) continue;
            ++count;
        }
        this.simplicity = (double)count / (double)((double[])fv.values).length;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.simplicity});
    }
}

