/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.algorithm.histogram.BinnedWindowedExtractor;
import org.openimaj.image.analysis.algorithm.histogram.InterpolatedBinnedWindowedExtractor;
import org.openimaj.image.pixel.sampling.QuadtreeSampler;
import org.openimaj.image.processing.convolution.FImageGradients;
import org.openimaj.image.processing.edges.CannyEdgeDetector;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.statistics.distribution.Histogram;

@Reference(type=ReferenceType.Inproceedings, author={"Bosch, Anna", "Zisserman, Andrew", "Munoz, Xavier"}, title="Representing shape with a spatial pyramid kernel", year="2007", booktitle="Proceedings of the 6th ACM international conference on Image and video retrieval", pages={"401", "", "408"}, url="http://doi.acm.org/10.1145/1282280.1282340", publisher="ACM", series="CIVR '07", customData={"isbn", "978-1-59593-733-9", "location", "Amsterdam, The Netherlands", "numpages", "8", "doi", "10.1145/1282280.1282340", "acmid", "1282340", "address", "New York, NY, USA", "keywords", "object and video retrieval, shape features, spatial pyramid kernel"})
public class PHOG
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    private int nlevels = 3;
    private ImageProcessor<FImage> edgeDetector;
    private FImageGradients.Mode orientationMode;
    private BinnedWindowedExtractor histExtractor;
    private Rectangle lastBounds;
    private FImage magnitudes;

    public PHOG() {
        this(4, 40, FImageGradients.Mode.Signed);
    }

    public PHOG(int nlevels, int nbins, FImageGradients.Mode orientationMode) {
        this(nlevels, nbins, true, orientationMode, (ImageProcessor<FImage>)new CannyEdgeDetector());
    }

    public PHOG(int nlevels, int nbins, boolean histogramInterpolation, FImageGradients.Mode orientationMode, ImageProcessor<FImage> edgeDetector) {
        this.nlevels = nlevels;
        this.edgeDetector = edgeDetector;
        this.orientationMode = orientationMode;
        this.histExtractor = histogramInterpolation ? new InterpolatedBinnedWindowedExtractor(nbins, true) : new BinnedWindowedExtractor(nbins);
        this.histExtractor.setMax(orientationMode.maxAngle());
        this.histExtractor.setMin(orientationMode.minAngle());
    }

    public void analyseImage(FImage image) {
        this.lastBounds = image.getBounds();
        FImageGradients gradMag = FImageGradients.getGradientMagnitudesAndOrientations((FImage)image, (FImageGradients.Mode)this.orientationMode);
        this.magnitudes = gradMag.magnitudes;
        this.histExtractor.analyseImage(gradMag.orientations);
        if (this.edgeDetector != null) {
            this.magnitudes.multiplyInplace((FImage)image.process(this.edgeDetector));
        }
    }

    public Histogram getFeatureVector(Rectangle rect) {
        QuadtreeSampler sampler = new QuadtreeSampler(rect, this.nlevels + 1);
        Histogram hist = new Histogram(0);
        for (Rectangle r : sampler) {
            Histogram h = this.histExtractor.computeHistogram(r, this.magnitudes);
            hist = hist.combine(new Histogram[]{h});
        }
        hist.normaliseL1();
        return hist;
    }

    public Histogram getFeatureVector() {
        return this.getFeatureVector(this.lastBounds);
    }
}

