/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.binarypattern;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.Pixel;

@Reference(type=ReferenceType.Article, author={"Tan, Xiaoyang", "Triggs, Bill"}, title="Enhanced local texture feature sets for face recognition under difficult lighting conditions", year="2010", journal="Trans. Img. Proc.", pages={"1635", "", "1650"}, url="http://dx.doi.org/10.1109/TIP.2010.2042645", month="June", number="6", publisher="IEEE Press", volume="19")
public class LocalTernaryPattern
implements ImageAnalyser<FImage> {
    protected int[][] positiveBinaryPattern;
    protected int[][] negativeBinaryPattern;
    protected int[][] ternaryPattern;
    protected float radius;
    protected int samples;
    protected float threshold;

    public LocalTernaryPattern(float radius, int samples, float threshold) {
        LocalTernaryPattern.checkParams(radius, samples);
        this.radius = radius;
        this.samples = samples;
        this.threshold = threshold;
    }

    public static int[][][] calculateLTP(FImage image, float radius, int samples, float threshold) {
        LocalTernaryPattern.checkParams(radius, samples);
        int[][][] pattern = new int[3][image.height][image.width];
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int[] pn = LocalTernaryPattern.calculateLTP(image, radius, samples, threshold, x, y);
                pattern[0][y][x] = pn[0];
                pattern[1][y][x] = pn[1];
                pattern[2][y][x] = pn[2];
            }
        }
        return pattern;
    }

    public static int[] calculateLTP(FImage image, float radius, int samples, float threshold, int x, int y) {
        float centre = image.pixels[y][x];
        int[] pattern = new int[3];
        for (int i = 0; i < samples; ++i) {
            double yy;
            double xx = (double)(-radius) * Math.sin(Math.PI * 2 * (double)i / (double)samples);
            float pix = image.getPixelInterp((double)x + xx, (double)y + (yy = (double)radius * Math.cos(Math.PI * 2 * (double)i / (double)samples))).floatValue();
            float d = pix - centre;
            if (d >= threshold) {
                pattern[0] = (int)((double)pattern[0] + Math.pow(2.0, i));
                pattern[2] = (int)((double)pattern[2] + Math.pow(3.0, i));
            }
            if (!(d <= threshold)) continue;
            pattern[1] = (int)((double)pattern[1] + Math.pow(2.0, i));
            pattern[2] = (int)((double)pattern[2] + 2.0 * Math.pow(3.0, i));
        }
        return pattern;
    }

    public static int[] calculateLTP(FImage image, float radius, int samples, float threshold, Pixel point) {
        return LocalTernaryPattern.calculateLTP(image, radius, samples, threshold, point.x, point.y);
    }

    private static void checkParams(float radius, int samples) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("radius must be greater than 0");
        }
        if (samples <= 1 || samples > 31) {
            throw new IllegalArgumentException("samples cannot be less than one or more than 31");
        }
    }

    public void analyseImage(FImage image) {
        int[][][] patterns = LocalTernaryPattern.calculateLTP(image, this.radius, this.samples, this.threshold);
        this.positiveBinaryPattern = patterns[0];
        this.negativeBinaryPattern = patterns[1];
        this.ternaryPattern = patterns[2];
    }

    public int[][] getPositivePattern() {
        return this.positiveBinaryPattern;
    }

    public int[][] getNegativePattern() {
        return this.negativeBinaryPattern;
    }

    public int[][] getTernaryPattern() {
        return this.ternaryPattern;
    }
}

