/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.SingleTestExecutor;

class HierarchicalTestExecutor<C extends EngineExecutionContext> {
    private static final SingleTestExecutor singleTestExecutor = new SingleTestExecutor();
    private final TestDescriptor rootTestDescriptor;
    private final EngineExecutionListener listener;
    private final C rootContext;
    private static final Node noOpNode = new Node(){};

    HierarchicalTestExecutor(ExecutionRequest request, C rootContext) {
        this.rootTestDescriptor = request.getRootTestDescriptor();
        this.listener = request.getEngineExecutionListener();
        this.rootContext = rootContext;
    }

    void execute() {
        this.execute(this.rootTestDescriptor, this.rootContext);
    }

    private void execute(TestDescriptor testDescriptor, C parentContext) {
        C preparedContext;
        Node<C> node = this.asNode(testDescriptor);
        try {
            preparedContext = node.prepare(parentContext);
            Node.SkipResult skipResult = node.shouldBeSkipped(preparedContext);
            if (skipResult.isSkipped()) {
                this.listener.executionSkipped(testDescriptor, skipResult.getReason().orElse("<unknown>"));
                return;
            }
        }
        catch (Throwable throwable) {
            BlacklistedExceptions.rethrowIfBlacklisted((Throwable)throwable);
            this.listener.executionStarted(testDescriptor);
            this.listener.executionFinished(testDescriptor, TestExecutionResult.failed(throwable));
            return;
        }
        this.listener.executionStarted(testDescriptor);
        TestExecutionResult result = singleTestExecutor.executeSafely(() -> {
            EngineExecutionContext context = preparedContext;
            try {
                EngineExecutionContext dynamicTestContext = context = node.before(context);
                context = node.execute(context, dynamicTestDescriptor -> {
                    this.listener.dynamicTestRegistered(dynamicTestDescriptor);
                    this.execute(dynamicTestDescriptor, dynamicTestContext);
                });
                if (!node.isLeaf()) {
                    for (TestDescriptor testDescriptor2 : testDescriptor.getChildren()) {
                        this.execute(testDescriptor2, context);
                    }
                }
            }
            finally {
                node.after(context);
            }
        });
        this.listener.executionFinished(testDescriptor, result);
    }

    private Node<C> asNode(TestDescriptor testDescriptor) {
        return testDescriptor instanceof Node ? (Node)((Object)testDescriptor) : noOpNode;
    }
}

