/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.ButtonBarSkin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.FXDialog;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

class HeavyweightDialog
extends FXDialog {
    private final Dialog<?> dialog;
    private final Stage stage;
    private final Scene scene;
    private final StackPane sceneRoot;
    private DialogPane dialogPane;

    HeavyweightDialog(Dialog<?> dialog) {
        this.dialog = dialog;
        this.stage = new Stage(){

            public void centerOnScreen() {
                double x = this.getX();
                double y = this.getY();
                if (!Double.isNaN(x) && !Double.isNaN(y)) {
                    this.setX(x);
                    this.setY(y);
                    return;
                }
                Window owner = this.getOwner();
                if (owner != null) {
                    Scene scene = owner.getScene();
                    double titleBarHeight = scene.getY();
                    double dialogWidth = HeavyweightDialog.this.sceneRoot.prefWidth(-1.0);
                    double dialogHeight = HeavyweightDialog.this.sceneRoot.prefHeight(-1.0);
                    if (owner.getX() < 0.0 || owner.getY() < 0.0) {
                        Screen screen = Screen.getPrimary();
                        double maxW = screen.getVisualBounds().getWidth();
                        double maxH = screen.getVisualBounds().getHeight();
                        x = maxW / 2.0 - dialogWidth / 2.0;
                        y = maxH / 2.0 - dialogHeight / 2.0 + titleBarHeight;
                    } else {
                        x = owner.getX() + scene.getWidth() / 2.0 - dialogWidth / 2.0;
                        y = owner.getY() + titleBarHeight + scene.getHeight() / 2.0 - dialogHeight / 2.0;
                    }
                    this.setX(x);
                    this.setY(y);
                } else {
                    super.centerOnScreen();
                }
            }
        };
        this.stage.setResizable(false);
        this.stage.setOnCloseRequest(windowEvent -> {
            if (this.requestPermissionToClose(dialog)) {
                dialog.close();
            } else {
                windowEvent.consume();
            }
        });
        this.stage.addEventHandler(KeyEvent.KEY_RELEASED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE && this.requestPermissionToClose(dialog)) {
                dialog.close();
                keyEvent.consume();
            }
        });
        this.sceneRoot = new StackPane();
        this.sceneRoot.getStyleClass().setAll((Object[])new String[]{"dialog"});
        this.scene = new Scene((Parent)this.sceneRoot);
        this.stage.setScene(this.scene);
        this.scene.getStylesheets().add((Object)ButtonBarSkin.class.getResource("modena/dialog.css").toExternalForm());
    }

    @Override
    void initStyle(StageStyle style) {
        this.stage.initStyle(style);
    }

    @Override
    StageStyle getStyle() {
        return this.stage.getStyle();
    }

    @Override
    public void initOwner(Window window) {
        this.stage.initOwner(window);
    }

    @Override
    public Window getOwner() {
        return this.stage.getOwner();
    }

    @Override
    public void initModality(Modality modality) {
        this.stage.initModality(modality == null ? Modality.APPLICATION_MODAL : modality);
    }

    @Override
    public Modality getModality() {
        return this.stage.getModality();
    }

    @Override
    public void setDialogPane(DialogPane dialogPane) {
        this.dialogPane = dialogPane;
        this.sceneRoot.getChildren().setAll((Object[])new Node[]{dialogPane});
        this.stage.sizeToScene();
    }

    @Override
    public void show() {
        this.dialogPane.heightProperty().addListener(o -> this.stage.centerOnScreen());
        this.stage.show();
    }

    @Override
    public void showAndWait() {
        this.dialogPane.heightProperty().addListener(o -> this.stage.centerOnScreen());
        this.stage.showAndWait();
    }

    @Override
    public void close() {
        if (this.stage.isShowing()) {
            this.stage.hide();
        }
    }

    @Override
    public ReadOnlyBooleanProperty showingProperty() {
        return this.stage.showingProperty();
    }

    @Override
    public Window getWindow() {
        return this.stage;
    }

    @Override
    public Node getRoot() {
        return this.stage.getScene().getRoot();
    }

    @Override
    public double getX() {
        return this.stage.getX();
    }

    @Override
    public void setX(double x) {
        this.stage.setX(x);
    }

    @Override
    public ReadOnlyDoubleProperty xProperty() {
        return this.stage.xProperty();
    }

    @Override
    public double getY() {
        return this.stage.getY();
    }

    @Override
    public void setY(double y) {
        this.stage.setY(y);
    }

    @Override
    public ReadOnlyDoubleProperty yProperty() {
        return this.stage.yProperty();
    }

    @Override
    ReadOnlyDoubleProperty heightProperty() {
        return this.stage.heightProperty();
    }

    @Override
    void setHeight(double height) {
        this.stage.setHeight(height);
    }

    @Override
    ReadOnlyDoubleProperty widthProperty() {
        return this.stage.widthProperty();
    }

    @Override
    void setWidth(double width) {
        this.stage.setWidth(width);
    }

    @Override
    BooleanProperty resizableProperty() {
        return this.stage.resizableProperty();
    }

    @Override
    StringProperty titleProperty() {
        return this.stage.titleProperty();
    }

    @Override
    ReadOnlyBooleanProperty focusedProperty() {
        return this.stage.focusedProperty();
    }

    @Override
    public void sizeToScene() {
        this.stage.sizeToScene();
    }
}

