/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetSortableMerger;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.StrAggValueSource;
import org.apache.solr.search.facet.UniqueMultiDvSlotAcc;
import org.apache.solr.search.facet.UniqueMultivaluedSlotAcc;
import org.apache.solr.search.facet.UniqueSinglevaluedSlotAcc;
import org.apache.solr.util.hll.HLL;
import org.apache.solr.util.hll.HLLType;

public class HLLAgg
extends StrAggValueSource {
    public static Integer NO_VALUES = 0;
    protected HLLFactory factory = new HLLFactory();

    public HLLAgg(String field) {
        super("hll", field);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(this.getArg());
        if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
            if (sf.getType().isPointField()) {
                return new SortedNumericAcc(fcontext, this.getArg(), numSlots);
            }
            if (sf.hasDocValues()) {
                return new UniqueMultiDvSlotAcc(fcontext, sf, numSlots, fcontext.isShard() ? this.factory : null);
            }
            return new UniqueMultivaluedSlotAcc(fcontext, sf, numSlots, fcontext.isShard() ? this.factory : null);
        }
        if (sf.getType().getNumberType() != null) {
            return new NumericAcc(fcontext, this.getArg(), numSlots);
        }
        return new UniqueSinglevaluedSlotAcc(fcontext, sf, numSlots, fcontext.isShard() ? this.factory : null);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    class SortedNumericAcc
    extends BaseNumericAcc {
        SortedNumericDocValues values;

        public SortedNumericAcc(FacetContext fcontext, String field, int numSlots) throws IOException {
            super(fcontext, field, numSlots);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = DocValues.getSortedNumeric((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected DocIdSetIterator docIdSetIterator() {
            return this.values;
        }

        @Override
        protected void collectValues(int doc, HLL hll) throws IOException {
            for (int i = 0; i < this.values.docValueCount(); ++i) {
                long val = this.values.nextValue();
                long hash = Hash.fmix64((long)val);
                hll.addRaw(hash);
            }
        }
    }

    class NumericAcc
    extends BaseNumericAcc {
        NumericDocValues values;

        public NumericAcc(FacetContext fcontext, String field, int numSlots) throws IOException {
            super(fcontext, field, numSlots);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected DocIdSetIterator docIdSetIterator() {
            return this.values;
        }

        @Override
        protected void collectValues(int doc, HLL hll) throws IOException {
            long val = this.values.longValue();
            long hash = Hash.fmix64((long)val);
            hll.addRaw(hash);
        }
    }

    abstract class BaseNumericAcc
    extends SlotAcc {
        SchemaField sf;
        HLL[] sets;

        public BaseNumericAcc(FacetContext fcontext, String field, int numSlots) throws IOException {
            super(fcontext);
            this.sf = fcontext.searcher.getSchema().getField(field);
            this.sets = new HLL[numSlots];
        }

        @Override
        public void reset() {
            this.sets = new HLL[this.sets.length];
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.sets = resizer.resize(this.sets, null);
        }

        @Override
        public void collect(int doc, int slot) throws IOException {
            int valuesDocID = this.docIdSetIterator().docID();
            if (valuesDocID < doc) {
                valuesDocID = this.docIdSetIterator().advance(doc);
            }
            if (valuesDocID > doc) {
                return;
            }
            assert (valuesDocID == doc);
            HLL hll = this.sets[slot];
            if (hll == null) {
                hll = this.sets[slot] = HLLAgg.this.factory.getHLL();
            }
            this.collectValues(doc, hll);
        }

        protected abstract DocIdSetIterator docIdSetIterator();

        protected abstract void collectValues(int var1, HLL var2) throws IOException;

        @Override
        public Object getValue(int slot) throws IOException {
            if (this.fcontext.isShard()) {
                return this.getShardValue(slot);
            }
            return this.getCardinality(slot);
        }

        private int getCardinality(int slot) {
            HLL set = this.sets[slot];
            return set == null ? 0 : (int)set.cardinality();
        }

        public Object getShardValue(int slot) throws IOException {
            HLL hll = this.sets[slot];
            if (hll == null) {
                return NO_VALUES;
            }
            SimpleOrderedMap map = new SimpleOrderedMap();
            map.add("hll", (Object)hll.toBytes());
            return map;
        }

        @Override
        public int compare(int slotA, int slotB) {
            return this.getCardinality(slotA) - this.getCardinality(slotB);
        }
    }

    private static class Merger
    extends FacetSortableMerger {
        HLL aggregate = null;
        long answer = -1L;

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            if (facetResult instanceof Number) {
                assert (NO_VALUES.equals(facetResult));
                return;
            }
            SimpleOrderedMap map = (SimpleOrderedMap)facetResult;
            byte[] serialized = (byte[])map.get("hll");
            HLL subHLL = HLL.fromBytes(serialized);
            if (this.aggregate == null) {
                this.aggregate = subHLL;
            } else {
                this.aggregate.union(subHLL);
            }
        }

        private long getLong() {
            if (this.answer < 0L) {
                this.answer = this.aggregate == null ? 0L : this.aggregate.cardinality();
            }
            return this.answer;
        }

        @Override
        public Object getMergedResult() {
            return this.getLong();
        }

        @Override
        public int compareTo(FacetSortableMerger other, FacetRequest.SortDirection direction) {
            return Long.compare(this.getLong(), ((Merger)other).getLong());
        }
    }

    public static class HLLFactory {
        int log2m = 13;
        int regwidth = 6;

        public HLL getHLL() {
            return new HLL(this.log2m, this.regwidth, -1, false, HLLType.EMPTY);
        }
    }
}

