/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.NumericFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PointField
extends NumericFieldType {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static boolean TEST_HACK_IGNORE_USELESS_TRIEFIELD_ARGS = false;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        if (TEST_HACK_IGNORE_USELESS_TRIEFIELD_ARGS) {
            args.remove("precisionStep");
        }
    }

    @Override
    public boolean isPointField() {
        return true;
    }

    @Override
    public final ValueSource getSingleValueSource(FieldType.MultiValueSelector choice, SchemaField field, QParser parser) {
        if (!field.multiValued()) {
            return this.getValueSource(field, parser);
        }
        if (!field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "docValues='true' is required to select '" + choice.toString() + "' value from multivalued field (" + field.getName() + ") at query time");
        }
        SortedNumericSelector.Type selectorType = choice.getSortedNumericSelectorType();
        if (null == selectorType) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, choice.toString() + " is not a supported option for picking a single value from the multivalued field: " + field.getName() + " (type: " + this.getTypeName() + ")");
        }
        return this.getSingleValueSource(selectorType, field);
    }

    protected abstract ValueSource getSingleValueSource(SortedNumericSelector.Type var1, SchemaField var2);

    @Override
    public boolean isTokenized() {
        return false;
    }

    @Override
    public boolean multiValuedFieldCache() {
        return false;
    }

    @Override
    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVals) {
        return super.getSetQuery(parser, field, externalVals);
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        if (!field.indexed() && field.hasDocValues()) {
            return this.getRangeQuery(parser, field, externalVal, externalVal, true, true);
        }
        if (field.indexed() && field.hasDocValues()) {
            Query pointsQuery = this.getExactQuery(field, externalVal);
            Query dvQuery = this.getDocValuesRangeQuery(parser, field, externalVal, externalVal, true, true);
            return new IndexOrDocValuesQuery(pointsQuery, dvQuery);
        }
        return this.getExactQuery(field, externalVal);
    }

    protected abstract Query getExactQuery(SchemaField var1, String var2);

    public abstract Query getPointRangeQuery(QParser var1, SchemaField var2, String var3, String var4, boolean var5, boolean var6);

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        if (!field.indexed() && field.hasDocValues()) {
            return this.getDocValuesRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
        }
        if (field.indexed() && field.hasDocValues()) {
            Query pointsQuery = this.getPointRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
            Query dvQuery = this.getDocValuesRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
            return new IndexOrDocValuesQuery(pointsQuery, dvQuery);
        }
        return this.getPointRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
    }

    @Override
    public String storedToReadable(IndexableField f) {
        return this.toExternal(f);
    }

    @Override
    public String toInternal(String val) {
        throw new UnsupportedOperationException("Can't generate internal string in PointField. use PointField.toInternalByteRef");
    }

    public BytesRef toInternalByteRef(String val) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        this.readableToIndexed(val, bytes);
        return bytes.get();
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeVal(name, this.toObject(f));
    }

    @Override
    public String storedToIndexed(IndexableField f) {
        throw new UnsupportedOperationException("Not supported with PointFields");
    }

    @Override
    public CharsRef indexedToReadable(BytesRef indexedForm, CharsRefBuilder charsRef) {
        String value = this.indexedToReadable(indexedForm);
        charsRef.grow(value.length());
        charsRef.setLength(value.length());
        value.getChars(0, charsRef.length(), charsRef.chars(), 0);
        return charsRef.get();
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return this.indexedToReadable(new BytesRef((CharSequence)indexedForm));
    }

    protected abstract String indexedToReadable(BytesRef var1);

    @Override
    public Query getPrefixQuery(QParser parser, SchemaField sf, String termStr) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't run prefix queries on numeric fields");
    }

    protected boolean isFieldUsed(SchemaField field) {
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        boolean docValues = field.hasDocValues();
        if (!(indexed || stored || docValues)) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return false;
        }
        return true;
    }

    @Override
    public List<IndexableField> createFields(SchemaField sf, Object value) {
        if (!this.isFieldUsed(sf)) {
            return Collections.emptyList();
        }
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>(3);
        IndexableField field = null;
        if (sf.indexed()) {
            field = this.createField(sf, value);
            fields.add(field);
        }
        if (sf.hasDocValues()) {
            Number numericValue;
            if (field == null) {
                Object nativeTypeObject = this.toNativeType(value);
                numericValue = this.getNumberType() == NumberType.DATE ? (Number)((Date)nativeTypeObject).getTime() : (Number)((Number)nativeTypeObject);
            } else {
                numericValue = field.numericValue();
            }
            if (!sf.multiValued()) {
                long bits;
                if (numericValue instanceof Integer || numericValue instanceof Long) {
                    bits = numericValue.longValue();
                } else if (numericValue instanceof Float) {
                    bits = Float.floatToIntBits(numericValue.floatValue());
                } else {
                    assert (numericValue instanceof Double);
                    bits = Double.doubleToLongBits(numericValue.doubleValue());
                }
                fields.add((IndexableField)new NumericDocValuesField(sf.getName(), bits));
            } else {
                long bits;
                if (numericValue instanceof Integer || numericValue instanceof Long) {
                    bits = numericValue.longValue();
                } else if (numericValue instanceof Float) {
                    bits = NumericUtils.floatToSortableInt((float)numericValue.floatValue());
                } else {
                    assert (numericValue instanceof Double);
                    bits = NumericUtils.doubleToSortableLong((double)numericValue.doubleValue());
                }
                fields.add((IndexableField)new SortedNumericDocValuesField(sf.getName(), bits));
            }
        }
        if (sf.stored()) {
            fields.add((IndexableField)this.getStoredField(sf, value));
        }
        return fields;
    }

    protected abstract StoredField getStoredField(SchemaField var1, Object var2);
}

