/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.IdUtils;

public class TriggerEvent
implements MapWriter {
    public static final String COOLDOWN = "cooldown";
    public static final String REPLAYING = "replaying";
    public static final String NODE_NAMES = "nodeNames";
    public static final String EVENT_TIMES = "eventTimes";
    protected final String id;
    protected final String source;
    protected final long eventTime;
    protected final TriggerEventType eventType;
    protected final Map<String, Object> properties = new HashMap<String, Object>();

    public TriggerEvent(TriggerEventType eventType, String source, long eventTime, Map<String, Object> properties) {
        this(IdUtils.timeRandomId(eventTime), eventType, source, eventTime, properties);
    }

    public TriggerEvent(String id, TriggerEventType eventType, String source, long eventTime, Map<String, Object> properties) {
        this.id = id;
        this.eventType = eventType;
        this.source = source;
        this.eventTime = eventTime;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public TriggerEventType getEventType() {
        return this.eventType;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put("id", (Object)this.id);
        ew.put("source", (Object)this.source);
        ew.put("eventTime", this.eventTime);
        ew.put("eventType", (Object)this.eventType.toString());
        ew.put("properties", this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerEvent that = (TriggerEvent)o;
        if (this.eventTime != that.eventTime) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (this.eventType != that.eventType) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + (int)(this.eventTime ^ this.eventTime >>> 32);
        result = 31 * result + this.eventType.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    public String toString() {
        return Utils.toJSONString((Object)this);
    }
}

