/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import com.google.common.util.concurrent.AtomicDouble;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.metrics.SolrCoreMetricManager;
import org.apache.solr.util.TimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRateTrigger
extends TriggerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TimeSource timeSource;
    private final String handler;
    private final String collection;
    private final String shard;
    private final String node;
    private final double rate;
    private final Map<String, Long> lastCollectionEvent = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> lastNodeEvent = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> lastShardEvent = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> lastReplicaEvent = new ConcurrentHashMap<String, Long>();
    private final Map<String, Object> state = new HashMap<String, Object>();

    public SearchRateTrigger(String name, Map<String, Object> properties, SolrResourceLoader loader, SolrCloudManager cloudManager) {
        super(TriggerEventType.SEARCHRATE, name, properties, loader, cloudManager);
        this.timeSource = TimeSource.CURRENT_TIME;
        this.state.put("lastCollectionEvent", this.lastCollectionEvent);
        this.state.put("lastNodeEvent", this.lastNodeEvent);
        this.state.put("lastShardEvent", this.lastShardEvent);
        this.state.put("lastReplicaEvent", this.lastReplicaEvent);
        this.collection = (String)properties.getOrDefault("collection", "#ANY");
        this.shard = (String)properties.getOrDefault("shard", "#ANY");
        if (this.collection.equals("#ANY") && !this.shard.equals("#ANY")) {
            throw new IllegalArgumentException("When 'shard' is other than #ANY then collection name must be also other than #ANY");
        }
        this.node = (String)properties.getOrDefault("node", "#ANY");
        this.handler = (String)properties.getOrDefault("handler", "/select");
        if (properties.get("rate") == null) {
            throw new IllegalArgumentException("No 'rate' specified in configuration");
        }
        String rateString = String.valueOf(properties.get("rate"));
        try {
            this.rate = Double.parseDouble(rateString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid 'rate' configuration value: '" + rateString + "'", e);
        }
    }

    @Override
    protected Map<String, Object> getState() {
        return this.state;
    }

    @Override
    protected void setState(Map<String, Object> state) {
        Map replicaTimes;
        Map shardTimes;
        Map nodeTimes;
        this.lastCollectionEvent.clear();
        this.lastNodeEvent.clear();
        this.lastShardEvent.clear();
        this.lastReplicaEvent.clear();
        Map collTimes = (Map)state.get("lastCollectionEvent");
        if (collTimes != null) {
            this.lastCollectionEvent.putAll(collTimes);
        }
        if ((nodeTimes = (Map)state.get("lastNodeEvent")) != null) {
            this.lastNodeEvent.putAll(nodeTimes);
        }
        if ((shardTimes = (Map)state.get("lastShardEvent")) != null) {
            this.lastShardEvent.putAll(shardTimes);
        }
        if ((replicaTimes = (Map)state.get("lastReplicaEvent")) != null) {
            this.lastReplicaEvent.putAll(replicaTimes);
        }
    }

    @Override
    public void restoreState(AutoScaling.Trigger old) {
        SearchRateTrigger that;
        assert (old.isClosed());
        if (old instanceof SearchRateTrigger) {
            that = (SearchRateTrigger)old;
            assert (this.name.equals(that.name));
        } else {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Unable to restore state from an unknown type of trigger");
        }
        this.lastCollectionEvent.clear();
        this.lastNodeEvent.clear();
        this.lastShardEvent.clear();
        this.lastReplicaEvent.clear();
        this.lastCollectionEvent.putAll(that.lastCollectionEvent);
        this.lastNodeEvent.putAll(that.lastNodeEvent);
        this.lastShardEvent.putAll(that.lastShardEvent);
        this.lastReplicaEvent.putAll(that.lastReplicaEvent);
    }

    @Override
    public void run() {
        AutoScaling.TriggerEventProcessor processor = (AutoScaling.TriggerEventProcessor)this.processorRef.get();
        if (processor == null) {
            return;
        }
        HashMap<String, Map> collectionRates = new HashMap<String, Map>();
        HashMap nodeRates = new HashMap();
        for (String node2 : this.cloudManager.getClusterStateProvider().getLiveNodes()) {
            HashMap metricTags = new HashMap();
            Map infos = this.cloudManager.getNodeStateProvider().getReplicaInfo(node2, Collections.emptyList());
            infos.forEach((coll, shards) -> shards.forEach((sh, replicas) -> replicas.forEach(replica -> {
                String replicaName = Utils.parseMetricsReplicaName((String)coll, (String)replica.getCore());
                if (replicaName == null) {
                    replicaName = replica.getName();
                }
                String registry = SolrCoreMetricManager.createRegistryName(true, coll, sh, replicaName, null);
                String tag = "metrics:" + registry + ":QUERY." + this.handler + ".requestTimes:1minRate";
                metricTags.put(tag, replica);
            })));
            Map rates = this.cloudManager.getNodeStateProvider().getNodeValues(node2, metricTags.keySet());
            rates.forEach((tag, rate) -> {
                ReplicaInfo info = (ReplicaInfo)metricTags.get(tag);
                if (info == null) {
                    log.warn("Missing replica info for response tag " + tag);
                } else {
                    Map perCollection = collectionRates.computeIfAbsent(info.getCollection(), s -> new HashMap());
                    List perShard = perCollection.computeIfAbsent(info.getShard(), s -> new ArrayList());
                    info.getVariables().put("rate", rate);
                    perShard.add(info);
                    AtomicDouble perNode = nodeRates.computeIfAbsent(node2, s -> new AtomicDouble());
                    perNode.addAndGet(((Double)rate).doubleValue());
                }
            });
        }
        long now = this.timeSource.getTime();
        Map<String, Double> hotNodes = nodeRates.entrySet().stream().filter(entry -> this.node.equals("#ANY") || this.node.equals(entry.getKey())).filter(entry -> this.waitForElapsed((String)entry.getKey(), now, this.lastNodeEvent)).filter(entry -> ((AtomicDouble)entry.getValue()).get() > this.rate).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((AtomicDouble)entry.getValue()).get()));
        HashMap<String, Map<String, Double>> hotShards = new HashMap<String, Map<String, Double>>();
        ArrayList<ReplicaInfo> hotReplicas = new ArrayList<ReplicaInfo>();
        collectionRates.forEach((coll, shardRates) -> shardRates.forEach((sh, replicaRates) -> {
            double shardRate = replicaRates.stream().map(r -> {
                if (this.waitForElapsed(r.getCollection() + "." + r.getCore(), now, this.lastReplicaEvent) && (Double)r.getVariable("rate") > this.rate) {
                    hotReplicas.add((ReplicaInfo)r);
                }
                return r;
            }).mapToDouble(r -> (Double)r.getVariable("rate")).sum();
            if (this.waitForElapsed(coll + "." + sh, now, this.lastShardEvent) && shardRate > this.rate && (this.collection.equals("#ANY") || this.collection.equals(coll)) && (this.shard.equals("#ANY") || this.shard.equals(sh))) {
                hotShards.computeIfAbsent((String)coll, s -> new HashMap()).put(sh, shardRate);
            }
        }));
        HashMap<String, Double> hotCollections = new HashMap<String, Double>();
        collectionRates.forEach((coll, shardRates) -> {
            double total = shardRates.entrySet().stream().mapToDouble(e -> ((List)e.getValue()).stream().mapToDouble(r -> (Double)r.getVariable("rate")).sum()).sum();
            if (this.waitForElapsed((String)coll, now, this.lastCollectionEvent) && total > this.rate && (this.collection.equals("#ANY") || this.collection.equals(coll))) {
                hotCollections.put((String)coll, total);
            }
        });
        if (hotCollections.isEmpty() && hotShards.isEmpty() && hotReplicas.isEmpty() && hotNodes.isEmpty()) {
            return;
        }
        AtomicLong eventTime = new AtomicLong(now);
        hotCollections.forEach((c, r) -> {
            long time = this.lastCollectionEvent.get(c);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        hotShards.forEach((c, shards) -> shards.forEach((s, r) -> {
            long time = this.lastShardEvent.get(c + "." + s);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        }));
        hotReplicas.forEach(r -> {
            long time = this.lastReplicaEvent.get(r.getCollection() + "." + r.getCore());
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        hotNodes.forEach((n, r) -> {
            long time = this.lastNodeEvent.get(n);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        if (processor.process(new SearchRateEvent(this.getName(), eventTime.get(), hotNodes, hotCollections, hotShards, hotReplicas))) {
            hotNodes.keySet().forEach(node -> this.lastNodeEvent.put((String)node, now));
            hotCollections.keySet().forEach(coll -> this.lastCollectionEvent.put((String)coll, now));
            hotShards.entrySet().forEach(e -> ((Map)e.getValue()).forEach((sh, rate) -> this.lastShardEvent.put((String)e.getKey() + "." + sh, now)));
            hotReplicas.forEach(r -> this.lastReplicaEvent.put(r.getCollection() + "." + r.getCore(), now));
        }
    }

    private boolean waitForElapsed(String name, long now, Map<String, Long> lastEventMap) {
        Long lastTime = lastEventMap.computeIfAbsent(name, s -> now);
        long elapsed = TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS);
        log.debug("name=" + name + ", lastTime=" + lastTime + ", elapsed=" + elapsed);
        return TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS) >= (long)this.getWaitForSecond();
    }

    public static class SearchRateEvent
    extends TriggerEvent {
        public SearchRateEvent(String source, long eventTime, Map<String, Double> hotNodes, Map<String, Double> hotCollections, Map<String, Map<String, Double>> hotShards, List<ReplicaInfo> hotReplicas) {
            super(TriggerEventType.SEARCHRATE, source, eventTime, null);
            this.properties.put("collection", hotCollections);
            this.properties.put("shard", hotShards);
            this.properties.put("replica", hotReplicas);
            this.properties.put("node", hotNodes);
        }
    }
}

