/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.cloud.ActionThrottle;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardLeaderElectionContext
extends ShardLeaderElectionContextBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZkController zkController;
    private final CoreContainer cc;
    private final SyncStrategy syncStrategy;
    private volatile boolean isClosed = false;

    public ShardLeaderElectionContext(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkController zkController, CoreContainer cc) {
        super(leaderElector, shardId, collection, coreNodeName, props, zkController.getZkStateReader());
        this.zkController = zkController;
        this.cc = cc;
        this.syncStrategy = new SyncStrategy(cc);
    }

    @Override
    public void close() {
        super.close();
        this.isClosed = true;
        this.syncStrategy.close();
    }

    @Override
    public void cancelElection() throws InterruptedException, KeeperException {
        String coreName = this.leaderProps.getStr("core");
        try (SolrCore core = this.cc.getCore(coreName);){
            if (core != null) {
                core.getCoreDescriptor().getCloudDescriptor().setLeader(false);
            }
        }
        super.cancelElection();
    }

    @Override
    public ElectionContext copy() {
        return new ShardLeaderElectionContext(this.leaderElector, this.shardId, this.collection, this.id, this.leaderProps, this.zkController, this.cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStart) throws KeeperException, InterruptedException, IOException {
        ActionThrottle lt;
        String coreName = this.leaderProps.getStr("core");
        try (SolrCore core = this.cc.getCore(coreName);){
            if (core == null) {
                if (!this.cc.isShutDown()) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore not found:" + coreName + " in " + this.cc.getLoadedCoreNames());
                return;
            }
            MDCLoggingContext.setCore(core);
            lt = core.getUpdateHandler().getSolrCoreState().getLeaderThrottle();
        }
        try {
            block139: {
                Object result;
                Replica.Type replicaType;
                lt.minimumWaitBetweenActions();
                lt.markAttemptingAction();
                int leaderVoteWait = this.cc.getZkController().getLeaderVoteWait();
                log.debug("Running the leader process for shard={} and weAreReplacement={} and leaderVoteWait={}", new Object[]{this.shardId, weAreReplacement, leaderVoteWait});
                if (this.zkController.getClusterState().getCollection(this.collection).getSlice(this.shardId).getReplicas().size() > 1) {
                    ZkNodeProps m = new ZkNodeProps(new String[]{"operation", OverseerAction.LEADER.toLower(), "shard", this.shardId, "collection", this.collection});
                    Overseer.getStateUpdateQueue(this.zkClient).offer(Utils.toJSON((Object)m));
                }
                boolean allReplicasInLine = false;
                allReplicasInLine = !weAreReplacement ? this.waitForReplicasToComeUp(leaderVoteWait) : this.areAllReplicasParticipating();
                if (this.isClosed) {
                    return;
                }
                try (SolrCore core = this.cc.getCore(coreName);){
                    if (core == null) {
                        if (this.zkController.getCoreContainer().isShutDown()) return;
                        this.cancelElection();
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore not found:" + coreName + " in " + this.cc.getLoadedCoreNames());
                    }
                    replicaType = core.getCoreDescriptor().getCloudDescriptor().getReplicaType();
                    if (weAreReplacement && !this.shouldIBeLeader(this.leaderProps, core, weAreReplacement)) {
                        this.rejoinLeaderElection(core);
                        return;
                    }
                    log.info("I may be the new leader - try and sync");
                    core.getUpdateHandler().getSolrCoreState().cancelRecovery();
                    if (weAreReplacement) {
                        try {
                            Thread.sleep(2500L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, (Throwable)e);
                        }
                    }
                    result = null;
                    boolean success = false;
                    try {
                        result = this.syncStrategy.sync(this.zkController, core, this.leaderProps, weAreReplacement);
                        success = ((PeerSync.PeerSyncResult)result).isSuccess();
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)log, (String)"Exception while trying to sync", (Throwable)e);
                        result = PeerSync.PeerSyncResult.failure();
                    }
                    UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
                    if (!success) {
                        boolean hasRecentUpdates = false;
                        if (ulog != null) {
                            try (UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();){
                                hasRecentUpdates = !recentUpdates.getVersions(1).isEmpty();
                            }
                        }
                        if (!hasRecentUpdates) {
                            if (((PeerSync.PeerSyncResult)result).getOtherHasVersions().orElse(false).booleanValue()) {
                                log.info("We failed sync, but we have no versions - we can't sync in that case. But others have some versions, so we should not become leader");
                                success = false;
                            } else {
                                log.info("We failed sync, but we have no versions - we can't sync in that case - we were active before, so become leader anyway");
                                success = true;
                            }
                        }
                    }
                    if (log.isDebugEnabled()) {
                        try {
                            RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                            SolrIndexSearcher searcher = searchHolder.get();
                            try {
                                log.debug(core.getCoreContainer().getZkController().getNodeName() + " synched " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits);
                            }
                            finally {
                                searchHolder.decref();
                            }
                        }
                        catch (Exception e) {
                            log.error("Error in solrcloud_debug block", (Throwable)e);
                        }
                    }
                    if (!success) {
                        this.rejoinLeaderElection(core);
                        return;
                    }
                }
                boolean isLeader = true;
                if (this.isClosed) break block139;
                try {
                    block137: {
                        SolrCore core;
                        block135: {
                            block136: {
                                this.checkLIR(coreName, allReplicasInLine);
                                if (replicaType == Replica.Type.TLOG) {
                                    this.zkController.stopReplicationFromLeader(coreName);
                                    if (weAreReplacement) {
                                        core = this.cc.getCore(coreName);
                                        result = null;
                                        try {
                                            Future<UpdateLog.RecoveryInfo> future = core.getUpdateHandler().getUpdateLog().recoverFromCurrentLog();
                                            if (future != null) {
                                                log.info("Replaying tlog before become new leader");
                                                future.get();
                                            } else {
                                                log.info("New leader does not have old tlog to replay");
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            result = throwable;
                                            throw throwable;
                                        }
                                        finally {
                                            if (core != null) {
                                                if (result != null) {
                                                    try {
                                                        core.close();
                                                    }
                                                    catch (Throwable throwable) {
                                                        ((Throwable)result).addSuppressed(throwable);
                                                    }
                                                } else {
                                                    core.close();
                                                }
                                            }
                                        }
                                    }
                                }
                                super.runLeaderProcess(weAreReplacement, 0);
                                core = this.cc.getCore(coreName);
                                result = null;
                                if (core != null) {
                                    core.getCoreDescriptor().getCloudDescriptor().setLeader(true);
                                    this.publishActiveIfRegisteredAndNotActive(core);
                                    break block135;
                                }
                                if (core == null) return;
                                if (result == null) break block136;
                                try {
                                    core.close();
                                    return;
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)result).addSuppressed(throwable);
                                    return;
                                }
                            }
                            core.close();
                            return;
                        }
                        if (core != null) {
                            if (result != null) {
                                try {
                                    core.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)result).addSuppressed(throwable);
                                }
                                break block137;
                            } else {
                                core.close();
                            }
                        }
                        break block137;
                        catch (Throwable throwable) {
                            try {
                                result = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                if (core == null) throw throwable2;
                                if (result == null) {
                                    core.close();
                                    throw throwable2;
                                }
                                try {
                                    core.close();
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)result).addSuppressed(throwable3);
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    log.info("I am the new leader: " + ZkCoreNodeProps.getCoreUrl((ZkNodeProps)this.leaderProps) + " " + this.shardId);
                    this.syncStrategy.requestRecoveries();
                }
                catch (Exception e) {
                    isLeader = false;
                    SolrException.log((Logger)log, (String)"There was a problem trying to register as the leader", (Throwable)e);
                    try (SolrCore core = this.cc.getCore(coreName);){
                        if (core == null) {
                            log.debug("SolrCore not found:" + coreName + " in " + this.cc.getLoadedCoreNames());
                            MDCLoggingContext.clear();
                            return;
                        }
                        core.getCoreDescriptor().getCloudDescriptor().setLeader(false);
                        this.rejoinLeaderElection(core);
                    }
                }
                if (!isLeader) return;
                try {
                    this.startLeaderInitiatedRecoveryOnReplicas(coreName);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            this.cancelElection();
            return;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public void publishActiveIfRegisteredAndNotActive(SolrCore core) throws Exception {
        if (core.getCoreDescriptor().getCloudDescriptor().hasRegistered()) {
            ZkStateReader zkStateReader = this.zkController.getZkStateReader();
            zkStateReader.forceUpdateCollection(this.collection);
            ClusterState clusterState = zkStateReader.getClusterState();
            Replica rep = this.getReplica(clusterState, this.collection, this.leaderProps.getStr("core_node_name"));
            if (rep != null && rep.getState() != Replica.State.ACTIVE && rep.getState() != Replica.State.RECOVERING) {
                log.debug("We have become the leader after core registration but are not in an ACTIVE state - publishing ACTIVE");
                this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
            }
        }
    }

    private Replica getReplica(ClusterState clusterState, String collectionName, String replicaName) {
        if (clusterState == null) {
            return null;
        }
        DocCollection docCollection = clusterState.getCollectionOrNull(collectionName);
        if (docCollection == null) {
            return null;
        }
        return docCollection.getReplica(replicaName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkLIR(String coreName, boolean allReplicasInLine) throws InterruptedException, KeeperException, IOException {
        if (allReplicasInLine) {
            log.info("Found all replicas participating in election, clear LIR");
            try (SolrCore core = this.cc.getCore(coreName);){
                Replica.State lirState = this.zkController.getLeaderInitiatedRecoveryState(this.collection, this.shardId, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
                if (lirState != Replica.State.DOWN) return;
                this.zkController.updateLeaderInitiatedRecoveryState(this.collection, this.shardId, this.leaderProps.getStr("core_node_name"), Replica.State.ACTIVE, core.getCoreDescriptor(), true);
                return;
            }
        } else {
            try (SolrCore core = this.cc.getCore(coreName);){
                Replica.State lirState;
                if (core == null || (lirState = this.zkController.getLeaderInitiatedRecoveryState(this.collection, this.shardId, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName())) != Replica.State.DOWN && lirState != Replica.State.RECOVERING) return;
                log.warn("The previous leader marked me " + core.getName() + " as " + lirState.toString() + " and I haven't recovered yet, so I shouldn't be the leader.");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Leader Initiated Recovery prevented leadership");
            }
        }
    }

    private void startLeaderInitiatedRecoveryOnReplicas(String coreName) throws Exception {
        try (SolrCore core = this.cc.getCore(coreName);){
            CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
            String coll = cloudDesc.getCollectionName();
            String shardId = cloudDesc.getShardId();
            String coreNodeName = cloudDesc.getCoreNodeName();
            if (coll == null || shardId == null) {
                log.error("Cannot start leader-initiated recovery on new leader (core=" + coreName + ",coreNodeName=" + coreNodeName + ") because collection and/or shard is null!");
                return;
            }
            String znodePath = this.zkController.getLeaderInitiatedRecoveryZnodePath(coll, shardId);
            List replicas = null;
            try {
                replicas = this.zkClient.getChildren(znodePath, null, false);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            if (replicas != null && replicas.size() > 0) {
                for (String replicaCoreNodeName : replicas) {
                    Replica.State lirState;
                    if (coreNodeName.equals(replicaCoreNodeName) || (lirState = this.zkController.getLeaderInitiatedRecoveryState(coll, shardId, replicaCoreNodeName)) != Replica.State.DOWN && lirState != Replica.State.RECOVERY_FAILED) continue;
                    log.info("After core={} coreNodeName={} was elected leader, a replica coreNodeName={} was found in state: " + lirState.toString() + " and needing recovery.", new Object[]{coreName, coreNodeName, replicaCoreNodeName});
                    List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, coreNodeName);
                    if (replicaProps == null || replicaProps.size() <= 0) continue;
                    ZkCoreNodeProps coreNodeProps = null;
                    for (ZkCoreNodeProps p : replicaProps) {
                        if (!((Replica)p.getNodeProps()).getName().equals(replicaCoreNodeName)) continue;
                        coreNodeProps = p;
                        break;
                    }
                    this.zkController.ensureReplicaInLeaderInitiatedRecovery(this.cc, this.collection, shardId, coreNodeProps, core.getCoreDescriptor(), false);
                }
            }
        }
    }

    private boolean waitForReplicasToComeUp(int timeoutms) throws InterruptedException {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutms, TimeUnit.MILLISECONDS);
        String shardsElectZkPath = this.electionPath + "/election";
        DocCollection docCollection = this.zkController.getClusterState().getCollectionOrNull(this.collection);
        Slice slices = docCollection == null ? null : docCollection.getSlice(this.shardId);
        int cnt = 0;
        while (!this.isClosed && !this.cc.isShutDown()) {
            if (slices != null) {
                int found = 0;
                try {
                    found = this.zkClient.getChildren(shardsElectZkPath, null, true).size();
                }
                catch (KeeperException e) {
                    if (e instanceof KeeperException.SessionExpiredException) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ZK session expired - cancelling election for " + this.collection + " " + this.shardId);
                    }
                    SolrException.log((Logger)log, (String)"Error checking for the number of election participants", (Throwable)e);
                }
                if (found >= slices.getReplicas(EnumSet.of(Replica.Type.TLOG, Replica.Type.NRT)).size()) {
                    log.info("Enough replicas found to continue.");
                    return true;
                }
                if (cnt % 40 == 0) {
                    log.info("Waiting until we see more replicas up for shard {}: total={} found={} timeoutin={}ms", new Object[]{this.shardId, slices.getReplicas(EnumSet.of(Replica.Type.TLOG, Replica.Type.NRT)).size(), found, TimeUnit.MILLISECONDS.convert(timeoutAt - System.nanoTime(), TimeUnit.NANOSECONDS)});
                }
                if (System.nanoTime() > timeoutAt) {
                    log.info("Was waiting for replicas to come up, but they are taking too long - assuming they won't come back till later");
                    return false;
                }
            } else {
                log.warn("Shard not found: " + this.shardId + " for collection " + this.collection);
                return false;
            }
            Thread.sleep(500L);
            docCollection = this.zkController.getClusterState().getCollectionOrNull(this.collection);
            slices = docCollection == null ? null : docCollection.getSlice(this.shardId);
            ++cnt;
        }
        return false;
    }

    private boolean areAllReplicasParticipating() throws InterruptedException {
        String shardsElectZkPath = this.electionPath + "/election";
        DocCollection docCollection = this.zkController.getClusterState().getCollectionOrNull(this.collection);
        if (docCollection != null && docCollection.getSlice(this.shardId) != null) {
            Slice slices = docCollection.getSlice(this.shardId);
            int found = 0;
            try {
                found = this.zkClient.getChildren(shardsElectZkPath, null, true).size();
            }
            catch (KeeperException e) {
                if (e instanceof KeeperException.SessionExpiredException) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ZK session expired - cancelling election for " + this.collection + " " + this.shardId);
                }
                SolrException.log((Logger)log, (String)"Error checking for the number of election participants", (Throwable)e);
            }
            if (found >= slices.getReplicasMap().size()) {
                log.debug("All replicas are ready to participate in election.");
                return true;
            }
        } else {
            log.warn("Shard not found: " + this.shardId + " for collection " + this.collection);
            return false;
        }
        return false;
    }

    private void rejoinLeaderElection(SolrCore core) throws InterruptedException, KeeperException, IOException {
        if (this.cc.isShutDown()) {
            log.debug("Not rejoining election because CoreContainer is closed");
            return;
        }
        log.info("There may be a better leader candidate than us - going back into recovery");
        this.cancelElection();
        core.getUpdateHandler().getSolrCoreState().doRecovery(this.cc, core.getCoreDescriptor());
        this.leaderElector.joinElection(this, true);
    }

    private boolean shouldIBeLeader(ZkNodeProps leaderProps, SolrCore core, boolean weAreReplacement) {
        log.debug("Checking if I should try and be the leader.");
        if (this.isClosed) {
            log.debug("Bailing on leader process because we have been closed");
            return false;
        }
        if (!weAreReplacement) {
            return true;
        }
        if (core.getCoreDescriptor().getCloudDescriptor().getLastPublished() == Replica.State.ACTIVE) {
            log.debug("My last published State was Active, it's okay to be the leader.");
            return true;
        }
        log.debug("My last published State was " + core.getCoreDescriptor().getCloudDescriptor().getLastPublished() + ", I won't be the leader.");
        return false;
    }
}

