/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlApply;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlCast;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlCollection;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlIsOf;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlLabeledElement;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlNull;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlRecord;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlUrlRef;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlDynamicExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlIf;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlLogicalOrComparisonExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlNavigationPropertyPath;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPath;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPropertyPath;

@JsonDeserialize(using=DynamicExpressionDeserializer.class)
public abstract class ClientCsdlDynamicExpression
extends CsdlDynamicExpression
implements Serializable {
    private static final long serialVersionUID = 1093411847477874348L;

    static class DynamicExpressionDeserializer
    extends AbstractClientCsdlEdmDeserializer<CsdlDynamicExpression> {
        private static final String APPLY = "Apply";
        private static final String CAST = "Cast";
        private static final String COLLECTION = "Collection";
        private static final String IF = "If";
        private static final String IS_OF = "IsOf";
        private static final String LABELED_ELEMENT = "LabeledElement";
        private static final String NULL = "Null";
        private static final String RECORD = "Record";
        private static final String URL_REF = "UrlRef";
        private static final String ANNOTATION_PATH = "AnnotationPath";
        private static final String NAVIGATION_PROPERTY_PATH = "NavigationPropertyPath";
        private static final String PATH = "Path";
        private static final String PROPERTY_PATH = "PropertyPath";

        DynamicExpressionDeserializer() {
        }

        private CsdlExpression parseConstOrEnumExpression(JsonParser jp) throws IOException {
            Object result = this.isAnnotationConstExprConstruct(jp) ? this.parseAnnotationConstExprConstruct(jp) : (CsdlExpression)jp.readValueAs(ClientCsdlDynamicExpression.class);
            jp.nextToken();
            return result;
        }

        @Override
        protected CsdlDynamicExpression doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            CsdlPath expression = null;
            if ("Not".equals(jp.getCurrentName())) {
                CsdlLogicalOrComparisonExpression not = new CsdlLogicalOrComparisonExpression(CsdlLogicalOrComparisonExpression.LogicalOrComparisonExpressionType.Not);
                jp.nextToken();
                while (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                    jp.nextToken();
                }
                not.setLeft((CsdlExpression)jp.readValueAs(ClientCsdlDynamicExpression.class));
                while (jp.getCurrentToken() != JsonToken.END_OBJECT || !jp.getCurrentName().equals("Not")) {
                    jp.nextToken();
                }
                expression = not;
            } else if (CsdlLogicalOrComparisonExpression.LogicalOrComparisonExpressionType.fromString((String)jp.getCurrentName()) != null) {
                CsdlLogicalOrComparisonExpression logicalOrComparissonExp = new CsdlLogicalOrComparisonExpression(CsdlLogicalOrComparisonExpression.LogicalOrComparisonExpressionType.fromString((String)jp.getCurrentName()));
                jp.nextToken();
                while (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                    jp.nextToken();
                }
                logicalOrComparissonExp.setLeft((CsdlExpression)jp.readValueAs(ClientCsdlDynamicExpression.class));
                logicalOrComparissonExp.setRight((CsdlExpression)jp.readValueAs(ClientCsdlDynamicExpression.class));
                while (jp.getCurrentToken() != JsonToken.END_OBJECT || !jp.getCurrentName().equals(logicalOrComparissonExp.getType().name())) {
                    jp.nextToken();
                }
                expression = logicalOrComparissonExp;
            } else if (PATH.equals(jp.getCurrentName())) {
                expression = new CsdlPath().setValue(jp.nextTextValue());
            } else if (NAVIGATION_PROPERTY_PATH.equals(jp.getCurrentName())) {
                expression = new CsdlNavigationPropertyPath().setValue(jp.nextTextValue());
            } else if (PROPERTY_PATH.equals(jp.getCurrentName())) {
                expression = new CsdlPropertyPath().setValue(jp.nextTextValue());
            } else if (ANNOTATION_PATH.equals(jp.getCurrentName())) {
                expression = new CsdlPath().setValue(jp.nextTextValue());
            } else if (APPLY.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (CsdlDynamicExpression)jp.readValueAs(ClientCsdlApply.class);
            } else if (CAST.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (CsdlDynamicExpression)jp.readValueAs(ClientCsdlCast.class);
            } else if (COLLECTION.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (CsdlDynamicExpression)jp.readValueAs(ClientCsdlCollection.class);
            } else if (IF.equals(jp.getCurrentName())) {
                jp.nextToken();
                jp.nextToken();
                CsdlIf ifImpl = new CsdlIf();
                ifImpl.setGuard(this.parseConstOrEnumExpression(jp));
                ifImpl.setThen(this.parseConstOrEnumExpression(jp));
                ifImpl.setElse(this.parseConstOrEnumExpression(jp));
                expression = ifImpl;
            } else if (IS_OF.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (CsdlDynamicExpression)jp.readValueAs(ClientCsdlIsOf.class);
            } else if (LABELED_ELEMENT.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (CsdlDynamicExpression)jp.readValueAs(ClientCsdlLabeledElement.class);
            } else if (NULL.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (CsdlDynamicExpression)jp.readValueAs(ClientCsdlNull.class);
            } else if (RECORD.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (CsdlDynamicExpression)jp.readValueAs(ClientCsdlRecord.class);
            } else if (URL_REF.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (CsdlDynamicExpression)jp.readValueAs(ClientCsdlUrlRef.class);
            }
            return expression;
        }
    }
}

