/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.nio.charset.Charset;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequestItem;
import org.apache.olingo.client.core.communication.request.AbstractODataStreamer;

public abstract class AbstractODataBatchRequestItem
extends AbstractODataStreamer
implements ODataBatchRequestItem {
    protected boolean hasStreamedSomething = false;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private boolean open = true;
    protected ODataBatchRequest req;

    public AbstractODataBatchRequestItem(ODataBatchRequest req) {
        super(req.getOutputStream());
        this.req = req;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.closeItem();
        this.open = false;
    }

    protected void streamRequestHeader(String contentId) {
        this.stream("Content-Type: application/http".getBytes(DEFAULT_CHARSET));
        this.newLine();
        this.stream("Content-Transfer-Encoding: binary".getBytes(DEFAULT_CHARSET));
        this.newLine();
        this.stream(("Content-ID:" + contentId).getBytes(DEFAULT_CHARSET));
        this.newLine();
        this.newLine();
    }

    protected void streamRequestHeader(ODataBatchableRequest request) {
        this.stream("Content-Type: application/http".getBytes(DEFAULT_CHARSET));
        this.newLine();
        this.stream("Content-Transfer-Encoding: binary".getBytes(DEFAULT_CHARSET));
        this.newLine();
        this.newLine();
        this.stream(request.toByteArray());
        this.newLine();
    }

    public boolean hasStreamedSomething() {
        return this.hasStreamedSomething;
    }

    protected abstract void closeItem();
}

