/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.plugins.enforcer.utils.EnforcerRuleUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RequireNoRepositories
extends AbstractNonCacheableEnforcerRule {
    private boolean banRepositories = true;
    private boolean banPluginRepositories = true;
    private List<String> allowedRepositories = Collections.emptyList();
    private List<String> allowedPluginRepositories = Collections.emptyList();
    private boolean allowSnapshotRepositories = false;
    private boolean allowSnapshotPluginRepositories = false;

    public final void setBanRepositories(boolean banRepositories) {
        this.banRepositories = banRepositories;
    }

    public final void setBanPluginRepositories(boolean banPluginRepositories) {
        this.banPluginRepositories = banPluginRepositories;
    }

    public final void setAllowedRepositories(List<String> allowedRepositories) {
        this.allowedRepositories = allowedRepositories;
    }

    public final void setAllowedPluginRepositories(List<String> allowedPluginRepositories) {
        this.allowedPluginRepositories = allowedPluginRepositories;
    }

    public final void setAllowSnapshotRepositories(boolean allowSnapshotRepositories) {
        this.allowSnapshotRepositories = allowSnapshotRepositories;
    }

    public final void setAllowSnapshotPluginRepositories(boolean allowSnapshotPluginRepositories) {
        this.allowSnapshotPluginRepositories = allowSnapshotPluginRepositories;
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        EnforcerRuleUtils utils = new EnforcerRuleUtils(helper);
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            List<Model> models = utils.getModelsRecursively(project.getGroupId(), project.getArtifactId(), project.getVersion(), new File(project.getBasedir(), "pom.xml"));
            ArrayList<Model> badModels = new ArrayList<Model>();
            StringBuffer newMsg = new StringBuffer();
            newMsg.append("Some poms have repositories defined:\n");
            for (Model model : models) {
                List<String> bannedRepos;
                List repos;
                if (this.banRepositories && (repos = model.getRepositories()) != null && !repos.isEmpty() && !(bannedRepos = RequireNoRepositories.findBannedRepositories(repos, this.allowedRepositories, this.allowSnapshotRepositories)).isEmpty()) {
                    badModels.add(model);
                    newMsg.append(model.getGroupId() + ":" + model.getArtifactId() + " version:" + model.getVersion() + " has repositories " + bannedRepos);
                }
                if (!this.banPluginRepositories || (repos = model.getPluginRepositories()) == null || repos.isEmpty() || (bannedRepos = RequireNoRepositories.findBannedRepositories(repos, this.allowedPluginRepositories, this.allowSnapshotPluginRepositories)).isEmpty()) continue;
                badModels.add(model);
                newMsg.append(model.getGroupId() + ":" + model.getArtifactId() + " version:" + model.getVersion() + " has plugin repositories " + bannedRepos);
            }
            if (!badModels.isEmpty()) {
                String message = this.getMessage();
                if (StringUtils.isNotEmpty((String)message)) {
                    newMsg.append(message);
                }
                throw new EnforcerRuleException(newMsg.toString());
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (ArtifactNotFoundException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (XmlPullParserException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
    }

    private static List<String> findBannedRepositories(List<Repository> repos, List<String> allowedRepos, boolean allowSnapshots) {
        ArrayList<String> bannedRepos = new ArrayList<String>(allowedRepos.size());
        for (Repository r : repos) {
            if (allowedRepos.contains(r.getId()) || allowSnapshots && r.getReleases() != null && !r.getReleases().isEnabled()) continue;
            bannedRepos.add(r.getId());
        }
        return bannedRepos;
    }
}

