/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg.imageio;

import de.digitalcollections.openjpeg.OpenJpeg;
import de.digitalcollections.openjpeg.imageio.OpenJp2ImageWriter;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class OpenJp2ImageWriterSpi
extends ImageWriterSpi {
    private static final String vendorName = "M\u00fcnchener Digitalisierungszentrum/Digitale Bibliothek, Bayerische Staatsbibliothek";
    private static final String version = "0.1.0";
    private static final String writerClassName = "de.digitalcollections.openjpeg.imageio.OpenJp2ImageWriter";
    private static final String[] names = new String[]{"jpeg2000"};
    private static final String[] suffixes = new String[]{"jp2"};
    private static final String[] MIMETypes = new String[]{"image/jp2"};
    private static final String[] readerSpiNames = new String[]{"de.digitalcollections.openjpeg.imageio.OpenJp2ImageWriterSpi"};
    private static final Class[] outputTypes = new Class[]{ImageOutputStream.class};
    private OpenJpeg lib;

    public OpenJp2ImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, outputTypes, readerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    private void loadLibrary() throws IOException {
        if (this.lib == null) {
            try {
                this.lib = new OpenJpeg();
            }
            catch (UnsatisfiedLinkError e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return type.getNumBands() == 3 && type.getBufferedImageType() == 5 || type.getNumBands() == 1 && type.getBufferedImageType() == 10;
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        this.loadLibrary();
        return new OpenJp2ImageWriter(this, this.lib);
    }

    @Override
    public String getDescription(Locale locale) {
        return "JPEG2000 reader plugin based on the OpenJp2 library from the OpenJPEG project.";
    }
}

