/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg.imageio;

import de.digitalcollections.openjpeg.Info;
import de.digitalcollections.openjpeg.OpenJpeg;
import de.digitalcollections.openjpeg.imageio.ImageInputStreamWrapper;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenJp2ImageReader
extends ImageReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenJp2ImageReader.class);
    private OpenJpeg lib;
    private ImageInputStream stream = null;
    private ImageInputStreamWrapper streamWrapper = null;
    private Info info = null;

    protected OpenJp2ImageReader(ImageReaderSpi originatingProvider, OpenJpeg lib) {
        super(originatingProvider);
        this.lib = lib;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            return;
        }
        if (!(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Bad input.");
        }
        this.stream = (ImageInputStream)input;
        this.streamWrapper = new ImageInputStreamWrapper(this.stream, this.lib);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return this.getInfo().getNumResolutions();
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex >= this.getInfo().getNumResolutions()) {
            throw new IndexOutOfBoundsException("bad index");
        }
    }

    private Info getInfo() {
        if (this.info == null) {
            try {
                this.info = this.lib.getInfo(this.streamWrapper);
                this.stream.seek(0L);
                this.streamWrapper = new ImageInputStreamWrapper(this.stream, this.lib);
            }
            catch (IOException e) {
                LOGGER.error("Error obtaining info", (Throwable)e);
                this.info = null;
            }
        }
        return this.info;
    }

    private int adjustSize(int size, int imageIndex) {
        return (int)((double)size / Math.pow(2.0, imageIndex));
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.adjustSize(this.info.getNativeSize().width, imageIndex);
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.adjustSize(this.info.getNativeSize().height, imageIndex);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return Collections.singletonList(ImageTypeSpecifier.createFromBufferedImageType(5)).iterator();
    }

    private Rectangle adjustRegion(int imageIndex, Rectangle sourceRegion) throws IOException {
        if (sourceRegion == null) {
            return null;
        }
        if (sourceRegion.x == 0 && sourceRegion.y == 0 && sourceRegion.width == this.getWidth(imageIndex) && sourceRegion.height == this.getHeight(imageIndex)) {
            return null;
        }
        double scaleFactor = (double)this.getWidth(0) / (double)this.getWidth(imageIndex);
        return new Rectangle((int)Math.ceil(scaleFactor * (double)sourceRegion.x), (int)Math.ceil(scaleFactor * (double)sourceRegion.y), (int)Math.ceil(scaleFactor * (double)sourceRegion.width), (int)Math.ceil(scaleFactor * (double)sourceRegion.height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        try {
            Rectangle sourceRegion = null;
            if (param != null) {
                sourceRegion = this.adjustRegion(imageIndex, param.getSourceRegion());
            }
            BufferedImage bufferedImage = this.lib.decode(this.streamWrapper, sourceRegion, imageIndex);
            return bufferedImage;
        }
        finally {
            if (this.streamWrapper != null) {
                this.streamWrapper.close();
            }
        }
    }

    @Override
    public boolean isImageTiled(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.getInfo().getNumTiles() > 1;
    }

    @Override
    public int getTileWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.adjustSize(this.getInfo().getTileSize().width, imageIndex);
    }

    @Override
    public int getTileHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.adjustSize(this.getInfo().getTileSize().height, imageIndex);
    }

    @Override
    public int getTileGridXOffset(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.getInfo().getTileOrigin().x;
    }

    @Override
    public int getTileGridYOffset(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.getInfo().getTileOrigin().y;
    }

    @Override
    public BufferedImage readTile(int imageIndex, int tileX, int tileY) throws IOException {
        this.checkIndex(imageIndex);
        int xOffset = this.getTileGridXOffset(imageIndex);
        int yOffset = this.getTileGridYOffset(imageIndex);
        int tileWidth = this.getTileWidth(imageIndex);
        int tileHeight = this.getTileHeight(imageIndex);
        Rectangle region = new Rectangle(xOffset + tileX * tileWidth, yOffset + tileY * tileHeight, tileWidth, tileHeight);
        if (region.x + region.width > this.getWidth(imageIndex) || region.y + region.height > this.getHeight(imageIndex)) {
            throw new IllegalArgumentException("Tile indices out of bounds.");
        }
        ImageReadParam param = this.getDefaultReadParam();
        param.setSourceRegion(region);
        return this.read(imageIndex, param);
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }
}

