/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg;

import de.digitalcollections.openjpeg.lib.callbacks.opj_stream_seek_fn;
import de.digitalcollections.openjpeg.lib.callbacks.opj_stream_skip_fn;
import de.digitalcollections.openjpeg.lib.callbacks.opj_stream_write_fn;
import de.digitalcollections.openjpeg.lib.libopenjp2;
import java.io.IOException;
import jnr.ffi.Pointer;

public abstract class OutStreamWrapper {
    private libopenjp2 lib;
    private Pointer stream;
    private opj_stream_write_fn write_cb;
    private opj_stream_skip_fn skip_cb;
    private opj_stream_seek_fn seek_cb;

    protected OutStreamWrapper(libopenjp2 lib) {
        this.lib = lib;
        this.stream = lib.opj_stream_create(0x100000L, false);
        this.skip_cb = this::skip;
        this.seek_cb = this::seek;
        this.write_cb = this::write;
        lib.opj_stream_set_write_function(this.stream, this.write_cb);
        lib.opj_stream_set_skip_function(this.stream, this.skip_cb);
        lib.opj_stream_set_seek_function(this.stream, this.seek_cb);
        lib.opj_stream_set_user_data_length(this.stream, (long)Math.pow(2.0, 32.0));
    }

    public Pointer getNativeStream() {
        return this.stream;
    }

    protected abstract long write(Pointer var1, long var2, Pointer var4);

    protected abstract long skip(long var1, Pointer var3);

    protected abstract boolean seek(long var1, Pointer var3);

    public void close() throws IOException {
        this.lib.opj_stream_destroy(this.stream);
        this.stream = null;
    }
}

