/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.checkin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitItem;

public class SvnJavaCheckInCommand
extends AbstractCheckInCommand
implements SvnCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion tag) throws ScmException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("SVN commit directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        CommitHandler handler = new CommitHandler();
        SVNCommitClient svnCommitClient = javaRepo.getClientManager().getCommitClient();
        svnCommitClient.setCommitHandler((ISVNCommitHandler)handler);
        try {
            ArrayList<File> paths;
            List tmpPaths = fileSet.getFileList();
            if (tmpPaths == null || tmpPaths.isEmpty()) {
                paths = new ArrayList<File>(1);
                paths.add(fileSet.getBasedir());
            } else {
                paths = new ArrayList(tmpPaths.size());
                for (File f : tmpPaths) {
                    if (f.isAbsolute()) {
                        paths.add(f);
                        continue;
                    }
                    paths.add(new File(fileSet.getBasedir(), f.toString()));
                }
            }
            SVNCommitInfo svnCommitInfo = SvnJavaUtil.commit(svnCommitClient, paths.toArray(new File[paths.size()]), false, message, true);
            ArrayList<ScmFile> files = new ArrayList<ScmFile>();
            for (String filePath : handler.getFiles()) {
                files.add(new ScmFile(filePath, ScmFileStatus.CHECKED_IN));
            }
            CheckInScmResult checkInScmResult = new CheckInScmResult("JavaSVN Library", files, Long.toString(svnCommitInfo.getNewRevision()));
            return checkInScmResult;
        }
        catch (SVNException e) {
            CheckInScmResult checkInScmResult = new CheckInScmResult("JavaSVN Library", "SVN commit failed.", e.getMessage(), false);
            return checkInScmResult;
        }
        finally {
            javaRepo.getClientManager().getCommitClient().setEventHandler(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommitHandler
    implements ISVNCommitHandler {
        private List<String> files = new ArrayList<String>();

        public String getCommitMessage(String message, SVNCommitItem[] commitItems) throws SVNException {
            if (commitItems != null) {
                for (SVNCommitItem commitItem : commitItems) {
                    if (!commitItem.getFile().isFile()) continue;
                    this.files.add(commitItem.getPath());
                }
            }
            return message;
        }

        public SVNProperties getRevisionProperties(String arg0, SVNCommitItem[] arg1, SVNProperties svnProperties) throws SVNException {
            return svnProperties;
        }

        public List<String> getFiles() {
            return this.files;
        }
    }
}

