/* Copyright 2013 Samuel Halliday (generated Java and C).
 * Copyright 2003-2007 Keith Seymour (Fortran to Java translation).
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 *
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.github.fommil.netlib;

/**
 * Generated by {@code JavaInterfaceGenerator} from {@code org.netlib.arpack} in {@code net.sourceforge.f2j:arpack_combined_all:jar:0.1}.
 * <p>
 * Property {@value #PROPERTY_KEY} defines the implementation to load,
 * defaulting to {@value #FALLBACK}.
 * <p>
 * <i>This requires 1D column-major linearized arrays, as
 * expected by the lower level routines; contrary to
 * typical Java 2D row-major arrays.</i>
 */
@lombok.extern.java.Log
public abstract class ARPACK {

  private static final String FALLBACK = "com.github.fommil.netlib.F2jARPACK";
  private static final String IMPLS = "com.github.fommil.netlib.NativeSystemARPACK,com.github.fommil.netlib.NativeRefARPACK,com.github.fommil.netlib.F2jARPACK";
  private static final String PROPERTY_KEY = "com.github.fommil.netlib.ARPACK";
  private static final ARPACK INSTANCE;
  static {
    try {
      String[] classNames = System.getProperty(PROPERTY_KEY, IMPLS).split(",");
      ARPACK impl = null;
      for (String className: classNames) {
        try {
          impl = load(className);
          break;
        } catch (ExceptionInInitializerError e) {
          log.warning("Failed to load implementation from: " + className);
        }
      }
      if (impl == null) {
        log.warning("Using the fallback implementation.");
        impl = load(FALLBACK);
      }
      INSTANCE = impl;
      log.config("Implementation provided by " + INSTANCE.getClass());
    } catch (Exception e) {
      throw new ExceptionInInitializerError(e);
    }
  }

  private static ARPACK load(String className) throws Exception {
    Class klass = Class.forName(className);
    return (ARPACK) klass.newInstance();
  }

  /**
   * @return the environment-defined implementation.
   */
  public static ARPACK getInstance() {
    return INSTANCE;
  }

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    DMOUT
    Purpose:    Real matrix output routine.
    Usage:      CALL DMOUT (LOUT, M, N, A, LDA, IDIGIT, IFMT)
    Arguments
       M      - Number of rows of A.  (Input)
       N      - Number of columns of A.  (Input)
       A      - Real M by N matrix to be printed.  (Input)
       LDA    - Leading dimension of A exactly as specified in the
                dimension statement of the calling program.  (Input)
       IFMT   - Format to be used in printing matrix A.  (Input)
       IDIGIT - Print up to IABS(IDIGIT) decimal digits per number.  (In)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void dmout(int lout, int m, int n, double[] a, int lda, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    DMOUT
    Purpose:    Real matrix output routine.
    Usage:      CALL DMOUT (LOUT, M, N, A, LDA, IDIGIT, IFMT)
    Arguments
       M      - Number of rows of A.  (Input)
       N      - Number of columns of A.  (Input)
       A      - Real M by N matrix to be printed.  (Input)
       LDA    - Leading dimension of A exactly as specified in the
                dimension statement of the calling program.  (Input)
       IFMT   - Format to be used in printing matrix A.  (Input)
       IDIGIT - Print up to IABS(IDIGIT) decimal digits per number.  (In)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void dmout(int lout, int m, int n, double[] a, int _a_offset, int lda, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    DVOUT
    Purpose:    Real vector output routine.
    Usage:      CALL DVOUT (LOUT, N, SX, IDIGIT, IFMT)
    Arguments
       N      - Length of array SX.  (Input)
       SX     - Real array to be printed.  (Input)
       IFMT   - Format to be used in printing array SX.  (Input)
       IDIGIT - Print up to IABS(IDIGIT) decimal digits per number.  (In)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param n
   * @param sx
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void dvout(int lout, int n, double[] sx, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    DVOUT
    Purpose:    Real vector output routine.
    Usage:      CALL DVOUT (LOUT, N, SX, IDIGIT, IFMT)
    Arguments
       N      - Length of array SX.  (Input)
       SX     - Real array to be printed.  (Input)
       IFMT   - Format to be used in printing array SX.  (Input)
       IDIGIT - Print up to IABS(IDIGIT) decimal digits per number.  (In)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param n
   * @param sx
   * @param _sx_offset
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void dvout(int lout, int n, double[] sx, int _sx_offset, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
       Count the number of elements equal to a specified integer value.
   * </code></pre>
   *
   * @param n
   * @param array
   * @param value
   * @return
   */
  abstract public int icnteq(int n, int[] array, int value);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
       Count the number of elements equal to a specified integer value.
   * </code></pre>
   *
   * @param n
   * @param array
   * @param _array_offset
   * @param value
   * @return
   */
  abstract public int icnteq(int n, int[] array, int _array_offset, int value);

  /**
   * <pre><code>
  --------------------------------------------------------------------
  \Documentation
  \Name: ICOPY
  \Description:
       ICOPY copies an integer vector lx to an integer vector ly.
  \Usage:
       call icopy ( n, lx, inc, ly, incy )
  \Arguments:
      n        integer (input)
               On entry, n is the number of elements of lx to be
               copied to ly.
      lx       integer array (input)
               On entry, lx is the integer vector to be copied.
      incx     integer (input)
               On entry, incx is the increment between elements of lx.
      ly       integer array (input)
               On exit, ly is the integer vector that contains the
               copy of lx.
      incy     integer (input)
               On entry, incy is the increment between elements of ly.
  \Enddoc
  --------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param lx
   * @param incx
   * @param ly
   * @param incy
   * 
   */
  abstract public void icopy(int n, int[] lx, int incx, int[] ly, int incy);

  /**
   * <pre><code>
  --------------------------------------------------------------------
  \Documentation
  \Name: ICOPY
  \Description:
       ICOPY copies an integer vector lx to an integer vector ly.
  \Usage:
       call icopy ( n, lx, inc, ly, incy )
  \Arguments:
      n        integer (input)
               On entry, n is the number of elements of lx to be
               copied to ly.
      lx       integer array (input)
               On entry, lx is the integer vector to be copied.
      incx     integer (input)
               On entry, incx is the increment between elements of lx.
      ly       integer array (input)
               On exit, ly is the integer vector that contains the
               copy of lx.
      incy     integer (input)
               On entry, incy is the increment between elements of ly.
  \Enddoc
  --------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param lx
   * @param _lx_offset
   * @param incx
   * @param ly
   * @param _ly_offset
   * @param incy
   * 
   */
  abstract public void icopy(int n, int[] lx, int _lx_offset, int incx, int[] ly, int _ly_offset, int incy);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
       Only work with increment equal to 1 right now.
   * </code></pre>
   *
   * @param n
   * @param value
   * @param array
   * @param inc
   * 
   */
  abstract public void iset(int n, int value, int[] array, int inc);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
       Only work with increment equal to 1 right now.
   * </code></pre>
   *
   * @param n
   * @param value
   * @param array
   * @param _array_offset
   * @param inc
   * 
   */
  abstract public void iset(int n, int value, int[] array, int _array_offset, int inc);

  /**
   * <pre><code>
       interchanges two vectors.
       uses unrolled loops for increments equal to 1.
       jack dongarra, linpack, 3/11/78.
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param incx
   * @param sy
   * @param incy
   * 
   */
  abstract public void iswap(int n, int[] sx, int incx, int[] sy, int incy);

  /**
   * <pre><code>
       interchanges two vectors.
       uses unrolled loops for increments equal to 1.
       jack dongarra, linpack, 3/11/78.
   * </code></pre>
   *
   * @param n
   * @param sx
   * @param _sx_offset
   * @param incx
   * @param sy
   * @param _sy_offset
   * @param incy
   * 
   */
  abstract public void iswap(int n, int[] sx, int _sx_offset, int incx, int[] sy, int _sy_offset, int incy);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    IVOUT
    Purpose:    Integer vector output routine.
    Usage:      CALL IVOUT (LOUT, N, IX, IDIGIT, IFMT)
    Arguments
       N      - Length of array IX. (Input)
       IX     - Integer array to be printed. (Input)
       IFMT   - Format to be used in printing array IX. (Input)
       IDIGIT - Print up to ABS(IDIGIT) decimal digits / number. (Input)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param n
   * @param ix
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void ivout(int lout, int n, int[] ix, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    IVOUT
    Purpose:    Integer vector output routine.
    Usage:      CALL IVOUT (LOUT, N, IX, IDIGIT, IFMT)
    Arguments
       N      - Length of array IX. (Input)
       IX     - Integer array to be printed. (Input)
       IFMT   - Format to be used in printing array IX. (Input)
       IDIGIT - Print up to ABS(IDIGIT) decimal digits / number. (Input)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param n
   * @param ix
   * @param _ix_offset
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void ivout(int lout, int n, int[] ix, int _ix_offset, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
    -- LAPACK auxiliary routine (preliminary version) --
       Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
       Courant Institute, Argonne National Lab, and Rice University
       July 26, 1991
    Purpose
    =======
    SECOND returns the user time for a process in seconds.
    This version gets the time from the system function ETIME.
       .. Local Scalars ..
   * </code></pre>
   *
   * @param t
   * 
   */
  abstract public void second(org.netlib.util.floatW t);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    SMOUT
    Purpose:    Real matrix output routine.
    Usage:      CALL SMOUT (LOUT, M, N, A, LDA, IDIGIT, IFMT)
    Arguments
       M      - Number of rows of A.  (Input)
       N      - Number of columns of A.  (Input)
       A      - Real M by N matrix to be printed.  (Input)
       LDA    - Leading dimension of A exactly as specified in the
                dimension statement of the calling program.  (Input)
       IFMT   - Format to be used in printing matrix A.  (Input)
       IDIGIT - Print up to IABS(IDIGIT) decimal digits per number.  (In)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param m
   * @param n
   * @param a
   * @param lda
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void smout(int lout, int m, int n, float[] a, int lda, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    SMOUT
    Purpose:    Real matrix output routine.
    Usage:      CALL SMOUT (LOUT, M, N, A, LDA, IDIGIT, IFMT)
    Arguments
       M      - Number of rows of A.  (Input)
       N      - Number of columns of A.  (Input)
       A      - Real M by N matrix to be printed.  (Input)
       LDA    - Leading dimension of A exactly as specified in the
                dimension statement of the calling program.  (Input)
       IFMT   - Format to be used in printing matrix A.  (Input)
       IDIGIT - Print up to IABS(IDIGIT) decimal digits per number.  (In)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param m
   * @param n
   * @param a
   * @param _a_offset
   * @param lda
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void smout(int lout, int m, int n, float[] a, int _a_offset, int lda, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    SVOUT
    Purpose:    Real vector output routine.
    Usage:      CALL SVOUT (LOUT, N, SX, IDIGIT, IFMT)
    Arguments
       N      - Length of array SX.  (Input)
       SX     - Real array to be printed.  (Input)
       IFMT   - Format to be used in printing array SX.  (Input)
       IDIGIT - Print up to IABS(IDIGIT) decimal digits per number.  (In)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param n
   * @param sx
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void svout(int lout, int n, float[] sx, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
  -----------------------------------------------------------------------
    Routine:    SVOUT
    Purpose:    Real vector output routine.
    Usage:      CALL SVOUT (LOUT, N, SX, IDIGIT, IFMT)
    Arguments
       N      - Length of array SX.  (Input)
       SX     - Real array to be printed.  (Input)
       IFMT   - Format to be used in printing array SX.  (Input)
       IDIGIT - Print up to IABS(IDIGIT) decimal digits per number.  (In)
                If IDIGIT .LT. 0, printing is done with 72 columns.
                If IDIGIT .GT. 0, printing is done with 132 columns.
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param lout
   * @param n
   * @param sx
   * @param _sx_offset
   * @param idigit
   * @param ifmt
   * 
   */
  abstract public void svout(int lout, int n, float[] sx, int _sx_offset, int idigit, java.lang.String ifmt);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dgetv0
  \Description: 
    Generate a random initial residual vector for the Arnoldi process.
    Force the residual vector to be in the range of the operator OP.  
  \Usage:
    call dgetv0
       ( IDO, BMAT, ITRY, INITV, N, J, V, LDV, RESID, RNORM, 
         IPNTR, WORKD, IERR )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first
            call to dgetv0.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO = 99: done
            -------------------------------------------------------------
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B in the (generalized)
            eigenvalue problem A*x = lambda*B*x.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    ITRY    Integer.  (INPUT)
            ITRY counts the number of times that dgetv0 is called.  
            It should be set to 1 on the initial call to dgetv0.
    INITV   Logical variable.  (INPUT)
            .TRUE.  => the initial residual vector is given in RESID.
            .FALSE. => generate a random initial residual vector.
    N       Integer.  (INPUT)
            Dimension of the problem.
    J       Integer.  (INPUT)
            Index of the residual vector to be generated, with respect to
            the Arnoldi process.  J > 1 in case of a "restart".
    V       Double precision N by J array.  (INPUT)
            The first J-1 columns of V contain the current Arnoldi basis
            if this is a "restart".
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            Initial residual vector to be generated.  If RESID is 
            provided, force RESID into the range of the operator OP.
    RNORM   Double precision scalar.  (OUTPUT)
            B-norm of the generated residual.
    IPNTR   Integer array of length 3.  (OUTPUT)
    WORKD   Double precision work array of length 2*N.  (REVERSE COMMUNICATION).
            On exit, WORK(1:N) = B*RESID to be used in SSAITR.
    IERR    Integer.  (OUTPUT)
            =  0: Normal exit.
            = -1: Cannot generate a nontrivial restarted residual vector
                  in the range of the operator OP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine for vector output.
       dlarnv  LAPACK routine for generating a random vector.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       dcopy   Level 1 BLAS that copies one vector to another.
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: getv0.F   SID: 2.7   DATE OF SID: 04/07/99   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param itry
   * @param initv
   * @param n
   * @param j
   * @param v
   * @param ldv
   * @param resid
   * @param rnorm
   * @param ipntr
   * @param workd
   * @param ierr
   * 
   */
  abstract public void dgetv0(org.netlib.util.intW ido, java.lang.String bmat, int itry, boolean initv, int n, int j, double[] v, int ldv, double[] resid, org.netlib.util.doubleW rnorm, int[] ipntr, double[] workd, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dgetv0
  \Description: 
    Generate a random initial residual vector for the Arnoldi process.
    Force the residual vector to be in the range of the operator OP.  
  \Usage:
    call dgetv0
       ( IDO, BMAT, ITRY, INITV, N, J, V, LDV, RESID, RNORM, 
         IPNTR, WORKD, IERR )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first
            call to dgetv0.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO = 99: done
            -------------------------------------------------------------
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B in the (generalized)
            eigenvalue problem A*x = lambda*B*x.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    ITRY    Integer.  (INPUT)
            ITRY counts the number of times that dgetv0 is called.  
            It should be set to 1 on the initial call to dgetv0.
    INITV   Logical variable.  (INPUT)
            .TRUE.  => the initial residual vector is given in RESID.
            .FALSE. => generate a random initial residual vector.
    N       Integer.  (INPUT)
            Dimension of the problem.
    J       Integer.  (INPUT)
            Index of the residual vector to be generated, with respect to
            the Arnoldi process.  J > 1 in case of a "restart".
    V       Double precision N by J array.  (INPUT)
            The first J-1 columns of V contain the current Arnoldi basis
            if this is a "restart".
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            Initial residual vector to be generated.  If RESID is 
            provided, force RESID into the range of the operator OP.
    RNORM   Double precision scalar.  (OUTPUT)
            B-norm of the generated residual.
    IPNTR   Integer array of length 3.  (OUTPUT)
    WORKD   Double precision work array of length 2*N.  (REVERSE COMMUNICATION).
            On exit, WORK(1:N) = B*RESID to be used in SSAITR.
    IERR    Integer.  (OUTPUT)
            =  0: Normal exit.
            = -1: Cannot generate a nontrivial restarted residual vector
                  in the range of the operator OP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine for vector output.
       dlarnv  LAPACK routine for generating a random vector.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       dcopy   Level 1 BLAS that copies one vector to another.
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: getv0.F   SID: 2.7   DATE OF SID: 04/07/99   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param itry
   * @param initv
   * @param n
   * @param j
   * @param v
   * @param _v_offset
   * @param ldv
   * @param resid
   * @param _resid_offset
   * @param rnorm
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param ierr
   * 
   */
  abstract public void dgetv0(org.netlib.util.intW ido, java.lang.String bmat, int itry, boolean initv, int n, int j, double[] v, int _v_offset, int ldv, double[] resid, int _resid_offset, org.netlib.util.doubleW rnorm, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dlaqrb
  \Description:
    Compute the eigenvalues and the Schur decomposition of an upper 
    Hessenberg submatrix in rows and columns ILO to IHI.  Only the
    last component of the Schur vectors are computed.
    This is mostly a modification of the LAPACK routine dlahqr.
    
  \Usage:
    call dlaqrb
       ( WANTT, N, ILO, IHI, H, LDH, WR, WI,  Z, INFO )
  \Arguments
    WANTT   Logical variable.  (INPUT)
            = .TRUE. : the full Schur form T is required;
            = .FALSE.: only eigenvalues are required.
    N       Integer.  (INPUT)
            The order of the matrix H.  N >= 0.
    ILO     Integer.  (INPUT)
    IHI     Integer.  (INPUT)
            It is assumed that H is already upper quasi-triangular in
            rows and columns IHI+1:N, and that H(ILO,ILO-1) = 0 (unless
            ILO = 1). SLAQRB works primarily with the Hessenberg
            submatrix in rows and columns ILO to IHI, but applies
            transformations to all of H if WANTT is .TRUE..
            1 <= ILO <= max(1,IHI); IHI <= N.
    H       Double precision array, dimension (LDH,N).  (INPUT/OUTPUT)
            On entry, the upper Hessenberg matrix H.
            On exit, if WANTT is .TRUE., H is upper quasi-triangular in
            rows and columns ILO:IHI, with any 2-by-2 diagonal blocks in
            standard form. If WANTT is .FALSE., the contents of H are
            unspecified on exit.
    LDH     Integer.  (INPUT)
            The leading dimension of the array H. LDH >= max(1,N).
    WR      Double precision array, dimension (N).  (OUTPUT)
    WI      Double precision array, dimension (N).  (OUTPUT)
            The real and imaginary parts, respectively, of the computed
            eigenvalues ILO to IHI are stored in the corresponding
            elements of WR and WI. If two eigenvalues are computed as a
            complex conjugate pair, they are stored in consecutive
            elements of WR and WI, say the i-th and (i+1)th, with
            WI(i) > 0 and WI(i+1) < 0. If WANTT is .TRUE., the
            eigenvalues are stored in the same order as on the diagonal
            of the Schur form returned in H, with WR(i) = H(i,i), and, if
            H(i:i+1,i:i+1) is a 2-by-2 diagonal block,
            WI(i) = sqrt(H(i+1,i)*H(i,i+1)) and WI(i+1) = -WI(i).
    Z       Double precision array, dimension (N).  (OUTPUT)
            On exit Z contains the last components of the Schur vectors.
    INFO    Integer.  (OUPUT)
            = 0: successful exit
            > 0: SLAQRB failed to compute all the eigenvalues ILO to IHI
                 in a total of 30*(IHI-ILO+1) iterations; if INFO = i,
                 elements i+1:ihi of WR and WI contain those eigenvalues
                 which have been successfully computed.
  \Remarks
    1. None.
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dlabad  LAPACK routine that computes machine constants.
       dlamch  LAPACK routine that determines machine constants.
       dlanhs  LAPACK routine that computes various norms of a matrix.
       dlanv2  LAPACK routine that computes the Schur factorization of
               2 by 2 nonsymmetric matrix in standard form.
       dlarfg  LAPACK Householder reflection construction routine.
       dcopy   Level 1 BLAS that copies one vector to another.
       drot    Level 1 BLAS that applies a rotation to a 2 by 2 matrix.

  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.4'
                 Modified from the LAPACK routine dlahqr so that only the
                 last component of the Schur vectors are computed.
  \SCCS Information: @(#) 
   FILE: laqrb.F   SID: 2.2   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param wantt
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param ldh
   * @param wr
   * @param wi
   * @param z
   * @param info
   * 
   */
  abstract public void dlaqrb(boolean wantt, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, double[] z, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dlaqrb
  \Description:
    Compute the eigenvalues and the Schur decomposition of an upper 
    Hessenberg submatrix in rows and columns ILO to IHI.  Only the
    last component of the Schur vectors are computed.
    This is mostly a modification of the LAPACK routine dlahqr.
    
  \Usage:
    call dlaqrb
       ( WANTT, N, ILO, IHI, H, LDH, WR, WI,  Z, INFO )
  \Arguments
    WANTT   Logical variable.  (INPUT)
            = .TRUE. : the full Schur form T is required;
            = .FALSE.: only eigenvalues are required.
    N       Integer.  (INPUT)
            The order of the matrix H.  N >= 0.
    ILO     Integer.  (INPUT)
    IHI     Integer.  (INPUT)
            It is assumed that H is already upper quasi-triangular in
            rows and columns IHI+1:N, and that H(ILO,ILO-1) = 0 (unless
            ILO = 1). SLAQRB works primarily with the Hessenberg
            submatrix in rows and columns ILO to IHI, but applies
            transformations to all of H if WANTT is .TRUE..
            1 <= ILO <= max(1,IHI); IHI <= N.
    H       Double precision array, dimension (LDH,N).  (INPUT/OUTPUT)
            On entry, the upper Hessenberg matrix H.
            On exit, if WANTT is .TRUE., H is upper quasi-triangular in
            rows and columns ILO:IHI, with any 2-by-2 diagonal blocks in
            standard form. If WANTT is .FALSE., the contents of H are
            unspecified on exit.
    LDH     Integer.  (INPUT)
            The leading dimension of the array H. LDH >= max(1,N).
    WR      Double precision array, dimension (N).  (OUTPUT)
    WI      Double precision array, dimension (N).  (OUTPUT)
            The real and imaginary parts, respectively, of the computed
            eigenvalues ILO to IHI are stored in the corresponding
            elements of WR and WI. If two eigenvalues are computed as a
            complex conjugate pair, they are stored in consecutive
            elements of WR and WI, say the i-th and (i+1)th, with
            WI(i) > 0 and WI(i+1) < 0. If WANTT is .TRUE., the
            eigenvalues are stored in the same order as on the diagonal
            of the Schur form returned in H, with WR(i) = H(i,i), and, if
            H(i:i+1,i:i+1) is a 2-by-2 diagonal block,
            WI(i) = sqrt(H(i+1,i)*H(i,i+1)) and WI(i+1) = -WI(i).
    Z       Double precision array, dimension (N).  (OUTPUT)
            On exit Z contains the last components of the Schur vectors.
    INFO    Integer.  (OUPUT)
            = 0: successful exit
            > 0: SLAQRB failed to compute all the eigenvalues ILO to IHI
                 in a total of 30*(IHI-ILO+1) iterations; if INFO = i,
                 elements i+1:ihi of WR and WI contain those eigenvalues
                 which have been successfully computed.
  \Remarks
    1. None.
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dlabad  LAPACK routine that computes machine constants.
       dlamch  LAPACK routine that determines machine constants.
       dlanhs  LAPACK routine that computes various norms of a matrix.
       dlanv2  LAPACK routine that computes the Schur factorization of
               2 by 2 nonsymmetric matrix in standard form.
       dlarfg  LAPACK Householder reflection construction routine.
       dcopy   Level 1 BLAS that copies one vector to another.
       drot    Level 1 BLAS that applies a rotation to a 2 by 2 matrix.

  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.4'
                 Modified from the LAPACK routine dlahqr so that only the
                 last component of the Schur vectors are computed.
  \SCCS Information: @(#) 
   FILE: laqrb.F   SID: 2.2   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param wantt
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param _h_offset
   * @param ldh
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param z
   * @param _z_offset
   * @param info
   * 
   */
  abstract public void dlaqrb(boolean wantt, int n, int ilo, int ihi, double[] h, int _h_offset, int ldh, double[] wr, int _wr_offset, double[] wi, int _wi_offset, double[] z, int _z_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dnaitr
  \Description: 
    Reverse communication interface for applying NP additional steps to 
    a K step nonsymmetric Arnoldi factorization.
    Input:  OP*V_{k}  -  V_{k}*H = r_{k}*e_{k}^T
            with (V_{k}^T)*B*V_{k} = I, (V_{k}^T)*B*r_{k} = 0.
    Output: OP*V_{k+p}  -  V_{k+p}*H = r_{k+p}*e_{k+p}^T
            with (V_{k+p}^T)*B*V_{k+p} = I, (V_{k+p}^T)*B*r_{k+p} = 0.
    where OP and B are as in dnaupd.  The B-norm of r_{k+p} is also
    computed and returned.
  \Usage:
    call dnaitr
       ( IDO, BMAT, N, K, NP, NB, RESID, RNORM, V, LDV, H, LDH, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
                      This is for the restart phase to force the new
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y,
                      IPNTR(3) is the pointer into WORK for B * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
            IDO = 99: done
            -------------------------------------------------------------
            When the routine is used in the "shift-and-invert" mode, the
            vector B * Q is already available and do not need to be
            recompute in forming OP * Q.
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.  See dnaupd.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*M**x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    K       Integer.  (INPUT)
            Current size of V and H.
    NP      Integer.  (INPUT)
            Number of additional Arnoldi steps to take.
    NB      Integer.  (INPUT)
            Blocksize to be used in the recurrence.          
            Only work for NB = 1 right now.  The goal is to have a 
            program that implement both the block and non-block method.
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            On INPUT:  RESID contains the residual vector r_{k}.
            On OUTPUT: RESID contains the residual vector r_{k+p}.
    RNORM   Double precision scalar.  (INPUT/OUTPUT)
            B-norm of the starting residual on input.
            B-norm of the updated residual r_{k+p} on output.
    V       Double precision N by K+NP array.  (INPUT/OUTPUT)
            On INPUT:  V contains the Arnoldi vectors in the first K 
            columns.
            On OUTPUT: V contains the new NP Arnoldi vectors in the next
            NP columns.  The first K columns are unchanged.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Double precision (K+NP) by (K+NP) array.  (INPUT/OUTPUT)
            H is used to store the generated upper Hessenberg matrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORK for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The calling program should not 
            use WORKD as temporary workspace during the iteration !!!!!!
            On input, WORKD(1:N) = B*RESID and is used to save some 
            computation at the first step.
    INFO    Integer.  (OUTPUT)
            = 0: Normal exit.
            > 0: Size of the spanning invariant subspace of OP found.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       dgetv0  ARPACK routine to generate the initial vector.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dmout   ARPACK utility routine that prints matrices
       dvout   ARPACK utility routine that prints vectors.
       dlabad  LAPACK routine that computes machine constants.
       dlamch  LAPACK routine that determines machine constants.
       dlascl  LAPACK routine for careful scaling of a matrix.
       dlanhs  LAPACK routine that computes various norms of a matrix.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       daxpy   Level 1 BLAS that computes a vector triad.
       dscal   Level 1 BLAS that scales a vector.
       dcopy   Level 1 BLAS that copies one vector to another .
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
   
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: naitr.F   SID: 2.4   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
    The algorithm implemented is:
    
    restart = .false.
    Given V_{k} = [v_{1}, ..., v_{k}], r_{k}; 
    r_{k} contains the initial residual vector even for k = 0;
    Also assume that rnorm = || B*r_{k} || and B*r_{k} are already 
    computed by the calling program.
    betaj = rnorm ; p_{k+1} = B*r_{k} ;
    For  j = k+1, ..., k+np  Do
       1) if ( betaj < tol ) stop or restart depending on j.
          ( At present tol is zero )
          if ( restart ) generate a new starting vector.
       2) v_{j} = r(j-1)/betaj;  V_{j} = [V_{j-1}, v_{j}];  
          p_{j} = p_{j}/betaj
       3) r_{j} = OP*v_{j} where OP is defined as in dnaupd
          For shift-invert mode p_{j} = B*v_{j} is already available.
          wnorm = || OP*v_{j} ||
       4) Compute the j-th step residual vector.
          w_{j} =  V_{j}^T * B * OP * v_{j}
          r_{j} =  OP*v_{j} - V_{j} * w_{j}
          H(:,j) = w_{j};
          H(j,j-1) = rnorm
          rnorm = || r_(j) ||
          If (rnorm > 0.717*wnorm) accept step and go back to 1)
       5) Re-orthogonalization step:
          s = V_{j}'*B*r_{j}
          r_{j} = r_{j} - V_{j}*s;  rnorm1 = || r_{j} ||
          alphaj = alphaj + s_{j};   
       6) Iterative refinement step:
          If (rnorm1 > 0.717*rnorm) then
             rnorm = rnorm1
             accept step and go back to 1)
          Else
             rnorm = rnorm1
             If this is the first time in step 6), go to 5)
             Else r_{j} lies in the span of V_{j} numerically.
                Set r_{j} = 0 and rnorm = 0; go to 1)
          EndIf 
    End Do
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param k
   * @param np
   * @param nb
   * @param resid
   * @param rnorm
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param ipntr
   * @param workd
   * @param info
   * 
   */
  abstract public void dnaitr(org.netlib.util.intW ido, java.lang.String bmat, int n, int k, int np, int nb, double[] resid, org.netlib.util.doubleW rnorm, double[] v, int ldv, double[] h, int ldh, int[] ipntr, double[] workd, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dnaitr
  \Description: 
    Reverse communication interface for applying NP additional steps to 
    a K step nonsymmetric Arnoldi factorization.
    Input:  OP*V_{k}  -  V_{k}*H = r_{k}*e_{k}^T
            with (V_{k}^T)*B*V_{k} = I, (V_{k}^T)*B*r_{k} = 0.
    Output: OP*V_{k+p}  -  V_{k+p}*H = r_{k+p}*e_{k+p}^T
            with (V_{k+p}^T)*B*V_{k+p} = I, (V_{k+p}^T)*B*r_{k+p} = 0.
    where OP and B are as in dnaupd.  The B-norm of r_{k+p} is also
    computed and returned.
  \Usage:
    call dnaitr
       ( IDO, BMAT, N, K, NP, NB, RESID, RNORM, V, LDV, H, LDH, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
                      This is for the restart phase to force the new
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y,
                      IPNTR(3) is the pointer into WORK for B * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
            IDO = 99: done
            -------------------------------------------------------------
            When the routine is used in the "shift-and-invert" mode, the
            vector B * Q is already available and do not need to be
            recompute in forming OP * Q.
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.  See dnaupd.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*M**x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    K       Integer.  (INPUT)
            Current size of V and H.
    NP      Integer.  (INPUT)
            Number of additional Arnoldi steps to take.
    NB      Integer.  (INPUT)
            Blocksize to be used in the recurrence.          
            Only work for NB = 1 right now.  The goal is to have a 
            program that implement both the block and non-block method.
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            On INPUT:  RESID contains the residual vector r_{k}.
            On OUTPUT: RESID contains the residual vector r_{k+p}.
    RNORM   Double precision scalar.  (INPUT/OUTPUT)
            B-norm of the starting residual on input.
            B-norm of the updated residual r_{k+p} on output.
    V       Double precision N by K+NP array.  (INPUT/OUTPUT)
            On INPUT:  V contains the Arnoldi vectors in the first K 
            columns.
            On OUTPUT: V contains the new NP Arnoldi vectors in the next
            NP columns.  The first K columns are unchanged.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Double precision (K+NP) by (K+NP) array.  (INPUT/OUTPUT)
            H is used to store the generated upper Hessenberg matrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORK for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The calling program should not 
            use WORKD as temporary workspace during the iteration !!!!!!
            On input, WORKD(1:N) = B*RESID and is used to save some 
            computation at the first step.
    INFO    Integer.  (OUTPUT)
            = 0: Normal exit.
            > 0: Size of the spanning invariant subspace of OP found.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       dgetv0  ARPACK routine to generate the initial vector.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dmout   ARPACK utility routine that prints matrices
       dvout   ARPACK utility routine that prints vectors.
       dlabad  LAPACK routine that computes machine constants.
       dlamch  LAPACK routine that determines machine constants.
       dlascl  LAPACK routine for careful scaling of a matrix.
       dlanhs  LAPACK routine that computes various norms of a matrix.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       daxpy   Level 1 BLAS that computes a vector triad.
       dscal   Level 1 BLAS that scales a vector.
       dcopy   Level 1 BLAS that copies one vector to another .
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
   
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: naitr.F   SID: 2.4   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
    The algorithm implemented is:
    
    restart = .false.
    Given V_{k} = [v_{1}, ..., v_{k}], r_{k}; 
    r_{k} contains the initial residual vector even for k = 0;
    Also assume that rnorm = || B*r_{k} || and B*r_{k} are already 
    computed by the calling program.
    betaj = rnorm ; p_{k+1} = B*r_{k} ;
    For  j = k+1, ..., k+np  Do
       1) if ( betaj < tol ) stop or restart depending on j.
          ( At present tol is zero )
          if ( restart ) generate a new starting vector.
       2) v_{j} = r(j-1)/betaj;  V_{j} = [V_{j-1}, v_{j}];  
          p_{j} = p_{j}/betaj
       3) r_{j} = OP*v_{j} where OP is defined as in dnaupd
          For shift-invert mode p_{j} = B*v_{j} is already available.
          wnorm = || OP*v_{j} ||
       4) Compute the j-th step residual vector.
          w_{j} =  V_{j}^T * B * OP * v_{j}
          r_{j} =  OP*v_{j} - V_{j} * w_{j}
          H(:,j) = w_{j};
          H(j,j-1) = rnorm
          rnorm = || r_(j) ||
          If (rnorm > 0.717*wnorm) accept step and go back to 1)
       5) Re-orthogonalization step:
          s = V_{j}'*B*r_{j}
          r_{j} = r_{j} - V_{j}*s;  rnorm1 = || r_{j} ||
          alphaj = alphaj + s_{j};   
       6) Iterative refinement step:
          If (rnorm1 > 0.717*rnorm) then
             rnorm = rnorm1
             accept step and go back to 1)
          Else
             rnorm = rnorm1
             If this is the first time in step 6), go to 5)
             Else r_{j} lies in the span of V_{j} numerically.
                Set r_{j} = 0 and rnorm = 0; go to 1)
          EndIf 
    End Do
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param k
   * @param np
   * @param nb
   * @param resid
   * @param _resid_offset
   * @param rnorm
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param info
   * 
   */
  abstract public void dnaitr(org.netlib.util.intW ido, java.lang.String bmat, int n, int k, int np, int nb, double[] resid, int _resid_offset, org.netlib.util.doubleW rnorm, double[] v, int _v_offset, int ldv, double[] h, int _h_offset, int ldh, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dnapps
  \Description:
    Given the Arnoldi factorization
       A*V_{k} - V_{k}*H_{k} = r_{k+p}*e_{k+p}^T,
    apply NP implicit shifts resulting in
       A*(V_{k}*Q) - (V_{k}*Q)*(Q^T* H_{k}*Q) = r_{k+p}*e_{k+p}^T * Q
    where Q is an orthogonal matrix which is the product of rotations
    and reflections resulting from the NP bulge chage sweeps.
    The updated Arnoldi factorization becomes:
       A*VNEW_{k} - VNEW_{k}*HNEW_{k} = rnew_{k}*e_{k}^T.
  \Usage:
    call dnapps
       ( N, KEV, NP, SHIFTR, SHIFTI, V, LDV, H, LDH, RESID, Q, LDQ, 
         WORKL, WORKD )
  \Arguments
    N       Integer.  (INPUT)
            Problem size, i.e. size of matrix A.
    KEV     Integer.  (INPUT/OUTPUT)
            KEV+NP is the size of the input matrix H.
            KEV is the size of the updated matrix HNEW.  KEV is only 
            updated on ouput when fewer than NP shifts are applied in
            order to keep the conjugate pair together.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be applied.
    SHIFTR, Double precision array of length NP.  (INPUT)
    SHIFTI  Real and imaginary part of the shifts to be applied.
            Upon, entry to dnapps, the shifts must be sorted so that the 
            conjugate pairs are in consecutive locations.
    V       Double precision N by (KEV+NP) array.  (INPUT/OUTPUT)
            On INPUT, V contains the current KEV+NP Arnoldi vectors.
            On OUTPUT, V contains the updated KEV Arnoldi vectors
            in the first KEV columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    H       Double precision (KEV+NP) by (KEV+NP) array.  (INPUT/OUTPUT)
            On INPUT, H contains the current KEV+NP by KEV+NP upper 
            Hessenber matrix of the Arnoldi factorization.
            On OUTPUT, H contains the updated KEV by KEV upper Hessenberg
            matrix in the KEV leading submatrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            On INPUT, RESID contains the the residual vector r_{k+p}.
            On OUTPUT, RESID is the update residual vector rnew_{k} 
            in the first KEV locations.
    Q       Double precision KEV+NP by KEV+NP work array.  (WORKSPACE)
            Work array used to accumulate the rotations and reflections
            during the bulge chase sweep.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Double precision work array of length (KEV+NP).  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.
    WORKD   Double precision work array of length 2*N.  (WORKSPACE)
            Distributed array used in the application of the accumulated
            orthogonal matrix Q.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
  \Routines called:
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dmout   ARPACK utility routine that prints matrices.
       dvout   ARPACK utility routine that prints vectors.
       dlabad  LAPACK routine that computes machine constants.
       dlacpy  LAPACK matrix copy routine.
       dlamch  LAPACK routine that determines machine constants. 
       dlanhs  LAPACK routine that computes various norms of a matrix.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dlarf   LAPACK routine that applies Householder reflection to
               a matrix.
       dlarfg  LAPACK Householder reflection construction routine.
       dlartg  LAPACK Givens rotation construction routine.
       dlaset  LAPACK matrix initialization routine.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       daxpy   Level 1 BLAS that computes a vector triad.
       dcopy   Level 1 BLAS that copies one vector to another .
       dscal   Level 1 BLAS that scales a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: napps.F   SID: 2.4   DATE OF SID: 3/28/97   RELEASE: 2
  \Remarks
    1. In this version, each shift is applied to all the sublocks of
       the Hessenberg matrix H and not just to the submatrix that it
       comes from. Deflation as in LAPACK routine dlahqr (QR algorithm
       for upper Hessenberg matrices ) is used.
       The subdiagonals of H are enforced to be non-negative.
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param kev
   * @param np
   * @param shiftr
   * @param shifti
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param resid
   * @param q
   * @param ldq
   * @param workl
   * @param workd
   * 
   */
  abstract public void dnapps(int n, org.netlib.util.intW kev, int np, double[] shiftr, double[] shifti, double[] v, int ldv, double[] h, int ldh, double[] resid, double[] q, int ldq, double[] workl, double[] workd);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dnapps
  \Description:
    Given the Arnoldi factorization
       A*V_{k} - V_{k}*H_{k} = r_{k+p}*e_{k+p}^T,
    apply NP implicit shifts resulting in
       A*(V_{k}*Q) - (V_{k}*Q)*(Q^T* H_{k}*Q) = r_{k+p}*e_{k+p}^T * Q
    where Q is an orthogonal matrix which is the product of rotations
    and reflections resulting from the NP bulge chage sweeps.
    The updated Arnoldi factorization becomes:
       A*VNEW_{k} - VNEW_{k}*HNEW_{k} = rnew_{k}*e_{k}^T.
  \Usage:
    call dnapps
       ( N, KEV, NP, SHIFTR, SHIFTI, V, LDV, H, LDH, RESID, Q, LDQ, 
         WORKL, WORKD )
  \Arguments
    N       Integer.  (INPUT)
            Problem size, i.e. size of matrix A.
    KEV     Integer.  (INPUT/OUTPUT)
            KEV+NP is the size of the input matrix H.
            KEV is the size of the updated matrix HNEW.  KEV is only 
            updated on ouput when fewer than NP shifts are applied in
            order to keep the conjugate pair together.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be applied.
    SHIFTR, Double precision array of length NP.  (INPUT)
    SHIFTI  Real and imaginary part of the shifts to be applied.
            Upon, entry to dnapps, the shifts must be sorted so that the 
            conjugate pairs are in consecutive locations.
    V       Double precision N by (KEV+NP) array.  (INPUT/OUTPUT)
            On INPUT, V contains the current KEV+NP Arnoldi vectors.
            On OUTPUT, V contains the updated KEV Arnoldi vectors
            in the first KEV columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    H       Double precision (KEV+NP) by (KEV+NP) array.  (INPUT/OUTPUT)
            On INPUT, H contains the current KEV+NP by KEV+NP upper 
            Hessenber matrix of the Arnoldi factorization.
            On OUTPUT, H contains the updated KEV by KEV upper Hessenberg
            matrix in the KEV leading submatrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            On INPUT, RESID contains the the residual vector r_{k+p}.
            On OUTPUT, RESID is the update residual vector rnew_{k} 
            in the first KEV locations.
    Q       Double precision KEV+NP by KEV+NP work array.  (WORKSPACE)
            Work array used to accumulate the rotations and reflections
            during the bulge chase sweep.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Double precision work array of length (KEV+NP).  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.
    WORKD   Double precision work array of length 2*N.  (WORKSPACE)
            Distributed array used in the application of the accumulated
            orthogonal matrix Q.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
  \Routines called:
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dmout   ARPACK utility routine that prints matrices.
       dvout   ARPACK utility routine that prints vectors.
       dlabad  LAPACK routine that computes machine constants.
       dlacpy  LAPACK matrix copy routine.
       dlamch  LAPACK routine that determines machine constants. 
       dlanhs  LAPACK routine that computes various norms of a matrix.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dlarf   LAPACK routine that applies Householder reflection to
               a matrix.
       dlarfg  LAPACK Householder reflection construction routine.
       dlartg  LAPACK Givens rotation construction routine.
       dlaset  LAPACK matrix initialization routine.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       daxpy   Level 1 BLAS that computes a vector triad.
       dcopy   Level 1 BLAS that copies one vector to another .
       dscal   Level 1 BLAS that scales a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: napps.F   SID: 2.4   DATE OF SID: 3/28/97   RELEASE: 2
  \Remarks
    1. In this version, each shift is applied to all the sublocks of
       the Hessenberg matrix H and not just to the submatrix that it
       comes from. Deflation as in LAPACK routine dlahqr (QR algorithm
       for upper Hessenberg matrices ) is used.
       The subdiagonals of H are enforced to be non-negative.
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param kev
   * @param np
   * @param shiftr
   * @param _shiftr_offset
   * @param shifti
   * @param _shifti_offset
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param resid
   * @param _resid_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workl
   * @param _workl_offset
   * @param workd
   * @param _workd_offset
   * 
   */
  abstract public void dnapps(int n, org.netlib.util.intW kev, int np, double[] shiftr, int _shiftr_offset, double[] shifti, int _shifti_offset, double[] v, int _v_offset, int ldv, double[] h, int _h_offset, int ldh, double[] resid, int _resid_offset, double[] q, int _q_offset, int ldq, double[] workl, int _workl_offset, double[] workd, int _workd_offset);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: dnaup2
  \Description: 
    Intermediate level interface called by dnaupd.
  \Usage:
    call dnaup2
       ( IDO, BMAT, N, WHICH, NEV, NP, TOL, RESID, MODE, IUPD,
         ISHIFT, MXITER, V, LDV, H, LDH, RITZR, RITZI, BOUNDS, 
         Q, LDQ, WORKL, IPNTR, WORKD, INFO )
  \Arguments
    IDO, BMAT, N, WHICH, NEV, TOL, RESID: same as defined in dnaupd.
    MODE, ISHIFT, MXITER: see the definition of IPARAM in dnaupd.
    NP      Integer.  (INPUT/OUTPUT)
            Contains the number of implicit shifts to apply during 
            each Arnoldi iteration.  
            If ISHIFT=1, NP is adjusted dynamically at each iteration 
            to accelerate convergence and prevent stagnation.
            This is also roughly equal to the number of matrix-vector 
            products (involving the operator OP) per Arnoldi iteration.
            The logic for adjusting is contained within the current
            subroutine.
            If ISHIFT=0, NP is the number of shifts the user needs
            to provide via reverse comunication. 0 < NP < NCV-NEV.
            NP may be less than NCV-NEV for two reasons. The first, is
            to keep complex conjugate pairs of "wanted" Ritz values 
            together. The second, is that a leading block of the current
            upper Hessenberg matrix has split off and contains "unwanted"
            Ritz values.
            Upon termination of the IRA iteration, NP contains the number 
            of "converged" wanted Ritz values.
    IUPD    Integer.  (INPUT)
            IUPD .EQ. 0: use explicit restart instead implicit update.
            IUPD .NE. 0: use implicit update.
    V       Double precision N by (NEV+NP) array.  (INPUT/OUTPUT)
            The Arnoldi basis vectors are returned in the first NEV 
            columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Double precision (NEV+NP) by (NEV+NP) array.  (OUTPUT)
            H is used to store the generated upper Hessenberg matrix
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    RITZR,  Double precision arrays of length NEV+NP.  (OUTPUT)
    RITZI   RITZR(1:NEV) (resp. RITZI(1:NEV)) contains the real (resp.
            imaginary) part of the computed Ritz values of OP.
    BOUNDS  Double precision array of length NEV+NP.  (OUTPUT)
            BOUNDS(1:NEV) contain the error bounds corresponding to 
            the computed Ritz values.
            
    Q       Double precision (NEV+NP) by (NEV+NP) array.  (WORKSPACE)
            Private (replicated) work array used to accumulate the
            rotation in the shift application step.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Double precision work array of length at least 
            (NEV+NP)**2 + 3*(NEV+NP).  (INPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  It is used in shifts calculation, shifts
            application and convergence checking.
            On exit, the last 3*(NEV+NP) locations of WORKL contain
            the Ritz values (real,imaginary) and associated Ritz
            estimates of the current Hessenberg matrix.  They are
            listed in the same order as returned from dneigh.
            If ISHIFT .EQ. O and IDO .EQ. 3, the first 2*NP locations
            of WORKL are used in reverse communication to hold the user 
            supplied shifts.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (WORKSPACE)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD
            as temporary workspace during the iteration !!!!!!!!!!
            See Data Distribution Note in DNAUPD.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =     0: Normal return.
            =     1: Maximum number of iterations taken.
                     All possible eigenvalues of OP has been found.  
                     NP returns the number of converged Ritz values.
            =     2: No shifts could be applied.
            =    -8: Error return from LAPACK eigenvalue calculation;
                     This should never happen.
            =    -9: Starting vector is zero.
            = -9999: Could not build an Arnoldi factorization.
                     Size that was built in returned in NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       dgetv0  ARPACK initial vector generation routine. 
       dnaitr  ARPACK Arnoldi factorization routine.
       dnapps  ARPACK application of implicit shifts routine.
       dnconv  ARPACK convergence of Ritz values routine.
       dneigh  ARPACK compute Ritz values and error bounds routine.
       dngets  ARPACK reorder Ritz values and error bounds routine.
       dsortc  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dmout   ARPACK utility routine that prints matrices
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dcopy   Level 1 BLAS that copies one vector to another .
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
       dswap   Level 1 BLAS that swaps two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas    
   
  \SCCS Information: @(#) 
   FILE: naup2.F   SID: 2.8   DATE OF SID: 10/17/00   RELEASE: 2
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param np
   * @param tol
   * @param resid
   * @param mode
   * @param iupd
   * @param ishift
   * @param mxiter
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param ritzr
   * @param ritzi
   * @param bounds
   * @param q
   * @param ldq
   * @param workl
   * @param ipntr
   * @param workd
   * @param info
   * 
   */
  abstract public void dnaup2(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, org.netlib.util.intW np, double tol, double[] resid, int mode, int iupd, int ishift, org.netlib.util.intW mxiter, double[] v, int ldv, double[] h, int ldh, double[] ritzr, double[] ritzi, double[] bounds, double[] q, int ldq, double[] workl, int[] ipntr, double[] workd, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: dnaup2
  \Description: 
    Intermediate level interface called by dnaupd.
  \Usage:
    call dnaup2
       ( IDO, BMAT, N, WHICH, NEV, NP, TOL, RESID, MODE, IUPD,
         ISHIFT, MXITER, V, LDV, H, LDH, RITZR, RITZI, BOUNDS, 
         Q, LDQ, WORKL, IPNTR, WORKD, INFO )
  \Arguments
    IDO, BMAT, N, WHICH, NEV, TOL, RESID: same as defined in dnaupd.
    MODE, ISHIFT, MXITER: see the definition of IPARAM in dnaupd.
    NP      Integer.  (INPUT/OUTPUT)
            Contains the number of implicit shifts to apply during 
            each Arnoldi iteration.  
            If ISHIFT=1, NP is adjusted dynamically at each iteration 
            to accelerate convergence and prevent stagnation.
            This is also roughly equal to the number of matrix-vector 
            products (involving the operator OP) per Arnoldi iteration.
            The logic for adjusting is contained within the current
            subroutine.
            If ISHIFT=0, NP is the number of shifts the user needs
            to provide via reverse comunication. 0 < NP < NCV-NEV.
            NP may be less than NCV-NEV for two reasons. The first, is
            to keep complex conjugate pairs of "wanted" Ritz values 
            together. The second, is that a leading block of the current
            upper Hessenberg matrix has split off and contains "unwanted"
            Ritz values.
            Upon termination of the IRA iteration, NP contains the number 
            of "converged" wanted Ritz values.
    IUPD    Integer.  (INPUT)
            IUPD .EQ. 0: use explicit restart instead implicit update.
            IUPD .NE. 0: use implicit update.
    V       Double precision N by (NEV+NP) array.  (INPUT/OUTPUT)
            The Arnoldi basis vectors are returned in the first NEV 
            columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Double precision (NEV+NP) by (NEV+NP) array.  (OUTPUT)
            H is used to store the generated upper Hessenberg matrix
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    RITZR,  Double precision arrays of length NEV+NP.  (OUTPUT)
    RITZI   RITZR(1:NEV) (resp. RITZI(1:NEV)) contains the real (resp.
            imaginary) part of the computed Ritz values of OP.
    BOUNDS  Double precision array of length NEV+NP.  (OUTPUT)
            BOUNDS(1:NEV) contain the error bounds corresponding to 
            the computed Ritz values.
            
    Q       Double precision (NEV+NP) by (NEV+NP) array.  (WORKSPACE)
            Private (replicated) work array used to accumulate the
            rotation in the shift application step.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Double precision work array of length at least 
            (NEV+NP)**2 + 3*(NEV+NP).  (INPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  It is used in shifts calculation, shifts
            application and convergence checking.
            On exit, the last 3*(NEV+NP) locations of WORKL contain
            the Ritz values (real,imaginary) and associated Ritz
            estimates of the current Hessenberg matrix.  They are
            listed in the same order as returned from dneigh.
            If ISHIFT .EQ. O and IDO .EQ. 3, the first 2*NP locations
            of WORKL are used in reverse communication to hold the user 
            supplied shifts.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (WORKSPACE)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD
            as temporary workspace during the iteration !!!!!!!!!!
            See Data Distribution Note in DNAUPD.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =     0: Normal return.
            =     1: Maximum number of iterations taken.
                     All possible eigenvalues of OP has been found.  
                     NP returns the number of converged Ritz values.
            =     2: No shifts could be applied.
            =    -8: Error return from LAPACK eigenvalue calculation;
                     This should never happen.
            =    -9: Starting vector is zero.
            = -9999: Could not build an Arnoldi factorization.
                     Size that was built in returned in NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       dgetv0  ARPACK initial vector generation routine. 
       dnaitr  ARPACK Arnoldi factorization routine.
       dnapps  ARPACK application of implicit shifts routine.
       dnconv  ARPACK convergence of Ritz values routine.
       dneigh  ARPACK compute Ritz values and error bounds routine.
       dngets  ARPACK reorder Ritz values and error bounds routine.
       dsortc  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dmout   ARPACK utility routine that prints matrices
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dcopy   Level 1 BLAS that copies one vector to another .
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
       dswap   Level 1 BLAS that swaps two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas    
   
  \SCCS Information: @(#) 
   FILE: naup2.F   SID: 2.8   DATE OF SID: 10/17/00   RELEASE: 2
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param np
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param mode
   * @param iupd
   * @param ishift
   * @param mxiter
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ritzr
   * @param _ritzr_offset
   * @param ritzi
   * @param _ritzi_offset
   * @param bounds
   * @param _bounds_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workl
   * @param _workl_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param info
   * 
   */
  abstract public void dnaup2(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, org.netlib.util.intW np, double tol, double[] resid, int _resid_offset, int mode, int iupd, int ishift, org.netlib.util.intW mxiter, double[] v, int _v_offset, int ldv, double[] h, int _h_offset, int ldh, double[] ritzr, int _ritzr_offset, double[] ritzi, int _ritzi_offset, double[] bounds, int _bounds_offset, double[] q, int _q_offset, int ldq, double[] workl, int _workl_offset, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: dnaupd
  \Description: 
    Reverse communication interface for the Implicitly Restarted Arnoldi
    iteration. This subroutine computes approximations to a few eigenpairs 
    of a linear operator "OP" with respect to a semi-inner product defined by 
    a symmetric positive semi-definite real matrix B. B may be the identity 
    matrix. NOTE: If the linear operator "OP" is real and symmetric 
    with respect to the real positive semi-definite symmetric matrix B, 
    i.e. B*OP = (OP`)*B, then subroutine dsaupd should be used instead.
    The computed approximate eigenvalues are called Ritz values and
    the corresponding approximate eigenvectors are called Ritz vectors.
    dnaupd is usually called iteratively to solve one of the 
    following problems:
    Mode 1:  A*x = lambda*x.
             ===> OP = A  and  B = I.
    Mode 2:  A*x = lambda*M*x, M symmetric positive definite
             ===> OP = inv[M]*A  and  B = M.
             ===> (If M can be factored see remark 3 below)
    Mode 3:  A*x = lambda*M*x, M symmetric semi-definite
             ===> OP = Real_Part{ inv[A - sigma*M]*M }  and  B = M. 
             ===> shift-and-invert mode (in real arithmetic)
             If OP*x = amu*x, then 
             amu = 1/2 * [ 1/(lambda-sigma) + 1/(lambda-conjg(sigma)) ].
             Note: If sigma is real, i.e. imaginary part of sigma is zero;
                   Real_Part{ inv[A - sigma*M]*M } == inv[A - sigma*M]*M 
                   amu == 1/(lambda-sigma). 
    
    Mode 4:  A*x = lambda*M*x, M symmetric semi-definite
             ===> OP = Imaginary_Part{ inv[A - sigma*M]*M }  and  B = M. 
             ===> shift-and-invert mode (in real arithmetic)
             If OP*x = amu*x, then 
             amu = 1/2i * [ 1/(lambda-sigma) - 1/(lambda-conjg(sigma)) ].
    Both mode 3 and 4 give the same enhancement to eigenvalues close to
    the (complex) shift sigma.  However, as lambda goes to infinity,
    the operator OP in mode 4 dampens the eigenvalues more strongly than
    does OP defined in mode 3.
    NOTE: The action of w <- inv[A - sigma*M]*v or w <- inv[M]*v
          should be accomplished either by a direct method
          using a sparse matrix factorization and solving
             [A - sigma*M]*w = v  or M*w = v,
          or through an iterative method for solving these
          systems.  If an iterative method is used, the
          convergence test must be more stringent than
          the accuracy requirements for the eigenvalue
          approximations.
  \Usage:
    call dnaupd
       ( IDO, BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM,
         IPNTR, WORKD, WORKL, LWORKL, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first 
            call to dnaupd.  IDO will be set internally to
            indicate the type of operation to be performed.  Control is
            then given back to the calling routine which has the
            responsibility to carry out the requested operation and call
            dnaupd with the result.  The operand is given in
            WORKD(IPNTR(1)), the result must be put in WORKD(IPNTR(2)).
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      In mode 3 and 4, the vector B * X is already
                      available in WORKD(ipntr(3)).  It does not
                      need to be recomputed in forming OP * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO =  3: compute the IPARAM(8) real and imaginary parts 
                      of the shifts where INPTR(14) is the pointer
                      into WORKL for placing the shifts. See Remark
                      5 below.
            IDO = 99: done
            -------------------------------------------------------------
               
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.
            BMAT = 'I' -> standard eigenvalue problem A*x = lambda*x
            BMAT = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    WHICH   Character*2.  (INPUT)
            'LM' -> want the NEV eigenvalues of largest magnitude.
            'SM' -> want the NEV eigenvalues of smallest magnitude.
            'LR' -> want the NEV eigenvalues of largest real part.
            'SR' -> want the NEV eigenvalues of smallest real part.
            'LI' -> want the NEV eigenvalues of largest imaginary part.
            'SI' -> want the NEV eigenvalues of smallest imaginary part.
    NEV     Integer.  (INPUT/OUTPUT)
            Number of eigenvalues of OP to be computed. 0 < NEV < N-1.
    TOL     Double precision scalar.  (INPUT)
            Stopping criterion: the relative accuracy of the Ritz value 
            is considered acceptable if BOUNDS(I) .LE. TOL*ABS(RITZ(I))
            where ABS(RITZ(I)) is the magnitude when RITZ(I) is complex.
            DEFAULT = DLAMCH('EPS')  (machine precision as computed
                      by the LAPACK auxiliary subroutine DLAMCH).
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            On INPUT: 
            If INFO .EQ. 0, a random initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            On OUTPUT:
            RESID contains the final residual vector.
    NCV     Integer.  (INPUT)
            Number of columns of the matrix V. NCV must satisfy the two
            inequalities 2 <= NCV-NEV and NCV <= N.
            This will indicate how many Arnoldi vectors are generated 
            at each iteration.  After the startup phase in which NEV 
            Arnoldi vectors are generated, the algorithm generates 
            approximately NCV-NEV Arnoldi vectors at each subsequent update 
            iteration. Most of the cost in generating each Arnoldi vector is 
            in the matrix-vector operation OP*x. 
            NOTE: 2 <= NCV-NEV in order that complex conjugate pairs of Ritz 
            values are kept together. (See remark 4 below)
    V       Double precision array N by NCV.  (OUTPUT)
            Contains the final set of Arnoldi basis vectors. 
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling program.
    IPARAM  Integer array of length 11.  (INPUT/OUTPUT)
            IPARAM(1) = ISHIFT: method for selecting the implicit shifts.
            The shifts selected at each iteration are used to restart
            the Arnoldi iteration in an implicit fashion.
            -------------------------------------------------------------
            ISHIFT = 0: the shifts are provided by the user via
                        reverse communication.  The real and imaginary
                        parts of the NCV eigenvalues of the Hessenberg
                        matrix H are returned in the part of the WORKL 
                        array corresponding to RITZR and RITZI. See remark 
                        5 below.
            ISHIFT = 1: exact shifts with respect to the current
                        Hessenberg matrix H.  This is equivalent to 
                        restarting the iteration with a starting vector
                        that is a linear combination of approximate Schur
                        vectors associated with the "wanted" Ritz values.
            -------------------------------------------------------------
            IPARAM(2) = No longer referenced.
            IPARAM(3) = MXITER
            On INPUT:  maximum number of Arnoldi update iterations allowed. 
            On OUTPUT: actual number of Arnoldi update iterations taken. 
            IPARAM(4) = NB: blocksize to be used in the recurrence.
            The code currently works only for NB = 1.
            IPARAM(5) = NCONV: number of "converged" Ritz values.
            This represents the number of Ritz values that satisfy
            the convergence criterion.
            IPARAM(6) = IUPD
            No longer referenced. Implicit restarting is ALWAYS used.  
            IPARAM(7) = MODE
            On INPUT determines what type of eigenproblem is being solved.
            Must be 1,2,3,4; See under \Description of dnaupd for the 
            four modes available.
            IPARAM(8) = NP
            When ido = 3 and the user provides shifts through reverse
            communication (IPARAM(1)=0), dnaupd returns NP, the number
            of shifts the user is to provide. 0 < NP <=NCV-NEV. See Remark
            5 below.
            IPARAM(9) = NUMOP, IPARAM(10) = NUMOPB, IPARAM(11) = NUMREO,
            OUTPUT: NUMOP  = total number of OP*x operations,
                    NUMOPB = total number of B*x operations if BMAT='G',
                    NUMREO = total number of steps of re-orthogonalization.        
    IPNTR   Integer array of length 14.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD and WORKL
            arrays for matrices/vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X in WORKD.
            IPNTR(2): pointer to the current result vector Y in WORKD.
            IPNTR(3): pointer to the vector B * X in WORKD when used in 
                      the shift-and-invert mode.
            IPNTR(4): pointer to the next available location in WORKL
                      that is untouched by the program.
            IPNTR(5): pointer to the NCV by NCV upper Hessenberg matrix
                      H in WORKL.
            IPNTR(6): pointer to the real part of the ritz value array 
                      RITZR in WORKL.
            IPNTR(7): pointer to the imaginary part of the ritz value array
                      RITZI in WORKL.
            IPNTR(8): pointer to the Ritz estimates in array WORKL associated
                      with the Ritz values located in RITZR and RITZI in WORKL.
            IPNTR(14): pointer to the NP shifts in WORKL. See Remark 5 below.
            Note: IPNTR(9:13) is only referenced by dneupd. See Remark 2 below.
            IPNTR(9):  pointer to the real part of the NCV RITZ values of the 
                       original system.
            IPNTR(10): pointer to the imaginary part of the NCV RITZ values of 
                       the original system.
            IPNTR(11): pointer to the NCV corresponding error bounds.
            IPNTR(12): pointer to the NCV by NCV upper quasi-triangular
                       Schur matrix for H.
            IPNTR(13): pointer to the NCV by NCV matrix of eigenvectors
                       of the upper Hessenberg matrix H. Only referenced by
                       dneupd if RVEC = .TRUE. See Remark 2 below.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD 
            as temporary workspace during the iteration. Upon termination
            WORKD(1:N) contains B*RESID(1:N). If an invariant subspace
            associated with the converged Ritz values is desired, see remark
            2 below, subroutine dneupd uses this output.
            See Data Distribution Note below.  
    WORKL   Double precision work array of length LWORKL.  (OUTPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  See Data Distribution Note below.
    LWORKL  Integer.  (INPUT)
            LWORKL must be at least 3*NCV**2 + 6*NCV.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =  0: Normal exit.
            =  1: Maximum number of iterations taken.
                  All possible eigenvalues of OP has been found. IPARAM(5)  
                  returns the number of wanted converged Ritz values.
            =  2: No longer an informational error. Deprecated starting
                  with release 2 of ARPACK.
            =  3: No shifts could be applied during a cycle of the 
                  Implicitly restarted Arnoldi iteration. One possibility 
                  is to increase the size of NCV relative to NEV. 
                  See remark 4 below.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV-NEV >= 2 and less than or equal to N.
            = -4: The maximum number of Arnoldi update iteration 
                  must be greater than zero.
            = -5: WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work array is not sufficient.
            = -8: Error return from LAPACK eigenvalue calculation;
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatable.
            = -12: IPARAM(1) must be equal to 0 or 1.
            = -9999: Could not build an Arnoldi factorization.
                     IPARAM(5) returns the size of the current Arnoldi
                     factorization.
  \Remarks
    1. The computed Ritz values are approximate eigenvalues of OP. The
       selection of WHICH should be made with this in mind when
       Mode = 3 and 4.  After convergence, approximate eigenvalues of the
       original problem may be obtained with the ARPACK subroutine dneupd.
    2. If a basis for the invariant subspace corresponding to the converged Ritz 
       values is needed, the user must call dneupd immediately following 
       completion of dnaupd. This is new starting with release 2 of ARPACK.
    3. If M can be factored into a Cholesky factorization M = LL`
       then Mode = 2 should not be selected.  Instead one should use
       Mode = 1 with  OP = inv(L)*A*inv(L`).  Appropriate triangular 
       linear systems should be solved with L and L` rather
       than computing inverses.  After convergence, an approximate
       eigenvector z of the original problem is recovered by solving
       L`z = x  where x is a Ritz vector of OP.
    4. At present there is no a-priori analysis to guide the selection
       of NCV relative to NEV.  The only formal requrement is that NCV > NEV + 2.
       However, it is recommended that NCV .ge. 2*NEV+1.  If many problems of
       the same type are to be solved, one should experiment with increasing
       NCV while keeping NEV fixed for a given test problem.  This will 
       usually decrease the required number of OP*x operations but it
       also increases the work and storage required to maintain the orthogonal
       basis vectors.  The optimal "cross-over" with respect to CPU time
       is problem dependent and must be determined empirically. 
       See Chapter 8 of Reference 2 for further information.
    5. When IPARAM(1) = 0, and IDO = 3, the user needs to provide the 
       NP = IPARAM(8) real and imaginary parts of the shifts in locations 
           real part                  imaginary part
           -----------------------    --------------
       1   WORKL(IPNTR(14))           WORKL(IPNTR(14)+NP)
       2   WORKL(IPNTR(14)+1)         WORKL(IPNTR(14)+NP+1)
                          .                          .
                          .                          .
                          .                          .
       NP  WORKL(IPNTR(14)+NP-1)      WORKL(IPNTR(14)+2*NP-1).
       Only complex conjugate pairs of shifts may be applied and the pairs 
       must be placed in consecutive locations. The real part of the 
       eigenvalues of the current upper Hessenberg matrix are located in 
       WORKL(IPNTR(6)) through WORKL(IPNTR(6)+NCV-1) and the imaginary part 
       in WORKL(IPNTR(7)) through WORKL(IPNTR(7)+NCV-1). They are ordered
       according to the order defined by WHICH. The complex conjugate
       pairs are kept together and the associated Ritz estimates are located in
       WORKL(IPNTR(8)), WORKL(IPNTR(8)+1), ... , WORKL(IPNTR(8)+NCV-1).
  -----------------------------------------------------------------------
  \Data Distribution Note: 
    Fortran-D syntax:
    ================
    Double precision resid(n), v(ldv,ncv), workd(3*n), workl(lworkl)
    decompose  d1(n), d2(n,ncv)
    align      resid(i) with d1(i)
    align      v(i,j)   with d2(i,j)
    align      workd(i) with d1(i)     range (1:n)
    align      workd(i) with d1(i-n)   range (n+1:2*n)
    align      workd(i) with d1(i-2*n) range (2*n+1:3*n)
    distribute d1(block), d2(block,:)
    replicated workl(lworkl)
    Cray MPP syntax:
    ===============
    Double precision  resid(n), v(ldv,ncv), workd(n,3), workl(lworkl)
    shared     resid(block), v(block,:), workd(block,:)
    replicated workl(lworkl)
    
    CM2/CM5 syntax:
    ==============
    
  -----------------------------------------------------------------------
       include   'ex-nonsym.doc'
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett & Y. Saad, "Complex Shift and Invert Strategies for
       Real Matrices", Linear Algebra and its Applications, vol 88/89,
       pp 575-595, (1987).
  \Routines called:
       dnaup2  ARPACK routine that implements the Implicitly Restarted
               Arnoldi Iteration.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/16/93: Version '1.1'
  \SCCS Information: @(#) 
   FILE: naupd.F   SID: 2.10   DATE OF SID: 08/23/02   RELEASE: 2
  \Remarks
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param ncv
   * @param v
   * @param ldv
   * @param iparam
   * @param ipntr
   * @param workd
   * @param workl
   * @param lworkl
   * @param info
   * 
   */
  abstract public void dnaupd(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, int nev, org.netlib.util.doubleW tol, double[] resid, int ncv, double[] v, int ldv, int[] iparam, int[] ipntr, double[] workd, double[] workl, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: dnaupd
  \Description: 
    Reverse communication interface for the Implicitly Restarted Arnoldi
    iteration. This subroutine computes approximations to a few eigenpairs 
    of a linear operator "OP" with respect to a semi-inner product defined by 
    a symmetric positive semi-definite real matrix B. B may be the identity 
    matrix. NOTE: If the linear operator "OP" is real and symmetric 
    with respect to the real positive semi-definite symmetric matrix B, 
    i.e. B*OP = (OP`)*B, then subroutine dsaupd should be used instead.
    The computed approximate eigenvalues are called Ritz values and
    the corresponding approximate eigenvectors are called Ritz vectors.
    dnaupd is usually called iteratively to solve one of the 
    following problems:
    Mode 1:  A*x = lambda*x.
             ===> OP = A  and  B = I.
    Mode 2:  A*x = lambda*M*x, M symmetric positive definite
             ===> OP = inv[M]*A  and  B = M.
             ===> (If M can be factored see remark 3 below)
    Mode 3:  A*x = lambda*M*x, M symmetric semi-definite
             ===> OP = Real_Part{ inv[A - sigma*M]*M }  and  B = M. 
             ===> shift-and-invert mode (in real arithmetic)
             If OP*x = amu*x, then 
             amu = 1/2 * [ 1/(lambda-sigma) + 1/(lambda-conjg(sigma)) ].
             Note: If sigma is real, i.e. imaginary part of sigma is zero;
                   Real_Part{ inv[A - sigma*M]*M } == inv[A - sigma*M]*M 
                   amu == 1/(lambda-sigma). 
    
    Mode 4:  A*x = lambda*M*x, M symmetric semi-definite
             ===> OP = Imaginary_Part{ inv[A - sigma*M]*M }  and  B = M. 
             ===> shift-and-invert mode (in real arithmetic)
             If OP*x = amu*x, then 
             amu = 1/2i * [ 1/(lambda-sigma) - 1/(lambda-conjg(sigma)) ].
    Both mode 3 and 4 give the same enhancement to eigenvalues close to
    the (complex) shift sigma.  However, as lambda goes to infinity,
    the operator OP in mode 4 dampens the eigenvalues more strongly than
    does OP defined in mode 3.
    NOTE: The action of w <- inv[A - sigma*M]*v or w <- inv[M]*v
          should be accomplished either by a direct method
          using a sparse matrix factorization and solving
             [A - sigma*M]*w = v  or M*w = v,
          or through an iterative method for solving these
          systems.  If an iterative method is used, the
          convergence test must be more stringent than
          the accuracy requirements for the eigenvalue
          approximations.
  \Usage:
    call dnaupd
       ( IDO, BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM,
         IPNTR, WORKD, WORKL, LWORKL, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first 
            call to dnaupd.  IDO will be set internally to
            indicate the type of operation to be performed.  Control is
            then given back to the calling routine which has the
            responsibility to carry out the requested operation and call
            dnaupd with the result.  The operand is given in
            WORKD(IPNTR(1)), the result must be put in WORKD(IPNTR(2)).
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      In mode 3 and 4, the vector B * X is already
                      available in WORKD(ipntr(3)).  It does not
                      need to be recomputed in forming OP * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO =  3: compute the IPARAM(8) real and imaginary parts 
                      of the shifts where INPTR(14) is the pointer
                      into WORKL for placing the shifts. See Remark
                      5 below.
            IDO = 99: done
            -------------------------------------------------------------
               
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.
            BMAT = 'I' -> standard eigenvalue problem A*x = lambda*x
            BMAT = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    WHICH   Character*2.  (INPUT)
            'LM' -> want the NEV eigenvalues of largest magnitude.
            'SM' -> want the NEV eigenvalues of smallest magnitude.
            'LR' -> want the NEV eigenvalues of largest real part.
            'SR' -> want the NEV eigenvalues of smallest real part.
            'LI' -> want the NEV eigenvalues of largest imaginary part.
            'SI' -> want the NEV eigenvalues of smallest imaginary part.
    NEV     Integer.  (INPUT/OUTPUT)
            Number of eigenvalues of OP to be computed. 0 < NEV < N-1.
    TOL     Double precision scalar.  (INPUT)
            Stopping criterion: the relative accuracy of the Ritz value 
            is considered acceptable if BOUNDS(I) .LE. TOL*ABS(RITZ(I))
            where ABS(RITZ(I)) is the magnitude when RITZ(I) is complex.
            DEFAULT = DLAMCH('EPS')  (machine precision as computed
                      by the LAPACK auxiliary subroutine DLAMCH).
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            On INPUT: 
            If INFO .EQ. 0, a random initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            On OUTPUT:
            RESID contains the final residual vector.
    NCV     Integer.  (INPUT)
            Number of columns of the matrix V. NCV must satisfy the two
            inequalities 2 <= NCV-NEV and NCV <= N.
            This will indicate how many Arnoldi vectors are generated 
            at each iteration.  After the startup phase in which NEV 
            Arnoldi vectors are generated, the algorithm generates 
            approximately NCV-NEV Arnoldi vectors at each subsequent update 
            iteration. Most of the cost in generating each Arnoldi vector is 
            in the matrix-vector operation OP*x. 
            NOTE: 2 <= NCV-NEV in order that complex conjugate pairs of Ritz 
            values are kept together. (See remark 4 below)
    V       Double precision array N by NCV.  (OUTPUT)
            Contains the final set of Arnoldi basis vectors. 
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling program.
    IPARAM  Integer array of length 11.  (INPUT/OUTPUT)
            IPARAM(1) = ISHIFT: method for selecting the implicit shifts.
            The shifts selected at each iteration are used to restart
            the Arnoldi iteration in an implicit fashion.
            -------------------------------------------------------------
            ISHIFT = 0: the shifts are provided by the user via
                        reverse communication.  The real and imaginary
                        parts of the NCV eigenvalues of the Hessenberg
                        matrix H are returned in the part of the WORKL 
                        array corresponding to RITZR and RITZI. See remark 
                        5 below.
            ISHIFT = 1: exact shifts with respect to the current
                        Hessenberg matrix H.  This is equivalent to 
                        restarting the iteration with a starting vector
                        that is a linear combination of approximate Schur
                        vectors associated with the "wanted" Ritz values.
            -------------------------------------------------------------
            IPARAM(2) = No longer referenced.
            IPARAM(3) = MXITER
            On INPUT:  maximum number of Arnoldi update iterations allowed. 
            On OUTPUT: actual number of Arnoldi update iterations taken. 
            IPARAM(4) = NB: blocksize to be used in the recurrence.
            The code currently works only for NB = 1.
            IPARAM(5) = NCONV: number of "converged" Ritz values.
            This represents the number of Ritz values that satisfy
            the convergence criterion.
            IPARAM(6) = IUPD
            No longer referenced. Implicit restarting is ALWAYS used.  
            IPARAM(7) = MODE
            On INPUT determines what type of eigenproblem is being solved.
            Must be 1,2,3,4; See under \Description of dnaupd for the 
            four modes available.
            IPARAM(8) = NP
            When ido = 3 and the user provides shifts through reverse
            communication (IPARAM(1)=0), dnaupd returns NP, the number
            of shifts the user is to provide. 0 < NP <=NCV-NEV. See Remark
            5 below.
            IPARAM(9) = NUMOP, IPARAM(10) = NUMOPB, IPARAM(11) = NUMREO,
            OUTPUT: NUMOP  = total number of OP*x operations,
                    NUMOPB = total number of B*x operations if BMAT='G',
                    NUMREO = total number of steps of re-orthogonalization.        
    IPNTR   Integer array of length 14.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD and WORKL
            arrays for matrices/vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X in WORKD.
            IPNTR(2): pointer to the current result vector Y in WORKD.
            IPNTR(3): pointer to the vector B * X in WORKD when used in 
                      the shift-and-invert mode.
            IPNTR(4): pointer to the next available location in WORKL
                      that is untouched by the program.
            IPNTR(5): pointer to the NCV by NCV upper Hessenberg matrix
                      H in WORKL.
            IPNTR(6): pointer to the real part of the ritz value array 
                      RITZR in WORKL.
            IPNTR(7): pointer to the imaginary part of the ritz value array
                      RITZI in WORKL.
            IPNTR(8): pointer to the Ritz estimates in array WORKL associated
                      with the Ritz values located in RITZR and RITZI in WORKL.
            IPNTR(14): pointer to the NP shifts in WORKL. See Remark 5 below.
            Note: IPNTR(9:13) is only referenced by dneupd. See Remark 2 below.
            IPNTR(9):  pointer to the real part of the NCV RITZ values of the 
                       original system.
            IPNTR(10): pointer to the imaginary part of the NCV RITZ values of 
                       the original system.
            IPNTR(11): pointer to the NCV corresponding error bounds.
            IPNTR(12): pointer to the NCV by NCV upper quasi-triangular
                       Schur matrix for H.
            IPNTR(13): pointer to the NCV by NCV matrix of eigenvectors
                       of the upper Hessenberg matrix H. Only referenced by
                       dneupd if RVEC = .TRUE. See Remark 2 below.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD 
            as temporary workspace during the iteration. Upon termination
            WORKD(1:N) contains B*RESID(1:N). If an invariant subspace
            associated with the converged Ritz values is desired, see remark
            2 below, subroutine dneupd uses this output.
            See Data Distribution Note below.  
    WORKL   Double precision work array of length LWORKL.  (OUTPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  See Data Distribution Note below.
    LWORKL  Integer.  (INPUT)
            LWORKL must be at least 3*NCV**2 + 6*NCV.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =  0: Normal exit.
            =  1: Maximum number of iterations taken.
                  All possible eigenvalues of OP has been found. IPARAM(5)  
                  returns the number of wanted converged Ritz values.
            =  2: No longer an informational error. Deprecated starting
                  with release 2 of ARPACK.
            =  3: No shifts could be applied during a cycle of the 
                  Implicitly restarted Arnoldi iteration. One possibility 
                  is to increase the size of NCV relative to NEV. 
                  See remark 4 below.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV-NEV >= 2 and less than or equal to N.
            = -4: The maximum number of Arnoldi update iteration 
                  must be greater than zero.
            = -5: WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work array is not sufficient.
            = -8: Error return from LAPACK eigenvalue calculation;
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatable.
            = -12: IPARAM(1) must be equal to 0 or 1.
            = -9999: Could not build an Arnoldi factorization.
                     IPARAM(5) returns the size of the current Arnoldi
                     factorization.
  \Remarks
    1. The computed Ritz values are approximate eigenvalues of OP. The
       selection of WHICH should be made with this in mind when
       Mode = 3 and 4.  After convergence, approximate eigenvalues of the
       original problem may be obtained with the ARPACK subroutine dneupd.
    2. If a basis for the invariant subspace corresponding to the converged Ritz 
       values is needed, the user must call dneupd immediately following 
       completion of dnaupd. This is new starting with release 2 of ARPACK.
    3. If M can be factored into a Cholesky factorization M = LL`
       then Mode = 2 should not be selected.  Instead one should use
       Mode = 1 with  OP = inv(L)*A*inv(L`).  Appropriate triangular 
       linear systems should be solved with L and L` rather
       than computing inverses.  After convergence, an approximate
       eigenvector z of the original problem is recovered by solving
       L`z = x  where x is a Ritz vector of OP.
    4. At present there is no a-priori analysis to guide the selection
       of NCV relative to NEV.  The only formal requrement is that NCV > NEV + 2.
       However, it is recommended that NCV .ge. 2*NEV+1.  If many problems of
       the same type are to be solved, one should experiment with increasing
       NCV while keeping NEV fixed for a given test problem.  This will 
       usually decrease the required number of OP*x operations but it
       also increases the work and storage required to maintain the orthogonal
       basis vectors.  The optimal "cross-over" with respect to CPU time
       is problem dependent and must be determined empirically. 
       See Chapter 8 of Reference 2 for further information.
    5. When IPARAM(1) = 0, and IDO = 3, the user needs to provide the 
       NP = IPARAM(8) real and imaginary parts of the shifts in locations 
           real part                  imaginary part
           -----------------------    --------------
       1   WORKL(IPNTR(14))           WORKL(IPNTR(14)+NP)
       2   WORKL(IPNTR(14)+1)         WORKL(IPNTR(14)+NP+1)
                          .                          .
                          .                          .
                          .                          .
       NP  WORKL(IPNTR(14)+NP-1)      WORKL(IPNTR(14)+2*NP-1).
       Only complex conjugate pairs of shifts may be applied and the pairs 
       must be placed in consecutive locations. The real part of the 
       eigenvalues of the current upper Hessenberg matrix are located in 
       WORKL(IPNTR(6)) through WORKL(IPNTR(6)+NCV-1) and the imaginary part 
       in WORKL(IPNTR(7)) through WORKL(IPNTR(7)+NCV-1). They are ordered
       according to the order defined by WHICH. The complex conjugate
       pairs are kept together and the associated Ritz estimates are located in
       WORKL(IPNTR(8)), WORKL(IPNTR(8)+1), ... , WORKL(IPNTR(8)+NCV-1).
  -----------------------------------------------------------------------
  \Data Distribution Note: 
    Fortran-D syntax:
    ================
    Double precision resid(n), v(ldv,ncv), workd(3*n), workl(lworkl)
    decompose  d1(n), d2(n,ncv)
    align      resid(i) with d1(i)
    align      v(i,j)   with d2(i,j)
    align      workd(i) with d1(i)     range (1:n)
    align      workd(i) with d1(i-n)   range (n+1:2*n)
    align      workd(i) with d1(i-2*n) range (2*n+1:3*n)
    distribute d1(block), d2(block,:)
    replicated workl(lworkl)
    Cray MPP syntax:
    ===============
    Double precision  resid(n), v(ldv,ncv), workd(n,3), workl(lworkl)
    shared     resid(block), v(block,:), workd(block,:)
    replicated workl(lworkl)
    
    CM2/CM5 syntax:
    ==============
    
  -----------------------------------------------------------------------
       include   'ex-nonsym.doc'
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett & Y. Saad, "Complex Shift and Invert Strategies for
       Real Matrices", Linear Algebra and its Applications, vol 88/89,
       pp 575-595, (1987).
  \Routines called:
       dnaup2  ARPACK routine that implements the Implicitly Restarted
               Arnoldi Iteration.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/16/93: Version '1.1'
  \SCCS Information: @(#) 
   FILE: naupd.F   SID: 2.10   DATE OF SID: 08/23/02   RELEASE: 2
  \Remarks
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param ncv
   * @param v
   * @param _v_offset
   * @param ldv
   * @param iparam
   * @param _iparam_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param workl
   * @param _workl_offset
   * @param lworkl
   * @param info
   * 
   */
  abstract public void dnaupd(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, int nev, org.netlib.util.doubleW tol, double[] resid, int _resid_offset, int ncv, double[] v, int _v_offset, int ldv, int[] iparam, int _iparam_offset, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, double[] workl, int _workl_offset, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dnconv
  \Description: 
    Convergence testing for the nonsymmetric Arnoldi eigenvalue routine.
  \Usage:
    call dnconv
       ( N, RITZR, RITZI, BOUNDS, TOL, NCONV )
  \Arguments
    N       Integer.  (INPUT)
            Number of Ritz values to check for convergence.
    RITZR,  Double precision arrays of length N.  (INPUT)
    RITZI   Real and imaginary parts of the Ritz values to be checked
            for convergence.
    BOUNDS  Double precision array of length N.  (INPUT)
            Ritz estimates for the Ritz values in RITZR and RITZI.
    TOL     Double precision scalar.  (INPUT)
            Desired backward error for a Ritz value to be considered
            "converged".
    NCONV   Integer scalar.  (OUTPUT)
            Number of "converged" Ritz values.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       second  ARPACK utility routine for timing.
       dlamch  LAPACK routine that determines machine constants.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas
       Applied Mathematics 
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: nconv.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       1. xxxx
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param ritzr
   * @param ritzi
   * @param bounds
   * @param tol
   * @param nconv
   * 
   */
  abstract public void dnconv(int n, double[] ritzr, double[] ritzi, double[] bounds, double tol, org.netlib.util.intW nconv);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dnconv
  \Description: 
    Convergence testing for the nonsymmetric Arnoldi eigenvalue routine.
  \Usage:
    call dnconv
       ( N, RITZR, RITZI, BOUNDS, TOL, NCONV )
  \Arguments
    N       Integer.  (INPUT)
            Number of Ritz values to check for convergence.
    RITZR,  Double precision arrays of length N.  (INPUT)
    RITZI   Real and imaginary parts of the Ritz values to be checked
            for convergence.
    BOUNDS  Double precision array of length N.  (INPUT)
            Ritz estimates for the Ritz values in RITZR and RITZI.
    TOL     Double precision scalar.  (INPUT)
            Desired backward error for a Ritz value to be considered
            "converged".
    NCONV   Integer scalar.  (OUTPUT)
            Number of "converged" Ritz values.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       second  ARPACK utility routine for timing.
       dlamch  LAPACK routine that determines machine constants.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas
       Applied Mathematics 
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: nconv.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       1. xxxx
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param ritzr
   * @param _ritzr_offset
   * @param ritzi
   * @param _ritzi_offset
   * @param bounds
   * @param _bounds_offset
   * @param tol
   * @param nconv
   * 
   */
  abstract public void dnconv(int n, double[] ritzr, int _ritzr_offset, double[] ritzi, int _ritzi_offset, double[] bounds, int _bounds_offset, double tol, org.netlib.util.intW nconv);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dneigh
  \Description:
    Compute the eigenvalues of the current upper Hessenberg matrix
    and the corresponding Ritz estimates given the current residual norm.
  \Usage:
    call dneigh
       ( RNORM, N, H, LDH, RITZR, RITZI, BOUNDS, Q, LDQ, WORKL, IERR )
  \Arguments
    RNORM   Double precision scalar.  (INPUT)
            Residual norm corresponding to the current upper Hessenberg 
            matrix H.
    N       Integer.  (INPUT)
            Size of the matrix H.
    H       Double precision N by N array.  (INPUT)
            H contains the current upper Hessenberg matrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RITZR,  Double precision arrays of length N.  (OUTPUT)
    RITZI   On output, RITZR(1:N) (resp. RITZI(1:N)) contains the real 
            (respectively imaginary) parts of the eigenvalues of H.
    BOUNDS  Double precision array of length N.  (OUTPUT)
            On output, BOUNDS contains the Ritz estimates associated with
            the eigenvalues RITZR and RITZI.  This is equal to RNORM 
            times the last components of the eigenvectors corresponding 
            to the eigenvalues in RITZR and RITZI.
    Q       Double precision N by N array.  (WORKSPACE)
            Workspace needed to store the eigenvectors of H.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Double precision work array of length N**2 + 3*N.  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  This is needed to keep the full Schur form
            of H and also in the calculation of the eigenvectors of H.
    IERR    Integer.  (OUTPUT)
            Error exit flag from dlaqrb or dtrevc.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dlaqrb  ARPACK routine to compute the real Schur form of an
               upper Hessenberg matrix and last row of the Schur vectors.
       second  ARPACK utility routine for timing.
       dmout   ARPACK utility routine that prints matrices
       dvout   ARPACK utility routine that prints vectors.
       dlacpy  LAPACK matrix copy routine.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dtrevc  LAPACK routine to compute the eigenvectors of a matrix
               in upper quasi-triangular form
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       dcopy   Level 1 BLAS that copies one vector to another .
       dnrm2   Level 1 BLAS that computes the norm of a vector.
       dscal   Level 1 BLAS that scales a vector.
       
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: neigh.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rnorm
   * @param n
   * @param h
   * @param ldh
   * @param ritzr
   * @param ritzi
   * @param bounds
   * @param q
   * @param ldq
   * @param workl
   * @param ierr
   * 
   */
  abstract public void dneigh(double rnorm, org.netlib.util.intW n, double[] h, int ldh, double[] ritzr, double[] ritzi, double[] bounds, double[] q, int ldq, double[] workl, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dneigh
  \Description:
    Compute the eigenvalues of the current upper Hessenberg matrix
    and the corresponding Ritz estimates given the current residual norm.
  \Usage:
    call dneigh
       ( RNORM, N, H, LDH, RITZR, RITZI, BOUNDS, Q, LDQ, WORKL, IERR )
  \Arguments
    RNORM   Double precision scalar.  (INPUT)
            Residual norm corresponding to the current upper Hessenberg 
            matrix H.
    N       Integer.  (INPUT)
            Size of the matrix H.
    H       Double precision N by N array.  (INPUT)
            H contains the current upper Hessenberg matrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RITZR,  Double precision arrays of length N.  (OUTPUT)
    RITZI   On output, RITZR(1:N) (resp. RITZI(1:N)) contains the real 
            (respectively imaginary) parts of the eigenvalues of H.
    BOUNDS  Double precision array of length N.  (OUTPUT)
            On output, BOUNDS contains the Ritz estimates associated with
            the eigenvalues RITZR and RITZI.  This is equal to RNORM 
            times the last components of the eigenvectors corresponding 
            to the eigenvalues in RITZR and RITZI.
    Q       Double precision N by N array.  (WORKSPACE)
            Workspace needed to store the eigenvectors of H.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Double precision work array of length N**2 + 3*N.  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  This is needed to keep the full Schur form
            of H and also in the calculation of the eigenvectors of H.
    IERR    Integer.  (OUTPUT)
            Error exit flag from dlaqrb or dtrevc.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dlaqrb  ARPACK routine to compute the real Schur form of an
               upper Hessenberg matrix and last row of the Schur vectors.
       second  ARPACK utility routine for timing.
       dmout   ARPACK utility routine that prints matrices
       dvout   ARPACK utility routine that prints vectors.
       dlacpy  LAPACK matrix copy routine.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dtrevc  LAPACK routine to compute the eigenvectors of a matrix
               in upper quasi-triangular form
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       dcopy   Level 1 BLAS that copies one vector to another .
       dnrm2   Level 1 BLAS that computes the norm of a vector.
       dscal   Level 1 BLAS that scales a vector.
       
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: neigh.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rnorm
   * @param n
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ritzr
   * @param _ritzr_offset
   * @param ritzi
   * @param _ritzi_offset
   * @param bounds
   * @param _bounds_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workl
   * @param _workl_offset
   * @param ierr
   * 
   */
  abstract public void dneigh(double rnorm, org.netlib.util.intW n, double[] h, int _h_offset, int ldh, double[] ritzr, int _ritzr_offset, double[] ritzi, int _ritzi_offset, double[] bounds, int _bounds_offset, double[] q, int _q_offset, int ldq, double[] workl, int _workl_offset, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: dneupd 
  \Description: 
    This subroutine returns the converged approximations to eigenvalues
    of A*z = lambda*B*z and (optionally):
        (1) The corresponding approximate eigenvectors;
        (2) An orthonormal basis for the associated approximate
            invariant subspace;
        (3) Both.
    There is negligible additional cost to obtain eigenvectors.  An orthonormal
    basis is always computed.  There is an additional storage cost of n*nev
    if both are requested (in this case a separate array Z must be supplied).
    The approximate eigenvalues and eigenvectors of  A*z = lambda*B*z
    are derived from approximate eigenvalues and eigenvectors of
    of the linear operator OP prescribed by the MODE selection in the
    call to DNAUPD .  DNAUPD  must be called before this routine is called.
    These approximate eigenvalues and vectors are commonly called Ritz
    values and Ritz vectors respectively.  They are referred to as such
    in the comments that follow.  The computed orthonormal basis for the
    invariant subspace corresponding to these Ritz values is referred to as a
    Schur basis.
    See documentation in the header of the subroutine DNAUPD  for 
    definition of OP as well as other terms and the relation of computed
    Ritz values and Ritz vectors of OP with respect to the given problem
    A*z = lambda*B*z.  For a brief description, see definitions of 
    IPARAM(7), MODE and WHICH in the documentation of DNAUPD .
  \Usage:
    call dneupd  
       ( RVEC, HOWMNY, SELECT, DR, DI, Z, LDZ, SIGMAR, SIGMAI, WORKEV, BMAT, 
         N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR, WORKD, WORKL, 
         LWORKL, INFO )
  \Arguments:
    RVEC    LOGICAL  (INPUT) 
            Specifies whether a basis for the invariant subspace corresponding 
            to the converged Ritz value approximations for the eigenproblem 
            A*z = lambda*B*z is computed.
               RVEC = .FALSE.     Compute Ritz values only.
               RVEC = .TRUE.      Compute the Ritz vectors or Schur vectors.
                                  See Remarks below. 
   
    HOWMNY  Character*1  (INPUT) 
            Specifies the form of the basis for the invariant subspace 
            corresponding to the converged Ritz values that is to be computed.
            = 'A': Compute NEV Ritz vectors; 
            = 'P': Compute NEV Schur vectors;
            = 'S': compute some of the Ritz vectors, specified
                   by the logical array SELECT.
    SELECT  Logical array of dimension NCV.  (INPUT)
            If HOWMNY = 'S', SELECT specifies the Ritz vectors to be
            computed. To select the Ritz vector corresponding to a
            Ritz value (DR(j), DI(j)), SELECT(j) must be set to .TRUE.. 
            If HOWMNY = 'A' or 'P', SELECT is used as internal workspace.
    DR      Double precision  array of dimension NEV+1.  (OUTPUT)
            If IPARAM(7) = 1,2 or 3 and SIGMAI=0.0  then on exit: DR contains 
            the real part of the Ritz  approximations to the eigenvalues of 
            A*z = lambda*B*z. 
            If IPARAM(7) = 3, 4 and SIGMAI is not equal to zero, then on exit:
            DR contains the real part of the Ritz values of OP computed by 
            DNAUPD . A further computation must be performed by the user
            to transform the Ritz values computed for OP by DNAUPD  to those
            of the original system A*z = lambda*B*z. See remark 3 below.
    DI      Double precision  array of dimension NEV+1.  (OUTPUT)
            On exit, DI contains the imaginary part of the Ritz value 
            approximations to the eigenvalues of A*z = lambda*B*z associated
            with DR.
            NOTE: When Ritz values are complex, they will come in complex 
                  conjugate pairs.  If eigenvectors are requested, the 
                  corresponding Ritz vectors will also come in conjugate 
                  pairs and the real and imaginary parts of these are 
                  represented in two consecutive columns of the array Z 
                  (see below).
    Z       Double precision  N by NEV+1 array if RVEC = .TRUE. and HOWMNY = 'A'. (OUTPUT)
            On exit, if RVEC = .TRUE. and HOWMNY = 'A', then the columns of 
            Z represent approximate eigenvectors (Ritz vectors) corresponding 
            to the NCONV=IPARAM(5) Ritz values for eigensystem 
            A*z = lambda*B*z. 
   
            The complex Ritz vector associated with the Ritz value 
            with positive imaginary part is stored in two consecutive 
            columns.  The first column holds the real part of the Ritz 
            vector and the second column holds the imaginary part.  The 
            Ritz vector associated with the Ritz value with negative 
            imaginary part is simply the complex conjugate of the Ritz vector 
            associated with the positive imaginary part.
            If  RVEC = .FALSE. or HOWMNY = 'P', then Z is not referenced.
            NOTE: If if RVEC = .TRUE. and a Schur basis is not required,
            the array Z may be set equal to first NEV+1 columns of the Arnoldi
            basis array V computed by DNAUPD .  In this case the Arnoldi basis
            will be destroyed and overwritten with the eigenvector basis.
    LDZ     Integer.  (INPUT)
            The leading dimension of the array Z.  If Ritz vectors are
            desired, then  LDZ >= max( 1, N ).  In any case,  LDZ >= 1.
    SIGMAR  Double precision   (INPUT)
            If IPARAM(7) = 3 or 4, represents the real part of the shift. 
            Not referenced if IPARAM(7) = 1 or 2.
    SIGMAI  Double precision   (INPUT)
            If IPARAM(7) = 3 or 4, represents the imaginary part of the shift. 
            Not referenced if IPARAM(7) = 1 or 2. See remark 3 below.
    WORKEV  Double precision  work array of dimension 3*NCV.  (WORKSPACE)
    **** The remaining arguments MUST be the same as for the   ****
    **** call to DNAUPD  that was just completed.               ****
    NOTE: The remaining arguments
             BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR,
             WORKD, WORKL, LWORKL, INFO
           must be passed directly to DNEUPD  following the last call
           to DNAUPD .  These arguments MUST NOT BE MODIFIED between
           the the last call to DNAUPD  and the call to DNEUPD .
    Three of these parameters (V, WORKL, INFO) are also output parameters:
    V       Double precision  N by NCV array.  (INPUT/OUTPUT)
            Upon INPUT: the NCV columns of V contain the Arnoldi basis
                        vectors for OP as constructed by DNAUPD  .
            Upon OUTPUT: If RVEC = .TRUE. the first NCONV=IPARAM(5) columns
                         contain approximate Schur vectors that span the
                         desired invariant subspace.  See Remark 2 below.
            NOTE: If the array Z has been set equal to first NEV+1 columns
            of the array V and RVEC=.TRUE. and HOWMNY= 'A', then the
            Arnoldi basis held by V has been overwritten by the desired
            Ritz vectors.  If a separate array Z has been passed then
            the first NCONV=IPARAM(5) columns of V will contain approximate
            Schur vectors that span the desired invariant subspace.
    WORKL   Double precision  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            WORKL(1:ncv*ncv+3*ncv) contains information obtained in
            dnaupd .  They are not changed by dneupd .
            WORKL(ncv*ncv+3*ncv+1:3*ncv*ncv+6*ncv) holds the
            real and imaginary part of the untransformed Ritz values,
            the upper quasi-triangular matrix for H, and the
            associated matrix representation of the invariant subspace for H.
            Note: IPNTR(9:13) contains the pointer into WORKL for addresses
            of the above information computed by dneupd .
            -------------------------------------------------------------
            IPNTR(9):  pointer to the real part of the NCV RITZ values of the
                       original system.
            IPNTR(10): pointer to the imaginary part of the NCV RITZ values of
                       the original system.
            IPNTR(11): pointer to the NCV corresponding error bounds.
            IPNTR(12): pointer to the NCV by NCV upper quasi-triangular
                       Schur matrix for H.
            IPNTR(13): pointer to the NCV by NCV matrix of eigenvectors
                       of the upper Hessenberg matrix H. Only referenced by
                       dneupd  if RVEC = .TRUE. See Remark 2 below.
            -------------------------------------------------------------
    INFO    Integer.  (OUTPUT)
            Error flag on output.
            =  0: Normal exit.
            =  1: The Schur form computed by LAPACK routine dlahqr 
                  could not be reordered by LAPACK routine dtrsen .
                  Re-enter subroutine dneupd  with IPARAM(5)=NCV and 
                  increase the size of the arrays DR and DI to have 
                  dimension at least dimension NCV and allocate at least NCV 
                  columns for Z. NOTE: Not necessary if Z and V share 
                  the same space. Please notify the authors if this error
                  occurs.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV-NEV >= 2 and less than or equal to N.
            = -5: WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work WORKL array is not sufficient.
            = -8: Error return from calculation of a real Schur form.
                  Informational error from LAPACK routine dlahqr .
            = -9: Error return from calculation of eigenvectors.
                  Informational error from LAPACK routine dtrevc .
            = -10: IPARAM(7) must be 1,2,3,4.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatible.
            = -12: HOWMNY = 'S' not yet implemented
            = -13: HOWMNY must be one of 'A' or 'P' if RVEC = .true.
            = -14: DNAUPD  did not find any eigenvalues to sufficient
                   accuracy.
            = -15: DNEUPD got a different count of the number of converged
                   Ritz values than DNAUPD got.  This indicates the user
                   probably made an error in passing data from DNAUPD to
                   DNEUPD or that the data was modified before entering
                   DNEUPD
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett & Y. Saad, "Complex Shift and Invert Strategies for
       Real Matrices", Linear Algebra and its Applications, vol 88/89,
       pp 575-595, (1987).
  \Routines called:
       ivout   ARPACK utility routine that prints integers.
       dmout    ARPACK utility routine that prints matrices
       dvout    ARPACK utility routine that prints vectors.
       dgeqr2   LAPACK routine that computes the QR factorization of 
               a matrix.
       dlacpy   LAPACK matrix copy routine.
       dlahqr   LAPACK routine to compute the real Schur form of an
               upper Hessenberg matrix.
       dlamch   LAPACK routine that determines machine constants.
       dlapy2   LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dlaset   LAPACK matrix initialization routine.
       dorm2r   LAPACK routine that applies an orthogonal matrix in 
               factored form.
       dtrevc   LAPACK routine to compute the eigenvectors of a matrix
               in upper quasi-triangular form.
       dtrsen   LAPACK routine that re-orders the Schur form.
       dtrmm    Level 3 BLAS matrix times an upper triangular matrix.
       dger     Level 2 BLAS rank one update to a matrix.
       dcopy    Level 1 BLAS that copies one vector to another .
       ddot     Level 1 BLAS that computes the scalar product of two vectors.
       dnrm2    Level 1 BLAS that computes the norm of a vector.
       dscal    Level 1 BLAS that scales a vector.
  \Remarks
    1. Currently only HOWMNY = 'A' and 'P' are implemented.
       Let trans(X) denote the transpose of X.
    2. Schur vectors are an orthogonal representation for the basis of
       Ritz vectors. Thus, their numerical properties are often superior.
       If RVEC = .TRUE. then the relationship
               A * V(:,1:IPARAM(5)) = V(:,1:IPARAM(5)) * T, and
       trans(V(:,1:IPARAM(5))) * V(:,1:IPARAM(5)) = I are approximately 
       satisfied. Here T is the leading submatrix of order IPARAM(5) of the 
       real upper quasi-triangular matrix stored workl(ipntr(12)). That is,
       T is block upper triangular with 1-by-1 and 2-by-2 diagonal blocks; 
       each 2-by-2 diagonal block has its diagonal elements equal and its
       off-diagonal elements of opposite sign.  Corresponding to each 2-by-2
       diagonal block is a complex conjugate pair of Ritz values. The real
       Ritz values are stored on the diagonal of T.
    3. If IPARAM(7) = 3 or 4 and SIGMAI is not equal zero, then the user must
       form the IPARAM(5) Rayleigh quotients in order to transform the Ritz
       values computed by DNAUPD  for OP to those of A*z = lambda*B*z. 
       Set RVEC = .true. and HOWMNY = 'A', and
       compute 
             trans(Z(:,I)) * A * Z(:,I) if DI(I) = 0.
       If DI(I) is not equal to zero and DI(I+1) = - D(I), 
       then the desired real and imaginary parts of the Ritz value are
             trans(Z(:,I)) * A * Z(:,I) +  trans(Z(:,I+1)) * A * Z(:,I+1),
             trans(Z(:,I)) * A * Z(:,I+1) -  trans(Z(:,I+1)) * A * Z(:,I), 
       respectively.
       Another possibility is to set RVEC = .true. and HOWMNY = 'P' and
       compute trans(V(:,1:IPARAM(5))) * A * V(:,1:IPARAM(5)) and then an upper
       quasi-triangular matrix of order IPARAM(5) is computed. See remark
       2 above.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Chao Yang                    Houston, Texas
       Dept. of Computational &
       Applied Mathematics          
       Rice University           
       Houston, Texas            
   
  \SCCS Information: @(#) 
   FILE: neupd.F   SID: 2.7   DATE OF SID: 09/20/00   RELEASE: 2 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rvec
   * @param howmny
   * @param select
   * @param dr
   * @param di
   * @param z
   * @param ldz
   * @param sigmar
   * @param sigmai
   * @param workev
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param ncv
   * @param v
   * @param ldv
   * @param iparam
   * @param ipntr
   * @param workd
   * @param workl
   * @param lworkl
   * @param info
   * 
   */
  abstract public void dneupd(boolean rvec, java.lang.String howmny, boolean[] select, double[] dr, double[] di, double[] z, int ldz, double sigmar, double sigmai, double[] workev, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, double tol, double[] resid, int ncv, double[] v, int ldv, int[] iparam, int[] ipntr, double[] workd, double[] workl, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: dneupd 
  \Description: 
    This subroutine returns the converged approximations to eigenvalues
    of A*z = lambda*B*z and (optionally):
        (1) The corresponding approximate eigenvectors;
        (2) An orthonormal basis for the associated approximate
            invariant subspace;
        (3) Both.
    There is negligible additional cost to obtain eigenvectors.  An orthonormal
    basis is always computed.  There is an additional storage cost of n*nev
    if both are requested (in this case a separate array Z must be supplied).
    The approximate eigenvalues and eigenvectors of  A*z = lambda*B*z
    are derived from approximate eigenvalues and eigenvectors of
    of the linear operator OP prescribed by the MODE selection in the
    call to DNAUPD .  DNAUPD  must be called before this routine is called.
    These approximate eigenvalues and vectors are commonly called Ritz
    values and Ritz vectors respectively.  They are referred to as such
    in the comments that follow.  The computed orthonormal basis for the
    invariant subspace corresponding to these Ritz values is referred to as a
    Schur basis.
    See documentation in the header of the subroutine DNAUPD  for 
    definition of OP as well as other terms and the relation of computed
    Ritz values and Ritz vectors of OP with respect to the given problem
    A*z = lambda*B*z.  For a brief description, see definitions of 
    IPARAM(7), MODE and WHICH in the documentation of DNAUPD .
  \Usage:
    call dneupd  
       ( RVEC, HOWMNY, SELECT, DR, DI, Z, LDZ, SIGMAR, SIGMAI, WORKEV, BMAT, 
         N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR, WORKD, WORKL, 
         LWORKL, INFO )
  \Arguments:
    RVEC    LOGICAL  (INPUT) 
            Specifies whether a basis for the invariant subspace corresponding 
            to the converged Ritz value approximations for the eigenproblem 
            A*z = lambda*B*z is computed.
               RVEC = .FALSE.     Compute Ritz values only.
               RVEC = .TRUE.      Compute the Ritz vectors or Schur vectors.
                                  See Remarks below. 
   
    HOWMNY  Character*1  (INPUT) 
            Specifies the form of the basis for the invariant subspace 
            corresponding to the converged Ritz values that is to be computed.
            = 'A': Compute NEV Ritz vectors; 
            = 'P': Compute NEV Schur vectors;
            = 'S': compute some of the Ritz vectors, specified
                   by the logical array SELECT.
    SELECT  Logical array of dimension NCV.  (INPUT)
            If HOWMNY = 'S', SELECT specifies the Ritz vectors to be
            computed. To select the Ritz vector corresponding to a
            Ritz value (DR(j), DI(j)), SELECT(j) must be set to .TRUE.. 
            If HOWMNY = 'A' or 'P', SELECT is used as internal workspace.
    DR      Double precision  array of dimension NEV+1.  (OUTPUT)
            If IPARAM(7) = 1,2 or 3 and SIGMAI=0.0  then on exit: DR contains 
            the real part of the Ritz  approximations to the eigenvalues of 
            A*z = lambda*B*z. 
            If IPARAM(7) = 3, 4 and SIGMAI is not equal to zero, then on exit:
            DR contains the real part of the Ritz values of OP computed by 
            DNAUPD . A further computation must be performed by the user
            to transform the Ritz values computed for OP by DNAUPD  to those
            of the original system A*z = lambda*B*z. See remark 3 below.
    DI      Double precision  array of dimension NEV+1.  (OUTPUT)
            On exit, DI contains the imaginary part of the Ritz value 
            approximations to the eigenvalues of A*z = lambda*B*z associated
            with DR.
            NOTE: When Ritz values are complex, they will come in complex 
                  conjugate pairs.  If eigenvectors are requested, the 
                  corresponding Ritz vectors will also come in conjugate 
                  pairs and the real and imaginary parts of these are 
                  represented in two consecutive columns of the array Z 
                  (see below).
    Z       Double precision  N by NEV+1 array if RVEC = .TRUE. and HOWMNY = 'A'. (OUTPUT)
            On exit, if RVEC = .TRUE. and HOWMNY = 'A', then the columns of 
            Z represent approximate eigenvectors (Ritz vectors) corresponding 
            to the NCONV=IPARAM(5) Ritz values for eigensystem 
            A*z = lambda*B*z. 
   
            The complex Ritz vector associated with the Ritz value 
            with positive imaginary part is stored in two consecutive 
            columns.  The first column holds the real part of the Ritz 
            vector and the second column holds the imaginary part.  The 
            Ritz vector associated with the Ritz value with negative 
            imaginary part is simply the complex conjugate of the Ritz vector 
            associated with the positive imaginary part.
            If  RVEC = .FALSE. or HOWMNY = 'P', then Z is not referenced.
            NOTE: If if RVEC = .TRUE. and a Schur basis is not required,
            the array Z may be set equal to first NEV+1 columns of the Arnoldi
            basis array V computed by DNAUPD .  In this case the Arnoldi basis
            will be destroyed and overwritten with the eigenvector basis.
    LDZ     Integer.  (INPUT)
            The leading dimension of the array Z.  If Ritz vectors are
            desired, then  LDZ >= max( 1, N ).  In any case,  LDZ >= 1.
    SIGMAR  Double precision   (INPUT)
            If IPARAM(7) = 3 or 4, represents the real part of the shift. 
            Not referenced if IPARAM(7) = 1 or 2.
    SIGMAI  Double precision   (INPUT)
            If IPARAM(7) = 3 or 4, represents the imaginary part of the shift. 
            Not referenced if IPARAM(7) = 1 or 2. See remark 3 below.
    WORKEV  Double precision  work array of dimension 3*NCV.  (WORKSPACE)
    **** The remaining arguments MUST be the same as for the   ****
    **** call to DNAUPD  that was just completed.               ****
    NOTE: The remaining arguments
             BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR,
             WORKD, WORKL, LWORKL, INFO
           must be passed directly to DNEUPD  following the last call
           to DNAUPD .  These arguments MUST NOT BE MODIFIED between
           the the last call to DNAUPD  and the call to DNEUPD .
    Three of these parameters (V, WORKL, INFO) are also output parameters:
    V       Double precision  N by NCV array.  (INPUT/OUTPUT)
            Upon INPUT: the NCV columns of V contain the Arnoldi basis
                        vectors for OP as constructed by DNAUPD  .
            Upon OUTPUT: If RVEC = .TRUE. the first NCONV=IPARAM(5) columns
                         contain approximate Schur vectors that span the
                         desired invariant subspace.  See Remark 2 below.
            NOTE: If the array Z has been set equal to first NEV+1 columns
            of the array V and RVEC=.TRUE. and HOWMNY= 'A', then the
            Arnoldi basis held by V has been overwritten by the desired
            Ritz vectors.  If a separate array Z has been passed then
            the first NCONV=IPARAM(5) columns of V will contain approximate
            Schur vectors that span the desired invariant subspace.
    WORKL   Double precision  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            WORKL(1:ncv*ncv+3*ncv) contains information obtained in
            dnaupd .  They are not changed by dneupd .
            WORKL(ncv*ncv+3*ncv+1:3*ncv*ncv+6*ncv) holds the
            real and imaginary part of the untransformed Ritz values,
            the upper quasi-triangular matrix for H, and the
            associated matrix representation of the invariant subspace for H.
            Note: IPNTR(9:13) contains the pointer into WORKL for addresses
            of the above information computed by dneupd .
            -------------------------------------------------------------
            IPNTR(9):  pointer to the real part of the NCV RITZ values of the
                       original system.
            IPNTR(10): pointer to the imaginary part of the NCV RITZ values of
                       the original system.
            IPNTR(11): pointer to the NCV corresponding error bounds.
            IPNTR(12): pointer to the NCV by NCV upper quasi-triangular
                       Schur matrix for H.
            IPNTR(13): pointer to the NCV by NCV matrix of eigenvectors
                       of the upper Hessenberg matrix H. Only referenced by
                       dneupd  if RVEC = .TRUE. See Remark 2 below.
            -------------------------------------------------------------
    INFO    Integer.  (OUTPUT)
            Error flag on output.
            =  0: Normal exit.
            =  1: The Schur form computed by LAPACK routine dlahqr 
                  could not be reordered by LAPACK routine dtrsen .
                  Re-enter subroutine dneupd  with IPARAM(5)=NCV and 
                  increase the size of the arrays DR and DI to have 
                  dimension at least dimension NCV and allocate at least NCV 
                  columns for Z. NOTE: Not necessary if Z and V share 
                  the same space. Please notify the authors if this error
                  occurs.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV-NEV >= 2 and less than or equal to N.
            = -5: WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work WORKL array is not sufficient.
            = -8: Error return from calculation of a real Schur form.
                  Informational error from LAPACK routine dlahqr .
            = -9: Error return from calculation of eigenvectors.
                  Informational error from LAPACK routine dtrevc .
            = -10: IPARAM(7) must be 1,2,3,4.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatible.
            = -12: HOWMNY = 'S' not yet implemented
            = -13: HOWMNY must be one of 'A' or 'P' if RVEC = .true.
            = -14: DNAUPD  did not find any eigenvalues to sufficient
                   accuracy.
            = -15: DNEUPD got a different count of the number of converged
                   Ritz values than DNAUPD got.  This indicates the user
                   probably made an error in passing data from DNAUPD to
                   DNEUPD or that the data was modified before entering
                   DNEUPD
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett & Y. Saad, "Complex Shift and Invert Strategies for
       Real Matrices", Linear Algebra and its Applications, vol 88/89,
       pp 575-595, (1987).
  \Routines called:
       ivout   ARPACK utility routine that prints integers.
       dmout    ARPACK utility routine that prints matrices
       dvout    ARPACK utility routine that prints vectors.
       dgeqr2   LAPACK routine that computes the QR factorization of 
               a matrix.
       dlacpy   LAPACK matrix copy routine.
       dlahqr   LAPACK routine to compute the real Schur form of an
               upper Hessenberg matrix.
       dlamch   LAPACK routine that determines machine constants.
       dlapy2   LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dlaset   LAPACK matrix initialization routine.
       dorm2r   LAPACK routine that applies an orthogonal matrix in 
               factored form.
       dtrevc   LAPACK routine to compute the eigenvectors of a matrix
               in upper quasi-triangular form.
       dtrsen   LAPACK routine that re-orders the Schur form.
       dtrmm    Level 3 BLAS matrix times an upper triangular matrix.
       dger     Level 2 BLAS rank one update to a matrix.
       dcopy    Level 1 BLAS that copies one vector to another .
       ddot     Level 1 BLAS that computes the scalar product of two vectors.
       dnrm2    Level 1 BLAS that computes the norm of a vector.
       dscal    Level 1 BLAS that scales a vector.
  \Remarks
    1. Currently only HOWMNY = 'A' and 'P' are implemented.
       Let trans(X) denote the transpose of X.
    2. Schur vectors are an orthogonal representation for the basis of
       Ritz vectors. Thus, their numerical properties are often superior.
       If RVEC = .TRUE. then the relationship
               A * V(:,1:IPARAM(5)) = V(:,1:IPARAM(5)) * T, and
       trans(V(:,1:IPARAM(5))) * V(:,1:IPARAM(5)) = I are approximately 
       satisfied. Here T is the leading submatrix of order IPARAM(5) of the 
       real upper quasi-triangular matrix stored workl(ipntr(12)). That is,
       T is block upper triangular with 1-by-1 and 2-by-2 diagonal blocks; 
       each 2-by-2 diagonal block has its diagonal elements equal and its
       off-diagonal elements of opposite sign.  Corresponding to each 2-by-2
       diagonal block is a complex conjugate pair of Ritz values. The real
       Ritz values are stored on the diagonal of T.
    3. If IPARAM(7) = 3 or 4 and SIGMAI is not equal zero, then the user must
       form the IPARAM(5) Rayleigh quotients in order to transform the Ritz
       values computed by DNAUPD  for OP to those of A*z = lambda*B*z. 
       Set RVEC = .true. and HOWMNY = 'A', and
       compute 
             trans(Z(:,I)) * A * Z(:,I) if DI(I) = 0.
       If DI(I) is not equal to zero and DI(I+1) = - D(I), 
       then the desired real and imaginary parts of the Ritz value are
             trans(Z(:,I)) * A * Z(:,I) +  trans(Z(:,I+1)) * A * Z(:,I+1),
             trans(Z(:,I)) * A * Z(:,I+1) -  trans(Z(:,I+1)) * A * Z(:,I), 
       respectively.
       Another possibility is to set RVEC = .true. and HOWMNY = 'P' and
       compute trans(V(:,1:IPARAM(5))) * A * V(:,1:IPARAM(5)) and then an upper
       quasi-triangular matrix of order IPARAM(5) is computed. See remark
       2 above.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Chao Yang                    Houston, Texas
       Dept. of Computational &
       Applied Mathematics          
       Rice University           
       Houston, Texas            
   
  \SCCS Information: @(#) 
   FILE: neupd.F   SID: 2.7   DATE OF SID: 09/20/00   RELEASE: 2 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rvec
   * @param howmny
   * @param select
   * @param _select_offset
   * @param dr
   * @param _dr_offset
   * @param di
   * @param _di_offset
   * @param z
   * @param _z_offset
   * @param ldz
   * @param sigmar
   * @param sigmai
   * @param workev
   * @param _workev_offset
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param ncv
   * @param v
   * @param _v_offset
   * @param ldv
   * @param iparam
   * @param _iparam_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param workl
   * @param _workl_offset
   * @param lworkl
   * @param info
   * 
   */
  abstract public void dneupd(boolean rvec, java.lang.String howmny, boolean[] select, int _select_offset, double[] dr, int _dr_offset, double[] di, int _di_offset, double[] z, int _z_offset, int ldz, double sigmar, double sigmai, double[] workev, int _workev_offset, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, double tol, double[] resid, int _resid_offset, int ncv, double[] v, int _v_offset, int ldv, int[] iparam, int _iparam_offset, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, double[] workl, int _workl_offset, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dngets
  \Description: 
    Given the eigenvalues of the upper Hessenberg matrix H,
    computes the NP shifts AMU that are zeros of the polynomial of 
    degree NP which filters out components of the unwanted eigenvectors
    corresponding to the AMU's based on some given criteria.
    NOTE: call this even in the case of user specified shifts in order
    to sort the eigenvalues, and error bounds of H for later use.
  \Usage:
    call dngets
       ( ISHIFT, WHICH, KEV, NP, RITZR, RITZI, BOUNDS, SHIFTR, SHIFTI )
  \Arguments
    ISHIFT  Integer.  (INPUT)
            Method for selecting the implicit shifts at each iteration.
            ISHIFT = 0: user specified shifts
            ISHIFT = 1: exact shift with respect to the matrix H.
    WHICH   Character*2.  (INPUT)
            Shift selection criteria.
            'LM' -> want the KEV eigenvalues of largest magnitude.
            'SM' -> want the KEV eigenvalues of smallest magnitude.
            'LR' -> want the KEV eigenvalues of largest real part.
            'SR' -> want the KEV eigenvalues of smallest real part.
            'LI' -> want the KEV eigenvalues of largest imaginary part.
            'SI' -> want the KEV eigenvalues of smallest imaginary part.
    KEV      Integer.  (INPUT/OUTPUT)
             INPUT: KEV+NP is the size of the matrix H.
             OUTPUT: Possibly increases KEV by one to keep complex conjugate
             pairs together.
    NP       Integer.  (INPUT/OUTPUT)
             Number of implicit shifts to be computed.
             OUTPUT: Possibly decreases NP by one to keep complex conjugate
             pairs together.
    RITZR,  Double precision array of length KEV+NP.  (INPUT/OUTPUT)
    RITZI   On INPUT, RITZR and RITZI contain the real and imaginary 
            parts of the eigenvalues of H.
            On OUTPUT, RITZR and RITZI are sorted so that the unwanted
            eigenvalues are in the first NP locations and the wanted
            portion is in the last KEV locations.  When exact shifts are 
            selected, the unwanted part corresponds to the shifts to 
            be applied. Also, if ISHIFT .eq. 1, the unwanted eigenvalues
            are further sorted so that the ones with largest Ritz values
            are first.
    BOUNDS  Double precision array of length KEV+NP.  (INPUT/OUTPUT)
            Error bounds corresponding to the ordering in RITZ.
    SHIFTR, SHIFTI  *** USE deprecated as of version 2.1. ***
    
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dsortc  ARPACK sorting routine.
       dcopy   Level 1 BLAS that copies one vector to another .
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: ngets.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       1. xxxx
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ishift
   * @param which
   * @param kev
   * @param np
   * @param ritzr
   * @param ritzi
   * @param bounds
   * @param shiftr
   * @param shifti
   * 
   */
  abstract public void dngets(int ishift, java.lang.String which, org.netlib.util.intW kev, org.netlib.util.intW np, double[] ritzr, double[] ritzi, double[] bounds, double[] shiftr, double[] shifti);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dngets
  \Description: 
    Given the eigenvalues of the upper Hessenberg matrix H,
    computes the NP shifts AMU that are zeros of the polynomial of 
    degree NP which filters out components of the unwanted eigenvectors
    corresponding to the AMU's based on some given criteria.
    NOTE: call this even in the case of user specified shifts in order
    to sort the eigenvalues, and error bounds of H for later use.
  \Usage:
    call dngets
       ( ISHIFT, WHICH, KEV, NP, RITZR, RITZI, BOUNDS, SHIFTR, SHIFTI )
  \Arguments
    ISHIFT  Integer.  (INPUT)
            Method for selecting the implicit shifts at each iteration.
            ISHIFT = 0: user specified shifts
            ISHIFT = 1: exact shift with respect to the matrix H.
    WHICH   Character*2.  (INPUT)
            Shift selection criteria.
            'LM' -> want the KEV eigenvalues of largest magnitude.
            'SM' -> want the KEV eigenvalues of smallest magnitude.
            'LR' -> want the KEV eigenvalues of largest real part.
            'SR' -> want the KEV eigenvalues of smallest real part.
            'LI' -> want the KEV eigenvalues of largest imaginary part.
            'SI' -> want the KEV eigenvalues of smallest imaginary part.
    KEV      Integer.  (INPUT/OUTPUT)
             INPUT: KEV+NP is the size of the matrix H.
             OUTPUT: Possibly increases KEV by one to keep complex conjugate
             pairs together.
    NP       Integer.  (INPUT/OUTPUT)
             Number of implicit shifts to be computed.
             OUTPUT: Possibly decreases NP by one to keep complex conjugate
             pairs together.
    RITZR,  Double precision array of length KEV+NP.  (INPUT/OUTPUT)
    RITZI   On INPUT, RITZR and RITZI contain the real and imaginary 
            parts of the eigenvalues of H.
            On OUTPUT, RITZR and RITZI are sorted so that the unwanted
            eigenvalues are in the first NP locations and the wanted
            portion is in the last KEV locations.  When exact shifts are 
            selected, the unwanted part corresponds to the shifts to 
            be applied. Also, if ISHIFT .eq. 1, the unwanted eigenvalues
            are further sorted so that the ones with largest Ritz values
            are first.
    BOUNDS  Double precision array of length KEV+NP.  (INPUT/OUTPUT)
            Error bounds corresponding to the ordering in RITZ.
    SHIFTR, SHIFTI  *** USE deprecated as of version 2.1. ***
    
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dsortc  ARPACK sorting routine.
       dcopy   Level 1 BLAS that copies one vector to another .
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: ngets.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       1. xxxx
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ishift
   * @param which
   * @param kev
   * @param np
   * @param ritzr
   * @param _ritzr_offset
   * @param ritzi
   * @param _ritzi_offset
   * @param bounds
   * @param _bounds_offset
   * @param shiftr
   * @param _shiftr_offset
   * @param shifti
   * @param _shifti_offset
   * 
   */
  abstract public void dngets(int ishift, java.lang.String which, org.netlib.util.intW kev, org.netlib.util.intW np, double[] ritzr, int _ritzr_offset, double[] ritzi, int _ritzi_offset, double[] bounds, int _bounds_offset, double[] shiftr, int _shiftr_offset, double[] shifti, int _shifti_offset);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsaitr
  \Description: 
    Reverse communication interface for applying NP additional steps to 
    a K step symmetric Arnoldi factorization.
    Input:  OP*V_{k}  -  V_{k}*H = r_{k}*e_{k}^T
            with (V_{k}^T)*B*V_{k} = I, (V_{k}^T)*B*r_{k} = 0.
    Output: OP*V_{k+p}  -  V_{k+p}*H = r_{k+p}*e_{k+p}^T
            with (V_{k+p}^T)*B*V_{k+p} = I, (V_{k+p}^T)*B*r_{k+p} = 0.
    where OP and B are as in dsaupd.  The B-norm of r_{k+p} is also
    computed and returned.
  \Usage:
    call dsaitr
       ( IDO, BMAT, N, K, NP, MODE, RESID, RNORM, V, LDV, H, LDH, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
                      This is for the restart phase to force the new
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y,
                      IPNTR(3) is the pointer into WORK for B * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
            IDO = 99: done
            -------------------------------------------------------------
            When the routine is used in the "shift-and-invert" mode, the
            vector B * Q is already available and does not need to be
            recomputed in forming OP * Q.
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of matrix B that defines the
            semi-inner product for the operator OP.  See dsaupd.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*M*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    K       Integer.  (INPUT)
            Current order of H and the number of columns of V.
    NP      Integer.  (INPUT)
            Number of additional Arnoldi steps to take.
    MODE    Integer.  (INPUT)
            Signifies which form for "OP". If MODE=2 then
            a reduction in the number of B matrix vector multiplies
            is possible since the B-norm of OP*x is equivalent to
            the inv(B)-norm of A*x.
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            On INPUT:  RESID contains the residual vector r_{k}.
            On OUTPUT: RESID contains the residual vector r_{k+p}.
    RNORM   Double precision scalar.  (INPUT/OUTPUT)
            On INPUT the B-norm of r_{k}.
            On OUTPUT the B-norm of the updated residual r_{k+p}.
    V       Double precision N by K+NP array.  (INPUT/OUTPUT)
            On INPUT:  V contains the Arnoldi vectors in the first K 
            columns.
            On OUTPUT: V contains the new NP Arnoldi vectors in the next
            NP columns.  The first K columns are unchanged.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Double precision (K+NP) by 2 array.  (INPUT/OUTPUT)
            H is used to store the generated symmetric tridiagonal matrix
            with the subdiagonal in the first column starting at H(2,1)
            and the main diagonal in the second column.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORK for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The calling program should not 
            use WORKD as temporary workspace during the iteration !!!!!!
            On INPUT, WORKD(1:N) = B*RESID where RESID is associated
            with the K step Arnoldi factorization. Used to save some 
            computation at the first step. 
            On OUTPUT, WORKD(1:N) = B*RESID where RESID is associated
            with the K+NP step Arnoldi factorization.
    INFO    Integer.  (OUTPUT)
            = 0: Normal exit.
            > 0: Size of an invariant subspace of OP is found that is
                 less than K + NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dgetv0  ARPACK routine to generate the initial vector.
       ivout   ARPACK utility routine that prints integers.
       dmout   ARPACK utility routine that prints matrices.
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
       dlascl  LAPACK routine for careful scaling of a matrix.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       daxpy   Level 1 BLAS that computes a vector triad.
       dscal   Level 1 BLAS that scales a vector.
       dcopy   Level 1 BLAS that copies one vector to another .
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       xx/xx/93: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: saitr.F   SID: 2.6   DATE OF SID: 8/28/96   RELEASE: 2
  \Remarks
    The algorithm implemented is:
    
    restart = .false.
    Given V_{k} = [v_{1}, ..., v_{k}], r_{k}; 
    r_{k} contains the initial residual vector even for k = 0;
    Also assume that rnorm = || B*r_{k} || and B*r_{k} are already 
    computed by the calling program.
    betaj = rnorm ; p_{k+1} = B*r_{k} ;
    For  j = k+1, ..., k+np  Do
       1) if ( betaj < tol ) stop or restart depending on j.
          if ( restart ) generate a new starting vector.
       2) v_{j} = r(j-1)/betaj;  V_{j} = [V_{j-1}, v_{j}];  
          p_{j} = p_{j}/betaj
       3) r_{j} = OP*v_{j} where OP is defined as in dsaupd
          For shift-invert mode p_{j} = B*v_{j} is already available.
          wnorm = || OP*v_{j} ||
       4) Compute the j-th step residual vector.
          w_{j} =  V_{j}^T * B * OP * v_{j}
          r_{j} =  OP*v_{j} - V_{j} * w_{j}
          alphaj <- j-th component of w_{j}
          rnorm = || r_{j} ||
          betaj+1 = rnorm
          If (rnorm > 0.717*wnorm) accept step and go back to 1)
       5) Re-orthogonalization step:
          s = V_{j}'*B*r_{j}
          r_{j} = r_{j} - V_{j}*s;  rnorm1 = || r_{j} ||
          alphaj = alphaj + s_{j};   
       6) Iterative refinement step:
          If (rnorm1 > 0.717*rnorm) then
             rnorm = rnorm1
             accept step and go back to 1)
          Else
             rnorm = rnorm1
             If this is the first time in step 6), go to 5)
             Else r_{j} lies in the span of V_{j} numerically.
                Set r_{j} = 0 and rnorm = 0; go to 1)
          EndIf 
    End Do
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param k
   * @param np
   * @param mode
   * @param resid
   * @param rnorm
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param ipntr
   * @param workd
   * @param info
   * 
   */
  abstract public void dsaitr(org.netlib.util.intW ido, java.lang.String bmat, int n, int k, int np, int mode, double[] resid, org.netlib.util.doubleW rnorm, double[] v, int ldv, double[] h, int ldh, int[] ipntr, double[] workd, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsaitr
  \Description: 
    Reverse communication interface for applying NP additional steps to 
    a K step symmetric Arnoldi factorization.
    Input:  OP*V_{k}  -  V_{k}*H = r_{k}*e_{k}^T
            with (V_{k}^T)*B*V_{k} = I, (V_{k}^T)*B*r_{k} = 0.
    Output: OP*V_{k+p}  -  V_{k+p}*H = r_{k+p}*e_{k+p}^T
            with (V_{k+p}^T)*B*V_{k+p} = I, (V_{k+p}^T)*B*r_{k+p} = 0.
    where OP and B are as in dsaupd.  The B-norm of r_{k+p} is also
    computed and returned.
  \Usage:
    call dsaitr
       ( IDO, BMAT, N, K, NP, MODE, RESID, RNORM, V, LDV, H, LDH, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
                      This is for the restart phase to force the new
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y,
                      IPNTR(3) is the pointer into WORK for B * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
            IDO = 99: done
            -------------------------------------------------------------
            When the routine is used in the "shift-and-invert" mode, the
            vector B * Q is already available and does not need to be
            recomputed in forming OP * Q.
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of matrix B that defines the
            semi-inner product for the operator OP.  See dsaupd.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*M*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    K       Integer.  (INPUT)
            Current order of H and the number of columns of V.
    NP      Integer.  (INPUT)
            Number of additional Arnoldi steps to take.
    MODE    Integer.  (INPUT)
            Signifies which form for "OP". If MODE=2 then
            a reduction in the number of B matrix vector multiplies
            is possible since the B-norm of OP*x is equivalent to
            the inv(B)-norm of A*x.
    RESID   Double precision array of length N.  (INPUT/OUTPUT)
            On INPUT:  RESID contains the residual vector r_{k}.
            On OUTPUT: RESID contains the residual vector r_{k+p}.
    RNORM   Double precision scalar.  (INPUT/OUTPUT)
            On INPUT the B-norm of r_{k}.
            On OUTPUT the B-norm of the updated residual r_{k+p}.
    V       Double precision N by K+NP array.  (INPUT/OUTPUT)
            On INPUT:  V contains the Arnoldi vectors in the first K 
            columns.
            On OUTPUT: V contains the new NP Arnoldi vectors in the next
            NP columns.  The first K columns are unchanged.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Double precision (K+NP) by 2 array.  (INPUT/OUTPUT)
            H is used to store the generated symmetric tridiagonal matrix
            with the subdiagonal in the first column starting at H(2,1)
            and the main diagonal in the second column.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORK for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The calling program should not 
            use WORKD as temporary workspace during the iteration !!!!!!
            On INPUT, WORKD(1:N) = B*RESID where RESID is associated
            with the K step Arnoldi factorization. Used to save some 
            computation at the first step. 
            On OUTPUT, WORKD(1:N) = B*RESID where RESID is associated
            with the K+NP step Arnoldi factorization.
    INFO    Integer.  (OUTPUT)
            = 0: Normal exit.
            > 0: Size of an invariant subspace of OP is found that is
                 less than K + NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dgetv0  ARPACK routine to generate the initial vector.
       ivout   ARPACK utility routine that prints integers.
       dmout   ARPACK utility routine that prints matrices.
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
       dlascl  LAPACK routine for careful scaling of a matrix.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       daxpy   Level 1 BLAS that computes a vector triad.
       dscal   Level 1 BLAS that scales a vector.
       dcopy   Level 1 BLAS that copies one vector to another .
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       xx/xx/93: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: saitr.F   SID: 2.6   DATE OF SID: 8/28/96   RELEASE: 2
  \Remarks
    The algorithm implemented is:
    
    restart = .false.
    Given V_{k} = [v_{1}, ..., v_{k}], r_{k}; 
    r_{k} contains the initial residual vector even for k = 0;
    Also assume that rnorm = || B*r_{k} || and B*r_{k} are already 
    computed by the calling program.
    betaj = rnorm ; p_{k+1} = B*r_{k} ;
    For  j = k+1, ..., k+np  Do
       1) if ( betaj < tol ) stop or restart depending on j.
          if ( restart ) generate a new starting vector.
       2) v_{j} = r(j-1)/betaj;  V_{j} = [V_{j-1}, v_{j}];  
          p_{j} = p_{j}/betaj
       3) r_{j} = OP*v_{j} where OP is defined as in dsaupd
          For shift-invert mode p_{j} = B*v_{j} is already available.
          wnorm = || OP*v_{j} ||
       4) Compute the j-th step residual vector.
          w_{j} =  V_{j}^T * B * OP * v_{j}
          r_{j} =  OP*v_{j} - V_{j} * w_{j}
          alphaj <- j-th component of w_{j}
          rnorm = || r_{j} ||
          betaj+1 = rnorm
          If (rnorm > 0.717*wnorm) accept step and go back to 1)
       5) Re-orthogonalization step:
          s = V_{j}'*B*r_{j}
          r_{j} = r_{j} - V_{j}*s;  rnorm1 = || r_{j} ||
          alphaj = alphaj + s_{j};   
       6) Iterative refinement step:
          If (rnorm1 > 0.717*rnorm) then
             rnorm = rnorm1
             accept step and go back to 1)
          Else
             rnorm = rnorm1
             If this is the first time in step 6), go to 5)
             Else r_{j} lies in the span of V_{j} numerically.
                Set r_{j} = 0 and rnorm = 0; go to 1)
          EndIf 
    End Do
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param k
   * @param np
   * @param mode
   * @param resid
   * @param _resid_offset
   * @param rnorm
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param info
   * 
   */
  abstract public void dsaitr(org.netlib.util.intW ido, java.lang.String bmat, int n, int k, int np, int mode, double[] resid, int _resid_offset, org.netlib.util.doubleW rnorm, double[] v, int _v_offset, int ldv, double[] h, int _h_offset, int ldh, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsapps
  \Description:
    Given the Arnoldi factorization
       A*V_{k} - V_{k}*H_{k} = r_{k+p}*e_{k+p}^T,
    apply NP shifts implicitly resulting in
       A*(V_{k}*Q) - (V_{k}*Q)*(Q^T* H_{k}*Q) = r_{k+p}*e_{k+p}^T * Q
    where Q is an orthogonal matrix of order KEV+NP. Q is the product of 
    rotations resulting from the NP bulge chasing sweeps.  The updated Arnoldi 
    factorization becomes:
       A*VNEW_{k} - VNEW_{k}*HNEW_{k} = rnew_{k}*e_{k}^T.
  \Usage:
    call dsapps
       ( N, KEV, NP, SHIFT, V, LDV, H, LDH, RESID, Q, LDQ, WORKD )
  \Arguments
    N       Integer.  (INPUT)
            Problem size, i.e. dimension of matrix A.
    KEV     Integer.  (INPUT)
            INPUT: KEV+NP is the size of the input matrix H.
            OUTPUT: KEV is the size of the updated matrix HNEW.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be applied.
    SHIFT   Double precision array of length NP.  (INPUT)
            The shifts to be applied.
    V       Double precision N by (KEV+NP) array.  (INPUT/OUTPUT)
            INPUT: V contains the current KEV+NP Arnoldi vectors.
            OUTPUT: VNEW = V(1:n,1:KEV); the updated Arnoldi vectors
            are in the first KEV columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    H       Double precision (KEV+NP) by 2 array.  (INPUT/OUTPUT)
            INPUT: H contains the symmetric tridiagonal matrix of the
            Arnoldi factorization with the subdiagonal in the 1st column
            starting at H(2,1) and the main diagonal in the 2nd column.
            OUTPUT: H contains the updated tridiagonal matrix in the 
            KEV leading submatrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RESID   Double precision array of length (N).  (INPUT/OUTPUT)
            INPUT: RESID contains the the residual vector r_{k+p}.
            OUTPUT: RESID is the updated residual vector rnew_{k}.
    Q       Double precision KEV+NP by KEV+NP work array.  (WORKSPACE)
            Work array used to accumulate the rotations during the bulge
            chase sweep.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKD   Double precision work array of length 2*N.  (WORKSPACE)
            Distributed array used in the application of the accumulated
            orthogonal matrix Q.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       ivout   ARPACK utility routine that prints integers. 
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
       dlartg  LAPACK Givens rotation construction routine.
       dlacpy  LAPACK matrix copy routine.
       dlaset  LAPACK matrix initialization routine.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       daxpy   Level 1 BLAS that computes a vector triad.
       dcopy   Level 1 BLAS that copies one vector to another.
       dscal   Level 1 BLAS that scales a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/16/93: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: sapps.F   SID: 2.6   DATE OF SID: 3/28/97   RELEASE: 2
  \Remarks
    1. In this version, each shift is applied to all the subblocks of
       the tridiagonal matrix H and not just to the submatrix that it 
       comes from. This routine assumes that the subdiagonal elements 
       of H that are stored in h(1:kev+np,1) are nonegative upon input
       and enforce this condition upon output. This version incorporates
       deflation. See code for documentation.
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param kev
   * @param np
   * @param shift
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param resid
   * @param q
   * @param ldq
   * @param workd
   * 
   */
  abstract public void dsapps(int n, int kev, int np, double[] shift, double[] v, int ldv, double[] h, int ldh, double[] resid, double[] q, int ldq, double[] workd);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsapps
  \Description:
    Given the Arnoldi factorization
       A*V_{k} - V_{k}*H_{k} = r_{k+p}*e_{k+p}^T,
    apply NP shifts implicitly resulting in
       A*(V_{k}*Q) - (V_{k}*Q)*(Q^T* H_{k}*Q) = r_{k+p}*e_{k+p}^T * Q
    where Q is an orthogonal matrix of order KEV+NP. Q is the product of 
    rotations resulting from the NP bulge chasing sweeps.  The updated Arnoldi 
    factorization becomes:
       A*VNEW_{k} - VNEW_{k}*HNEW_{k} = rnew_{k}*e_{k}^T.
  \Usage:
    call dsapps
       ( N, KEV, NP, SHIFT, V, LDV, H, LDH, RESID, Q, LDQ, WORKD )
  \Arguments
    N       Integer.  (INPUT)
            Problem size, i.e. dimension of matrix A.
    KEV     Integer.  (INPUT)
            INPUT: KEV+NP is the size of the input matrix H.
            OUTPUT: KEV is the size of the updated matrix HNEW.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be applied.
    SHIFT   Double precision array of length NP.  (INPUT)
            The shifts to be applied.
    V       Double precision N by (KEV+NP) array.  (INPUT/OUTPUT)
            INPUT: V contains the current KEV+NP Arnoldi vectors.
            OUTPUT: VNEW = V(1:n,1:KEV); the updated Arnoldi vectors
            are in the first KEV columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    H       Double precision (KEV+NP) by 2 array.  (INPUT/OUTPUT)
            INPUT: H contains the symmetric tridiagonal matrix of the
            Arnoldi factorization with the subdiagonal in the 1st column
            starting at H(2,1) and the main diagonal in the 2nd column.
            OUTPUT: H contains the updated tridiagonal matrix in the 
            KEV leading submatrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RESID   Double precision array of length (N).  (INPUT/OUTPUT)
            INPUT: RESID contains the the residual vector r_{k+p}.
            OUTPUT: RESID is the updated residual vector rnew_{k}.
    Q       Double precision KEV+NP by KEV+NP work array.  (WORKSPACE)
            Work array used to accumulate the rotations during the bulge
            chase sweep.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKD   Double precision work array of length 2*N.  (WORKSPACE)
            Distributed array used in the application of the accumulated
            orthogonal matrix Q.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       ivout   ARPACK utility routine that prints integers. 
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
       dlartg  LAPACK Givens rotation construction routine.
       dlacpy  LAPACK matrix copy routine.
       dlaset  LAPACK matrix initialization routine.
       dgemv   Level 2 BLAS routine for matrix vector multiplication.
       daxpy   Level 1 BLAS that computes a vector triad.
       dcopy   Level 1 BLAS that copies one vector to another.
       dscal   Level 1 BLAS that scales a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/16/93: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: sapps.F   SID: 2.6   DATE OF SID: 3/28/97   RELEASE: 2
  \Remarks
    1. In this version, each shift is applied to all the subblocks of
       the tridiagonal matrix H and not just to the submatrix that it 
       comes from. This routine assumes that the subdiagonal elements 
       of H that are stored in h(1:kev+np,1) are nonegative upon input
       and enforce this condition upon output. This version incorporates
       deflation. See code for documentation.
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param kev
   * @param np
   * @param shift
   * @param _shift_offset
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param resid
   * @param _resid_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workd
   * @param _workd_offset
   * 
   */
  abstract public void dsapps(int n, int kev, int np, double[] shift, int _shift_offset, double[] v, int _v_offset, int ldv, double[] h, int _h_offset, int ldh, double[] resid, int _resid_offset, double[] q, int _q_offset, int ldq, double[] workd, int _workd_offset);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsaup2
  \Description: 
    Intermediate level interface called by dsaupd.
  \Usage:
    call dsaup2 
       ( IDO, BMAT, N, WHICH, NEV, NP, TOL, RESID, MODE, IUPD,
         ISHIFT, MXITER, V, LDV, H, LDH, RITZ, BOUNDS, Q, LDQ, WORKL, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO, BMAT, N, WHICH, NEV, TOL, RESID: same as defined in dsaupd.
    MODE, ISHIFT, MXITER: see the definition of IPARAM in dsaupd.
    
    NP      Integer.  (INPUT/OUTPUT)
            Contains the number of implicit shifts to apply during 
            each Arnoldi/Lanczos iteration.  
            If ISHIFT=1, NP is adjusted dynamically at each iteration 
            to accelerate convergence and prevent stagnation.
            This is also roughly equal to the number of matrix-vector 
            products (involving the operator OP) per Arnoldi iteration.
            The logic for adjusting is contained within the current
            subroutine.
            If ISHIFT=0, NP is the number of shifts the user needs
            to provide via reverse comunication. 0 < NP < NCV-NEV.
            NP may be less than NCV-NEV since a leading block of the current
            upper Tridiagonal matrix has split off and contains "unwanted"
            Ritz values.
            Upon termination of the IRA iteration, NP contains the number 
            of "converged" wanted Ritz values.
    IUPD    Integer.  (INPUT)
            IUPD .EQ. 0: use explicit restart instead implicit update.
            IUPD .NE. 0: use implicit update.
    V       Double precision N by (NEV+NP) array.  (INPUT/OUTPUT)
            The Lanczos basis vectors.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Double precision (NEV+NP) by 2 array.  (OUTPUT)
            H is used to store the generated symmetric tridiagonal matrix
            The subdiagonal is stored in the first column of H starting 
            at H(2,1).  The main diagonal is stored in the second column
            of H starting at H(1,2). If dsaup2 converges store the 
            B-norm of the final residual vector in H(1,1).
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    RITZ    Double precision array of length NEV+NP.  (OUTPUT)
            RITZ(1:NEV) contains the computed Ritz values of OP.
    BOUNDS  Double precision array of length NEV+NP.  (OUTPUT)
            BOUNDS(1:NEV) contain the error bounds corresponding to RITZ.
    Q       Double precision (NEV+NP) by (NEV+NP) array.  (WORKSPACE)
            Private (replicated) work array used to accumulate the 
            rotation in the shift application step.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
            
    WORKL   Double precision array of length at least 3*(NEV+NP).  (INPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  It is used in the computation of the 
            tridiagonal eigenvalue problem, the calculation and
            application of the shifts and convergence checking.
            If ISHIFT .EQ. O and IDO .EQ. 3, the first NP locations
            of WORKL are used in reverse communication to hold the user 
            supplied shifts.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD for 
            vectors used by the Lanczos iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in one of  
                      the spectral transformation modes.  X is the current
                      operand.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Lanczos iteration
            for reverse communication.  The user should not use WORKD
            as temporary workspace during the iteration !!!!!!!!!!
            See Data Distribution Note in dsaupd.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =     0: Normal return.
            =     1: All possible eigenvalues of OP has been found.  
                     NP returns the size of the invariant subspace
                     spanning the operator OP. 
            =     2: No shifts could be applied.
            =    -8: Error return from trid. eigenvalue calculation;
                     This should never happen.
            =    -9: Starting vector is zero.
            = -9999: Could not build an Lanczos factorization.
                     Size that was built in returned in NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
  \Routines called:
       dgetv0  ARPACK initial vector generation routine. 
       dsaitr  ARPACK Lanczos factorization routine.
       dsapps  ARPACK application of implicit shifts routine.
       dsconv  ARPACK convergence of Ritz values routine.
       dseigt  ARPACK compute Ritz values and error bounds routine.
       dsgets  ARPACK reorder Ritz values and error bounds routine.
       dsortr  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
       dcopy   Level 1 BLAS that copies one vector to another.
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
       dscal   Level 1 BLAS that scales a vector.
       dswap   Level 1 BLAS that swaps two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.4'
       xx/xx/95: Version ' 2.4'.  (R.B. Lehoucq)
  \SCCS Information: @(#) 
   FILE: saup2.F   SID: 2.7   DATE OF SID: 5/19/98   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param np
   * @param tol
   * @param resid
   * @param mode
   * @param iupd
   * @param ishift
   * @param mxiter
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param ritz
   * @param bounds
   * @param q
   * @param ldq
   * @param workl
   * @param ipntr
   * @param workd
   * @param info
   * 
   */
  abstract public void dsaup2(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, org.netlib.util.intW np, double tol, double[] resid, int mode, int iupd, int ishift, org.netlib.util.intW mxiter, double[] v, int ldv, double[] h, int ldh, double[] ritz, double[] bounds, double[] q, int ldq, double[] workl, int[] ipntr, double[] workd, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsaup2
  \Description: 
    Intermediate level interface called by dsaupd.
  \Usage:
    call dsaup2 
       ( IDO, BMAT, N, WHICH, NEV, NP, TOL, RESID, MODE, IUPD,
         ISHIFT, MXITER, V, LDV, H, LDH, RITZ, BOUNDS, Q, LDQ, WORKL, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO, BMAT, N, WHICH, NEV, TOL, RESID: same as defined in dsaupd.
    MODE, ISHIFT, MXITER: see the definition of IPARAM in dsaupd.
    
    NP      Integer.  (INPUT/OUTPUT)
            Contains the number of implicit shifts to apply during 
            each Arnoldi/Lanczos iteration.  
            If ISHIFT=1, NP is adjusted dynamically at each iteration 
            to accelerate convergence and prevent stagnation.
            This is also roughly equal to the number of matrix-vector 
            products (involving the operator OP) per Arnoldi iteration.
            The logic for adjusting is contained within the current
            subroutine.
            If ISHIFT=0, NP is the number of shifts the user needs
            to provide via reverse comunication. 0 < NP < NCV-NEV.
            NP may be less than NCV-NEV since a leading block of the current
            upper Tridiagonal matrix has split off and contains "unwanted"
            Ritz values.
            Upon termination of the IRA iteration, NP contains the number 
            of "converged" wanted Ritz values.
    IUPD    Integer.  (INPUT)
            IUPD .EQ. 0: use explicit restart instead implicit update.
            IUPD .NE. 0: use implicit update.
    V       Double precision N by (NEV+NP) array.  (INPUT/OUTPUT)
            The Lanczos basis vectors.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Double precision (NEV+NP) by 2 array.  (OUTPUT)
            H is used to store the generated symmetric tridiagonal matrix
            The subdiagonal is stored in the first column of H starting 
            at H(2,1).  The main diagonal is stored in the second column
            of H starting at H(1,2). If dsaup2 converges store the 
            B-norm of the final residual vector in H(1,1).
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    RITZ    Double precision array of length NEV+NP.  (OUTPUT)
            RITZ(1:NEV) contains the computed Ritz values of OP.
    BOUNDS  Double precision array of length NEV+NP.  (OUTPUT)
            BOUNDS(1:NEV) contain the error bounds corresponding to RITZ.
    Q       Double precision (NEV+NP) by (NEV+NP) array.  (WORKSPACE)
            Private (replicated) work array used to accumulate the 
            rotation in the shift application step.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
            
    WORKL   Double precision array of length at least 3*(NEV+NP).  (INPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  It is used in the computation of the 
            tridiagonal eigenvalue problem, the calculation and
            application of the shifts and convergence checking.
            If ISHIFT .EQ. O and IDO .EQ. 3, the first NP locations
            of WORKL are used in reverse communication to hold the user 
            supplied shifts.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD for 
            vectors used by the Lanczos iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in one of  
                      the spectral transformation modes.  X is the current
                      operand.
            -------------------------------------------------------------
            
    WORKD   Double precision work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Lanczos iteration
            for reverse communication.  The user should not use WORKD
            as temporary workspace during the iteration !!!!!!!!!!
            See Data Distribution Note in dsaupd.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =     0: Normal return.
            =     1: All possible eigenvalues of OP has been found.  
                     NP returns the size of the invariant subspace
                     spanning the operator OP. 
            =     2: No shifts could be applied.
            =    -8: Error return from trid. eigenvalue calculation;
                     This should never happen.
            =    -9: Starting vector is zero.
            = -9999: Could not build an Lanczos factorization.
                     Size that was built in returned in NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
  \Routines called:
       dgetv0  ARPACK initial vector generation routine. 
       dsaitr  ARPACK Lanczos factorization routine.
       dsapps  ARPACK application of implicit shifts routine.
       dsconv  ARPACK convergence of Ritz values routine.
       dseigt  ARPACK compute Ritz values and error bounds routine.
       dsgets  ARPACK reorder Ritz values and error bounds routine.
       dsortr  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dlamch  LAPACK routine that determines machine constants.
       dcopy   Level 1 BLAS that copies one vector to another.
       ddot    Level 1 BLAS that computes the scalar product of two vectors. 
       dnrm2   Level 1 BLAS that computes the norm of a vector.
       dscal   Level 1 BLAS that scales a vector.
       dswap   Level 1 BLAS that swaps two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.4'
       xx/xx/95: Version ' 2.4'.  (R.B. Lehoucq)
  \SCCS Information: @(#) 
   FILE: saup2.F   SID: 2.7   DATE OF SID: 5/19/98   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param np
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param mode
   * @param iupd
   * @param ishift
   * @param mxiter
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ritz
   * @param _ritz_offset
   * @param bounds
   * @param _bounds_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workl
   * @param _workl_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param info
   * 
   */
  abstract public void dsaup2(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, org.netlib.util.intW np, double tol, double[] resid, int _resid_offset, int mode, int iupd, int ishift, org.netlib.util.intW mxiter, double[] v, int _v_offset, int ldv, double[] h, int _h_offset, int ldh, double[] ritz, int _ritz_offset, double[] bounds, int _bounds_offset, double[] q, int _q_offset, int ldq, double[] workl, int _workl_offset, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsaupd 
  \Description: 
    Reverse communication interface for the Implicitly Restarted Arnoldi 
    Iteration.  For symmetric problems this reduces to a variant of the Lanczos 
    method.  This method has been designed to compute approximations to a 
    few eigenpairs of a linear operator OP that is real and symmetric 
    with respect to a real positive semi-definite symmetric matrix B, 
    i.e.
                     
         B*OP = (OP`)*B.  
    Another way to express this condition is 
         < x,OPy > = < OPx,y >  where < z,w > = z`Bw  .
    
    In the standard eigenproblem B is the identity matrix.  
    ( A` denotes transpose of A)
    The computed approximate eigenvalues are called Ritz values and
    the corresponding approximate eigenvectors are called Ritz vectors.
    dsaupd  is usually called iteratively to solve one of the 
    following problems:
    Mode 1:  A*x = lambda*x, A symmetric 
             ===> OP = A  and  B = I.
    Mode 2:  A*x = lambda*M*x, A symmetric, M symmetric positive definite
             ===> OP = inv[M]*A  and  B = M.
             ===> (If M can be factored see remark 3 below)
    Mode 3:  K*x = lambda*M*x, K symmetric, M symmetric positive semi-definite
             ===> OP = (inv[K - sigma*M])*M  and  B = M. 
             ===> Shift-and-Invert mode
    Mode 4:  K*x = lambda*KG*x, K symmetric positive semi-definite, 
             KG symmetric indefinite
             ===> OP = (inv[K - sigma*KG])*K  and  B = K.
             ===> Buckling mode
    Mode 5:  A*x = lambda*M*x, A symmetric, M symmetric positive semi-definite
             ===> OP = inv[A - sigma*M]*[A + sigma*M]  and  B = M.
             ===> Cayley transformed mode
    NOTE: The action of w <- inv[A - sigma*M]*v or w <- inv[M]*v
          should be accomplished either by a direct method
          using a sparse matrix factorization and solving
             [A - sigma*M]*w = v  or M*w = v,
          or through an iterative method for solving these
          systems.  If an iterative method is used, the
          convergence test must be more stringent than
          the accuracy requirements for the eigenvalue
          approximations.
  \Usage:
    call dsaupd  
       ( IDO, BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM,
         IPNTR, WORKD, WORKL, LWORKL, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first 
            call to dsaupd .  IDO will be set internally to
            indicate the type of operation to be performed.  Control is
            then given back to the calling routine which has the
            responsibility to carry out the requested operation and call
            dsaupd  with the result.  The operand is given in
            WORKD(IPNTR(1)), the result must be put in WORKD(IPNTR(2)).
            (If Mode = 2 see remark 5 below)
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      In mode 3,4 and 5, the vector B * X is already
                      available in WORKD(ipntr(3)).  It does not
                      need to be recomputed in forming OP * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO =  3: compute the IPARAM(8) shifts where
                      IPNTR(11) is the pointer into WORKL for
                      placing the shifts. See remark 6 below.
            IDO = 99: done
            -------------------------------------------------------------
               
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    WHICH   Character*2.  (INPUT)
            Specify which of the Ritz values of OP to compute.
            'LA' - compute the NEV largest (algebraic) eigenvalues.
            'SA' - compute the NEV smallest (algebraic) eigenvalues.
            'LM' - compute the NEV largest (in magnitude) eigenvalues.
            'SM' - compute the NEV smallest (in magnitude) eigenvalues. 
            'BE' - compute NEV eigenvalues, half from each end of the
                   spectrum.  When NEV is odd, compute one more from the
                   high end than from the low end.
             (see remark 1 below)
    NEV     Integer.  (INPUT)
            Number of eigenvalues of OP to be computed. 0 < NEV < N.
    TOL     Double precision  scalar.  (INPUT)
            Stopping criterion: the relative accuracy of the Ritz value 
            is considered acceptable if BOUNDS(I) .LE. TOL*ABS(RITZ(I)).
            If TOL .LE. 0. is passed a default is set:
            DEFAULT = DLAMCH ('EPS')  (machine precision as computed
                      by the LAPACK auxiliary subroutine DLAMCH ).
    RESID   Double precision  array of length N.  (INPUT/OUTPUT)
            On INPUT: 
            If INFO .EQ. 0, a random initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            On OUTPUT:
            RESID contains the final residual vector. 
    NCV     Integer.  (INPUT)
            Number of columns of the matrix V (less than or equal to N).
            This will indicate how many Lanczos vectors are generated 
            at each iteration.  After the startup phase in which NEV 
            Lanczos vectors are generated, the algorithm generates 
            NCV-NEV Lanczos vectors at each subsequent update iteration.
            Most of the cost in generating each Lanczos vector is in the 
            matrix-vector product OP*x. (See remark 4 below).
    V       Double precision  N by NCV array.  (OUTPUT)
            The NCV columns of V contain the Lanczos basis vectors.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    IPARAM  Integer array of length 11.  (INPUT/OUTPUT)
            IPARAM(1) = ISHIFT: method for selecting the implicit shifts.
            The shifts selected at each iteration are used to restart
            the Arnoldi iteration in an implicit fashion.
            -------------------------------------------------------------
            ISHIFT = 0: the shifts are provided by the user via
                        reverse communication.  The NCV eigenvalues of
                        the current tridiagonal matrix T are returned in
                        the part of WORKL array corresponding to RITZ.
                        See remark 6 below.
            ISHIFT = 1: exact shifts with respect to the reduced 
                        tridiagonal matrix T.  This is equivalent to 
                        restarting the iteration with a starting vector 
                        that is a linear combination of Ritz vectors 
                        associated with the "wanted" Ritz values.
            -------------------------------------------------------------
            IPARAM(2) = LEVEC
            No longer referenced. See remark 2 below.
            IPARAM(3) = MXITER
            On INPUT:  maximum number of Arnoldi update iterations allowed. 
            On OUTPUT: actual number of Arnoldi update iterations taken. 
            IPARAM(4) = NB: blocksize to be used in the recurrence.
            The code currently works only for NB = 1.
            IPARAM(5) = NCONV: number of "converged" Ritz values.
            This represents the number of Ritz values that satisfy
            the convergence criterion.
            IPARAM(6) = IUPD
            No longer referenced. Implicit restarting is ALWAYS used. 
            IPARAM(7) = MODE
            On INPUT determines what type of eigenproblem is being solved.
            Must be 1,2,3,4,5; See under \Description of dsaupd  for the 
            five modes available.
            IPARAM(8) = NP
            When ido = 3 and the user provides shifts through reverse
            communication (IPARAM(1)=0), dsaupd  returns NP, the number
            of shifts the user is to provide. 0 < NP <=NCV-NEV. See Remark
            6 below.
            IPARAM(9) = NUMOP, IPARAM(10) = NUMOPB, IPARAM(11) = NUMREO,
            OUTPUT: NUMOP  = total number of OP*x operations,
                    NUMOPB = total number of B*x operations if BMAT='G',
                    NUMREO = total number of steps of re-orthogonalization.        
    IPNTR   Integer array of length 11.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD and WORKL
            arrays for matrices/vectors used by the Lanczos iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X in WORKD.
            IPNTR(2): pointer to the current result vector Y in WORKD.
            IPNTR(3): pointer to the vector B * X in WORKD when used in 
                      the shift-and-invert mode.
            IPNTR(4): pointer to the next available location in WORKL
                      that is untouched by the program.
            IPNTR(5): pointer to the NCV by 2 tridiagonal matrix T in WORKL.
            IPNTR(6): pointer to the NCV RITZ values array in WORKL.
            IPNTR(7): pointer to the Ritz estimates in array WORKL associated
                      with the Ritz values located in RITZ in WORKL.
            IPNTR(11): pointer to the NP shifts in WORKL. See Remark 6 below.
            Note: IPNTR(8:10) is only referenced by dseupd . See Remark 2.
            IPNTR(8): pointer to the NCV RITZ values of the original system.
            IPNTR(9): pointer to the NCV corresponding error bounds.
            IPNTR(10): pointer to the NCV by NCV matrix of eigenvectors
                       of the tridiagonal matrix T. Only referenced by
                       dseupd  if RVEC = .TRUE. See Remarks.
            -------------------------------------------------------------
            
    WORKD   Double precision  work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD 
            as temporary workspace during the iteration. Upon termination
            WORKD(1:N) contains B*RESID(1:N). If the Ritz vectors are desired
            subroutine dseupd  uses this output.
            See Data Distribution Note below.  
    WORKL   Double precision  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  See Data Distribution Note below.
    LWORKL  Integer.  (INPUT)
            LWORKL must be at least NCV**2 + 8*NCV .
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =  0: Normal exit.
            =  1: Maximum number of iterations taken.
                  All possible eigenvalues of OP has been found. IPARAM(5)  
                  returns the number of wanted converged Ritz values.
            =  2: No longer an informational error. Deprecated starting
                  with release 2 of ARPACK.
            =  3: No shifts could be applied during a cycle of the 
                  Implicitly restarted Arnoldi iteration. One possibility 
                  is to increase the size of NCV relative to NEV. 
                  See remark 4 below.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV must be greater than NEV and less than or equal to N.
            = -4: The maximum number of Arnoldi update iterations allowed
                  must be greater than zero.
            = -5: WHICH must be one of 'LM', 'SM', 'LA', 'SA' or 'BE'.
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work array WORKL is not sufficient.
            = -8: Error return from trid. eigenvalue calculation;
                  Informatinal error from LAPACK routine dsteqr .
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4,5.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatable.
            = -12: IPARAM(1) must be equal to 0 or 1.
            = -13: NEV and WHICH = 'BE' are incompatable.
            = -9999: Could not build an Arnoldi factorization.
                     IPARAM(5) returns the size of the current Arnoldi
                     factorization. The user is advised to check that
                     enough workspace and array storage has been allocated.

  \Remarks
    1. The converged Ritz values are always returned in ascending 
       algebraic order.  The computed Ritz values are approximate
       eigenvalues of OP.  The selection of WHICH should be made
       with this in mind when Mode = 3,4,5.  After convergence, 
       approximate eigenvalues of the original problem may be obtained 
       with the ARPACK subroutine dseupd . 
    2. If the Ritz vectors corresponding to the converged Ritz values
       are needed, the user must call dseupd  immediately following completion
       of dsaupd . This is new starting with version 2.1 of ARPACK.
    3. If M can be factored into a Cholesky factorization M = LL`
       then Mode = 2 should not be selected.  Instead one should use
       Mode = 1 with  OP = inv(L)*A*inv(L`).  Appropriate triangular 
       linear systems should be solved with L and L` rather
       than computing inverses.  After convergence, an approximate
       eigenvector z of the original problem is recovered by solving
       L`z = x  where x is a Ritz vector of OP.
    4. At present there is no a-priori analysis to guide the selection
       of NCV relative to NEV.  The only formal requrement is that NCV > NEV.
       However, it is recommended that NCV .ge. 2*NEV.  If many problems of
       the same type are to be solved, one should experiment with increasing
       NCV while keeping NEV fixed for a given test problem.  This will 
       usually decrease the required number of OP*x operations but it
       also increases the work and storage required to maintain the orthogonal
       basis vectors.   The optimal "cross-over" with respect to CPU time
       is problem dependent and must be determined empirically.
    5. If IPARAM(7) = 2 then in the Reverse commuication interface the user
       must do the following. When IDO = 1, Y = OP * X is to be computed.
       When IPARAM(7) = 2 OP = inv(B)*A. After computing A*X the user
       must overwrite X with A*X. Y is then the solution to the linear set
       of equations B*Y = A*X.
    6. When IPARAM(1) = 0, and IDO = 3, the user needs to provide the 
       NP = IPARAM(8) shifts in locations: 
       1   WORKL(IPNTR(11))           
       2   WORKL(IPNTR(11)+1)         
                          .           
                          .           
                          .      
       NP  WORKL(IPNTR(11)+NP-1). 
       The eigenvalues of the current tridiagonal matrix are located in 
       WORKL(IPNTR(6)) through WORKL(IPNTR(6)+NCV-1). They are in the
       order defined by WHICH. The associated Ritz estimates are located in
       WORKL(IPNTR(8)), WORKL(IPNTR(8)+1), ... , WORKL(IPNTR(8)+NCV-1).
  -----------------------------------------------------------------------
  \Data Distribution Note:
    Fortran-D syntax:
    ================
    REAL       RESID(N), V(LDV,NCV), WORKD(3*N), WORKL(LWORKL)
    DECOMPOSE  D1(N), D2(N,NCV)
    ALIGN      RESID(I) with D1(I)
    ALIGN      V(I,J)   with D2(I,J)
    ALIGN      WORKD(I) with D1(I)     range (1:N)
    ALIGN      WORKD(I) with D1(I-N)   range (N+1:2*N)
    ALIGN      WORKD(I) with D1(I-2*N) range (2*N+1:3*N)
    DISTRIBUTE D1(BLOCK), D2(BLOCK,:)
    REPLICATED WORKL(LWORKL)
    Cray MPP syntax:
    ===============
    REAL       RESID(N), V(LDV,NCV), WORKD(N,3), WORKL(LWORKL)
    SHARED     RESID(BLOCK), V(BLOCK,:), WORKD(BLOCK,:)
    REPLICATED WORKL(LWORKL)
    
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
    8. R.B. Lehoucq, D.C. Sorensen, "Implementation of Some Spectral
       Transformations in a k-Step Arnoldi Method". In Preparation.
  \Routines called:
       dsaup2   ARPACK routine that implements the Implicitly Restarted
               Arnoldi Iteration.
       dstats   ARPACK routine that initialize timing and other statistics
               variables.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dvout    ARPACK utility routine that prints vectors.
       dlamch   LAPACK routine that determines machine constants.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.4' 
  \SCCS Information: @(#) 
   FILE: saupd.F   SID: 2.8   DATE OF SID: 04/10/01   RELEASE: 2 
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param ncv
   * @param v
   * @param ldv
   * @param iparam
   * @param ipntr
   * @param workd
   * @param workl
   * @param lworkl
   * @param info
   * 
   */
  abstract public void dsaupd(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, int nev, org.netlib.util.doubleW tol, double[] resid, int ncv, double[] v, int ldv, int[] iparam, int[] ipntr, double[] workd, double[] workl, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsaupd 
  \Description: 
    Reverse communication interface for the Implicitly Restarted Arnoldi 
    Iteration.  For symmetric problems this reduces to a variant of the Lanczos 
    method.  This method has been designed to compute approximations to a 
    few eigenpairs of a linear operator OP that is real and symmetric 
    with respect to a real positive semi-definite symmetric matrix B, 
    i.e.
                     
         B*OP = (OP`)*B.  
    Another way to express this condition is 
         < x,OPy > = < OPx,y >  where < z,w > = z`Bw  .
    
    In the standard eigenproblem B is the identity matrix.  
    ( A` denotes transpose of A)
    The computed approximate eigenvalues are called Ritz values and
    the corresponding approximate eigenvectors are called Ritz vectors.
    dsaupd  is usually called iteratively to solve one of the 
    following problems:
    Mode 1:  A*x = lambda*x, A symmetric 
             ===> OP = A  and  B = I.
    Mode 2:  A*x = lambda*M*x, A symmetric, M symmetric positive definite
             ===> OP = inv[M]*A  and  B = M.
             ===> (If M can be factored see remark 3 below)
    Mode 3:  K*x = lambda*M*x, K symmetric, M symmetric positive semi-definite
             ===> OP = (inv[K - sigma*M])*M  and  B = M. 
             ===> Shift-and-Invert mode
    Mode 4:  K*x = lambda*KG*x, K symmetric positive semi-definite, 
             KG symmetric indefinite
             ===> OP = (inv[K - sigma*KG])*K  and  B = K.
             ===> Buckling mode
    Mode 5:  A*x = lambda*M*x, A symmetric, M symmetric positive semi-definite
             ===> OP = inv[A - sigma*M]*[A + sigma*M]  and  B = M.
             ===> Cayley transformed mode
    NOTE: The action of w <- inv[A - sigma*M]*v or w <- inv[M]*v
          should be accomplished either by a direct method
          using a sparse matrix factorization and solving
             [A - sigma*M]*w = v  or M*w = v,
          or through an iterative method for solving these
          systems.  If an iterative method is used, the
          convergence test must be more stringent than
          the accuracy requirements for the eigenvalue
          approximations.
  \Usage:
    call dsaupd  
       ( IDO, BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM,
         IPNTR, WORKD, WORKL, LWORKL, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first 
            call to dsaupd .  IDO will be set internally to
            indicate the type of operation to be performed.  Control is
            then given back to the calling routine which has the
            responsibility to carry out the requested operation and call
            dsaupd  with the result.  The operand is given in
            WORKD(IPNTR(1)), the result must be put in WORKD(IPNTR(2)).
            (If Mode = 2 see remark 5 below)
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      In mode 3,4 and 5, the vector B * X is already
                      available in WORKD(ipntr(3)).  It does not
                      need to be recomputed in forming OP * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO =  3: compute the IPARAM(8) shifts where
                      IPNTR(11) is the pointer into WORKL for
                      placing the shifts. See remark 6 below.
            IDO = 99: done
            -------------------------------------------------------------
               
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    WHICH   Character*2.  (INPUT)
            Specify which of the Ritz values of OP to compute.
            'LA' - compute the NEV largest (algebraic) eigenvalues.
            'SA' - compute the NEV smallest (algebraic) eigenvalues.
            'LM' - compute the NEV largest (in magnitude) eigenvalues.
            'SM' - compute the NEV smallest (in magnitude) eigenvalues. 
            'BE' - compute NEV eigenvalues, half from each end of the
                   spectrum.  When NEV is odd, compute one more from the
                   high end than from the low end.
             (see remark 1 below)
    NEV     Integer.  (INPUT)
            Number of eigenvalues of OP to be computed. 0 < NEV < N.
    TOL     Double precision  scalar.  (INPUT)
            Stopping criterion: the relative accuracy of the Ritz value 
            is considered acceptable if BOUNDS(I) .LE. TOL*ABS(RITZ(I)).
            If TOL .LE. 0. is passed a default is set:
            DEFAULT = DLAMCH ('EPS')  (machine precision as computed
                      by the LAPACK auxiliary subroutine DLAMCH ).
    RESID   Double precision  array of length N.  (INPUT/OUTPUT)
            On INPUT: 
            If INFO .EQ. 0, a random initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            On OUTPUT:
            RESID contains the final residual vector. 
    NCV     Integer.  (INPUT)
            Number of columns of the matrix V (less than or equal to N).
            This will indicate how many Lanczos vectors are generated 
            at each iteration.  After the startup phase in which NEV 
            Lanczos vectors are generated, the algorithm generates 
            NCV-NEV Lanczos vectors at each subsequent update iteration.
            Most of the cost in generating each Lanczos vector is in the 
            matrix-vector product OP*x. (See remark 4 below).
    V       Double precision  N by NCV array.  (OUTPUT)
            The NCV columns of V contain the Lanczos basis vectors.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    IPARAM  Integer array of length 11.  (INPUT/OUTPUT)
            IPARAM(1) = ISHIFT: method for selecting the implicit shifts.
            The shifts selected at each iteration are used to restart
            the Arnoldi iteration in an implicit fashion.
            -------------------------------------------------------------
            ISHIFT = 0: the shifts are provided by the user via
                        reverse communication.  The NCV eigenvalues of
                        the current tridiagonal matrix T are returned in
                        the part of WORKL array corresponding to RITZ.
                        See remark 6 below.
            ISHIFT = 1: exact shifts with respect to the reduced 
                        tridiagonal matrix T.  This is equivalent to 
                        restarting the iteration with a starting vector 
                        that is a linear combination of Ritz vectors 
                        associated with the "wanted" Ritz values.
            -------------------------------------------------------------
            IPARAM(2) = LEVEC
            No longer referenced. See remark 2 below.
            IPARAM(3) = MXITER
            On INPUT:  maximum number of Arnoldi update iterations allowed. 
            On OUTPUT: actual number of Arnoldi update iterations taken. 
            IPARAM(4) = NB: blocksize to be used in the recurrence.
            The code currently works only for NB = 1.
            IPARAM(5) = NCONV: number of "converged" Ritz values.
            This represents the number of Ritz values that satisfy
            the convergence criterion.
            IPARAM(6) = IUPD
            No longer referenced. Implicit restarting is ALWAYS used. 
            IPARAM(7) = MODE
            On INPUT determines what type of eigenproblem is being solved.
            Must be 1,2,3,4,5; See under \Description of dsaupd  for the 
            five modes available.
            IPARAM(8) = NP
            When ido = 3 and the user provides shifts through reverse
            communication (IPARAM(1)=0), dsaupd  returns NP, the number
            of shifts the user is to provide. 0 < NP <=NCV-NEV. See Remark
            6 below.
            IPARAM(9) = NUMOP, IPARAM(10) = NUMOPB, IPARAM(11) = NUMREO,
            OUTPUT: NUMOP  = total number of OP*x operations,
                    NUMOPB = total number of B*x operations if BMAT='G',
                    NUMREO = total number of steps of re-orthogonalization.        
    IPNTR   Integer array of length 11.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD and WORKL
            arrays for matrices/vectors used by the Lanczos iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X in WORKD.
            IPNTR(2): pointer to the current result vector Y in WORKD.
            IPNTR(3): pointer to the vector B * X in WORKD when used in 
                      the shift-and-invert mode.
            IPNTR(4): pointer to the next available location in WORKL
                      that is untouched by the program.
            IPNTR(5): pointer to the NCV by 2 tridiagonal matrix T in WORKL.
            IPNTR(6): pointer to the NCV RITZ values array in WORKL.
            IPNTR(7): pointer to the Ritz estimates in array WORKL associated
                      with the Ritz values located in RITZ in WORKL.
            IPNTR(11): pointer to the NP shifts in WORKL. See Remark 6 below.
            Note: IPNTR(8:10) is only referenced by dseupd . See Remark 2.
            IPNTR(8): pointer to the NCV RITZ values of the original system.
            IPNTR(9): pointer to the NCV corresponding error bounds.
            IPNTR(10): pointer to the NCV by NCV matrix of eigenvectors
                       of the tridiagonal matrix T. Only referenced by
                       dseupd  if RVEC = .TRUE. See Remarks.
            -------------------------------------------------------------
            
    WORKD   Double precision  work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD 
            as temporary workspace during the iteration. Upon termination
            WORKD(1:N) contains B*RESID(1:N). If the Ritz vectors are desired
            subroutine dseupd  uses this output.
            See Data Distribution Note below.  
    WORKL   Double precision  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  See Data Distribution Note below.
    LWORKL  Integer.  (INPUT)
            LWORKL must be at least NCV**2 + 8*NCV .
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =  0: Normal exit.
            =  1: Maximum number of iterations taken.
                  All possible eigenvalues of OP has been found. IPARAM(5)  
                  returns the number of wanted converged Ritz values.
            =  2: No longer an informational error. Deprecated starting
                  with release 2 of ARPACK.
            =  3: No shifts could be applied during a cycle of the 
                  Implicitly restarted Arnoldi iteration. One possibility 
                  is to increase the size of NCV relative to NEV. 
                  See remark 4 below.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV must be greater than NEV and less than or equal to N.
            = -4: The maximum number of Arnoldi update iterations allowed
                  must be greater than zero.
            = -5: WHICH must be one of 'LM', 'SM', 'LA', 'SA' or 'BE'.
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work array WORKL is not sufficient.
            = -8: Error return from trid. eigenvalue calculation;
                  Informatinal error from LAPACK routine dsteqr .
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4,5.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatable.
            = -12: IPARAM(1) must be equal to 0 or 1.
            = -13: NEV and WHICH = 'BE' are incompatable.
            = -9999: Could not build an Arnoldi factorization.
                     IPARAM(5) returns the size of the current Arnoldi
                     factorization. The user is advised to check that
                     enough workspace and array storage has been allocated.

  \Remarks
    1. The converged Ritz values are always returned in ascending 
       algebraic order.  The computed Ritz values are approximate
       eigenvalues of OP.  The selection of WHICH should be made
       with this in mind when Mode = 3,4,5.  After convergence, 
       approximate eigenvalues of the original problem may be obtained 
       with the ARPACK subroutine dseupd . 
    2. If the Ritz vectors corresponding to the converged Ritz values
       are needed, the user must call dseupd  immediately following completion
       of dsaupd . This is new starting with version 2.1 of ARPACK.
    3. If M can be factored into a Cholesky factorization M = LL`
       then Mode = 2 should not be selected.  Instead one should use
       Mode = 1 with  OP = inv(L)*A*inv(L`).  Appropriate triangular 
       linear systems should be solved with L and L` rather
       than computing inverses.  After convergence, an approximate
       eigenvector z of the original problem is recovered by solving
       L`z = x  where x is a Ritz vector of OP.
    4. At present there is no a-priori analysis to guide the selection
       of NCV relative to NEV.  The only formal requrement is that NCV > NEV.
       However, it is recommended that NCV .ge. 2*NEV.  If many problems of
       the same type are to be solved, one should experiment with increasing
       NCV while keeping NEV fixed for a given test problem.  This will 
       usually decrease the required number of OP*x operations but it
       also increases the work and storage required to maintain the orthogonal
       basis vectors.   The optimal "cross-over" with respect to CPU time
       is problem dependent and must be determined empirically.
    5. If IPARAM(7) = 2 then in the Reverse commuication interface the user
       must do the following. When IDO = 1, Y = OP * X is to be computed.
       When IPARAM(7) = 2 OP = inv(B)*A. After computing A*X the user
       must overwrite X with A*X. Y is then the solution to the linear set
       of equations B*Y = A*X.
    6. When IPARAM(1) = 0, and IDO = 3, the user needs to provide the 
       NP = IPARAM(8) shifts in locations: 
       1   WORKL(IPNTR(11))           
       2   WORKL(IPNTR(11)+1)         
                          .           
                          .           
                          .      
       NP  WORKL(IPNTR(11)+NP-1). 
       The eigenvalues of the current tridiagonal matrix are located in 
       WORKL(IPNTR(6)) through WORKL(IPNTR(6)+NCV-1). They are in the
       order defined by WHICH. The associated Ritz estimates are located in
       WORKL(IPNTR(8)), WORKL(IPNTR(8)+1), ... , WORKL(IPNTR(8)+NCV-1).
  -----------------------------------------------------------------------
  \Data Distribution Note:
    Fortran-D syntax:
    ================
    REAL       RESID(N), V(LDV,NCV), WORKD(3*N), WORKL(LWORKL)
    DECOMPOSE  D1(N), D2(N,NCV)
    ALIGN      RESID(I) with D1(I)
    ALIGN      V(I,J)   with D2(I,J)
    ALIGN      WORKD(I) with D1(I)     range (1:N)
    ALIGN      WORKD(I) with D1(I-N)   range (N+1:2*N)
    ALIGN      WORKD(I) with D1(I-2*N) range (2*N+1:3*N)
    DISTRIBUTE D1(BLOCK), D2(BLOCK,:)
    REPLICATED WORKL(LWORKL)
    Cray MPP syntax:
    ===============
    REAL       RESID(N), V(LDV,NCV), WORKD(N,3), WORKL(LWORKL)
    SHARED     RESID(BLOCK), V(BLOCK,:), WORKD(BLOCK,:)
    REPLICATED WORKL(LWORKL)
    
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
    8. R.B. Lehoucq, D.C. Sorensen, "Implementation of Some Spectral
       Transformations in a k-Step Arnoldi Method". In Preparation.
  \Routines called:
       dsaup2   ARPACK routine that implements the Implicitly Restarted
               Arnoldi Iteration.
       dstats   ARPACK routine that initialize timing and other statistics
               variables.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dvout    ARPACK utility routine that prints vectors.
       dlamch   LAPACK routine that determines machine constants.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.4' 
  \SCCS Information: @(#) 
   FILE: saupd.F   SID: 2.8   DATE OF SID: 04/10/01   RELEASE: 2 
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param ncv
   * @param v
   * @param _v_offset
   * @param ldv
   * @param iparam
   * @param _iparam_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param workl
   * @param _workl_offset
   * @param lworkl
   * @param info
   * 
   */
  abstract public void dsaupd(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, int nev, org.netlib.util.doubleW tol, double[] resid, int _resid_offset, int ncv, double[] v, int _v_offset, int ldv, int[] iparam, int _iparam_offset, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, double[] workl, int _workl_offset, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsconv
  \Description: 
    Convergence testing for the symmetric Arnoldi eigenvalue routine.
  \Usage:
    call dsconv
       ( N, RITZ, BOUNDS, TOL, NCONV )
  \Arguments
    N       Integer.  (INPUT)
            Number of Ritz values to check for convergence.
    RITZ    Double precision array of length N.  (INPUT)
            The Ritz values to be checked for convergence.
    BOUNDS  Double precision array of length N.  (INPUT)
            Ritz estimates associated with the Ritz values in RITZ.
    TOL     Double precision scalar.  (INPUT)
            Desired relative accuracy for a Ritz value to be considered
            "converged".
    NCONV   Integer scalar.  (OUTPUT)
            Number of "converged" Ritz values.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Routines called:
       second  ARPACK utility routine for timing.
       dlamch  LAPACK routine that determines machine constants. 
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: sconv.F   SID: 2.4   DATE OF SID: 4/19/96   RELEASE: 2
  \Remarks
       1. Starting with version 2.4, this routine no longer uses the
          Parlett strategy using the gap conditions. 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param ritz
   * @param bounds
   * @param tol
   * @param nconv
   * 
   */
  abstract public void dsconv(int n, double[] ritz, double[] bounds, double tol, org.netlib.util.intW nconv);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsconv
  \Description: 
    Convergence testing for the symmetric Arnoldi eigenvalue routine.
  \Usage:
    call dsconv
       ( N, RITZ, BOUNDS, TOL, NCONV )
  \Arguments
    N       Integer.  (INPUT)
            Number of Ritz values to check for convergence.
    RITZ    Double precision array of length N.  (INPUT)
            The Ritz values to be checked for convergence.
    BOUNDS  Double precision array of length N.  (INPUT)
            Ritz estimates associated with the Ritz values in RITZ.
    TOL     Double precision scalar.  (INPUT)
            Desired relative accuracy for a Ritz value to be considered
            "converged".
    NCONV   Integer scalar.  (OUTPUT)
            Number of "converged" Ritz values.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Routines called:
       second  ARPACK utility routine for timing.
       dlamch  LAPACK routine that determines machine constants. 
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: sconv.F   SID: 2.4   DATE OF SID: 4/19/96   RELEASE: 2
  \Remarks
       1. Starting with version 2.4, this routine no longer uses the
          Parlett strategy using the gap conditions. 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param ritz
   * @param _ritz_offset
   * @param bounds
   * @param _bounds_offset
   * @param tol
   * @param nconv
   * 
   */
  abstract public void dsconv(int n, double[] ritz, int _ritz_offset, double[] bounds, int _bounds_offset, double tol, org.netlib.util.intW nconv);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dseigt
  \Description: 
    Compute the eigenvalues of the current symmetric tridiagonal matrix
    and the corresponding error bounds given the current residual norm.
  \Usage:
    call dseigt
       ( RNORM, N, H, LDH, EIG, BOUNDS, WORKL, IERR )
  \Arguments
    RNORM   Double precision scalar.  (INPUT)
            RNORM contains the residual norm corresponding to the current
            symmetric tridiagonal matrix H.
    N       Integer.  (INPUT)
            Size of the symmetric tridiagonal matrix H.
    H       Double precision N by 2 array.  (INPUT)
            H contains the symmetric tridiagonal matrix with the 
            subdiagonal in the first column starting at H(2,1) and the 
            main diagonal in second column.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    EIG     Double precision array of length N.  (OUTPUT)
            On output, EIG contains the N eigenvalues of H possibly 
            unsorted.  The BOUNDS arrays are returned in the
            same sorted order as EIG.
    BOUNDS  Double precision array of length N.  (OUTPUT)
            On output, BOUNDS contains the error estimates corresponding
            to the eigenvalues EIG.  This is equal to RNORM times the
            last components of the eigenvectors corresponding to the
            eigenvalues in EIG.
    WORKL   Double precision work array of length 3*N.  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.
    IERR    Integer.  (OUTPUT)
            Error exit flag from dstqrb.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dstqrb  ARPACK routine that computes the eigenvalues and the
               last components of the eigenvectors of a symmetric
               and tridiagonal matrix.
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dcopy   Level 1 BLAS that copies one vector to another.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: seigt.F   SID: 2.4   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rnorm
   * @param n
   * @param h
   * @param ldh
   * @param eig
   * @param bounds
   * @param workl
   * @param ierr
   * 
   */
  abstract public void dseigt(double rnorm, int n, double[] h, int ldh, double[] eig, double[] bounds, double[] workl, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dseigt
  \Description: 
    Compute the eigenvalues of the current symmetric tridiagonal matrix
    and the corresponding error bounds given the current residual norm.
  \Usage:
    call dseigt
       ( RNORM, N, H, LDH, EIG, BOUNDS, WORKL, IERR )
  \Arguments
    RNORM   Double precision scalar.  (INPUT)
            RNORM contains the residual norm corresponding to the current
            symmetric tridiagonal matrix H.
    N       Integer.  (INPUT)
            Size of the symmetric tridiagonal matrix H.
    H       Double precision N by 2 array.  (INPUT)
            H contains the symmetric tridiagonal matrix with the 
            subdiagonal in the first column starting at H(2,1) and the 
            main diagonal in second column.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    EIG     Double precision array of length N.  (OUTPUT)
            On output, EIG contains the N eigenvalues of H possibly 
            unsorted.  The BOUNDS arrays are returned in the
            same sorted order as EIG.
    BOUNDS  Double precision array of length N.  (OUTPUT)
            On output, BOUNDS contains the error estimates corresponding
            to the eigenvalues EIG.  This is equal to RNORM times the
            last components of the eigenvectors corresponding to the
            eigenvalues in EIG.
    WORKL   Double precision work array of length 3*N.  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.
    IERR    Integer.  (OUTPUT)
            Error exit flag from dstqrb.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dstqrb  ARPACK routine that computes the eigenvalues and the
               last components of the eigenvectors of a symmetric
               and tridiagonal matrix.
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dcopy   Level 1 BLAS that copies one vector to another.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: seigt.F   SID: 2.4   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rnorm
   * @param n
   * @param h
   * @param _h_offset
   * @param ldh
   * @param eig
   * @param _eig_offset
   * @param bounds
   * @param _bounds_offset
   * @param workl
   * @param _workl_offset
   * @param ierr
   * 
   */
  abstract public void dseigt(double rnorm, int n, double[] h, int _h_offset, int ldh, double[] eig, int _eig_offset, double[] bounds, int _bounds_offset, double[] workl, int _workl_offset, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsesrt
  \Description:
    Sort the array X in the order specified by WHICH and optionally 
    apply the permutation to the columns of the matrix A.
  \Usage:
    call dsesrt
       ( WHICH, APPLY, N, X, NA, A, LDA)
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> X is sorted into increasing order of magnitude.
            'SM' -> X is sorted into decreasing order of magnitude.
            'LA' -> X is sorted into increasing order of algebraic.
            'SA' -> X is sorted into decreasing order of algebraic.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to A.
            APPLY = .FALSE. -> do not apply the sorted order to A.
    N       Integer.  (INPUT)
            Dimension of the array X.
    X      Double precision array of length N.  (INPUT/OUTPUT)
            The array to be sorted.
    NA      Integer.  (INPUT)
            Number of rows of the matrix A.
    A      Double precision array of length NA by N.  (INPUT/OUTPUT)
           
    LDA     Integer.  (INPUT)
            Leading dimension of A.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Routines
       dswap  Level 1 BLAS that swaps the contents of two vectors.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/15/93: Version ' 2.1'.
                 Adapted from the sort routine in LANSO and 
                 the ARPACK code dsortr
  \SCCS Information: @(#) 
   FILE: sesrt.F   SID: 2.3   DATE OF SID: 4/19/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param x
   * @param na
   * @param a
   * @param lda
   * 
   */
  abstract public void dsesrt(java.lang.String which, boolean apply, int n, double[] x, int na, double[] a, int lda);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsesrt
  \Description:
    Sort the array X in the order specified by WHICH and optionally 
    apply the permutation to the columns of the matrix A.
  \Usage:
    call dsesrt
       ( WHICH, APPLY, N, X, NA, A, LDA)
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> X is sorted into increasing order of magnitude.
            'SM' -> X is sorted into decreasing order of magnitude.
            'LA' -> X is sorted into increasing order of algebraic.
            'SA' -> X is sorted into decreasing order of algebraic.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to A.
            APPLY = .FALSE. -> do not apply the sorted order to A.
    N       Integer.  (INPUT)
            Dimension of the array X.
    X      Double precision array of length N.  (INPUT/OUTPUT)
            The array to be sorted.
    NA      Integer.  (INPUT)
            Number of rows of the matrix A.
    A      Double precision array of length NA by N.  (INPUT/OUTPUT)
           
    LDA     Integer.  (INPUT)
            Leading dimension of A.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Routines
       dswap  Level 1 BLAS that swaps the contents of two vectors.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/15/93: Version ' 2.1'.
                 Adapted from the sort routine in LANSO and 
                 the ARPACK code dsortr
  \SCCS Information: @(#) 
   FILE: sesrt.F   SID: 2.3   DATE OF SID: 4/19/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param x
   * @param _x_offset
   * @param na
   * @param a
   * @param _a_offset
   * @param lda
   * 
   */
  abstract public void dsesrt(java.lang.String which, boolean apply, int n, double[] x, int _x_offset, int na, double[] a, int _a_offset, int lda);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: dseupd 
  \Description: 
    This subroutine returns the converged approximations to eigenvalues
    of A*z = lambda*B*z and (optionally):
        (1) the corresponding approximate eigenvectors,
        (2) an orthonormal (Lanczos) basis for the associated approximate
            invariant subspace,
        (3) Both.
    There is negligible additional cost to obtain eigenvectors.  An orthonormal
    (Lanczos) basis is always computed.  There is an additional storage cost 
    of n*nev if both are requested (in this case a separate array Z must be 
    supplied).
    These quantities are obtained from the Lanczos factorization computed
    by DSAUPD  for the linear operator OP prescribed by the MODE selection
    (see IPARAM(7) in DSAUPD  documentation.)  DSAUPD  must be called before
    this routine is called. These approximate eigenvalues and vectors are 
    commonly called Ritz values and Ritz vectors respectively.  They are 
    referred to as such in the comments that follow.   The computed orthonormal 
    basis for the invariant subspace corresponding to these Ritz values is 
    referred to as a Lanczos basis.
    See documentation in the header of the subroutine DSAUPD  for a definition 
    of OP as well as other terms and the relation of computed Ritz values 
    and vectors of OP with respect to the given problem  A*z = lambda*B*z.  
    The approximate eigenvalues of the original problem are returned in
    ascending algebraic order.  The user may elect to call this routine
    once for each desired Ritz vector and store it peripherally if desired.
    There is also the option of computing a selected set of these vectors
    with a single call.
  \Usage:
    call dseupd  
       ( RVEC, HOWMNY, SELECT, D, Z, LDZ, SIGMA, BMAT, N, WHICH, NEV, TOL,
         RESID, NCV, V, LDV, IPARAM, IPNTR, WORKD, WORKL, LWORKL, INFO )
    RVEC    LOGICAL  (INPUT) 
            Specifies whether Ritz vectors corresponding to the Ritz value 
            approximations to the eigenproblem A*z = lambda*B*z are computed.
               RVEC = .FALSE.     Compute Ritz values only.
               RVEC = .TRUE.      Compute Ritz vectors.
    HOWMNY  Character*1  (INPUT) 
            Specifies how many Ritz vectors are wanted and the form of Z
            the matrix of Ritz vectors. See remark 1 below.
            = 'A': compute NEV Ritz vectors;
            = 'S': compute some of the Ritz vectors, specified
                   by the logical array SELECT.
    SELECT  Logical array of dimension NCV.  (INPUT/WORKSPACE)
            If HOWMNY = 'S', SELECT specifies the Ritz vectors to be
            computed. To select the Ritz vector corresponding to a
            Ritz value D(j), SELECT(j) must be set to .TRUE.. 
            If HOWMNY = 'A' , SELECT is used as a workspace for
            reordering the Ritz values.
    D       Double precision  array of dimension NEV.  (OUTPUT)
            On exit, D contains the Ritz value approximations to the
            eigenvalues of A*z = lambda*B*z. The values are returned
            in ascending order. If IPARAM(7) = 3,4,5 then D represents
            the Ritz values of OP computed by dsaupd  transformed to
            those of the original eigensystem A*z = lambda*B*z. If 
            IPARAM(7) = 1,2 then the Ritz values of OP are the same 
            as the those of A*z = lambda*B*z.
    Z       Double precision  N by NEV array if HOWMNY = 'A'.  (OUTPUT)
            On exit, Z contains the B-orthonormal Ritz vectors of the
            eigensystem A*z = lambda*B*z corresponding to the Ritz
            value approximations.
            If  RVEC = .FALSE. then Z is not referenced.
            NOTE: The array Z may be set equal to first NEV columns of the 
            Arnoldi/Lanczos basis array V computed by DSAUPD .
    LDZ     Integer.  (INPUT)
            The leading dimension of the array Z.  If Ritz vectors are
            desired, then  LDZ .ge.  max( 1, N ).  In any case,  LDZ .ge. 1.
    SIGMA   Double precision   (INPUT)
            If IPARAM(7) = 3,4,5 represents the shift. Not referenced if
            IPARAM(7) = 1 or 2.

    **** The remaining arguments MUST be the same as for the   ****
    **** call to DSAUPD  that was just completed.               ****
    NOTE: The remaining arguments
             BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR,
             WORKD, WORKL, LWORKL, INFO
           must be passed directly to DSEUPD  following the last call
           to DSAUPD .  These arguments MUST NOT BE MODIFIED between
           the the last call to DSAUPD  and the call to DSEUPD .
    Two of these parameters (WORKL, INFO) are also output parameters:
    WORKL   Double precision  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            WORKL(1:4*ncv) contains information obtained in
            dsaupd .  They are not changed by dseupd .
            WORKL(4*ncv+1:ncv*ncv+8*ncv) holds the
            untransformed Ritz values, the computed error estimates,
            and the associated eigenvector matrix of H.
            Note: IPNTR(8:10) contains the pointer into WORKL for addresses
            of the above information computed by dseupd .
            -------------------------------------------------------------
            IPNTR(8): pointer to the NCV RITZ values of the original system.
            IPNTR(9): pointer to the NCV corresponding error bounds.
            IPNTR(10): pointer to the NCV by NCV matrix of eigenvectors
                       of the tridiagonal matrix T. Only referenced by
                       dseupd  if RVEC = .TRUE. See Remarks.
            -------------------------------------------------------------
    INFO    Integer.  (OUTPUT)
            Error flag on output.
            =  0: Normal exit.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV must be greater than NEV and less than or equal to N.
            = -5: WHICH must be one of 'LM', 'SM', 'LA', 'SA' or 'BE'.
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work WORKL array is not sufficient.
            = -8: Error return from trid. eigenvalue calculation;
                  Information error from LAPACK routine dsteqr .
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4,5.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatible.
            = -12: NEV and WHICH = 'BE' are incompatible.
            = -14: DSAUPD  did not find any eigenvalues to sufficient
                   accuracy.
            = -15: HOWMNY must be one of 'A' or 'S' if RVEC = .true.
            = -16: HOWMNY = 'S' not yet implemented
            = -17: DSEUPD  got a different count of the number of converged
                   Ritz values than DSAUPD  got.  This indicates the user
                   probably made an error in passing data from DSAUPD  to
                   DSEUPD  or that the data was modified before entering 
                   DSEUPD .
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
  \Remarks
    1. The converged Ritz values are always returned in increasing 
       (algebraic) order.
    2. Currently only HOWMNY = 'A' is implemented. It is included at this
       stage for the user who wants to incorporate it. 
  \Routines called:
       dsesrt   ARPACK routine that sorts an array X, and applies the
               corresponding permutation to a matrix A.
       dsortr   dsortr   ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       dvout    ARPACK utility routine that prints vectors.
       dgeqr2   LAPACK routine that computes the QR factorization of
               a matrix.
       dlacpy   LAPACK matrix copy routine.
       dlamch   LAPACK routine that determines machine constants.
       dorm2r   LAPACK routine that applies an orthogonal matrix in
               factored form.
       dsteqr   LAPACK routine that computes eigenvalues and eigenvectors
               of a tridiagonal matrix.
       dger     Level 2 BLAS rank one update to a matrix.
       dcopy    Level 1 BLAS that copies one vector to another .
       dnrm2    Level 1 BLAS that computes the norm of a vector.
       dscal    Level 1 BLAS that scales a vector.
       dswap    Level 1 BLAS that swaps the contents of two vectors.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Chao Yang                    Houston, Texas
       Dept. of Computational & 
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: seupd.F   SID: 2.11   DATE OF SID: 04/10/01   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rvec
   * @param howmny
   * @param select
   * @param d
   * @param z
   * @param ldz
   * @param sigma
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param ncv
   * @param v
   * @param ldv
   * @param iparam
   * @param ipntr
   * @param workd
   * @param workl
   * @param lworkl
   * @param info
   * 
   */
  abstract public void dseupd(boolean rvec, java.lang.String howmny, boolean[] select, double[] d, double[] z, int ldz, double sigma, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, double tol, double[] resid, int ncv, double[] v, int ldv, int[] iparam, int[] ipntr, double[] workd, double[] workl, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: dseupd 
  \Description: 
    This subroutine returns the converged approximations to eigenvalues
    of A*z = lambda*B*z and (optionally):
        (1) the corresponding approximate eigenvectors,
        (2) an orthonormal (Lanczos) basis for the associated approximate
            invariant subspace,
        (3) Both.
    There is negligible additional cost to obtain eigenvectors.  An orthonormal
    (Lanczos) basis is always computed.  There is an additional storage cost 
    of n*nev if both are requested (in this case a separate array Z must be 
    supplied).
    These quantities are obtained from the Lanczos factorization computed
    by DSAUPD  for the linear operator OP prescribed by the MODE selection
    (see IPARAM(7) in DSAUPD  documentation.)  DSAUPD  must be called before
    this routine is called. These approximate eigenvalues and vectors are 
    commonly called Ritz values and Ritz vectors respectively.  They are 
    referred to as such in the comments that follow.   The computed orthonormal 
    basis for the invariant subspace corresponding to these Ritz values is 
    referred to as a Lanczos basis.
    See documentation in the header of the subroutine DSAUPD  for a definition 
    of OP as well as other terms and the relation of computed Ritz values 
    and vectors of OP with respect to the given problem  A*z = lambda*B*z.  
    The approximate eigenvalues of the original problem are returned in
    ascending algebraic order.  The user may elect to call this routine
    once for each desired Ritz vector and store it peripherally if desired.
    There is also the option of computing a selected set of these vectors
    with a single call.
  \Usage:
    call dseupd  
       ( RVEC, HOWMNY, SELECT, D, Z, LDZ, SIGMA, BMAT, N, WHICH, NEV, TOL,
         RESID, NCV, V, LDV, IPARAM, IPNTR, WORKD, WORKL, LWORKL, INFO )
    RVEC    LOGICAL  (INPUT) 
            Specifies whether Ritz vectors corresponding to the Ritz value 
            approximations to the eigenproblem A*z = lambda*B*z are computed.
               RVEC = .FALSE.     Compute Ritz values only.
               RVEC = .TRUE.      Compute Ritz vectors.
    HOWMNY  Character*1  (INPUT) 
            Specifies how many Ritz vectors are wanted and the form of Z
            the matrix of Ritz vectors. See remark 1 below.
            = 'A': compute NEV Ritz vectors;
            = 'S': compute some of the Ritz vectors, specified
                   by the logical array SELECT.
    SELECT  Logical array of dimension NCV.  (INPUT/WORKSPACE)
            If HOWMNY = 'S', SELECT specifies the Ritz vectors to be
            computed. To select the Ritz vector corresponding to a
            Ritz value D(j), SELECT(j) must be set to .TRUE.. 
            If HOWMNY = 'A' , SELECT is used as a workspace for
            reordering the Ritz values.
    D       Double precision  array of dimension NEV.  (OUTPUT)
            On exit, D contains the Ritz value approximations to the
            eigenvalues of A*z = lambda*B*z. The values are returned
            in ascending order. If IPARAM(7) = 3,4,5 then D represents
            the Ritz values of OP computed by dsaupd  transformed to
            those of the original eigensystem A*z = lambda*B*z. If 
            IPARAM(7) = 1,2 then the Ritz values of OP are the same 
            as the those of A*z = lambda*B*z.
    Z       Double precision  N by NEV array if HOWMNY = 'A'.  (OUTPUT)
            On exit, Z contains the B-orthonormal Ritz vectors of the
            eigensystem A*z = lambda*B*z corresponding to the Ritz
            value approximations.
            If  RVEC = .FALSE. then Z is not referenced.
            NOTE: The array Z may be set equal to first NEV columns of the 
            Arnoldi/Lanczos basis array V computed by DSAUPD .
    LDZ     Integer.  (INPUT)
            The leading dimension of the array Z.  If Ritz vectors are
            desired, then  LDZ .ge.  max( 1, N ).  In any case,  LDZ .ge. 1.
    SIGMA   Double precision   (INPUT)
            If IPARAM(7) = 3,4,5 represents the shift. Not referenced if
            IPARAM(7) = 1 or 2.

    **** The remaining arguments MUST be the same as for the   ****
    **** call to DSAUPD  that was just completed.               ****
    NOTE: The remaining arguments
             BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR,
             WORKD, WORKL, LWORKL, INFO
           must be passed directly to DSEUPD  following the last call
           to DSAUPD .  These arguments MUST NOT BE MODIFIED between
           the the last call to DSAUPD  and the call to DSEUPD .
    Two of these parameters (WORKL, INFO) are also output parameters:
    WORKL   Double precision  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            WORKL(1:4*ncv) contains information obtained in
            dsaupd .  They are not changed by dseupd .
            WORKL(4*ncv+1:ncv*ncv+8*ncv) holds the
            untransformed Ritz values, the computed error estimates,
            and the associated eigenvector matrix of H.
            Note: IPNTR(8:10) contains the pointer into WORKL for addresses
            of the above information computed by dseupd .
            -------------------------------------------------------------
            IPNTR(8): pointer to the NCV RITZ values of the original system.
            IPNTR(9): pointer to the NCV corresponding error bounds.
            IPNTR(10): pointer to the NCV by NCV matrix of eigenvectors
                       of the tridiagonal matrix T. Only referenced by
                       dseupd  if RVEC = .TRUE. See Remarks.
            -------------------------------------------------------------
    INFO    Integer.  (OUTPUT)
            Error flag on output.
            =  0: Normal exit.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV must be greater than NEV and less than or equal to N.
            = -5: WHICH must be one of 'LM', 'SM', 'LA', 'SA' or 'BE'.
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work WORKL array is not sufficient.
            = -8: Error return from trid. eigenvalue calculation;
                  Information error from LAPACK routine dsteqr .
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4,5.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatible.
            = -12: NEV and WHICH = 'BE' are incompatible.
            = -14: DSAUPD  did not find any eigenvalues to sufficient
                   accuracy.
            = -15: HOWMNY must be one of 'A' or 'S' if RVEC = .true.
            = -16: HOWMNY = 'S' not yet implemented
            = -17: DSEUPD  got a different count of the number of converged
                   Ritz values than DSAUPD  got.  This indicates the user
                   probably made an error in passing data from DSAUPD  to
                   DSEUPD  or that the data was modified before entering 
                   DSEUPD .
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
  \Remarks
    1. The converged Ritz values are always returned in increasing 
       (algebraic) order.
    2. Currently only HOWMNY = 'A' is implemented. It is included at this
       stage for the user who wants to incorporate it. 
  \Routines called:
       dsesrt   ARPACK routine that sorts an array X, and applies the
               corresponding permutation to a matrix A.
       dsortr   dsortr   ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       dvout    ARPACK utility routine that prints vectors.
       dgeqr2   LAPACK routine that computes the QR factorization of
               a matrix.
       dlacpy   LAPACK matrix copy routine.
       dlamch   LAPACK routine that determines machine constants.
       dorm2r   LAPACK routine that applies an orthogonal matrix in
               factored form.
       dsteqr   LAPACK routine that computes eigenvalues and eigenvectors
               of a tridiagonal matrix.
       dger     Level 2 BLAS rank one update to a matrix.
       dcopy    Level 1 BLAS that copies one vector to another .
       dnrm2    Level 1 BLAS that computes the norm of a vector.
       dscal    Level 1 BLAS that scales a vector.
       dswap    Level 1 BLAS that swaps the contents of two vectors.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Chao Yang                    Houston, Texas
       Dept. of Computational & 
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: seupd.F   SID: 2.11   DATE OF SID: 04/10/01   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rvec
   * @param howmny
   * @param select
   * @param _select_offset
   * @param d
   * @param _d_offset
   * @param z
   * @param _z_offset
   * @param ldz
   * @param sigma
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param ncv
   * @param v
   * @param _v_offset
   * @param ldv
   * @param iparam
   * @param _iparam_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param workl
   * @param _workl_offset
   * @param lworkl
   * @param info
   * 
   */
  abstract public void dseupd(boolean rvec, java.lang.String howmny, boolean[] select, int _select_offset, double[] d, int _d_offset, double[] z, int _z_offset, int ldz, double sigma, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, double tol, double[] resid, int _resid_offset, int ncv, double[] v, int _v_offset, int ldv, int[] iparam, int _iparam_offset, int[] ipntr, int _ipntr_offset, double[] workd, int _workd_offset, double[] workl, int _workl_offset, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsgets
  \Description: 
    Given the eigenvalues of the symmetric tridiagonal matrix H,
    computes the NP shifts AMU that are zeros of the polynomial of 
    degree NP which filters out components of the unwanted eigenvectors 
    corresponding to the AMU's based on some given criteria.
    NOTE: This is called even in the case of user specified shifts in 
    order to sort the eigenvalues, and error bounds of H for later use.
  \Usage:
    call dsgets
       ( ISHIFT, WHICH, KEV, NP, RITZ, BOUNDS, SHIFTS )
  \Arguments
    ISHIFT  Integer.  (INPUT)
            Method for selecting the implicit shifts at each iteration.
            ISHIFT = 0: user specified shifts
            ISHIFT = 1: exact shift with respect to the matrix H.
    WHICH   Character*2.  (INPUT)
            Shift selection criteria.
            'LM' -> KEV eigenvalues of largest magnitude are retained.
            'SM' -> KEV eigenvalues of smallest magnitude are retained.
            'LA' -> KEV eigenvalues of largest value are retained.
            'SA' -> KEV eigenvalues of smallest value are retained.
            'BE' -> KEV eigenvalues, half from each end of the spectrum.
                    If KEV is odd, compute one more from the high end.
    KEV      Integer.  (INPUT)
            KEV+NP is the size of the matrix H.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be computed.
    RITZ    Double precision array of length KEV+NP.  (INPUT/OUTPUT)
            On INPUT, RITZ contains the eigenvalues of H.
            On OUTPUT, RITZ are sorted so that the unwanted eigenvalues 
            are in the first NP locations and the wanted part is in 
            the last KEV locations.  When exact shifts are selected, the
            unwanted part corresponds to the shifts to be applied.
    BOUNDS  Double precision array of length KEV+NP.  (INPUT/OUTPUT)
            Error bounds corresponding to the ordering in RITZ.
    SHIFTS  Double precision array of length NP.  (INPUT/OUTPUT)
            On INPUT:  contains the user specified shifts if ISHIFT = 0.
            On OUTPUT: contains the shifts sorted into decreasing order 
            of magnitude with respect to the Ritz estimates contained in
            BOUNDS. If ISHIFT = 0, SHIFTS is not modified on exit.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dsortr  ARPACK utility sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dcopy   Level 1 BLAS that copies one vector to another.
       dswap   Level 1 BLAS that swaps the contents of two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/93: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: sgets.F   SID: 2.4   DATE OF SID: 4/19/96   RELEASE: 2
  \Remarks
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ishift
   * @param which
   * @param kev
   * @param np
   * @param ritz
   * @param bounds
   * @param shifts
   * 
   */
  abstract public void dsgets(int ishift, java.lang.String which, org.netlib.util.intW kev, org.netlib.util.intW np, double[] ritz, double[] bounds, double[] shifts);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsgets
  \Description: 
    Given the eigenvalues of the symmetric tridiagonal matrix H,
    computes the NP shifts AMU that are zeros of the polynomial of 
    degree NP which filters out components of the unwanted eigenvectors 
    corresponding to the AMU's based on some given criteria.
    NOTE: This is called even in the case of user specified shifts in 
    order to sort the eigenvalues, and error bounds of H for later use.
  \Usage:
    call dsgets
       ( ISHIFT, WHICH, KEV, NP, RITZ, BOUNDS, SHIFTS )
  \Arguments
    ISHIFT  Integer.  (INPUT)
            Method for selecting the implicit shifts at each iteration.
            ISHIFT = 0: user specified shifts
            ISHIFT = 1: exact shift with respect to the matrix H.
    WHICH   Character*2.  (INPUT)
            Shift selection criteria.
            'LM' -> KEV eigenvalues of largest magnitude are retained.
            'SM' -> KEV eigenvalues of smallest magnitude are retained.
            'LA' -> KEV eigenvalues of largest value are retained.
            'SA' -> KEV eigenvalues of smallest value are retained.
            'BE' -> KEV eigenvalues, half from each end of the spectrum.
                    If KEV is odd, compute one more from the high end.
    KEV      Integer.  (INPUT)
            KEV+NP is the size of the matrix H.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be computed.
    RITZ    Double precision array of length KEV+NP.  (INPUT/OUTPUT)
            On INPUT, RITZ contains the eigenvalues of H.
            On OUTPUT, RITZ are sorted so that the unwanted eigenvalues 
            are in the first NP locations and the wanted part is in 
            the last KEV locations.  When exact shifts are selected, the
            unwanted part corresponds to the shifts to be applied.
    BOUNDS  Double precision array of length KEV+NP.  (INPUT/OUTPUT)
            Error bounds corresponding to the ordering in RITZ.
    SHIFTS  Double precision array of length NP.  (INPUT/OUTPUT)
            On INPUT:  contains the user specified shifts if ISHIFT = 0.
            On OUTPUT: contains the shifts sorted into decreasing order 
            of magnitude with respect to the Ritz estimates contained in
            BOUNDS. If ISHIFT = 0, SHIFTS is not modified on exit.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       dsortr  ARPACK utility sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       dvout   ARPACK utility routine that prints vectors.
       dcopy   Level 1 BLAS that copies one vector to another.
       dswap   Level 1 BLAS that swaps the contents of two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/93: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: sgets.F   SID: 2.4   DATE OF SID: 4/19/96   RELEASE: 2
  \Remarks
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ishift
   * @param which
   * @param kev
   * @param np
   * @param ritz
   * @param _ritz_offset
   * @param bounds
   * @param _bounds_offset
   * @param shifts
   * @param _shifts_offset
   * 
   */
  abstract public void dsgets(int ishift, java.lang.String which, org.netlib.util.intW kev, org.netlib.util.intW np, double[] ritz, int _ritz_offset, double[] bounds, int _bounds_offset, double[] shifts, int _shifts_offset);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsortc
  \Description:
    Sorts the complex array in XREAL and XIMAG into the order 
    specified by WHICH and optionally applies the permutation to the
    real array Y. It is assumed that if an element of XIMAG is
    nonzero, then its negative is also an element. In other words,
    both members of a complex conjugate pair are to be sorted and the
    pairs are kept adjacent to each other.
  \Usage:
    call dsortc
       ( WHICH, APPLY, N, XREAL, XIMAG, Y )
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> sort XREAL,XIMAG into increasing order of magnitude.
            'SM' -> sort XREAL,XIMAG into decreasing order of magnitude.
            'LR' -> sort XREAL into increasing order of algebraic.
            'SR' -> sort XREAL into decreasing order of algebraic.
            'LI' -> sort XIMAG into increasing order of magnitude.
            'SI' -> sort XIMAG into decreasing order of magnitude.
            NOTE: If an element of XIMAG is non-zero, then its negative
                  is also an element.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to array Y.
            APPLY = .FALSE. -> do not apply the sorted order to array Y.
    N       Integer.  (INPUT)
            Size of the arrays.
    XREAL,  Double precision array of length N.  (INPUT/OUTPUT)
    XIMAG   Real and imaginary part of the array to be sorted.
    Y       Double precision array of length N.  (INPUT/OUTPUT)
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.1'
                 Adapted from the sort routine in LANSO.
  \SCCS Information: @(#) 
   FILE: sortc.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param xreal
   * @param ximag
   * @param y
   * 
   */
  abstract public void dsortc(java.lang.String which, boolean apply, int n, double[] xreal, double[] ximag, double[] y);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsortc
  \Description:
    Sorts the complex array in XREAL and XIMAG into the order 
    specified by WHICH and optionally applies the permutation to the
    real array Y. It is assumed that if an element of XIMAG is
    nonzero, then its negative is also an element. In other words,
    both members of a complex conjugate pair are to be sorted and the
    pairs are kept adjacent to each other.
  \Usage:
    call dsortc
       ( WHICH, APPLY, N, XREAL, XIMAG, Y )
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> sort XREAL,XIMAG into increasing order of magnitude.
            'SM' -> sort XREAL,XIMAG into decreasing order of magnitude.
            'LR' -> sort XREAL into increasing order of algebraic.
            'SR' -> sort XREAL into decreasing order of algebraic.
            'LI' -> sort XIMAG into increasing order of magnitude.
            'SI' -> sort XIMAG into decreasing order of magnitude.
            NOTE: If an element of XIMAG is non-zero, then its negative
                  is also an element.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to array Y.
            APPLY = .FALSE. -> do not apply the sorted order to array Y.
    N       Integer.  (INPUT)
            Size of the arrays.
    XREAL,  Double precision array of length N.  (INPUT/OUTPUT)
    XIMAG   Real and imaginary part of the array to be sorted.
    Y       Double precision array of length N.  (INPUT/OUTPUT)
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.1'
                 Adapted from the sort routine in LANSO.
  \SCCS Information: @(#) 
   FILE: sortc.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param xreal
   * @param _xreal_offset
   * @param ximag
   * @param _ximag_offset
   * @param y
   * @param _y_offset
   * 
   */
  abstract public void dsortc(java.lang.String which, boolean apply, int n, double[] xreal, int _xreal_offset, double[] ximag, int _ximag_offset, double[] y, int _y_offset);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsortr
  \Description:
    Sort the array X1 in the order specified by WHICH and optionally 
    applies the permutation to the array X2.
  \Usage:
    call dsortr
       ( WHICH, APPLY, N, X1, X2 )
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> X1 is sorted into increasing order of magnitude.
            'SM' -> X1 is sorted into decreasing order of magnitude.
            'LA' -> X1 is sorted into increasing order of algebraic.
            'SA' -> X1 is sorted into decreasing order of algebraic.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to X2.
            APPLY = .FALSE. -> do not apply the sorted order to X2.
    N       Integer.  (INPUT)
            Size of the arrays.
    X1      Double precision array of length N.  (INPUT/OUTPUT)
            The array to be sorted.
    X2      Double precision array of length N.  (INPUT/OUTPUT)
            Only referenced if APPLY = .TRUE.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/16/93: Version ' 2.1'.
                 Adapted from the sort routine in LANSO.
  \SCCS Information: @(#) 
   FILE: sortr.F   SID: 2.3   DATE OF SID: 4/19/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param x1
   * @param x2
   * 
   */
  abstract public void dsortr(java.lang.String which, boolean apply, int n, double[] x1, double[] x2);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dsortr
  \Description:
    Sort the array X1 in the order specified by WHICH and optionally 
    applies the permutation to the array X2.
  \Usage:
    call dsortr
       ( WHICH, APPLY, N, X1, X2 )
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> X1 is sorted into increasing order of magnitude.
            'SM' -> X1 is sorted into decreasing order of magnitude.
            'LA' -> X1 is sorted into increasing order of algebraic.
            'SA' -> X1 is sorted into decreasing order of algebraic.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to X2.
            APPLY = .FALSE. -> do not apply the sorted order to X2.
    N       Integer.  (INPUT)
            Size of the arrays.
    X1      Double precision array of length N.  (INPUT/OUTPUT)
            The array to be sorted.
    X2      Double precision array of length N.  (INPUT/OUTPUT)
            Only referenced if APPLY = .TRUE.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/16/93: Version ' 2.1'.
                 Adapted from the sort routine in LANSO.
  \SCCS Information: @(#) 
   FILE: sortr.F   SID: 2.3   DATE OF SID: 4/19/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param x1
   * @param _x1_offset
   * @param x2
   * @param _x2_offset
   * 
   */
  abstract public void dsortr(java.lang.String which, boolean apply, int n, double[] x1, int _x1_offset, double[] x2, int _x2_offset);

  /**
   * <pre><code>
       %---------------------------------------------%
       | Initialize statistic and timing information |
       | for nonsymmetric Arnoldi code.              |
       %---------------------------------------------%
   * </code></pre>
   *
   * 
   */
  abstract public void dstatn();

  /**
   * <pre><code>
       %---------------------------------------------%
       | Initialize statistic and timing information |
       | for symmetric Arnoldi code.                 |
       %---------------------------------------------%
   * </code></pre>
   *
   * 
   */
  abstract public void dstats();

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dstqrb
  \Description:
    Computes all eigenvalues and the last component of the eigenvectors
    of a symmetric tridiagonal matrix using the implicit QL or QR method.
    This is mostly a modification of the LAPACK routine dsteqr.
    See Remarks.
  \Usage:
    call dstqrb
       ( N, D, E, Z, WORK, INFO )
  \Arguments
    N       Integer.  (INPUT)
            The number of rows and columns in the matrix.  N >= 0.
    D       Double precision array, dimension (N).  (INPUT/OUTPUT)
            On entry, D contains the diagonal elements of the
            tridiagonal matrix.
            On exit, D contains the eigenvalues, in ascending order.
            If an error exit is made, the eigenvalues are correct
            for indices 1,2,...,INFO-1, but they are unordered and
            may not be the smallest eigenvalues of the matrix.
    E       Double precision array, dimension (N-1).  (INPUT/OUTPUT)
            On entry, E contains the subdiagonal elements of the
            tridiagonal matrix in positions 1 through N-1.
            On exit, E has been destroyed.
    Z       Double precision array, dimension (N).  (OUTPUT)
            On exit, Z contains the last row of the orthonormal 
            eigenvector matrix of the symmetric tridiagonal matrix.  
            If an error exit is made, Z contains the last row of the
            eigenvector matrix associated with the stored eigenvalues.
    WORK    Double precision array, dimension (max(1,2*N-2)).  (WORKSPACE)
            Workspace used in accumulating the transformation for 
            computing the last components of the eigenvectors.
    INFO    Integer.  (OUTPUT)
            = 0:  normal return.
            < 0:  if INFO = -i, the i-th argument had an illegal value.
            > 0:  if INFO = +i, the i-th eigenvalue has not converged
                                after a total of  30*N  iterations.
  \Remarks
    1. None.
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       daxpy   Level 1 BLAS that computes a vector triad.
       dcopy   Level 1 BLAS that copies one vector to another.
       dswap   Level 1 BLAS that swaps the contents of two vectors.
       lsame   LAPACK character comparison routine.
       dlae2   LAPACK routine that computes the eigenvalues of a 2-by-2 
               symmetric matrix.
       dlaev2  LAPACK routine that eigendecomposition of a 2-by-2 symmetric 
               matrix.
       dlamch  LAPACK routine that determines machine constants.
       dlanst  LAPACK routine that computes the norm of a matrix.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dlartg  LAPACK Givens rotation construction routine.
       dlascl  LAPACK routine for careful scaling of a matrix.
       dlaset  LAPACK matrix initialization routine.
       dlasr   LAPACK routine that applies an orthogonal transformation to 
               a matrix.
       dlasrt  LAPACK sorting routine.
       dsteqr  LAPACK routine that computes eigenvalues and eigenvectors
               of a symmetric tridiagonal matrix.
       xerbla  LAPACK error handler routine.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: stqrb.F   SID: 2.5   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       1. Starting with version 2.5, this routine is a modified version
          of LAPACK version 2.0 subroutine SSTEQR. No lines are deleted,
          only commeted out and new lines inserted.
          All lines commented out have "c$$$" at the beginning.
          Note that the LAPACK version 1.0 subroutine SSTEQR contained
          bugs. 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param d
   * @param e
   * @param z
   * @param work
   * @param info
   * 
   */
  abstract public void dstqrb(int n, double[] d, double[] e, double[] z, double[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: dstqrb
  \Description:
    Computes all eigenvalues and the last component of the eigenvectors
    of a symmetric tridiagonal matrix using the implicit QL or QR method.
    This is mostly a modification of the LAPACK routine dsteqr.
    See Remarks.
  \Usage:
    call dstqrb
       ( N, D, E, Z, WORK, INFO )
  \Arguments
    N       Integer.  (INPUT)
            The number of rows and columns in the matrix.  N >= 0.
    D       Double precision array, dimension (N).  (INPUT/OUTPUT)
            On entry, D contains the diagonal elements of the
            tridiagonal matrix.
            On exit, D contains the eigenvalues, in ascending order.
            If an error exit is made, the eigenvalues are correct
            for indices 1,2,...,INFO-1, but they are unordered and
            may not be the smallest eigenvalues of the matrix.
    E       Double precision array, dimension (N-1).  (INPUT/OUTPUT)
            On entry, E contains the subdiagonal elements of the
            tridiagonal matrix in positions 1 through N-1.
            On exit, E has been destroyed.
    Z       Double precision array, dimension (N).  (OUTPUT)
            On exit, Z contains the last row of the orthonormal 
            eigenvector matrix of the symmetric tridiagonal matrix.  
            If an error exit is made, Z contains the last row of the
            eigenvector matrix associated with the stored eigenvalues.
    WORK    Double precision array, dimension (max(1,2*N-2)).  (WORKSPACE)
            Workspace used in accumulating the transformation for 
            computing the last components of the eigenvectors.
    INFO    Integer.  (OUTPUT)
            = 0:  normal return.
            < 0:  if INFO = -i, the i-th argument had an illegal value.
            > 0:  if INFO = +i, the i-th eigenvalue has not converged
                                after a total of  30*N  iterations.
  \Remarks
    1. None.
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       daxpy   Level 1 BLAS that computes a vector triad.
       dcopy   Level 1 BLAS that copies one vector to another.
       dswap   Level 1 BLAS that swaps the contents of two vectors.
       lsame   LAPACK character comparison routine.
       dlae2   LAPACK routine that computes the eigenvalues of a 2-by-2 
               symmetric matrix.
       dlaev2  LAPACK routine that eigendecomposition of a 2-by-2 symmetric 
               matrix.
       dlamch  LAPACK routine that determines machine constants.
       dlanst  LAPACK routine that computes the norm of a matrix.
       dlapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       dlartg  LAPACK Givens rotation construction routine.
       dlascl  LAPACK routine for careful scaling of a matrix.
       dlaset  LAPACK matrix initialization routine.
       dlasr   LAPACK routine that applies an orthogonal transformation to 
               a matrix.
       dlasrt  LAPACK sorting routine.
       dsteqr  LAPACK routine that computes eigenvalues and eigenvectors
               of a symmetric tridiagonal matrix.
       xerbla  LAPACK error handler routine.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: stqrb.F   SID: 2.5   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       1. Starting with version 2.5, this routine is a modified version
          of LAPACK version 2.0 subroutine SSTEQR. No lines are deleted,
          only commeted out and new lines inserted.
          All lines commented out have "c$$$" at the beginning.
          Note that the LAPACK version 1.0 subroutine SSTEQR contained
          bugs. 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param z
   * @param _z_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void dstqrb(int n, double[] d, int _d_offset, double[] e, int _e_offset, double[] z, int _z_offset, double[] work, int _work_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sgetv0
  \Description: 
    Generate a random initial residual vector for the Arnoldi process.
    Force the residual vector to be in the range of the operator OP.  
  \Usage:
    call sgetv0
       ( IDO, BMAT, ITRY, INITV, N, J, V, LDV, RESID, RNORM, 
         IPNTR, WORKD, IERR )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first
            call to sgetv0.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO = 99: done
            -------------------------------------------------------------
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B in the (generalized)
            eigenvalue problem A*x = lambda*B*x.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    ITRY    Integer.  (INPUT)
            ITRY counts the number of times that sgetv0 is called.  
            It should be set to 1 on the initial call to sgetv0.
    INITV   Logical variable.  (INPUT)
            .TRUE.  => the initial residual vector is given in RESID.
            .FALSE. => generate a random initial residual vector.
    N       Integer.  (INPUT)
            Dimension of the problem.
    J       Integer.  (INPUT)
            Index of the residual vector to be generated, with respect to
            the Arnoldi process.  J > 1 in case of a "restart".
    V       Real N by J array.  (INPUT)
            The first J-1 columns of V contain the current Arnoldi basis
            if this is a "restart".
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    RESID   Real array of length N.  (INPUT/OUTPUT)
            Initial residual vector to be generated.  If RESID is 
            provided, force RESID into the range of the operator OP.
    RNORM   Real scalar.  (OUTPUT)
            B-norm of the generated residual.
    IPNTR   Integer array of length 3.  (OUTPUT)
    WORKD   Real work array of length 2*N.  (REVERSE COMMUNICATION).
            On exit, WORK(1:N) = B*RESID to be used in SSAITR.
    IERR    Integer.  (OUTPUT)
            =  0: Normal exit.
            = -1: Cannot generate a nontrivial restarted residual vector
                  in the range of the operator OP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine for vector output.
       slarnv  LAPACK routine for generating a random vector.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       scopy   Level 1 BLAS that copies one vector to another.
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: getv0.F   SID: 2.7   DATE OF SID: 04/07/99   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param itry
   * @param initv
   * @param n
   * @param j
   * @param v
   * @param ldv
   * @param resid
   * @param rnorm
   * @param ipntr
   * @param workd
   * @param ierr
   * 
   */
  abstract public void sgetv0(org.netlib.util.intW ido, java.lang.String bmat, int itry, boolean initv, int n, int j, float[] v, int ldv, float[] resid, org.netlib.util.floatW rnorm, int[] ipntr, float[] workd, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sgetv0
  \Description: 
    Generate a random initial residual vector for the Arnoldi process.
    Force the residual vector to be in the range of the operator OP.  
  \Usage:
    call sgetv0
       ( IDO, BMAT, ITRY, INITV, N, J, V, LDV, RESID, RNORM, 
         IPNTR, WORKD, IERR )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first
            call to sgetv0.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO = 99: done
            -------------------------------------------------------------
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B in the (generalized)
            eigenvalue problem A*x = lambda*B*x.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    ITRY    Integer.  (INPUT)
            ITRY counts the number of times that sgetv0 is called.  
            It should be set to 1 on the initial call to sgetv0.
    INITV   Logical variable.  (INPUT)
            .TRUE.  => the initial residual vector is given in RESID.
            .FALSE. => generate a random initial residual vector.
    N       Integer.  (INPUT)
            Dimension of the problem.
    J       Integer.  (INPUT)
            Index of the residual vector to be generated, with respect to
            the Arnoldi process.  J > 1 in case of a "restart".
    V       Real N by J array.  (INPUT)
            The first J-1 columns of V contain the current Arnoldi basis
            if this is a "restart".
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    RESID   Real array of length N.  (INPUT/OUTPUT)
            Initial residual vector to be generated.  If RESID is 
            provided, force RESID into the range of the operator OP.
    RNORM   Real scalar.  (OUTPUT)
            B-norm of the generated residual.
    IPNTR   Integer array of length 3.  (OUTPUT)
    WORKD   Real work array of length 2*N.  (REVERSE COMMUNICATION).
            On exit, WORK(1:N) = B*RESID to be used in SSAITR.
    IERR    Integer.  (OUTPUT)
            =  0: Normal exit.
            = -1: Cannot generate a nontrivial restarted residual vector
                  in the range of the operator OP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine for vector output.
       slarnv  LAPACK routine for generating a random vector.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       scopy   Level 1 BLAS that copies one vector to another.
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: getv0.F   SID: 2.7   DATE OF SID: 04/07/99   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param itry
   * @param initv
   * @param n
   * @param j
   * @param v
   * @param _v_offset
   * @param ldv
   * @param resid
   * @param _resid_offset
   * @param rnorm
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param ierr
   * 
   */
  abstract public void sgetv0(org.netlib.util.intW ido, java.lang.String bmat, int itry, boolean initv, int n, int j, float[] v, int _v_offset, int ldv, float[] resid, int _resid_offset, org.netlib.util.floatW rnorm, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: slaqrb
  \Description:
    Compute the eigenvalues and the Schur decomposition of an upper 
    Hessenberg submatrix in rows and columns ILO to IHI.  Only the
    last component of the Schur vectors are computed.
    This is mostly a modification of the LAPACK routine slahqr.
    
  \Usage:
    call slaqrb
       ( WANTT, N, ILO, IHI, H, LDH, WR, WI,  Z, INFO )
  \Arguments
    WANTT   Logical variable.  (INPUT)
            = .TRUE. : the full Schur form T is required;
            = .FALSE.: only eigenvalues are required.
    N       Integer.  (INPUT)
            The order of the matrix H.  N >= 0.
    ILO     Integer.  (INPUT)
    IHI     Integer.  (INPUT)
            It is assumed that H is already upper quasi-triangular in
            rows and columns IHI+1:N, and that H(ILO,ILO-1) = 0 (unless
            ILO = 1). SLAQRB works primarily with the Hessenberg
            submatrix in rows and columns ILO to IHI, but applies
            transformations to all of H if WANTT is .TRUE..
            1 <= ILO <= max(1,IHI); IHI <= N.
    H       Real array, dimension (LDH,N).  (INPUT/OUTPUT)
            On entry, the upper Hessenberg matrix H.
            On exit, if WANTT is .TRUE., H is upper quasi-triangular in
            rows and columns ILO:IHI, with any 2-by-2 diagonal blocks in
            standard form. If WANTT is .FALSE., the contents of H are
            unspecified on exit.
    LDH     Integer.  (INPUT)
            The leading dimension of the array H. LDH >= max(1,N).
    WR      Real array, dimension (N).  (OUTPUT)
    WI      Real array, dimension (N).  (OUTPUT)
            The real and imaginary parts, respectively, of the computed
            eigenvalues ILO to IHI are stored in the corresponding
            elements of WR and WI. If two eigenvalues are computed as a
            complex conjugate pair, they are stored in consecutive
            elements of WR and WI, say the i-th and (i+1)th, with
            WI(i) > 0 and WI(i+1) < 0. If WANTT is .TRUE., the
            eigenvalues are stored in the same order as on the diagonal
            of the Schur form returned in H, with WR(i) = H(i,i), and, if
            H(i:i+1,i:i+1) is a 2-by-2 diagonal block,
            WI(i) = sqrt(H(i+1,i)*H(i,i+1)) and WI(i+1) = -WI(i).
    Z       Real array, dimension (N).  (OUTPUT)
            On exit Z contains the last components of the Schur vectors.
    INFO    Integer.  (OUPUT)
            = 0: successful exit
            > 0: SLAQRB failed to compute all the eigenvalues ILO to IHI
                 in a total of 30*(IHI-ILO+1) iterations; if INFO = i,
                 elements i+1:ihi of WR and WI contain those eigenvalues
                 which have been successfully computed.
  \Remarks
    1. None.
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       slabad  LAPACK routine that computes machine constants.
       slamch  LAPACK routine that determines machine constants.
       slanhs  LAPACK routine that computes various norms of a matrix.
       slanv2  LAPACK routine that computes the Schur factorization of
               2 by 2 nonsymmetric matrix in standard form.
       slarfg  LAPACK Householder reflection construction routine.
       scopy   Level 1 BLAS that copies one vector to another.
       srot    Level 1 BLAS that applies a rotation to a 2 by 2 matrix.

  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.4'
                 Modified from the LAPACK routine slahqr so that only the
                 last component of the Schur vectors are computed.
  \SCCS Information: @(#) 
   FILE: laqrb.F   SID: 2.2   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param wantt
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param ldh
   * @param wr
   * @param wi
   * @param z
   * @param info
   * 
   */
  abstract public void slaqrb(boolean wantt, int n, int ilo, int ihi, float[] h, int ldh, float[] wr, float[] wi, float[] z, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: slaqrb
  \Description:
    Compute the eigenvalues and the Schur decomposition of an upper 
    Hessenberg submatrix in rows and columns ILO to IHI.  Only the
    last component of the Schur vectors are computed.
    This is mostly a modification of the LAPACK routine slahqr.
    
  \Usage:
    call slaqrb
       ( WANTT, N, ILO, IHI, H, LDH, WR, WI,  Z, INFO )
  \Arguments
    WANTT   Logical variable.  (INPUT)
            = .TRUE. : the full Schur form T is required;
            = .FALSE.: only eigenvalues are required.
    N       Integer.  (INPUT)
            The order of the matrix H.  N >= 0.
    ILO     Integer.  (INPUT)
    IHI     Integer.  (INPUT)
            It is assumed that H is already upper quasi-triangular in
            rows and columns IHI+1:N, and that H(ILO,ILO-1) = 0 (unless
            ILO = 1). SLAQRB works primarily with the Hessenberg
            submatrix in rows and columns ILO to IHI, but applies
            transformations to all of H if WANTT is .TRUE..
            1 <= ILO <= max(1,IHI); IHI <= N.
    H       Real array, dimension (LDH,N).  (INPUT/OUTPUT)
            On entry, the upper Hessenberg matrix H.
            On exit, if WANTT is .TRUE., H is upper quasi-triangular in
            rows and columns ILO:IHI, with any 2-by-2 diagonal blocks in
            standard form. If WANTT is .FALSE., the contents of H are
            unspecified on exit.
    LDH     Integer.  (INPUT)
            The leading dimension of the array H. LDH >= max(1,N).
    WR      Real array, dimension (N).  (OUTPUT)
    WI      Real array, dimension (N).  (OUTPUT)
            The real and imaginary parts, respectively, of the computed
            eigenvalues ILO to IHI are stored in the corresponding
            elements of WR and WI. If two eigenvalues are computed as a
            complex conjugate pair, they are stored in consecutive
            elements of WR and WI, say the i-th and (i+1)th, with
            WI(i) > 0 and WI(i+1) < 0. If WANTT is .TRUE., the
            eigenvalues are stored in the same order as on the diagonal
            of the Schur form returned in H, with WR(i) = H(i,i), and, if
            H(i:i+1,i:i+1) is a 2-by-2 diagonal block,
            WI(i) = sqrt(H(i+1,i)*H(i,i+1)) and WI(i+1) = -WI(i).
    Z       Real array, dimension (N).  (OUTPUT)
            On exit Z contains the last components of the Schur vectors.
    INFO    Integer.  (OUPUT)
            = 0: successful exit
            > 0: SLAQRB failed to compute all the eigenvalues ILO to IHI
                 in a total of 30*(IHI-ILO+1) iterations; if INFO = i,
                 elements i+1:ihi of WR and WI contain those eigenvalues
                 which have been successfully computed.
  \Remarks
    1. None.
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       slabad  LAPACK routine that computes machine constants.
       slamch  LAPACK routine that determines machine constants.
       slanhs  LAPACK routine that computes various norms of a matrix.
       slanv2  LAPACK routine that computes the Schur factorization of
               2 by 2 nonsymmetric matrix in standard form.
       slarfg  LAPACK Householder reflection construction routine.
       scopy   Level 1 BLAS that copies one vector to another.
       srot    Level 1 BLAS that applies a rotation to a 2 by 2 matrix.

  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.4'
                 Modified from the LAPACK routine slahqr so that only the
                 last component of the Schur vectors are computed.
  \SCCS Information: @(#) 
   FILE: laqrb.F   SID: 2.2   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param wantt
   * @param n
   * @param ilo
   * @param ihi
   * @param h
   * @param _h_offset
   * @param ldh
   * @param wr
   * @param _wr_offset
   * @param wi
   * @param _wi_offset
   * @param z
   * @param _z_offset
   * @param info
   * 
   */
  abstract public void slaqrb(boolean wantt, int n, int ilo, int ihi, float[] h, int _h_offset, int ldh, float[] wr, int _wr_offset, float[] wi, int _wi_offset, float[] z, int _z_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: snaitr
  \Description: 
    Reverse communication interface for applying NP additional steps to 
    a K step nonsymmetric Arnoldi factorization.
    Input:  OP*V_{k}  -  V_{k}*H = r_{k}*e_{k}^T
            with (V_{k}^T)*B*V_{k} = I, (V_{k}^T)*B*r_{k} = 0.
    Output: OP*V_{k+p}  -  V_{k+p}*H = r_{k+p}*e_{k+p}^T
            with (V_{k+p}^T)*B*V_{k+p} = I, (V_{k+p}^T)*B*r_{k+p} = 0.
    where OP and B are as in snaupd.  The B-norm of r_{k+p} is also
    computed and returned.
  \Usage:
    call snaitr
       ( IDO, BMAT, N, K, NP, NB, RESID, RNORM, V, LDV, H, LDH, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
                      This is for the restart phase to force the new
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y,
                      IPNTR(3) is the pointer into WORK for B * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
            IDO = 99: done
            -------------------------------------------------------------
            When the routine is used in the "shift-and-invert" mode, the
            vector B * Q is already available and do not need to be
            recompute in forming OP * Q.
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.  See snaupd.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*M**x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    K       Integer.  (INPUT)
            Current size of V and H.
    NP      Integer.  (INPUT)
            Number of additional Arnoldi steps to take.
    NB      Integer.  (INPUT)
            Blocksize to be used in the recurrence.          
            Only work for NB = 1 right now.  The goal is to have a 
            program that implement both the block and non-block method.
    RESID   Real array of length N.  (INPUT/OUTPUT)
            On INPUT:  RESID contains the residual vector r_{k}.
            On OUTPUT: RESID contains the residual vector r_{k+p}.
    RNORM   Real scalar.  (INPUT/OUTPUT)
            B-norm of the starting residual on input.
            B-norm of the updated residual r_{k+p} on output.
    V       Real N by K+NP array.  (INPUT/OUTPUT)
            On INPUT:  V contains the Arnoldi vectors in the first K 
            columns.
            On OUTPUT: V contains the new NP Arnoldi vectors in the next
            NP columns.  The first K columns are unchanged.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Real (K+NP) by (K+NP) array.  (INPUT/OUTPUT)
            H is used to store the generated upper Hessenberg matrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORK for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The calling program should not 
            use WORKD as temporary workspace during the iteration !!!!!!
            On input, WORKD(1:N) = B*RESID and is used to save some 
            computation at the first step.
    INFO    Integer.  (OUTPUT)
            = 0: Normal exit.
            > 0: Size of the spanning invariant subspace of OP found.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       sgetv0  ARPACK routine to generate the initial vector.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       smout   ARPACK utility routine that prints matrices
       svout   ARPACK utility routine that prints vectors.
       slabad  LAPACK routine that computes machine constants.
       slamch  LAPACK routine that determines machine constants.
       slascl  LAPACK routine for careful scaling of a matrix.
       slanhs  LAPACK routine that computes various norms of a matrix.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       saxpy   Level 1 BLAS that computes a vector triad.
       sscal   Level 1 BLAS that scales a vector.
       scopy   Level 1 BLAS that copies one vector to another .
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
   
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: naitr.F   SID: 2.4   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
    The algorithm implemented is:
    
    restart = .false.
    Given V_{k} = [v_{1}, ..., v_{k}], r_{k}; 
    r_{k} contains the initial residual vector even for k = 0;
    Also assume that rnorm = || B*r_{k} || and B*r_{k} are already 
    computed by the calling program.
    betaj = rnorm ; p_{k+1} = B*r_{k} ;
    For  j = k+1, ..., k+np  Do
       1) if ( betaj < tol ) stop or restart depending on j.
          ( At present tol is zero )
          if ( restart ) generate a new starting vector.
       2) v_{j} = r(j-1)/betaj;  V_{j} = [V_{j-1}, v_{j}];  
          p_{j} = p_{j}/betaj
       3) r_{j} = OP*v_{j} where OP is defined as in snaupd
          For shift-invert mode p_{j} = B*v_{j} is already available.
          wnorm = || OP*v_{j} ||
       4) Compute the j-th step residual vector.
          w_{j} =  V_{j}^T * B * OP * v_{j}
          r_{j} =  OP*v_{j} - V_{j} * w_{j}
          H(:,j) = w_{j};
          H(j,j-1) = rnorm
          rnorm = || r_(j) ||
          If (rnorm > 0.717*wnorm) accept step and go back to 1)
       5) Re-orthogonalization step:
          s = V_{j}'*B*r_{j}
          r_{j} = r_{j} - V_{j}*s;  rnorm1 = || r_{j} ||
          alphaj = alphaj + s_{j};   
       6) Iterative refinement step:
          If (rnorm1 > 0.717*rnorm) then
             rnorm = rnorm1
             accept step and go back to 1)
          Else
             rnorm = rnorm1
             If this is the first time in step 6), go to 5)
             Else r_{j} lies in the span of V_{j} numerically.
                Set r_{j} = 0 and rnorm = 0; go to 1)
          EndIf 
    End Do
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param k
   * @param np
   * @param nb
   * @param resid
   * @param rnorm
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param ipntr
   * @param workd
   * @param info
   * 
   */
  abstract public void snaitr(org.netlib.util.intW ido, java.lang.String bmat, int n, int k, int np, int nb, float[] resid, org.netlib.util.floatW rnorm, float[] v, int ldv, float[] h, int ldh, int[] ipntr, float[] workd, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: snaitr
  \Description: 
    Reverse communication interface for applying NP additional steps to 
    a K step nonsymmetric Arnoldi factorization.
    Input:  OP*V_{k}  -  V_{k}*H = r_{k}*e_{k}^T
            with (V_{k}^T)*B*V_{k} = I, (V_{k}^T)*B*r_{k} = 0.
    Output: OP*V_{k+p}  -  V_{k+p}*H = r_{k+p}*e_{k+p}^T
            with (V_{k+p}^T)*B*V_{k+p} = I, (V_{k+p}^T)*B*r_{k+p} = 0.
    where OP and B are as in snaupd.  The B-norm of r_{k+p} is also
    computed and returned.
  \Usage:
    call snaitr
       ( IDO, BMAT, N, K, NP, NB, RESID, RNORM, V, LDV, H, LDH, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
                      This is for the restart phase to force the new
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y,
                      IPNTR(3) is the pointer into WORK for B * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
            IDO = 99: done
            -------------------------------------------------------------
            When the routine is used in the "shift-and-invert" mode, the
            vector B * Q is already available and do not need to be
            recompute in forming OP * Q.
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.  See snaupd.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*M**x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    K       Integer.  (INPUT)
            Current size of V and H.
    NP      Integer.  (INPUT)
            Number of additional Arnoldi steps to take.
    NB      Integer.  (INPUT)
            Blocksize to be used in the recurrence.          
            Only work for NB = 1 right now.  The goal is to have a 
            program that implement both the block and non-block method.
    RESID   Real array of length N.  (INPUT/OUTPUT)
            On INPUT:  RESID contains the residual vector r_{k}.
            On OUTPUT: RESID contains the residual vector r_{k+p}.
    RNORM   Real scalar.  (INPUT/OUTPUT)
            B-norm of the starting residual on input.
            B-norm of the updated residual r_{k+p} on output.
    V       Real N by K+NP array.  (INPUT/OUTPUT)
            On INPUT:  V contains the Arnoldi vectors in the first K 
            columns.
            On OUTPUT: V contains the new NP Arnoldi vectors in the next
            NP columns.  The first K columns are unchanged.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Real (K+NP) by (K+NP) array.  (INPUT/OUTPUT)
            H is used to store the generated upper Hessenberg matrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORK for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The calling program should not 
            use WORKD as temporary workspace during the iteration !!!!!!
            On input, WORKD(1:N) = B*RESID and is used to save some 
            computation at the first step.
    INFO    Integer.  (OUTPUT)
            = 0: Normal exit.
            > 0: Size of the spanning invariant subspace of OP found.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       sgetv0  ARPACK routine to generate the initial vector.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       smout   ARPACK utility routine that prints matrices
       svout   ARPACK utility routine that prints vectors.
       slabad  LAPACK routine that computes machine constants.
       slamch  LAPACK routine that determines machine constants.
       slascl  LAPACK routine for careful scaling of a matrix.
       slanhs  LAPACK routine that computes various norms of a matrix.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       saxpy   Level 1 BLAS that computes a vector triad.
       sscal   Level 1 BLAS that scales a vector.
       scopy   Level 1 BLAS that copies one vector to another .
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
   
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: naitr.F   SID: 2.4   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
    The algorithm implemented is:
    
    restart = .false.
    Given V_{k} = [v_{1}, ..., v_{k}], r_{k}; 
    r_{k} contains the initial residual vector even for k = 0;
    Also assume that rnorm = || B*r_{k} || and B*r_{k} are already 
    computed by the calling program.
    betaj = rnorm ; p_{k+1} = B*r_{k} ;
    For  j = k+1, ..., k+np  Do
       1) if ( betaj < tol ) stop or restart depending on j.
          ( At present tol is zero )
          if ( restart ) generate a new starting vector.
       2) v_{j} = r(j-1)/betaj;  V_{j} = [V_{j-1}, v_{j}];  
          p_{j} = p_{j}/betaj
       3) r_{j} = OP*v_{j} where OP is defined as in snaupd
          For shift-invert mode p_{j} = B*v_{j} is already available.
          wnorm = || OP*v_{j} ||
       4) Compute the j-th step residual vector.
          w_{j} =  V_{j}^T * B * OP * v_{j}
          r_{j} =  OP*v_{j} - V_{j} * w_{j}
          H(:,j) = w_{j};
          H(j,j-1) = rnorm
          rnorm = || r_(j) ||
          If (rnorm > 0.717*wnorm) accept step and go back to 1)
       5) Re-orthogonalization step:
          s = V_{j}'*B*r_{j}
          r_{j} = r_{j} - V_{j}*s;  rnorm1 = || r_{j} ||
          alphaj = alphaj + s_{j};   
       6) Iterative refinement step:
          If (rnorm1 > 0.717*rnorm) then
             rnorm = rnorm1
             accept step and go back to 1)
          Else
             rnorm = rnorm1
             If this is the first time in step 6), go to 5)
             Else r_{j} lies in the span of V_{j} numerically.
                Set r_{j} = 0 and rnorm = 0; go to 1)
          EndIf 
    End Do
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param k
   * @param np
   * @param nb
   * @param resid
   * @param _resid_offset
   * @param rnorm
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param info
   * 
   */
  abstract public void snaitr(org.netlib.util.intW ido, java.lang.String bmat, int n, int k, int np, int nb, float[] resid, int _resid_offset, org.netlib.util.floatW rnorm, float[] v, int _v_offset, int ldv, float[] h, int _h_offset, int ldh, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: snapps
  \Description:
    Given the Arnoldi factorization
       A*V_{k} - V_{k}*H_{k} = r_{k+p}*e_{k+p}^T,
    apply NP implicit shifts resulting in
       A*(V_{k}*Q) - (V_{k}*Q)*(Q^T* H_{k}*Q) = r_{k+p}*e_{k+p}^T * Q
    where Q is an orthogonal matrix which is the product of rotations
    and reflections resulting from the NP bulge chage sweeps.
    The updated Arnoldi factorization becomes:
       A*VNEW_{k} - VNEW_{k}*HNEW_{k} = rnew_{k}*e_{k}^T.
  \Usage:
    call snapps
       ( N, KEV, NP, SHIFTR, SHIFTI, V, LDV, H, LDH, RESID, Q, LDQ, 
         WORKL, WORKD )
  \Arguments
    N       Integer.  (INPUT)
            Problem size, i.e. size of matrix A.
    KEV     Integer.  (INPUT/OUTPUT)
            KEV+NP is the size of the input matrix H.
            KEV is the size of the updated matrix HNEW.  KEV is only 
            updated on ouput when fewer than NP shifts are applied in
            order to keep the conjugate pair together.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be applied.
    SHIFTR, Real array of length NP.  (INPUT)
    SHIFTI  Real and imaginary part of the shifts to be applied.
            Upon, entry to snapps, the shifts must be sorted so that the 
            conjugate pairs are in consecutive locations.
    V       Real N by (KEV+NP) array.  (INPUT/OUTPUT)
            On INPUT, V contains the current KEV+NP Arnoldi vectors.
            On OUTPUT, V contains the updated KEV Arnoldi vectors
            in the first KEV columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    H       Real (KEV+NP) by (KEV+NP) array.  (INPUT/OUTPUT)
            On INPUT, H contains the current KEV+NP by KEV+NP upper 
            Hessenber matrix of the Arnoldi factorization.
            On OUTPUT, H contains the updated KEV by KEV upper Hessenberg
            matrix in the KEV leading submatrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RESID   Real array of length N.  (INPUT/OUTPUT)
            On INPUT, RESID contains the the residual vector r_{k+p}.
            On OUTPUT, RESID is the update residual vector rnew_{k} 
            in the first KEV locations.
    Q       Real KEV+NP by KEV+NP work array.  (WORKSPACE)
            Work array used to accumulate the rotations and reflections
            during the bulge chase sweep.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Real work array of length (KEV+NP).  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.
    WORKD   Real work array of length 2*N.  (WORKSPACE)
            Distributed array used in the application of the accumulated
            orthogonal matrix Q.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
  \Routines called:
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       smout   ARPACK utility routine that prints matrices.
       svout   ARPACK utility routine that prints vectors.
       slabad  LAPACK routine that computes machine constants.
       slacpy  LAPACK matrix copy routine.
       slamch  LAPACK routine that determines machine constants. 
       slanhs  LAPACK routine that computes various norms of a matrix.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       slarf   LAPACK routine that applies Householder reflection to
               a matrix.
       slarfg  LAPACK Householder reflection construction routine.
       slartg  LAPACK Givens rotation construction routine.
       slaset  LAPACK matrix initialization routine.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       saxpy   Level 1 BLAS that computes a vector triad.
       scopy   Level 1 BLAS that copies one vector to another .
       sscal   Level 1 BLAS that scales a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: napps.F   SID: 2.4   DATE OF SID: 3/28/97   RELEASE: 2
  \Remarks
    1. In this version, each shift is applied to all the sublocks of
       the Hessenberg matrix H and not just to the submatrix that it
       comes from. Deflation as in LAPACK routine slahqr (QR algorithm
       for upper Hessenberg matrices ) is used.
       The subdiagonals of H are enforced to be non-negative.
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param kev
   * @param np
   * @param shiftr
   * @param shifti
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param resid
   * @param q
   * @param ldq
   * @param workl
   * @param workd
   * 
   */
  abstract public void snapps(int n, org.netlib.util.intW kev, int np, float[] shiftr, float[] shifti, float[] v, int ldv, float[] h, int ldh, float[] resid, float[] q, int ldq, float[] workl, float[] workd);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: snapps
  \Description:
    Given the Arnoldi factorization
       A*V_{k} - V_{k}*H_{k} = r_{k+p}*e_{k+p}^T,
    apply NP implicit shifts resulting in
       A*(V_{k}*Q) - (V_{k}*Q)*(Q^T* H_{k}*Q) = r_{k+p}*e_{k+p}^T * Q
    where Q is an orthogonal matrix which is the product of rotations
    and reflections resulting from the NP bulge chage sweeps.
    The updated Arnoldi factorization becomes:
       A*VNEW_{k} - VNEW_{k}*HNEW_{k} = rnew_{k}*e_{k}^T.
  \Usage:
    call snapps
       ( N, KEV, NP, SHIFTR, SHIFTI, V, LDV, H, LDH, RESID, Q, LDQ, 
         WORKL, WORKD )
  \Arguments
    N       Integer.  (INPUT)
            Problem size, i.e. size of matrix A.
    KEV     Integer.  (INPUT/OUTPUT)
            KEV+NP is the size of the input matrix H.
            KEV is the size of the updated matrix HNEW.  KEV is only 
            updated on ouput when fewer than NP shifts are applied in
            order to keep the conjugate pair together.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be applied.
    SHIFTR, Real array of length NP.  (INPUT)
    SHIFTI  Real and imaginary part of the shifts to be applied.
            Upon, entry to snapps, the shifts must be sorted so that the 
            conjugate pairs are in consecutive locations.
    V       Real N by (KEV+NP) array.  (INPUT/OUTPUT)
            On INPUT, V contains the current KEV+NP Arnoldi vectors.
            On OUTPUT, V contains the updated KEV Arnoldi vectors
            in the first KEV columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    H       Real (KEV+NP) by (KEV+NP) array.  (INPUT/OUTPUT)
            On INPUT, H contains the current KEV+NP by KEV+NP upper 
            Hessenber matrix of the Arnoldi factorization.
            On OUTPUT, H contains the updated KEV by KEV upper Hessenberg
            matrix in the KEV leading submatrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RESID   Real array of length N.  (INPUT/OUTPUT)
            On INPUT, RESID contains the the residual vector r_{k+p}.
            On OUTPUT, RESID is the update residual vector rnew_{k} 
            in the first KEV locations.
    Q       Real KEV+NP by KEV+NP work array.  (WORKSPACE)
            Work array used to accumulate the rotations and reflections
            during the bulge chase sweep.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Real work array of length (KEV+NP).  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.
    WORKD   Real work array of length 2*N.  (WORKSPACE)
            Distributed array used in the application of the accumulated
            orthogonal matrix Q.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
  \Routines called:
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       smout   ARPACK utility routine that prints matrices.
       svout   ARPACK utility routine that prints vectors.
       slabad  LAPACK routine that computes machine constants.
       slacpy  LAPACK matrix copy routine.
       slamch  LAPACK routine that determines machine constants. 
       slanhs  LAPACK routine that computes various norms of a matrix.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       slarf   LAPACK routine that applies Householder reflection to
               a matrix.
       slarfg  LAPACK Householder reflection construction routine.
       slartg  LAPACK Givens rotation construction routine.
       slaset  LAPACK matrix initialization routine.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       saxpy   Level 1 BLAS that computes a vector triad.
       scopy   Level 1 BLAS that copies one vector to another .
       sscal   Level 1 BLAS that scales a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: napps.F   SID: 2.4   DATE OF SID: 3/28/97   RELEASE: 2
  \Remarks
    1. In this version, each shift is applied to all the sublocks of
       the Hessenberg matrix H and not just to the submatrix that it
       comes from. Deflation as in LAPACK routine slahqr (QR algorithm
       for upper Hessenberg matrices ) is used.
       The subdiagonals of H are enforced to be non-negative.
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param kev
   * @param np
   * @param shiftr
   * @param _shiftr_offset
   * @param shifti
   * @param _shifti_offset
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param resid
   * @param _resid_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workl
   * @param _workl_offset
   * @param workd
   * @param _workd_offset
   * 
   */
  abstract public void snapps(int n, org.netlib.util.intW kev, int np, float[] shiftr, int _shiftr_offset, float[] shifti, int _shifti_offset, float[] v, int _v_offset, int ldv, float[] h, int _h_offset, int ldh, float[] resid, int _resid_offset, float[] q, int _q_offset, int ldq, float[] workl, int _workl_offset, float[] workd, int _workd_offset);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: snaup2
  \Description: 
    Intermediate level interface called by snaupd.
  \Usage:
    call snaup2
       ( IDO, BMAT, N, WHICH, NEV, NP, TOL, RESID, MODE, IUPD,
         ISHIFT, MXITER, V, LDV, H, LDH, RITZR, RITZI, BOUNDS, 
         Q, LDQ, WORKL, IPNTR, WORKD, INFO )
  \Arguments
    IDO, BMAT, N, WHICH, NEV, TOL, RESID: same as defined in snaupd.
    MODE, ISHIFT, MXITER: see the definition of IPARAM in snaupd.
    NP      Integer.  (INPUT/OUTPUT)
            Contains the number of implicit shifts to apply during 
            each Arnoldi iteration.  
            If ISHIFT=1, NP is adjusted dynamically at each iteration 
            to accelerate convergence and prevent stagnation.
            This is also roughly equal to the number of matrix-vector 
            products (involving the operator OP) per Arnoldi iteration.
            The logic for adjusting is contained within the current
            subroutine.
            If ISHIFT=0, NP is the number of shifts the user needs
            to provide via reverse comunication. 0 < NP < NCV-NEV.
            NP may be less than NCV-NEV for two reasons. The first, is
            to keep complex conjugate pairs of "wanted" Ritz values 
            together. The second, is that a leading block of the current
            upper Hessenberg matrix has split off and contains "unwanted"
            Ritz values.
            Upon termination of the IRA iteration, NP contains the number 
            of "converged" wanted Ritz values.
    IUPD    Integer.  (INPUT)
            IUPD .EQ. 0: use explicit restart instead implicit update.
            IUPD .NE. 0: use implicit update.
    V       Real N by (NEV+NP) array.  (INPUT/OUTPUT)
            The Arnoldi basis vectors are returned in the first NEV 
            columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Real (NEV+NP) by (NEV+NP) array.  (OUTPUT)
            H is used to store the generated upper Hessenberg matrix
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    RITZR,  Real arrays of length NEV+NP.  (OUTPUT)
    RITZI   RITZR(1:NEV) (resp. RITZI(1:NEV)) contains the real (resp.
            imaginary) part of the computed Ritz values of OP.
    BOUNDS  Real array of length NEV+NP.  (OUTPUT)
            BOUNDS(1:NEV) contain the error bounds corresponding to 
            the computed Ritz values.
            
    Q       Real (NEV+NP) by (NEV+NP) array.  (WORKSPACE)
            Private (replicated) work array used to accumulate the
            rotation in the shift application step.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Real work array of length at least 
            (NEV+NP)**2 + 3*(NEV+NP).  (INPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  It is used in shifts calculation, shifts
            application and convergence checking.
            On exit, the last 3*(NEV+NP) locations of WORKL contain
            the Ritz values (real,imaginary) and associated Ritz
            estimates of the current Hessenberg matrix.  They are
            listed in the same order as returned from sneigh.
            If ISHIFT .EQ. O and IDO .EQ. 3, the first 2*NP locations
            of WORKL are used in reverse communication to hold the user 
            supplied shifts.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (WORKSPACE)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD
            as temporary workspace during the iteration !!!!!!!!!!
            See Data Distribution Note in DNAUPD.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =     0: Normal return.
            =     1: Maximum number of iterations taken.
                     All possible eigenvalues of OP has been found.  
                     NP returns the number of converged Ritz values.
            =     2: No shifts could be applied.
            =    -8: Error return from LAPACK eigenvalue calculation;
                     This should never happen.
            =    -9: Starting vector is zero.
            = -9999: Could not build an Arnoldi factorization.
                     Size that was built in returned in NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       sgetv0  ARPACK initial vector generation routine. 
       snaitr  ARPACK Arnoldi factorization routine.
       snapps  ARPACK application of implicit shifts routine.
       snconv  ARPACK convergence of Ritz values routine.
       sneigh  ARPACK compute Ritz values and error bounds routine.
       sngets  ARPACK reorder Ritz values and error bounds routine.
       ssortc  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       smout   ARPACK utility routine that prints matrices
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       scopy   Level 1 BLAS that copies one vector to another .
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sswap   Level 1 BLAS that swaps two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas    
   
  \SCCS Information: @(#) 
   FILE: naup2.F   SID: 2.8   DATE OF SID: 10/17/00   RELEASE: 2
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param np
   * @param tol
   * @param resid
   * @param mode
   * @param iupd
   * @param ishift
   * @param mxiter
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param ritzr
   * @param ritzi
   * @param bounds
   * @param q
   * @param ldq
   * @param workl
   * @param ipntr
   * @param workd
   * @param info
   * 
   */
  abstract public void snaup2(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, org.netlib.util.intW np, float tol, float[] resid, int mode, int iupd, int ishift, org.netlib.util.intW mxiter, float[] v, int ldv, float[] h, int ldh, float[] ritzr, float[] ritzi, float[] bounds, float[] q, int ldq, float[] workl, int[] ipntr, float[] workd, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: snaup2
  \Description: 
    Intermediate level interface called by snaupd.
  \Usage:
    call snaup2
       ( IDO, BMAT, N, WHICH, NEV, NP, TOL, RESID, MODE, IUPD,
         ISHIFT, MXITER, V, LDV, H, LDH, RITZR, RITZI, BOUNDS, 
         Q, LDQ, WORKL, IPNTR, WORKD, INFO )
  \Arguments
    IDO, BMAT, N, WHICH, NEV, TOL, RESID: same as defined in snaupd.
    MODE, ISHIFT, MXITER: see the definition of IPARAM in snaupd.
    NP      Integer.  (INPUT/OUTPUT)
            Contains the number of implicit shifts to apply during 
            each Arnoldi iteration.  
            If ISHIFT=1, NP is adjusted dynamically at each iteration 
            to accelerate convergence and prevent stagnation.
            This is also roughly equal to the number of matrix-vector 
            products (involving the operator OP) per Arnoldi iteration.
            The logic for adjusting is contained within the current
            subroutine.
            If ISHIFT=0, NP is the number of shifts the user needs
            to provide via reverse comunication. 0 < NP < NCV-NEV.
            NP may be less than NCV-NEV for two reasons. The first, is
            to keep complex conjugate pairs of "wanted" Ritz values 
            together. The second, is that a leading block of the current
            upper Hessenberg matrix has split off and contains "unwanted"
            Ritz values.
            Upon termination of the IRA iteration, NP contains the number 
            of "converged" wanted Ritz values.
    IUPD    Integer.  (INPUT)
            IUPD .EQ. 0: use explicit restart instead implicit update.
            IUPD .NE. 0: use implicit update.
    V       Real N by (NEV+NP) array.  (INPUT/OUTPUT)
            The Arnoldi basis vectors are returned in the first NEV 
            columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Real (NEV+NP) by (NEV+NP) array.  (OUTPUT)
            H is used to store the generated upper Hessenberg matrix
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    RITZR,  Real arrays of length NEV+NP.  (OUTPUT)
    RITZI   RITZR(1:NEV) (resp. RITZI(1:NEV)) contains the real (resp.
            imaginary) part of the computed Ritz values of OP.
    BOUNDS  Real array of length NEV+NP.  (OUTPUT)
            BOUNDS(1:NEV) contain the error bounds corresponding to 
            the computed Ritz values.
            
    Q       Real (NEV+NP) by (NEV+NP) array.  (WORKSPACE)
            Private (replicated) work array used to accumulate the
            rotation in the shift application step.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Real work array of length at least 
            (NEV+NP)**2 + 3*(NEV+NP).  (INPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  It is used in shifts calculation, shifts
            application and convergence checking.
            On exit, the last 3*(NEV+NP) locations of WORKL contain
            the Ritz values (real,imaginary) and associated Ritz
            estimates of the current Hessenberg matrix.  They are
            listed in the same order as returned from sneigh.
            If ISHIFT .EQ. O and IDO .EQ. 3, the first 2*NP locations
            of WORKL are used in reverse communication to hold the user 
            supplied shifts.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (WORKSPACE)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD
            as temporary workspace during the iteration !!!!!!!!!!
            See Data Distribution Note in DNAUPD.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =     0: Normal return.
            =     1: Maximum number of iterations taken.
                     All possible eigenvalues of OP has been found.  
                     NP returns the number of converged Ritz values.
            =     2: No shifts could be applied.
            =    -8: Error return from LAPACK eigenvalue calculation;
                     This should never happen.
            =    -9: Starting vector is zero.
            = -9999: Could not build an Arnoldi factorization.
                     Size that was built in returned in NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       sgetv0  ARPACK initial vector generation routine. 
       snaitr  ARPACK Arnoldi factorization routine.
       snapps  ARPACK application of implicit shifts routine.
       snconv  ARPACK convergence of Ritz values routine.
       sneigh  ARPACK compute Ritz values and error bounds routine.
       sngets  ARPACK reorder Ritz values and error bounds routine.
       ssortc  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       smout   ARPACK utility routine that prints matrices
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       scopy   Level 1 BLAS that copies one vector to another .
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sswap   Level 1 BLAS that swaps two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas    
   
  \SCCS Information: @(#) 
   FILE: naup2.F   SID: 2.8   DATE OF SID: 10/17/00   RELEASE: 2
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param np
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param mode
   * @param iupd
   * @param ishift
   * @param mxiter
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ritzr
   * @param _ritzr_offset
   * @param ritzi
   * @param _ritzi_offset
   * @param bounds
   * @param _bounds_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workl
   * @param _workl_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param info
   * 
   */
  abstract public void snaup2(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, org.netlib.util.intW np, float tol, float[] resid, int _resid_offset, int mode, int iupd, int ishift, org.netlib.util.intW mxiter, float[] v, int _v_offset, int ldv, float[] h, int _h_offset, int ldh, float[] ritzr, int _ritzr_offset, float[] ritzi, int _ritzi_offset, float[] bounds, int _bounds_offset, float[] q, int _q_offset, int ldq, float[] workl, int _workl_offset, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: snaupd
  \Description: 
    Reverse communication interface for the Implicitly Restarted Arnoldi
    iteration. This subroutine computes approximations to a few eigenpairs 
    of a linear operator "OP" with respect to a semi-inner product defined by 
    a symmetric positive semi-definite real matrix B. B may be the identity 
    matrix. NOTE: If the linear operator "OP" is real and symmetric 
    with respect to the real positive semi-definite symmetric matrix B, 
    i.e. B*OP = (OP`)*B, then subroutine ssaupd should be used instead.
    The computed approximate eigenvalues are called Ritz values and
    the corresponding approximate eigenvectors are called Ritz vectors.
    snaupd is usually called iteratively to solve one of the 
    following problems:
    Mode 1:  A*x = lambda*x.
             ===> OP = A  and  B = I.
    Mode 2:  A*x = lambda*M*x, M symmetric positive definite
             ===> OP = inv[M]*A  and  B = M.
             ===> (If M can be factored see remark 3 below)
    Mode 3:  A*x = lambda*M*x, M symmetric semi-definite
             ===> OP = Real_Part{ inv[A - sigma*M]*M }  and  B = M. 
             ===> shift-and-invert mode (in real arithmetic)
             If OP*x = amu*x, then 
             amu = 1/2 * [ 1/(lambda-sigma) + 1/(lambda-conjg(sigma)) ].
             Note: If sigma is real, i.e. imaginary part of sigma is zero;
                   Real_Part{ inv[A - sigma*M]*M } == inv[A - sigma*M]*M 
                   amu == 1/(lambda-sigma). 
    
    Mode 4:  A*x = lambda*M*x, M symmetric semi-definite
             ===> OP = Imaginary_Part{ inv[A - sigma*M]*M }  and  B = M. 
             ===> shift-and-invert mode (in real arithmetic)
             If OP*x = amu*x, then 
             amu = 1/2i * [ 1/(lambda-sigma) - 1/(lambda-conjg(sigma)) ].
    Both mode 3 and 4 give the same enhancement to eigenvalues close to
    the (complex) shift sigma.  However, as lambda goes to infinity,
    the operator OP in mode 4 dampens the eigenvalues more strongly than
    does OP defined in mode 3.
    NOTE: The action of w <- inv[A - sigma*M]*v or w <- inv[M]*v
          should be accomplished either by a direct method
          using a sparse matrix factorization and solving
             [A - sigma*M]*w = v  or M*w = v,
          or through an iterative method for solving these
          systems.  If an iterative method is used, the
          convergence test must be more stringent than
          the accuracy requirements for the eigenvalue
          approximations.
  \Usage:
    call snaupd
       ( IDO, BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM,
         IPNTR, WORKD, WORKL, LWORKL, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first 
            call to snaupd.  IDO will be set internally to
            indicate the type of operation to be performed.  Control is
            then given back to the calling routine which has the
            responsibility to carry out the requested operation and call
            snaupd with the result.  The operand is given in
            WORKD(IPNTR(1)), the result must be put in WORKD(IPNTR(2)).
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      In mode 3 and 4, the vector B * X is already
                      available in WORKD(ipntr(3)).  It does not
                      need to be recomputed in forming OP * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO =  3: compute the IPARAM(8) real and imaginary parts 
                      of the shifts where INPTR(14) is the pointer
                      into WORKL for placing the shifts. See Remark
                      5 below.
            IDO = 99: done
            -------------------------------------------------------------
               
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.
            BMAT = 'I' -> standard eigenvalue problem A*x = lambda*x
            BMAT = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    WHICH   Character*2.  (INPUT)
            'LM' -> want the NEV eigenvalues of largest magnitude.
            'SM' -> want the NEV eigenvalues of smallest magnitude.
            'LR' -> want the NEV eigenvalues of largest real part.
            'SR' -> want the NEV eigenvalues of smallest real part.
            'LI' -> want the NEV eigenvalues of largest imaginary part.
            'SI' -> want the NEV eigenvalues of smallest imaginary part.
    NEV     Integer.  (INPUT/OUTPUT)
            Number of eigenvalues of OP to be computed. 0 < NEV < N-1.
    TOL     Real scalar.  (INPUT)
            Stopping criterion: the relative accuracy of the Ritz value 
            is considered acceptable if BOUNDS(I) .LE. TOL*ABS(RITZ(I))
            where ABS(RITZ(I)) is the magnitude when RITZ(I) is complex.
            DEFAULT = SLAMCH('EPS')  (machine precision as computed
                      by the LAPACK auxiliary subroutine SLAMCH).
    RESID   Real array of length N.  (INPUT/OUTPUT)
            On INPUT: 
            If INFO .EQ. 0, a random initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            On OUTPUT:
            RESID contains the final residual vector.
    NCV     Integer.  (INPUT)
            Number of columns of the matrix V. NCV must satisfy the two
            inequalities 2 <= NCV-NEV and NCV <= N.
            This will indicate how many Arnoldi vectors are generated 
            at each iteration.  After the startup phase in which NEV 
            Arnoldi vectors are generated, the algorithm generates 
            approximately NCV-NEV Arnoldi vectors at each subsequent update 
            iteration. Most of the cost in generating each Arnoldi vector is 
            in the matrix-vector operation OP*x. 
            NOTE: 2 <= NCV-NEV in order that complex conjugate pairs of Ritz 
            values are kept together. (See remark 4 below)
    V       Real array N by NCV.  (OUTPUT)
            Contains the final set of Arnoldi basis vectors. 
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling program.
    IPARAM  Integer array of length 11.  (INPUT/OUTPUT)
            IPARAM(1) = ISHIFT: method for selecting the implicit shifts.
            The shifts selected at each iteration are used to restart
            the Arnoldi iteration in an implicit fashion.
            -------------------------------------------------------------
            ISHIFT = 0: the shifts are provided by the user via
                        reverse communication.  The real and imaginary
                        parts of the NCV eigenvalues of the Hessenberg
                        matrix H are returned in the part of the WORKL 
                        array corresponding to RITZR and RITZI. See remark 
                        5 below.
            ISHIFT = 1: exact shifts with respect to the current
                        Hessenberg matrix H.  This is equivalent to 
                        restarting the iteration with a starting vector
                        that is a linear combination of approximate Schur
                        vectors associated with the "wanted" Ritz values.
            -------------------------------------------------------------
            IPARAM(2) = No longer referenced.
            IPARAM(3) = MXITER
            On INPUT:  maximum number of Arnoldi update iterations allowed. 
            On OUTPUT: actual number of Arnoldi update iterations taken. 
            IPARAM(4) = NB: blocksize to be used in the recurrence.
            The code currently works only for NB = 1.
            IPARAM(5) = NCONV: number of "converged" Ritz values.
            This represents the number of Ritz values that satisfy
            the convergence criterion.
            IPARAM(6) = IUPD
            No longer referenced. Implicit restarting is ALWAYS used.  
            IPARAM(7) = MODE
            On INPUT determines what type of eigenproblem is being solved.
            Must be 1,2,3,4; See under \Description of snaupd for the 
            four modes available.
            IPARAM(8) = NP
            When ido = 3 and the user provides shifts through reverse
            communication (IPARAM(1)=0), snaupd returns NP, the number
            of shifts the user is to provide. 0 < NP <=NCV-NEV. See Remark
            5 below.
            IPARAM(9) = NUMOP, IPARAM(10) = NUMOPB, IPARAM(11) = NUMREO,
            OUTPUT: NUMOP  = total number of OP*x operations,
                    NUMOPB = total number of B*x operations if BMAT='G',
                    NUMREO = total number of steps of re-orthogonalization.        
    IPNTR   Integer array of length 14.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD and WORKL
            arrays for matrices/vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X in WORKD.
            IPNTR(2): pointer to the current result vector Y in WORKD.
            IPNTR(3): pointer to the vector B * X in WORKD when used in 
                      the shift-and-invert mode.
            IPNTR(4): pointer to the next available location in WORKL
                      that is untouched by the program.
            IPNTR(5): pointer to the NCV by NCV upper Hessenberg matrix
                      H in WORKL.
            IPNTR(6): pointer to the real part of the ritz value array 
                      RITZR in WORKL.
            IPNTR(7): pointer to the imaginary part of the ritz value array
                      RITZI in WORKL.
            IPNTR(8): pointer to the Ritz estimates in array WORKL associated
                      with the Ritz values located in RITZR and RITZI in WORKL.
            IPNTR(14): pointer to the NP shifts in WORKL. See Remark 5 below.
            Note: IPNTR(9:13) is only referenced by sneupd. See Remark 2 below.
            IPNTR(9):  pointer to the real part of the NCV RITZ values of the 
                       original system.
            IPNTR(10): pointer to the imaginary part of the NCV RITZ values of 
                       the original system.
            IPNTR(11): pointer to the NCV corresponding error bounds.
            IPNTR(12): pointer to the NCV by NCV upper quasi-triangular
                       Schur matrix for H.
            IPNTR(13): pointer to the NCV by NCV matrix of eigenvectors
                       of the upper Hessenberg matrix H. Only referenced by
                       sneupd if RVEC = .TRUE. See Remark 2 below.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD 
            as temporary workspace during the iteration. Upon termination
            WORKD(1:N) contains B*RESID(1:N). If an invariant subspace
            associated with the converged Ritz values is desired, see remark
            2 below, subroutine sneupd uses this output.
            See Data Distribution Note below.  
    WORKL   Real work array of length LWORKL.  (OUTPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  See Data Distribution Note below.
    LWORKL  Integer.  (INPUT)
            LWORKL must be at least 3*NCV**2 + 6*NCV.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =  0: Normal exit.
            =  1: Maximum number of iterations taken.
                  All possible eigenvalues of OP has been found. IPARAM(5)  
                  returns the number of wanted converged Ritz values.
            =  2: No longer an informational error. Deprecated starting
                  with release 2 of ARPACK.
            =  3: No shifts could be applied during a cycle of the 
                  Implicitly restarted Arnoldi iteration. One possibility 
                  is to increase the size of NCV relative to NEV. 
                  See remark 4 below.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV-NEV >= 2 and less than or equal to N.
            = -4: The maximum number of Arnoldi update iteration 
                  must be greater than zero.
            = -5: WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work array is not sufficient.
            = -8: Error return from LAPACK eigenvalue calculation;
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatable.
            = -12: IPARAM(1) must be equal to 0 or 1.
            = -9999: Could not build an Arnoldi factorization.
                     IPARAM(5) returns the size of the current Arnoldi
                     factorization.
  \Remarks
    1. The computed Ritz values are approximate eigenvalues of OP. The
       selection of WHICH should be made with this in mind when
       Mode = 3 and 4.  After convergence, approximate eigenvalues of the
       original problem may be obtained with the ARPACK subroutine sneupd.
    2. If a basis for the invariant subspace corresponding to the converged Ritz 
       values is needed, the user must call sneupd immediately following 
       completion of snaupd. This is new starting with release 2 of ARPACK.
    3. If M can be factored into a Cholesky factorization M = LL`
       then Mode = 2 should not be selected.  Instead one should use
       Mode = 1 with  OP = inv(L)*A*inv(L`).  Appropriate triangular 
       linear systems should be solved with L and L` rather
       than computing inverses.  After convergence, an approximate
       eigenvector z of the original problem is recovered by solving
       L`z = x  where x is a Ritz vector of OP.
    4. At present there is no a-priori analysis to guide the selection
       of NCV relative to NEV.  The only formal requrement is that NCV > NEV + 2.
       However, it is recommended that NCV .ge. 2*NEV+1.  If many problems of
       the same type are to be solved, one should experiment with increasing
       NCV while keeping NEV fixed for a given test problem.  This will 
       usually decrease the required number of OP*x operations but it
       also increases the work and storage required to maintain the orthogonal
       basis vectors.  The optimal "cross-over" with respect to CPU time
       is problem dependent and must be determined empirically. 
       See Chapter 8 of Reference 2 for further information.
    5. When IPARAM(1) = 0, and IDO = 3, the user needs to provide the 
       NP = IPARAM(8) real and imaginary parts of the shifts in locations 
           real part                  imaginary part
           -----------------------    --------------
       1   WORKL(IPNTR(14))           WORKL(IPNTR(14)+NP)
       2   WORKL(IPNTR(14)+1)         WORKL(IPNTR(14)+NP+1)
                          .                          .
                          .                          .
                          .                          .
       NP  WORKL(IPNTR(14)+NP-1)      WORKL(IPNTR(14)+2*NP-1).
       Only complex conjugate pairs of shifts may be applied and the pairs 
       must be placed in consecutive locations. The real part of the 
       eigenvalues of the current upper Hessenberg matrix are located in 
       WORKL(IPNTR(6)) through WORKL(IPNTR(6)+NCV-1) and the imaginary part 
       in WORKL(IPNTR(7)) through WORKL(IPNTR(7)+NCV-1). They are ordered
       according to the order defined by WHICH. The complex conjugate
       pairs are kept together and the associated Ritz estimates are located in
       WORKL(IPNTR(8)), WORKL(IPNTR(8)+1), ... , WORKL(IPNTR(8)+NCV-1).
  -----------------------------------------------------------------------
  \Data Distribution Note: 
    Fortran-D syntax:
    ================
    Real resid(n), v(ldv,ncv), workd(3*n), workl(lworkl)
    decompose  d1(n), d2(n,ncv)
    align      resid(i) with d1(i)
    align      v(i,j)   with d2(i,j)
    align      workd(i) with d1(i)     range (1:n)
    align      workd(i) with d1(i-n)   range (n+1:2*n)
    align      workd(i) with d1(i-2*n) range (2*n+1:3*n)
    distribute d1(block), d2(block,:)
    replicated workl(lworkl)
    Cray MPP syntax:
    ===============
    Real  resid(n), v(ldv,ncv), workd(n,3), workl(lworkl)
    shared     resid(block), v(block,:), workd(block,:)
    replicated workl(lworkl)
    
    CM2/CM5 syntax:
    ==============
    
  -----------------------------------------------------------------------
       include   'ex-nonsym.doc'
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett & Y. Saad, "Complex Shift and Invert Strategies for
       Real Matrices", Linear Algebra and its Applications, vol 88/89,
       pp 575-595, (1987).
  \Routines called:
       snaup2  ARPACK routine that implements the Implicitly Restarted
               Arnoldi Iteration.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/16/93: Version '1.1'
  \SCCS Information: @(#) 
   FILE: naupd.F   SID: 2.10   DATE OF SID: 08/23/02   RELEASE: 2
  \Remarks
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param ncv
   * @param v
   * @param ldv
   * @param iparam
   * @param ipntr
   * @param workd
   * @param workl
   * @param lworkl
   * @param info
   * 
   */
  abstract public void snaupd(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, int nev, org.netlib.util.floatW tol, float[] resid, int ncv, float[] v, int ldv, int[] iparam, int[] ipntr, float[] workd, float[] workl, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: snaupd
  \Description: 
    Reverse communication interface for the Implicitly Restarted Arnoldi
    iteration. This subroutine computes approximations to a few eigenpairs 
    of a linear operator "OP" with respect to a semi-inner product defined by 
    a symmetric positive semi-definite real matrix B. B may be the identity 
    matrix. NOTE: If the linear operator "OP" is real and symmetric 
    with respect to the real positive semi-definite symmetric matrix B, 
    i.e. B*OP = (OP`)*B, then subroutine ssaupd should be used instead.
    The computed approximate eigenvalues are called Ritz values and
    the corresponding approximate eigenvectors are called Ritz vectors.
    snaupd is usually called iteratively to solve one of the 
    following problems:
    Mode 1:  A*x = lambda*x.
             ===> OP = A  and  B = I.
    Mode 2:  A*x = lambda*M*x, M symmetric positive definite
             ===> OP = inv[M]*A  and  B = M.
             ===> (If M can be factored see remark 3 below)
    Mode 3:  A*x = lambda*M*x, M symmetric semi-definite
             ===> OP = Real_Part{ inv[A - sigma*M]*M }  and  B = M. 
             ===> shift-and-invert mode (in real arithmetic)
             If OP*x = amu*x, then 
             amu = 1/2 * [ 1/(lambda-sigma) + 1/(lambda-conjg(sigma)) ].
             Note: If sigma is real, i.e. imaginary part of sigma is zero;
                   Real_Part{ inv[A - sigma*M]*M } == inv[A - sigma*M]*M 
                   amu == 1/(lambda-sigma). 
    
    Mode 4:  A*x = lambda*M*x, M symmetric semi-definite
             ===> OP = Imaginary_Part{ inv[A - sigma*M]*M }  and  B = M. 
             ===> shift-and-invert mode (in real arithmetic)
             If OP*x = amu*x, then 
             amu = 1/2i * [ 1/(lambda-sigma) - 1/(lambda-conjg(sigma)) ].
    Both mode 3 and 4 give the same enhancement to eigenvalues close to
    the (complex) shift sigma.  However, as lambda goes to infinity,
    the operator OP in mode 4 dampens the eigenvalues more strongly than
    does OP defined in mode 3.
    NOTE: The action of w <- inv[A - sigma*M]*v or w <- inv[M]*v
          should be accomplished either by a direct method
          using a sparse matrix factorization and solving
             [A - sigma*M]*w = v  or M*w = v,
          or through an iterative method for solving these
          systems.  If an iterative method is used, the
          convergence test must be more stringent than
          the accuracy requirements for the eigenvalue
          approximations.
  \Usage:
    call snaupd
       ( IDO, BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM,
         IPNTR, WORKD, WORKL, LWORKL, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first 
            call to snaupd.  IDO will be set internally to
            indicate the type of operation to be performed.  Control is
            then given back to the calling routine which has the
            responsibility to carry out the requested operation and call
            snaupd with the result.  The operand is given in
            WORKD(IPNTR(1)), the result must be put in WORKD(IPNTR(2)).
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      In mode 3 and 4, the vector B * X is already
                      available in WORKD(ipntr(3)).  It does not
                      need to be recomputed in forming OP * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO =  3: compute the IPARAM(8) real and imaginary parts 
                      of the shifts where INPTR(14) is the pointer
                      into WORKL for placing the shifts. See Remark
                      5 below.
            IDO = 99: done
            -------------------------------------------------------------
               
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.
            BMAT = 'I' -> standard eigenvalue problem A*x = lambda*x
            BMAT = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    WHICH   Character*2.  (INPUT)
            'LM' -> want the NEV eigenvalues of largest magnitude.
            'SM' -> want the NEV eigenvalues of smallest magnitude.
            'LR' -> want the NEV eigenvalues of largest real part.
            'SR' -> want the NEV eigenvalues of smallest real part.
            'LI' -> want the NEV eigenvalues of largest imaginary part.
            'SI' -> want the NEV eigenvalues of smallest imaginary part.
    NEV     Integer.  (INPUT/OUTPUT)
            Number of eigenvalues of OP to be computed. 0 < NEV < N-1.
    TOL     Real scalar.  (INPUT)
            Stopping criterion: the relative accuracy of the Ritz value 
            is considered acceptable if BOUNDS(I) .LE. TOL*ABS(RITZ(I))
            where ABS(RITZ(I)) is the magnitude when RITZ(I) is complex.
            DEFAULT = SLAMCH('EPS')  (machine precision as computed
                      by the LAPACK auxiliary subroutine SLAMCH).
    RESID   Real array of length N.  (INPUT/OUTPUT)
            On INPUT: 
            If INFO .EQ. 0, a random initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            On OUTPUT:
            RESID contains the final residual vector.
    NCV     Integer.  (INPUT)
            Number of columns of the matrix V. NCV must satisfy the two
            inequalities 2 <= NCV-NEV and NCV <= N.
            This will indicate how many Arnoldi vectors are generated 
            at each iteration.  After the startup phase in which NEV 
            Arnoldi vectors are generated, the algorithm generates 
            approximately NCV-NEV Arnoldi vectors at each subsequent update 
            iteration. Most of the cost in generating each Arnoldi vector is 
            in the matrix-vector operation OP*x. 
            NOTE: 2 <= NCV-NEV in order that complex conjugate pairs of Ritz 
            values are kept together. (See remark 4 below)
    V       Real array N by NCV.  (OUTPUT)
            Contains the final set of Arnoldi basis vectors. 
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling program.
    IPARAM  Integer array of length 11.  (INPUT/OUTPUT)
            IPARAM(1) = ISHIFT: method for selecting the implicit shifts.
            The shifts selected at each iteration are used to restart
            the Arnoldi iteration in an implicit fashion.
            -------------------------------------------------------------
            ISHIFT = 0: the shifts are provided by the user via
                        reverse communication.  The real and imaginary
                        parts of the NCV eigenvalues of the Hessenberg
                        matrix H are returned in the part of the WORKL 
                        array corresponding to RITZR and RITZI. See remark 
                        5 below.
            ISHIFT = 1: exact shifts with respect to the current
                        Hessenberg matrix H.  This is equivalent to 
                        restarting the iteration with a starting vector
                        that is a linear combination of approximate Schur
                        vectors associated with the "wanted" Ritz values.
            -------------------------------------------------------------
            IPARAM(2) = No longer referenced.
            IPARAM(3) = MXITER
            On INPUT:  maximum number of Arnoldi update iterations allowed. 
            On OUTPUT: actual number of Arnoldi update iterations taken. 
            IPARAM(4) = NB: blocksize to be used in the recurrence.
            The code currently works only for NB = 1.
            IPARAM(5) = NCONV: number of "converged" Ritz values.
            This represents the number of Ritz values that satisfy
            the convergence criterion.
            IPARAM(6) = IUPD
            No longer referenced. Implicit restarting is ALWAYS used.  
            IPARAM(7) = MODE
            On INPUT determines what type of eigenproblem is being solved.
            Must be 1,2,3,4; See under \Description of snaupd for the 
            four modes available.
            IPARAM(8) = NP
            When ido = 3 and the user provides shifts through reverse
            communication (IPARAM(1)=0), snaupd returns NP, the number
            of shifts the user is to provide. 0 < NP <=NCV-NEV. See Remark
            5 below.
            IPARAM(9) = NUMOP, IPARAM(10) = NUMOPB, IPARAM(11) = NUMREO,
            OUTPUT: NUMOP  = total number of OP*x operations,
                    NUMOPB = total number of B*x operations if BMAT='G',
                    NUMREO = total number of steps of re-orthogonalization.        
    IPNTR   Integer array of length 14.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD and WORKL
            arrays for matrices/vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X in WORKD.
            IPNTR(2): pointer to the current result vector Y in WORKD.
            IPNTR(3): pointer to the vector B * X in WORKD when used in 
                      the shift-and-invert mode.
            IPNTR(4): pointer to the next available location in WORKL
                      that is untouched by the program.
            IPNTR(5): pointer to the NCV by NCV upper Hessenberg matrix
                      H in WORKL.
            IPNTR(6): pointer to the real part of the ritz value array 
                      RITZR in WORKL.
            IPNTR(7): pointer to the imaginary part of the ritz value array
                      RITZI in WORKL.
            IPNTR(8): pointer to the Ritz estimates in array WORKL associated
                      with the Ritz values located in RITZR and RITZI in WORKL.
            IPNTR(14): pointer to the NP shifts in WORKL. See Remark 5 below.
            Note: IPNTR(9:13) is only referenced by sneupd. See Remark 2 below.
            IPNTR(9):  pointer to the real part of the NCV RITZ values of the 
                       original system.
            IPNTR(10): pointer to the imaginary part of the NCV RITZ values of 
                       the original system.
            IPNTR(11): pointer to the NCV corresponding error bounds.
            IPNTR(12): pointer to the NCV by NCV upper quasi-triangular
                       Schur matrix for H.
            IPNTR(13): pointer to the NCV by NCV matrix of eigenvectors
                       of the upper Hessenberg matrix H. Only referenced by
                       sneupd if RVEC = .TRUE. See Remark 2 below.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD 
            as temporary workspace during the iteration. Upon termination
            WORKD(1:N) contains B*RESID(1:N). If an invariant subspace
            associated with the converged Ritz values is desired, see remark
            2 below, subroutine sneupd uses this output.
            See Data Distribution Note below.  
    WORKL   Real work array of length LWORKL.  (OUTPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  See Data Distribution Note below.
    LWORKL  Integer.  (INPUT)
            LWORKL must be at least 3*NCV**2 + 6*NCV.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =  0: Normal exit.
            =  1: Maximum number of iterations taken.
                  All possible eigenvalues of OP has been found. IPARAM(5)  
                  returns the number of wanted converged Ritz values.
            =  2: No longer an informational error. Deprecated starting
                  with release 2 of ARPACK.
            =  3: No shifts could be applied during a cycle of the 
                  Implicitly restarted Arnoldi iteration. One possibility 
                  is to increase the size of NCV relative to NEV. 
                  See remark 4 below.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV-NEV >= 2 and less than or equal to N.
            = -4: The maximum number of Arnoldi update iteration 
                  must be greater than zero.
            = -5: WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work array is not sufficient.
            = -8: Error return from LAPACK eigenvalue calculation;
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatable.
            = -12: IPARAM(1) must be equal to 0 or 1.
            = -9999: Could not build an Arnoldi factorization.
                     IPARAM(5) returns the size of the current Arnoldi
                     factorization.
  \Remarks
    1. The computed Ritz values are approximate eigenvalues of OP. The
       selection of WHICH should be made with this in mind when
       Mode = 3 and 4.  After convergence, approximate eigenvalues of the
       original problem may be obtained with the ARPACK subroutine sneupd.
    2. If a basis for the invariant subspace corresponding to the converged Ritz 
       values is needed, the user must call sneupd immediately following 
       completion of snaupd. This is new starting with release 2 of ARPACK.
    3. If M can be factored into a Cholesky factorization M = LL`
       then Mode = 2 should not be selected.  Instead one should use
       Mode = 1 with  OP = inv(L)*A*inv(L`).  Appropriate triangular 
       linear systems should be solved with L and L` rather
       than computing inverses.  After convergence, an approximate
       eigenvector z of the original problem is recovered by solving
       L`z = x  where x is a Ritz vector of OP.
    4. At present there is no a-priori analysis to guide the selection
       of NCV relative to NEV.  The only formal requrement is that NCV > NEV + 2.
       However, it is recommended that NCV .ge. 2*NEV+1.  If many problems of
       the same type are to be solved, one should experiment with increasing
       NCV while keeping NEV fixed for a given test problem.  This will 
       usually decrease the required number of OP*x operations but it
       also increases the work and storage required to maintain the orthogonal
       basis vectors.  The optimal "cross-over" with respect to CPU time
       is problem dependent and must be determined empirically. 
       See Chapter 8 of Reference 2 for further information.
    5. When IPARAM(1) = 0, and IDO = 3, the user needs to provide the 
       NP = IPARAM(8) real and imaginary parts of the shifts in locations 
           real part                  imaginary part
           -----------------------    --------------
       1   WORKL(IPNTR(14))           WORKL(IPNTR(14)+NP)
       2   WORKL(IPNTR(14)+1)         WORKL(IPNTR(14)+NP+1)
                          .                          .
                          .                          .
                          .                          .
       NP  WORKL(IPNTR(14)+NP-1)      WORKL(IPNTR(14)+2*NP-1).
       Only complex conjugate pairs of shifts may be applied and the pairs 
       must be placed in consecutive locations. The real part of the 
       eigenvalues of the current upper Hessenberg matrix are located in 
       WORKL(IPNTR(6)) through WORKL(IPNTR(6)+NCV-1) and the imaginary part 
       in WORKL(IPNTR(7)) through WORKL(IPNTR(7)+NCV-1). They are ordered
       according to the order defined by WHICH. The complex conjugate
       pairs are kept together and the associated Ritz estimates are located in
       WORKL(IPNTR(8)), WORKL(IPNTR(8)+1), ... , WORKL(IPNTR(8)+NCV-1).
  -----------------------------------------------------------------------
  \Data Distribution Note: 
    Fortran-D syntax:
    ================
    Real resid(n), v(ldv,ncv), workd(3*n), workl(lworkl)
    decompose  d1(n), d2(n,ncv)
    align      resid(i) with d1(i)
    align      v(i,j)   with d2(i,j)
    align      workd(i) with d1(i)     range (1:n)
    align      workd(i) with d1(i-n)   range (n+1:2*n)
    align      workd(i) with d1(i-2*n) range (2*n+1:3*n)
    distribute d1(block), d2(block,:)
    replicated workl(lworkl)
    Cray MPP syntax:
    ===============
    Real  resid(n), v(ldv,ncv), workd(n,3), workl(lworkl)
    shared     resid(block), v(block,:), workd(block,:)
    replicated workl(lworkl)
    
    CM2/CM5 syntax:
    ==============
    
  -----------------------------------------------------------------------
       include   'ex-nonsym.doc'
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett & Y. Saad, "Complex Shift and Invert Strategies for
       Real Matrices", Linear Algebra and its Applications, vol 88/89,
       pp 575-595, (1987).
  \Routines called:
       snaup2  ARPACK routine that implements the Implicitly Restarted
               Arnoldi Iteration.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/16/93: Version '1.1'
  \SCCS Information: @(#) 
   FILE: naupd.F   SID: 2.10   DATE OF SID: 08/23/02   RELEASE: 2
  \Remarks
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param ncv
   * @param v
   * @param _v_offset
   * @param ldv
   * @param iparam
   * @param _iparam_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param workl
   * @param _workl_offset
   * @param lworkl
   * @param info
   * 
   */
  abstract public void snaupd(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, int nev, org.netlib.util.floatW tol, float[] resid, int _resid_offset, int ncv, float[] v, int _v_offset, int ldv, int[] iparam, int _iparam_offset, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, float[] workl, int _workl_offset, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: snconv
  \Description: 
    Convergence testing for the nonsymmetric Arnoldi eigenvalue routine.
  \Usage:
    call snconv
       ( N, RITZR, RITZI, BOUNDS, TOL, NCONV )
  \Arguments
    N       Integer.  (INPUT)
            Number of Ritz values to check for convergence.
    RITZR,  Real arrays of length N.  (INPUT)
    RITZI   Real and imaginary parts of the Ritz values to be checked
            for convergence.
    BOUNDS  Real array of length N.  (INPUT)
            Ritz estimates for the Ritz values in RITZR and RITZI.
    TOL     Real scalar.  (INPUT)
            Desired backward error for a Ritz value to be considered
            "converged".
    NCONV   Integer scalar.  (OUTPUT)
            Number of "converged" Ritz values.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       second  ARPACK utility routine for timing.
       slamch  LAPACK routine that determines machine constants.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas
       Applied Mathematics 
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: nconv.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       1. xxxx
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param ritzr
   * @param ritzi
   * @param bounds
   * @param tol
   * @param nconv
   * 
   */
  abstract public void snconv(int n, float[] ritzr, float[] ritzi, float[] bounds, float tol, org.netlib.util.intW nconv);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: snconv
  \Description: 
    Convergence testing for the nonsymmetric Arnoldi eigenvalue routine.
  \Usage:
    call snconv
       ( N, RITZR, RITZI, BOUNDS, TOL, NCONV )
  \Arguments
    N       Integer.  (INPUT)
            Number of Ritz values to check for convergence.
    RITZR,  Real arrays of length N.  (INPUT)
    RITZI   Real and imaginary parts of the Ritz values to be checked
            for convergence.
    BOUNDS  Real array of length N.  (INPUT)
            Ritz estimates for the Ritz values in RITZR and RITZI.
    TOL     Real scalar.  (INPUT)
            Desired backward error for a Ritz value to be considered
            "converged".
    NCONV   Integer scalar.  (OUTPUT)
            Number of "converged" Ritz values.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       second  ARPACK utility routine for timing.
       slamch  LAPACK routine that determines machine constants.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas
       Applied Mathematics 
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: nconv.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       1. xxxx
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param ritzr
   * @param _ritzr_offset
   * @param ritzi
   * @param _ritzi_offset
   * @param bounds
   * @param _bounds_offset
   * @param tol
   * @param nconv
   * 
   */
  abstract public void snconv(int n, float[] ritzr, int _ritzr_offset, float[] ritzi, int _ritzi_offset, float[] bounds, int _bounds_offset, float tol, org.netlib.util.intW nconv);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sneigh
  \Description:
    Compute the eigenvalues of the current upper Hessenberg matrix
    and the corresponding Ritz estimates given the current residual norm.
  \Usage:
    call sneigh
       ( RNORM, N, H, LDH, RITZR, RITZI, BOUNDS, Q, LDQ, WORKL, IERR )
  \Arguments
    RNORM   Real scalar.  (INPUT)
            Residual norm corresponding to the current upper Hessenberg 
            matrix H.
    N       Integer.  (INPUT)
            Size of the matrix H.
    H       Real N by N array.  (INPUT)
            H contains the current upper Hessenberg matrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RITZR,  Real arrays of length N.  (OUTPUT)
    RITZI   On output, RITZR(1:N) (resp. RITZI(1:N)) contains the real 
            (respectively imaginary) parts of the eigenvalues of H.
    BOUNDS  Real array of length N.  (OUTPUT)
            On output, BOUNDS contains the Ritz estimates associated with
            the eigenvalues RITZR and RITZI.  This is equal to RNORM 
            times the last components of the eigenvectors corresponding 
            to the eigenvalues in RITZR and RITZI.
    Q       Real N by N array.  (WORKSPACE)
            Workspace needed to store the eigenvectors of H.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Real work array of length N**2 + 3*N.  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  This is needed to keep the full Schur form
            of H and also in the calculation of the eigenvectors of H.
    IERR    Integer.  (OUTPUT)
            Error exit flag from slaqrb or strevc.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       slaqrb  ARPACK routine to compute the real Schur form of an
               upper Hessenberg matrix and last row of the Schur vectors.
       second  ARPACK utility routine for timing.
       smout   ARPACK utility routine that prints matrices
       svout   ARPACK utility routine that prints vectors.
       slacpy  LAPACK matrix copy routine.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       strevc  LAPACK routine to compute the eigenvectors of a matrix
               in upper quasi-triangular form
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       scopy   Level 1 BLAS that copies one vector to another .
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sscal   Level 1 BLAS that scales a vector.
       
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: neigh.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rnorm
   * @param n
   * @param h
   * @param ldh
   * @param ritzr
   * @param ritzi
   * @param bounds
   * @param q
   * @param ldq
   * @param workl
   * @param ierr
   * 
   */
  abstract public void sneigh(float rnorm, org.netlib.util.intW n, float[] h, int ldh, float[] ritzr, float[] ritzi, float[] bounds, float[] q, int ldq, float[] workl, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sneigh
  \Description:
    Compute the eigenvalues of the current upper Hessenberg matrix
    and the corresponding Ritz estimates given the current residual norm.
  \Usage:
    call sneigh
       ( RNORM, N, H, LDH, RITZR, RITZI, BOUNDS, Q, LDQ, WORKL, IERR )
  \Arguments
    RNORM   Real scalar.  (INPUT)
            Residual norm corresponding to the current upper Hessenberg 
            matrix H.
    N       Integer.  (INPUT)
            Size of the matrix H.
    H       Real N by N array.  (INPUT)
            H contains the current upper Hessenberg matrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RITZR,  Real arrays of length N.  (OUTPUT)
    RITZI   On output, RITZR(1:N) (resp. RITZI(1:N)) contains the real 
            (respectively imaginary) parts of the eigenvalues of H.
    BOUNDS  Real array of length N.  (OUTPUT)
            On output, BOUNDS contains the Ritz estimates associated with
            the eigenvalues RITZR and RITZI.  This is equal to RNORM 
            times the last components of the eigenvectors corresponding 
            to the eigenvalues in RITZR and RITZI.
    Q       Real N by N array.  (WORKSPACE)
            Workspace needed to store the eigenvectors of H.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKL   Real work array of length N**2 + 3*N.  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  This is needed to keep the full Schur form
            of H and also in the calculation of the eigenvectors of H.
    IERR    Integer.  (OUTPUT)
            Error exit flag from slaqrb or strevc.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       slaqrb  ARPACK routine to compute the real Schur form of an
               upper Hessenberg matrix and last row of the Schur vectors.
       second  ARPACK utility routine for timing.
       smout   ARPACK utility routine that prints matrices
       svout   ARPACK utility routine that prints vectors.
       slacpy  LAPACK matrix copy routine.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       strevc  LAPACK routine to compute the eigenvectors of a matrix
               in upper quasi-triangular form
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       scopy   Level 1 BLAS that copies one vector to another .
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sscal   Level 1 BLAS that scales a vector.
       
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: neigh.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rnorm
   * @param n
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ritzr
   * @param _ritzr_offset
   * @param ritzi
   * @param _ritzi_offset
   * @param bounds
   * @param _bounds_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workl
   * @param _workl_offset
   * @param ierr
   * 
   */
  abstract public void sneigh(float rnorm, org.netlib.util.intW n, float[] h, int _h_offset, int ldh, float[] ritzr, int _ritzr_offset, float[] ritzi, int _ritzi_offset, float[] bounds, int _bounds_offset, float[] q, int _q_offset, int ldq, float[] workl, int _workl_offset, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: sneupd
  \Description: 
    This subroutine returns the converged approximations to eigenvalues
    of A*z = lambda*B*z and (optionally):
        (1) The corresponding approximate eigenvectors;
        (2) An orthonormal basis for the associated approximate
            invariant subspace;
        (3) Both.
    There is negligible additional cost to obtain eigenvectors.  An orthonormal
    basis is always computed.  There is an additional storage cost of n*nev
    if both are requested (in this case a separate array Z must be supplied).
    The approximate eigenvalues and eigenvectors of  A*z = lambda*B*z
    are derived from approximate eigenvalues and eigenvectors of
    of the linear operator OP prescribed by the MODE selection in the
    call to SNAUPD.  SNAUPD must be called before this routine is called.
    These approximate eigenvalues and vectors are commonly called Ritz
    values and Ritz vectors respectively.  They are referred to as such
    in the comments that follow.  The computed orthonormal basis for the
    invariant subspace corresponding to these Ritz values is referred to as a
    Schur basis.
    See documentation in the header of the subroutine SNAUPD for 
    definition of OP as well as other terms and the relation of computed
    Ritz values and Ritz vectors of OP with respect to the given problem
    A*z = lambda*B*z.  For a brief description, see definitions of 
    IPARAM(7), MODE and WHICH in the documentation of SNAUPD.
  \Usage:
    call sneupd 
       ( RVEC, HOWMNY, SELECT, DR, DI, Z, LDZ, SIGMAR, SIGMAI, WORKEV, BMAT, 
         N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR, WORKD, WORKL, 
         LWORKL, INFO )
  \Arguments:
    RVEC    LOGICAL  (INPUT) 
            Specifies whether a basis for the invariant subspace corresponding 
            to the converged Ritz value approximations for the eigenproblem 
            A*z = lambda*B*z is computed.
               RVEC = .FALSE.     Compute Ritz values only.
               RVEC = .TRUE.      Compute the Ritz vectors or Schur vectors.
                                  See Remarks below. 
   
    HOWMNY  Character*1  (INPUT) 
            Specifies the form of the basis for the invariant subspace 
            corresponding to the converged Ritz values that is to be computed.
            = 'A': Compute NEV Ritz vectors; 
            = 'P': Compute NEV Schur vectors;
            = 'S': compute some of the Ritz vectors, specified
                   by the logical array SELECT.
    SELECT  Logical array of dimension NCV.  (INPUT)
            If HOWMNY = 'S', SELECT specifies the Ritz vectors to be
            computed. To select the Ritz vector corresponding to a
            Ritz value (DR(j), DI(j)), SELECT(j) must be set to .TRUE.. 
            If HOWMNY = 'A' or 'P', SELECT is used as internal workspace.
    DR      Real  array of dimension NEV+1.  (OUTPUT)
            If IPARAM(7) = 1,2 or 3 and SIGMAI=0.0  then on exit: DR contains 
            the real part of the Ritz  approximations to the eigenvalues of 
            A*z = lambda*B*z. 
            If IPARAM(7) = 3, 4 and SIGMAI is not equal to zero, then on exit:
            DR contains the real part of the Ritz values of OP computed by 
            SNAUPD. A further computation must be performed by the user
            to transform the Ritz values computed for OP by SNAUPD to those
            of the original system A*z = lambda*B*z. See remark 3 below.
    DI      Real  array of dimension NEV+1.  (OUTPUT)
            On exit, DI contains the imaginary part of the Ritz value 
            approximations to the eigenvalues of A*z = lambda*B*z associated
            with DR.
            NOTE: When Ritz values are complex, they will come in complex 
                  conjugate pairs.  If eigenvectors are requested, the 
                  corresponding Ritz vectors will also come in conjugate 
                  pairs and the real and imaginary parts of these are 
                  represented in two consecutive columns of the array Z 
                  (see below).
    Z       Real  N by NEV+1 array if RVEC = .TRUE. and HOWMNY = 'A'. (OUTPUT)
            On exit, if RVEC = .TRUE. and HOWMNY = 'A', then the columns of 
            Z represent approximate eigenvectors (Ritz vectors) corresponding 
            to the NCONV=IPARAM(5) Ritz values for eigensystem 
            A*z = lambda*B*z. 
   
            The complex Ritz vector associated with the Ritz value 
            with positive imaginary part is stored in two consecutive 
            columns.  The first column holds the real part of the Ritz 
            vector and the second column holds the imaginary part.  The 
            Ritz vector associated with the Ritz value with negative 
            imaginary part is simply the complex conjugate of the Ritz vector 
            associated with the positive imaginary part.
            If  RVEC = .FALSE. or HOWMNY = 'P', then Z is not referenced.
            NOTE: If if RVEC = .TRUE. and a Schur basis is not required,
            the array Z may be set equal to first NEV+1 columns of the Arnoldi
            basis array V computed by SNAUPD.  In this case the Arnoldi basis
            will be destroyed and overwritten with the eigenvector basis.
    LDZ     Integer.  (INPUT)
            The leading dimension of the array Z.  If Ritz vectors are
            desired, then  LDZ >= max( 1, N ).  In any case,  LDZ >= 1.
    SIGMAR  Real   (INPUT)
            If IPARAM(7) = 3 or 4, represents the real part of the shift. 
            Not referenced if IPARAM(7) = 1 or 2.
    SIGMAI  Real   (INPUT)
            If IPARAM(7) = 3 or 4, represents the imaginary part of the shift. 
            Not referenced if IPARAM(7) = 1 or 2. See remark 3 below.
    WORKEV  Real  work array of dimension 3*NCV.  (WORKSPACE)
    **** The remaining arguments MUST be the same as for the   ****
    **** call to SNAUPD that was just completed.               ****
    NOTE: The remaining arguments
             BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR,
             WORKD, WORKL, LWORKL, INFO
           must be passed directly to SNEUPD following the last call
           to SNAUPD.  These arguments MUST NOT BE MODIFIED between
           the the last call to SNAUPD and the call to SNEUPD.
    Three of these parameters (V, WORKL, INFO) are also output parameters:
    V       Real  N by NCV array.  (INPUT/OUTPUT)
            Upon INPUT: the NCV columns of V contain the Arnoldi basis
                        vectors for OP as constructed by SNAUPD .
            Upon OUTPUT: If RVEC = .TRUE. the first NCONV=IPARAM(5) columns
                         contain approximate Schur vectors that span the
                         desired invariant subspace.  See Remark 2 below.
            NOTE: If the array Z has been set equal to first NEV+1 columns
            of the array V and RVEC=.TRUE. and HOWMNY= 'A', then the
            Arnoldi basis held by V has been overwritten by the desired
            Ritz vectors.  If a separate array Z has been passed then
            the first NCONV=IPARAM(5) columns of V will contain approximate
            Schur vectors that span the desired invariant subspace.
    WORKL   Real  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            WORKL(1:ncv*ncv+3*ncv) contains information obtained in
            snaupd.  They are not changed by sneupd.
            WORKL(ncv*ncv+3*ncv+1:3*ncv*ncv+6*ncv) holds the
            real and imaginary part of the untransformed Ritz values,
            the upper quasi-triangular matrix for H, and the
            associated matrix representation of the invariant subspace for H.
            Note: IPNTR(9:13) contains the pointer into WORKL for addresses
            of the above information computed by sneupd.
            -------------------------------------------------------------
            IPNTR(9):  pointer to the real part of the NCV RITZ values of the
                       original system.
            IPNTR(10): pointer to the imaginary part of the NCV RITZ values of
                       the original system.
            IPNTR(11): pointer to the NCV corresponding error bounds.
            IPNTR(12): pointer to the NCV by NCV upper quasi-triangular
                       Schur matrix for H.
            IPNTR(13): pointer to the NCV by NCV matrix of eigenvectors
                       of the upper Hessenberg matrix H. Only referenced by
                       sneupd if RVEC = .TRUE. See Remark 2 below.
            -------------------------------------------------------------
    INFO    Integer.  (OUTPUT)
            Error flag on output.
            =  0: Normal exit.
            =  1: The Schur form computed by LAPACK routine slahqr
                  could not be reordered by LAPACK routine strsen.
                  Re-enter subroutine sneupd with IPARAM(5)=NCV and 
                  increase the size of the arrays DR and DI to have 
                  dimension at least dimension NCV and allocate at least NCV 
                  columns for Z. NOTE: Not necessary if Z and V share 
                  the same space. Please notify the authors if this error
                  occurs.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV-NEV >= 2 and less than or equal to N.
            = -5: WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work WORKL array is not sufficient.
            = -8: Error return from calculation of a real Schur form.
                  Informational error from LAPACK routine slahqr.
            = -9: Error return from calculation of eigenvectors.
                  Informational error from LAPACK routine strevc.
            = -10: IPARAM(7) must be 1,2,3,4.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatible.
            = -12: HOWMNY = 'S' not yet implemented
            = -13: HOWMNY must be one of 'A' or 'P' if RVEC = .true.
            = -14: SNAUPD did not find any eigenvalues to sufficient
                   accuracy.
            = -15: DNEUPD got a different count of the number of converged
                   Ritz values than DNAUPD got.  This indicates the user
                   probably made an error in passing data from DNAUPD to
                   DNEUPD or that the data was modified before entering
                   DNEUPD
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett & Y. Saad, "Complex Shift and Invert Strategies for
       Real Matrices", Linear Algebra and its Applications, vol 88/89,
       pp 575-595, (1987).
  \Routines called:
       ivout   ARPACK utility routine that prints integers.
       smout   ARPACK utility routine that prints matrices
       svout   ARPACK utility routine that prints vectors.
       sgeqr2  LAPACK routine that computes the QR factorization of 
               a matrix.
       slacpy  LAPACK matrix copy routine.
       slahqr  LAPACK routine to compute the real Schur form of an
               upper Hessenberg matrix.
       slamch  LAPACK routine that determines machine constants.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       slaset  LAPACK matrix initialization routine.
       sorm2r  LAPACK routine that applies an orthogonal matrix in 
               factored form.
       strevc  LAPACK routine to compute the eigenvectors of a matrix
               in upper quasi-triangular form.
       strsen  LAPACK routine that re-orders the Schur form.
       strmm   Level 3 BLAS matrix times an upper triangular matrix.
       sger    Level 2 BLAS rank one update to a matrix.
       scopy   Level 1 BLAS that copies one vector to another .
       sdot    Level 1 BLAS that computes the scalar product of two vectors.
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sscal   Level 1 BLAS that scales a vector.
  \Remarks
    1. Currently only HOWMNY = 'A' and 'P' are implemented.
       Let trans(X) denote the transpose of X.
    2. Schur vectors are an orthogonal representation for the basis of
       Ritz vectors. Thus, their numerical properties are often superior.
       If RVEC = .TRUE. then the relationship
               A * V(:,1:IPARAM(5)) = V(:,1:IPARAM(5)) * T, and
       trans(V(:,1:IPARAM(5))) * V(:,1:IPARAM(5)) = I are approximately 
       satisfied. Here T is the leading submatrix of order IPARAM(5) of the 
       real upper quasi-triangular matrix stored workl(ipntr(12)). That is,
       T is block upper triangular with 1-by-1 and 2-by-2 diagonal blocks; 
       each 2-by-2 diagonal block has its diagonal elements equal and its
       off-diagonal elements of opposite sign.  Corresponding to each 2-by-2
       diagonal block is a complex conjugate pair of Ritz values. The real
       Ritz values are stored on the diagonal of T.
    3. If IPARAM(7) = 3 or 4 and SIGMAI is not equal zero, then the user must
       form the IPARAM(5) Rayleigh quotients in order to transform the Ritz
       values computed by SNAUPD for OP to those of A*z = lambda*B*z. 
       Set RVEC = .true. and HOWMNY = 'A', and
       compute 
             trans(Z(:,I)) * A * Z(:,I) if DI(I) = 0.
       If DI(I) is not equal to zero and DI(I+1) = - D(I), 
       then the desired real and imaginary parts of the Ritz value are
             trans(Z(:,I)) * A * Z(:,I) +  trans(Z(:,I+1)) * A * Z(:,I+1),
             trans(Z(:,I)) * A * Z(:,I+1) -  trans(Z(:,I+1)) * A * Z(:,I), 
       respectively.
       Another possibility is to set RVEC = .true. and HOWMNY = 'P' and
       compute trans(V(:,1:IPARAM(5))) * A * V(:,1:IPARAM(5)) and then an upper
       quasi-triangular matrix of order IPARAM(5) is computed. See remark
       2 above.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Chao Yang                    Houston, Texas
       Dept. of Computational &
       Applied Mathematics          
       Rice University           
       Houston, Texas            
   
  \SCCS Information: @(#) 
   FILE: neupd.F   SID: 2.7   DATE OF SID: 09/20/00   RELEASE: 2 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rvec
   * @param howmny
   * @param select
   * @param dr
   * @param di
   * @param z
   * @param ldz
   * @param sigmar
   * @param sigmai
   * @param workev
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param ncv
   * @param v
   * @param ldv
   * @param iparam
   * @param ipntr
   * @param workd
   * @param workl
   * @param lworkl
   * @param info
   * 
   */
  abstract public void sneupd(boolean rvec, java.lang.String howmny, boolean[] select, float[] dr, float[] di, float[] z, int ldz, float sigmar, float sigmai, float[] workev, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, float tol, float[] resid, int ncv, float[] v, int ldv, int[] iparam, int[] ipntr, float[] workd, float[] workl, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: sneupd
  \Description: 
    This subroutine returns the converged approximations to eigenvalues
    of A*z = lambda*B*z and (optionally):
        (1) The corresponding approximate eigenvectors;
        (2) An orthonormal basis for the associated approximate
            invariant subspace;
        (3) Both.
    There is negligible additional cost to obtain eigenvectors.  An orthonormal
    basis is always computed.  There is an additional storage cost of n*nev
    if both are requested (in this case a separate array Z must be supplied).
    The approximate eigenvalues and eigenvectors of  A*z = lambda*B*z
    are derived from approximate eigenvalues and eigenvectors of
    of the linear operator OP prescribed by the MODE selection in the
    call to SNAUPD.  SNAUPD must be called before this routine is called.
    These approximate eigenvalues and vectors are commonly called Ritz
    values and Ritz vectors respectively.  They are referred to as such
    in the comments that follow.  The computed orthonormal basis for the
    invariant subspace corresponding to these Ritz values is referred to as a
    Schur basis.
    See documentation in the header of the subroutine SNAUPD for 
    definition of OP as well as other terms and the relation of computed
    Ritz values and Ritz vectors of OP with respect to the given problem
    A*z = lambda*B*z.  For a brief description, see definitions of 
    IPARAM(7), MODE and WHICH in the documentation of SNAUPD.
  \Usage:
    call sneupd 
       ( RVEC, HOWMNY, SELECT, DR, DI, Z, LDZ, SIGMAR, SIGMAI, WORKEV, BMAT, 
         N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR, WORKD, WORKL, 
         LWORKL, INFO )
  \Arguments:
    RVEC    LOGICAL  (INPUT) 
            Specifies whether a basis for the invariant subspace corresponding 
            to the converged Ritz value approximations for the eigenproblem 
            A*z = lambda*B*z is computed.
               RVEC = .FALSE.     Compute Ritz values only.
               RVEC = .TRUE.      Compute the Ritz vectors or Schur vectors.
                                  See Remarks below. 
   
    HOWMNY  Character*1  (INPUT) 
            Specifies the form of the basis for the invariant subspace 
            corresponding to the converged Ritz values that is to be computed.
            = 'A': Compute NEV Ritz vectors; 
            = 'P': Compute NEV Schur vectors;
            = 'S': compute some of the Ritz vectors, specified
                   by the logical array SELECT.
    SELECT  Logical array of dimension NCV.  (INPUT)
            If HOWMNY = 'S', SELECT specifies the Ritz vectors to be
            computed. To select the Ritz vector corresponding to a
            Ritz value (DR(j), DI(j)), SELECT(j) must be set to .TRUE.. 
            If HOWMNY = 'A' or 'P', SELECT is used as internal workspace.
    DR      Real  array of dimension NEV+1.  (OUTPUT)
            If IPARAM(7) = 1,2 or 3 and SIGMAI=0.0  then on exit: DR contains 
            the real part of the Ritz  approximations to the eigenvalues of 
            A*z = lambda*B*z. 
            If IPARAM(7) = 3, 4 and SIGMAI is not equal to zero, then on exit:
            DR contains the real part of the Ritz values of OP computed by 
            SNAUPD. A further computation must be performed by the user
            to transform the Ritz values computed for OP by SNAUPD to those
            of the original system A*z = lambda*B*z. See remark 3 below.
    DI      Real  array of dimension NEV+1.  (OUTPUT)
            On exit, DI contains the imaginary part of the Ritz value 
            approximations to the eigenvalues of A*z = lambda*B*z associated
            with DR.
            NOTE: When Ritz values are complex, they will come in complex 
                  conjugate pairs.  If eigenvectors are requested, the 
                  corresponding Ritz vectors will also come in conjugate 
                  pairs and the real and imaginary parts of these are 
                  represented in two consecutive columns of the array Z 
                  (see below).
    Z       Real  N by NEV+1 array if RVEC = .TRUE. and HOWMNY = 'A'. (OUTPUT)
            On exit, if RVEC = .TRUE. and HOWMNY = 'A', then the columns of 
            Z represent approximate eigenvectors (Ritz vectors) corresponding 
            to the NCONV=IPARAM(5) Ritz values for eigensystem 
            A*z = lambda*B*z. 
   
            The complex Ritz vector associated with the Ritz value 
            with positive imaginary part is stored in two consecutive 
            columns.  The first column holds the real part of the Ritz 
            vector and the second column holds the imaginary part.  The 
            Ritz vector associated with the Ritz value with negative 
            imaginary part is simply the complex conjugate of the Ritz vector 
            associated with the positive imaginary part.
            If  RVEC = .FALSE. or HOWMNY = 'P', then Z is not referenced.
            NOTE: If if RVEC = .TRUE. and a Schur basis is not required,
            the array Z may be set equal to first NEV+1 columns of the Arnoldi
            basis array V computed by SNAUPD.  In this case the Arnoldi basis
            will be destroyed and overwritten with the eigenvector basis.
    LDZ     Integer.  (INPUT)
            The leading dimension of the array Z.  If Ritz vectors are
            desired, then  LDZ >= max( 1, N ).  In any case,  LDZ >= 1.
    SIGMAR  Real   (INPUT)
            If IPARAM(7) = 3 or 4, represents the real part of the shift. 
            Not referenced if IPARAM(7) = 1 or 2.
    SIGMAI  Real   (INPUT)
            If IPARAM(7) = 3 or 4, represents the imaginary part of the shift. 
            Not referenced if IPARAM(7) = 1 or 2. See remark 3 below.
    WORKEV  Real  work array of dimension 3*NCV.  (WORKSPACE)
    **** The remaining arguments MUST be the same as for the   ****
    **** call to SNAUPD that was just completed.               ****
    NOTE: The remaining arguments
             BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR,
             WORKD, WORKL, LWORKL, INFO
           must be passed directly to SNEUPD following the last call
           to SNAUPD.  These arguments MUST NOT BE MODIFIED between
           the the last call to SNAUPD and the call to SNEUPD.
    Three of these parameters (V, WORKL, INFO) are also output parameters:
    V       Real  N by NCV array.  (INPUT/OUTPUT)
            Upon INPUT: the NCV columns of V contain the Arnoldi basis
                        vectors for OP as constructed by SNAUPD .
            Upon OUTPUT: If RVEC = .TRUE. the first NCONV=IPARAM(5) columns
                         contain approximate Schur vectors that span the
                         desired invariant subspace.  See Remark 2 below.
            NOTE: If the array Z has been set equal to first NEV+1 columns
            of the array V and RVEC=.TRUE. and HOWMNY= 'A', then the
            Arnoldi basis held by V has been overwritten by the desired
            Ritz vectors.  If a separate array Z has been passed then
            the first NCONV=IPARAM(5) columns of V will contain approximate
            Schur vectors that span the desired invariant subspace.
    WORKL   Real  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            WORKL(1:ncv*ncv+3*ncv) contains information obtained in
            snaupd.  They are not changed by sneupd.
            WORKL(ncv*ncv+3*ncv+1:3*ncv*ncv+6*ncv) holds the
            real and imaginary part of the untransformed Ritz values,
            the upper quasi-triangular matrix for H, and the
            associated matrix representation of the invariant subspace for H.
            Note: IPNTR(9:13) contains the pointer into WORKL for addresses
            of the above information computed by sneupd.
            -------------------------------------------------------------
            IPNTR(9):  pointer to the real part of the NCV RITZ values of the
                       original system.
            IPNTR(10): pointer to the imaginary part of the NCV RITZ values of
                       the original system.
            IPNTR(11): pointer to the NCV corresponding error bounds.
            IPNTR(12): pointer to the NCV by NCV upper quasi-triangular
                       Schur matrix for H.
            IPNTR(13): pointer to the NCV by NCV matrix of eigenvectors
                       of the upper Hessenberg matrix H. Only referenced by
                       sneupd if RVEC = .TRUE. See Remark 2 below.
            -------------------------------------------------------------
    INFO    Integer.  (OUTPUT)
            Error flag on output.
            =  0: Normal exit.
            =  1: The Schur form computed by LAPACK routine slahqr
                  could not be reordered by LAPACK routine strsen.
                  Re-enter subroutine sneupd with IPARAM(5)=NCV and 
                  increase the size of the arrays DR and DI to have 
                  dimension at least dimension NCV and allocate at least NCV 
                  columns for Z. NOTE: Not necessary if Z and V share 
                  the same space. Please notify the authors if this error
                  occurs.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV-NEV >= 2 and less than or equal to N.
            = -5: WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work WORKL array is not sufficient.
            = -8: Error return from calculation of a real Schur form.
                  Informational error from LAPACK routine slahqr.
            = -9: Error return from calculation of eigenvectors.
                  Informational error from LAPACK routine strevc.
            = -10: IPARAM(7) must be 1,2,3,4.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatible.
            = -12: HOWMNY = 'S' not yet implemented
            = -13: HOWMNY must be one of 'A' or 'P' if RVEC = .true.
            = -14: SNAUPD did not find any eigenvalues to sufficient
                   accuracy.
            = -15: DNEUPD got a different count of the number of converged
                   Ritz values than DNAUPD got.  This indicates the user
                   probably made an error in passing data from DNAUPD to
                   DNEUPD or that the data was modified before entering
                   DNEUPD
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett & Y. Saad, "Complex Shift and Invert Strategies for
       Real Matrices", Linear Algebra and its Applications, vol 88/89,
       pp 575-595, (1987).
  \Routines called:
       ivout   ARPACK utility routine that prints integers.
       smout   ARPACK utility routine that prints matrices
       svout   ARPACK utility routine that prints vectors.
       sgeqr2  LAPACK routine that computes the QR factorization of 
               a matrix.
       slacpy  LAPACK matrix copy routine.
       slahqr  LAPACK routine to compute the real Schur form of an
               upper Hessenberg matrix.
       slamch  LAPACK routine that determines machine constants.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       slaset  LAPACK matrix initialization routine.
       sorm2r  LAPACK routine that applies an orthogonal matrix in 
               factored form.
       strevc  LAPACK routine to compute the eigenvectors of a matrix
               in upper quasi-triangular form.
       strsen  LAPACK routine that re-orders the Schur form.
       strmm   Level 3 BLAS matrix times an upper triangular matrix.
       sger    Level 2 BLAS rank one update to a matrix.
       scopy   Level 1 BLAS that copies one vector to another .
       sdot    Level 1 BLAS that computes the scalar product of two vectors.
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sscal   Level 1 BLAS that scales a vector.
  \Remarks
    1. Currently only HOWMNY = 'A' and 'P' are implemented.
       Let trans(X) denote the transpose of X.
    2. Schur vectors are an orthogonal representation for the basis of
       Ritz vectors. Thus, their numerical properties are often superior.
       If RVEC = .TRUE. then the relationship
               A * V(:,1:IPARAM(5)) = V(:,1:IPARAM(5)) * T, and
       trans(V(:,1:IPARAM(5))) * V(:,1:IPARAM(5)) = I are approximately 
       satisfied. Here T is the leading submatrix of order IPARAM(5) of the 
       real upper quasi-triangular matrix stored workl(ipntr(12)). That is,
       T is block upper triangular with 1-by-1 and 2-by-2 diagonal blocks; 
       each 2-by-2 diagonal block has its diagonal elements equal and its
       off-diagonal elements of opposite sign.  Corresponding to each 2-by-2
       diagonal block is a complex conjugate pair of Ritz values. The real
       Ritz values are stored on the diagonal of T.
    3. If IPARAM(7) = 3 or 4 and SIGMAI is not equal zero, then the user must
       form the IPARAM(5) Rayleigh quotients in order to transform the Ritz
       values computed by SNAUPD for OP to those of A*z = lambda*B*z. 
       Set RVEC = .true. and HOWMNY = 'A', and
       compute 
             trans(Z(:,I)) * A * Z(:,I) if DI(I) = 0.
       If DI(I) is not equal to zero and DI(I+1) = - D(I), 
       then the desired real and imaginary parts of the Ritz value are
             trans(Z(:,I)) * A * Z(:,I) +  trans(Z(:,I+1)) * A * Z(:,I+1),
             trans(Z(:,I)) * A * Z(:,I+1) -  trans(Z(:,I+1)) * A * Z(:,I), 
       respectively.
       Another possibility is to set RVEC = .true. and HOWMNY = 'P' and
       compute trans(V(:,1:IPARAM(5))) * A * V(:,1:IPARAM(5)) and then an upper
       quasi-triangular matrix of order IPARAM(5) is computed. See remark
       2 above.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Chao Yang                    Houston, Texas
       Dept. of Computational &
       Applied Mathematics          
       Rice University           
       Houston, Texas            
   
  \SCCS Information: @(#) 
   FILE: neupd.F   SID: 2.7   DATE OF SID: 09/20/00   RELEASE: 2 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rvec
   * @param howmny
   * @param select
   * @param _select_offset
   * @param dr
   * @param _dr_offset
   * @param di
   * @param _di_offset
   * @param z
   * @param _z_offset
   * @param ldz
   * @param sigmar
   * @param sigmai
   * @param workev
   * @param _workev_offset
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param ncv
   * @param v
   * @param _v_offset
   * @param ldv
   * @param iparam
   * @param _iparam_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param workl
   * @param _workl_offset
   * @param lworkl
   * @param info
   * 
   */
  abstract public void sneupd(boolean rvec, java.lang.String howmny, boolean[] select, int _select_offset, float[] dr, int _dr_offset, float[] di, int _di_offset, float[] z, int _z_offset, int ldz, float sigmar, float sigmai, float[] workev, int _workev_offset, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, float tol, float[] resid, int _resid_offset, int ncv, float[] v, int _v_offset, int ldv, int[] iparam, int _iparam_offset, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, float[] workl, int _workl_offset, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sngets
  \Description: 
    Given the eigenvalues of the upper Hessenberg matrix H,
    computes the NP shifts AMU that are zeros of the polynomial of 
    degree NP which filters out components of the unwanted eigenvectors
    corresponding to the AMU's based on some given criteria.
    NOTE: call this even in the case of user specified shifts in order
    to sort the eigenvalues, and error bounds of H for later use.
  \Usage:
    call sngets
       ( ISHIFT, WHICH, KEV, NP, RITZR, RITZI, BOUNDS, SHIFTR, SHIFTI )
  \Arguments
    ISHIFT  Integer.  (INPUT)
            Method for selecting the implicit shifts at each iteration.
            ISHIFT = 0: user specified shifts
            ISHIFT = 1: exact shift with respect to the matrix H.
    WHICH   Character*2.  (INPUT)
            Shift selection criteria.
            'LM' -> want the KEV eigenvalues of largest magnitude.
            'SM' -> want the KEV eigenvalues of smallest magnitude.
            'LR' -> want the KEV eigenvalues of largest real part.
            'SR' -> want the KEV eigenvalues of smallest real part.
            'LI' -> want the KEV eigenvalues of largest imaginary part.
            'SI' -> want the KEV eigenvalues of smallest imaginary part.
    KEV      Integer.  (INPUT/OUTPUT)
             INPUT: KEV+NP is the size of the matrix H.
             OUTPUT: Possibly increases KEV by one to keep complex conjugate
             pairs together.
    NP       Integer.  (INPUT/OUTPUT)
             Number of implicit shifts to be computed.
             OUTPUT: Possibly decreases NP by one to keep complex conjugate
             pairs together.
    RITZR,  Real array of length KEV+NP.  (INPUT/OUTPUT)
    RITZI   On INPUT, RITZR and RITZI contain the real and imaginary 
            parts of the eigenvalues of H.
            On OUTPUT, RITZR and RITZI are sorted so that the unwanted
            eigenvalues are in the first NP locations and the wanted
            portion is in the last KEV locations.  When exact shifts are 
            selected, the unwanted part corresponds to the shifts to 
            be applied. Also, if ISHIFT .eq. 1, the unwanted eigenvalues
            are further sorted so that the ones with largest Ritz values
            are first.
    BOUNDS  Real array of length KEV+NP.  (INPUT/OUTPUT)
            Error bounds corresponding to the ordering in RITZ.
    SHIFTR, SHIFTI  *** USE deprecated as of version 2.1. ***
    
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       ssortc  ARPACK sorting routine.
       scopy   Level 1 BLAS that copies one vector to another .
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: ngets.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       1. xxxx
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ishift
   * @param which
   * @param kev
   * @param np
   * @param ritzr
   * @param ritzi
   * @param bounds
   * @param shiftr
   * @param shifti
   * 
   */
  abstract public void sngets(int ishift, java.lang.String which, org.netlib.util.intW kev, org.netlib.util.intW np, float[] ritzr, float[] ritzi, float[] bounds, float[] shiftr, float[] shifti);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sngets
  \Description: 
    Given the eigenvalues of the upper Hessenberg matrix H,
    computes the NP shifts AMU that are zeros of the polynomial of 
    degree NP which filters out components of the unwanted eigenvectors
    corresponding to the AMU's based on some given criteria.
    NOTE: call this even in the case of user specified shifts in order
    to sort the eigenvalues, and error bounds of H for later use.
  \Usage:
    call sngets
       ( ISHIFT, WHICH, KEV, NP, RITZR, RITZI, BOUNDS, SHIFTR, SHIFTI )
  \Arguments
    ISHIFT  Integer.  (INPUT)
            Method for selecting the implicit shifts at each iteration.
            ISHIFT = 0: user specified shifts
            ISHIFT = 1: exact shift with respect to the matrix H.
    WHICH   Character*2.  (INPUT)
            Shift selection criteria.
            'LM' -> want the KEV eigenvalues of largest magnitude.
            'SM' -> want the KEV eigenvalues of smallest magnitude.
            'LR' -> want the KEV eigenvalues of largest real part.
            'SR' -> want the KEV eigenvalues of smallest real part.
            'LI' -> want the KEV eigenvalues of largest imaginary part.
            'SI' -> want the KEV eigenvalues of smallest imaginary part.
    KEV      Integer.  (INPUT/OUTPUT)
             INPUT: KEV+NP is the size of the matrix H.
             OUTPUT: Possibly increases KEV by one to keep complex conjugate
             pairs together.
    NP       Integer.  (INPUT/OUTPUT)
             Number of implicit shifts to be computed.
             OUTPUT: Possibly decreases NP by one to keep complex conjugate
             pairs together.
    RITZR,  Real array of length KEV+NP.  (INPUT/OUTPUT)
    RITZI   On INPUT, RITZR and RITZI contain the real and imaginary 
            parts of the eigenvalues of H.
            On OUTPUT, RITZR and RITZI are sorted so that the unwanted
            eigenvalues are in the first NP locations and the wanted
            portion is in the last KEV locations.  When exact shifts are 
            selected, the unwanted part corresponds to the shifts to 
            be applied. Also, if ISHIFT .eq. 1, the unwanted eigenvalues
            are further sorted so that the ones with largest Ritz values
            are first.
    BOUNDS  Real array of length KEV+NP.  (INPUT/OUTPUT)
            Error bounds corresponding to the ordering in RITZ.
    SHIFTR, SHIFTI  *** USE deprecated as of version 2.1. ***
    
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       ssortc  ARPACK sorting routine.
       scopy   Level 1 BLAS that copies one vector to another .
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas    
  \Revision history:
       xx/xx/92: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: ngets.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \Remarks
       1. xxxx
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ishift
   * @param which
   * @param kev
   * @param np
   * @param ritzr
   * @param _ritzr_offset
   * @param ritzi
   * @param _ritzi_offset
   * @param bounds
   * @param _bounds_offset
   * @param shiftr
   * @param _shiftr_offset
   * @param shifti
   * @param _shifti_offset
   * 
   */
  abstract public void sngets(int ishift, java.lang.String which, org.netlib.util.intW kev, org.netlib.util.intW np, float[] ritzr, int _ritzr_offset, float[] ritzi, int _ritzi_offset, float[] bounds, int _bounds_offset, float[] shiftr, int _shiftr_offset, float[] shifti, int _shifti_offset);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssaitr
  \Description: 
    Reverse communication interface for applying NP additional steps to 
    a K step symmetric Arnoldi factorization.
    Input:  OP*V_{k}  -  V_{k}*H = r_{k}*e_{k}^T
            with (V_{k}^T)*B*V_{k} = I, (V_{k}^T)*B*r_{k} = 0.
    Output: OP*V_{k+p}  -  V_{k+p}*H = r_{k+p}*e_{k+p}^T
            with (V_{k+p}^T)*B*V_{k+p} = I, (V_{k+p}^T)*B*r_{k+p} = 0.
    where OP and B are as in ssaupd.  The B-norm of r_{k+p} is also
    computed and returned.
  \Usage:
    call ssaitr
       ( IDO, BMAT, N, K, NP, MODE, RESID, RNORM, V, LDV, H, LDH, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
                      This is for the restart phase to force the new
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y,
                      IPNTR(3) is the pointer into WORK for B * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
            IDO = 99: done
            -------------------------------------------------------------
            When the routine is used in the "shift-and-invert" mode, the
            vector B * Q is already available and does not need to be
            recomputed in forming OP * Q.
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of matrix B that defines the
            semi-inner product for the operator OP.  See ssaupd.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*M*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    K       Integer.  (INPUT)
            Current order of H and the number of columns of V.
    NP      Integer.  (INPUT)
            Number of additional Arnoldi steps to take.
    MODE    Integer.  (INPUT)
            Signifies which form for "OP". If MODE=2 then
            a reduction in the number of B matrix vector multiplies
            is possible since the B-norm of OP*x is equivalent to
            the inv(B)-norm of A*x.
    RESID   Real array of length N.  (INPUT/OUTPUT)
            On INPUT:  RESID contains the residual vector r_{k}.
            On OUTPUT: RESID contains the residual vector r_{k+p}.
    RNORM   Real scalar.  (INPUT/OUTPUT)
            On INPUT the B-norm of r_{k}.
            On OUTPUT the B-norm of the updated residual r_{k+p}.
    V       Real N by K+NP array.  (INPUT/OUTPUT)
            On INPUT:  V contains the Arnoldi vectors in the first K 
            columns.
            On OUTPUT: V contains the new NP Arnoldi vectors in the next
            NP columns.  The first K columns are unchanged.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Real (K+NP) by 2 array.  (INPUT/OUTPUT)
            H is used to store the generated symmetric tridiagonal matrix
            with the subdiagonal in the first column starting at H(2,1)
            and the main diagonal in the second column.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORK for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The calling program should not 
            use WORKD as temporary workspace during the iteration !!!!!!
            On INPUT, WORKD(1:N) = B*RESID where RESID is associated
            with the K step Arnoldi factorization. Used to save some 
            computation at the first step. 
            On OUTPUT, WORKD(1:N) = B*RESID where RESID is associated
            with the K+NP step Arnoldi factorization.
    INFO    Integer.  (OUTPUT)
            = 0: Normal exit.
            > 0: Size of an invariant subspace of OP is found that is
                 less than K + NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       sgetv0  ARPACK routine to generate the initial vector.
       ivout   ARPACK utility routine that prints integers.
       smout   ARPACK utility routine that prints matrices.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
       slascl  LAPACK routine for careful scaling of a matrix.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       saxpy   Level 1 BLAS that computes a vector triad.
       sscal   Level 1 BLAS that scales a vector.
       scopy   Level 1 BLAS that copies one vector to another .
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       xx/xx/93: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: saitr.F   SID: 2.6   DATE OF SID: 8/28/96   RELEASE: 2
  \Remarks
    The algorithm implemented is:
    
    restart = .false.
    Given V_{k} = [v_{1}, ..., v_{k}], r_{k}; 
    r_{k} contains the initial residual vector even for k = 0;
    Also assume that rnorm = || B*r_{k} || and B*r_{k} are already 
    computed by the calling program.
    betaj = rnorm ; p_{k+1} = B*r_{k} ;
    For  j = k+1, ..., k+np  Do
       1) if ( betaj < tol ) stop or restart depending on j.
          if ( restart ) generate a new starting vector.
       2) v_{j} = r(j-1)/betaj;  V_{j} = [V_{j-1}, v_{j}];  
          p_{j} = p_{j}/betaj
       3) r_{j} = OP*v_{j} where OP is defined as in ssaupd
          For shift-invert mode p_{j} = B*v_{j} is already available.
          wnorm = || OP*v_{j} ||
       4) Compute the j-th step residual vector.
          w_{j} =  V_{j}^T * B * OP * v_{j}
          r_{j} =  OP*v_{j} - V_{j} * w_{j}
          alphaj <- j-th component of w_{j}
          rnorm = || r_{j} ||
          betaj+1 = rnorm
          If (rnorm > 0.717*wnorm) accept step and go back to 1)
       5) Re-orthogonalization step:
          s = V_{j}'*B*r_{j}
          r_{j} = r_{j} - V_{j}*s;  rnorm1 = || r_{j} ||
          alphaj = alphaj + s_{j};   
       6) Iterative refinement step:
          If (rnorm1 > 0.717*rnorm) then
             rnorm = rnorm1
             accept step and go back to 1)
          Else
             rnorm = rnorm1
             If this is the first time in step 6), go to 5)
             Else r_{j} lies in the span of V_{j} numerically.
                Set r_{j} = 0 and rnorm = 0; go to 1)
          EndIf 
    End Do
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param k
   * @param np
   * @param mode
   * @param resid
   * @param rnorm
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param ipntr
   * @param workd
   * @param info
   * 
   */
  abstract public void ssaitr(org.netlib.util.intW ido, java.lang.String bmat, int n, int k, int np, int mode, float[] resid, org.netlib.util.floatW rnorm, float[] v, int ldv, float[] h, int ldh, int[] ipntr, float[] workd, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssaitr
  \Description: 
    Reverse communication interface for applying NP additional steps to 
    a K step symmetric Arnoldi factorization.
    Input:  OP*V_{k}  -  V_{k}*H = r_{k}*e_{k}^T
            with (V_{k}^T)*B*V_{k} = I, (V_{k}^T)*B*r_{k} = 0.
    Output: OP*V_{k+p}  -  V_{k+p}*H = r_{k+p}*e_{k+p}^T
            with (V_{k+p}^T)*B*V_{k+p} = I, (V_{k+p}^T)*B*r_{k+p} = 0.
    where OP and B are as in ssaupd.  The B-norm of r_{k+p} is also
    computed and returned.
  \Usage:
    call ssaitr
       ( IDO, BMAT, N, K, NP, MODE, RESID, RNORM, V, LDV, H, LDH, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
                      This is for the restart phase to force the new
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y,
                      IPNTR(3) is the pointer into WORK for B * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORK for X,
                      IPNTR(2) is the pointer into WORK for Y.
            IDO = 99: done
            -------------------------------------------------------------
            When the routine is used in the "shift-and-invert" mode, the
            vector B * Q is already available and does not need to be
            recomputed in forming OP * Q.
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of matrix B that defines the
            semi-inner product for the operator OP.  See ssaupd.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*M*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    K       Integer.  (INPUT)
            Current order of H and the number of columns of V.
    NP      Integer.  (INPUT)
            Number of additional Arnoldi steps to take.
    MODE    Integer.  (INPUT)
            Signifies which form for "OP". If MODE=2 then
            a reduction in the number of B matrix vector multiplies
            is possible since the B-norm of OP*x is equivalent to
            the inv(B)-norm of A*x.
    RESID   Real array of length N.  (INPUT/OUTPUT)
            On INPUT:  RESID contains the residual vector r_{k}.
            On OUTPUT: RESID contains the residual vector r_{k+p}.
    RNORM   Real scalar.  (INPUT/OUTPUT)
            On INPUT the B-norm of r_{k}.
            On OUTPUT the B-norm of the updated residual r_{k+p}.
    V       Real N by K+NP array.  (INPUT/OUTPUT)
            On INPUT:  V contains the Arnoldi vectors in the first K 
            columns.
            On OUTPUT: V contains the new NP Arnoldi vectors in the next
            NP columns.  The first K columns are unchanged.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Real (K+NP) by 2 array.  (INPUT/OUTPUT)
            H is used to store the generated symmetric tridiagonal matrix
            with the subdiagonal in the first column starting at H(2,1)
            and the main diagonal in the second column.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORK for 
            vectors used by the Arnoldi iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in the 
                      shift-and-invert mode.  X is the current operand.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The calling program should not 
            use WORKD as temporary workspace during the iteration !!!!!!
            On INPUT, WORKD(1:N) = B*RESID where RESID is associated
            with the K step Arnoldi factorization. Used to save some 
            computation at the first step. 
            On OUTPUT, WORKD(1:N) = B*RESID where RESID is associated
            with the K+NP step Arnoldi factorization.
    INFO    Integer.  (OUTPUT)
            = 0: Normal exit.
            > 0: Size of an invariant subspace of OP is found that is
                 less than K + NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       sgetv0  ARPACK routine to generate the initial vector.
       ivout   ARPACK utility routine that prints integers.
       smout   ARPACK utility routine that prints matrices.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
       slascl  LAPACK routine for careful scaling of a matrix.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       saxpy   Level 1 BLAS that computes a vector triad.
       sscal   Level 1 BLAS that scales a vector.
       scopy   Level 1 BLAS that copies one vector to another .
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       xx/xx/93: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: saitr.F   SID: 2.6   DATE OF SID: 8/28/96   RELEASE: 2
  \Remarks
    The algorithm implemented is:
    
    restart = .false.
    Given V_{k} = [v_{1}, ..., v_{k}], r_{k}; 
    r_{k} contains the initial residual vector even for k = 0;
    Also assume that rnorm = || B*r_{k} || and B*r_{k} are already 
    computed by the calling program.
    betaj = rnorm ; p_{k+1} = B*r_{k} ;
    For  j = k+1, ..., k+np  Do
       1) if ( betaj < tol ) stop or restart depending on j.
          if ( restart ) generate a new starting vector.
       2) v_{j} = r(j-1)/betaj;  V_{j} = [V_{j-1}, v_{j}];  
          p_{j} = p_{j}/betaj
       3) r_{j} = OP*v_{j} where OP is defined as in ssaupd
          For shift-invert mode p_{j} = B*v_{j} is already available.
          wnorm = || OP*v_{j} ||
       4) Compute the j-th step residual vector.
          w_{j} =  V_{j}^T * B * OP * v_{j}
          r_{j} =  OP*v_{j} - V_{j} * w_{j}
          alphaj <- j-th component of w_{j}
          rnorm = || r_{j} ||
          betaj+1 = rnorm
          If (rnorm > 0.717*wnorm) accept step and go back to 1)
       5) Re-orthogonalization step:
          s = V_{j}'*B*r_{j}
          r_{j} = r_{j} - V_{j}*s;  rnorm1 = || r_{j} ||
          alphaj = alphaj + s_{j};   
       6) Iterative refinement step:
          If (rnorm1 > 0.717*rnorm) then
             rnorm = rnorm1
             accept step and go back to 1)
          Else
             rnorm = rnorm1
             If this is the first time in step 6), go to 5)
             Else r_{j} lies in the span of V_{j} numerically.
                Set r_{j} = 0 and rnorm = 0; go to 1)
          EndIf 
    End Do
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param k
   * @param np
   * @param mode
   * @param resid
   * @param _resid_offset
   * @param rnorm
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param info
   * 
   */
  abstract public void ssaitr(org.netlib.util.intW ido, java.lang.String bmat, int n, int k, int np, int mode, float[] resid, int _resid_offset, org.netlib.util.floatW rnorm, float[] v, int _v_offset, int ldv, float[] h, int _h_offset, int ldh, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssapps
  \Description:
    Given the Arnoldi factorization
       A*V_{k} - V_{k}*H_{k} = r_{k+p}*e_{k+p}^T,
    apply NP shifts implicitly resulting in
       A*(V_{k}*Q) - (V_{k}*Q)*(Q^T* H_{k}*Q) = r_{k+p}*e_{k+p}^T * Q
    where Q is an orthogonal matrix of order KEV+NP. Q is the product of 
    rotations resulting from the NP bulge chasing sweeps.  The updated Arnoldi 
    factorization becomes:
       A*VNEW_{k} - VNEW_{k}*HNEW_{k} = rnew_{k}*e_{k}^T.
  \Usage:
    call ssapps
       ( N, KEV, NP, SHIFT, V, LDV, H, LDH, RESID, Q, LDQ, WORKD )
  \Arguments
    N       Integer.  (INPUT)
            Problem size, i.e. dimension of matrix A.
    KEV     Integer.  (INPUT)
            INPUT: KEV+NP is the size of the input matrix H.
            OUTPUT: KEV is the size of the updated matrix HNEW.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be applied.
    SHIFT   Real array of length NP.  (INPUT)
            The shifts to be applied.
    V       Real N by (KEV+NP) array.  (INPUT/OUTPUT)
            INPUT: V contains the current KEV+NP Arnoldi vectors.
            OUTPUT: VNEW = V(1:n,1:KEV); the updated Arnoldi vectors
            are in the first KEV columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    H       Real (KEV+NP) by 2 array.  (INPUT/OUTPUT)
            INPUT: H contains the symmetric tridiagonal matrix of the
            Arnoldi factorization with the subdiagonal in the 1st column
            starting at H(2,1) and the main diagonal in the 2nd column.
            OUTPUT: H contains the updated tridiagonal matrix in the 
            KEV leading submatrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RESID   Real array of length (N).  (INPUT/OUTPUT)
            INPUT: RESID contains the the residual vector r_{k+p}.
            OUTPUT: RESID is the updated residual vector rnew_{k}.
    Q       Real KEV+NP by KEV+NP work array.  (WORKSPACE)
            Work array used to accumulate the rotations during the bulge
            chase sweep.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKD   Real work array of length 2*N.  (WORKSPACE)
            Distributed array used in the application of the accumulated
            orthogonal matrix Q.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       ivout   ARPACK utility routine that prints integers. 
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
       slartg  LAPACK Givens rotation construction routine.
       slacpy  LAPACK matrix copy routine.
       slaset  LAPACK matrix initialization routine.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       saxpy   Level 1 BLAS that computes a vector triad.
       scopy   Level 1 BLAS that copies one vector to another.
       sscal   Level 1 BLAS that scales a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/16/93: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: sapps.F   SID: 2.6   DATE OF SID: 3/28/97   RELEASE: 2
  \Remarks
    1. In this version, each shift is applied to all the subblocks of
       the tridiagonal matrix H and not just to the submatrix that it 
       comes from. This routine assumes that the subdiagonal elements 
       of H that are stored in h(1:kev+np,1) are nonegative upon input
       and enforce this condition upon output. This version incorporates
       deflation. See code for documentation.
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param kev
   * @param np
   * @param shift
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param resid
   * @param q
   * @param ldq
   * @param workd
   * 
   */
  abstract public void ssapps(int n, int kev, int np, float[] shift, float[] v, int ldv, float[] h, int ldh, float[] resid, float[] q, int ldq, float[] workd);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssapps
  \Description:
    Given the Arnoldi factorization
       A*V_{k} - V_{k}*H_{k} = r_{k+p}*e_{k+p}^T,
    apply NP shifts implicitly resulting in
       A*(V_{k}*Q) - (V_{k}*Q)*(Q^T* H_{k}*Q) = r_{k+p}*e_{k+p}^T * Q
    where Q is an orthogonal matrix of order KEV+NP. Q is the product of 
    rotations resulting from the NP bulge chasing sweeps.  The updated Arnoldi 
    factorization becomes:
       A*VNEW_{k} - VNEW_{k}*HNEW_{k} = rnew_{k}*e_{k}^T.
  \Usage:
    call ssapps
       ( N, KEV, NP, SHIFT, V, LDV, H, LDH, RESID, Q, LDQ, WORKD )
  \Arguments
    N       Integer.  (INPUT)
            Problem size, i.e. dimension of matrix A.
    KEV     Integer.  (INPUT)
            INPUT: KEV+NP is the size of the input matrix H.
            OUTPUT: KEV is the size of the updated matrix HNEW.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be applied.
    SHIFT   Real array of length NP.  (INPUT)
            The shifts to be applied.
    V       Real N by (KEV+NP) array.  (INPUT/OUTPUT)
            INPUT: V contains the current KEV+NP Arnoldi vectors.
            OUTPUT: VNEW = V(1:n,1:KEV); the updated Arnoldi vectors
            are in the first KEV columns of V.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    H       Real (KEV+NP) by 2 array.  (INPUT/OUTPUT)
            INPUT: H contains the symmetric tridiagonal matrix of the
            Arnoldi factorization with the subdiagonal in the 1st column
            starting at H(2,1) and the main diagonal in the 2nd column.
            OUTPUT: H contains the updated tridiagonal matrix in the 
            KEV leading submatrix.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling
            program.
    RESID   Real array of length (N).  (INPUT/OUTPUT)
            INPUT: RESID contains the the residual vector r_{k+p}.
            OUTPUT: RESID is the updated residual vector rnew_{k}.
    Q       Real KEV+NP by KEV+NP work array.  (WORKSPACE)
            Work array used to accumulate the rotations during the bulge
            chase sweep.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
    WORKD   Real work array of length 2*N.  (WORKSPACE)
            Distributed array used in the application of the accumulated
            orthogonal matrix Q.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
  \Routines called:
       ivout   ARPACK utility routine that prints integers. 
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
       slartg  LAPACK Givens rotation construction routine.
       slacpy  LAPACK matrix copy routine.
       slaset  LAPACK matrix initialization routine.
       sgemv   Level 2 BLAS routine for matrix vector multiplication.
       saxpy   Level 1 BLAS that computes a vector triad.
       scopy   Level 1 BLAS that copies one vector to another.
       sscal   Level 1 BLAS that scales a vector.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/16/93: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: sapps.F   SID: 2.6   DATE OF SID: 3/28/97   RELEASE: 2
  \Remarks
    1. In this version, each shift is applied to all the subblocks of
       the tridiagonal matrix H and not just to the submatrix that it 
       comes from. This routine assumes that the subdiagonal elements 
       of H that are stored in h(1:kev+np,1) are nonegative upon input
       and enforce this condition upon output. This version incorporates
       deflation. See code for documentation.
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param kev
   * @param np
   * @param shift
   * @param _shift_offset
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param resid
   * @param _resid_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workd
   * @param _workd_offset
   * 
   */
  abstract public void ssapps(int n, int kev, int np, float[] shift, int _shift_offset, float[] v, int _v_offset, int ldv, float[] h, int _h_offset, int ldh, float[] resid, int _resid_offset, float[] q, int _q_offset, int ldq, float[] workd, int _workd_offset);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssaup2
  \Description: 
    Intermediate level interface called by ssaupd.
  \Usage:
    call ssaup2 
       ( IDO, BMAT, N, WHICH, NEV, NP, TOL, RESID, MODE, IUPD,
         ISHIFT, MXITER, V, LDV, H, LDH, RITZ, BOUNDS, Q, LDQ, WORKL, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO, BMAT, N, WHICH, NEV, TOL, RESID: same as defined in ssaupd.
    MODE, ISHIFT, MXITER: see the definition of IPARAM in ssaupd.
    
    NP      Integer.  (INPUT/OUTPUT)
            Contains the number of implicit shifts to apply during 
            each Arnoldi/Lanczos iteration.  
            If ISHIFT=1, NP is adjusted dynamically at each iteration 
            to accelerate convergence and prevent stagnation.
            This is also roughly equal to the number of matrix-vector 
            products (involving the operator OP) per Arnoldi iteration.
            The logic for adjusting is contained within the current
            subroutine.
            If ISHIFT=0, NP is the number of shifts the user needs
            to provide via reverse comunication. 0 < NP < NCV-NEV.
            NP may be less than NCV-NEV since a leading block of the current
            upper Tridiagonal matrix has split off and contains "unwanted"
            Ritz values.
            Upon termination of the IRA iteration, NP contains the number 
            of "converged" wanted Ritz values.
    IUPD    Integer.  (INPUT)
            IUPD .EQ. 0: use explicit restart instead implicit update.
            IUPD .NE. 0: use implicit update.
    V       Real N by (NEV+NP) array.  (INPUT/OUTPUT)
            The Lanczos basis vectors.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Real (NEV+NP) by 2 array.  (OUTPUT)
            H is used to store the generated symmetric tridiagonal matrix
            The subdiagonal is stored in the first column of H starting 
            at H(2,1).  The main diagonal is stored in the second column
            of H starting at H(1,2). If ssaup2 converges store the 
            B-norm of the final residual vector in H(1,1).
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    RITZ    Real array of length NEV+NP.  (OUTPUT)
            RITZ(1:NEV) contains the computed Ritz values of OP.
    BOUNDS  Real array of length NEV+NP.  (OUTPUT)
            BOUNDS(1:NEV) contain the error bounds corresponding to RITZ.
    Q       Real (NEV+NP) by (NEV+NP) array.  (WORKSPACE)
            Private (replicated) work array used to accumulate the 
            rotation in the shift application step.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
            
    WORKL   Real array of length at least 3*(NEV+NP).  (INPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  It is used in the computation of the 
            tridiagonal eigenvalue problem, the calculation and
            application of the shifts and convergence checking.
            If ISHIFT .EQ. O and IDO .EQ. 3, the first NP locations
            of WORKL are used in reverse communication to hold the user 
            supplied shifts.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD for 
            vectors used by the Lanczos iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in one of  
                      the spectral transformation modes.  X is the current
                      operand.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Lanczos iteration
            for reverse communication.  The user should not use WORKD
            as temporary workspace during the iteration !!!!!!!!!!
            See Data Distribution Note in ssaupd.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =     0: Normal return.
            =     1: All possible eigenvalues of OP has been found.  
                     NP returns the size of the invariant subspace
                     spanning the operator OP. 
            =     2: No shifts could be applied.
            =    -8: Error return from trid. eigenvalue calculation;
                     This should never happen.
            =    -9: Starting vector is zero.
            = -9999: Could not build an Lanczos factorization.
                     Size that was built in returned in NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
  \Routines called:
       sgetv0  ARPACK initial vector generation routine. 
       ssaitr  ARPACK Lanczos factorization routine.
       ssapps  ARPACK application of implicit shifts routine.
       ssconv  ARPACK convergence of Ritz values routine.
       sseigt  ARPACK compute Ritz values and error bounds routine.
       ssgets  ARPACK reorder Ritz values and error bounds routine.
       ssortr  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
       scopy   Level 1 BLAS that copies one vector to another.
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sscal   Level 1 BLAS that scales a vector.
       sswap   Level 1 BLAS that swaps two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.4'
       xx/xx/95: Version ' 2.4'.  (R.B. Lehoucq)
  \SCCS Information: @(#) 
   FILE: saup2.F   SID: 2.7   DATE OF SID: 5/19/98   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param np
   * @param tol
   * @param resid
   * @param mode
   * @param iupd
   * @param ishift
   * @param mxiter
   * @param v
   * @param ldv
   * @param h
   * @param ldh
   * @param ritz
   * @param bounds
   * @param q
   * @param ldq
   * @param workl
   * @param ipntr
   * @param workd
   * @param info
   * 
   */
  abstract public void ssaup2(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, org.netlib.util.intW np, float tol, float[] resid, int mode, int iupd, int ishift, org.netlib.util.intW mxiter, float[] v, int ldv, float[] h, int ldh, float[] ritz, float[] bounds, float[] q, int ldq, float[] workl, int[] ipntr, float[] workd, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssaup2
  \Description: 
    Intermediate level interface called by ssaupd.
  \Usage:
    call ssaup2 
       ( IDO, BMAT, N, WHICH, NEV, NP, TOL, RESID, MODE, IUPD,
         ISHIFT, MXITER, V, LDV, H, LDH, RITZ, BOUNDS, Q, LDQ, WORKL, 
         IPNTR, WORKD, INFO )
  \Arguments
    IDO, BMAT, N, WHICH, NEV, TOL, RESID: same as defined in ssaupd.
    MODE, ISHIFT, MXITER: see the definition of IPARAM in ssaupd.
    
    NP      Integer.  (INPUT/OUTPUT)
            Contains the number of implicit shifts to apply during 
            each Arnoldi/Lanczos iteration.  
            If ISHIFT=1, NP is adjusted dynamically at each iteration 
            to accelerate convergence and prevent stagnation.
            This is also roughly equal to the number of matrix-vector 
            products (involving the operator OP) per Arnoldi iteration.
            The logic for adjusting is contained within the current
            subroutine.
            If ISHIFT=0, NP is the number of shifts the user needs
            to provide via reverse comunication. 0 < NP < NCV-NEV.
            NP may be less than NCV-NEV since a leading block of the current
            upper Tridiagonal matrix has split off and contains "unwanted"
            Ritz values.
            Upon termination of the IRA iteration, NP contains the number 
            of "converged" wanted Ritz values.
    IUPD    Integer.  (INPUT)
            IUPD .EQ. 0: use explicit restart instead implicit update.
            IUPD .NE. 0: use implicit update.
    V       Real N by (NEV+NP) array.  (INPUT/OUTPUT)
            The Lanczos basis vectors.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling 
            program.
    H       Real (NEV+NP) by 2 array.  (OUTPUT)
            H is used to store the generated symmetric tridiagonal matrix
            The subdiagonal is stored in the first column of H starting 
            at H(2,1).  The main diagonal is stored in the second column
            of H starting at H(1,2). If ssaup2 converges store the 
            B-norm of the final residual vector in H(1,1).
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    RITZ    Real array of length NEV+NP.  (OUTPUT)
            RITZ(1:NEV) contains the computed Ritz values of OP.
    BOUNDS  Real array of length NEV+NP.  (OUTPUT)
            BOUNDS(1:NEV) contain the error bounds corresponding to RITZ.
    Q       Real (NEV+NP) by (NEV+NP) array.  (WORKSPACE)
            Private (replicated) work array used to accumulate the 
            rotation in the shift application step.
    LDQ     Integer.  (INPUT)
            Leading dimension of Q exactly as declared in the calling
            program.
            
    WORKL   Real array of length at least 3*(NEV+NP).  (INPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  It is used in the computation of the 
            tridiagonal eigenvalue problem, the calculation and
            application of the shifts and convergence checking.
            If ISHIFT .EQ. O and IDO .EQ. 3, the first NP locations
            of WORKL are used in reverse communication to hold the user 
            supplied shifts.
    IPNTR   Integer array of length 3.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD for 
            vectors used by the Lanczos iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X.
            IPNTR(2): pointer to the current result vector Y.
            IPNTR(3): pointer to the vector B * X when used in one of  
                      the spectral transformation modes.  X is the current
                      operand.
            -------------------------------------------------------------
            
    WORKD   Real work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Lanczos iteration
            for reverse communication.  The user should not use WORKD
            as temporary workspace during the iteration !!!!!!!!!!
            See Data Distribution Note in ssaupd.
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =     0: Normal return.
            =     1: All possible eigenvalues of OP has been found.  
                     NP returns the size of the invariant subspace
                     spanning the operator OP. 
            =     2: No shifts could be applied.
            =    -8: Error return from trid. eigenvalue calculation;
                     This should never happen.
            =    -9: Starting vector is zero.
            = -9999: Could not build an Lanczos factorization.
                     Size that was built in returned in NP.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
  \Routines called:
       sgetv0  ARPACK initial vector generation routine. 
       ssaitr  ARPACK Lanczos factorization routine.
       ssapps  ARPACK application of implicit shifts routine.
       ssconv  ARPACK convergence of Ritz values routine.
       sseigt  ARPACK compute Ritz values and error bounds routine.
       ssgets  ARPACK reorder Ritz values and error bounds routine.
       ssortr  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
       scopy   Level 1 BLAS that copies one vector to another.
       sdot    Level 1 BLAS that computes the scalar product of two vectors. 
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sscal   Level 1 BLAS that scales a vector.
       sswap   Level 1 BLAS that swaps two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.4'
       xx/xx/95: Version ' 2.4'.  (R.B. Lehoucq)
  \SCCS Information: @(#) 
   FILE: saup2.F   SID: 2.7   DATE OF SID: 5/19/98   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param np
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param mode
   * @param iupd
   * @param ishift
   * @param mxiter
   * @param v
   * @param _v_offset
   * @param ldv
   * @param h
   * @param _h_offset
   * @param ldh
   * @param ritz
   * @param _ritz_offset
   * @param bounds
   * @param _bounds_offset
   * @param q
   * @param _q_offset
   * @param ldq
   * @param workl
   * @param _workl_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param info
   * 
   */
  abstract public void ssaup2(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, org.netlib.util.intW np, float tol, float[] resid, int _resid_offset, int mode, int iupd, int ishift, org.netlib.util.intW mxiter, float[] v, int _v_offset, int ldv, float[] h, int _h_offset, int ldh, float[] ritz, int _ritz_offset, float[] bounds, int _bounds_offset, float[] q, int _q_offset, int ldq, float[] workl, int _workl_offset, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssaupd
  \Description: 
    Reverse communication interface for the Implicitly Restarted Arnoldi 
    Iteration.  For symmetric problems this reduces to a variant of the Lanczos 
    method.  This method has been designed to compute approximations to a 
    few eigenpairs of a linear operator OP that is real and symmetric 
    with respect to a real positive semi-definite symmetric matrix B, 
    i.e.
                     
         B*OP = (OP`)*B.  
    Another way to express this condition is 
         < x,OPy > = < OPx,y >  where < z,w > = z`Bw  .
    
    In the standard eigenproblem B is the identity matrix.  
    ( A` denotes transpose of A)
    The computed approximate eigenvalues are called Ritz values and
    the corresponding approximate eigenvectors are called Ritz vectors.
    ssaupd is usually called iteratively to solve one of the 
    following problems:
    Mode 1:  A*x = lambda*x, A symmetric 
             ===> OP = A  and  B = I.
    Mode 2:  A*x = lambda*M*x, A symmetric, M symmetric positive definite
             ===> OP = inv[M]*A  and  B = M.
             ===> (If M can be factored see remark 3 below)
    Mode 3:  K*x = lambda*M*x, K symmetric, M symmetric positive semi-definite
             ===> OP = (inv[K - sigma*M])*M  and  B = M. 
             ===> Shift-and-Invert mode
    Mode 4:  K*x = lambda*KG*x, K symmetric positive semi-definite, 
             KG symmetric indefinite
             ===> OP = (inv[K - sigma*KG])*K  and  B = K.
             ===> Buckling mode
    Mode 5:  A*x = lambda*M*x, A symmetric, M symmetric positive semi-definite
             ===> OP = inv[A - sigma*M]*[A + sigma*M]  and  B = M.
             ===> Cayley transformed mode
    NOTE: The action of w <- inv[A - sigma*M]*v or w <- inv[M]*v
          should be accomplished either by a direct method
          using a sparse matrix factorization and solving
             [A - sigma*M]*w = v  or M*w = v,
          or through an iterative method for solving these
          systems.  If an iterative method is used, the
          convergence test must be more stringent than
          the accuracy requirements for the eigenvalue
          approximations.
  \Usage:
    call ssaupd 
       ( IDO, BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM,
         IPNTR, WORKD, WORKL, LWORKL, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first 
            call to ssaupd.  IDO will be set internally to
            indicate the type of operation to be performed.  Control is
            then given back to the calling routine which has the
            responsibility to carry out the requested operation and call
            ssaupd with the result.  The operand is given in
            WORKD(IPNTR(1)), the result must be put in WORKD(IPNTR(2)).
            (If Mode = 2 see remark 5 below)
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      In mode 3,4 and 5, the vector B * X is already
                      available in WORKD(ipntr(3)).  It does not
                      need to be recomputed in forming OP * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO =  3: compute the IPARAM(8) shifts where
                      IPNTR(11) is the pointer into WORKL for
                      placing the shifts. See remark 6 below.
            IDO = 99: done
            -------------------------------------------------------------
               
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    WHICH   Character*2.  (INPUT)
            Specify which of the Ritz values of OP to compute.
            'LA' - compute the NEV largest (algebraic) eigenvalues.
            'SA' - compute the NEV smallest (algebraic) eigenvalues.
            'LM' - compute the NEV largest (in magnitude) eigenvalues.
            'SM' - compute the NEV smallest (in magnitude) eigenvalues. 
            'BE' - compute NEV eigenvalues, half from each end of the
                   spectrum.  When NEV is odd, compute one more from the
                   high end than from the low end.
             (see remark 1 below)
    NEV     Integer.  (INPUT)
            Number of eigenvalues of OP to be computed. 0 < NEV < N.
    TOL     Real  scalar.  (INPUT)
            Stopping criterion: the relative accuracy of the Ritz value 
            is considered acceptable if BOUNDS(I) .LE. TOL*ABS(RITZ(I)).
            If TOL .LE. 0. is passed a default is set:
            DEFAULT = SLAMCH('EPS')  (machine precision as computed
                      by the LAPACK auxiliary subroutine SLAMCH).
    RESID   Real  array of length N.  (INPUT/OUTPUT)
            On INPUT: 
            If INFO .EQ. 0, a random initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            On OUTPUT:
            RESID contains the final residual vector. 
    NCV     Integer.  (INPUT)
            Number of columns of the matrix V (less than or equal to N).
            This will indicate how many Lanczos vectors are generated 
            at each iteration.  After the startup phase in which NEV 
            Lanczos vectors are generated, the algorithm generates 
            NCV-NEV Lanczos vectors at each subsequent update iteration.
            Most of the cost in generating each Lanczos vector is in the 
            matrix-vector product OP*x. (See remark 4 below).
    V       Real  N by NCV array.  (OUTPUT)
            The NCV columns of V contain the Lanczos basis vectors.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    IPARAM  Integer array of length 11.  (INPUT/OUTPUT)
            IPARAM(1) = ISHIFT: method for selecting the implicit shifts.
            The shifts selected at each iteration are used to restart
            the Arnoldi iteration in an implicit fashion.
            -------------------------------------------------------------
            ISHIFT = 0: the shifts are provided by the user via
                        reverse communication.  The NCV eigenvalues of
                        the current tridiagonal matrix T are returned in
                        the part of WORKL array corresponding to RITZ.
                        See remark 6 below.
            ISHIFT = 1: exact shifts with respect to the reduced 
                        tridiagonal matrix T.  This is equivalent to 
                        restarting the iteration with a starting vector 
                        that is a linear combination of Ritz vectors 
                        associated with the "wanted" Ritz values.
            -------------------------------------------------------------
            IPARAM(2) = LEVEC
            No longer referenced. See remark 2 below.
            IPARAM(3) = MXITER
            On INPUT:  maximum number of Arnoldi update iterations allowed. 
            On OUTPUT: actual number of Arnoldi update iterations taken. 
            IPARAM(4) = NB: blocksize to be used in the recurrence.
            The code currently works only for NB = 1.
            IPARAM(5) = NCONV: number of "converged" Ritz values.
            This represents the number of Ritz values that satisfy
            the convergence criterion.
            IPARAM(6) = IUPD
            No longer referenced. Implicit restarting is ALWAYS used. 
            IPARAM(7) = MODE
            On INPUT determines what type of eigenproblem is being solved.
            Must be 1,2,3,4,5; See under \Description of ssaupd for the 
            five modes available.
            IPARAM(8) = NP
            When ido = 3 and the user provides shifts through reverse
            communication (IPARAM(1)=0), ssaupd returns NP, the number
            of shifts the user is to provide. 0 < NP <=NCV-NEV. See Remark
            6 below.
            IPARAM(9) = NUMOP, IPARAM(10) = NUMOPB, IPARAM(11) = NUMREO,
            OUTPUT: NUMOP  = total number of OP*x operations,
                    NUMOPB = total number of B*x operations if BMAT='G',
                    NUMREO = total number of steps of re-orthogonalization.        
    IPNTR   Integer array of length 11.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD and WORKL
            arrays for matrices/vectors used by the Lanczos iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X in WORKD.
            IPNTR(2): pointer to the current result vector Y in WORKD.
            IPNTR(3): pointer to the vector B * X in WORKD when used in 
                      the shift-and-invert mode.
            IPNTR(4): pointer to the next available location in WORKL
                      that is untouched by the program.
            IPNTR(5): pointer to the NCV by 2 tridiagonal matrix T in WORKL.
            IPNTR(6): pointer to the NCV RITZ values array in WORKL.
            IPNTR(7): pointer to the Ritz estimates in array WORKL associated
                      with the Ritz values located in RITZ in WORKL.
            IPNTR(11): pointer to the NP shifts in WORKL. See Remark 6 below.
            Note: IPNTR(8:10) is only referenced by sseupd. See Remark 2.
            IPNTR(8): pointer to the NCV RITZ values of the original system.
            IPNTR(9): pointer to the NCV corresponding error bounds.
            IPNTR(10): pointer to the NCV by NCV matrix of eigenvectors
                       of the tridiagonal matrix T. Only referenced by
                       sseupd if RVEC = .TRUE. See Remarks.
            -------------------------------------------------------------
            
    WORKD   Real  work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD 
            as temporary workspace during the iteration. Upon termination
            WORKD(1:N) contains B*RESID(1:N). If the Ritz vectors are desired
            subroutine sseupd uses this output.
            See Data Distribution Note below.  
    WORKL   Real  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  See Data Distribution Note below.
    LWORKL  Integer.  (INPUT)
            LWORKL must be at least NCV**2 + 8*NCV .
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =  0: Normal exit.
            =  1: Maximum number of iterations taken.
                  All possible eigenvalues of OP has been found. IPARAM(5)  
                  returns the number of wanted converged Ritz values.
            =  2: No longer an informational error. Deprecated starting
                  with release 2 of ARPACK.
            =  3: No shifts could be applied during a cycle of the 
                  Implicitly restarted Arnoldi iteration. One possibility 
                  is to increase the size of NCV relative to NEV. 
                  See remark 4 below.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV must be greater than NEV and less than or equal to N.
            = -4: The maximum number of Arnoldi update iterations allowed
                  must be greater than zero.
            = -5: WHICH must be one of 'LM', 'SM', 'LA', 'SA' or 'BE'.
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work array WORKL is not sufficient.
            = -8: Error return from trid. eigenvalue calculation;
                  Informatinal error from LAPACK routine ssteqr.
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4,5.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatable.
            = -12: IPARAM(1) must be equal to 0 or 1.
            = -13: NEV and WHICH = 'BE' are incompatable.
            = -9999: Could not build an Arnoldi factorization.
                     IPARAM(5) returns the size of the current Arnoldi
                     factorization. The user is advised to check that
                     enough workspace and array storage has been allocated.

  \Remarks
    1. The converged Ritz values are always returned in ascending 
       algebraic order.  The computed Ritz values are approximate
       eigenvalues of OP.  The selection of WHICH should be made
       with this in mind when Mode = 3,4,5.  After convergence, 
       approximate eigenvalues of the original problem may be obtained 
       with the ARPACK subroutine sseupd. 
    2. If the Ritz vectors corresponding to the converged Ritz values
       are needed, the user must call sseupd immediately following completion
       of ssaupd. This is new starting with version 2.1 of ARPACK.
    3. If M can be factored into a Cholesky factorization M = LL`
       then Mode = 2 should not be selected.  Instead one should use
       Mode = 1 with  OP = inv(L)*A*inv(L`).  Appropriate triangular 
       linear systems should be solved with L and L` rather
       than computing inverses.  After convergence, an approximate
       eigenvector z of the original problem is recovered by solving
       L`z = x  where x is a Ritz vector of OP.
    4. At present there is no a-priori analysis to guide the selection
       of NCV relative to NEV.  The only formal requrement is that NCV > NEV.
       However, it is recommended that NCV .ge. 2*NEV.  If many problems of
       the same type are to be solved, one should experiment with increasing
       NCV while keeping NEV fixed for a given test problem.  This will 
       usually decrease the required number of OP*x operations but it
       also increases the work and storage required to maintain the orthogonal
       basis vectors.   The optimal "cross-over" with respect to CPU time
       is problem dependent and must be determined empirically.
    5. If IPARAM(7) = 2 then in the Reverse commuication interface the user
       must do the following. When IDO = 1, Y = OP * X is to be computed.
       When IPARAM(7) = 2 OP = inv(B)*A. After computing A*X the user
       must overwrite X with A*X. Y is then the solution to the linear set
       of equations B*Y = A*X.
    6. When IPARAM(1) = 0, and IDO = 3, the user needs to provide the 
       NP = IPARAM(8) shifts in locations: 
       1   WORKL(IPNTR(11))           
       2   WORKL(IPNTR(11)+1)         
                          .           
                          .           
                          .      
       NP  WORKL(IPNTR(11)+NP-1). 
       The eigenvalues of the current tridiagonal matrix are located in 
       WORKL(IPNTR(6)) through WORKL(IPNTR(6)+NCV-1). They are in the
       order defined by WHICH. The associated Ritz estimates are located in
       WORKL(IPNTR(8)), WORKL(IPNTR(8)+1), ... , WORKL(IPNTR(8)+NCV-1).
  -----------------------------------------------------------------------
  \Data Distribution Note:
    Fortran-D syntax:
    ================
    REAL       RESID(N), V(LDV,NCV), WORKD(3*N), WORKL(LWORKL)
    DECOMPOSE  D1(N), D2(N,NCV)
    ALIGN      RESID(I) with D1(I)
    ALIGN      V(I,J)   with D2(I,J)
    ALIGN      WORKD(I) with D1(I)     range (1:N)
    ALIGN      WORKD(I) with D1(I-N)   range (N+1:2*N)
    ALIGN      WORKD(I) with D1(I-2*N) range (2*N+1:3*N)
    DISTRIBUTE D1(BLOCK), D2(BLOCK,:)
    REPLICATED WORKL(LWORKL)
    Cray MPP syntax:
    ===============
    REAL       RESID(N), V(LDV,NCV), WORKD(N,3), WORKL(LWORKL)
    SHARED     RESID(BLOCK), V(BLOCK,:), WORKD(BLOCK,:)
    REPLICATED WORKL(LWORKL)
    
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
    8. R.B. Lehoucq, D.C. Sorensen, "Implementation of Some Spectral
       Transformations in a k-Step Arnoldi Method". In Preparation.
  \Routines called:
       ssaup2  ARPACK routine that implements the Implicitly Restarted
               Arnoldi Iteration.
       sstats  ARPACK routine that initialize timing and other statistics
               variables.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.4' 
  \SCCS Information: @(#) 
   FILE: saupd.F   SID: 2.8   DATE OF SID: 04/10/01   RELEASE: 2 
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param ncv
   * @param v
   * @param ldv
   * @param iparam
   * @param ipntr
   * @param workd
   * @param workl
   * @param lworkl
   * @param info
   * 
   */
  abstract public void ssaupd(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, int nev, org.netlib.util.floatW tol, float[] resid, int ncv, float[] v, int ldv, int[] iparam, int[] ipntr, float[] workd, float[] workl, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssaupd
  \Description: 
    Reverse communication interface for the Implicitly Restarted Arnoldi 
    Iteration.  For symmetric problems this reduces to a variant of the Lanczos 
    method.  This method has been designed to compute approximations to a 
    few eigenpairs of a linear operator OP that is real and symmetric 
    with respect to a real positive semi-definite symmetric matrix B, 
    i.e.
                     
         B*OP = (OP`)*B.  
    Another way to express this condition is 
         < x,OPy > = < OPx,y >  where < z,w > = z`Bw  .
    
    In the standard eigenproblem B is the identity matrix.  
    ( A` denotes transpose of A)
    The computed approximate eigenvalues are called Ritz values and
    the corresponding approximate eigenvectors are called Ritz vectors.
    ssaupd is usually called iteratively to solve one of the 
    following problems:
    Mode 1:  A*x = lambda*x, A symmetric 
             ===> OP = A  and  B = I.
    Mode 2:  A*x = lambda*M*x, A symmetric, M symmetric positive definite
             ===> OP = inv[M]*A  and  B = M.
             ===> (If M can be factored see remark 3 below)
    Mode 3:  K*x = lambda*M*x, K symmetric, M symmetric positive semi-definite
             ===> OP = (inv[K - sigma*M])*M  and  B = M. 
             ===> Shift-and-Invert mode
    Mode 4:  K*x = lambda*KG*x, K symmetric positive semi-definite, 
             KG symmetric indefinite
             ===> OP = (inv[K - sigma*KG])*K  and  B = K.
             ===> Buckling mode
    Mode 5:  A*x = lambda*M*x, A symmetric, M symmetric positive semi-definite
             ===> OP = inv[A - sigma*M]*[A + sigma*M]  and  B = M.
             ===> Cayley transformed mode
    NOTE: The action of w <- inv[A - sigma*M]*v or w <- inv[M]*v
          should be accomplished either by a direct method
          using a sparse matrix factorization and solving
             [A - sigma*M]*w = v  or M*w = v,
          or through an iterative method for solving these
          systems.  If an iterative method is used, the
          convergence test must be more stringent than
          the accuracy requirements for the eigenvalue
          approximations.
  \Usage:
    call ssaupd 
       ( IDO, BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM,
         IPNTR, WORKD, WORKL, LWORKL, INFO )
  \Arguments
    IDO     Integer.  (INPUT/OUTPUT)
            Reverse communication flag.  IDO must be zero on the first 
            call to ssaupd.  IDO will be set internally to
            indicate the type of operation to be performed.  Control is
            then given back to the calling routine which has the
            responsibility to carry out the requested operation and call
            ssaupd with the result.  The operand is given in
            WORKD(IPNTR(1)), the result must be put in WORKD(IPNTR(2)).
            (If Mode = 2 see remark 5 below)
            -------------------------------------------------------------
            IDO =  0: first call to the reverse communication interface
            IDO = -1: compute  Y = OP * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      This is for the initialization phase to force the
                      starting vector into the range of OP.
            IDO =  1: compute  Y = OP * X where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
                      In mode 3,4 and 5, the vector B * X is already
                      available in WORKD(ipntr(3)).  It does not
                      need to be recomputed in forming OP * X.
            IDO =  2: compute  Y = B * X  where
                      IPNTR(1) is the pointer into WORKD for X,
                      IPNTR(2) is the pointer into WORKD for Y.
            IDO =  3: compute the IPARAM(8) shifts where
                      IPNTR(11) is the pointer into WORKL for
                      placing the shifts. See remark 6 below.
            IDO = 99: done
            -------------------------------------------------------------
               
    BMAT    Character*1.  (INPUT)
            BMAT specifies the type of the matrix B that defines the
            semi-inner product for the operator OP.
            B = 'I' -> standard eigenvalue problem A*x = lambda*x
            B = 'G' -> generalized eigenvalue problem A*x = lambda*B*x
    N       Integer.  (INPUT)
            Dimension of the eigenproblem.
    WHICH   Character*2.  (INPUT)
            Specify which of the Ritz values of OP to compute.
            'LA' - compute the NEV largest (algebraic) eigenvalues.
            'SA' - compute the NEV smallest (algebraic) eigenvalues.
            'LM' - compute the NEV largest (in magnitude) eigenvalues.
            'SM' - compute the NEV smallest (in magnitude) eigenvalues. 
            'BE' - compute NEV eigenvalues, half from each end of the
                   spectrum.  When NEV is odd, compute one more from the
                   high end than from the low end.
             (see remark 1 below)
    NEV     Integer.  (INPUT)
            Number of eigenvalues of OP to be computed. 0 < NEV < N.
    TOL     Real  scalar.  (INPUT)
            Stopping criterion: the relative accuracy of the Ritz value 
            is considered acceptable if BOUNDS(I) .LE. TOL*ABS(RITZ(I)).
            If TOL .LE. 0. is passed a default is set:
            DEFAULT = SLAMCH('EPS')  (machine precision as computed
                      by the LAPACK auxiliary subroutine SLAMCH).
    RESID   Real  array of length N.  (INPUT/OUTPUT)
            On INPUT: 
            If INFO .EQ. 0, a random initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            On OUTPUT:
            RESID contains the final residual vector. 
    NCV     Integer.  (INPUT)
            Number of columns of the matrix V (less than or equal to N).
            This will indicate how many Lanczos vectors are generated 
            at each iteration.  After the startup phase in which NEV 
            Lanczos vectors are generated, the algorithm generates 
            NCV-NEV Lanczos vectors at each subsequent update iteration.
            Most of the cost in generating each Lanczos vector is in the 
            matrix-vector product OP*x. (See remark 4 below).
    V       Real  N by NCV array.  (OUTPUT)
            The NCV columns of V contain the Lanczos basis vectors.
    LDV     Integer.  (INPUT)
            Leading dimension of V exactly as declared in the calling
            program.
    IPARAM  Integer array of length 11.  (INPUT/OUTPUT)
            IPARAM(1) = ISHIFT: method for selecting the implicit shifts.
            The shifts selected at each iteration are used to restart
            the Arnoldi iteration in an implicit fashion.
            -------------------------------------------------------------
            ISHIFT = 0: the shifts are provided by the user via
                        reverse communication.  The NCV eigenvalues of
                        the current tridiagonal matrix T are returned in
                        the part of WORKL array corresponding to RITZ.
                        See remark 6 below.
            ISHIFT = 1: exact shifts with respect to the reduced 
                        tridiagonal matrix T.  This is equivalent to 
                        restarting the iteration with a starting vector 
                        that is a linear combination of Ritz vectors 
                        associated with the "wanted" Ritz values.
            -------------------------------------------------------------
            IPARAM(2) = LEVEC
            No longer referenced. See remark 2 below.
            IPARAM(3) = MXITER
            On INPUT:  maximum number of Arnoldi update iterations allowed. 
            On OUTPUT: actual number of Arnoldi update iterations taken. 
            IPARAM(4) = NB: blocksize to be used in the recurrence.
            The code currently works only for NB = 1.
            IPARAM(5) = NCONV: number of "converged" Ritz values.
            This represents the number of Ritz values that satisfy
            the convergence criterion.
            IPARAM(6) = IUPD
            No longer referenced. Implicit restarting is ALWAYS used. 
            IPARAM(7) = MODE
            On INPUT determines what type of eigenproblem is being solved.
            Must be 1,2,3,4,5; See under \Description of ssaupd for the 
            five modes available.
            IPARAM(8) = NP
            When ido = 3 and the user provides shifts through reverse
            communication (IPARAM(1)=0), ssaupd returns NP, the number
            of shifts the user is to provide. 0 < NP <=NCV-NEV. See Remark
            6 below.
            IPARAM(9) = NUMOP, IPARAM(10) = NUMOPB, IPARAM(11) = NUMREO,
            OUTPUT: NUMOP  = total number of OP*x operations,
                    NUMOPB = total number of B*x operations if BMAT='G',
                    NUMREO = total number of steps of re-orthogonalization.        
    IPNTR   Integer array of length 11.  (OUTPUT)
            Pointer to mark the starting locations in the WORKD and WORKL
            arrays for matrices/vectors used by the Lanczos iteration.
            -------------------------------------------------------------
            IPNTR(1): pointer to the current operand vector X in WORKD.
            IPNTR(2): pointer to the current result vector Y in WORKD.
            IPNTR(3): pointer to the vector B * X in WORKD when used in 
                      the shift-and-invert mode.
            IPNTR(4): pointer to the next available location in WORKL
                      that is untouched by the program.
            IPNTR(5): pointer to the NCV by 2 tridiagonal matrix T in WORKL.
            IPNTR(6): pointer to the NCV RITZ values array in WORKL.
            IPNTR(7): pointer to the Ritz estimates in array WORKL associated
                      with the Ritz values located in RITZ in WORKL.
            IPNTR(11): pointer to the NP shifts in WORKL. See Remark 6 below.
            Note: IPNTR(8:10) is only referenced by sseupd. See Remark 2.
            IPNTR(8): pointer to the NCV RITZ values of the original system.
            IPNTR(9): pointer to the NCV corresponding error bounds.
            IPNTR(10): pointer to the NCV by NCV matrix of eigenvectors
                       of the tridiagonal matrix T. Only referenced by
                       sseupd if RVEC = .TRUE. See Remarks.
            -------------------------------------------------------------
            
    WORKD   Real  work array of length 3*N.  (REVERSE COMMUNICATION)
            Distributed array to be used in the basic Arnoldi iteration
            for reverse communication.  The user should not use WORKD 
            as temporary workspace during the iteration. Upon termination
            WORKD(1:N) contains B*RESID(1:N). If the Ritz vectors are desired
            subroutine sseupd uses this output.
            See Data Distribution Note below.  
    WORKL   Real  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.  See Data Distribution Note below.
    LWORKL  Integer.  (INPUT)
            LWORKL must be at least NCV**2 + 8*NCV .
    INFO    Integer.  (INPUT/OUTPUT)
            If INFO .EQ. 0, a randomly initial residual vector is used.
            If INFO .NE. 0, RESID contains the initial residual vector,
                            possibly from a previous run.
            Error flag on output.
            =  0: Normal exit.
            =  1: Maximum number of iterations taken.
                  All possible eigenvalues of OP has been found. IPARAM(5)  
                  returns the number of wanted converged Ritz values.
            =  2: No longer an informational error. Deprecated starting
                  with release 2 of ARPACK.
            =  3: No shifts could be applied during a cycle of the 
                  Implicitly restarted Arnoldi iteration. One possibility 
                  is to increase the size of NCV relative to NEV. 
                  See remark 4 below.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV must be greater than NEV and less than or equal to N.
            = -4: The maximum number of Arnoldi update iterations allowed
                  must be greater than zero.
            = -5: WHICH must be one of 'LM', 'SM', 'LA', 'SA' or 'BE'.
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work array WORKL is not sufficient.
            = -8: Error return from trid. eigenvalue calculation;
                  Informatinal error from LAPACK routine ssteqr.
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4,5.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatable.
            = -12: IPARAM(1) must be equal to 0 or 1.
            = -13: NEV and WHICH = 'BE' are incompatable.
            = -9999: Could not build an Arnoldi factorization.
                     IPARAM(5) returns the size of the current Arnoldi
                     factorization. The user is advised to check that
                     enough workspace and array storage has been allocated.

  \Remarks
    1. The converged Ritz values are always returned in ascending 
       algebraic order.  The computed Ritz values are approximate
       eigenvalues of OP.  The selection of WHICH should be made
       with this in mind when Mode = 3,4,5.  After convergence, 
       approximate eigenvalues of the original problem may be obtained 
       with the ARPACK subroutine sseupd. 
    2. If the Ritz vectors corresponding to the converged Ritz values
       are needed, the user must call sseupd immediately following completion
       of ssaupd. This is new starting with version 2.1 of ARPACK.
    3. If M can be factored into a Cholesky factorization M = LL`
       then Mode = 2 should not be selected.  Instead one should use
       Mode = 1 with  OP = inv(L)*A*inv(L`).  Appropriate triangular 
       linear systems should be solved with L and L` rather
       than computing inverses.  After convergence, an approximate
       eigenvector z of the original problem is recovered by solving
       L`z = x  where x is a Ritz vector of OP.
    4. At present there is no a-priori analysis to guide the selection
       of NCV relative to NEV.  The only formal requrement is that NCV > NEV.
       However, it is recommended that NCV .ge. 2*NEV.  If many problems of
       the same type are to be solved, one should experiment with increasing
       NCV while keeping NEV fixed for a given test problem.  This will 
       usually decrease the required number of OP*x operations but it
       also increases the work and storage required to maintain the orthogonal
       basis vectors.   The optimal "cross-over" with respect to CPU time
       is problem dependent and must be determined empirically.
    5. If IPARAM(7) = 2 then in the Reverse commuication interface the user
       must do the following. When IDO = 1, Y = OP * X is to be computed.
       When IPARAM(7) = 2 OP = inv(B)*A. After computing A*X the user
       must overwrite X with A*X. Y is then the solution to the linear set
       of equations B*Y = A*X.
    6. When IPARAM(1) = 0, and IDO = 3, the user needs to provide the 
       NP = IPARAM(8) shifts in locations: 
       1   WORKL(IPNTR(11))           
       2   WORKL(IPNTR(11)+1)         
                          .           
                          .           
                          .      
       NP  WORKL(IPNTR(11)+NP-1). 
       The eigenvalues of the current tridiagonal matrix are located in 
       WORKL(IPNTR(6)) through WORKL(IPNTR(6)+NCV-1). They are in the
       order defined by WHICH. The associated Ritz estimates are located in
       WORKL(IPNTR(8)), WORKL(IPNTR(8)+1), ... , WORKL(IPNTR(8)+NCV-1).
  -----------------------------------------------------------------------
  \Data Distribution Note:
    Fortran-D syntax:
    ================
    REAL       RESID(N), V(LDV,NCV), WORKD(3*N), WORKL(LWORKL)
    DECOMPOSE  D1(N), D2(N,NCV)
    ALIGN      RESID(I) with D1(I)
    ALIGN      V(I,J)   with D2(I,J)
    ALIGN      WORKD(I) with D1(I)     range (1:N)
    ALIGN      WORKD(I) with D1(I-N)   range (N+1:2*N)
    ALIGN      WORKD(I) with D1(I-2*N) range (2*N+1:3*N)
    DISTRIBUTE D1(BLOCK), D2(BLOCK,:)
    REPLICATED WORKL(LWORKL)
    Cray MPP syntax:
    ===============
    REAL       RESID(N), V(LDV,NCV), WORKD(N,3), WORKL(LWORKL)
    SHARED     RESID(BLOCK), V(BLOCK,:), WORKD(BLOCK,:)
    REPLICATED WORKL(LWORKL)
    
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
    8. R.B. Lehoucq, D.C. Sorensen, "Implementation of Some Spectral
       Transformations in a k-Step Arnoldi Method". In Preparation.
  \Routines called:
       ssaup2  ARPACK routine that implements the Implicitly Restarted
               Arnoldi Iteration.
       sstats  ARPACK routine that initialize timing and other statistics
               variables.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       slamch  LAPACK routine that determines machine constants.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.4' 
  \SCCS Information: @(#) 
   FILE: saupd.F   SID: 2.8   DATE OF SID: 04/10/01   RELEASE: 2 
  \Remarks
       1. None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ido
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param ncv
   * @param v
   * @param _v_offset
   * @param ldv
   * @param iparam
   * @param _iparam_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param workl
   * @param _workl_offset
   * @param lworkl
   * @param info
   * 
   */
  abstract public void ssaupd(org.netlib.util.intW ido, java.lang.String bmat, int n, java.lang.String which, int nev, org.netlib.util.floatW tol, float[] resid, int _resid_offset, int ncv, float[] v, int _v_offset, int ldv, int[] iparam, int _iparam_offset, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, float[] workl, int _workl_offset, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssconv
  \Description: 
    Convergence testing for the symmetric Arnoldi eigenvalue routine.
  \Usage:
    call ssconv
       ( N, RITZ, BOUNDS, TOL, NCONV )
  \Arguments
    N       Integer.  (INPUT)
            Number of Ritz values to check for convergence.
    RITZ    Real array of length N.  (INPUT)
            The Ritz values to be checked for convergence.
    BOUNDS  Real array of length N.  (INPUT)
            Ritz estimates associated with the Ritz values in RITZ.
    TOL     Real scalar.  (INPUT)
            Desired relative accuracy for a Ritz value to be considered
            "converged".
    NCONV   Integer scalar.  (OUTPUT)
            Number of "converged" Ritz values.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Routines called:
       second  ARPACK utility routine for timing.
       slamch  LAPACK routine that determines machine constants. 
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: sconv.F   SID: 2.4   DATE OF SID: 4/19/96   RELEASE: 2
  \Remarks
       1. Starting with version 2.4, this routine no longer uses the
          Parlett strategy using the gap conditions. 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param ritz
   * @param bounds
   * @param tol
   * @param nconv
   * 
   */
  abstract public void ssconv(int n, float[] ritz, float[] bounds, float tol, org.netlib.util.intW nconv);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssconv
  \Description: 
    Convergence testing for the symmetric Arnoldi eigenvalue routine.
  \Usage:
    call ssconv
       ( N, RITZ, BOUNDS, TOL, NCONV )
  \Arguments
    N       Integer.  (INPUT)
            Number of Ritz values to check for convergence.
    RITZ    Real array of length N.  (INPUT)
            The Ritz values to be checked for convergence.
    BOUNDS  Real array of length N.  (INPUT)
            Ritz estimates associated with the Ritz values in RITZ.
    TOL     Real scalar.  (INPUT)
            Desired relative accuracy for a Ritz value to be considered
            "converged".
    NCONV   Integer scalar.  (OUTPUT)
            Number of "converged" Ritz values.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Routines called:
       second  ARPACK utility routine for timing.
       slamch  LAPACK routine that determines machine constants. 
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: sconv.F   SID: 2.4   DATE OF SID: 4/19/96   RELEASE: 2
  \Remarks
       1. Starting with version 2.4, this routine no longer uses the
          Parlett strategy using the gap conditions. 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param ritz
   * @param _ritz_offset
   * @param bounds
   * @param _bounds_offset
   * @param tol
   * @param nconv
   * 
   */
  abstract public void ssconv(int n, float[] ritz, int _ritz_offset, float[] bounds, int _bounds_offset, float tol, org.netlib.util.intW nconv);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sseigt
  \Description: 
    Compute the eigenvalues of the current symmetric tridiagonal matrix
    and the corresponding error bounds given the current residual norm.
  \Usage:
    call sseigt
       ( RNORM, N, H, LDH, EIG, BOUNDS, WORKL, IERR )
  \Arguments
    RNORM   Real scalar.  (INPUT)
            RNORM contains the residual norm corresponding to the current
            symmetric tridiagonal matrix H.
    N       Integer.  (INPUT)
            Size of the symmetric tridiagonal matrix H.
    H       Real N by 2 array.  (INPUT)
            H contains the symmetric tridiagonal matrix with the 
            subdiagonal in the first column starting at H(2,1) and the 
            main diagonal in second column.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    EIG     Real array of length N.  (OUTPUT)
            On output, EIG contains the N eigenvalues of H possibly 
            unsorted.  The BOUNDS arrays are returned in the
            same sorted order as EIG.
    BOUNDS  Real array of length N.  (OUTPUT)
            On output, BOUNDS contains the error estimates corresponding
            to the eigenvalues EIG.  This is equal to RNORM times the
            last components of the eigenvectors corresponding to the
            eigenvalues in EIG.
    WORKL   Real work array of length 3*N.  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.
    IERR    Integer.  (OUTPUT)
            Error exit flag from sstqrb.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       sstqrb  ARPACK routine that computes the eigenvalues and the
               last components of the eigenvectors of a symmetric
               and tridiagonal matrix.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       scopy   Level 1 BLAS that copies one vector to another.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: seigt.F   SID: 2.4   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rnorm
   * @param n
   * @param h
   * @param ldh
   * @param eig
   * @param bounds
   * @param workl
   * @param ierr
   * 
   */
  abstract public void sseigt(float rnorm, int n, float[] h, int ldh, float[] eig, float[] bounds, float[] workl, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sseigt
  \Description: 
    Compute the eigenvalues of the current symmetric tridiagonal matrix
    and the corresponding error bounds given the current residual norm.
  \Usage:
    call sseigt
       ( RNORM, N, H, LDH, EIG, BOUNDS, WORKL, IERR )
  \Arguments
    RNORM   Real scalar.  (INPUT)
            RNORM contains the residual norm corresponding to the current
            symmetric tridiagonal matrix H.
    N       Integer.  (INPUT)
            Size of the symmetric tridiagonal matrix H.
    H       Real N by 2 array.  (INPUT)
            H contains the symmetric tridiagonal matrix with the 
            subdiagonal in the first column starting at H(2,1) and the 
            main diagonal in second column.
    LDH     Integer.  (INPUT)
            Leading dimension of H exactly as declared in the calling 
            program.
    EIG     Real array of length N.  (OUTPUT)
            On output, EIG contains the N eigenvalues of H possibly 
            unsorted.  The BOUNDS arrays are returned in the
            same sorted order as EIG.
    BOUNDS  Real array of length N.  (OUTPUT)
            On output, BOUNDS contains the error estimates corresponding
            to the eigenvalues EIG.  This is equal to RNORM times the
            last components of the eigenvectors corresponding to the
            eigenvalues in EIG.
    WORKL   Real work array of length 3*N.  (WORKSPACE)
            Private (replicated) array on each PE or array allocated on
            the front end.
    IERR    Integer.  (OUTPUT)
            Error exit flag from sstqrb.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       sstqrb  ARPACK routine that computes the eigenvalues and the
               last components of the eigenvectors of a symmetric
               and tridiagonal matrix.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       scopy   Level 1 BLAS that copies one vector to another.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.4'
  \SCCS Information: @(#) 
   FILE: seigt.F   SID: 2.4   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       None
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rnorm
   * @param n
   * @param h
   * @param _h_offset
   * @param ldh
   * @param eig
   * @param _eig_offset
   * @param bounds
   * @param _bounds_offset
   * @param workl
   * @param _workl_offset
   * @param ierr
   * 
   */
  abstract public void sseigt(float rnorm, int n, float[] h, int _h_offset, int ldh, float[] eig, int _eig_offset, float[] bounds, int _bounds_offset, float[] workl, int _workl_offset, org.netlib.util.intW ierr);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssesrt
  \Description:
    Sort the array X in the order specified by WHICH and optionally 
    apply the permutation to the columns of the matrix A.
  \Usage:
    call ssesrt
       ( WHICH, APPLY, N, X, NA, A, LDA)
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> X is sorted into increasing order of magnitude.
            'SM' -> X is sorted into decreasing order of magnitude.
            'LA' -> X is sorted into increasing order of algebraic.
            'SA' -> X is sorted into decreasing order of algebraic.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to A.
            APPLY = .FALSE. -> do not apply the sorted order to A.
    N       Integer.  (INPUT)
            Dimension of the array X.
    X      Real array of length N.  (INPUT/OUTPUT)
            The array to be sorted.
    NA      Integer.  (INPUT)
            Number of rows of the matrix A.
    A      Real array of length NA by N.  (INPUT/OUTPUT)
           
    LDA     Integer.  (INPUT)
            Leading dimension of A.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Routines
       sswap  Level 1 BLAS that swaps the contents of two vectors.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/15/93: Version ' 2.1'.
                 Adapted from the sort routine in LANSO and 
                 the ARPACK code ssortr
  \SCCS Information: @(#) 
   FILE: sesrt.F   SID: 2.3   DATE OF SID: 4/19/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param x
   * @param na
   * @param a
   * @param lda
   * 
   */
  abstract public void ssesrt(java.lang.String which, boolean apply, int n, float[] x, int na, float[] a, int lda);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssesrt
  \Description:
    Sort the array X in the order specified by WHICH and optionally 
    apply the permutation to the columns of the matrix A.
  \Usage:
    call ssesrt
       ( WHICH, APPLY, N, X, NA, A, LDA)
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> X is sorted into increasing order of magnitude.
            'SM' -> X is sorted into decreasing order of magnitude.
            'LA' -> X is sorted into increasing order of algebraic.
            'SA' -> X is sorted into decreasing order of algebraic.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to A.
            APPLY = .FALSE. -> do not apply the sorted order to A.
    N       Integer.  (INPUT)
            Dimension of the array X.
    X      Real array of length N.  (INPUT/OUTPUT)
            The array to be sorted.
    NA      Integer.  (INPUT)
            Number of rows of the matrix A.
    A      Real array of length NA by N.  (INPUT/OUTPUT)
           
    LDA     Integer.  (INPUT)
            Leading dimension of A.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Routines
       sswap  Level 1 BLAS that swaps the contents of two vectors.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/15/93: Version ' 2.1'.
                 Adapted from the sort routine in LANSO and 
                 the ARPACK code ssortr
  \SCCS Information: @(#) 
   FILE: sesrt.F   SID: 2.3   DATE OF SID: 4/19/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param x
   * @param _x_offset
   * @param na
   * @param a
   * @param _a_offset
   * @param lda
   * 
   */
  abstract public void ssesrt(java.lang.String which, boolean apply, int n, float[] x, int _x_offset, int na, float[] a, int _a_offset, int lda);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: sseupd
  \Description: 
    This subroutine returns the converged approximations to eigenvalues
    of A*z = lambda*B*z and (optionally):
        (1) the corresponding approximate eigenvectors,
        (2) an orthonormal (Lanczos) basis for the associated approximate
            invariant subspace,
        (3) Both.
    There is negligible additional cost to obtain eigenvectors.  An orthonormal
    (Lanczos) basis is always computed.  There is an additional storage cost 
    of n*nev if both are requested (in this case a separate array Z must be 
    supplied).
    These quantities are obtained from the Lanczos factorization computed
    by SSAUPD for the linear operator OP prescribed by the MODE selection
    (see IPARAM(7) in SSAUPD documentation.)  SSAUPD must be called before
    this routine is called. These approximate eigenvalues and vectors are 
    commonly called Ritz values and Ritz vectors respectively.  They are 
    referred to as such in the comments that follow.   The computed orthonormal 
    basis for the invariant subspace corresponding to these Ritz values is 
    referred to as a Lanczos basis.
    See documentation in the header of the subroutine SSAUPD for a definition 
    of OP as well as other terms and the relation of computed Ritz values 
    and vectors of OP with respect to the given problem  A*z = lambda*B*z.  
    The approximate eigenvalues of the original problem are returned in
    ascending algebraic order.  The user may elect to call this routine
    once for each desired Ritz vector and store it peripherally if desired.
    There is also the option of computing a selected set of these vectors
    with a single call.
  \Usage:
    call sseupd 
       ( RVEC, HOWMNY, SELECT, D, Z, LDZ, SIGMA, BMAT, N, WHICH, NEV, TOL,
         RESID, NCV, V, LDV, IPARAM, IPNTR, WORKD, WORKL, LWORKL, INFO )
    RVEC    LOGICAL  (INPUT) 
            Specifies whether Ritz vectors corresponding to the Ritz value 
            approximations to the eigenproblem A*z = lambda*B*z are computed.
               RVEC = .FALSE.     Compute Ritz values only.
               RVEC = .TRUE.      Compute Ritz vectors.
    HOWMNY  Character*1  (INPUT) 
            Specifies how many Ritz vectors are wanted and the form of Z
            the matrix of Ritz vectors. See remark 1 below.
            = 'A': compute NEV Ritz vectors;
            = 'S': compute some of the Ritz vectors, specified
                   by the logical array SELECT.
    SELECT  Logical array of dimension NCV.  (INPUT/WORKSPACE)
            If HOWMNY = 'S', SELECT specifies the Ritz vectors to be
            computed. To select the Ritz vector corresponding to a
            Ritz value D(j), SELECT(j) must be set to .TRUE.. 
            If HOWMNY = 'A' , SELECT is used as a workspace for
            reordering the Ritz values.
    D       Real  array of dimension NEV.  (OUTPUT)
            On exit, D contains the Ritz value approximations to the
            eigenvalues of A*z = lambda*B*z. The values are returned
            in ascending order. If IPARAM(7) = 3,4,5 then D represents
            the Ritz values of OP computed by ssaupd transformed to
            those of the original eigensystem A*z = lambda*B*z. If 
            IPARAM(7) = 1,2 then the Ritz values of OP are the same 
            as the those of A*z = lambda*B*z.
    Z       Real  N by NEV array if HOWMNY = 'A'.  (OUTPUT)
            On exit, Z contains the B-orthonormal Ritz vectors of the
            eigensystem A*z = lambda*B*z corresponding to the Ritz
            value approximations.
            If  RVEC = .FALSE. then Z is not referenced.
            NOTE: The array Z may be set equal to first NEV columns of the 
            Arnoldi/Lanczos basis array V computed by SSAUPD.
    LDZ     Integer.  (INPUT)
            The leading dimension of the array Z.  If Ritz vectors are
            desired, then  LDZ .ge.  max( 1, N ).  In any case,  LDZ .ge. 1.
    SIGMA   Real   (INPUT)
            If IPARAM(7) = 3,4,5 represents the shift. Not referenced if
            IPARAM(7) = 1 or 2.

    **** The remaining arguments MUST be the same as for the   ****
    **** call to SSAUPD that was just completed.               ****
    NOTE: The remaining arguments
             BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR,
             WORKD, WORKL, LWORKL, INFO
           must be passed directly to SSEUPD following the last call
           to SSAUPD.  These arguments MUST NOT BE MODIFIED between
           the the last call to SSAUPD and the call to SSEUPD.
    Two of these parameters (WORKL, INFO) are also output parameters:
    WORKL   Real  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            WORKL(1:4*ncv) contains information obtained in
            ssaupd.  They are not changed by sseupd.
            WORKL(4*ncv+1:ncv*ncv+8*ncv) holds the
            untransformed Ritz values, the computed error estimates,
            and the associated eigenvector matrix of H.
            Note: IPNTR(8:10) contains the pointer into WORKL for addresses
            of the above information computed by sseupd.
            -------------------------------------------------------------
            IPNTR(8): pointer to the NCV RITZ values of the original system.
            IPNTR(9): pointer to the NCV corresponding error bounds.
            IPNTR(10): pointer to the NCV by NCV matrix of eigenvectors
                       of the tridiagonal matrix T. Only referenced by
                       sseupd if RVEC = .TRUE. See Remarks.
            -------------------------------------------------------------
    INFO    Integer.  (OUTPUT)
            Error flag on output.
            =  0: Normal exit.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV must be greater than NEV and less than or equal to N.
            = -5: WHICH must be one of 'LM', 'SM', 'LA', 'SA' or 'BE'.
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work WORKL array is not sufficient.
            = -8: Error return from trid. eigenvalue calculation;
                  Information error from LAPACK routine ssteqr.
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4,5.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatible.
            = -12: NEV and WHICH = 'BE' are incompatible.
            = -14: SSAUPD did not find any eigenvalues to sufficient
                   accuracy.
            = -15: HOWMNY must be one of 'A' or 'S' if RVEC = .true.
            = -16: HOWMNY = 'S' not yet implemented
            = -17: SSEUPD got a different count of the number of converged
                   Ritz values than SSAUPD got.  This indicates the user
                   probably made an error in passing data from SSAUPD to
                   SSEUPD or that the data was modified before entering 
                   SSEUPD.
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
  \Remarks
    1. The converged Ritz values are always returned in increasing 
       (algebraic) order.
    2. Currently only HOWMNY = 'A' is implemented. It is included at this
       stage for the user who wants to incorporate it. 
  \Routines called:
       ssesrt  ARPACK routine that sorts an array X, and applies the
               corresponding permutation to a matrix A.
       ssortr  ssortr  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       svout   ARPACK utility routine that prints vectors.
       sgeqr2  LAPACK routine that computes the QR factorization of
               a matrix.
       slacpy  LAPACK matrix copy routine.
       slamch  LAPACK routine that determines machine constants.
       sorm2r  LAPACK routine that applies an orthogonal matrix in
               factored form.
       ssteqr  LAPACK routine that computes eigenvalues and eigenvectors
               of a tridiagonal matrix.
       sger    Level 2 BLAS rank one update to a matrix.
       scopy   Level 1 BLAS that copies one vector to another .
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sscal   Level 1 BLAS that scales a vector.
       sswap   Level 1 BLAS that swaps the contents of two vectors.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Chao Yang                    Houston, Texas
       Dept. of Computational & 
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: seupd.F   SID: 2.11   DATE OF SID: 04/10/01   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rvec
   * @param howmny
   * @param select
   * @param d
   * @param z
   * @param ldz
   * @param sigma
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param ncv
   * @param v
   * @param ldv
   * @param iparam
   * @param ipntr
   * @param workd
   * @param workl
   * @param lworkl
   * @param info
   * 
   */
  abstract public void sseupd(boolean rvec, java.lang.String howmny, boolean[] select, float[] d, float[] z, int ldz, float sigma, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, float tol, float[] resid, int ncv, float[] v, int ldv, int[] iparam, int[] ipntr, float[] workd, float[] workl, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *\BeginDoc
  \Name: sseupd
  \Description: 
    This subroutine returns the converged approximations to eigenvalues
    of A*z = lambda*B*z and (optionally):
        (1) the corresponding approximate eigenvectors,
        (2) an orthonormal (Lanczos) basis for the associated approximate
            invariant subspace,
        (3) Both.
    There is negligible additional cost to obtain eigenvectors.  An orthonormal
    (Lanczos) basis is always computed.  There is an additional storage cost 
    of n*nev if both are requested (in this case a separate array Z must be 
    supplied).
    These quantities are obtained from the Lanczos factorization computed
    by SSAUPD for the linear operator OP prescribed by the MODE selection
    (see IPARAM(7) in SSAUPD documentation.)  SSAUPD must be called before
    this routine is called. These approximate eigenvalues and vectors are 
    commonly called Ritz values and Ritz vectors respectively.  They are 
    referred to as such in the comments that follow.   The computed orthonormal 
    basis for the invariant subspace corresponding to these Ritz values is 
    referred to as a Lanczos basis.
    See documentation in the header of the subroutine SSAUPD for a definition 
    of OP as well as other terms and the relation of computed Ritz values 
    and vectors of OP with respect to the given problem  A*z = lambda*B*z.  
    The approximate eigenvalues of the original problem are returned in
    ascending algebraic order.  The user may elect to call this routine
    once for each desired Ritz vector and store it peripherally if desired.
    There is also the option of computing a selected set of these vectors
    with a single call.
  \Usage:
    call sseupd 
       ( RVEC, HOWMNY, SELECT, D, Z, LDZ, SIGMA, BMAT, N, WHICH, NEV, TOL,
         RESID, NCV, V, LDV, IPARAM, IPNTR, WORKD, WORKL, LWORKL, INFO )
    RVEC    LOGICAL  (INPUT) 
            Specifies whether Ritz vectors corresponding to the Ritz value 
            approximations to the eigenproblem A*z = lambda*B*z are computed.
               RVEC = .FALSE.     Compute Ritz values only.
               RVEC = .TRUE.      Compute Ritz vectors.
    HOWMNY  Character*1  (INPUT) 
            Specifies how many Ritz vectors are wanted and the form of Z
            the matrix of Ritz vectors. See remark 1 below.
            = 'A': compute NEV Ritz vectors;
            = 'S': compute some of the Ritz vectors, specified
                   by the logical array SELECT.
    SELECT  Logical array of dimension NCV.  (INPUT/WORKSPACE)
            If HOWMNY = 'S', SELECT specifies the Ritz vectors to be
            computed. To select the Ritz vector corresponding to a
            Ritz value D(j), SELECT(j) must be set to .TRUE.. 
            If HOWMNY = 'A' , SELECT is used as a workspace for
            reordering the Ritz values.
    D       Real  array of dimension NEV.  (OUTPUT)
            On exit, D contains the Ritz value approximations to the
            eigenvalues of A*z = lambda*B*z. The values are returned
            in ascending order. If IPARAM(7) = 3,4,5 then D represents
            the Ritz values of OP computed by ssaupd transformed to
            those of the original eigensystem A*z = lambda*B*z. If 
            IPARAM(7) = 1,2 then the Ritz values of OP are the same 
            as the those of A*z = lambda*B*z.
    Z       Real  N by NEV array if HOWMNY = 'A'.  (OUTPUT)
            On exit, Z contains the B-orthonormal Ritz vectors of the
            eigensystem A*z = lambda*B*z corresponding to the Ritz
            value approximations.
            If  RVEC = .FALSE. then Z is not referenced.
            NOTE: The array Z may be set equal to first NEV columns of the 
            Arnoldi/Lanczos basis array V computed by SSAUPD.
    LDZ     Integer.  (INPUT)
            The leading dimension of the array Z.  If Ritz vectors are
            desired, then  LDZ .ge.  max( 1, N ).  In any case,  LDZ .ge. 1.
    SIGMA   Real   (INPUT)
            If IPARAM(7) = 3,4,5 represents the shift. Not referenced if
            IPARAM(7) = 1 or 2.

    **** The remaining arguments MUST be the same as for the   ****
    **** call to SSAUPD that was just completed.               ****
    NOTE: The remaining arguments
             BMAT, N, WHICH, NEV, TOL, RESID, NCV, V, LDV, IPARAM, IPNTR,
             WORKD, WORKL, LWORKL, INFO
           must be passed directly to SSEUPD following the last call
           to SSAUPD.  These arguments MUST NOT BE MODIFIED between
           the the last call to SSAUPD and the call to SSEUPD.
    Two of these parameters (WORKL, INFO) are also output parameters:
    WORKL   Real  work array of length LWORKL.  (OUTPUT/WORKSPACE)
            WORKL(1:4*ncv) contains information obtained in
            ssaupd.  They are not changed by sseupd.
            WORKL(4*ncv+1:ncv*ncv+8*ncv) holds the
            untransformed Ritz values, the computed error estimates,
            and the associated eigenvector matrix of H.
            Note: IPNTR(8:10) contains the pointer into WORKL for addresses
            of the above information computed by sseupd.
            -------------------------------------------------------------
            IPNTR(8): pointer to the NCV RITZ values of the original system.
            IPNTR(9): pointer to the NCV corresponding error bounds.
            IPNTR(10): pointer to the NCV by NCV matrix of eigenvectors
                       of the tridiagonal matrix T. Only referenced by
                       sseupd if RVEC = .TRUE. See Remarks.
            -------------------------------------------------------------
    INFO    Integer.  (OUTPUT)
            Error flag on output.
            =  0: Normal exit.
            = -1: N must be positive.
            = -2: NEV must be positive.
            = -3: NCV must be greater than NEV and less than or equal to N.
            = -5: WHICH must be one of 'LM', 'SM', 'LA', 'SA' or 'BE'.
            = -6: BMAT must be one of 'I' or 'G'.
            = -7: Length of private work WORKL array is not sufficient.
            = -8: Error return from trid. eigenvalue calculation;
                  Information error from LAPACK routine ssteqr.
            = -9: Starting vector is zero.
            = -10: IPARAM(7) must be 1,2,3,4,5.
            = -11: IPARAM(7) = 1 and BMAT = 'G' are incompatible.
            = -12: NEV and WHICH = 'BE' are incompatible.
            = -14: SSAUPD did not find any eigenvalues to sufficient
                   accuracy.
            = -15: HOWMNY must be one of 'A' or 'S' if RVEC = .true.
            = -16: HOWMNY = 'S' not yet implemented
            = -17: SSEUPD got a different count of the number of converged
                   Ritz values than SSAUPD got.  This indicates the user
                   probably made an error in passing data from SSAUPD to
                   SSEUPD or that the data was modified before entering 
                   SSEUPD.
  \BeginLib
  \References:
    1. D.C. Sorensen, "Implicit Application of Polynomial Filters in
       a k-Step Arnoldi Method", SIAM J. Matr. Anal. Apps., 13 (1992),
       pp 357-385.
    2. R.B. Lehoucq, "Analysis and Implementation of an Implicitly 
       Restarted Arnoldi Iteration", Rice University Technical Report
       TR95-13, Department of Computational and Applied Mathematics.
    3. B.N. Parlett, "The Symmetric Eigenvalue Problem". Prentice-Hall,
       1980.
    4. B.N. Parlett, B. Nour-Omid, "Towards a Black Box Lanczos Program",
       Computer Physics Communications, 53 (1989), pp 169-179.
    5. B. Nour-Omid, B.N. Parlett, T. Ericson, P.S. Jensen, "How to
       Implement the Spectral Transformation", Math. Comp., 48 (1987),
       pp 663-673.
    6. R.G. Grimes, J.G. Lewis and H.D. Simon, "A Shifted Block Lanczos 
       Algorithm for Solving Sparse Symmetric Generalized Eigenproblems", 
       SIAM J. Matr. Anal. Apps.,  January (1993).
    7. L. Reichel, W.B. Gragg, "Algorithm 686: FORTRAN Subroutines
       for Updating the QR decomposition", ACM TOMS, December 1990,
       Volume 16 Number 4, pp 369-377.
  \Remarks
    1. The converged Ritz values are always returned in increasing 
       (algebraic) order.
    2. Currently only HOWMNY = 'A' is implemented. It is included at this
       stage for the user who wants to incorporate it. 
  \Routines called:
       ssesrt  ARPACK routine that sorts an array X, and applies the
               corresponding permutation to a matrix A.
       ssortr  ssortr  ARPACK sorting routine.
       ivout   ARPACK utility routine that prints integers.
       svout   ARPACK utility routine that prints vectors.
       sgeqr2  LAPACK routine that computes the QR factorization of
               a matrix.
       slacpy  LAPACK matrix copy routine.
       slamch  LAPACK routine that determines machine constants.
       sorm2r  LAPACK routine that applies an orthogonal matrix in
               factored form.
       ssteqr  LAPACK routine that computes eigenvalues and eigenvectors
               of a tridiagonal matrix.
       sger    Level 2 BLAS rank one update to a matrix.
       scopy   Level 1 BLAS that copies one vector to another .
       snrm2   Level 1 BLAS that computes the norm of a vector.
       sscal   Level 1 BLAS that scales a vector.
       sswap   Level 1 BLAS that swaps the contents of two vectors.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Chao Yang                    Houston, Texas
       Dept. of Computational & 
       Applied Mathematics
       Rice University           
       Houston, Texas            
   
  \Revision history:
       12/15/93: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: seupd.F   SID: 2.11   DATE OF SID: 04/10/01   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param rvec
   * @param howmny
   * @param select
   * @param _select_offset
   * @param d
   * @param _d_offset
   * @param z
   * @param _z_offset
   * @param ldz
   * @param sigma
   * @param bmat
   * @param n
   * @param which
   * @param nev
   * @param tol
   * @param resid
   * @param _resid_offset
   * @param ncv
   * @param v
   * @param _v_offset
   * @param ldv
   * @param iparam
   * @param _iparam_offset
   * @param ipntr
   * @param _ipntr_offset
   * @param workd
   * @param _workd_offset
   * @param workl
   * @param _workl_offset
   * @param lworkl
   * @param info
   * 
   */
  abstract public void sseupd(boolean rvec, java.lang.String howmny, boolean[] select, int _select_offset, float[] d, int _d_offset, float[] z, int _z_offset, int ldz, float sigma, java.lang.String bmat, int n, java.lang.String which, org.netlib.util.intW nev, float tol, float[] resid, int _resid_offset, int ncv, float[] v, int _v_offset, int ldv, int[] iparam, int _iparam_offset, int[] ipntr, int _ipntr_offset, float[] workd, int _workd_offset, float[] workl, int _workl_offset, int lworkl, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssgets
  \Description: 
    Given the eigenvalues of the symmetric tridiagonal matrix H,
    computes the NP shifts AMU that are zeros of the polynomial of 
    degree NP which filters out components of the unwanted eigenvectors 
    corresponding to the AMU's based on some given criteria.
    NOTE: This is called even in the case of user specified shifts in 
    order to sort the eigenvalues, and error bounds of H for later use.
  \Usage:
    call ssgets
       ( ISHIFT, WHICH, KEV, NP, RITZ, BOUNDS, SHIFTS )
  \Arguments
    ISHIFT  Integer.  (INPUT)
            Method for selecting the implicit shifts at each iteration.
            ISHIFT = 0: user specified shifts
            ISHIFT = 1: exact shift with respect to the matrix H.
    WHICH   Character*2.  (INPUT)
            Shift selection criteria.
            'LM' -> KEV eigenvalues of largest magnitude are retained.
            'SM' -> KEV eigenvalues of smallest magnitude are retained.
            'LA' -> KEV eigenvalues of largest value are retained.
            'SA' -> KEV eigenvalues of smallest value are retained.
            'BE' -> KEV eigenvalues, half from each end of the spectrum.
                    If KEV is odd, compute one more from the high end.
    KEV      Integer.  (INPUT)
            KEV+NP is the size of the matrix H.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be computed.
    RITZ    Real array of length KEV+NP.  (INPUT/OUTPUT)
            On INPUT, RITZ contains the eigenvalues of H.
            On OUTPUT, RITZ are sorted so that the unwanted eigenvalues 
            are in the first NP locations and the wanted part is in 
            the last KEV locations.  When exact shifts are selected, the
            unwanted part corresponds to the shifts to be applied.
    BOUNDS  Real array of length KEV+NP.  (INPUT/OUTPUT)
            Error bounds corresponding to the ordering in RITZ.
    SHIFTS  Real array of length NP.  (INPUT/OUTPUT)
            On INPUT:  contains the user specified shifts if ISHIFT = 0.
            On OUTPUT: contains the shifts sorted into decreasing order 
            of magnitude with respect to the Ritz estimates contained in
            BOUNDS. If ISHIFT = 0, SHIFTS is not modified on exit.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       ssortr  ARPACK utility sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       scopy   Level 1 BLAS that copies one vector to another.
       sswap   Level 1 BLAS that swaps the contents of two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/93: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: sgets.F   SID: 2.4   DATE OF SID: 4/19/96   RELEASE: 2
  \Remarks
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ishift
   * @param which
   * @param kev
   * @param np
   * @param ritz
   * @param bounds
   * @param shifts
   * 
   */
  abstract public void ssgets(int ishift, java.lang.String which, org.netlib.util.intW kev, org.netlib.util.intW np, float[] ritz, float[] bounds, float[] shifts);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssgets
  \Description: 
    Given the eigenvalues of the symmetric tridiagonal matrix H,
    computes the NP shifts AMU that are zeros of the polynomial of 
    degree NP which filters out components of the unwanted eigenvectors 
    corresponding to the AMU's based on some given criteria.
    NOTE: This is called even in the case of user specified shifts in 
    order to sort the eigenvalues, and error bounds of H for later use.
  \Usage:
    call ssgets
       ( ISHIFT, WHICH, KEV, NP, RITZ, BOUNDS, SHIFTS )
  \Arguments
    ISHIFT  Integer.  (INPUT)
            Method for selecting the implicit shifts at each iteration.
            ISHIFT = 0: user specified shifts
            ISHIFT = 1: exact shift with respect to the matrix H.
    WHICH   Character*2.  (INPUT)
            Shift selection criteria.
            'LM' -> KEV eigenvalues of largest magnitude are retained.
            'SM' -> KEV eigenvalues of smallest magnitude are retained.
            'LA' -> KEV eigenvalues of largest value are retained.
            'SA' -> KEV eigenvalues of smallest value are retained.
            'BE' -> KEV eigenvalues, half from each end of the spectrum.
                    If KEV is odd, compute one more from the high end.
    KEV      Integer.  (INPUT)
            KEV+NP is the size of the matrix H.
    NP      Integer.  (INPUT)
            Number of implicit shifts to be computed.
    RITZ    Real array of length KEV+NP.  (INPUT/OUTPUT)
            On INPUT, RITZ contains the eigenvalues of H.
            On OUTPUT, RITZ are sorted so that the unwanted eigenvalues 
            are in the first NP locations and the wanted part is in 
            the last KEV locations.  When exact shifts are selected, the
            unwanted part corresponds to the shifts to be applied.
    BOUNDS  Real array of length KEV+NP.  (INPUT/OUTPUT)
            Error bounds corresponding to the ordering in RITZ.
    SHIFTS  Real array of length NP.  (INPUT/OUTPUT)
            On INPUT:  contains the user specified shifts if ISHIFT = 0.
            On OUTPUT: contains the shifts sorted into decreasing order 
            of magnitude with respect to the Ritz estimates contained in
            BOUNDS. If ISHIFT = 0, SHIFTS is not modified on exit.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       ssortr  ARPACK utility sorting routine.
       ivout   ARPACK utility routine that prints integers.
       second  ARPACK utility routine for timing.
       svout   ARPACK utility routine that prints vectors.
       scopy   Level 1 BLAS that copies one vector to another.
       sswap   Level 1 BLAS that swaps the contents of two vectors.
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/93: Version ' 2.1'
  \SCCS Information: @(#) 
   FILE: sgets.F   SID: 2.4   DATE OF SID: 4/19/96   RELEASE: 2
  \Remarks
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param ishift
   * @param which
   * @param kev
   * @param np
   * @param ritz
   * @param _ritz_offset
   * @param bounds
   * @param _bounds_offset
   * @param shifts
   * @param _shifts_offset
   * 
   */
  abstract public void ssgets(int ishift, java.lang.String which, org.netlib.util.intW kev, org.netlib.util.intW np, float[] ritz, int _ritz_offset, float[] bounds, int _bounds_offset, float[] shifts, int _shifts_offset);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssortc
  \Description:
    Sorts the complex array in XREAL and XIMAG into the order 
    specified by WHICH and optionally applies the permutation to the
    real array Y. It is assumed that if an element of XIMAG is
    nonzero, then its negative is also an element. In other words,
    both members of a complex conjugate pair are to be sorted and the
    pairs are kept adjacent to each other.
  \Usage:
    call ssortc
       ( WHICH, APPLY, N, XREAL, XIMAG, Y )
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> sort XREAL,XIMAG into increasing order of magnitude.
            'SM' -> sort XREAL,XIMAG into decreasing order of magnitude.
            'LR' -> sort XREAL into increasing order of algebraic.
            'SR' -> sort XREAL into decreasing order of algebraic.
            'LI' -> sort XIMAG into increasing order of magnitude.
            'SI' -> sort XIMAG into decreasing order of magnitude.
            NOTE: If an element of XIMAG is non-zero, then its negative
                  is also an element.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to array Y.
            APPLY = .FALSE. -> do not apply the sorted order to array Y.
    N       Integer.  (INPUT)
            Size of the arrays.
    XREAL,  Real array of length N.  (INPUT/OUTPUT)
    XIMAG   Real and imaginary part of the array to be sorted.
    Y       Real array of length N.  (INPUT/OUTPUT)
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.1'
                 Adapted from the sort routine in LANSO.
  \SCCS Information: @(#) 
   FILE: sortc.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param xreal
   * @param ximag
   * @param y
   * 
   */
  abstract public void ssortc(java.lang.String which, boolean apply, int n, float[] xreal, float[] ximag, float[] y);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssortc
  \Description:
    Sorts the complex array in XREAL and XIMAG into the order 
    specified by WHICH and optionally applies the permutation to the
    real array Y. It is assumed that if an element of XIMAG is
    nonzero, then its negative is also an element. In other words,
    both members of a complex conjugate pair are to be sorted and the
    pairs are kept adjacent to each other.
  \Usage:
    call ssortc
       ( WHICH, APPLY, N, XREAL, XIMAG, Y )
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> sort XREAL,XIMAG into increasing order of magnitude.
            'SM' -> sort XREAL,XIMAG into decreasing order of magnitude.
            'LR' -> sort XREAL into increasing order of algebraic.
            'SR' -> sort XREAL into decreasing order of algebraic.
            'LI' -> sort XIMAG into increasing order of magnitude.
            'SI' -> sort XIMAG into decreasing order of magnitude.
            NOTE: If an element of XIMAG is non-zero, then its negative
                  is also an element.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to array Y.
            APPLY = .FALSE. -> do not apply the sorted order to array Y.
    N       Integer.  (INPUT)
            Size of the arrays.
    XREAL,  Real array of length N.  (INPUT/OUTPUT)
    XIMAG   Real and imaginary part of the array to be sorted.
    Y       Real array of length N.  (INPUT/OUTPUT)
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       xx/xx/92: Version ' 2.1'
                 Adapted from the sort routine in LANSO.
  \SCCS Information: @(#) 
   FILE: sortc.F   SID: 2.3   DATE OF SID: 4/20/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param xreal
   * @param _xreal_offset
   * @param ximag
   * @param _ximag_offset
   * @param y
   * @param _y_offset
   * 
   */
  abstract public void ssortc(java.lang.String which, boolean apply, int n, float[] xreal, int _xreal_offset, float[] ximag, int _ximag_offset, float[] y, int _y_offset);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssortr
  \Description:
    Sort the array X1 in the order specified by WHICH and optionally 
    applies the permutation to the array X2.
  \Usage:
    call ssortr
       ( WHICH, APPLY, N, X1, X2 )
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> X1 is sorted into increasing order of magnitude.
            'SM' -> X1 is sorted into decreasing order of magnitude.
            'LA' -> X1 is sorted into increasing order of algebraic.
            'SA' -> X1 is sorted into decreasing order of algebraic.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to X2.
            APPLY = .FALSE. -> do not apply the sorted order to X2.
    N       Integer.  (INPUT)
            Size of the arrays.
    X1      Real array of length N.  (INPUT/OUTPUT)
            The array to be sorted.
    X2      Real array of length N.  (INPUT/OUTPUT)
            Only referenced if APPLY = .TRUE.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/16/93: Version ' 2.1'.
                 Adapted from the sort routine in LANSO.
  \SCCS Information: @(#) 
   FILE: sortr.F   SID: 2.3   DATE OF SID: 4/19/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param x1
   * @param x2
   * 
   */
  abstract public void ssortr(java.lang.String which, boolean apply, int n, float[] x1, float[] x2);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: ssortr
  \Description:
    Sort the array X1 in the order specified by WHICH and optionally 
    applies the permutation to the array X2.
  \Usage:
    call ssortr
       ( WHICH, APPLY, N, X1, X2 )
  \Arguments
    WHICH   Character*2.  (Input)
            'LM' -> X1 is sorted into increasing order of magnitude.
            'SM' -> X1 is sorted into decreasing order of magnitude.
            'LA' -> X1 is sorted into increasing order of algebraic.
            'SA' -> X1 is sorted into decreasing order of algebraic.
    APPLY   Logical.  (Input)
            APPLY = .TRUE.  -> apply the sorted order to X2.
            APPLY = .FALSE. -> do not apply the sorted order to X2.
    N       Integer.  (INPUT)
            Size of the arrays.
    X1      Real array of length N.  (INPUT/OUTPUT)
            The array to be sorted.
    X2      Real array of length N.  (INPUT/OUTPUT)
            Only referenced if APPLY = .TRUE.
  \EndDoc
  -----------------------------------------------------------------------
  \BeginLib
  \Author
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University 
       Dept. of Computational &     Houston, Texas 
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \Revision history:
       12/16/93: Version ' 2.1'.
                 Adapted from the sort routine in LANSO.
  \SCCS Information: @(#) 
   FILE: sortr.F   SID: 2.3   DATE OF SID: 4/19/96   RELEASE: 2
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param which
   * @param apply
   * @param n
   * @param x1
   * @param _x1_offset
   * @param x2
   * @param _x2_offset
   * 
   */
  abstract public void ssortr(java.lang.String which, boolean apply, int n, float[] x1, int _x1_offset, float[] x2, int _x2_offset);

  /**
   * <pre><code>
       %---------------------------------------------%
       | Initialize statistic and timing information |
       | for nonsymmetric Arnoldi code.              |
       %---------------------------------------------%
   * </code></pre>
   *
   * 
   */
  abstract public void sstatn();

  /**
   * <pre><code>
       %---------------------------------------------%
       | Initialize statistic and timing information |
       | for symmetric Arnoldi code.                 |
       %---------------------------------------------%
   * </code></pre>
   *
   * 
   */
  abstract public void sstats();

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sstqrb
  \Description:
    Computes all eigenvalues and the last component of the eigenvectors
    of a symmetric tridiagonal matrix using the implicit QL or QR method.
    This is mostly a modification of the LAPACK routine ssteqr.
    See Remarks.
  \Usage:
    call sstqrb
       ( N, D, E, Z, WORK, INFO )
  \Arguments
    N       Integer.  (INPUT)
            The number of rows and columns in the matrix.  N >= 0.
    D       Real array, dimension (N).  (INPUT/OUTPUT)
            On entry, D contains the diagonal elements of the
            tridiagonal matrix.
            On exit, D contains the eigenvalues, in ascending order.
            If an error exit is made, the eigenvalues are correct
            for indices 1,2,...,INFO-1, but they are unordered and
            may not be the smallest eigenvalues of the matrix.
    E       Real array, dimension (N-1).  (INPUT/OUTPUT)
            On entry, E contains the subdiagonal elements of the
            tridiagonal matrix in positions 1 through N-1.
            On exit, E has been destroyed.
    Z       Real array, dimension (N).  (OUTPUT)
            On exit, Z contains the last row of the orthonormal 
            eigenvector matrix of the symmetric tridiagonal matrix.  
            If an error exit is made, Z contains the last row of the
            eigenvector matrix associated with the stored eigenvalues.
    WORK    Real array, dimension (max(1,2*N-2)).  (WORKSPACE)
            Workspace used in accumulating the transformation for 
            computing the last components of the eigenvectors.
    INFO    Integer.  (OUTPUT)
            = 0:  normal return.
            < 0:  if INFO = -i, the i-th argument had an illegal value.
            > 0:  if INFO = +i, the i-th eigenvalue has not converged
                                after a total of  30*N  iterations.
  \Remarks
    1. None.
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       saxpy   Level 1 BLAS that computes a vector triad.
       scopy   Level 1 BLAS that copies one vector to another.
       sswap   Level 1 BLAS that swaps the contents of two vectors.
       lsame   LAPACK character comparison routine.
       slae2   LAPACK routine that computes the eigenvalues of a 2-by-2 
               symmetric matrix.
       slaev2  LAPACK routine that eigendecomposition of a 2-by-2 symmetric 
               matrix.
       slamch  LAPACK routine that determines machine constants.
       slanst  LAPACK routine that computes the norm of a matrix.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       slartg  LAPACK Givens rotation construction routine.
       slascl  LAPACK routine for careful scaling of a matrix.
       slaset  LAPACK matrix initialization routine.
       slasr   LAPACK routine that applies an orthogonal transformation to 
               a matrix.
       slasrt  LAPACK sorting routine.
       ssteqr  LAPACK routine that computes eigenvalues and eigenvectors
               of a symmetric tridiagonal matrix.
       xerbla  LAPACK error handler routine.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: stqrb.F   SID: 2.5   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       1. Starting with version 2.5, this routine is a modified version
          of LAPACK version 2.0 subroutine SSTEQR. No lines are deleted,
          only commeted out and new lines inserted.
          All lines commented out have "c$$$" at the beginning.
          Note that the LAPACK version 1.0 subroutine SSTEQR contained
          bugs. 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param d
   * @param e
   * @param z
   * @param work
   * @param info
   * 
   */
  abstract public void sstqrb(int n, float[] d, float[] e, float[] z, float[] work, org.netlib.util.intW info);

  /**
   * <pre><code>
   *-----------------------------------------------------------------------
  \BeginDoc
  \Name: sstqrb
  \Description:
    Computes all eigenvalues and the last component of the eigenvectors
    of a symmetric tridiagonal matrix using the implicit QL or QR method.
    This is mostly a modification of the LAPACK routine ssteqr.
    See Remarks.
  \Usage:
    call sstqrb
       ( N, D, E, Z, WORK, INFO )
  \Arguments
    N       Integer.  (INPUT)
            The number of rows and columns in the matrix.  N >= 0.
    D       Real array, dimension (N).  (INPUT/OUTPUT)
            On entry, D contains the diagonal elements of the
            tridiagonal matrix.
            On exit, D contains the eigenvalues, in ascending order.
            If an error exit is made, the eigenvalues are correct
            for indices 1,2,...,INFO-1, but they are unordered and
            may not be the smallest eigenvalues of the matrix.
    E       Real array, dimension (N-1).  (INPUT/OUTPUT)
            On entry, E contains the subdiagonal elements of the
            tridiagonal matrix in positions 1 through N-1.
            On exit, E has been destroyed.
    Z       Real array, dimension (N).  (OUTPUT)
            On exit, Z contains the last row of the orthonormal 
            eigenvector matrix of the symmetric tridiagonal matrix.  
            If an error exit is made, Z contains the last row of the
            eigenvector matrix associated with the stored eigenvalues.
    WORK    Real array, dimension (max(1,2*N-2)).  (WORKSPACE)
            Workspace used in accumulating the transformation for 
            computing the last components of the eigenvectors.
    INFO    Integer.  (OUTPUT)
            = 0:  normal return.
            < 0:  if INFO = -i, the i-th argument had an illegal value.
            > 0:  if INFO = +i, the i-th eigenvalue has not converged
                                after a total of  30*N  iterations.
  \Remarks
    1. None.
  -----------------------------------------------------------------------
  \BeginLib
  \Local variables:
       xxxxxx  real
  \Routines called:
       saxpy   Level 1 BLAS that computes a vector triad.
       scopy   Level 1 BLAS that copies one vector to another.
       sswap   Level 1 BLAS that swaps the contents of two vectors.
       lsame   LAPACK character comparison routine.
       slae2   LAPACK routine that computes the eigenvalues of a 2-by-2 
               symmetric matrix.
       slaev2  LAPACK routine that eigendecomposition of a 2-by-2 symmetric 
               matrix.
       slamch  LAPACK routine that determines machine constants.
       slanst  LAPACK routine that computes the norm of a matrix.
       slapy2  LAPACK routine to compute sqrt(x**2+y**2) carefully.
       slartg  LAPACK Givens rotation construction routine.
       slascl  LAPACK routine for careful scaling of a matrix.
       slaset  LAPACK matrix initialization routine.
       slasr   LAPACK routine that applies an orthogonal transformation to 
               a matrix.
       slasrt  LAPACK sorting routine.
       ssteqr  LAPACK routine that computes eigenvalues and eigenvectors
               of a symmetric tridiagonal matrix.
       xerbla  LAPACK error handler routine.
  \Authors
       Danny Sorensen               Phuong Vu
       Richard Lehoucq              CRPC / Rice University
       Dept. of Computational &     Houston, Texas
       Applied Mathematics
       Rice University           
       Houston, Texas            
  \SCCS Information: @(#) 
   FILE: stqrb.F   SID: 2.5   DATE OF SID: 8/27/96   RELEASE: 2
  \Remarks
       1. Starting with version 2.5, this routine is a modified version
          of LAPACK version 2.0 subroutine SSTEQR. No lines are deleted,
          only commeted out and new lines inserted.
          All lines commented out have "c$$$" at the beginning.
          Note that the LAPACK version 1.0 subroutine SSTEQR contained
          bugs. 
  \EndLib
  -----------------------------------------------------------------------
   * </code></pre>
   *
   * @param n
   * @param d
   * @param _d_offset
   * @param e
   * @param _e_offset
   * @param z
   * @param _z_offset
   * @param work
   * @param _work_offset
   * @param info
   * 
   */
  abstract public void sstqrb(int n, float[] d, int _d_offset, float[] e, int _e_offset, float[] z, int _z_offset, float[] work, int _work_offset, org.netlib.util.intW info);
}