/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1.sql;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore$;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SparkPlanGraph;
import org.apache.spark.sql.execution.ui.SparkPlanGraphCluster;
import org.apache.spark.sql.execution.ui.SparkPlanGraphEdge;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNode;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.status.api.v1.sql.ExecutionData;
import org.apache.spark.status.api.v1.sql.Metric;
import org.apache.spark.status.api.v1.sql.Metric$;
import org.apache.spark.status.api.v1.sql.Node;
import org.apache.spark.status.api.v1.sql.Node$;
import org.apache.spark.ui.SparkUI;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f!\u0002\u0006\f\u00015I\u0002\"\u0002\u0013\u0001\t\u00031\u0003bB\u0015\u0001\u0005\u0004%\tA\u000b\u0005\u0007g\u0001\u0001\u000b\u0011B\u0016\t\u000bQ\u0002A\u0011A\u001b\t\u000b1\u0001A\u0011A<\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003\u001f\u0003A\u0011BAI\u0005-\u0019\u0016\u000f\u001c*fg>,(oY3\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0003mFR!\u0001E\t\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0013'\u000511\u000f^1ukNT!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"E5\tQ\"\u0003\u0002$\u001b\ty!)Y:f\u0003B\u0004(+Z:pkJ\u001cW-\u0001\u0004=S:LGOP\u0002\u0001)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005Y\u0011aE,I\u001f2+ul\u0015+B\u000f\u0016{6i\u0014#F\u000f\u0016sU#A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t11\u000b\u001e:j]\u001e\fAc\u0016%P\u0019\u0016{6\u000bV!H\u000b~\u001bu\nR#H\u000b:\u0003\u0013aB:rY2K7\u000f\u001e\u000b\u0006m\u0015k&\r\u001c\t\u0004o}\u0012eB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYT%\u0001\u0004=e>|GOP\u0005\u0002;%\u0011a\bH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0015IA\u0002TKFT!A\u0010\u000f\u0011\u0005!\u001a\u0015B\u0001#\f\u00055)\u00050Z2vi&|g\u000eR1uC\")a\t\u0002a\u0001\u000f\u00069A-\u001a;bS2\u001c\bCA\u000eI\u0013\tIEDA\u0004C_>dW-\u00198)\t\u0015[UK\u0016\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000b!A]:\u000b\u0005A\u000b\u0016AA<t\u0015\u0005\u0011\u0016!\u00026bm\u0006D\u0018B\u0001+N\u00051!UMZ1vYR4\u0016\r\\;f\u0003\u00151\u0018\r\\;fC\u00059\u0016\u0001\u0002;sk\u0016DC!R-V9B\u0011AJW\u0005\u000376\u0013!\"U;fef\u0004\u0016M]1nC\u00051\u0005\"\u00020\u0005\u0001\u00049\u0015a\u00049mC:$Um]2sSB$\u0018n\u001c8)\tu[UK\u0016\u0015\u0005;f+\u0016-I\u0001_\u0011\u0015\u0019G\u00011\u0001e\u0003\u0019ygMZ:fiB\u00111$Z\u0005\u0003Mr\u00111!\u00138uQ\u0011\u00117*\u00165\"\u0003%\f\u0011\u0001\r\u0015\u0005Ef+6.I\u0001d\u0011\u0015iG\u00011\u0001e\u0003\u0019aWM\\4uQ\"\"AnS+pC\u0005\u0001\u0018A\u0001\u001a1Q\u0011a\u0017,\u0016:\"\u00035D#\u0001\u0002;\u0011\u00051+\u0018B\u0001<N\u0005\r9U\t\u0016\u000b\u0007\u0005b\f9!!\u0004\t\u000be,\u0001\u0019\u0001>\u0002\r\u0015DXmY%e!\tY20\u0003\u0002}9\t!Aj\u001c8hQ\u0015Ah0VA\u0002!\tau0C\u0002\u0002\u00025\u0013\u0011\u0002U1uQB\u000b'/Y7\"\u0005\u0005\u0015\u0011aC3yK\u000e,H/[8o\u0013\u0012DQAR\u0003A\u0002\u001dCS!a\u0002L+ZCS!a\u0002Z+rCQAX\u0003A\u0002\u001dCS!!\u0004L+ZCS!!\u0004Z+\u0006D#!\u0002;)\r\u0015\t9\"VA\u000f!\ra\u0015\u0011D\u0005\u0004\u00037i%\u0001\u0002)bi\"\f#!a\b\u0002#m,\u00070Z2vi&|g.\u00133;9\u0012\\S0\u0001\u000bqe\u0016\u0004\u0018M]3Fq\u0016\u001cW\u000f^5p]\u0012\u000bG/\u0019\u000b\n\u0005\u0006\u0015\u00121HA#\u0003\u000fBq!a\n\u0007\u0001\u0004\tI#\u0001\u0003fq\u0016\u001c\u0007\u0003BA\u0016\u0003oi!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0003k&TA!a\r\u00026\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u0019MIA!!\u000f\u0002.\t\u00112+\u0015'Fq\u0016\u001cW\u000f^5p]VKE)\u0019;b\u0011\u001d\tiD\u0002a\u0001\u0003\u007f\tQa\u001a:ba\"\u0004B!a\u000b\u0002B%!\u00111IA\u0017\u00059\u0019\u0006/\u0019:l!2\fgn\u0012:ba\"DQA\u0012\u0004A\u0002\u001dCQA\u0018\u0004A\u0002\u001d\u000b\u0001\u0003\u001d:j]R\f'\r\\3NKR\u0014\u0018nY:\u0015\r\u00055\u0013QLA5!\u0019\ty%!\u0016\u0002X5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'b\u0012AC2pY2,7\r^5p]&\u0019\u0001)!\u0015\u0011\u0007!\nI&C\u0002\u0002\\-\u0011AAT8eK\"9\u0011qL\u0004A\u0002\u0005\u0005\u0014\u0001C1mY:{G-Z:\u0011\r\u0005=\u0013QKA2!\u0011\tY#!\u001a\n\t\u0005\u001d\u0014Q\u0006\u0002\u0013'B\f'o\u001b)mC:<%/\u00199i\u001d>$W\rC\u0004\u0002l\u001d\u0001\r!!\u001c\u0002\u00195,GO]5d-\u0006dW/Z:\u0011\u000f\u0005=\u0014q\u000f>\u0002~9!\u0011\u0011OA:!\tID$C\u0002\u0002vq\ta\u0001\u0015:fI\u00164\u0017\u0002BA=\u0003w\u00121!T1q\u0015\r\t)\b\b\t\u0005\u0003_\ny(C\u00023\u0003w\nQcZ3u\u001d>$W-\u00133B]\u0012<6kQ$JI6\u000b\u0007\u000f\u0006\u0003\u0002\u0006\u00065\u0005cBA8\u0003oR\u0018q\u0011\t\u00057\u0005%%0C\u0002\u0002\fr\u0011aa\u00149uS>t\u0007bBA0\u0011\u0001\u0007\u0011\u0011M\u0001\u0017O\u0016$x\u000b[8mKN#\u0018mZ3D_\u0012,w-\u001a8JIR!\u0011qQAJ\u0011\u001d\t)*\u0003a\u0001\u0003{\nAb^:dO:{G-\u001a(b[\u0016Dc\u0001AAM+\u0006}\u0005c\u0001'\u0002\u001c&\u0019\u0011QT'\u0003\u0011A\u0013x\u000eZ;dKNd#!!)\"\u0005\u0005\r\u0016\u0001E1qa2L7-\u0019;j_:|#n]8o\u0001")
public class SqlResource
implements BaseAppResource {
    private final String WHOLE_STAGE_CODEGEN;
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$((BaseAppResource)this, fn);
    }

    public void checkUIViewPermissions() {
        BaseAppResource.checkUIViewPermissions$((BaseAppResource)this);
    }

    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$((ApiRequestContext)this);
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    public String WHOLE_STAGE_CODEGEN() {
        return this.WHOLE_STAGE_CODEGEN;
    }

    @GET
    public scala.collection.immutable.Seq<ExecutionData> sqlList(@DefaultValue(value="true") @QueryParam(value="details") boolean details, @DefaultValue(value="true") @QueryParam(value="planDescription") boolean planDescription, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="length") int length) {
        return (scala.collection.immutable.Seq)this.withUI((Function1 & Serializable)ui -> {
            SQLAppStatusStore sqlStore = new SQLAppStatusStore(ui.store().store(), SQLAppStatusStore$.MODULE$.$lessinit$greater$default$2());
            return (scala.collection.immutable.Seq)sqlStore.executionsList(offset, length).map((Function1 & Serializable)exec -> {
                SparkPlanGraph graph = sqlStore.planGraph(exec.executionId());
                return this.prepareExecutionData((SQLExecutionUIData)exec, graph, details, planDescription);
            });
        });
    }

    @GET
    @Path(value="{executionId:\\d+}")
    public ExecutionData sql(@PathParam(value="executionId") long execId, @DefaultValue(value="true") @QueryParam(value="details") boolean details, @DefaultValue(value="true") @QueryParam(value="planDescription") boolean planDescription) {
        return (ExecutionData)this.withUI((Function1 & Serializable)ui -> {
            SQLAppStatusStore sqlStore = new SQLAppStatusStore(ui.store().store(), SQLAppStatusStore$.MODULE$.$lessinit$greater$default$2());
            return (ExecutionData)sqlStore.execution(execId).map((Function1 & Serializable)x$1 -> this.prepareExecutionData((SQLExecutionUIData)x$1, sqlStore.planGraph(execId), details, planDescription)).getOrElse((Function0 & Serializable)() -> {
                throw new NotFoundException("unknown query execution id: " + execId);
            });
        });
    }

    private ExecutionData prepareExecutionData(SQLExecutionUIData exec, SparkPlanGraph graph, boolean details, boolean planDescription) {
        ObjectRef running = ObjectRef.create((Object)((scala.collection.immutable.Seq)Nil$.MODULE$));
        ObjectRef completed = ObjectRef.create((Object)((scala.collection.immutable.Seq)Nil$.MODULE$));
        ObjectRef failed = ObjectRef.create((Object)((scala.collection.immutable.Seq)Nil$.MODULE$));
        exec.jobs().foreach((Function1 & Serializable)x0$1 -> {
            SqlResource.$anonfun$prepareExecutionData$1(running, completed, failed, x0$1);
            return BoxedUnit.UNIT;
        });
        long duration = ((Date)exec.completionTime().getOrElse((Function0 & Serializable)() -> new Date())).getTime() - exec.submissionTime();
        String planDetails = planDescription ? exec.physicalPlanDescription() : "";
        Seq<Node> nodes = details ? this.printableMetrics(graph.allNodes(), (Map<Object, String>)((Map)Option$.MODULE$.apply(exec.metricValues()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))) : (Seq<Node>)package$.MODULE$.Seq().empty();
        Seq edges = details ? graph.edges() : (Seq)package$.MODULE$.Seq().empty();
        return new ExecutionData(exec.executionId(), exec.executionStatus(), exec.description(), planDetails, new Date(exec.submissionTime()), duration, (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)running.elem), (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)completed.elem), (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)failed.elem), nodes, (Seq<SparkPlanGraphEdge>)edges);
    }

    private Seq<Node> printableMetrics(Seq<SparkPlanGraphNode> allNodes, Map<Object, String> metricValues) {
        Map<Object, Option<Object>> nodeIdAndWSCGIdMap = this.getNodeIdAndWSCGIdMap(allNodes);
        Seq nodes = (Seq)allNodes.map((Function1 & Serializable)node -> {
            Option wholeStageCodegenId = nodeIdAndWSCGIdMap.get((Object)BoxesRunTime.boxToLong((long)node.id())).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Seq metrics = (Seq)node.metrics().flatMap((Function1 & Serializable)m -> SqlResource.getMetric$1(metricValues, m.accumulatorId(), m.name().trim()));
            return Node$.MODULE$.apply(node.id(), node.name().trim(), (Option<Object>)wholeStageCodegenId, (Seq<Metric>)metrics);
        });
        return (Seq)((SeqOps)nodes.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.nodeId()), (Ordering)Ordering.Long$.MODULE$)).reverse();
    }

    private Map<Object, Option<Object>> getNodeIdAndWSCGIdMap(Seq<SparkPlanGraphNode> allNodes) {
        Seq wscgNodes = (Seq)allNodes.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlResource.$anonfun$getNodeIdAndWSCGIdMap$1(this, x$3)));
        Map nodeIdAndWSCGIdMap = ((IterableOnceOps)wscgNodes.flatMap((Function1 & Serializable)x$4 -> {
            SparkPlanGraphNode sparkPlanGraphNode = x$4;
            if (sparkPlanGraphNode instanceof SparkPlanGraphCluster) {
                SparkPlanGraphCluster sparkPlanGraphCluster = (SparkPlanGraphCluster)sparkPlanGraphNode;
                return (Seq)sparkPlanGraphCluster.nodes().map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)x$5.id())), this.getWholeStageCodegenId(sparkPlanGraphCluster.name().trim())));
            }
            return (Seq)package$.MODULE$.Seq().empty();
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return nodeIdAndWSCGIdMap;
    }

    private Option<Object> getWholeStageCodegenId(String wscgNodeName) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(wscgNodeName.substring((this.WHOLE_STAGE_CODEGEN() + " (").length(), wscgNodeName.length() - 1))));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            long wscgId = BoxesRunTime.unboxToLong((Object)success.value());
            return new Some((Object)BoxesRunTime.boxToLong((long)wscgId));
        }
        if (try_ instanceof Failure) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$prepareExecutionData$1(ObjectRef running$1, ObjectRef completed$1, ObjectRef failed$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            JobExecutionStatus jobExecutionStatus = (JobExecutionStatus)tuple2._2();
            if (JobExecutionStatus.RUNNING.equals(jobExecutionStatus)) {
                running$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)running$1.elem).$colon$plus((Object)BoxesRunTime.boxToInteger((int)id));
                return;
            }
        }
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            JobExecutionStatus jobExecutionStatus = (JobExecutionStatus)tuple2._2();
            if (JobExecutionStatus.SUCCEEDED.equals(jobExecutionStatus)) {
                completed$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)completed$1.elem).$colon$plus((Object)BoxesRunTime.boxToInteger((int)id));
                return;
            }
        }
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            JobExecutionStatus jobExecutionStatus = (JobExecutionStatus)tuple2._2();
            if (JobExecutionStatus.FAILED.equals(jobExecutionStatus)) {
                failed$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)failed$1.elem).$colon$plus((Object)BoxesRunTime.boxToInteger((int)id));
                return;
            }
        }
    }

    private static final Option getMetric$1(Map metricValues, long accumulatorId, String metricName) {
        return metricValues.get((Object)BoxesRunTime.boxToLong((long)accumulatorId)).map((Function1 & Serializable)mv -> {
            String metricValue = mv.startsWith("\n") ? mv.substring(1, mv.length()) : mv;
            return Metric$.MODULE$.apply(metricName, metricValue);
        });
    }

    public static final /* synthetic */ boolean $anonfun$getNodeIdAndWSCGIdMap$1(SqlResource $this, SparkPlanGraphNode x$3) {
        return x$3.name().trim().startsWith($this.WHOLE_STAGE_CODEGEN());
    }

    public SqlResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
        BaseAppResource.$init$((BaseAppResource)this);
        this.WHOLE_STAGE_CODEGEN = "WholeStageCodegen";
    }
}

