/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.sql.streaming.ui.StreamingQueryDataSource;
import org.apache.spark.sql.streaming.ui.StreamingQueryTab;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.StructuredStreamingRow;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.ui.PagedDataSource;
import org.apache.spark.ui.PagedTable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc!B\u000f\u001f\u0001yQ\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t5\u0002\u0011\t\u0011)A\u00057\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003\\\u0011!A\u0007A!A!\u0002\u0013Y\u0006\"B5\u0001\t\u0003Q\u0007BC:\u0001!\u0003\u0005\u0019\u0011)A\u0005i\"9!\u0010\u0001b\u0001\n\u0013Y\bB\u0002?\u0001A\u0003%1\fC\u0004~\u0001\t\u0007I\u0011\u0002@\t\r}\u0004\u0001\u0015!\u0003e\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B<\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0003\t\u0013\u0005m\u0001A1A\u0005\n\u0005%\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0003\t\r\u0005}\u0001\u0001\"\u0011|\u0011\u0019\t\t\u0003\u0001C!w\"1\u00111\u0005\u0001\u0005BmDa!!\n\u0001\t\u0003Z\bbBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\u0007\u0003_\u0001A\u0011I>\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u00111\b\u0001\u0005B\u0005u\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0002\u0019'R\u0014X-Y7j]\u001e\fV/\u001a:z!\u0006<W\r\u001a+bE2,'BA\u0010!\u0003\t)\u0018N\u0003\u0002\"E\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u00042A\r\u001b7\u001b\u0005\u0019$BA\u0010%\u0013\t)4G\u0001\u0006QC\u001e,G\rV1cY\u0016\u0004\"a\u000e\u001d\u000e\u0003yI!!\u000f\u0010\u0003-M#(/^2ukJ,Gm\u0015;sK\u0006l\u0017N\\4S_^\fqA]3rk\u0016\u001cHo\u0001\u0001\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015\u0001\u00025uiBT!!\u0011\"\u0002\u000fM,'O\u001e7fi*\t1)A\u0003kCZ\f\u00070\u0003\u0002F}\t\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u0003\u0019\u0001\u0018M]3oiB\u0011q\u0007S\u0005\u0003\u0013z\u0011\u0011c\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010V1c\u0003\u0011!\u0017\r^1\u0011\u00071#vK\u0004\u0002N%:\u0011a*U\u0007\u0002\u001f*\u0011\u0001kO\u0001\u0007yI|w\u000e\u001e \n\u00039J!aU\u0017\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\u0004'\u0016\f(BA*.!\t9\u0004,\u0003\u0002Z=\t!2\u000b\u001e:fC6LgnZ)vKJLX+\u0013#bi\u0006\f\u0001\u0002^1cY\u0016$\u0016m\u001a\t\u00039\u0002t!!\u00180\u0011\u00059k\u0013BA0.\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}k\u0013\u0001C5t\u0003\u000e$\u0018N^3\u0011\u00051*\u0017B\u00014.\u0005\u001d\u0011un\u001c7fC:\f\u0001BY1tKB\u000bG\u000f[\u0001\bgV\u0014\u0007+\u0019;i\u0003\u0019a\u0014N\\5u}QA1\u000e\\7o_B\f(\u000f\u0005\u00028\u0001!)!\b\u0003a\u0001y!)a\t\u0003a\u0001\u000f\")!\n\u0003a\u0001\u0017\")!\f\u0003a\u00017\")1\r\u0003a\u0001I\")q\r\u0003a\u00017\")\u0001\u000e\u0003a\u00017\u0006\u0019\u0001\u0010\n\u001b\u0011\u000b1*8\fZ<\n\u0005Yl#A\u0002+va2,7\u0007\u0005\u0002-q&\u0011\u00110\f\u0002\u0004\u0013:$\u0018AC:peR\u001cu\u000e\\;n]V\t1,A\u0006t_J$8i\u001c7v[:\u0004\u0013\u0001C:peR$Um]2\u0016\u0003\u0011\f\u0011b]8si\u0012+7o\u0019\u0011\u0002\u0011A\fw-Z*ju\u0016,\u0012a^\u0001\na\u0006<WmU5{K\u0002\nQ\u0002]1sC6,G/\u001a:QCRDWCAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\tA\u0001\\1oO*\u0011\u0011QC\u0001\u0005U\u00064\u0018-C\u0002b\u0003\u001f\ta\u0002]1sC6,G/\u001a:QCRD\u0007%A\tf]\u000e|G-\u001a3T_J$8i\u001c7v[:\f!#\u001a8d_\u0012,GmU8si\u000e{G.^7oA\u00059A/\u00192mK&#\u0017!\u0004;bE2,7i]:DY\u0006\u001c8/A\tqC\u001e,7+\u001b>f\r>\u0014XNR5fY\u0012\f1\u0003]1hK:+XNY3s\r>\u0014XNR5fY\u0012\f\u0001\u0002]1hK2Kgn\u001b\u000b\u00047\u0006-\u0002BBA\u00171\u0001\u0007q/\u0001\u0003qC\u001e,\u0017\u0001E4p\u0005V$Ho\u001c8G_Jl\u0007+\u0019;i\u0003)!\u0017\r^1T_V\u00148-Z\u000b\u0003\u0003k\u0001BAMA\u001cm%\u0019\u0011\u0011H\u001a\u0003\u001fA\u000bw-\u001a3ECR\f7k\\;sG\u0016\fq\u0001[3bI\u0016\u00148/\u0006\u0002\u0002@A!A\nVA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$[\u0005\u0019\u00010\u001c7\n\t\u0005-\u0013Q\t\u0002\u0005\u001d>$W-A\u0002s_^$B!a\u0010\u0002R!1\u00111\u000b\u000fA\u0002Y\nQ!];fef\u0004")
public class StreamingQueryPagedTable
implements PagedTable<StructuredStreamingRow> {
    private final HttpServletRequest request;
    private final StreamingQueryTab parent;
    private final scala.collection.immutable.Seq<StreamingQueryUIData> data;
    private final String tableTag;
    private final boolean isActive;
    private final /* synthetic */ Tuple3 x$4;
    private final String sortColumn;
    private final boolean sortDesc;
    private final int pageSize;
    private final String parameterPath;
    private final String encodedSortColumn;

    public scala.collection.immutable.Seq<Node> table(int page) {
        return PagedTable.table$((PagedTable)this, (int)page);
    }

    public scala.collection.immutable.Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$((PagedTable)this, (int)page, (int)pageSize, (int)totalPages, (String)navigationId);
    }

    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$((PagedTable)this);
    }

    public String getParameterOtherTable(HttpServletRequest request, String tableTag) {
        return PagedTable.getParameterOtherTable$((PagedTable)this, (HttpServletRequest)request, (String)tableTag);
    }

    public Tuple3<String, Object, Object> getTableParameters(HttpServletRequest request, String tableTag, String defaultSortColumn) {
        return PagedTable.getTableParameters$((PagedTable)this, (HttpServletRequest)request, (String)tableTag, (String)defaultSortColumn);
    }

    public void isSortColumnValid(scala.collection.immutable.Seq<Tuple3<String, Object, Option<String>>> headerInfo, String sortColumn) {
        PagedTable.isSortColumnValid$((PagedTable)this, headerInfo, (String)sortColumn);
    }

    public scala.collection.immutable.Seq<Node> headerRow(scala.collection.immutable.Seq<Tuple3<String, Object, Option<String>>> headerInfo, boolean desc, int pageSize, String sortColumn, String parameterPath, String tableTag, String headerId) {
        return PagedTable.headerRow$((PagedTable)this, headerInfo, (boolean)desc, (int)pageSize, (String)sortColumn, (String)parameterPath, (String)tableTag, (String)headerId);
    }

    private String sortColumn() {
        return this.sortColumn;
    }

    private boolean sortDesc() {
        return this.sortDesc;
    }

    private int pageSize() {
        return this.pageSize;
    }

    private String parameterPath() {
        return this.parameterPath;
    }

    private String encodedSortColumn() {
        return this.encodedSortColumn;
    }

    public String tableId() {
        return this.tableTag + "-table";
    }

    public String tableCssClass() {
        return "table table-bordered table-sm table-striped table-head-clickable table-cell-width-limited";
    }

    public String pageSizeFormField() {
        return this.tableTag + ".pageSize";
    }

    public String pageNumberFormField() {
        return this.tableTag + ".page";
    }

    public String pageLink(int page) {
        return this.parameterPath() + "&" + this.pageNumberFormField() + "=" + page + "&" + this.tableTag + ".sort=" + this.encodedSortColumn() + "&" + this.tableTag + ".desc=" + this.sortDesc() + "&" + this.pageSizeFormField() + "=" + this.pageSize() + "#" + this.tableTag;
    }

    public String goButtonFormPath() {
        return this.parameterPath() + "&" + this.tableTag + ".sort=" + this.encodedSortColumn() + "&" + this.tableTag + ".desc=" + this.sortDesc() + "#" + this.tableTag;
    }

    public PagedDataSource<StructuredStreamingRow> dataSource() {
        return new StreamingQueryDataSource(this.data, this.sortColumn(), this.sortDesc(), this.pageSize(), this.isActive);
    }

    public scala.collection.immutable.Seq<Node> headers() {
        scala.collection.immutable.Seq headerAndCss = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Name", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Status", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"ID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Run ID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Start Time", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Duration", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Avg Input /sec", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Avg Process /sec", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Latest Batch", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$)})).$plus$plus((IterableOnce)(!this.isActive ? new .colon.colon((Object)new Tuple3((Object)"Error", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$), (List)Nil$.MODULE$) : Nil$.MODULE$));
        this.isSortColumnValid((scala.collection.immutable.Seq<Tuple3<String, Object, Option<String>>>)headerAndCss, this.sortColumn());
        return this.headerRow((scala.collection.immutable.Seq<Tuple3<String, Object, Option<String>>>)headerAndCss, this.sortDesc(), this.pageSize(), this.sortColumn(), this.parameterPath(), this.tableTag, this.tableTag);
    }

    public scala.collection.immutable.Seq<Node> row(StructuredStreamingRow query) {
        StreamingQueryUIData streamingQuery = query.streamingUIData();
        String statisticsLink = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s/%s/statistics?id=%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(this.request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), this.parent.prefix(), streamingQuery.summary().runId()}));
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.getQueryName(streamingQuery));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)UIUtils$.MODULE$.getQueryStatus(streamingQuery));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)streamingQuery.summary().id());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", statisticsLink, (MetaData)$md);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)streamingQuery.summary().runId());
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(streamingQuery.summary().startTimestamp()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(query.duration()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)query.avgInput())})), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)query.avgProcess())})), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (JFunction0.mcJ.sp & Serializable)() -> streamingQuery.lastProgress().batchId(), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.details$1(streamingQuery));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private final scala.collection.immutable.Seq details$1(StreamingQueryUIData streamingQuery$1) {
        if (this.isActive) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        return org.apache.spark.ui.UIUtils$.MODULE$.errorMessageCell((String)streamingQuery$1.summary().exception().getOrElse((Function0 & Serializable)() -> "-"));
    }

    public StreamingQueryPagedTable(HttpServletRequest request, StreamingQueryTab parent, scala.collection.immutable.Seq<StreamingQueryUIData> data, String tableTag, boolean isActive, String basePath, String subPath) {
        this.request = request;
        this.parent = parent;
        this.data = data;
        this.tableTag = tableTag;
        this.isActive = isActive;
        PagedTable.$init$((PagedTable)this);
        Tuple3<String, Object, Object> tuple3 = this.getTableParameters(request, tableTag, "Start Time");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String sortColumn = (String)tuple3._1();
        boolean sortDesc = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        int pageSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
        this.x$4 = new Tuple3((Object)sortColumn, (Object)BoxesRunTime.boxToBoolean((boolean)sortDesc), (Object)BoxesRunTime.boxToInteger((int)pageSize));
        this.sortColumn = (String)this.x$4._1();
        this.sortDesc = BoxesRunTime.unboxToBoolean((Object)this.x$4._2());
        this.pageSize = BoxesRunTime.unboxToInt((Object)this.x$4._3());
        this.parameterPath = basePath + "/" + subPath + "/?" + this.getParameterOtherTable(request, tableTag);
        this.encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
    }
}

