/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class PostgresDialect$
extends JdbcDialect
implements SQLConfHelper {
    public static final PostgresDialect$ MODULE$ = new PostgresDialect$();
    private static final Set<String> supportedAggregateFunctions;
    private static final Set<String> supportedFunctions;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        supportedFunctions = MODULE$.supportedAggregateFunctions();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    private Set<String> supportedAggregateFunctions() {
        return supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        if (sqlType == 7) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (sqlType == 5) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (sqlType == -7) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                return new Some((Object)BinaryType$.MODULE$);
            }
        }
        if (sqlType == 8) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return new Some((Object)StringType$.MODULE$);
            }
        }
        if (sqlType == 1111) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("text".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (sqlType == 2003) {
            int scale = (int)md.build().getLong("scale");
            return this.toCatalystType(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(typeName), 1), size, scale).map((Function1 & Serializable)x$1 -> ArrayType$.MODULE$.apply(x$1));
        }
        return None$.MODULE$;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, int scale) {
        block58: {
            block60: {
                block62: {
                    block59: {
                        block61: {
                            String string = typeName;
                            switch (string == null ? 0 : string.hashCode()) {
                                case -2080719092: {
                                    if (!"pg_snapshot".equals(string)) break block58;
                                    break block59;
                                }
                                case -2000413939: {
                                    if (!"numeric".equals(string)) break block58;
                                    break block60;
                                }
                                case -1534143358: {
                                    if (!"tsvector".equals(string)) break block58;
                                    break block59;
                                }
                                case -1382823772: {
                                    if (!"bpchar".equals(string)) break block58;
                                    break block61;
                                }
                                case -1360216880: {
                                    if (!"circle".equals(string)) break block58;
                                    break block59;
                                }
                                case -1271649960: {
                                    if ("float4".equals(string)) {
                                        return new Some((Object)FloatType$.MODULE$);
                                    }
                                    break block58;
                                }
                                case -1271649956: {
                                    if ("float8".equals(string)) {
                                        return new Some((Object)DoubleType$.MODULE$);
                                    }
                                    break block58;
                                }
                                case -1023458903: {
                                    if (!"tsquery".equals(string)) break block58;
                                    break block59;
                                }
                                case -990442113: {
                                    if (!"pg_lsn".equals(string)) break block58;
                                    break block59;
                                }
                                case -873668077: {
                                    if (!"timetz".equals(string)) break block58;
                                    break block62;
                                }
                                case -823652218: {
                                    if (!"varbit".equals(string)) break block58;
                                    break block59;
                                }
                                case -397519558: {
                                    if (!"polygon".equals(string)) break block58;
                                    break block59;
                                }
                                case -191744392: {
                                    if (!"macaddr8".equals(string)) break block58;
                                    break block59;
                                }
                                case 97549: {
                                    if ("bit".equals(string)) {
                                        return new Some((Object)BinaryType$.MODULE$);
                                    }
                                    break block58;
                                }
                                case 97739: {
                                    if (!"box".equals(string)) break block58;
                                    break block59;
                                }
                                case 110026: {
                                    if ("oid".equals(string)) {
                                        break;
                                    }
                                    break block58;
                                }
                                case 118807: {
                                    if (!"xml".equals(string)) break block58;
                                    break block59;
                                }
                                case 3029738: {
                                    if ("bool".equals(string)) {
                                        return new Some((Object)BooleanType$.MODULE$);
                                    }
                                    break block58;
                                }
                                case 3052374: {
                                    if (!"char".equals(string)) break block58;
                                    break block61;
                                }
                                case 3053428: {
                                    if (!"cidr".equals(string)) break block58;
                                    break block59;
                                }
                                case 3076014: {
                                    if ("date".equals(string)) {
                                        return new Some((Object)DateType$.MODULE$);
                                    }
                                    break block58;
                                }
                                case 3237012: {
                                    if (!"inet".equals(string)) break block58;
                                    break block59;
                                }
                                case 3237411: {
                                    if ("int2".equals(string)) {
                                        return new Some((Object)ShortType$.MODULE$);
                                    }
                                    break block58;
                                }
                                case 3237413: {
                                    if ("int4".equals(string)) {
                                        return new Some((Object)IntegerType$.MODULE$);
                                    }
                                    break block58;
                                }
                                case 3237417: {
                                    if ("int8".equals(string)) {
                                        break;
                                    }
                                    break block58;
                                }
                                case 3271912: {
                                    if (!"json".equals(string)) break block58;
                                    break block59;
                                }
                                case 3321844: {
                                    if (!"line".equals(string)) break block58;
                                    break block59;
                                }
                                case 3331177: {
                                    if (!"lseg".equals(string)) break block58;
                                    break block59;
                                }
                                case 3433509: {
                                    if (!"path".equals(string)) break block58;
                                    break block59;
                                }
                                case 3556653: {
                                    if (!"text".equals(string)) break block58;
                                    break block59;
                                }
                                case 3560141: {
                                    if (!"time".equals(string)) break block58;
                                    break block62;
                                }
                                case 3601339: {
                                    if (!"uuid".equals(string)) break block58;
                                    break block59;
                                }
                                case 55126294: {
                                    if (!"timestamp".equals(string)) break block58;
                                    break block62;
                                }
                                case 94224473: {
                                    if ("bytea".equals(string)) {
                                        return new Some((Object)BinaryType$.MODULE$);
                                    }
                                    break block58;
                                }
                                case 101429370: {
                                    if (!"jsonb".equals(string)) break block58;
                                    break block59;
                                }
                                case 104079552: {
                                    if ("money".equals(string)) {
                                        return None$.MODULE$;
                                    }
                                    break block58;
                                }
                                case 106845584: {
                                    if (!"point".equals(string)) break block58;
                                    break block59;
                                }
                                case 236613373: {
                                    if ("varchar".equals(string)) {
                                        return new Some((Object)new VarcharType(precision));
                                    }
                                    break block58;
                                }
                                case 570418373: {
                                    if (!"interval".equals(string)) break block58;
                                    break block59;
                                }
                                case 825098688: {
                                    if (!"macaddr".equals(string)) break block58;
                                    break block59;
                                }
                                case 1132592996: {
                                    if (!"txid_snapshot".equals(string)) break block58;
                                    break block59;
                                }
                                case 1436764700: {
                                    if (!"timestamptz".equals(string)) break block58;
                                    break block62;
                                }
                                case 1542263633: {
                                    if (!"decimal".equals(string)) break block58;
                                    break block60;
                                }
                                default: {
                                    break block58;
                                }
                            }
                            return new Some((Object)LongType$.MODULE$);
                        }
                        return new Some((Object)new CharType(precision));
                    }
                    return new Some((Object)StringType$.MODULE$);
                }
                return new Some((Object)TimestampType$.MODULE$);
            }
            if (precision > 0) {
                return new Some((Object)DecimalType$.MODULE$.bounded(precision, scale));
            }
            return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        }
        return new Some((Object)StringType$.MODULE$);
    }

    @Override
    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return t.toLocalDateTime();
    }

    @Override
    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        return Timestamp.valueOf(ldt);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        ArrayType arrayType;
        DataType et;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("TEXT", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BYTEA", -2));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT4", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT8", 8));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        if (dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType) {
            return this.getJDBCType(et).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable)typeName -> new JdbcType(typeName + "[]", 2003));
        }
        return None$.MODULE$;
    }

    @Override
    public String getTableExistsQuery(String table) {
        return "SELECT 1 FROM " + table + " LIMIT 1";
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE ONLY " + table + " CASCADE";
        }
        return "TRUNCATE TABLE ONLY " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable)() -> "0"))) > 0) {
            connection.setAutoCommit(false);
            return;
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String indexType;
        Object indexProperties;
        String[] columnList;
        block1: {
            columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> MODULE$.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
            indexProperties = "";
            Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "postgresql");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String indexType2 = (String)tuple2._1();
            String[] indexPropertyList = (String[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType2, (Object)indexPropertyList);
            indexType = (String)tuple22._1();
            String[] indexPropertyList2 = (String[])tuple22._2();
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2))) break block1;
            indexProperties = "WITH (" + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(", ") + ")";
        }
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " ON " + this.quoteIdentifier(tableIdent.name()) + " " + indexType + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + (String)indexProperties;
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM pg_indexes WHERE tablename = '" + tableIdent.name() + "' AND indexname = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName);
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 48220673: {
                    if (!"2BP01".equals(string)) break;
                    throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
                }
                case 49567037: {
                    if (!"42704".equals(string)) break;
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed to drop index (.*) in (.*)"));
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 49591065: {
                    Option option;
                    Option option2;
                    if (!"42P07".equals(string)) break;
                    Regex indexRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed to create index (.*) in (.*)"));
                    Regex renameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed table renaming from (.*) to (.*)"));
                    Regex pgRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:.*)relation \"(.*)\" already exists"));
                    String string2 = message;
                    if (string2 != null && !(option2 = indexRegex.unapplySeq((CharSequence)string2)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
                        String index = (String)((LinearSeqOps)option2.get()).apply(0);
                        String table = (String)((LinearSeqOps)option2.get()).apply(1);
                        throw new IndexAlreadyExistsException(index, table, (Option)new Some((Object)e));
                    }
                    if (string2 != null && !(option = renameRegex.unapplySeq((CharSequence)string2)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                        String newTable = (String)((LinearSeqOps)option.get()).apply(1);
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                    }
                    if (pgRegex.findFirstMatchIn((CharSequence)sQLException.getMessage()).nonEmpty()) {
                        String tableName = ((Regex.MatchData)pgRegex.findFirstMatchIn((CharSequence)sQLException.getMessage()).get()).group(1);
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(tableName);
                    }
                    return super.classifyException(message, e);
                }
            }
            return super.classifyException(message, e);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return super.classifyException(message, e);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE BERNOULLI (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        if (!Predef$.MODULE$.wrapRefArray((Object[])oldTable.namespace()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newTable.namespace()))) {
            throw QueryCompilationErrors$.MODULE$.cannotRenameTableAcrossSchemaError();
        }
        return "ALTER TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " RENAME TO " + newTable.name();
    }

    @Override
    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        long POSTGRESQL_DATE_NEGATIVE_INFINITY = -9223372036832400000L;
        long POSTGRESQL_DATE_NEGATIVE_SMALLER_INFINITY = -185543533774800000L;
        long POSTGRESQL_DATE_POSITIVE_INFINITY = 9223372036825200000L;
        long POSTGRESQL_DATE_DATE_POSITIVE_SMALLER_INFINITY = 185543533774800000L;
        long minTimeStamp = LocalDateTime.of(1, 1, 1, 0, 0, 0).toEpochSecond(ZoneOffset.UTC);
        long maxTimestamp = LocalDateTime.of(9999, 12, 31, 23, 59, 59).toEpochSecond(ZoneOffset.UTC);
        long time = t.getTime();
        if (time == POSTGRESQL_DATE_POSITIVE_INFINITY || time == POSTGRESQL_DATE_DATE_POSITIVE_SMALLER_INFINITY) {
            return new Timestamp(maxTimestamp);
        }
        if (time == POSTGRESQL_DATE_NEGATIVE_INFINITY || time == POSTGRESQL_DATE_NEGATIVE_SMALLER_INFINITY) {
            return new Timestamp(minTimeStamp);
        }
        return t;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PostgresDialect$.class);
    }

    private PostgresDialect$() {
    }
}

