/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType;
import org.apache.spark.sql.catalyst.types.PhysicalByteType;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType;
import org.apache.spark.sql.catalyst.types.PhysicalLongType;
import org.apache.spark.sql.catalyst.types.PhysicalShortType;
import org.apache.spark.sql.catalyst.types.PhysicalStringType;
import org.apache.spark.sql.catalyst.types.PhysicalVariantType;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;

public class ColumnVectorUtils {
    public static void populate(ConstantColumnVector col, InternalRow row, int fieldIdx) {
        DataType t = col.dataType();
        PhysicalDataType pdt = PhysicalDataType.apply((DataType)t);
        if (row.isNullAt(fieldIdx)) {
            col.setNull();
        } else if (pdt instanceof PhysicalBooleanType) {
            col.setBoolean(row.getBoolean(fieldIdx));
        } else if (pdt instanceof PhysicalBinaryType) {
            col.setBinary(row.getBinary(fieldIdx));
        } else if (pdt instanceof PhysicalByteType) {
            col.setByte(row.getByte(fieldIdx));
        } else if (pdt instanceof PhysicalShortType) {
            col.setShort(row.getShort(fieldIdx));
        } else if (pdt instanceof PhysicalIntegerType) {
            col.setInt(row.getInt(fieldIdx));
        } else if (pdt instanceof PhysicalLongType) {
            col.setLong(row.getLong(fieldIdx));
        } else if (pdt instanceof PhysicalFloatType) {
            col.setFloat(row.getFloat(fieldIdx));
        } else if (pdt instanceof PhysicalDoubleType) {
            col.setDouble(row.getDouble(fieldIdx));
        } else if (pdt instanceof PhysicalStringType) {
            UTF8String v = row.getUTF8String(fieldIdx);
            col.setUtf8String(v);
        } else if (pdt instanceof PhysicalDecimalType) {
            PhysicalDecimalType dt = (PhysicalDecimalType)pdt;
            Decimal d = row.getDecimal(fieldIdx, dt.precision(), dt.scale());
            if (dt.precision() <= Decimal.MAX_INT_DIGITS()) {
                col.setInt((int)d.toUnscaledLong());
            } else if (dt.precision() <= Decimal.MAX_LONG_DIGITS()) {
                col.setLong(d.toUnscaledLong());
            } else {
                BigInteger integer = d.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                col.setBinary(bytes);
            }
        } else if (pdt instanceof PhysicalCalendarIntervalType) {
            col.setCalendarInterval((CalendarInterval)row.get(fieldIdx, t));
        } else if (pdt instanceof PhysicalVariantType) {
            col.setVariant((VariantVal)row.get(fieldIdx, t));
        } else {
            throw new RuntimeException(String.format("DataType %s is not supported in column vectorized reader.", t.sql()));
        }
    }

    public static int[] toJavaIntArray(ColumnarArray array) {
        for (int i = 0; i < array.numElements(); ++i) {
            if (!array.isNullAt(i)) continue;
            throw new RuntimeException("Cannot handle NULL values.");
        }
        return array.toIntArray();
    }

    public static Map<Integer, Integer> toJavaIntMap(ColumnarMap map) {
        int[] keys = ColumnVectorUtils.toJavaIntArray(map.keyArray());
        int[] values = ColumnVectorUtils.toJavaIntArray(map.valueArray());
        assert (keys.length == values.length);
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (int i = 0; i < keys.length; ++i) {
            result.put(keys[i], values[i]);
        }
        return result;
    }

    private static void appendValue(WritableColumnVector dst, DataType t, Object o) {
        if (o == null) {
            if (t instanceof CalendarIntervalType || t instanceof VariantType) {
                dst.appendStruct(true);
            } else {
                dst.appendNull();
            }
        } else if (t == DataTypes.BooleanType) {
            dst.appendBoolean((Boolean)o);
        } else if (t == DataTypes.ByteType) {
            dst.appendByte((Byte)o);
        } else if (t == DataTypes.ShortType) {
            dst.appendShort((Short)o);
        } else if (t == DataTypes.IntegerType) {
            dst.appendInt((Integer)o);
        } else if (t == DataTypes.LongType) {
            dst.appendLong((Long)o);
        } else if (t == DataTypes.FloatType) {
            dst.appendFloat(((Float)o).floatValue());
        } else if (t == DataTypes.DoubleType) {
            dst.appendDouble((Double)o);
        } else if (t == DataTypes.StringType) {
            byte[] b = ((String)o).getBytes(StandardCharsets.UTF_8);
            dst.appendByteArray(b, 0, b.length);
        } else if (t == DataTypes.BinaryType) {
            byte[] b = (byte[])o;
            dst.appendByteArray(b, 0, b.length);
        } else if (t instanceof DecimalType) {
            DecimalType dt = (DecimalType)t;
            Decimal d = Decimal.apply((BigDecimal)((BigDecimal)o), (int)dt.precision(), (int)dt.scale());
            if (dt.precision() <= Decimal.MAX_INT_DIGITS()) {
                dst.appendInt((int)d.toUnscaledLong());
            } else if (dt.precision() <= Decimal.MAX_LONG_DIGITS()) {
                dst.appendLong(d.toUnscaledLong());
            } else {
                BigInteger integer = d.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                dst.appendByteArray(bytes, 0, bytes.length);
            }
        } else if (t instanceof CalendarIntervalType) {
            CalendarInterval c = (CalendarInterval)o;
            dst.appendStruct(false);
            dst.getChild(0).appendInt(c.months);
            dst.getChild(1).appendInt(c.days);
            dst.getChild(2).appendLong(c.microseconds);
        } else if (t instanceof VariantType) {
            VariantVal v = (VariantVal)o;
            dst.appendStruct(false);
            dst.getChild(0).appendByteArray(v.getValue(), 0, v.getValue().length);
            dst.getChild(1).appendByteArray(v.getMetadata(), 0, v.getMetadata().length);
        } else if (t instanceof DateType) {
            dst.appendInt(DateTimeUtils.fromJavaDate((Date)((Date)o)));
        } else if (t instanceof TimestampType) {
            dst.appendLong(DateTimeUtils.fromJavaTimestamp((Timestamp)((Timestamp)o)));
        } else if (t instanceof TimestampNTZType) {
            dst.appendLong(DateTimeUtils.localDateTimeToMicros((LocalDateTime)((LocalDateTime)o)));
        } else {
            throw new UnsupportedOperationException("Type " + t);
        }
    }

    private static void appendValue(WritableColumnVector dst, DataType t, Row src, int fieldIdx) {
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            if (src.isNullAt(fieldIdx)) {
                dst.appendNull();
            } else {
                List values = src.getList(fieldIdx);
                dst.appendArray(values.size());
                for (Object o : values) {
                    ColumnVectorUtils.appendValue(dst.arrayData(), at.elementType(), o);
                }
            }
        } else if (t instanceof StructType) {
            StructType st = (StructType)t;
            if (src.isNullAt(fieldIdx)) {
                dst.appendStruct(true);
            } else {
                dst.appendStruct(false);
                Row c = src.getStruct(fieldIdx);
                for (int i = 0; i < st.fields().length; ++i) {
                    ColumnVectorUtils.appendValue(dst.getChild(i), st.fields()[i].dataType(), c, i);
                }
            }
        } else {
            ColumnVectorUtils.appendValue(dst, t, src.get(fieldIdx));
        }
    }

    public static ColumnarBatch toBatch(StructType schema, MemoryMode memMode, Iterator<Row> row) {
        int capacity = 4096;
        WritableColumnVector[] columnVectors = memMode == MemoryMode.OFF_HEAP ? OffHeapColumnVector.allocateColumns(capacity, schema) : OnHeapColumnVector.allocateColumns(capacity, schema);
        int n = 0;
        while (row.hasNext()) {
            Row r = row.next();
            for (int i = 0; i < schema.fields().length; ++i) {
                ColumnVectorUtils.appendValue(columnVectors[i], schema.fields()[i].dataType(), r, i);
            }
            ++n;
        }
        ColumnarBatch batch = new ColumnarBatch((ColumnVector[])columnVectors);
        batch.setNumRows(n);
        return batch;
    }
}

