/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.ui;

import java.io.Serializable;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.execution.ui.SQLPlanMetric;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005E3Aa\u0003\u0007\u00013!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003#\u0011!1\u0003A!b\u0001\n\u00039\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011Q\u0002!Q1A\u0005\u0002\u001dB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tm\u0001\u0011)\u0019!C\u0001o!A!\t\u0001B\u0001B\u0003%\u0001\bC\u0003D\u0001\u0011\u0005A\tC\u0003K\u0001\u0011\u00051J\u0001\nTa\u0006\u00148\u000e\u00157b]\u001e\u0013\u0018\r\u001d5O_\u0012,'BA\u0007\u000f\u0003\t)\u0018N\u0003\u0002\u0010!\u0005IQ\r_3dkRLwN\u001c\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0017AA5e+\u0005\u0011\u0003CA\u000e$\u0013\t!CD\u0001\u0003M_:<\u0017aA5eA\u0005!a.Y7f+\u0005A\u0003CA\u00151\u001d\tQc\u0006\u0005\u0002,95\tAF\u0003\u0002.1\u00051AH]8pizJ!a\f\u000f\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_q\tQA\\1nK\u0002\nA\u0001Z3tG\u0006)A-Z:dA\u00059Q.\u001a;sS\u000e\u001cX#\u0001\u001d\u0011\u0007ebd(D\u0001;\u0015\tYD$\u0001\u0006d_2dWm\u0019;j_:L!!\u0010\u001e\u0003\u0007M+\u0017\u000f\u0005\u0002@\u00016\tA\"\u0003\u0002B\u0019\ti1+\u0015'QY\u0006tW*\u001a;sS\u000e\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u00153u\tS%\u0011\u0005}\u0002\u0001\"\u0002\u0011\n\u0001\u0004\u0011\u0003\"\u0002\u0014\n\u0001\u0004A\u0003\"\u0002\u001b\n\u0001\u0004A\u0003\"\u0002\u001c\n\u0001\u0004A\u0014aC7bW\u0016$u\u000e\u001e(pI\u0016$\"\u0001\u000b'\t\u000b5S\u0001\u0019\u0001(\u0002\u00195,GO]5dgZ\u000bG.^3\u0011\t%z%\u0005K\u0005\u0003!J\u00121!T1q\u0001")
public class SparkPlanGraphNode {
    private final long id;
    private final String name;
    private final String desc;
    private final Seq<SQLPlanMetric> metrics;

    public long id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String desc() {
        return this.desc;
    }

    public Seq<SQLPlanMetric> metrics() {
        return this.metrics;
    }

    public String makeDotNode(Map<Object, String> metricsValue) {
        Object object;
        StringBuilder builder = new StringBuilder("<b>" + this.name() + "</b>");
        Seq values = (Seq)this.metrics().flatMap((Function1 & Serializable)metric -> metricsValue.get((Object)BoxesRunTime.boxToLong((long)metric.accumulatorId())).map((Function1 & Serializable)value -> {
            if (value.contains(":")) {
                return metric.name() + " " + value;
            }
            return metric.name() + ": " + value;
        }));
        String nodeId = "node" + this.id();
        String tooltip = StringEscapeUtils.escapeJava((String)this.desc());
        if (values.nonEmpty()) {
            builder.$plus$plus$eq("<br><br>");
            builder.$plus$plus$eq(values.mkString("<br>"));
            object = StringEscapeUtils.escapeJava((String)builder.toString().replaceAll("\n", "<br>"));
        } else {
            object = "<br><b>" + this.name() + "</b><br><br>";
        }
        String labelStr = object;
        return "  " + this.id() + " [id=\"" + nodeId + "\" labelType=\"html\" label=\"" + labelStr + "\" tooltip=\"" + tooltip + "\"];";
    }

    public SparkPlanGraphNode(long id, String name, String desc, Seq<SQLPlanMetric> metrics) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.metrics = metrics;
    }
}

