/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriter;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t\u0005h\u0001\u0002\u001d:\u0001!C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003W\u0011!!\bA!A!\u0002\u00131\u0006\"B;\u0001\t\u00031\bb\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u0002!Q\u0011\u0011\u0007\u0001\t\u0006\u0004%I!a\r\t\u0013\u0005u\u0002A1A\u0005\n\u0005}\u0002\u0002CA&\u0001\u0001\u0006I!!\u0011\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0003\u0002CA,\u0001\u0001\u0006I!!\u0015\t\u0013\u0005-\u0004A1A\u0005\n\u00055\u0004\u0002CA:\u0001\u0001\u0006I!a\u001c\t\u0015\u0005U\u0004\u0001#b\u0001\n\u0013\t9\bC\u0004\u0002\u0002\u0002!I!a!\t\u0013\u0005=\u0005\u00011A\u0005\n\u0005E\u0005\"CAM\u0001\u0001\u0007I\u0011BAN\u0011!\t9\u000b\u0001Q!\n\u0005M\u0005bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011%\tY\r\u0001a\u0001\n\u0013\ti\rC\u0005\u0002V\u0002\u0001\r\u0011\"\u0003\u0002X\"A\u00111\u001c\u0001!B\u0013\ty\rC\u0005\u0002`\u0002\u0001\r\u0011\"\u0003\u0002N\"I\u0011\u0011\u001d\u0001A\u0002\u0013%\u00111\u001d\u0005\t\u0003O\u0004\u0001\u0015)\u0003\u0002P\"9\u00111\u001e\u0001\u0005\u0002\u00055\u0007bBAw\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003_\u0004A\u0011AAy\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u007fDqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!Q\u0006\u0001\u0005\n\t=\u0002b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/BqAa\u0018\u0001\t\u0013\u0011\t\u0007C\u0004\u0003f\u0001!IAa\u001a\t\u000f\t]\u0004\u0001\"\u0003\u0003z!9!1\u0011\u0001\u0005\n\t\u0015\u0005b\u0002BF\u0001\u0011%!Q\u0012\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011\u001d\u00119\n\u0001C\u0005\u00053CqAa(\u0001\t#\u0012\t\u000bC\u0004\u0003$\u0002!IA!*\t\u000f\t-\u0006\u0001\"\u0003\u0003.\"9!1\u0017\u0001\u0005\n\tUv!\u0003B`s\u0005\u0005\t\u0012\u0001Ba\r!A\u0014(!A\t\u0002\t\r\u0007BB;5\t\u0003\u0011)\rC\u0005\u0003HR\n\n\u0011\"\u0001\u0003J\"I!q\u001c\u001b\u0012\u0002\u0013\u0005!\u0011\u001a\u0002\u0013%>\u001c7n\u001d#C\r&dW-T1oC\u001e,'O\u0003\u0002;w\u0005)1\u000f^1uK*\u0011A(P\u0001\ngR\u0014X-Y7j]\u001eT!AP \u0002\u0013\u0015DXmY;uS>t'B\u0001!B\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0005\u000e\u000bQa\u001d9be.T!\u0001R#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0015aA8sO\u000e\u00011c\u0001\u0001J\u001fB\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\u0004\"\u0001U*\u000e\u0003ES!AU!\u0002\u0011%tG/\u001a:oC2L!\u0001V)\u0003\u000f1{wmZ5oO\u0006QAMZ:S_>$H)\u001b:\u0011\u0005]sfB\u0001-]!\tI6*D\u0001[\u0015\tYv)\u0001\u0004=e>|GOP\u0005\u0003;.\u000ba\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011QlS\u0001\rY>\u001c\u0017\r\u001c+f[B$\u0015N\u001d\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f!![8\u000b\u0003\u001d\fAA[1wC&\u0011\u0011\u000e\u001a\u0002\u0005\r&dW-\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\t\r|gN\u001a\u0006\u0003a\u000e\u000ba\u0001[1e_>\u0004\u0018B\u0001:n\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006I1m\u001c3fG:\u000bW.Z\u0001\nY><w-\u001b8h\u0013\u0012\fa\u0001P5oSRtDCB<zundX\u0010\u0005\u0002y\u00015\t\u0011\bC\u0003V\r\u0001\u0007a\u000bC\u0003b\r\u0001\u0007!\rC\u0003k\r\u0001\u00071\u000eC\u0004t\rA\u0005\t\u0019\u0001,\t\u000fQ4\u0001\u0013!a\u0001-\u0006)b/\u001a:tS>tGk\u001c*pG.\u001cHI\u0011$jY\u0016\u001cXCAA\u0001!!\t\u0019!!\u0004\u0002\u0012\u0005]QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\f\u0019\fA!\u001e;jY&!\u0011qBA\u0003\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004\u0015\u0006M\u0011bAA\u000b\u0017\n!Aj\u001c8h!\u0019\tI\"a\t\u0002*9!\u00111DA\u0010\u001d\rI\u0016QD\u0005\u0002\u0019&\u0019\u0011\u0011E&\u0002\u000fA\f7m[1hK&!\u0011QEA\u0014\u0005\r\u0019V-\u001d\u0006\u0004\u0003CY\u0005c\u0001=\u0002,%\u0019\u0011QF\u001d\u0003)I{7m[:E\u0005&kW.\u001e;bE2,g)\u001b7f\u0003Y1XM]:j_:$vNU8dWN$%IR5mKN\u0004\u0013A\u00014n+\t\t)\u0004\u0005\u0003\u00028\u0005eR\"A\u001e\n\u0007\u0005m2HA\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0002\u0005\u0019\u001cXCAA!!\u0011\t\u0019%a\u0012\u000e\u0005\u0005\u0015#bAA\u001f_&!\u0011\u0011JA#\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\u0004MN\u0004\u0013\u0001D8oYfT\u0016\u000e\u001d$jY\u0016\u001cXCAA)%\u0019\t\u0019&!\u0017\u0002f\u00191\u0011QK\u0007\u0001\u0003#\u0012A\u0002\u0010:fM&tW-\\3oiz\nQb\u001c8msjK\u0007OR5mKN\u0004\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}c-\u0001\u0003mC:<\u0017\u0002BA2\u0003;\u0012aa\u00142kK\u000e$\b\u0003BA\"\u0003OJA!!\u001b\u0002F\tQ\u0001+\u0019;i\r&dG/\u001a:\u0002%=tG._\"iC:<W\r\\8h\r&dWm]\u000b\u0003\u0003_\u0012b!!\u001d\u0002Z\u0005\u0015dABA+\u001f\u0001\ty'A\np]2L8\t[1oO\u0016dwn\u001a$jY\u0016\u001c\b%A\u0005ta\u0006\u00148nQ8oMV\u0011\u0011\u0011\u0010\t\u0005\u0003w\ni(D\u0001B\u0013\r\ty(\u0011\u0002\n'B\f'o[\"p]\u001a\fQaY8eK\u000e,\"!!\"\u0011\t\u0005\u001d\u00151R\u0007\u0003\u0003\u0013S!!Z!\n\t\u00055\u0015\u0011\u0012\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000e\faB]8pi\u0012K'o\u00115fG.,G-\u0006\u0002\u0002\u0014B\u0019!*!&\n\u0007\u0005]5JA\u0004C_>dW-\u00198\u0002%I|w\u000e\u001e#je\u000eCWmY6fI~#S-\u001d\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002K\u0003?K1!!)L\u0005\u0011)f.\u001b;\t\u0013\u0005\u00156#!AA\u0002\u0005M\u0015a\u0001=%c\u0005y!o\\8u\t&\u00148\t[3dW\u0016$\u0007\u0005K\u0002\u0015\u0003W\u00032ASAW\u0013\r\tyk\u0013\u0002\tm>d\u0017\r^5mK\u0006\u0011r-\u001a;DQ\u0006tw-\u001a'pO^\u0013\u0018\u000e^3s)\u0011\t),a/\u0011\u0007a\f9,C\u0002\u0002:f\u0012\u0011d\u0015;bi\u0016\u001cFo\u001c:f\u0007\"\fgnZ3m_\u001e<&/\u001b;fe\"9\u0011QX\u000bA\u0002\u0005E\u0011a\u0002<feNLwN\\\u0001\u0013O\u0016$8\t[1oO\u0016dwn\u001a*fC\u0012,'\u000f\u0006\u0003\u0002D\u0006%\u0007c\u0001=\u0002F&\u0019\u0011qY\u001d\u00033M#\u0018\r^3Ti>\u0014Xm\u00115b]\u001e,Gn\\4SK\u0006$WM\u001d\u0005\b\u0003{3\u0002\u0019AA\t\u0003Uaw.\u00193DQ\u0016\u001c7\u000e]8j]RlU\r\u001e:jGN,\"!a4\u0011\u0007a\f\t.C\u0002\u0002Tf\u0012\u0011DU8dWN$%IR5mK6\u000bg.Y4fe6+GO]5dg\u0006IBn\\1e\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001cx\fJ3r)\u0011\ti*!7\t\u0013\u0005\u0015\u0006$!AA\u0002\u0005=\u0017A\u00067pC\u0012\u001c\u0005.Z2la>Lg\u000e^'fiJL7m\u001d\u0011)\u0007e\tY+A\u000btCZ,7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:\u00023M\fg/Z\"iK\u000e\\\u0007o\\5oi6+GO]5dg~#S-\u001d\u000b\u0005\u0003;\u000b)\u000fC\u0005\u0002&n\t\t\u00111\u0001\u0002P\u000612/\u0019<f\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c\b\u0005K\u0002\u001d\u0003W\u000b1\u0004\\1uKN$Hj\\1e\u0007\",7m\u001b9pS:$X*\u001a;sS\u000e\u001c\u0018a\u00077bi\u0016\u001cHoU1wK\u000eCWmY6q_&tG/T3ue&\u001c7/A\ntCZ,7\t[3dWB|\u0017N\u001c;U_\u001237\u000f\u0006\u0005\u0002\u001e\u0006M\u0018q_A}\u0011\u0019\t)p\ba\u0001E\u0006i1\r[3dWB|\u0017N\u001c;ESJDq!!0 \u0001\u0004\t\t\u0002C\u0004\u0002|~\u0001\r!!\u0005\u0002\u000f9,XnS3zg\u0006)Bn\\1e\u0007\",7m\u001b9pS:$hI]8n\t\u001a\u001cHC\u0002B\u0001\u0005\u000f\u0011I\u0001E\u0002y\u0005\u0007I1A!\u0002:\u0005e\u0011vnY6t\t\n\u001b\u0005.Z2la>Lg\u000e^'fi\u0006$\u0017\r^1\t\u000f\u0005u\u0006\u00051\u0001\u0002\u0012!1!1\u0002\u0011A\u0002\t\f\u0001\u0002\\8dC2$\u0015N]\u0001\u0019O\u0016$H*\u0019;fgR\u001cf.\u00199tQ>$h+\u001a:tS>tG\u0003BA\t\u0005#Aq!!0\"\u0001\u0004\t\t\"\u0001\thKRd\u0015\r^3tiZ+'o]5p]R\u0011\u0011\u0011C\u0001\u0010M&tGm\u0014:qQ\u0006tg)\u001b7fgR1!1\u0004B\u000f\u0005C\u0001R!!\u0007\u0002$YCqAa\b$\u0001\u0004\u0011Y\"\u0001\u0007ue\u0006\u001c7.\u001a3GS2,7\u000fC\u0004\u0003$\r\u0002\rA!\n\u0002\u0011\u0005dGNR5mKN\u0004b!!\u0007\u0002$\t\u001d\u0002\u0003BA\"\u0005SIAAa\u000b\u0002F\tQa)\u001b7f'R\fG/^:\u0002)\u0011,G.\u001a;f\u0007\"\fgnZ3m_\u001e4\u0015\u000e\\3t)\u0011\tiJ!\r\t\u000f\tMB\u00051\u0001\u00036\u0005\u0001b/\u001a:tS>t7\u000fV8EK2,G/\u001a\t\u0006\u0015\n]\u0012\u0011C\u0005\u0004\u0005sY%!B!se\u0006L\u0018!\u00053fY\u0016$Xm\u00147e-\u0016\u00148/[8ogR!\u0011Q\u0014B \u0011\u001d\u0011\t%\na\u0001\u0005\u0007\n1C\\;n-\u0016\u00148/[8ogR{'+\u001a;bS:\u00042A\u0013B#\u0013\r\u00119e\u0013\u0002\u0004\u0013:$\u0018aF:bm\u0016LU.\\;uC\ndWMR5mKN$v\u000e\u00124t)\u0019\t9B!\u0014\u0003P!9\u0011Q\u0018\u0014A\u0002\u0005E\u0001b\u0002B)M\u0001\u0007!1K\u0001\u000bY>\u001c\u0017\r\u001c$jY\u0016\u001c\b#BA\r\u0003G\u0011\u0017!\u00077pC\u0012LU.\\;uC\ndWMR5mKN4%o\\7EMN$b!!(\u0003Z\tu\u0003b\u0002B.O\u0001\u0007\u0011qC\u0001\u000fS6lW\u000f^1cY\u00164\u0015\u000e\\3t\u0011\u0019\u0011Ya\na\u0001E\u0006yr-\u001a;J[6,H/\u00192mK\u001aKG.Z:Ge>lg+\u001a:tS>t',\u001b9\u0015\t\u0005]!1\r\u0005\b\u0003{C\u0003\u0019AA\t\u00031Q\u0018\u000e\u001d+p\t\u001a\u001ch)\u001b7f)\u0019\tiJ!\u001b\u0003n!9!1N\u0015A\u0002\tM\u0013!\u00024jY\u0016\u001c\bb\u0002B8S\u0001\u0007!\u0011O\u0001\u000bI\u001a\u001c(,\u001b9GS2,\u0007\u0003BA\"\u0005gJAA!\u001e\u0002F\t!\u0001+\u0019;i\u00035awn\u001a$jY\u0016\u001c\u0018J\u001c#jeR1\u0011Q\u0014B>\u0005\u007fBaA! +\u0001\u0004\u0011\u0017a\u00013je\"1!\u0011\u0011\u0016A\u0002Y\u000b1!\\:h\u00039qWm\u001e#G'\u001aKG.\u001a(b[\u0016$2A\u0016BD\u0011\u0019\u0011Ii\u000ba\u0001-\u0006iAn\\2bY\u001aKG.\u001a(b[\u0016\fq\u0002\u001a4t\u0005\u0006$8\r\u001b.ja\u001aKG.\u001a\u000b\u0005\u0005c\u0012y\tC\u0004\u0002>2\u0002\r!!\u0005\u0002!\u001147o\u00115b]\u001e,Gn\\4GS2,G\u0003\u0002B9\u0005+Cq!!0.\u0001\u0004\t\t\"A\tm_\u000e\fG.T3uC\u0012\fG/\u0019$jY\u0016$2A\u0019BN\u0011\u0019\u0011iJ\fa\u0001E\u0006I\u0001/\u0019:f]R$\u0015N]\u0001\bY><g*Y7f+\u00051\u0016a\u00033gg\u001aKG.\u001a)bi\"$BA!\u001d\u0003(\"1!\u0011\u0016\u0019A\u0002Y\u000b\u0001BZ5mK:\u000bW.Z\u0001\u000eY>\u001c\u0017\r\u001c$jY\u0016\u0004\u0016\r\u001e5\u0015\u000b\t\u0014yK!-\t\r\t-\u0011\u00071\u0001c\u0011\u0019\u0011I+\ra\u0001-\u0006\u0001B.[:u%>\u001c7n\u001d#C\r&dWm\u001d\u000b\u0005\u0005o\u0013i\fE\u0004K\u0005s\u0013\u0019Fa\u0015\n\u0007\tm6J\u0001\u0004UkBdWM\r\u0005\u0007\u0005\u0017\u0011\u0004\u0019\u00012\u0002%I{7m[:E\u0005\u001aKG.Z'b]\u0006<WM\u001d\t\u0003qR\u001a\"\u0001N%\u0015\u0005\t\u0005\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0003L*\u001aaK!4,\u0005\t=\u0007\u0003\u0002Bi\u00057l!Aa5\u000b\t\tU'q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!7L\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005;\u0014\u0019NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0004")
public class RocksDBFileManager
implements Logging {
    private CheckpointFileManager fm;
    private SparkConf sparkConf;
    private final String dfsRootDir;
    private final File localTempDir;
    private Configuration hadoopConf;
    private final String codecName;
    private final String loggingId;
    private final ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles;
    private final FileSystem fs;
    private final PathFilter onlyZipFiles;
    private final PathFilter onlyChangelogFiles;
    private volatile boolean rootDirChecked;
    private volatile RocksDBFileManagerMetrics loadCheckpointMetrics;
    private volatile RocksDBFileManagerMetrics saveCheckpointMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$5() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles() {
        return this.versionToRocksDBFiles;
    }

    private CheckpointFileManager fm$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fm = CheckpointFileManager$.MODULE$.create(new Path(this.dfsRootDir), this.hadoopConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private PathFilter onlyZipFiles() {
        return this.onlyZipFiles;
    }

    private PathFilter onlyChangelogFiles() {
        return this.onlyChangelogFiles;
    }

    private SparkConf sparkConf$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkConf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$1 -> x$1.conf()).getOrElse((Function0 & Serializable)() -> new SparkConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkConf;
    }

    private SparkConf sparkConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkConf$lzycompute();
        }
        return this.sparkConf;
    }

    private CompressionCodec codec() {
        return CompressionCodec$.MODULE$.createCodec(this.sparkConf(), this.codecName);
    }

    private boolean rootDirChecked() {
        return this.rootDirChecked;
    }

    private void rootDirChecked_$eq(boolean x$1) {
        this.rootDirChecked = x$1;
    }

    public StateStoreChangelogWriter getChangeLogWriter(long version) {
        Path changelogFile = this.dfsChangelogFile(version);
        if (!this.rootDirChecked()) {
            Path rootDir = new Path(this.dfsRootDir);
            if (!this.fm().exists(rootDir)) {
                this.fm().mkdirs(rootDir);
            }
            this.rootDirChecked_$eq(true);
        }
        StateStoreChangelogWriter changelogWriter = new StateStoreChangelogWriter(this.fm(), changelogFile, this.codec());
        return changelogWriter;
    }

    public StateStoreChangelogReader getChangelogReader(long version) {
        Path changelogFile = this.dfsChangelogFile(version);
        return new StateStoreChangelogReader(this.fm(), changelogFile, this.codec());
    }

    private RocksDBFileManagerMetrics loadCheckpointMetrics() {
        return this.loadCheckpointMetrics;
    }

    private void loadCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.loadCheckpointMetrics = x$1;
    }

    private RocksDBFileManagerMetrics saveCheckpointMetrics() {
        return this.saveCheckpointMetrics;
    }

    private void saveCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.saveCheckpointMetrics = x$1;
    }

    public RocksDBFileManagerMetrics latestLoadCheckpointMetrics() {
        return this.loadCheckpointMetrics();
    }

    public RocksDBFileManagerMetrics latestSaveCheckpointMetrics() {
        return this.saveCheckpointMetrics();
    }

    public void saveCheckpointToDfs(File checkpointDir, long version, long numKeys) {
        this.logFilesInDir(checkpointDir, "Saving checkpoint files for version " + version);
        Tuple2<Seq<File>, Seq<File>> tuple2 = this.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localOtherFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)localImmutableFiles, (Object)localOtherFiles);
        Seq localImmutableFiles2 = (Seq)tuple22._1();
        Seq localOtherFiles2 = (Seq)tuple22._2();
        Seq<RocksDBImmutableFile> rocksDBFiles = this.saveImmutableFilesToDfs(version, (Seq<File>)localImmutableFiles2);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.apply(rocksDBFiles, numKeys);
        File metadataFile = this.localMetadataFile(checkpointDir);
        metadata.writeToFile(metadataFile);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Written metadata for version " + version + ":\n" + metadata.prettyJson());
        if (version <= 1L && numKeys <= 0L && !this.rootDirChecked()) {
            Path path = new Path(this.dfsRootDir);
            if (!this.fm().exists(path)) {
                this.fm().mkdirs(path);
            }
            this.rootDirChecked_$eq(true);
        }
        this.zipToDfsFile((Seq<File>)((Seq)localOtherFiles2.$colon$plus((Object)metadataFile)), this.dfsBatchZipFile(version));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Saved checkpoint file for version " + version);
    }

    public RocksDBCheckpointMetadata loadCheckpointFromDfs(long version, File localDir) {
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata;
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Loading checkpoint files for version " + version);
        this.versionToRocksDBFiles().keySet().removeIf(x$3 -> RocksDBFileManager.$anonfun$loadCheckpointFromDfs$2(version, BoxesRunTime.unboxToLong((Object)x$3)));
        if (version == 0L) {
            if (localDir.exists()) {
                Utils$.MODULE$.deleteRecursively(localDir);
            }
            localDir.mkdirs();
            rocksDBCheckpointMetadata = RocksDBCheckpointMetadata$.MODULE$.apply((Seq<RocksDBImmutableFile>)((Seq)package$.MODULE$.Seq().empty()), 0L);
        } else {
            ((IterableOnceOps)this.listRocksDBFiles(localDir)._2()).foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.delete()));
            Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), localDir);
            File metadataFile = this.localMetadataFile(localDir);
            RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Read metadata for version " + version + ":\n" + metadata.prettyJson());
            this.loadImmutableFilesFromDfs(metadata.immutableFiles(), localDir);
            this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), metadata.immutableFiles());
            metadataFile.delete();
            rocksDBCheckpointMetadata = metadata;
        }
        RocksDBCheckpointMetadata metadata = rocksDBCheckpointMetadata;
        this.logFilesInDir(localDir, "Loaded checkpoint files for version " + version);
        return metadata;
    }

    public long getLatestSnapshotVersion(long version) {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            if (this.fm().exists(this.dfsBatchZipFile(version))) {
                return version;
            }
            return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path, this.onlyZipFiles())), (Function1 & Serializable)x$5 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$5.getPath().getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6))), (ClassTag)ClassTag$.MODULE$.Long())), (Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 <= version)), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> scala.math.package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public long getLatestVersion() {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            Path[] files = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path)), (Function1 & Serializable)x$8 -> x$8.getPath(), ClassTag$.MODULE$.apply(Path.class));
            long[] changelogFileVersions = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$2(this, x$9)))), (Function1 & Serializable)x$10 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$10.getName()), ".changelog"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$11))), (ClassTag)ClassTag$.MODULE$.Long());
            long[] snapshotFileVersions = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$5(this, x$12)))), (Function1 & Serializable)x$13 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$13.getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14))), (ClassTag)ClassTag$.MODULE$.Long());
            long[] versions = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps(changelogFileVersions), (Object)snapshotFileVersions, (ClassTag)ClassTag$.MODULE$.Long());
            return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps(versions), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> scala.math.package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public Seq<String> findOrphanFiles(Seq<String> trackedFiles, Seq<FileStatus> allFiles) {
        Map fileModificationTimes = ((IterableOnceOps)allFiles.map((Function1 & Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.getPath().getName()), (Object)BoxesRunTime.boxToLong((long)file.getModificationTime())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (trackedFiles.nonEmpty() && allFiles.size() > trackedFiles.size()) {
            long oldestTrackedFileModificationTime = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)trackedFiles.flatMap((Function1 & Serializable)x$15 -> fileModificationTimes.get(x$15))).min((Ordering)Ordering.Long$.MODULE$));
            Seq orphanFiles = ((MapOps)fileModificationTimes.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$findOrphanFiles$3(oldestTrackedFileModificationTime, x$16)))).keys().toSeq();
            if (orphanFiles.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Found " + orphanFiles.size() + " orphan files: " + ((IterableOnceOps)orphanFiles.take(20)).mkString(", ") + "... (display at most 20 filenames) that should be deleted.");
            }
            return orphanFiles;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private void deleteChangelogFiles(long[] versionsToDelete) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(versionsToDelete), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            try {
                this.fm().delete(this.dfsChangelogFile(version));
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Deleted changelog file " + version);
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error deleting changelog file for version " + version, e);
            }
        });
    }

    public void deleteOldVersions(int numVersionsToRetain) {
        Path path = new Path(this.dfsRootDir);
        Path[] allFiles = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path)), (Function1 & Serializable)x$17 -> x$17.getPath(), ClassTag$.MODULE$.apply(Path.class));
        Path[] snapshotFiles = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$2(this, file)));
        Path[] changelogFiles = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$3(this, file)));
        long[] sortedSnapshotVersions = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])snapshotFiles), (Function1 & Serializable)x$18 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$18.getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$19))), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions))) {
            return;
        }
        long maxSnapshotVersionPresent = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)));
        long minVersionToRetain = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcZJ.sp & Serializable)x$20 -> x$20 <= maxSnapshotVersionPresent - (long)numVersionsToRetain + 1L)), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> scala.math.package$.MODULE$.max(x, y)));
        long[] snapshotVersionsToDelete = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcZJ.sp & Serializable)x$21 -> x$21 < minVersionToRetain);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete))) {
            return;
        }
        HashMap fileToMaxUsedVersion = new HashMap();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            Seq files = (Seq)Option$.MODULE$.apply(this.versionToRocksDBFiles().get(BoxesRunTime.boxToLong((long)version))).getOrElse((Function0 & Serializable)() -> {
                Seq<RocksDBImmutableFile> newResolvedFiles = this.getImmutableFilesFromVersionZip(version);
                this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), newResolvedFiles);
                return newResolvedFiles;
            });
            files.foreach((Function1 & Serializable)f -> {
                fileToMaxUsedVersion.update((Object)f.dfsFileName(), (Object)BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.max(version, BoxesRunTime.unboxToLong((Object)fileToMaxUsedVersion.getOrElse((Object)f.dfsFileName(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> version$5)))));
                return BoxedUnit.UNIT;
            });
        });
        HashMap filesToDelete = (HashMap)fileToMaxUsedVersion.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$13(snapshotVersionsToDelete, x0$1)));
        Path sstDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR());
        Path logDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR());
        Seq allSstFiles = this.fm().exists(sstDir) ? ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.fm().list(sstDir)).toImmutableArraySeq() : (Seq)package$.MODULE$.Seq().empty();
        Seq allLogFiles = this.fm().exists(logDir) ? ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.fm().list(logDir)).toImmutableArraySeq() : (Seq)package$.MODULE$.Seq().empty();
        filesToDelete.$plus$plus$eq((IterableOnce)this.findOrphanFiles((Seq<String>)fileToMaxUsedVersion.keys().toSeq(), (Seq<FileStatus>)((Seq)allSstFiles.$plus$plus((IterableOnce)allLogFiles))).map((Function1 & Serializable)x$22 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$22), (Object)BoxesRunTime.boxToLong((long)-1L))));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Deleting " + filesToDelete.size() + " files not used in versions >= " + minVersionToRetain);
        IntRef failedToDelete = IntRef.create((int)0);
        filesToDelete.foreach((Function1 & Serializable)x0$2 -> {
            RocksDBFileManager.$anonfun$deleteOldVersions$16(this, failedToDelete, x0$2);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            Path versionFile = this.dfsBatchZipFile(version);
            try {
                this.fm().delete(versionFile);
                this.versionToRocksDBFiles().remove(BoxesRunTime.boxToLong((long)version));
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted version " + version);
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error deleting version file " + versionFile + " for version " + version, e);
            }
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Deleted " + (filesToDelete.size() - failedToDelete$1.elem) + " files (failed to delete" + failedToDelete$1.elem + " files) not used in versions >= " + minVersionToRetain);
        long[] changelogVersionsToDelete = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])changelogFiles), (Function1 & Serializable)x$23 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$23.getName()), ".changelog"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$24))), (ClassTag)ClassTag$.MODULE$.Long())), (Function1)(JFunction1.mcZJ.sp & Serializable)x$25 -> x$25 < minVersionToRetain);
        this.deleteChangelogFiles(changelogVersionsToDelete);
    }

    private Seq<RocksDBImmutableFile> saveImmutableFilesToDfs(long version, Seq<File> localFiles) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Saving RocksDB files to DFS for " + version);
        Map prevFilesToSizes = ((IterableOnceOps)((IterableOps)((MapOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.versionToRocksDBFiles()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$saveImmutableFilesToDfs$2(version, x0$1)))).values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        Seq immutableFiles = (Seq)localFiles.map((Function1 & Serializable)localFile -> (RocksDBImmutableFile)prevFilesToSizes.get((Object)localFile.getName()).filter((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)x$26.isSameFile(localFile))).map((Function1 & Serializable)reusable -> {
            ++filesReused$1.elem;
            return reusable;
        }).getOrElse((Function0 & Serializable)() -> {
            String localFileName = localFile.getName();
            String dfsFileName = this.newDFSFileName(localFileName);
            Path dfsFile = this.dfsFilePath(dfsFileName);
            this.fs().copyFromLocalFile(new Path(localFile.getAbsoluteFile().toURI()), dfsFile);
            long localFileSize = localFile.length();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Copied " + localFile + " to " + dfsFile + " - " + localFileSize + " bytes");
            ++filesCopied$1.elem;
            bytesCopied$1.elem += localFileSize;
            return RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFileName, localFileSize);
        }));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Copied " + filesCopied$1.elem + " files (" + bytesCopied$1.elem + " bytes) from local to DFS for version " + version + ". " + filesReused$1.elem + " files reused without copying.");
        this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), (Seq<RocksDBImmutableFile>)immutableFiles);
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.saveCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
        return immutableFiles;
    }

    private void loadImmutableFilesFromDfs(Seq<RocksDBImmutableFile> immutableFiles, File localDir) {
        Map requiredFileNameToFileDetails = ((IterableOnceOps)immutableFiles.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ((IterableOnceOps)this.listRocksDBFiles(localDir)._1()).foreach((Function1 & Serializable)existingFile -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$2(this, requiredFileNameToFileDetails, existingFile);
            return BoxedUnit.UNIT;
        });
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        immutableFiles.foreach((Function1 & Serializable)file -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$5(this, localDir, filesCopied, bytesCopied, filesReused, file);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Copied " + filesCopied$2.elem + " files (" + bytesCopied$2.elem + " bytes) from DFS to local with " + filesReused$2.elem + " files reused.");
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.loadCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
    }

    private Seq<RocksDBImmutableFile> getImmutableFilesFromVersionZip(long version) {
        Utils$.MODULE$.deleteRecursively(this.localTempDir);
        this.localTempDir.mkdirs();
        Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), this.localTempDir);
        File metadataFile = this.localMetadataFile(this.localTempDir);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
        return metadata.immutableFiles();
    }

    private void zipToDfsFile(Seq<File> files, Path dfsZipFile) {
        LazyRef filesStr$lzy = new LazyRef();
        ObjectRef in = ObjectRef.create(null);
        CheckpointFileManager.CancellableFSDataOutputStream out = this.fm().createAtomic(dfsZipFile, true);
        LongRef totalBytes = LongRef.create((long)0L);
        ZipOutputStream zout = new ZipOutputStream((OutputStream)((Object)out));
        try {
            try {
                files.foreach((Function1 & Serializable)file -> {
                    RocksDBFileManager.$anonfun$zipToDfsFile$1(zout, in, totalBytes, file);
                    return BoxedUnit.UNIT;
                });
                zout.close();
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Zipped " + totalBytes$1.elem + " bytes (before compression) to " + RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files));
                RocksDBFileManagerMetrics qual$1 = this.saveCheckpointMetrics();
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)totalBytes.elem));
                long x$2 = qual$1.copy$default$1();
                long x$3 = qual$1.copy$default$2();
                long x$4 = qual$1.copy$default$3();
                this.saveCheckpointMetrics_$eq(qual$1.copy(x$2, x$3, x$4, (Option<Object>)x$1));
            }
            catch (Exception e) {
                out.cancel();
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Error zipping to " + RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files), e);
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)in.elem));
            IOUtils.closeQuietly((OutputStream)zout);
        }
    }

    private void logFilesInDir(File dir, String msg) {
        LazyRef files$lzy = new LazyRef();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> msg + " - " + RocksDBFileManager.files$2(files$lzy, dir).length + " files\n\t" + Predef$.MODULE$.wrapRefArray((Object[])RocksDBFileManager.files$2(files$lzy, dir)).mkString("\n\t"));
    }

    private String newDFSFileName(String localFileName) {
        String baseName = FilenameUtils.getBaseName((String)localFileName);
        String extension = FilenameUtils.getExtension((String)localFileName);
        return baseName + "-" + UUID.randomUUID() + "." + extension;
    }

    private Path dfsBatchZipFile(long version) {
        return new Path(this.dfsRootDir + "/" + version + ".zip");
    }

    private Path dfsChangelogFile(long version) {
        return new Path(this.dfsRootDir + "/" + version + ".changelog");
    }

    private File localMetadataFile(File parentDir) {
        return new File(parentDir, "metadata");
    }

    public String logName() {
        return Logging.logName$((Logging)this) + " " + this.loggingId;
    }

    private Path dfsFilePath(String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isSstFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR()), fileName);
        }
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR()), fileName);
        }
        return new Path(this.dfsRootDir, fileName);
    }

    private File localFilePath(File localDir, String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new File(new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()), fileName);
        }
        return new File(localDir, fileName);
    }

    private Tuple2<Seq<File>, Seq<File>> listRocksDBFiles(File localDir) {
        File[] topLevelFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])localDir.listFiles()), (Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$listRocksDBFiles$1(x$28)));
        File[] archivedLogFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()).listFiles()).getOrElse((Function0 & Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class)))), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isLogFile(file.getName())));
        Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isSstFile(f.getName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] topLevelSstFiles = (File[])tuple2._1();
        File[] topLevelOtherFiles = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelSstFiles, (Object)topLevelOtherFiles);
        File[] topLevelSstFiles2 = (File[])tuple22._1();
        File[] topLevelOtherFiles2 = (File[])tuple22._2();
        return new Tuple2((Object)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])topLevelSstFiles2), (Object)archivedLogFiles, ClassTag$.MODULE$.apply(File.class))).toImmutableArraySeq(), (Object)ArrayImplicits$.MODULE$.SparkArrayOps((Object)topLevelOtherFiles2).toImmutableArraySeq());
    }

    public static final /* synthetic */ boolean $anonfun$loadCheckpointFromDfs$2(long version$2, long x$3) {
        return x$3 >= version$2;
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$2(RocksDBFileManager $this, Path x$9) {
        return $this.onlyChangelogFiles().accept(x$9);
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$5(RocksDBFileManager $this, Path x$12) {
        return $this.onlyZipFiles().accept(x$12);
    }

    public static final /* synthetic */ boolean $anonfun$findOrphanFiles$3(long oldestTrackedFileModificationTime$1, Tuple2 x$16) {
        return x$16._2$mcJ$sp() < oldestTrackedFileModificationTime$1;
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$2(RocksDBFileManager $this, Path file) {
        return $this.onlyZipFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$3(RocksDBFileManager $this, Path file) {
        return $this.onlyChangelogFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$13(long[] snapshotVersionsToDelete$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long v = tuple2._2$mcJ$sp();
            return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete$1), (Object)BoxesRunTime.boxToLong((long)v));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteOldVersions$16(RocksDBFileManager $this, IntRef failedToDelete$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String dfsFileName = (String)tuple2._1();
            long maxUsedVersion = tuple2._2$mcJ$sp();
            try {
                Path dfsFile = $this.dfsFilePath(dfsFileName);
                $this.fm().delete(dfsFile);
                if (maxUsedVersion == -1L) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted orphan file " + dfsFileName);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted file " + dfsFileName + " that was last used in version " + maxUsedVersion);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                ++failedToDelete$1.elem;
                if (maxUsedVersion == -1L) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error deleting orphan file " + dfsFileName, e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error deleting file " + dfsFileName + ", last used in version " + maxUsedVersion, e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$saveImmutableFilesToDfs$2(long version$7, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long k = tuple2._1$mcJ$sp();
            return k < version$7;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$2(RocksDBFileManager $this, Map requiredFileNameToFileDetails$1, File existingFile) {
        boolean isSameFile = requiredFileNameToFileDetails$1.get((Object)existingFile.getName()).exists((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)x$27.isSameFile(existingFile)));
        if (!isSameFile) {
            existingFile.delete();
            $this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Deleted local file " + existingFile);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$5(RocksDBFileManager $this, File localDir$1, LongRef filesCopied$2, LongRef bytesCopied$2, LongRef filesReused$2, RocksDBImmutableFile file) {
        String localFileName = file.localFileName();
        File localFile = $this.localFilePath(localDir$1, localFileName);
        if (!localFile.exists()) {
            Path dfsFile = $this.dfsFilePath(file.dfsFileName());
            $this.fs().copyToLocalFile(dfsFile, new Path(localFile.getAbsoluteFile().toURI()));
            long localFileSize = localFile.length();
            long expectedSize = file.sizeBytes();
            if (localFileSize != expectedSize) {
                throw QueryExecutionErrors$.MODULE$.unexpectedFileSize(dfsFile, localFile, expectedSize, localFileSize);
            }
            ++filesCopied$2.elem;
            bytesCopied$2.elem += localFileSize;
            $this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Copied " + dfsFile + " to " + localFile + " - " + localFileSize + " bytes");
            return;
        }
        ++filesReused$2.elem;
    }

    private static final /* synthetic */ String filesStr$lzycompute$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        String string;
        LazyRef lazyRef = filesStr$lzy$1;
        synchronized (lazyRef) {
            string = filesStr$lzy$1.initialized() ? (String)filesStr$lzy$1.value() : (String)filesStr$lzy$1.initialize((Object)(dfsZipFile$1 + "\n\t" + files$1.mkString("\n\t")));
        }
        return string;
    }

    private static final String filesStr$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        if (filesStr$lzy$1.initialized()) {
            return (String)filesStr$lzy$1.value();
        }
        return RocksDBFileManager.filesStr$lzycompute$1(filesStr$lzy$1, dfsZipFile$1, files$1);
    }

    public static final /* synthetic */ void $anonfun$zipToDfsFile$1(ZipOutputStream zout$1, ObjectRef in$1, LongRef totalBytes$1, File file) {
        zout$1.putNextEntry(new ZipEntry(file.getName()));
        in$1.elem = new FileInputStream(file);
        int bytes = IOUtils.copy((InputStream)((InputStream)in$1.elem), (OutputStream)zout$1);
        ((InputStream)in$1.elem).close();
        zout$1.closeEntry();
        totalBytes$1.elem += (long)bytes;
    }

    private static final /* synthetic */ String[] files$lzycompute$1(LazyRef files$lzy$1, File dir$1) {
        String[] stringArray;
        LazyRef lazyRef = files$lzy$1;
        synchronized (lazyRef) {
            stringArray = files$lzy$1.initialized() ? (String[])files$lzy$1.value() : (String[])files$lzy$1.initialize(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)Utils$.MODULE$.recursiveList(dir$1)).getOrElse((Function0 & Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))), (Function1 & Serializable)f -> f.getAbsolutePath() + " - " + f.length() + " bytes", ClassTag$.MODULE$.apply(String.class)));
        }
        return stringArray;
    }

    private static final String[] files$2(LazyRef files$lzy$1, File dir$1) {
        if (files$lzy$1.initialized()) {
            return (String[])files$lzy$1.value();
        }
        return RocksDBFileManager.files$lzycompute$1(files$lzy$1, dir$1);
    }

    public static final /* synthetic */ boolean $anonfun$listRocksDBFiles$1(File x$28) {
        return !x$28.isDirectory();
    }

    public RocksDBFileManager(String dfsRootDir, File localTempDir, Configuration hadoopConf, String codecName, String loggingId) {
        this.dfsRootDir = dfsRootDir;
        this.localTempDir = localTempDir;
        this.hadoopConf = hadoopConf;
        this.codecName = codecName;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        this.versionToRocksDBFiles = new ConcurrentHashMap();
        this.fs = new Path(dfsRootDir).getFileSystem(hadoopConf);
        this.onlyZipFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".zip");
            }
        };
        this.onlyChangelogFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".changelog");
            }
        };
        this.rootDirChecked = false;
        this.loadCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.saveCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
    }
}

