/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterCommitMessage$;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\b\u0011\u0001}A\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001dq\u0006A1A\u0005\n}Caa\u0019\u0001!\u0002\u0013\u0001\u0007\"\u00033\u0001\u0001\u0004\u0005\r\u0011\"\u0003f\u0011%\u0011\b\u00011AA\u0002\u0013%1\u000fC\u0005z\u0001\u0001\u0007\t\u0011)Q\u0005M\")A\u0006\u0001C!u\")Q\u0010\u0001C!}\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0005\u0001\u0011\u0005\u0013q\u0001\u0002\u0012\r>\u0014X-Y2i\t\u0006$\u0018m\u0016:ji\u0016\u0014(BA\t\u0013\u0003\u001d\u0019x.\u001e:dKNT!a\u0005\u000b\u0002\u0013M$(/Z1nS:<'BA\u000b\u0017\u0003%)\u00070Z2vi&|gN\u0003\u0002\u00181\u0005\u00191/\u001d7\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001!\u0006\u0002!}M\u0019\u0001!I\u0015\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00027b]\u001eT\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t1qJ\u00196fGR\u00042AK\u00182\u001b\u0005Y#B\u0001\u0017.\u0003\u00159(/\u001b;f\u0015\tqc#A\u0005d_:tWm\u0019;pe&\u0011\u0001g\u000b\u0002\u000b\t\u0006$\u0018m\u0016:ji\u0016\u0014\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0017\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001c4\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\r]\u0014\u0018\u000e^3s!\rI$\bP\u0007\u0002-%\u00111H\u0006\u0002\u000e\r>\u0014X-Y2i/JLG/\u001a:\u0011\u0005urD\u0002\u0001\u0003\u0006\u007f\u0001\u0011\r\u0001\u0011\u0002\u0002)F\u0011\u0011i\u0012\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\b\u001d>$\b.\u001b8h!\t\u0011\u0005*\u0003\u0002J\u0007\n\u0019\u0011I\\=\u0002\u0019I|woQ8om\u0016\u0014H/\u001a:\u0011\t\tc\u0015\u0007P\u0005\u0003\u001b\u000e\u0013\u0011BR;oGRLwN\\\u0019\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\t\u0003\u0005BK!!U\"\u0003\u0007%sG/A\u0004fa>\u001c\u0007.\u00133\u0011\u0005\t#\u0016BA+D\u0005\u0011auN\\4\u0002\rqJg.\u001b;?)\u0015A&l\u0017/^!\rI\u0006\u0001P\u0007\u0002!!)q'\u0002a\u0001q!)!*\u0002a\u0001\u0017\")a*\u0002a\u0001\u001f\")!+\u0002a\u0001'\u00061q\u000e]3oK\u0012,\u0012\u0001\u0019\t\u0003\u0005\u0006L!AY\"\u0003\u000f\t{w\u000e\\3b]\u00069q\u000e]3oK\u0012\u0004\u0013aC3se>\u0014xJ\u001d(vY2,\u0012A\u001a\t\u0003O>t!\u0001[7\u000f\u0005%dW\"\u00016\u000b\u0005-t\u0012A\u0002\u001fs_>$h(C\u0001E\u0013\tq7)A\u0004qC\u000e\\\u0017mZ3\n\u0005A\f(!\u0003+ie><\u0018M\u00197f\u0015\tq7)A\bfeJ|'o\u0014:Ok2dw\fJ3r)\t!x\u000f\u0005\u0002Ck&\u0011ao\u0011\u0002\u0005+:LG\u000fC\u0004y\u0013\u0005\u0005\t\u0019\u00014\u0002\u0007a$\u0013'\u0001\u0007feJ|'o\u0014:Ok2d\u0007\u0005\u0006\u0002uw\")Ap\u0003a\u0001c\u00051!/Z2pe\u0012\faaY8n[&$H#A@\u0011\u0007)\n\t!C\u0002\u0002\u0004-\u00121c\u0016:ji\u0016\u00148i\\7nSRlUm]:bO\u0016\fQ!\u00192peR$\u0012\u0001^\u0001\u0006G2|7/\u001a")
public class ForeachDataWriter<T>
implements DataWriter<InternalRow> {
    private final ForeachWriter<T> writer;
    private final Function1<InternalRow, T> rowConverter;
    private final boolean opened;
    private Throwable errorOrNull;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private boolean opened() {
        return this.opened;
    }

    private Throwable errorOrNull() {
        return this.errorOrNull;
    }

    private void errorOrNull_$eq(Throwable x$1) {
        this.errorOrNull = x$1;
    }

    public void write(InternalRow record) {
        if (!this.opened()) {
            return;
        }
        try {
            this.writer.process(this.rowConverter.apply((Object)record));
        }
        catch (Throwable t) {
            this.errorOrNull_$eq(t);
            throw t;
        }
    }

    public WriterCommitMessage commit() {
        return ForeachWriterCommitMessage$.MODULE$;
    }

    public void abort() {
        if (this.errorOrNull() == null) {
            this.errorOrNull_$eq(QueryExecutionErrors$.MODULE$.foreachWriterAbortedDueToTaskFailureError());
            return;
        }
    }

    public void close() {
        this.writer.close(this.errorOrNull());
    }

    public ForeachDataWriter(ForeachWriter<T> writer, Function1<InternalRow, T> rowConverter, int partitionId, long epochId) {
        this.writer = writer;
        this.rowConverter = rowConverter;
        this.opened = writer.open(partitionId, epochId);
    }
}

