/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.optimizer.InlineCTE;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.WithCTE;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.ReportsSinkMetrics;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.MicroBatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.EventTimeStats;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.ProgressReporter$;
import org.apache.spark.sql.execution.streaming.ProgressReporter$ExecutionStats$;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.streaming.SinkProgress;
import org.apache.spark.sql.streaming.SinkProgress$;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.util.Clock;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011MaaB*U!\u0003\r\t!\u0019\u0005\u0006]\u0002!\ta\u001c\u0004\u0005g\u0002\u0001E\u000f\u0003\u0006\u0002\n\t\u0011)\u001a!C\u0001\u0003\u0017A!\"!\u000e\u0003\u0005#\u0005\u000b\u0011BA\u0007\u0011)\t9D\u0001BK\u0002\u0013\u0005\u0011\u0011\b\u0005\u000b\u0003\u0017\u0012!\u0011#Q\u0001\n\u0005m\u0002BCA'\u0005\tU\r\u0011\"\u0001\u0002P!Q\u0011\u0011\f\u0002\u0003\u0012\u0003\u0006I!!\u0015\t\u000f\u0005m#\u0001\"\u0001\u0002^!I\u0011\u0011\u000e\u0002\u0002\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003g\u0012\u0011\u0013!C\u0001\u0003kB\u0011\"a#\u0003#\u0003%\t!!$\t\u0013\u0005E%!%A\u0005\u0002\u0005M\u0005\"CAL\u0005\u0005\u0005I\u0011IAM\u0011%\tIKAA\u0001\n\u0003\tY\u000bC\u0005\u00024\n\t\t\u0011\"\u0001\u00026\"I\u0011\u0011\u0019\u0002\u0002\u0002\u0013\u0005\u00131\u0019\u0005\n\u0003#\u0014\u0011\u0011!C\u0001\u0003'D\u0011\"!8\u0003\u0003\u0003%\t%a8\t\u0013\u0005\r(!!A\u0005B\u0005\u0015\b\"CAt\u0005\u0005\u0005I\u0011IAu\u0011%\tYOAA\u0001\n\u0003\nioB\u0005\u0002r\u0002\t\t\u0011#\u0001\u0002t\u001aA1\u000fAA\u0001\u0012\u0003\t)\u0010C\u0004\u0002\\a!\tA!\u0004\t\u0013\u0005\u001d\b$!A\u0005F\u0005%\b\"\u0003B\b1\u0005\u0005I\u0011\u0011B\t\u0011%\u0011I\u0002GA\u0001\n\u0003\u0013Y\u0002C\u0004\u0003.\u00011\tBa\f\t\u000f\tu\u0002A\"\u0005\u00030!9!q\b\u0001\u0007\u0012\t\u0005\u0003b\u0002B\"\u0001\u0019E!Q\t\u0005\b\u0005#\u0002a\u0011\u0003B*\u0011\u001d\u0011I\u0007\u0001D\t\u0005WBqA!\u001e\u0001\r#\u00119\bC\u0004\u0003|\u00011\tB! \t\u000f\tE\u0005A\"\u0005\u0003\u0014\"9!q\u0013\u0001\u0007\u0012\te\u0005b\u0002BT\u0001\u0019E!\u0011\u0016\u0005\b\u0005g\u0003a\u0011\u0003B[\u0011\u001d\u00119\f\u0001D\t\u0005sCqAa1\u0001\r#\u0011)\rC\u0005\u0003Z\u0002\u0001\r\u0011\"\u0003\u00036\"I!1\u001c\u0001A\u0002\u0013%!Q\u001c\u0005\n\u0005C\u0004\u0001\u0019!C\u0005\u0005kC\u0011Ba9\u0001\u0001\u0004%IA!:\t\u0017\t%\b\u00011AA\u0002\u0013%!1\u001e\u0005\f\u0005_\u0004\u0001\u0019!a\u0001\n\u0013\u0011\t\u0010C\u0006\u0003v\u0002\u0001\r\u00111A\u0005\n\t-\bb\u0003B|\u0001\u0001\u0007\t\u0019!C\u0005\u0005sD1B!@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003l\"Y!q \u0001A\u0002\u0003\u0007I\u0011BB\u0001\u0011%\u0019)\u0001\u0001a\u0001\n\u0013\u0011)\fC\u0005\u0004\b\u0001\u0001\r\u0011\"\u0003\u0004\n!I1Q\u0002\u0001C\u0002\u0013%1q\u0002\u0005\n\u0007;\u0001\u0001\u0019!C\u0005\u0007?A\u0011b!\t\u0001\u0001\u0004%Iaa\t\t\u0013\r\u001d\u0002A1A\u0005\n\r%\u0002\"CB\u001c\u0001\t\u0007I\u0011\u0002B[\u0011%\u0019I\u0004\u0001a\u0001\n\u0013\u0011)\fC\u0005\u0004<\u0001\u0001\r\u0011\"\u0003\u0004>!I1\u0011\t\u0001C\u0002\u0013%11\t\u0005\n\u0007#\u0002\u0001\u0019!C\t\u0007'B\u0011ba\u0019\u0001\u0001\u0004%\tb!\u001a\t\u0017\r%\u0004\u00011AA\u0002\u0013%11\u000e\u0005\f\u0007g\u0002\u0001\u0019!a\u0001\n\u0013\u0019)\bC\u0004\u0004z\u0001!\taa\u0015\t\u000f\rm\u0004\u0001\"\u0001\u0004~!91Q\u0011\u0001\u0005\u0002\r\u001d\u0005BBBE\u0001\u0011Eq\u000eC\u0004\u0004\f\u0002!\tb!$\t\u000f\rm\u0005\u0001\"\u0003\u0004\u001e\"911\u0015\u0001\u0005\n\r\u0015\u0006bBBU\u0001\u0011%11\u0016\u0005\b\u0007_\u0003A\u0011CBY\u0011\u001d\u0019Y\f\u0001C\u0005\u0007{Cqa!1\u0001\t\u0013\u0019\u0019\rC\u0004\u0004J\u0002!Iaa3\t\u000f\r5\u0007\u0001\"\u0003\u0004P\"91Q\u001c\u0001\u0005\u0012\r}\u0007b\u0002C\u0002\u0001\u0011EAQ\u0001\u0005\b\t\u0017\u0001A\u0011\u0003C\u0007\u0005A\u0001&o\\4sKN\u001c(+\u001a9peR,'O\u0003\u0002V-\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003/b\u000b\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005eS\u0016aA:rY*\u00111\fX\u0001\u0006gB\f'o\u001b\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0007\u000e\u0005\u0002dM6\tAMC\u0001f\u0003\u0015\u00198-\u00197b\u0013\t9GM\u0001\u0004B]f\u0014VM\u001a\t\u0003S2l\u0011A\u001b\u0006\u0003Wj\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003[*\u0014q\u0001T8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002aB\u00111-]\u0005\u0003e\u0012\u0014A!\u00168ji\nqQ\t_3dkRLwN\\*uCR\u001c8\u0003\u0002\u0002ckb\u0004\"a\u0019<\n\u0005]$'a\u0002)s_\u0012,8\r\u001e\t\u0004s\u0006\raB\u0001>\u0000\u001d\tYh0D\u0001}\u0015\ti\b-\u0001\u0004=e>|GOP\u0005\u0002K&\u0019\u0011\u0011\u00013\u0002\u000fA\f7m[1hK&!\u0011QAA\u0004\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\t\u0001Z\u0001\nS:\u0004X\u000f\u001e*poN,\"!!\u0004\u0011\u0011\u0005=\u0011qCA\u000f\u0003_qA!!\u0005\u0002\u0014A\u00111\u0010Z\u0005\u0004\u0003+!\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0005m!aA'ba*\u0019\u0011Q\u00033\u0011\t\u0005}\u00111F\u0007\u0003\u0003CQ1!VA\u0012\u0015\u0011\t)#a\n\u0002\tI,\u0017\r\u001a\u0006\u0004\u0003SA\u0016!C2p]:,7\r^8s\u0013\u0011\ti#!\t\u0003\u001fM\u0003\u0018M]6ECR\f7\u000b\u001e:fC6\u00042aYA\u0019\u0013\r\t\u0019\u0004\u001a\u0002\u0005\u0019>tw-\u0001\u0006j]B,HOU8xg\u0002\nab\u001d;bi\u0016|\u0005/\u001a:bi>\u00148/\u0006\u0002\u0002<A)\u00110!\u0010\u0002B%!\u0011qHA\u0004\u0005\r\u0019V-\u001d\t\u0005\u0003\u0007\n9%\u0004\u0002\u0002F)\u0011Q\u000bW\u0005\u0005\u0003\u0013\n)EA\u000bTi\u0006$Xm\u00149fe\u0006$xN\u001d)s_\u001e\u0014Xm]:\u0002\u001fM$\u0018\r^3Pa\u0016\u0014\u0018\r^8sg\u0002\na\"\u001a<f]R$\u0016.\\3Ti\u0006$8/\u0006\u0002\u0002RAA\u0011qBA\f\u0003'\n\u0019\u0006\u0005\u0003\u0002\u0010\u0005U\u0013\u0002BA,\u00037\u0011aa\u0015;sS:<\u0017aD3wK:$H+[7f'R\fGo\u001d\u0011\u0002\rqJg.\u001b;?)!\ty&a\u0019\u0002f\u0005\u001d\u0004cAA1\u00055\t\u0001\u0001C\u0004\u0002\n%\u0001\r!!\u0004\t\u000f\u0005]\u0012\u00021\u0001\u0002<!9\u0011QJ\u0005A\u0002\u0005E\u0013\u0001B2paf$\u0002\"a\u0018\u0002n\u0005=\u0014\u0011\u000f\u0005\n\u0003\u0013Q\u0001\u0013!a\u0001\u0003\u001bA\u0011\"a\u000e\u000b!\u0003\u0005\r!a\u000f\t\u0013\u00055#\u0002%AA\u0002\u0005E\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003oRC!!\u0004\u0002z-\u0012\u00111\u0010\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0006\u0012\f!\"\u00198o_R\fG/[8o\u0013\u0011\tI)a \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005=%\u0006BA\u001e\u0003s\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0016*\"\u0011\u0011KA=\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0014\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0016\u0001\u00026bm\u0006LA!a\u0016\u0002 \u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0016\t\u0004G\u0006=\u0016bAAYI\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qWA_!\r\u0019\u0017\u0011X\u0005\u0004\u0003w#'aA!os\"I\u0011q\u0018\t\u0002\u0002\u0003\u0007\u0011QV\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\u0007CBAd\u0003\u001b\f9,\u0004\u0002\u0002J*\u0019\u00111\u001a3\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002P\u0006%'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!6\u0002\\B\u00191-a6\n\u0007\u0005eGMA\u0004C_>dW-\u00198\t\u0013\u0005}&#!AA\u0002\u0005]\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a'\u0002b\"I\u0011qX\n\u0002\u0002\u0003\u0007\u0011QV\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QV\u0001\ti>\u001cFO]5oOR\u0011\u00111T\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\u0017q\u001e\u0005\n\u0003\u007f3\u0012\u0011!a\u0001\u0003o\u000ba\"\u0012=fGV$\u0018n\u001c8Ti\u0006$8\u000fE\u0002\u0002ba\u0019R\u0001GA|\u0005\u0007\u0001B\"!?\u0002\u0000\u00065\u00111HA)\u0003?j!!a?\u000b\u0007\u0005uH-A\u0004sk:$\u0018.\\3\n\t\t\u0005\u00111 \u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B\u0003\u0005\u0017i!Aa\u0002\u000b\t\t%\u00111U\u0001\u0003S>LA!!\u0002\u0003\bQ\u0011\u00111_\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003?\u0012\u0019B!\u0006\u0003\u0018!9\u0011\u0011B\u000eA\u0002\u00055\u0001bBA\u001c7\u0001\u0007\u00111\b\u0005\b\u0003\u001bZ\u0002\u0019AA)\u0003\u001d)h.\u00199qYf$BA!\b\u0003*A)1Ma\b\u0003$%\u0019!\u0011\u00053\u0003\r=\u0003H/[8o!%\u0019'QEA\u0007\u0003w\t\t&C\u0002\u0003(\u0011\u0014a\u0001V;qY\u0016\u001c\u0004\"\u0003B\u00169\u0005\u0005\t\u0019AA0\u0003\rAH\u0005M\u0001\u0003S\u0012,\"A!\r\u0011\t\tM\"\u0011H\u0007\u0003\u0005kQAAa\u000e\u0002$\u0006!Q\u000f^5m\u0013\u0011\u0011YD!\u000e\u0003\tU+\u0016\nR\u0001\u0006eVt\u0017\nZ\u0001\u0005]\u0006lW-\u0006\u0002\u0002T\u0005aAO]5hO\u0016\u00148\t\\8dWV\u0011!q\t\t\u0005\u0005\u0013\u0012i%\u0004\u0002\u0003L)\u0019!q\u0007.\n\t\t=#1\n\u0002\u0006\u00072|7m[\u0001\fY><\u0017nY1m!2\fg.\u0006\u0002\u0003VA!!q\u000bB3\u001b\t\u0011IF\u0003\u0003\u0003\\\tu\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0005\u0005?\u0012\t'A\u0003qY\u0006t7OC\u0002\u0003da\u000b\u0001bY1uC2L8\u000f^\u0005\u0005\u0005O\u0012IFA\u0006M_\u001eL7-\u00197QY\u0006t\u0017!\u00047bgR,\u00050Z2vi&|g.\u0006\u0002\u0003nA!!q\u000eB9\u001b\u00051\u0016b\u0001B:-\nq\u0011+^3ss\u0016CXmY;uS>t\u0017a\u00028fo\u0012\u000bG/Y\u000b\u0003\u0005s\u0002\u0002\"a\u0004\u0002\u0018\u0005u!QK\u0001\u0013g&t7nQ8n[&$\bK]8he\u0016\u001c8/\u0006\u0002\u0003\u0000A)1Ma\b\u0003\u0002B!!1\u0011BG\u001b\t\u0011)I\u0003\u0003\u0003\b\n%\u0015A\u0001<3\u0015\r\u0011YIV\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0003\u0003\u0010\n\u0015%AG*ue\u0016\fWn\u0016:ji\u0016\u00148i\\7nSR\u0004&o\\4sKN\u001c\u0018aB:pkJ\u001cWm]\u000b\u0003\u0005+\u0003R!_A\u001f\u0003;\tAa]5oWV\u0011!1\u0014\t\u0005\u0005;\u0013\u0019+\u0004\u0002\u0003 *!!\u0011UA\u0014\u0003\u001d\u0019\u0017\r^1m_\u001eLAA!*\u0003 \n)A+\u00192mK\u0006\trN\u001a4tKR\u001cV-]'fi\u0006$\u0017\r^1\u0016\u0005\t-\u0006\u0003\u0002BW\u0005_k\u0011\u0001V\u0005\u0004\u0005c#&!E(gMN,GoU3r\u001b\u0016$\u0018\rZ1uC\u0006q1-\u001e:sK:$()\u0019;dQ&#WCAA\u0018\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\t\u0011Y\f\u0005\u0003\u0003>\n}V\"\u0001-\n\u0007\t\u0005\u0007L\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0005q_N$XI^3oiR\u0019\u0001Oa2\t\u000f\t%'\u00061\u0001\u0003L\u0006)QM^3oiB!!Q\u001aBj\u001d\u0011\t\u0019Ea4\n\t\tE\u0017QI\u0001\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe&!!Q\u001bBl\u0005\u0015)e/\u001a8u\u0015\u0011\u0011\t.!\u0012\u00029\r,(O]3oiR\u0013\u0018nZ4feN#\u0018M\u001d;US6,7\u000f^1na\u0006\u00013-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1siRKW.Z:uC6\u0004x\fJ3r)\r\u0001(q\u001c\u0005\n\u0003\u007fc\u0013\u0011!a\u0001\u0003_\t!dY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e)&lWm\u001d;b[B\fadY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e)&lWm\u001d;b[B|F%Z9\u0015\u0007A\u00149\u000fC\u0005\u0002@:\n\t\u00111\u0001\u00020\u0005Q2-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1si>3gm]3ugV\u0011!Q\u001e\t\t\u0003\u001f\t9\"!\b\u0002T\u0005q2-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1si>3gm]3ug~#S-\u001d\u000b\u0004a\nM\b\"CA`a\u0005\u0005\t\u0019\u0001Bw\u0003a\u0019WO\u001d:f]R$&/[4hKJ,e\u000eZ(gMN,Go]\u0001\u001dGV\u0014(/\u001a8u)JLwmZ3s\u000b:$wJ\u001a4tKR\u001cx\fJ3r)\r\u0001(1 \u0005\n\u0003\u007f\u0013\u0014\u0011!a\u0001\u0005[\f1dY;se\u0016tG\u000f\u0016:jO\u001e,'\u000fT1uKN$xJ\u001a4tKR\u001c\u0018aH2veJ,g\u000e\u001e+sS\u001e<WM\u001d'bi\u0016\u001cHo\u00144gg\u0016$8o\u0018\u0013fcR\u0019\u0001oa\u0001\t\u0013\u0005}F'!AA\u0002\t5\u0018!\u00077bgR$&/[4hKJ\u001cF/\u0019:u)&lWm\u001d;b[B\fQ\u0004\\1tiR\u0013\u0018nZ4feN#\u0018M\u001d;US6,7\u000f^1na~#S-\u001d\u000b\u0004a\u000e-\u0001\"CA`m\u0005\u0005\t\u0019AA\u0018\u0003I\u0019WO\u001d:f]R$UO]1uS>t7/T:\u0016\u0005\rE\u0001\u0003CB\n\u00073\t\u0019&a\f\u000e\u0005\rU!\u0002BB\f\u0003\u0013\fq!\\;uC\ndW-\u0003\u0003\u0004\u001c\rU!a\u0002%bg\"l\u0015\r]\u0001\u0014[\u0016$(/[2XCJt\u0017N\\4M_\u001e<W\rZ\u000b\u0003\u0003+\fq#\\3ue&\u001cw+\u0019:oS:<Gj\\4hK\u0012|F%Z9\u0015\u0007A\u001c)\u0003C\u0005\u0002@f\n\t\u00111\u0001\u0002V\u0006q\u0001O]8he\u0016\u001c8OQ;gM\u0016\u0014XCAB\u0016!\u0019\u0019\u0019b!\f\u00042%!1qFB\u000b\u0005\u0015\tV/Z;f!\u0011\t\u0019ea\r\n\t\rU\u0012Q\t\u0002\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z!J|wM]3tg\u0006Ybn\u001c#bi\u0006\u0004&o\\4sKN\u001cXI^3oi&sG/\u001a:wC2\f\u0001\u0005\\1ti:{W\t_3dkRLwN\u001c)s_\u001e\u0014Xm]:Fm\u0016tG\u000fV5nK\u0006!C.Y:u\u001d>,\u00050Z2vi&|g\u000e\u0015:pOJ,7o]#wK:$H+[7f?\u0012*\u0017\u000fF\u0002q\u0007\u007fA\u0011\"a0>\u0003\u0003\u0005\r!a\f\u0002\u001fQLW.Z:uC6\u0004hi\u001c:nCR,\"a!\u0012\u0011\t\r\u001d3QJ\u0007\u0003\u0007\u0013RAaa\u0013\u0002$\u0006!A/\u001a=u\u0013\u0011\u0019ye!\u0013\u0003!MKW\u000e\u001d7f\t\u0006$XMR8s[\u0006$\u0018!D2veJ,g\u000e^*uCR,8/\u0006\u0002\u0004VA!\u00111IB,\u0013\u0011\u0019I&!\u0012\u0003)M#(/Z1nS:<\u0017+^3ssN#\u0018\r^;tQ\ry4Q\f\t\u0004G\u000e}\u0013bAB1I\nAao\u001c7bi&dW-A\tdkJ\u0014XM\u001c;Ti\u0006$Xo]0%KF$2\u0001]B4\u0011%\ty\fQA\u0001\u0002\u0004\u0019)&\u0001\u000bmCR,7\u000f^*ue\u0016\fW\u000e\u0015:pOJ,7o]\u000b\u0003\u0007[\u0002BA!,\u0004p%\u00191\u0011\u000f+\u0003\u001dM#(/Z1n!J|wM]3tg\u0006AB.\u0019;fgR\u001cFO]3b[B\u0013xn\u001a:fgN|F%Z9\u0015\u0007A\u001c9\bC\u0005\u0002@\n\u000b\t\u00111\u0001\u0004n\u000511\u000f^1ukN\faB]3dK:$\bK]8he\u0016\u001c8/\u0006\u0002\u0004\u0000A)1m!!\u00042%\u001911\u00113\u0003\u000b\u0005\u0013(/Y=\u0002\u00191\f7\u000f\u001e)s_\u001e\u0014Xm]:\u0016\u0005\rE\u0012\u0001D:uCJ$HK]5hO\u0016\u0014\u0018\u0001\u0006:fG>\u0014H\r\u0016:jO\u001e,'o\u00144gg\u0016$8\u000fF\u0004q\u0007\u001f\u001b\u0019ja&\t\u000f\rEu\t1\u0001\u0004n\u0005!aM]8n\u0011\u001d\u0019)j\u0012a\u0001\u0007[\n!\u0001^8\t\u000f\reu\t1\u0001\u0004n\u00051A.\u0019;fgR\fa\"\u00193e\u001d\u0016<\bK]8he\u0016\u001c8\u000fF\u0002q\u0007?Cqa!)I\u0001\u0004\u0019\t$A\u0006oK^\u0004&o\\4sKN\u001c\u0018AD;qI\u0006$X\r\u0015:pOJ,7o\u001d\u000b\u0004a\u000e\u001d\u0006bBBQ\u0013\u0002\u00071\u0011G\u0001\u000fkB$\u0017\r^3JI2,g.Z:t)\r\u00018Q\u0016\u0005\b\u0007CS\u0005\u0019AB\u0019\u000351\u0017N\\5tQR\u0013\u0018nZ4feR)\u0001oa-\u00048\"91QW&A\u0002\u0005U\u0017A\u00035bg:+w\u000fR1uC\"91\u0011X&A\u0002\u0005U\u0017a\u00035bg\u0016CXmY;uK\u0012\f1$\u001a=ue\u0006\u001cGo\u0015;bi\u0016|\u0005/\u001a:bi>\u0014X*\u001a;sS\u000e\u001cH\u0003BA\u001e\u0007\u007fCqa!/M\u0001\u0004\t).A\u000bfqR\u0014\u0018m\u0019;Fq\u0016\u001cW\u000f^5p]N#\u0018\r^:\u0015\r\u0005}3QYBd\u0011\u001d\u0019),\u0014a\u0001\u0003+Dqa!/N\u0001\u0004\t).A\u000efqR\u0014\u0018m\u0019;T_V\u00148-\u001a+p\u001dVl\u0017J\u001c9viJ{wo\u001d\u000b\u0003\u0003\u001b\ta#\u001a=ue\u0006\u001cGo\u00142tKJ4X\rZ'fiJL7m\u001d\u000b\u0007\u0007#\u001cIna7\u0011\u0011\u0005=\u0011qCA*\u0007'\u0004BA!0\u0004V&\u00191q\u001b-\u0003\u0007I{w\u000fC\u0004\u00046>\u0003\r!!6\t\u000f\t%t\n1\u0001\u0003n\u0005y!/\u001a9peR$\u0016.\\3UC.,g.\u0006\u0003\u0004b\u000e%H\u0003BBr\u0007\u007f$Ba!:\u0004vB!1q]Bu\u0019\u0001!qaa;Q\u0005\u0004\u0019iOA\u0001U#\u0011\u0019y/a.\u0011\u0007\r\u001c\t0C\u0002\u0004t\u0012\u0014qAT8uQ&tw\r\u0003\u0005\u0004xB#\t\u0019AB}\u0003\u0011\u0011w\u000eZ=\u0011\u000b\r\u001cYp!:\n\u0007\ruHM\u0001\u0005=Eft\u0017-\\3?\u0011\u001d!\t\u0001\u0015a\u0001\u0003'\n\u0001\u0003\u001e:jO\u001e,'\u000fR3uC&d7*Z=\u0002\u001f\u0019|'/\\1u)&lWm\u001d;b[B$B!a\u0015\u0005\b!9A\u0011B)A\u0002\u0005=\u0012AB7jY2L7/A\nva\u0012\fG/Z*uCR,8/T3tg\u0006<W\rF\u0002q\t\u001fAq\u0001\"\u0005S\u0001\u0004\t\u0019&A\u0004nKN\u001c\u0018mZ3")
public interface ProgressReporter
extends Logging {
    public ProgressReporter$ExecutionStats$ ExecutionStats();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq(scala.collection.mutable.HashMap<String, Object> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq(Queue<StreamingQueryProgress> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq(long var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(SimpleDateFormat var1);

    public UUID id();

    public UUID runId();

    public String name();

    public Clock triggerClock();

    public LogicalPlan logicalPlan();

    public QueryExecution lastExecution();

    public scala.collection.immutable.Map<SparkDataStream, LogicalPlan> newData();

    public Option<StreamWriterCommitProgress> sinkCommitProgress();

    public Seq<SparkDataStream> sources();

    public Table sink();

    public OffsetSeqMetadata offsetSeqMetadata();

    public long currentBatchId();

    public SparkSession sparkSession();

    public void postEvent(StreamingQueryListener.Event var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(long var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(long var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(long var1);

    public scala.collection.mutable.HashMap<String, Object> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs();

    public boolean org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(boolean var1);

    public Queue<StreamingQueryProgress> org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(long var1);

    public SimpleDateFormat org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat();

    public StreamingQueryStatus currentStatus();

    public void currentStatus_$eq(StreamingQueryStatus var1);

    public StreamProgress org$apache$spark$sql$execution$streaming$ProgressReporter$$latestStreamProgress();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$latestStreamProgress_$eq(StreamProgress var1);

    public static /* synthetic */ StreamingQueryStatus status$(ProgressReporter $this) {
        return $this.status();
    }

    default public StreamingQueryStatus status() {
        return this.currentStatus();
    }

    public static /* synthetic */ StreamingQueryProgress[] recentProgress$(ProgressReporter $this) {
        return $this.recentProgress();
    }

    default public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public static /* synthetic */ StreamingQueryProgress lastProgress$(ProgressReporter $this) {
        return $this.lastProgress();
    }

    default public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().lastOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQueryProgress;
    }

    public static /* synthetic */ void startTrigger$(ProgressReporter $this) {
        $this.startTrigger();
    }

    default public void startTrigger() {
        this.logDebug((Function0 & Serializable)() -> "Starting Trigger Calculation");
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(this.triggerClock().getTimeMillis());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().clear();
    }

    public static /* synthetic */ void recordTriggerOffsets$(ProgressReporter $this, StreamProgress from, StreamProgress to, StreamProgress latest) {
        $this.recordTriggerOffsets(from, to, latest);
    }

    default public void recordTriggerOffsets(StreamProgress from, StreamProgress to, StreamProgress latest) {
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq((scala.collection.immutable.Map<SparkDataStream, String>)((scala.collection.immutable.Map)from.transform((Function2 & Serializable)(x$5, v) -> v.json())));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq((scala.collection.immutable.Map<SparkDataStream, String>)((scala.collection.immutable.Map)to.transform((Function2 & Serializable)(x$6, v) -> v.json())));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets_$eq((scala.collection.immutable.Map<SparkDataStream, String>)((scala.collection.immutable.Map)latest.transform((Function2 & Serializable)(x$7, v) -> v.json())));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$latestStreamProgress_$eq(to);
    }

    private void addNewProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().$plus$eq((Object)newProgress);
            while (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().length() >= this.sparkSession().sessionState().conf().streamingProgressRetention()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().dequeue();
            }
        }
    }

    private void updateProgress(StreamingQueryProgress newProgress) {
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(this.triggerClock().getTimeMillis());
        this.addNewProgress(newProgress);
        this.postEvent(new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo((Function0 & Serializable)() -> "Streaming query made progress: " + newProgress);
    }

    private void updateIdleness(StreamingQueryProgress newProgress) {
        long now = this.triggerClock().getTimeMillis();
        if (now - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval() >= this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime()) {
            this.addNewProgress(newProgress);
            if (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime() > Long.MIN_VALUE) {
                this.postEvent(new StreamingQueryListener.QueryIdleEvent(newProgress.id(), newProgress.runId(), this.formatTimestamp(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp())));
                this.logInfo((Function0 & Serializable)() -> "Streaming query has been idle and waiting for new data more than " + this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval() + " ms.");
            }
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(now);
            return;
        }
    }

    public static /* synthetic */ void finishTrigger$(ProgressReporter $this, boolean hasNewData, boolean hasExecuted) {
        $this.finishTrigger(hasNewData, hasExecuted);
    }

    default public void finishTrigger(boolean hasNewData, boolean hasExecuted) {
        java.util.Map map;
        Predef$.MODULE$.assert(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets() != null && this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets() != null && this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets() != null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(this.triggerClock().getTimeMillis());
        ExecutionStats executionStats = this.extractExecutionStats(hasNewData, hasExecuted);
        long processingTimeMills = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();
        double processingTimeSec = (double)Math.max(1L, processingTimeMills) / (double)1000L;
        double inputTimeSec = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp() >= 0L ? (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp()) / (double)1000L : Double.POSITIVE_INFINITY;
        this.logDebug((Function0 & Serializable)() -> "Execution stats: " + executionStats);
        Seq sourceProgress = (Seq)((IterableOps)this.sources().distinct()).map((Function1 & Serializable)source -> {
            java.util.Map map;
            long numRecords = BoxesRunTime.unboxToLong((Object)executionStats.inputRows().getOrElse(source, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            SparkDataStream sparkDataStream = source;
            if (sparkDataStream instanceof ReportsSourceMetrics) {
                ReportsSourceMetrics reportsSourceMetrics = (ReportsSourceMetrics)sparkDataStream;
                map = reportsSourceMetrics.metrics(Optional.ofNullable(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$latestStreamProgress().get((SparkDataStream)source).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            } else {
                map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava();
            }
            java.util.Map sourceMetrics = map;
            return new SourceProgress(source.toString(), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets().get(source).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets().get(source).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerLatestOffsets().get(source).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), numRecords, (double)numRecords / inputTimeSec, (double)numRecords / processingTimeSec, sourceMetrics);
        });
        Option sinkOutput = hasExecuted ? this.sinkCommitProgress().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.numOutputRows())) : this.sinkCommitProgress().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$finishTrigger$5(x$9)));
        Table table = this.sink();
        if (table instanceof ReportsSinkMetrics) {
            Table table2 = table;
            map = ((ReportsSinkMetrics)table2).metrics();
        } else {
            map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava();
        }
        java.util.Map sinkMetrics = map;
        SinkProgress sinkProgress = SinkProgress$.MODULE$.apply(this.sink().toString(), (Option<Object>)sinkOutput, sinkMetrics);
        scala.collection.immutable.Map<String, Row> observedMetrics = this.extractObservedMetrics(hasNewData, this.lastExecution());
        StreamingQueryProgress newProgress = new StreamingQueryProgress(this.id(), this.runId(), this.name(), this.formatTimestamp(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()), this.currentBatchId(), processingTimeMills, new HashMap<String, Long>(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).transform((Function2 & Serializable)(x$10, v) -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)v)))).asJava()), new HashMap<String, String>(CollectionConverters$.MODULE$.MapHasAsJava(executionStats.eventTimeStats()).asJava()), (StateOperatorProgress[])executionStats.stateOperators().toArray(ClassTag$.MODULE$.apply(StateOperatorProgress.class)), (SourceProgress[])sourceProgress.toArray(ClassTag$.MODULE$.apply(SourceProgress.class)), sinkProgress, new HashMap<String, Row>(CollectionConverters$.MODULE$.MapHasAsJava(observedMetrics).asJava()));
        if (hasExecuted) {
            this.updateProgress(newProgress);
        } else {
            this.updateIdleness(newProgress);
        }
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = false;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, false));
    }

    private Seq<StateOperatorProgress> extractStateOperatorMetrics(boolean hasExecuted) {
        if (this.lastExecution() == null) {
            return Nil$.MODULE$;
        }
        return this.lastExecution().executedPlan().collect((PartialFunction)new Serializable(null, hasExecuted){
            private static final long serialVersionUID = 0L;
            private final boolean hasExecuted$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StateStoreWriter) {
                    StateOperatorProgress progress = ((StateStoreWriter)((Object)A1)).getProgress();
                    if (this.hasExecuted$1) {
                        return (B1)progress;
                    }
                    return (B1)progress.copy(0L, 0L);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof StateStoreWriter;
            }
            {
                this.hasExecuted$1 = hasExecuted$1;
            }
        });
    }

    private ExecutionStats extractExecutionStats(boolean hasNewData, boolean hasExecuted) {
        boolean hasEventTime = this.logicalPlan().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermark) {
                    EventTimeWatermark eventTimeWatermark = (EventTimeWatermark)A1;
                    return (B1)eventTimeWatermark;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof EventTimeWatermark;
            }
        }).nonEmpty();
        scala.collection.immutable.Map watermarkTimestamp = hasEventTime ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"watermark"), (Object)this.formatTimestamp(this.offsetSeqMetadata().batchWatermarkMs()))})) : Predef$.MODULE$.Map().empty();
        Seq<StateOperatorProgress> stateOperators = this.extractStateOperatorMetrics(hasExecuted);
        if (!hasNewData) {
            return new ExecutionStats(this, (scala.collection.immutable.Map<SparkDataStream, Object>)Predef$.MODULE$.Map().empty(), stateOperators, (scala.collection.immutable.Map<String, String>)watermarkTimestamp);
        }
        scala.collection.immutable.Map<SparkDataStream, Object> numInputRows = this.extractSourceToNumInputRows();
        scala.collection.immutable.Map eventTimeStats = (scala.collection.immutable.Map)((MapOps)this.lastExecution().executedPlan().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ProgressReporter $outer;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                EventTimeWatermarkExec eventTimeWatermarkExec;
                A1 A1 = x2;
                if (A1 instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)A1).eventTimeStats().value().count() > 0L) {
                    EventTimeStats stats = eventTimeWatermarkExec.eventTimeStats().value();
                    return (B1)((scala.collection.immutable.MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)BoxesRunTime.boxToLong((long)stats.max())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)BoxesRunTime.boxToLong((long)stats.min())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avg"), (Object)BoxesRunTime.boxToLong((long)((long)stats.avg())))}))).transform((Function2 & Serializable)(x$11, v) -> $anonfun$2.$anonfun$applyOrElse$1(this, x$11, BoxesRunTime.unboxToLong((Object)v)));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                EventTimeWatermarkExec eventTimeWatermarkExec;
                SparkPlan sparkPlan = x2;
                return sparkPlan instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)sparkPlan).eventTimeStats().value().count() > 0L;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$2 $this, String x$11, long v) {
                return $this.$outer.formatTimestamp(v);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.execution.streaming.ProgressReporter$$anonfun$2 java.lang.String java.lang.Object )}, serializedLambda);
            }
        }).headOption().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((IterableOnce)watermarkTimestamp);
        return new ExecutionStats(this, numInputRows, stateOperators, (scala.collection.immutable.Map<String, String>)eventTimeStats);
    }

    private scala.collection.immutable.Map<SparkDataStream, Object> extractSourceToNumInputRows() {
        block2: {
            Seq allStreamingLeaves = this.logicalPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof StreamingDataSourceV2Relation) {
                        StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                        return (B1)BoxesRunTime.boxToBoolean((boolean)(streamingDataSourceV2Relation.stream() instanceof MicroBatchStream));
                    }
                    if (A1 instanceof StreamingExecutionRelation) {
                        return (B1)BoxesRunTime.boxToBoolean((boolean)false);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan2 = x1;
                    if (logicalPlan2 instanceof StreamingDataSourceV2Relation) {
                        return true;
                    }
                    return logicalPlan2 instanceof StreamingExecutionRelation;
                }
            });
            boolean onlyDataSourceV2Sources = allStreamingLeaves.forall((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ProgressReporter.$anonfun$extractSourceToNumInputRows$5(BoxesRunTime.unboxToBoolean((Object)x$15))));
            if (onlyDataSourceV2Sources) {
                Seq sourceToInputRowsTuples = this.lastExecution().executedPlan().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof MicroBatchScanExec) {
                            MicroBatchScanExec microBatchScanExec = (MicroBatchScanExec)A1;
                            long numRows = BoxesRunTime.unboxToLong((Object)microBatchScanExec.metrics().get((Object)"numOutputRows").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)$anonfun$4.$anonfun$applyOrElse$2(x$16))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                            MicroBatchStream source = microBatchScanExec.stream();
                            return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(SparkPlan x2) {
                        SparkPlan sparkPlan = x2;
                        return sparkPlan instanceof MicroBatchScanExec;
                    }

                    public static final /* synthetic */ long $anonfun$applyOrElse$2(SQLMetric x$16) {
                        return x$16.value();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2$adapted(org.apache.spark.sql.execution.metric.SQLMetric ), $anonfun$applyOrElse$3()}, serializedLambda);
                    }
                });
                this.logDebug((Function0 & Serializable)() -> "Source -> # input rows\n\t" + sourceToInputRowsTuples.mkString("\n\t"));
                return ProgressReporter.sumRows$1(sourceToInputRowsTuples);
            }
            scala.collection.immutable.Map logicalPlanLeafToSource = (scala.collection.immutable.Map)this.newData().flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    SparkDataStream source = (SparkDataStream)tuple2._1();
                    LogicalPlan logicalPlan2 = (LogicalPlan)tuple2._2();
                    return (Seq)logicalPlan2.collectLeaves().map((Function1 & Serializable)leaf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(leaf), (Object)source));
                }
                throw new MatchError((Object)tuple2);
            });
            LogicalPlan finalLogicalPlan = ProgressReporter.unrollCTE$1(this.lastExecution().logical());
            Seq allLogicalPlanLeaves = finalLogicalPlan.collectLeaves();
            Seq allExecPlanLeaves = this.lastExecution().executedPlan().collectLeaves();
            if (allLogicalPlanLeaves.size() == allExecPlanLeaves.size()) {
                Seq execLeafToSource = (Seq)((IterableOps)allLogicalPlanLeaves.zip((IterableOnce)allExecPlanLeaves)).flatMap((Function1 & Serializable)x0$2 -> {
                    SparkPlan ep;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null && (ep = (SparkPlan)tuple2._2()) instanceof MicroBatchScanExec) {
                        MicroBatchScanExec microBatchScanExec = (MicroBatchScanExec)ep;
                        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchScanExec), (Object)microBatchScanExec.stream()));
                    }
                    if (tuple2 != null) {
                        LogicalPlan lp = (LogicalPlan)tuple2._1();
                        SparkPlan ep2 = (SparkPlan)tuple2._2();
                        return logicalPlanLeafToSource.get((Object)lp).map((Function1 & Serializable)source -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep2), source));
                    }
                    throw new MatchError((Object)tuple2);
                });
                Seq sourceToInputRowsTuples = (Seq)execLeafToSource.map((Function1 & Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        SparkPlan execLeaf = (SparkPlan)tuple2._1();
                        SparkDataStream source = (SparkDataStream)tuple2._2();
                        long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return ProgressReporter.sumRows$1(sourceToInputRowsTuples);
            }
            if (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged()) break block2;
            this.logWarning((Function0 & Serializable)() -> "Could not report metrics as number leaves in trigger logical plan did not match that of the execution plan:\nlogical plan leaves: " + ProgressReporter.toString$1(allLogicalPlanLeaves) + "\nexecution plan leaves: " + ProgressReporter.toString$1(allExecPlanLeaves) + "\n");
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(true);
        }
        return Predef$.MODULE$.Map().empty();
    }

    private scala.collection.immutable.Map<String, Row> extractObservedMetrics(boolean hasNewData, QueryExecution lastExecution) {
        if (!hasNewData || lastExecution == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return lastExecution.observedMetrics();
    }

    public static /* synthetic */ Object reportTimeTaken$(ProgressReporter $this, String triggerDetailKey, Function0 body) {
        return $this.reportTimeTaken(triggerDetailKey, body);
    }

    default public <T> T reportTimeTaken(String triggerDetailKey, Function0<T> body) {
        long startTime = this.triggerClock().getTimeMillis();
        Object result = body.apply();
        long endTime = this.triggerClock().getTimeMillis();
        long timeTaken = package$.MODULE$.max(endTime - startTime, 0L);
        long previousTime = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().getOrElse((Object)triggerDetailKey, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().put((Object)triggerDetailKey, (Object)BoxesRunTime.boxToLong((long)(previousTime + timeTaken)));
        this.logDebug((Function0 & Serializable)() -> triggerDetailKey + " took " + timeTaken + " ms");
        return (T)result;
    }

    public static /* synthetic */ String formatTimestamp$(ProgressReporter $this, long millis) {
        return $this.formatTimestamp(millis);
    }

    default public String formatTimestamp(long millis) {
        return this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().format(new Date(millis));
    }

    public static /* synthetic */ void updateStatusMessage$(ProgressReporter $this, String message) {
        $this.updateStatusMessage(message);
    }

    default public void updateStatusMessage(String message) {
        StreamingQueryStatus qual$1 = this.currentStatus();
        String x$1 = message;
        boolean x$2 = qual$1.copy$default$2();
        boolean x$3 = qual$1.copy$default$3();
        this.currentStatus_$eq(qual$1.copy(x$1, x$2, x$3));
    }

    public static /* synthetic */ long $anonfun$finishTrigger$5(StreamWriterCommitProgress x$9) {
        return 0L;
    }

    public static /* synthetic */ long $anonfun$extractSourceToNumInputRows$2(SparkDataStream x$13, Seq v) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)v.map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14._2$mcJ$sp()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private static scala.collection.immutable.Map sumRows$1(Seq tuples) {
        return (scala.collection.immutable.Map)tuples.groupBy((Function1 & Serializable)x$12 -> (SparkDataStream)x$12._1()).transform((Function2 & Serializable)(x$13, v) -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$extractSourceToNumInputRows$2(x$13, v)));
    }

    public static /* synthetic */ boolean $anonfun$extractSourceToNumInputRows$4(LogicalPlan x0$1) {
        LogicalPlan logicalPlan2 = x0$1;
        return logicalPlan2 instanceof WithCTE;
    }

    private static LogicalPlan unrollCTE$1(LogicalPlan plan) {
        boolean containsCTE = plan.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProgressReporter.$anonfun$extractSourceToNumInputRows$4(x0$1)));
        if (containsCTE) {
            return new InlineCTE(true).apply(plan);
        }
        return plan;
    }

    public static /* synthetic */ boolean $anonfun$extractSourceToNumInputRows$5(boolean x$15) {
        return x$15;
    }

    private static String toString$1(Seq seq) {
        return "(size = " + seq.size() + "), " + seq.mkString(", ");
    }

    public static void $init$(ProgressReporter $this) {
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq((scala.collection.mutable.HashMap<String, Object>)new scala.collection.mutable.HashMap());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(false);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq((Queue<StreamingQueryProgress>)new Queue(Queue$.MODULE$.$lessinit$greater$default$1()));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq($this.sparkSession().sessionState().conf().streamingNoDataProgressEventInterval());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(Long.MIN_VALUE);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().setTimeZone(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        $this.currentStatus_$eq(new StreamingQueryStatus("Initializing StreamExecution", false, false));
    }

    public class ExecutionStats
    implements Product,
    Serializable {
        private final scala.collection.immutable.Map<SparkDataStream, Object> inputRows;
        private final Seq<StateOperatorProgress> stateOperators;
        private final scala.collection.immutable.Map<String, String> eventTimeStats;
        public final /* synthetic */ ProgressReporter $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Map<SparkDataStream, Object> inputRows() {
            return this.inputRows;
        }

        public Seq<StateOperatorProgress> stateOperators() {
            return this.stateOperators;
        }

        public scala.collection.immutable.Map<String, String> eventTimeStats() {
            return this.eventTimeStats;
        }

        public ExecutionStats copy(scala.collection.immutable.Map<SparkDataStream, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            return new ExecutionStats(this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer(), inputRows, stateOperators, eventTimeStats);
        }

        public scala.collection.immutable.Map<SparkDataStream, Object> copy$default$1() {
            return this.inputRows();
        }

        public Seq<StateOperatorProgress> copy$default$2() {
            return this.stateOperators();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.eventTimeStats();
        }

        public String productPrefix() {
            return "ExecutionStats";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.inputRows();
                }
                case 1: {
                    return this.stateOperators();
                }
                case 2: {
                    return this.eventTimeStats();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExecutionStats;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "inputRows";
                }
                case 1: {
                    return "stateOperators";
                }
                case 2: {
                    return "eventTimeStats";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExecutionStats)) return false;
            if (((ExecutionStats)object).org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() != this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ExecutionStats executionStats = (ExecutionStats)x$1;
            scala.collection.immutable.Map<SparkDataStream, Object> map = this.inputRows();
            scala.collection.immutable.Map<SparkDataStream, Object> map2 = executionStats.inputRows();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Seq<StateOperatorProgress> seq = this.stateOperators();
            Seq<StateOperatorProgress> seq2 = executionStats.stateOperators();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            scala.collection.immutable.Map<String, String> map3 = this.eventTimeStats();
            scala.collection.immutable.Map<String, String> map4 = executionStats.eventTimeStats();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (!executionStats.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ProgressReporter org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() {
            return this.$outer;
        }

        public ExecutionStats(ProgressReporter $outer, scala.collection.immutable.Map<SparkDataStream, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            this.inputRows = inputRows;
            this.stateOperators = stateOperators;
            this.eventTimeStats = eventTimeStats;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

