/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\u0011\"\u0001:B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003W\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u001d\u0011\u0007A1A\u0005\n\rDaa\u001a\u0001!\u0002\u0013!\u0007\"\u00025\u0001\t\u0003J\u0007\"B;\u0001\t\u00031\b\"B=\u0001\t\u0003Q\bbB?\u0001\u0003\u0003%\tA \u0005\n\u0003\u0007\u0001\u0011\u0013!C\u0001\u0003\u000bA\u0011\"a\u0007\u0001#\u0003%\t!!\b\t\u0013\u0005\u0005\u0002!!A\u0005B\u0005\r\u0002\"CA\u001b\u0001\u0005\u0005I\u0011AA\u001c\u0011%\ty\u0004AA\u0001\n\u0003\t\t\u0005C\u0005\u0002N\u0001\t\t\u0011\"\u0011\u0002P!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011q\f\u0005\n\u0003G\u0002\u0011\u0011!C!\u0003KB\u0011\"!\u001b\u0001\u0003\u0003%\t%a\u001b\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0004\"CA9\u0001\u0005\u0005I\u0011IA:\u000f%\t9(IA\u0001\u0012\u0003\tIH\u0002\u0005!C\u0005\u0005\t\u0012AA>\u0011\u0019i\u0006\u0004\"\u0001\u0002\u0014\"I\u0011Q\u000e\r\u0002\u0002\u0013\u0015\u0013q\u000e\u0005\n\u0003+C\u0012\u0011!CA\u0003/C\u0011\"!(\u0019#\u0003%\t!!\b\t\u0013\u0005}\u0005$!A\u0005\u0002\u0006\u0005\u0006\"CAZ1E\u0005I\u0011AA\u000f\u0011%\t)\fGA\u0001\n\u0013\t9L\u0001\fQe>\u001cWm]:j]\u001e$\u0016.\\3Fq\u0016\u001cW\u000f^8s\u0015\t\u00113%A\u0005tiJ,\u0017-\\5oO*\u0011A%J\u0001\nKb,7-\u001e;j_:T!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00186s}\u0012\u0005C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00027o5\t\u0011%\u0003\u00029C\tyAK]5hO\u0016\u0014X\t_3dkR|'\u000f\u0005\u0002;{5\t1H\u0003\u0002=O\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002?w\t9Aj\\4hS:<\u0007C\u0001\u0019A\u0013\t\t\u0015GA\u0004Qe>$Wo\u0019;\u0011\u0005\r[eB\u0001#J\u001d\t)\u0005*D\u0001G\u0015\t9U&\u0001\u0004=e>|GOP\u0005\u0002e%\u0011!*M\u0001\ba\u0006\u001c7.Y4f\u0013\taUJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Kc\u0005)\u0002O]8dKN\u001c\u0018N\\4US6,GK]5hO\u0016\u0014X#\u0001)\u0011\u0005Y\n\u0016B\u0001*\"\u0005U\u0001&o\\2fgNLgn\u001a+j[\u0016$&/[4hKJ\fa\u0003\u001d:pG\u0016\u001c8/\u001b8h)&lW\r\u0016:jO\u001e,'\u000fI\u0001\u0006G2|7m[\u000b\u0002-B\u0011qKW\u0007\u00021*\u0011\u0011lJ\u0001\u0005kRLG.\u0003\u0002\\1\n)1\t\\8dW\u000611\r\\8dW\u0002\na\u0001P5oSRtDcA0aCB\u0011a\u0007\u0001\u0005\u0006\u001d\u0016\u0001\r\u0001\u0015\u0005\b)\u0016\u0001\n\u00111\u0001W\u0003)Ig\u000e^3sm\u0006dWj]\u000b\u0002IB\u0011\u0001'Z\u0005\u0003MF\u0012A\u0001T8oO\u0006Y\u0011N\u001c;feZ\fG.T:!\u0003\u001d)\u00070Z2vi\u0016$\"A[7\u0011\u0005AZ\u0017B\u000172\u0005\u0011)f.\u001b;\t\u000b9D\u0001\u0019A8\u0002\u001dQ\u0014\u0018nZ4fe\"\u000bg\u000e\u001a7feB\u0019\u0001\u0007\u001d:\n\u0005E\f$!\u0003$v]\u000e$\u0018n\u001c81!\t\u00014/\u0003\u0002uc\t9!i\\8mK\u0006t\u0017\u0001\u00078pi&4\u0017PQ1uG\"4\u0015\r\u001c7j]\u001e\u0014U\r[5oIR\u0011!n\u001e\u0005\u0006q&\u0001\r\u0001Z\u0001\u0012e\u0016\fG.\u00127baN,G\rV5nK6\u001b\u0018!\u00048fqR\u0014\u0015\r^2i)&lW\r\u0006\u0002ew\")AP\u0003a\u0001I\u0006\u0019an\\<\u0002\t\r|\u0007/\u001f\u000b\u0005?~\f\t\u0001C\u0004O\u0017A\u0005\t\u0019\u0001)\t\u000fQ[\u0001\u0013!a\u0001-\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0004U\r\u0001\u0016\u0011B\u0016\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011QC\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0010U\r1\u0016\u0011B\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0005Y\u0006twM\u0003\u0002\u00020\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\u000b\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0004E\u00021\u0003wI1!!\u00102\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019%!\u0013\u0011\u0007A\n)%C\u0002\u0002HE\u00121!\u00118z\u0011%\tY\u0005EA\u0001\u0002\u0004\tI$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003#\u0002b!a\u0015\u0002Z\u0005\rSBAA+\u0015\r\t9&M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA.\u0003+\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019!/!\u0019\t\u0013\u0005-##!AA\u0002\u0005\r\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\n\u0002h!I\u00111J\n\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011H\u0001\ti>\u001cFO]5oOR\u0011\u0011QE\u0001\u0007KF,\u0018\r\\:\u0015\u0007I\f)\bC\u0005\u0002LY\t\t\u00111\u0001\u0002D\u00051\u0002K]8dKN\u001c\u0018N\\4US6,W\t_3dkR|'\u000f\u0005\u000271M)\u0001$! \u0002\nB9\u0011qPAC!Z{VBAAA\u0015\r\t\u0019)M\u0001\beVtG/[7f\u0013\u0011\t9)!!\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002\f\u0006EUBAAG\u0015\u0011\ty)!\f\u0002\u0005%|\u0017b\u0001'\u0002\u000eR\u0011\u0011\u0011P\u0001\u0006CB\u0004H.\u001f\u000b\u0006?\u0006e\u00151\u0014\u0005\u0006\u001dn\u0001\r\u0001\u0015\u0005\b)n\u0001\n\u00111\u0001W\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003G\u000by\u000bE\u00031\u0003K\u000bI+C\u0002\u0002(F\u0012aa\u00149uS>t\u0007#\u0002\u0019\u0002,B3\u0016bAAWc\t1A+\u001e9mKJB\u0001\"!-\u001e\u0003\u0003\u0005\raX\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002:B!\u0011qEA^\u0013\u0011\ti,!\u000b\u0003\r=\u0013'.Z2u\u0001")
public class ProcessingTimeExecutor
implements TriggerExecutor,
Logging,
Product,
Serializable {
    private final ProcessingTimeTrigger processingTimeTrigger;
    private final Clock clock;
    private final long intervalMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$2() {
        return ProcessingTimeExecutor$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<ProcessingTimeTrigger, Clock>> unapply(ProcessingTimeExecutor x$0) {
        return ProcessingTimeExecutor$.MODULE$.unapply(x$0);
    }

    public static Clock apply$default$2() {
        return ProcessingTimeExecutor$.MODULE$.apply$default$2();
    }

    public static ProcessingTimeExecutor apply(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        return ProcessingTimeExecutor$.MODULE$.apply(processingTimeTrigger, clock);
    }

    public static Function1<Tuple2<ProcessingTimeTrigger, Clock>, ProcessingTimeExecutor> tupled() {
        return ProcessingTimeExecutor$.MODULE$.tupled();
    }

    public static Function1<ProcessingTimeTrigger, Function1<Clock, ProcessingTimeExecutor>> curried() {
        return ProcessingTimeExecutor$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ProcessingTimeTrigger processingTimeTrigger() {
        return this.processingTimeTrigger;
    }

    public Clock clock() {
        return this.clock;
    }

    private long intervalMs() {
        return this.intervalMs;
    }

    @Override
    public void execute(Function0<Object> triggerHandler) {
        while (true) {
            Object object;
            boolean terminated;
            long triggerTimeMs = this.clock().getTimeMillis();
            long nextTriggerTimeMs = this.nextBatchTime(triggerTimeMs);
            boolean bl = terminated = !triggerHandler.apply$mcZ$sp();
            if (this.intervalMs() > 0L) {
                long batchElapsedTimeMs = this.clock().getTimeMillis() - triggerTimeMs;
                if (batchElapsedTimeMs > this.intervalMs()) {
                    this.notifyBatchFallingBehind(batchElapsedTimeMs);
                }
                if (terminated) {
                    return;
                }
                object = BoxesRunTime.boxToLong((long)this.clock().waitTillTime(nextTriggerTimeMs));
                continue;
            }
            if (terminated) {
                return;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void notifyBatchFallingBehind(long realElapsedTimeMs) {
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Current batch is falling behind. The trigger interval is " + this.intervalMs() + " milliseconds, but spent " + realElapsedTimeMs + " milliseconds");
    }

    public long nextBatchTime(long now) {
        if (this.intervalMs() == 0L) {
            return now;
        }
        return now / this.intervalMs() * this.intervalMs() + this.intervalMs();
    }

    public ProcessingTimeExecutor copy(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        return new ProcessingTimeExecutor(processingTimeTrigger, clock);
    }

    public ProcessingTimeTrigger copy$default$1() {
        return this.processingTimeTrigger();
    }

    public Clock copy$default$2() {
        return this.clock();
    }

    public String productPrefix() {
        return "ProcessingTimeExecutor";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.processingTimeTrigger();
            }
            case 1: {
                return this.clock();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcessingTimeExecutor;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "processingTimeTrigger";
            }
            case 1: {
                return "clock";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ProcessingTimeExecutor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ProcessingTimeExecutor processingTimeExecutor = (ProcessingTimeExecutor)x$1;
        ProcessingTimeTrigger processingTimeTrigger = this.processingTimeTrigger();
        ProcessingTimeTrigger processingTimeTrigger2 = processingTimeExecutor.processingTimeTrigger();
        if (processingTimeTrigger == null) {
            if (processingTimeTrigger2 != null) {
                return false;
            }
        } else if (!processingTimeTrigger.equals(processingTimeTrigger2)) return false;
        Clock clock = this.clock();
        Clock clock2 = processingTimeExecutor.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!clock.equals(clock2)) return false;
        if (!processingTimeExecutor.canEqual(this)) return false;
        return true;
    }

    public ProcessingTimeExecutor(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        this.processingTimeTrigger = processingTimeTrigger;
        this.clock = clock;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.intervalMs = processingTimeTrigger.intervalMs();
        Predef$.MODULE$.require(this.intervalMs() >= 0L);
    }
}

