/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.CurrentBatchTimestamp;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2Exec;
import org.apache.spark.sql.execution.streaming.AcceptsLatestSeenOffsetHandler$;
import org.apache.spark.sql.execution.streaming.AsyncLogPurge;
import org.apache.spark.sql.execution.streaming.AvailableNowDataStreamWrapper;
import org.apache.spark.sql.execution.streaming.AvailableNowMicroBatchStreamWrapper;
import org.apache.spark.sql.execution.streaming.AvailableNowSourceWrapper;
import org.apache.spark.sql.execution.streaming.AvailableNowTrigger$;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.ErrorNotifier;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$2$;
import org.apache.spark.sql.execution.streaming.MultiBatchExecutor;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.OffsetHolder;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.ProgressReporter;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.SingleBatchExecutor;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.TERMINATED$;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.execution.streaming.WatermarkPropagator;
import org.apache.spark.sql.execution.streaming.WatermarkPropagator$;
import org.apache.spark.sql.execution.streaming.WatermarkTracker;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSource;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSource$;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSourceV1;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSourceV1$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tUc\u0001\u0002\u00192\u0001yB\u0011B\u0012\u0001\u0003\u0002\u0003\u0006IaR&\t\u00131\u0003!\u0011!Q\u0001\n5\u0013\u0006\"C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+[\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u000bQ\u0004A\u0011A;\t\u0011q\u0004!\u0019!C\tkuDq!a\u0001\u0001A\u0003%a\u0010C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0005\u0002\b!I\u0011Q\u0006\u0001A\u0002\u0013E\u0011q\u0006\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002\n!a\u0011q\t\u0001A\u0002\u0003\u0007I\u0011C\u001b\u0002J!a\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011C\u001b\u0002T!Y\u0011q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA&\u0011\u001d\tY\u0006\u0001C\t\u0003;B1\"a\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002b!Y\u0011\u0011\u000e\u0001A\u0002\u0003\u0007I\u0011CA6\u0011-\ty\u0007\u0001a\u0001\u0002\u0003\u0006K!a\u0019\t\u0015\u0005E\u0004\u0001#b\u0001\n\u0003\n\u0019\bC\u0005\u0002\u0006\u0002\u0001\r\u0011\"\u0003\u0002\b\"I\u0011q\u0012\u0001A\u0002\u0013%\u0011\u0011\u0013\u0005\t\u0003+\u0003\u0001\u0015)\u0003\u0002\n\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005\"CAN\u0001\t\u0007I\u0011BAO\u0011!\t)\u000b\u0001Q\u0001\n\u0005}\u0005bBAT\u0001\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003S\u0003A\u0011KAM\u0011\u001d\tY\u000b\u0001C\t\u0003[Cq!a-\u0001\t\u0003\t)\fC\u0004\u0002N\u0002!I!a4\t\u000f\u0005U\u0007\u0001\"\u0003\u0002\b\"9\u0011q\u001b\u0001\u0005\n\u0005e\u0007bBAs\u0001\u0011%\u0011q\u001d\u0005\b\u0003[\u0004A\u0011CAx\u0011\u001d\t)\u0010\u0001C\u0005\u0003oDq!!@\u0001\t#\tI\nC\u0004\u0002\u0000\u0002!\t\"!'\t\u000f\t\u0005\u0001\u0001\"\u0005\u0002\u001a\"9!1\u0001\u0001\u0005\u0012\u0005e\u0005\u0002\u0003B\u0003\u0001\u0011\u0005QGa\u0002\t\u001b\t-\u0002\u0001%A\u0002\u0002\u0003%IA!\fL\u00115\u0011y\u0003\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002B\u00195\u001e9!1G\u0019\t\u0002\tUbA\u0002\u00192\u0011\u0003\u00119\u0004\u0003\u0004uY\u0011\u0005!q\b\u0005\n\u0005\u0003b#\u0019!C\u0001\u0005\u0007B\u0001Ba\u0015-A\u0003%!Q\t\u0002\u0014\u001b&\u001c'o\u001c\"bi\u000eDW\t_3dkRLwN\u001c\u0006\u0003eM\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005Q*\u0014!C3yK\u000e,H/[8o\u0015\t1t'A\u0002tc2T!\u0001O\u001d\u0002\u000bM\u0004\u0018M]6\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0002\u0001'\r\u0001qh\u0011\t\u0003\u0001\u0006k\u0011!M\u0005\u0003\u0005F\u0012qb\u0015;sK\u0006lW\t_3dkRLwN\u001c\t\u0003\u0001\u0012K!!R\u0019\u0003\u001b\u0005\u001b\u0018P\\2M_\u001e\u0004VO]4f\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tA\u0015*D\u00016\u0013\tQUG\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0003\u0002G\u0003\u00069AO]5hO\u0016\u0014\bC\u0001(Q\u001b\u0005y%B\u0001\u001a6\u0013\t\tvJA\u0004Ue&<w-\u001a:\n\u00051\u000b\u0015\u0001\u0004;sS\u001e<WM]\"m_\u000e\\\u0007CA+Y\u001b\u00051&BA,8\u0003\u0011)H/\u001b7\n\u0005e3&!B\"m_\u000e\\\u0017BA*B\u00031)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t!\u0011if-[5\u000f\u0005y#\u0007CA0c\u001b\u0005\u0001'BA1>\u0003\u0019a$o\\8u})\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\u00061\u0001K]3eK\u001aL!a\u001a5\u0003\u00075\u000b\u0007O\u0003\u0002fEB\u0011QL[\u0005\u0003W\"\u0014aa\u0015;sS:<\u0017\u0001\u00029mC:\u0004\"A\u001c:\u000e\u0003=T!A\r9\u000b\u0005E,\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\u0005M|'!D,sSR,Gk\\*ue\u0016\fW.\u0001\u0004=S:LGO\u0010\u000b\u0007m^D\u0018P_>\u0011\u0005\u0001\u0003\u0001\"\u0002$\u0007\u0001\u00049\u0005\"\u0002'\u0007\u0001\u0004i\u0005\"B*\u0007\u0001\u0004!\u0006\"B.\u0007\u0001\u0004a\u0006\"\u00027\u0007\u0001\u0004i\u0017!D3se>\u0014hj\u001c;jM&,'/F\u0001\u007f!\t\u0001u0C\u0002\u0002\u0002E\u0012Q\"\u0012:s_Jtu\u000e^5gS\u0016\u0014\u0018AD3se>\u0014hj\u001c;jM&,'\u000fI\u0001\bg>,(oY3t+\t\tI\u0001\u0005\u0004\u0002\f\u0005U\u00111\u0004\b\u0005\u0003\u001b\t\tBD\u0002`\u0003\u001fI\u0011aY\u0005\u0004\u0003'\u0011\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003/\tIBA\u0002TKFT1!a\u0005c!\u0011\ti\"!\u000b\u000e\u0005\u0005}!b\u0001\u001a\u0002\")!\u00111EA\u0013\u0003\u0011\u0011X-\u00193\u000b\u0007\u0005\u001dR'A\u0005d_:tWm\u0019;pe&!\u00111FA\u0010\u0005=\u0019\u0006/\u0019:l\t\u0006$\u0018m\u0015;sK\u0006l\u0017aC:pkJ\u001cWm]0%KF$B!!\r\u0002:A!\u00111GA\u001b\u001b\u0005\u0011\u0017bAA\u001cE\n!QK\\5u\u0011%\tYDCA\u0001\u0002\u0004\tI!A\u0002yIE\n\u0001b]8ve\u000e,7\u000f\t\u0015\u0004\u0017\u0005\u0005\u0003\u0003BA\u001a\u0003\u0007J1!!\u0012c\u0005!1x\u000e\\1uS2,\u0017a\u0004;sS\u001e<WM]#yK\u000e,Ho\u001c:\u0016\u0005\u0005-\u0003c\u0001!\u0002N%\u0019\u0011qJ\u0019\u0003\u001fQ\u0013\u0018nZ4fe\u0016CXmY;u_J\f1\u0003\u001e:jO\u001e,'/\u0012=fGV$xN]0%KF$B!!\r\u0002V!I\u00111H\u0007\u0002\u0002\u0003\u0007\u00111J\u0001\u0011iJLwmZ3s\u000bb,7-\u001e;pe\u0002B3ADA!\u0003)9W\r\u001e+sS\u001e<WM\u001d\u000b\u0003\u0003\u0017\n\u0001c^1uKJl\u0017M]6Ue\u0006\u001c7.\u001a:\u0016\u0005\u0005\r\u0004c\u0001!\u0002f%\u0019\u0011qM\u0019\u0003!]\u000bG/\u001a:nCJ\\GK]1dW\u0016\u0014\u0018\u0001F<bi\u0016\u0014X.\u0019:l)J\f7m[3s?\u0012*\u0017\u000f\u0006\u0003\u00022\u00055\u0004\"CA\u001e#\u0005\u0005\t\u0019AA2\u0003E9\u0018\r^3s[\u0006\u00148\u000e\u0016:bG.,'\u000fI\u0001\fY><\u0017nY1m!2\fg.\u0006\u0002\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0004\u0003\u007f\u0002\u0018!\u00029mC:\u001c\u0018\u0002BAB\u0003s\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\u0006I\u0012n]\"veJ,g\u000e\u001e\"bi\u000eD7i\u001c8tiJ,8\r^3e+\t\tI\t\u0005\u0003\u00024\u0005-\u0015bAAGE\n9!i\\8mK\u0006t\u0017!H5t\u0007V\u0014(/\u001a8u\u0005\u0006$8\r[\"p]N$(/^2uK\u0012|F%Z9\u0015\t\u0005E\u00121\u0013\u0005\n\u0003w)\u0012\u0011!a\u0001\u0003\u0013\u000b!$[:DkJ\u0014XM\u001c;CCR\u001c\u0007nQ8ogR\u0014Xo\u0019;fI\u0002\nAa\u001d;paR\u0011\u0011\u0011G\u0001\u0014o\u0006$XM]7be.\u0004&o\u001c9bO\u0006$xN]\u000b\u0003\u0003?\u00032\u0001QAQ\u0013\r\t\u0019+\r\u0002\u0014/\u0006$XM]7be.\u0004&o\u001c9bO\u0006$xN]\u0001\u0015o\u0006$XM]7be.\u0004&o\u001c9bO\u0006$xN\u001d\u0011\u0002\u000f\rdW-\u00198va\u0006a1\u000f^1siR\u0013\u0018nZ4fe\u0006\u0011\"/\u001e8BGRLg/\u0019;fIN#(/Z1n)\u0011\t\t$a,\t\r\u0005EF\u00041\u0001H\u0003U\u0019\b/\u0019:l'\u0016\u001c8/[8o\r>\u00148\u000b\u001e:fC6\f\u0011E^1mS\u0012\fG/Z(gMN,G\u000fT8h\u0003:$w)\u001a;Qe\u00164xJ\u001a4tKR$B!a.\u0002DB1\u00111GA]\u0003{K1!a/c\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001)a0\n\u0007\u0005\u0005\u0017GA\u0005PM\u001a\u001cX\r^*fc\"9\u0011QY\u000fA\u0002\u0005\u001d\u0017!\u00047bi\u0016\u001cHOQ1uG\"LE\r\u0005\u0003\u00024\u0005%\u0017bAAfE\n!Aj\u001c8h\u0003Q\u0001x\u000e];mCR,7\u000b^1si>3gm]3ugR!\u0011\u0011GAi\u0011\u0019\t\u0019N\ba\u0001\u000f\u0006A2\u000f]1sWN+7o]5p]R{'+\u001e8CCR\u001c\u0007.Z:\u0002%%\u001ch*Z<ECR\f\u0017I^1jY\u0006\u0014G.Z\u0001\u000fO\u0016$8\u000b^1si>3gm]3u)\u0011\tY.!9\u0011\t\u0005u\u0011Q\\\u0005\u0005\u0003?\fyB\u0001\u0004PM\u001a\u001cX\r\u001e\u0005\b\u0003G\u0004\u0003\u0019AA\u000e\u0003)!\u0017\r^1TiJ,\u0017-\\\u0001\u0013G>t7\u000f\u001e:vGRtU\r\u001f;CCR\u001c\u0007\u000e\u0006\u0003\u0002\n\u0006%\bbBAvC\u0001\u0007\u0011\u0011R\u0001\u0015]>$\u0015\r^1CCR\u001c\u0007.Z:F]\u0006\u0014G.\u001a3\u0002\u001b\r|W.\\5u'>,(oY3t)\u0011\t\t$!=\t\u000f\u0005M(\u00051\u0001\u0002>\u0006IqN\u001a4tKR\u001cV-]\u0001\teVt')\u0019;dQR!\u0011\u0011GA}\u0011\u0019\tYp\ta\u0001\u000f\u000612\u000f]1sWN+7o]5p]R{'+\u001e8CCR\u001c\u0007.A\nnCJ\\W*[2s_\n\u000bGo\u00195Ti\u0006\u0014H/\u0001\u000fnCJ\\W*[2s_\n\u000bGo\u00195Fq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;\u0002#5\f'o['jGJ|')\u0019;dQ\u0016sG-A\u000fdY\u0016\fg.\u00169MCN$X\t_3dkR,G-T5de>\u0014\u0015\r^2i\u0003I9\u0018\u000e\u001e5Qe><'/Z:t\u0019>\u001c7.\u001a3\u0016\t\t%!q\u0002\u000b\u0005\u0005\u0017\u0011\t\u0003\u0005\u0003\u0003\u000e\t=A\u0002\u0001\u0003\b\u0005#A#\u0019\u0001B\n\u0005\u0005!\u0016\u0003\u0002B\u000b\u00057\u0001B!a\r\u0003\u0018%\u0019!\u0011\u00042\u0003\u000f9{G\u000f[5oOB!\u00111\u0007B\u000f\u0013\r\u0011yB\u0019\u0002\u0004\u0003:L\b\u0002\u0003B\u0012Q\u0011\u0005\rA!\n\u0002\u0003\u0019\u0004b!a\r\u0003(\t-\u0011b\u0001B\u0015E\nAAHY=oC6,g(\u0001\ntkB,'\u000fJ:qCJ\\7+Z:tS>tW#A$\u0002%M,\b/\u001a:%iJLwmZ3s\u00072|7m[\u000b\u0002)\u0006\u0019R*[2s_\n\u000bGo\u00195Fq\u0016\u001cW\u000f^5p]B\u0011\u0001\tL\n\u0004Y\te\u0002\u0003BA\u001a\u0005wI1A!\u0010c\u0005\u0019\te.\u001f*fMR\u0011!QG\u0001\r\u0005\u0006#6\tS0J\t~[U)W\u000b\u0003\u0005\u000b\u0002BAa\u0012\u0003R5\u0011!\u0011\n\u0006\u0005\u0005\u0017\u0012i%\u0001\u0003mC:<'B\u0001B(\u0003\u0011Q\u0017M^1\n\u0007-\u0014I%A\u0007C\u0003R\u001b\u0005jX%E?.+\u0015\f\t")
public class MicroBatchExecution
extends StreamExecution
implements AsyncLogPurge {
    private LogicalPlan logicalPlan;
    private final scala.collection.immutable.Map<String, String> extraOptions;
    private final WriteToStream plan;
    private final ErrorNotifier errorNotifier;
    private volatile Seq<SparkDataStream> sources;
    private volatile TriggerExecutor triggerExecutor;
    private WatermarkTracker watermarkTracker;
    private boolean isCurrentBatchConstructed;
    private final WatermarkPropagator watermarkPropagator;
    private ThreadPoolExecutor org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService;
    private AtomicBoolean org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning;
    private boolean useAsyncPurge;
    private volatile byte bitmap$0;

    public static String BATCH_ID_KEY() {
        return MicroBatchExecution$.MODULE$.BATCH_ID_KEY();
    }

    @Override
    public void purgeAsync() {
        AsyncLogPurge.purgeAsync$(this);
    }

    @Override
    public void asyncLogPurgeShutdown() {
        AsyncLogPurge.asyncLogPurgeShutdown$(this);
    }

    @Override
    public boolean arePendingAsyncPurge() {
        return AsyncLogPurge.arePendingAsyncPurge$(this);
    }

    @Override
    public ThreadPoolExecutor org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService() {
        return this.org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService;
    }

    @Override
    public AtomicBoolean org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning() {
        return this.org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning;
    }

    private boolean useAsyncPurge$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.useAsyncPurge = AsyncLogPurge.useAsyncPurge$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.useAsyncPurge;
    }

    @Override
    public boolean useAsyncPurge() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.useAsyncPurge$lzycompute();
        }
        return this.useAsyncPurge;
    }

    @Override
    public final void org$apache$spark$sql$execution$streaming$AsyncLogPurge$_setter_$org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService_$eq(ThreadPoolExecutor x$1) {
        this.org$apache$spark$sql$execution$streaming$AsyncLogPurge$$asyncPurgeExecutorService = x$1;
    }

    @Override
    public final void org$apache$spark$sql$execution$streaming$AsyncLogPurge$_setter_$org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning_$eq(AtomicBoolean x$1) {
        this.org$apache$spark$sql$execution$streaming$AsyncLogPurge$$purgeRunning = x$1;
    }

    public /* synthetic */ SparkSession org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession() {
        return super.sparkSession();
    }

    private /* synthetic */ Clock super$triggerClock() {
        return super.triggerClock();
    }

    @Override
    public ErrorNotifier errorNotifier() {
        return this.errorNotifier;
    }

    @Override
    public Seq<SparkDataStream> sources() {
        return this.sources;
    }

    public void sources_$eq(Seq<SparkDataStream> x$1) {
        this.sources = x$1;
    }

    public TriggerExecutor triggerExecutor() {
        return this.triggerExecutor;
    }

    public void triggerExecutor_$eq(TriggerExecutor x$1) {
        this.triggerExecutor = x$1;
    }

    public TriggerExecutor getTrigger() {
        Predef$.MODULE$.assert(this.sources().nonEmpty(), (Function0 & Serializable)() -> "sources should have been retrieved from the plan!");
        Trigger trigger = super.trigger();
        if (trigger instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger;
            return new ProcessingTimeExecutor(processingTimeTrigger, super.triggerClock());
        }
        if (OneTimeTrigger$.MODULE$.equals(trigger)) {
            return new SingleBatchExecutor();
        }
        if (AvailableNowTrigger$.MODULE$.equals(trigger)) {
            if (BoxesRunTime.unboxToBoolean((Object)super.sparkSession().sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_TRIGGER_AVAILABLE_NOW_WRAPPER_ENABLED()))) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Configured to use the wrapper of Trigger.AvailableNow for query " + this.prettyIdString() + ".");
                return new MultiBatchExecutor();
            }
            boolean supportsTriggerAvailableNow = ((IterableOnceOps)this.sources().distinct()).forall((Function1 & Serializable)src -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$getTrigger$3(this, src)));
            if (supportsTriggerAvailableNow) {
                return new MultiBatchExecutor();
            }
            return new SingleBatchExecutor();
        }
        throw new IllegalStateException("Unknown type of trigger: " + super.trigger());
    }

    public WatermarkTracker watermarkTracker() {
        return this.watermarkTracker;
    }

    public void watermarkTracker_$eq(WatermarkTracker x$1) {
        this.watermarkTracker = x$1;
    }

    private LogicalPlan logicalPlan$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                LogicalPlan logicalPlan2;
                Predef$.MODULE$.assert(this.queryExecutionThread() == Thread.currentThread(), (Function0 & Serializable)() -> "logicalPlan must be initialized in QueryExecutionThread but the current thread was " + Thread.currentThread());
                LongRef nextSourceId = LongRef.create((long)0L);
                Map toExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Seq disabledSources = Utils$.MODULE$.stringToSeq(super.sparkSession().sessionState().conf().disabledV2StreamingMicroBatchReaders());
                LogicalPlan _logicalPlan = (LogicalPlan)this.analyzedPlan().transform((PartialFunction)new Serializable(this, toExecutionRelationMap, nextSourceId, disabledSources, v2ToRelationMap, v2ToExecutionRelationMap){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ MicroBatchExecution $outer;
                    private final Map toExecutionRelationMap$1;
                    private final LongRef nextSourceId$1;
                    private final Seq disabledSources$1;
                    private final Map v2ToRelationMap$1;
                    private final Map v2ToExecutionRelationMap$1;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof StreamingRelation) {
                            StreamingRelation streamingRelation = (StreamingRelation)A1;
                            DataSource dataSourceV1 = streamingRelation.dataSource();
                            String sourceName = streamingRelation.sourceName();
                            Seq<Attribute> output = streamingRelation.output();
                            return (B1)this.toExecutionRelationMap$1.getOrElseUpdate((Object)streamingRelation, (Function0 & Serializable)() -> {
                                String metadataPath = $this.$outer.resolvedCheckpointRoot() + "/sources/" + $this.nextSourceId$1.elem;
                                Source source = dataSourceV1.createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "Using Source [" + source + "] from DataSourceV1 named '" + sourceName + "' [" + dataSourceV1 + "]");
                                return new StreamingExecutionRelation(source, output, dataSourceV1.catalogTable(), $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                        }
                        if (A1 instanceof StreamingRelationV2) {
                            StreamingRelationV2 streamingRelationV2 = (StreamingRelationV2)A1;
                            Option src = streamingRelationV2.source();
                            String srcName = streamingRelationV2.sourceName();
                            Table table = streamingRelationV2.table();
                            CaseInsensitiveStringMap options = streamingRelationV2.extraOptions();
                            Seq output = streamingRelationV2.output();
                            Option catalog = streamingRelationV2.catalog();
                            Option identifier = streamingRelationV2.identifier();
                            Option v1 = streamingRelationV2.v1Relation();
                            if (table instanceof SupportsRead) {
                                SupportsRead supportsRead = (SupportsRead)table;
                                String dsStr = src.nonEmpty() ? "[" + src.get() + "]" : "";
                                boolean v2Disabled = this.disabledSources$1.contains((Object)src.getOrElse((Function0 & Serializable)() -> None$.MODULE$).getClass().getCanonicalName());
                                if (!v2Disabled && DataSourceV2Implicits$.MODULE$.TableHelper((Table)supportsRead).supports(TableCapability.MICRO_BATCH_READ)) {
                                    return (B1)this.v2ToRelationMap$1.getOrElseUpdate((Object)streamingRelationV2, (Function0 & Serializable)() -> {
                                        String metadataPath = $this.$outer.resolvedCheckpointRoot() + "/sources/" + $this.nextSourceId$1.elem;
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "Reading table [" + supportsRead + "] from DataSourceV2 named '" + srcName + "' " + dsStr);
                                        Scan scan = supportsRead.newScanBuilder(options).build();
                                        MicroBatchStream stream = scan.toMicroBatchStream(metadataPath);
                                        return new StreamingDataSourceV2Relation(output, scan, (SparkDataStream)stream, catalog, identifier, StreamingDataSourceV2Relation$.MODULE$.apply$default$6(), StreamingDataSourceV2Relation$.MODULE$.apply$default$7());
                                    });
                                }
                                if (v1.isEmpty()) {
                                    throw QueryExecutionErrors$.MODULE$.microBatchUnsupportedByDataSourceError(srcName, this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sessionState().conf().disabledV2StreamingMicroBatchReaders(), (Table)supportsRead);
                                }
                                return (B1)this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)streamingRelationV2, (Function0 & Serializable)() -> {
                                    String metadataPath = $this.$outer.resolvedCheckpointRoot() + "/sources/" + $this.nextSourceId$1.elem;
                                    Source source = ((StreamingRelation)v1.get()).dataSource().createSource(metadataPath);
                                    ++$this.nextSourceId$1.elem;
                                    $this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "Using Source [" + source + "] from DataSourceV2 named '" + srcName + "' " + dsStr);
                                    return new StreamingExecutionRelation(source, (Seq<Attribute>)output, (Option<CatalogTable>)None$.MODULE$, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                                });
                            }
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        StreamingRelationV2 streamingRelationV2;
                        Table table;
                        LogicalPlan logicalPlan2 = x1;
                        if (logicalPlan2 instanceof StreamingRelation) {
                            return true;
                        }
                        return logicalPlan2 instanceof StreamingRelationV2 && (table = (streamingRelationV2 = (StreamingRelationV2)logicalPlan2).table()) instanceof SupportsRead;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.toExecutionRelationMap$1 = toExecutionRelationMap$1;
                        this.nextSourceId$1 = nextSourceId$1;
                        this.disabledSources$1 = disabledSources$1;
                        this.v2ToRelationMap$1 = v2ToRelationMap$1;
                        this.v2ToExecutionRelationMap$1 = v2ToExecutionRelationMap$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.execution.datasources.DataSource java.lang.String scala.collection.immutable.Seq ), $anonfun$applyOrElse$2(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.execution.datasources.DataSource ), $anonfun$applyOrElse$3(), $anonfun$applyOrElse$4(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String java.lang.String org.apache.spark.sql.util.CaseInsensitiveStringMap scala.collection.immutable.Seq scala.Option scala.Option ), $anonfun$applyOrElse$5(org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String java.lang.String ), $anonfun$applyOrElse$6(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 scala.Option java.lang.String java.lang.String scala.collection.immutable.Seq ), $anonfun$applyOrElse$7(org.apache.spark.sql.execution.streaming.Source java.lang.String java.lang.String )}, serializedLambda);
                    }
                });
                this.sources_$eq((Seq<SparkDataStream>)_logicalPlan.collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof StreamingExecutionRelation) {
                            StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                            return (B1)streamingExecutionRelation.source();
                        }
                        if (A1 instanceof StreamingDataSourceV2Relation) {
                            StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                            return (B1)streamingDataSourceV2Relation.stream();
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan2 = x2;
                        if (logicalPlan2 instanceof StreamingExecutionRelation) {
                            return true;
                        }
                        return logicalPlan2 instanceof StreamingDataSourceV2Relation;
                    }
                }));
                this.triggerExecutor_$eq(this.getTrigger());
                TriggerExecutor triggerExecutor = this.triggerExecutor();
                this.uniqueSources_$eq((scala.collection.immutable.Map<SparkDataStream, ReadLimit>)(triggerExecutor instanceof SingleBatchExecutor ? ((IterableOnceOps)((IterableOps)this.sources().distinct()).map((Function1 & Serializable)x0$1 -> {
                    SparkDataStream sparkDataStream = x0$1;
                    if (sparkDataStream instanceof SupportsAdmissionControl) {
                        ReadLimit limit;
                        SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)sparkDataStream;
                        ReadLimit readLimit = limit = supportsAdmissionControl.getDefaultReadLimit();
                        ReadLimit readLimit2 = ReadLimit.allAvailable();
                        if (readLimit == null ? readLimit2 != null : !readLimit.equals(readLimit2)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The read limit " + limit + " for " + supportsAdmissionControl + " is ignored when Trigger.Once is used.");
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supportsAdmissionControl), (Object)ReadLimit.allAvailable());
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sparkDataStream), (Object)ReadLimit.allAvailable());
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : (triggerExecutor instanceof MultiBatchExecutor ? ((IterableOnceOps)((IterableOps)((IterableOps)this.sources().distinct()).map((Function1 & Serializable)x0$2 -> {
                    SparkDataStream sparkDataStream = x0$2;
                    if (sparkDataStream instanceof SupportsTriggerAvailableNow) {
                        SupportsTriggerAvailableNow supportsTriggerAvailableNow = (SupportsTriggerAvailableNow)sparkDataStream;
                        return supportsTriggerAvailableNow;
                    }
                    if (sparkDataStream instanceof Source) {
                        Source source = (Source)sparkDataStream;
                        return new AvailableNowSourceWrapper(source);
                    }
                    if (sparkDataStream instanceof MicroBatchStream) {
                        MicroBatchStream microBatchStream = (MicroBatchStream)sparkDataStream;
                        return new AvailableNowMicroBatchStreamWrapper(microBatchStream);
                    }
                    throw new MatchError((Object)sparkDataStream);
                })).map((Function1 & Serializable)s -> {
                    s.prepareForTriggerAvailableNow();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s), (Object)s.getDefaultReadLimit());
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : ((IterableOnceOps)((IterableOps)this.sources().distinct()).map((Function1 & Serializable)x0$3 -> {
                    SparkDataStream sparkDataStream = x0$3;
                    if (sparkDataStream instanceof SupportsAdmissionControl) {
                        SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)sparkDataStream;
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supportsAdmissionControl), (Object)supportsAdmissionControl.getDefaultReadLimit());
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sparkDataStream), (Object)ReadLimit.allAvailable());
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
                Table table = this.sink();
                if (table instanceof SupportsWrite) {
                    SupportsWrite supportsWrite = (SupportsWrite)table;
                    Option relationOpt = this.plan.catalogAndIdent().map((Function1 & Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 != null) {
                            TableCatalog catalog = (TableCatalog)tuple2._1();
                            Identifier ident = (Identifier)tuple2._2();
                            return DataSourceV2Relation$.MODULE$.create((Table)supportsWrite, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    logicalPlan2 = new WriteToMicroBatchDataSource((Option<DataSourceV2Relation>)relationOpt, supportsWrite, _logicalPlan, this.id().toString(), this.extraOptions, this.outputMode(), WriteToMicroBatchDataSource$.MODULE$.apply$default$7());
                } else if (table instanceof Sink) {
                    Sink sink = (Sink)table;
                    logicalPlan2 = new WriteToMicroBatchDataSourceV1((Option<CatalogTable>)this.plan.catalogTable(), sink, _logicalPlan, this.id().toString(), this.extraOptions, this.outputMode(), WriteToMicroBatchDataSourceV1$.MODULE$.apply$default$7());
                } else {
                    throw new IllegalArgumentException("unknown sink type for " + this.sink());
                }
                this.logicalPlan = logicalPlan2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logicalPlan;
    }

    @Override
    public LogicalPlan logicalPlan() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logicalPlan$lzycompute();
        }
        return this.logicalPlan;
    }

    private boolean isCurrentBatchConstructed() {
        return this.isCurrentBatchConstructed;
    }

    private void isCurrentBatchConstructed_$eq(boolean x$1) {
        this.isCurrentBatchConstructed = x$1;
    }

    @Override
    public void stop() {
        this.state().set(TERMINATED$.MODULE$);
        if (this.queryExecutionThread().isAlive()) {
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
            this.interruptAndAwaitExecutionThreadTermination();
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Query " + this.prettyIdString() + " was stopped");
    }

    private WatermarkPropagator watermarkPropagator() {
        return this.watermarkPropagator;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.asyncLogPurgeShutdown();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Async log purge executor pool for query " + this.prettyIdString() + " has been shutdown");
    }

    @Override
    public void startTrigger() {
        ProgressReporter.startTrigger$(this);
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = true;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, true));
    }

    @Override
    public void runActivatedStream(SparkSession sparkSessionForStream) {
        boolean noDataBatchesEnabled = sparkSessionForStream.sessionState().conf().streamingNoDataMicroBatchesEnabled();
        this.triggerExecutor().execute((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            if (this.isActive()) {
                this.errorNotifier().throwErrorIfExists();
                BooleanRef currentBatchHasNewData = BooleanRef.create((boolean)false);
                this.startTrigger();
                this.reportTimeTaken("triggerExecution", (JFunction0.mcV.sp & Serializable)() -> {
                    if (this.currentBatchId() < 0L) {
                        AcceptsLatestSeenOffsetHandler$.MODULE$.setLatestSeenOffsetOnSources((Option<OffsetSeq>)this.offsetLog().getLatest().map((Function1 & Serializable)x$3 -> (OffsetSeq)x$3._2()), this.sources());
                        this.populateStartOffsets(sparkSessionForStream);
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Stream started from " + this.committedOffsets());
                    }
                    this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sparkContext().setJobDescription(this.getBatchDescriptionString());
                    if (!this.isCurrentBatchConstructed()) {
                        this.isCurrentBatchConstructed_$eq(this.constructNextBatch(noDataBatchesEnabled));
                    }
                    this.recordTriggerOffsets(this.committedOffsets(), this.availableOffsets(), this.latestOffsets());
                    currentBatchHasNewData$1.elem = this.isNewDataAvailable();
                    StreamingQueryStatus qual$1 = this.currentStatus();
                    boolean x$1 = this.isNewDataAvailable();
                    String x$2 = qual$1.copy$default$1();
                    boolean x$32 = qual$1.copy$default$3();
                    this.currentStatus_$eq(qual$1.copy(x$2, x$1, x$32));
                    if (this.isCurrentBatchConstructed()) {
                        if (currentBatchHasNewData$1.elem) {
                            this.updateStatusMessage("Processing new data");
                        } else {
                            this.updateStatusMessage("No new data but cleaning up state");
                        }
                        this.runBatch(sparkSessionForStream);
                        return;
                    }
                    this.updateStatusMessage("Waiting for data to arrive");
                });
                this.finishTrigger(currentBatchHasNewData.elem, this.isCurrentBatchConstructed());
                this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable)() -> this.awaitProgressLockCondition().signalAll());
                if (this.isCurrentBatchConstructed()) {
                    this.currentBatchId_$eq(this.currentBatchId() + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                } else if (this.triggerExecutor() instanceof MultiBatchExecutor) {
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Finished processing all available data for the trigger, terminating this Trigger.AvailableNow query");
                    this.state().set(TERMINATED$.MODULE$);
                } else {
                    Thread.sleep(this.pollingDelayMs());
                }
            }
            this.updateStatusMessage("Waiting for next trigger");
            return this.isActive();
        });
    }

    public Option<OffsetSeq> validateOffsetLogAndGetPrevOffset(long latestBatchId) {
        if (latestBatchId != 0L) {
            return new Some(this.offsetLog().get(latestBatchId - 1L).getOrElse((Function0 & Serializable)() -> {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "The offset log for batch " + (latestBatchId - 1L) + " doesn't exist, which is required to restart the query from the latest batch " + latestBatchId + " from the offset log. Please ensure there are two subsequent offset logs available for the latest batch via manually deleting the offset file(s). Please also ensure the latest batch for commit log is equal or one batch earlier than the latest batch for offset log.");
                throw new IllegalStateException("batch " + (latestBatchId - 1L) + " doesn't exist");
            }));
        }
        return None$.MODULE$;
    }

    private void populateStartOffsets(SparkSession sparkSessionToRunBatches) {
        Some some;
        Tuple2 tuple2;
        this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)None$.MODULE$);
        Option option = this.offsetLog().getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Some some2;
            Tuple2 tuple22;
            long latestBatchId = tuple2._1$mcJ$sp();
            OffsetSeq nextOffsets = (OffsetSeq)tuple2._2();
            this.currentBatchId_$eq(latestBatchId);
            this.isCurrentBatchConstructed_$eq(true);
            this.availableOffsets_$eq(nextOffsets.toStreamProgress(this.sources()));
            Option<OffsetSeq> secondLatestOffsets = this.validateOffsetLogAndGetPrevOffset(latestBatchId);
            secondLatestOffsets.foreach((Function1 & Serializable)offset -> {
                this.committedOffsets_$eq(offset.toStreamProgress(this.sources()));
                return BoxedUnit.UNIT;
            });
            nextOffsets.metadata().foreach((Function1 & Serializable)metadata -> {
                MicroBatchExecution.$anonfun$populateStartOffsets$2(this, sparkSessionToRunBatches, metadata);
                return BoxedUnit.UNIT;
            });
            Option option2 = this.commitLog().getLatest();
            if (option2 instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                long latestCommittedBatchId = tuple22._1$mcJ$sp();
                CommitMetadata commitMetadata = (CommitMetadata)tuple22._2();
                if (latestBatchId == latestCommittedBatchId) {
                    this.availableOffsets().foreach((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            SparkDataStream source = (SparkDataStream)tuple2._1();
                            org.apache.spark.sql.connector.read.streaming.Offset end = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end instanceof Offset) {
                                    Offset offset = (Offset)end;
                                    Option start = this.committedOffsets().get(source2).map((Function1 & Serializable)x$4 -> (Offset)((Object)((Object)x$4)));
                                    return source2.getBatch((Option<Offset>)start, offset);
                                }
                            }
                        }
                        return BoxedUnit.UNIT;
                    });
                    this.currentBatchId_$eq(latestCommittedBatchId + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                    this.committedOffsets_$eq((StreamProgress)this.committedOffsets().$plus$plus((IterableOnce)this.availableOffsets()));
                    this.watermarkTracker().setWatermark(package$.MODULE$.max(this.watermarkTracker().currentWatermark(), commitMetadata.nextBatchWatermarkMs()));
                } else if (latestCommittedBatchId == latestBatchId - 1L) {
                    this.availableOffsets().foreach((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            SparkDataStream source = (SparkDataStream)tuple2._1();
                            org.apache.spark.sql.connector.read.streaming.Offset end = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end instanceof Offset) {
                                    Offset offset = (Offset)end;
                                    Option start = this.committedOffsets().get(source2).map((Function1 & Serializable)x$5 -> (Offset)((Object)((Object)x$5)));
                                    if (BoxesRunTime.unboxToBoolean((Object)start.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$populateStartOffsets$7(offset, x$6))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) {
                                        return source2.getBatch((Option<Offset>)start, offset);
                                    }
                                    return BoxedUnit.UNIT;
                                }
                            }
                        }
                        return BoxedUnit.UNIT;
                    });
                } else if (latestCommittedBatchId < latestBatchId - 1L) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Batch completion log latest batch id is " + latestCommittedBatchId + ", which is not trailing batchid " + latestBatchId + " by one");
                }
            } else if (None$.MODULE$.equals(option2)) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "no commit log present");
            } else {
                throw new MatchError(option2);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Resuming at batch " + this.currentBatchId() + " with committed offsets " + this.committedOffsets() + " and available offsets " + this.availableOffsets());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Starting new streaming query.");
            this.currentBatchId_$eq(0L);
            this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches.conf()));
            return;
        }
        throw new MatchError(option);
    }

    private boolean isNewDataAvailable() {
        return this.availableOffsets().exists((Function1<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$1(this, x0$1)));
    }

    private org.apache.spark.sql.connector.read.streaming.Offset getStartOffset(SparkDataStream dataStream) {
        Option<org.apache.spark.sql.connector.read.streaming.Offset> startOffsetOpt = this.availableOffsets().get(dataStream);
        SparkDataStream sparkDataStream = dataStream;
        if (sparkDataStream instanceof Source) {
            return (org.apache.spark.sql.connector.read.streaming.Offset)startOffsetOpt.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        if (sparkDataStream instanceof MicroBatchStream) {
            MicroBatchStream microBatchStream = (MicroBatchStream)sparkDataStream;
            return (org.apache.spark.sql.connector.read.streaming.Offset)startOffsetOpt.map((Function1 & Serializable)offset -> microBatchStream.deserializeOffset(offset.json())).getOrElse((Function0 & Serializable)() -> microBatchStream.initialOffset());
        }
        throw new MatchError((Object)sparkDataStream);
    }

    private boolean constructNextBatch(boolean noDataBatchesEnabled) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(this.withProgressLocked((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                if (this.isCurrentBatchConstructed()) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
                Tuple2 tuple2 = ((IterableOps)this.uniqueSources().toSeq().map((Function1 & Serializable)x0$1 -> {
                    SparkDataStream s;
                    SparkDataStream s2;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        SparkDataStream s3 = (SparkDataStream)tuple2._1();
                        ReadLimit limit = (ReadLimit)tuple2._2();
                        if (s3 instanceof AvailableNowDataStreamWrapper) {
                            AvailableNowDataStreamWrapper availableNowDataStreamWrapper = (AvailableNowDataStreamWrapper)s3;
                            this.updateStatusMessage("Getting offsets from " + availableNowDataStreamWrapper);
                            SparkDataStream originalSource = availableNowDataStreamWrapper.delegate();
                            return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable)() -> {
                                org.apache.spark.sql.connector.read.streaming.Offset next = availableNowDataStreamWrapper.latestOffset(this.getStartOffset(originalSource), limit);
                                org.apache.spark.sql.connector.read.streaming.Offset latest = availableNowDataStreamWrapper.reportLatestOffset();
                                return new Tuple2((Object)new Tuple2((Object)originalSource, (Object)Option$.MODULE$.apply((Object)next)), (Object)new Tuple2((Object)originalSource, (Object)Option$.MODULE$.apply((Object)latest)));
                            });
                        }
                    }
                    if (tuple2 != null) {
                        SparkDataStream s4 = (SparkDataStream)tuple2._1();
                        ReadLimit limit = (ReadLimit)tuple2._2();
                        if (s4 instanceof SupportsAdmissionControl) {
                            SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)s4;
                            this.updateStatusMessage("Getting offsets from " + supportsAdmissionControl);
                            return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable)() -> {
                                org.apache.spark.sql.connector.read.streaming.Offset next = supportsAdmissionControl.latestOffset(this.getStartOffset((SparkDataStream)supportsAdmissionControl), limit);
                                org.apache.spark.sql.connector.read.streaming.Offset latest = supportsAdmissionControl.reportLatestOffset();
                                return new Tuple2((Object)new Tuple2((Object)supportsAdmissionControl, (Object)Option$.MODULE$.apply((Object)next)), (Object)new Tuple2((Object)supportsAdmissionControl, (Object)Option$.MODULE$.apply((Object)latest)));
                            });
                        }
                    }
                    if (tuple2 != null && (s2 = (SparkDataStream)tuple2._1()) instanceof Source) {
                        Source source = (Source)s2;
                        this.updateStatusMessage("Getting offsets from " + source);
                        return (Tuple2)this.reportTimeTaken("getOffset", (Function0 & Serializable)() -> {
                            Option<Offset> offset = source.getOffset();
                            return new Tuple2((Object)new Tuple2((Object)source, offset), (Object)new Tuple2((Object)source, offset));
                        });
                    }
                    if (tuple2 != null && (s = (SparkDataStream)tuple2._1()) instanceof MicroBatchStream) {
                        MicroBatchStream microBatchStream = (MicroBatchStream)s;
                        this.updateStatusMessage("Getting offsets from " + microBatchStream);
                        return (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable)() -> {
                            org.apache.spark.sql.connector.read.streaming.Offset latest = microBatchStream.latestOffset();
                            return new Tuple2((Object)new Tuple2((Object)microBatchStream, (Object)Option$.MODULE$.apply((Object)latest)), (Object)new Tuple2((Object)microBatchStream, (Object)Option$.MODULE$.apply((Object)latest)));
                        });
                    }
                    if (tuple2 != null) {
                        SparkDataStream s5 = (SparkDataStream)tuple2._1();
                        throw new IllegalStateException("Unexpected source: " + s5);
                    }
                    throw new MatchError((Object)tuple2);
                })).unzip(Predef$.MODULE$.$conforms());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq nextOffsets = (Seq)tuple2._1();
                Seq recentOffsets = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)nextOffsets, (Object)recentOffsets);
                Seq nextOffsets2 = (Seq)tuple22._1();
                Seq recentOffsets2 = (Seq)tuple22._2();
                this.availableOffsets_$eq((StreamProgress)this.availableOffsets().$plus$plus((IterableOnce)((IterableOnceOps)((IterableOps)nextOffsets2.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$7(x0$2)))).map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), ((Option)p._2()).get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                this.latestOffsets_$eq((StreamProgress)this.latestOffsets().$plus$plus((IterableOnce)((IterableOnceOps)((IterableOps)recentOffsets2.filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$9(x0$3)))).map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), ((Option)p._2()).get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                OffsetSeqMetadata qual$1 = this.offsetSeqMetadata();
                long x$1 = this.watermarkTracker().currentWatermark();
                long x$2 = this.super$triggerClock().getTimeMillis();
                scala.collection.immutable.Map<String, String> x$3 = qual$1.copy$default$3();
                this.offsetSeqMetadata_$eq(qual$1.copy(x$1, x$2, x$3));
                boolean lastExecutionRequiresAnotherBatch = noDataBatchesEnabled && Option$.MODULE$.apply((Object)this.lastExecution()).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.shouldRunAnotherBatch(this.offsetSeqMetadata())));
                boolean shouldConstructNextBatch = this.isNewDataAvailable() || lastExecutionRequiresAnotherBatch;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> "noDataBatchesEnabled = " + noDataBatchesEnabled + ", lastExecutionRequiresAnotherBatch = " + lastExecutionRequiresAnotherBatch + ", isNewDataAvailable = " + this.isNewDataAvailable() + ", shouldConstructNextBatch = " + shouldConstructNextBatch);
                if (shouldConstructNextBatch) {
                    this.updateStatusMessage("Writing offsets to log");
                    this.reportTimeTaken("walCommit", (JFunction0.mcV.sp & Serializable)() -> {
                        this.markMicroBatchStart();
                        this.cleanUpLastExecutedMicroBatch();
                        if ((long)this.minLogEntriesToMaintain() < this.currentBatchId()) {
                            if (this.useAsyncPurge()) {
                                this.purgeAsync();
                                return;
                            }
                            this.purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                            return;
                        }
                    });
                    this.noNewData_$eq(false);
                } else {
                    this.noNewData_$eq(true);
                    this.awaitProgressLockCondition().signalAll();
                }
                return shouldConstructNextBatch;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public void commitSources(OffsetSeq offsetSeq) {
        offsetSeq.toStreamProgress(this.sources()).foreach((Function1 & Serializable)x0$1 -> {
            MicroBatchExecution.$anonfun$commitSources$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void runBatch(SparkSession sparkSessionToRunBatch) {
        LogicalPlan logicalPlan2;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Running batch " + this.currentBatchId());
        Map mutableNewData = (Map)((MapOps)Map$.MODULE$.empty()).$plus$plus((IterableOnce)this.reportTimeTaken("getBatch", (Function0 & Serializable)() -> (scala.collection.immutable.Map)this.availableOffsets().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SparkDataStream source = (SparkDataStream)tuple2._1();
                org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                if (source instanceof Source) {
                    Source source2 = (Source)source;
                    if (available instanceof Offset) {
                        Offset offset = (Offset)available;
                        if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(source2).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$4(offset, x$9))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) {
                            Option current = this.committedOffsets().get(source2).map((Function1 & Serializable)x$10 -> (Offset)((Object)((Object)((Object)x$10))));
                            Dataset<Row> batch = source2.getBatch((Option<Offset>)current, offset);
                            Predef$.MODULE$.assert(batch.isStreaming(), (Function0 & Serializable)() -> "DataFrame returned by getBatch from " + source2 + " did not have isStreaming=true\n" + batch.queryExecution().logical());
                            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Retrieving data from " + source2 + ": " + current + " -> " + offset);
                            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source2), (Object)batch.logicalPlan()));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                SparkDataStream stream = (SparkDataStream)tuple2._1();
                org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                if (stream instanceof MicroBatchStream) {
                    MicroBatchStream microBatchStream = (MicroBatchStream)stream;
                    if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$9(available, x$11))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) {
                        org.apache.spark.sql.connector.read.streaming.Offset offset;
                        Option current = this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable)off -> microBatchStream.deserializeOffset(off.json()));
                        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available;
                        if (offset2 instanceof SerializedOffset) {
                            SerializedOffset serializedOffset = (SerializedOffset)offset2;
                            offset = microBatchStream.deserializeOffset(serializedOffset.json());
                        } else if (offset2 != null) {
                            org.apache.spark.sql.connector.read.streaming.Offset offset3;
                            offset = offset3 = offset2;
                        } else {
                            throw new MatchError((Object)offset2);
                        }
                        org.apache.spark.sql.connector.read.streaming.Offset endOffset = offset;
                        org.apache.spark.sql.connector.read.streaming.Offset startOffset = (org.apache.spark.sql.connector.read.streaming.Offset)current.getOrElse((Function0 & Serializable)() -> microBatchStream.initialOffset());
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Retrieving data from " + microBatchStream + ": " + current + " -> " + endOffset);
                        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchStream), (Object)new OffsetHolder(startOffset, endOffset)));
                    }
                }
            }
            return None$.MODULE$;
        })));
        LogicalPlan newBatchesPlan = (LogicalPlan)this.logicalPlan().transform((PartialFunction)new Serializable(this, mutableNewData){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;
            private final Map mutableNewData$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StreamingExecutionRelation) {
                    StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                    SparkDataStream source = streamingExecutionRelation.source();
                    Seq<Attribute> output = streamingExecutionRelation.output();
                    Option<CatalogTable> catalogTable = streamingExecutionRelation.catalogTable();
                    return (B1)this.mutableNewData$1.get((Object)source).map((Function1 & Serializable)dataPlan -> {
                        boolean hasFileMetadata = output.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$2.$anonfun$applyOrElse$9(x0$1)));
                        LogicalPlan finalDataPlan = (LogicalPlan)dataPlan.transformUp((PartialFunction)new Serializable(this, hasFileMetadata, catalogTable, source){
                            private static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2 $outer;
                            private final boolean hasFileMetadata$1;
                            private final Option catalogTable$1;
                            private final SparkDataStream source$3;

                            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof LogicalRelation) {
                                    LogicalRelation logicalRelation = (LogicalRelation)A1;
                                    ObjectRef newRelation = ObjectRef.create((Object)logicalRelation);
                                    if (this.hasFileMetadata$1) {
                                        newRelation.elem = ((LogicalRelation)newRelation.elem).withMetadataColumns();
                                    }
                                    if (((LogicalRelation)newRelation.elem).catalogTable().isEmpty()) {
                                        this.catalogTable$1.foreach((Function1 & Serializable)table -> {
                                            $anonfun$2$$anonfun$3.$anonfun$applyOrElse$10(newRelation, table);
                                            return BoxedUnit.UNIT;
                                        });
                                    } else if (this.catalogTable$1.exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$2$$anonfun$3.$anonfun$applyOrElse$11(newRelation, x$12)))) {
                                        this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$anonfun$$$outer().logWarning((Function0<String>)(Function0 & Serializable)() -> "Source " + $this.source$3 + " should not produce the information of catalog table by its own.");
                                    }
                                    return (B1)((LogicalRelation)newRelation.elem);
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(LogicalPlan x1) {
                                LogicalPlan logicalPlan2 = x1;
                                return logicalPlan2 instanceof LogicalRelation;
                            }

                            public static final /* synthetic */ void $anonfun$applyOrElse$10(ObjectRef newRelation$1, CatalogTable table) {
                                LogicalRelation qual$1 = (LogicalRelation)newRelation$1.elem;
                                Some x$1 = new Some((Object)table);
                                BaseRelation x$2 = qual$1.copy$default$1();
                                Seq<AttributeReference> x$3 = qual$1.copy$default$2();
                                boolean x$4 = qual$1.copy$default$4();
                                newRelation$1.elem = qual$1.copy(x$2, x$3, (Option<CatalogTable>)x$1, x$4);
                            }

                            public static final /* synthetic */ boolean $anonfun$applyOrElse$11(ObjectRef newRelation$1, CatalogTable x$12) {
                                return x$12 != ((LogicalRelation)newRelation$1.elem).catalogTable().get();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.hasFileMetadata$1 = hasFileMetadata$1;
                                this.catalogTable$1 = catalogTable$1;
                                this.source$3 = source$3;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.catalog.CatalogTable ), $anonfun$applyOrElse$11$adapted(scala.runtime.ObjectRef org.apache.spark.sql.catalyst.catalog.CatalogTable ), $anonfun$applyOrElse$12(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$2$$anonfun$3 )}, serializedLambda);
                            }
                        });
                        $this.mutableNewData$1.put((Object)source, (Object)finalDataPlan);
                        int maxFields = SQLConf$.MODULE$.get().maxToStringFields();
                        Predef$.MODULE$.assert(output.size() == finalDataPlan.output().size(), (Function0 & Serializable)() -> "Invalid batch: " + org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(output, ",", maxFields) + " != " + org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(finalDataPlan.output(), ",", maxFields));
                        Seq aliases = (Seq)((IterableOps)output.zip((IterableOnce)finalDataPlan.output())).map((Function1 & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                Attribute from;
                                Attribute to = (Attribute)tuple2._1();
                                Attribute x$1 = from = (Attribute)tuple2._2();
                                String x$2 = to.name();
                                ExprId x$3 = to.exprId();
                                Some x$4 = new Some((Object)from.metadata());
                                Seq x$5 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                                Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                                return new Alias((Expression)x$1, x$2, x$3, x$5, (Option)x$4, x$6);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        return new Project(aliases, finalDataPlan);
                    }).getOrElse((Function0 & Serializable)() -> {
                        Seq x$7 = output;
                        boolean x$8 = true;
                        Seq x$9 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$7, x$9, true);
                    });
                }
                if (A1 instanceof StreamingDataSourceV2Relation) {
                    StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                    return (B1)this.mutableNewData$1.get((Object)streamingDataSourceV2Relation.stream()).map((Function1 & Serializable)x0$3 -> {
                        LogicalPlan logicalPlan2 = x0$3;
                        if (logicalPlan2 instanceof OffsetHolder) {
                            OffsetHolder offsetHolder = (OffsetHolder)logicalPlan2;
                            org.apache.spark.sql.connector.read.streaming.Offset start = offsetHolder.start();
                            org.apache.spark.sql.connector.read.streaming.Offset end = offsetHolder.end();
                            Some x$10 = new Some((Object)start);
                            Some x$11 = new Some((Object)end);
                            Seq x$12 = streamingDataSourceV2Relation.copy$default$1();
                            Scan x$13 = streamingDataSourceV2Relation.copy$default$2();
                            SparkDataStream x$14 = streamingDataSourceV2Relation.copy$default$3();
                            Option x$15 = streamingDataSourceV2Relation.copy$default$4();
                            Option x$16 = streamingDataSourceV2Relation.copy$default$5();
                            return streamingDataSourceV2Relation.copy(x$12, x$13, x$14, x$15, x$16, (Option)x$10, (Option)x$11);
                        }
                        throw new MatchError((Object)logicalPlan2);
                    }).getOrElse((Function0 & Serializable)() -> {
                        Seq x$17 = streamingDataSourceV2Relation.output();
                        boolean x$18 = true;
                        Seq x$19 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$17, x$19, true);
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof StreamingExecutionRelation) {
                    return true;
                }
                return logicalPlan2 instanceof StreamingDataSourceV2Relation;
            }

            public /* synthetic */ MicroBatchExecution org$apache$spark$sql$execution$streaming$MicroBatchExecution$$anonfun$$$outer() {
                return this.$outer;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$9(Attribute x0$1) {
                AttributeReference attributeReference;
                Option option;
                Attribute attribute = x0$1;
                return attribute instanceof AttributeReference && !(option = FileSourceMetadataAttribute$.MODULE$.unapply(attributeReference = (AttributeReference)attribute)).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mutableNewData$1 = mutableNewData$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$13(scala.collection.immutable.Seq int org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$14(scala.Tuple2 ), $anonfun$applyOrElse$15(scala.collection.immutable.Seq ), $anonfun$applyOrElse$16(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$17(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation ), $anonfun$applyOrElse$8(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$2 scala.collection.immutable.Seq scala.Option org.apache.spark.sql.connector.read.streaming.SparkDataStream org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$9$adapted(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
            }
        });
        this.newData_$eq((scala.collection.immutable.Map<SparkDataStream, LogicalPlan>)mutableNewData.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        LogicalPlan newAttributePlan = newBatchesPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE())), newBatchesPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof CurrentTimestamp) {
                    CurrentTimestamp currentTimestamp = (CurrentTimestamp)A1;
                    return (B1)new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentTimestamp.dataType(), (Option)new Some((Object)"Dummy TimeZoneId"));
                }
                if (A1 instanceof LocalTimestamp) {
                    LocalTimestamp localTimestamp = (LocalTimestamp)A1;
                    return (B1)new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), localTimestamp.dataType(), localTimestamp.timeZoneId());
                }
                if (A1 instanceof CurrentDate) {
                    CurrentDate currentDate = (CurrentDate)A1;
                    return (B1)new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentDate.dataType(), currentDate.timeZoneId());
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                if (expression instanceof CurrentTimestamp) {
                    return true;
                }
                if (expression instanceof LocalTimestamp) {
                    return true;
                }
                return expression instanceof CurrentDate;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Table table = this.sink();
        if (table instanceof Sink) {
            logicalPlan2 = ((WriteToMicroBatchDataSourceV1)newAttributePlan).withNewBatchId(this.currentBatchId());
        } else if (table instanceof SupportsWrite) {
            logicalPlan2 = ((WriteToMicroBatchDataSource)newAttributePlan).withNewBatchId(this.currentBatchId());
        } else {
            throw new IllegalArgumentException("unknown sink type for " + this.sink());
        }
        WriteToMicroBatchDataSourceV1 triggerLogicalPlan = logicalPlan2;
        sparkSessionToRunBatch.sparkContext().setLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY(), Long.toString(this.currentBatchId()));
        sparkSessionToRunBatch.sparkContext().setLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING(), Boolean.toString(false));
        this.reportTimeTaken("queryPlanning", (Function0 & Serializable)() -> {
            boolean isFirstBatch = this.lastExecution() == null;
            this.lastExecution_$eq(new IncrementalExecution(sparkSessionToRunBatch, triggerLogicalPlan, this.outputMode(), this.checkpointFile("state"), this.id(), this.runId(), this.currentBatchId(), this.offsetLog().offsetSeqMetadataForBatchId(this.currentBatchId() - 1L), this.offsetSeqMetadata(), this.watermarkPropagator(), isFirstBatch));
            return this.lastExecution().executedPlan();
        });
        this.markMicroBatchExecutionStart();
        Dataset nextBatch = new Dataset(this.lastExecution(), ExpressionEncoder$.MODULE$.apply(this.lastExecution().analyzed().schema()));
        Option batchSinkProgress = (Option)this.reportTimeTaken("addBatch", (Function0 & Serializable)() -> (Option)SQLExecution$.MODULE$.withNewExecutionId(this.lastExecution(), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0 & Serializable)() -> {
            Table table = this.sink();
            if (table instanceof Sink) {
                Sink sink = (Sink)table;
                sink.addBatch(this.currentBatchId(), nextBatch);
                $this.plan.catalogTable().foreach((Function1 & Serializable)tbl -> {
                    MicroBatchExecution.$anonfun$runBatch$18(this, tbl);
                    return BoxedUnit.UNIT;
                });
            } else if (table instanceof SupportsWrite) {
                nextBatch.collect();
            } else {
                throw new MatchError((Object)table);
            }
            SparkPlan sparkPlan = this.lastExecution().executedPlan();
            if (sparkPlan instanceof WriteToDataSourceV2Exec) {
                WriteToDataSourceV2Exec writeToDataSourceV2Exec = (WriteToDataSourceV2Exec)sparkPlan;
                return writeToDataSourceV2Exec.commitProgress();
            }
            return None$.MODULE$;
        }));
        this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)batchSinkProgress);
            this.markMicroBatchEnd();
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Completed batch " + this.currentBatchId());
    }

    public void markMicroBatchStart() {
        if (!this.offsetLog().add(this.currentBatchId(), this.availableOffsets().toOffsetSeq(this.sources(), this.offsetSeqMetadata()))) {
            throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(this.currentBatchId());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Committed offsets for batch " + this.currentBatchId() + ". Metadata " + this.offsetSeqMetadata().toString());
    }

    public void markMicroBatchExecutionStart() {
    }

    public void markMicroBatchEnd() {
        this.watermarkTracker().updateWatermark(this.lastExecution().executedPlan());
        this.reportTimeTaken("commitOffsets", (JFunction0.mcV.sp & Serializable)() -> {
            if (!this.commitLog().add(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark()))) {
                throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(this.currentBatchId());
            }
        });
        this.committedOffsets_$eq((StreamProgress)this.committedOffsets().$plus$plus((IterableOnce)this.availableOffsets()));
    }

    public void cleanUpLastExecutedMicroBatch() {
        if (this.currentBatchId() != 0L) {
            Option prevBatchOff = this.offsetLog().get(this.currentBatchId() - 1L);
            if (prevBatchOff.isDefined()) {
                this.commitSources((OffsetSeq)prevBatchOff.get());
                this.watermarkPropagator().purge(this.currentBatchId() - 2L);
                return;
            }
            throw new IllegalStateException("batch " + (this.currentBatchId() - 1L) + " doesn't exist");
        }
    }

    public <T> T withProgressLocked(Function0<T> f) {
        Object object;
        this.awaitProgressLock().lock();
        try {
            object = f.apply();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$getTrigger$3(MicroBatchExecution $this, SparkDataStream src) {
        boolean supports;
        block0: {
            supports = src instanceof SupportsTriggerAvailableNow;
            if (supports) break block0;
            $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "source [" + src + "] does not support Trigger.AvailableNow. Falling back to single batch execution. Note that this may not guarantee processing new data if there is an uncommitted batch. Please consult with data source developer to support Trigger.AvailableNow.");
        }
        return supports;
    }

    public static final /* synthetic */ void $anonfun$populateStartOffsets$2(MicroBatchExecution $this, SparkSession sparkSessionToRunBatches$1, OffsetSeqMetadata metadata) {
        OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, sparkSessionToRunBatches$1.conf());
        $this.offsetSeqMetadata_$eq(OffsetSeqMetadata$.MODULE$.apply(metadata.batchWatermarkMs(), metadata.batchTimestampMs(), sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker().setWatermark(metadata.batchWatermarkMs());
    }

    public static final /* synthetic */ boolean $anonfun$populateStartOffsets$7(Offset x3$1, Offset x$6) {
        Offset offset = x$6;
        Offset offset2 = x3$1;
        return !(offset != null ? !((Object)((Object)offset)).equals((Object)offset2) : offset2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$2(org.apache.spark.sql.connector.read.streaming.Offset available$1, org.apache.spark.sql.connector.read.streaming.Offset committed) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = committed;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$1;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$1(MicroBatchExecution $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SparkDataStream source = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)$this.committedOffsets().get(source).map((Function1 & Serializable)committed -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$2(available, committed))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$7(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Option o = (Option)tuple2._2();
            return o.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$9(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Option o = (Option)tuple2._2();
            return o.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$commitSources$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SparkDataStream src = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (src instanceof Source) {
                Source source = (Source)src;
                if (off instanceof Offset) {
                    Offset offset = (Offset)off;
                    source.commit(offset);
                    return;
                }
            }
        }
        if (tuple2 != null) {
            SparkDataStream stream = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (stream instanceof MicroBatchStream) {
                MicroBatchStream microBatchStream = (MicroBatchStream)stream;
                microBatchStream.commit(microBatchStream.deserializeOffset(off.json()));
                return;
            }
        }
        if (tuple2 != null) {
            SparkDataStream src = (SparkDataStream)tuple2._1();
            throw new IllegalArgumentException("Unknown source is found at constructNextBatch: " + src);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$4(Offset x3$4, org.apache.spark.sql.connector.read.streaming.Offset x$9) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$9;
        Offset offset2 = x3$4;
        return offset == null ? offset2 != null : !offset.equals((Object)offset2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$9(org.apache.spark.sql.connector.read.streaming.Offset available$2, org.apache.spark.sql.connector.read.streaming.Offset x$11) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$11;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$2;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public static final /* synthetic */ void $anonfun$runBatch$18(MicroBatchExecution $this, CatalogTable tbl) {
        $this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().catalog().refreshTable(tbl.identifier().quotedString());
    }

    public MicroBatchExecution(SparkSession sparkSession, Trigger trigger, Clock triggerClock, scala.collection.immutable.Map<String, String> extraOptions, WriteToStream plan) {
        this.extraOptions = extraOptions;
        this.plan = plan;
        super(sparkSession, plan.name(), plan.resolvedCheckpointLocation(), plan.inputQuery(), plan.sink(), trigger, triggerClock, plan.outputMode(), plan.deleteCheckpointOnStop());
        AsyncLogPurge.$init$(this);
        this.errorNotifier = new ErrorNotifier();
        this.sources = (Seq)scala.package$.MODULE$.Seq().empty();
        this.isCurrentBatchConstructed = false;
        this.watermarkPropagator = WatermarkPropagator$.MODULE$.apply(super.sparkSession().sessionState().conf());
        Statics.releaseFence();
    }
}

