/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.sql.execution.streaming.MetadataVersionUtil$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]f\u0001\u0002\u00192\u0001yB\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A\u0011\u000e\u0001B\u0002B\u0003-!\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0004x\u0001\t\u0007I1\u0002=\t\r}\u0004\u0001\u0015!\u0003z\u0011%\t\t\u0001\u0001b\u0001\n\u0017\t\u0019\u0001\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0003\u0011%\ti\u0001\u0001b\u0001\n\u0003\ty\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\t\u0011%\t\u0019\u0003\u0001b\u0001\n#\t)\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0014\u0011%\ty\u0003\u0001b\u0001\n#\t\t\u0004\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u001a\u0011)\tY\u0004\u0001b\u0001\n#)\u0014Q\b\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002@!I\u0011q\u000b\u0001C\u0002\u0013E\u0011\u0011\f\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002\\!9\u0011Q\u000f\u0001\u0005\u0012\u0005]\u0004bBA?\u0001\u0011E\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011CAC\u0011\u001d\tI\t\u0001C\t\u0003\u0017Cq!a*\u0001\t#\tI\u000bC\u0004\u00026\u0002!\t%a.\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005-\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\n\u0003o\u0004\u0011\u0013!C\u0001\u0003sDqAa\u0005\u0001\t#\u0011)\u0002C\u0004\u0003 \u0001!\tA!\t\t\u000f\t%\u0002\u0001\"\u0003\u0003,!9\u0011Q\u0018\u0001\u0005B\t=\u0002b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u0005\u0013\u0002A\u0011\tB&\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#B\u0011Ba\u0017\u0001\u0001\u0004%IA!\u0018\t\u0013\t}\u0003\u00011A\u0005\n\t\u0005\u0004\u0002\u0003B4\u0001\u0001\u0006K!a\u0014\t\u000f\t%\u0004\u0001\"\u0011\u0003l!9!\u0011\u000f\u0001\u0005\u0002\tM\u0004b\u0002B<\u0001\u0011E!\u0011\u0010\u0005\b\u0005{\u0002A\u0011\u0001B=\u0011!\u0011y\b\u0001C\u0001k\t\u0005ua\u0002BIc!\u0005!1\u0013\u0004\u0007aEB\tA!&\t\rAlC\u0011\u0001BL\u0011\u001d\u0011I*\fC\u0001\u00057\u0013q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003eM\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005Q*\u0014!C3yK\u000e,H/[8o\u0015\t1t'A\u0002tc2T!\u0001O\u001d\u0002\u000bM\u0004\u0018M]6\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0002\u0001+\tyDj\u0005\u0003\u0001\u0001\u001a\u0013\u0006CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%AB!osJ+g\rE\u0002H\u0011*k\u0011!M\u0005\u0003\u0013F\u00121\"T3uC\u0012\fG/\u0019'pOB\u00111\n\u0014\u0007\u0001\t\u0015i\u0005A1\u0001O\u0005\u0005!\u0016CA(A!\t\t\u0005+\u0003\u0002R\u0005\n9aj\u001c;iS:<\u0007CA*W\u001b\u0005!&BA+8\u0003!Ig\u000e^3s]\u0006d\u0017BA,U\u0005\u001daunZ4j]\u001e\fAb\u001d9be.\u001cVm]:j_:\u0004\"AW.\u000e\u0003UJ!\u0001X\u001b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\tA\fG\u000f\u001b\t\u0003?\u001at!\u0001\u00193\u0011\u0005\u0005\u0014U\"\u00012\u000b\u0005\rl\u0014A\u0002\u001fs_>$h(\u0003\u0002f\u0005\u00061\u0001K]3eK\u001aL!a\u001a5\u0003\rM#(/\u001b8h\u0015\t)')\u0001\u0006fm&$WM\\2fIE\u00022a\u001b8K\u001b\u0005a'BA7C\u0003\u001d\u0011XM\u001a7fGRL!a\u001c7\u0003\u0011\rc\u0017m]:UC\u001e\fa\u0001P5oSRtDc\u0001:vmR\u00111\u000f\u001e\t\u0004\u000f\u0002Q\u0005\"B5\u0005\u0001\bQ\u0007\"\u0002-\u0005\u0001\u0004I\u0006\"B/\u0005\u0001\u0004q\u0016a\u00024pe6\fGo]\u000b\u0002sB\u0011!0`\u0007\u0002w*\u0011ApO\u0001\u0007UN|g\u000eN:\n\u0005y\\(a\u0002$pe6\fGo]\u0001\tM>\u0014X.\u0019;tA\u0005AQ.\u00198jM\u0016\u001cH/\u0006\u0002\u0002\u0006A!1.a\u0002K\u0013\r\tI\u0001\u001c\u0002\t\u001b\u0006t\u0017NZ3ti\u0006IQ.\u00198jM\u0016\u001cH\u000fI\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f[\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0002gg*\u0019\u00111D\u001d\u0002\r!\fGm\\8q\u0013\u0011\ty\"!\u0006\u0003\tA\u000bG\u000f[\u0001\u000e[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0011\u0002\u0017\u0019LG.Z'b]\u0006<WM]\u000b\u0003\u0003O\u00012aRA\u0015\u0013\r\tY#\r\u0002\u0016\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s\u000311\u0017\u000e\\3NC:\fw-\u001a:!\u0003QiW\r^1eCR\f7)Y2iK\u0016s\u0017M\u00197fIV\u0011\u00111\u0007\t\u0004\u0003\u0006U\u0012bAA\u001c\u0005\n9!i\\8mK\u0006t\u0017!F7fi\u0006$\u0017\r^1DC\u000eDW-\u00128bE2,G\rI\u0001\u000bE\u0006$8\r[\"bG\",WCAA !\u001d\t\t%a\u0013\u0002P)k!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005kRLGN\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\u00075\u000b\u0007\u000fE\u0002B\u0003#J1!a\u0015C\u0005\u0011auN\\4\u0002\u0017\t\fGo\u00195DC\u000eDW\rI\u0001\u0011E\u0006$8\r\u001b$jY\u0016\u001ch)\u001b7uKJ,\"!a\u0017\u0013\r\u0005u\u00131MA8\r\u0019\tyF\u0005\u0001\u0002\\\taAH]3gS:,W.\u001a8u}\u0005\t\"-\u0019;dQ\u001aKG.Z:GS2$XM\u001d\u0011\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003ORA!!\u001b\u0002H\u0005!A.\u00198h\u0013\u0011\ti'a\u001a\u0003\r=\u0013'.Z2u!\u0011\t\u0019\"!\u001d\n\t\u0005M\u0014Q\u0003\u0002\u000b!\u0006$\bNR5mi\u0016\u0014\u0018!\u00042bi\u000eD\u0017\n\u001a+p!\u0006$\b\u000e\u0006\u0003\u0002\u0012\u0005e\u0004bBA>'\u0001\u0007\u0011qJ\u0001\bE\u0006$8\r[%e\u00035\u0001\u0018\r\u001e5U_\n\u000bGo\u00195JIR!\u0011qJAA\u0011\u0019iF\u00031\u0001\u0002\u0012\u0005Y\u0011n\u001d\"bi\u000eDg)\u001b7f)\u0011\t\u0019$a\"\t\ru+\u0002\u0019AA\t\u0003%\u0019XM]5bY&TX\r\u0006\u0004\u0002\u000e\u0006M\u0015q\u0013\t\u0004\u0003\u0006=\u0015bAAI\u0005\n!QK\\5u\u0011\u0019\t)J\u0006a\u0001\u0015\u0006AQ.\u001a;bI\u0006$\u0018\rC\u0004\u0002\u001aZ\u0001\r!a'\u0002\u0007=,H\u000f\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+a\u0012\u0002\u0005%|\u0017\u0002BAS\u0003?\u0013AbT;uaV$8\u000b\u001e:fC6\f1\u0002Z3tKJL\u0017\r\\5{KR\u0019!*a+\t\u000f\u00055v\u00031\u0001\u00020\u0006\u0011\u0011N\u001c\t\u0005\u0003;\u000b\t,\u0003\u0003\u00024\u0006}%aC%oaV$8\u000b\u001e:fC6\f1!\u00193e)\u0019\t\u0019$!/\u0002<\"9\u00111\u0010\rA\u0002\u0005=\u0003BBAK1\u0001\u0007!*A\u0002hKR$B!!1\u0002HB!\u0011)a1K\u0013\r\t)M\u0011\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005m\u0014\u00041\u0001\u0002P\u00059r-\u001a;Qe\u00164()\u0019;dQ\u001a\u0013x.\\*u_J\fw-\u001a\u000b\u0005\u0003\u001b\fy\rE\u0003B\u0003\u0007\fy\u0005C\u0004\u0002|i\u0001\r!a\u0014\u0002-\u0005\u0004\b\u000f\\=G]R{')\u0019;dQ\nK8\u000b\u001e:fC6,B!!6\u0002\\R1\u0011q[Ay\u0003g$B!!7\u0002hB\u00191*a7\u0005\u000f\u0005u7D1\u0001\u0002`\n\u0019!+\u0012+\u0012\u0007=\u000b\t\u000fE\u0002B\u0003GL1!!:C\u0005\r\te.\u001f\u0005\b\u0003S\\\u0002\u0019AAv\u0003\t1g\u000eE\u0004B\u0003[\fy+!7\n\u0007\u0005=(IA\u0005Gk:\u001cG/[8oc!9\u00111P\u000eA\u0002\u0005=\u0003\"CA{7A\u0005\t\u0019AA\u001a\u0003E\u00198.\u001b9Fq&\u001cH/\u001b8h\u0007\",7m[\u0001!CB\u0004H.\u001f$o)>\u0014\u0015\r^2i\u0005f\u001cFO]3b[\u0012\"WMZ1vYR$#'\u0006\u0003\u0002|\nEQCAA\u007fU\u0011\t\u0019$a@,\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u001bi!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0003C\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0011)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$q!!8\u001d\u0005\u0004\ty.A\u0003xe&$X\r\u0006\u0004\u0002\u000e\n]!1\u0004\u0005\b\u00053i\u0002\u0019AA\t\u0003E\u0011\u0017\r^2i\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a\u0005\b\u0003Sl\u0002\u0019\u0001B\u000f!\u001d\t\u0015Q^AN\u0003\u001b\u000b1#\u00193e\u001d\u0016<()\u0019;dQ\nK8\u000b\u001e:fC6$BAa\t\u0003(Q!\u00111\u0007B\u0013\u0011\u001d\tIO\ba\u0001\u0005;Aq!a\u001f\u001f\u0001\u0004\ty%\u0001\thKR,\u00050[:uS:<')\u0019;dQR\u0019!J!\f\t\u000f\u0005mt\u00041\u0001\u0002PQ1!\u0011\u0007B\u001f\u0005\u0003\u0002R!\u0011B\u001a\u0005oI1A!\u000eC\u0005\u0015\t%O]1z!\u0019\t%\u0011HA(\u0015&\u0019!1\b\"\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011y\u0004\ta\u0001\u0003\u001b\fqa\u001d;beRLE\rC\u0004\u0003D\u0001\u0002\r!!4\u0002\u000b\u0015tG-\u00133\u0002!\u001d,G\u000fT1uKN$()\u0019;dQ&#GCAAg\u0003%9W\r\u001e'bi\u0016\u001cH\u000f\u0006\u0002\u0003NA)\u0011)a1\u00038\u0005!r-\u001a;Pe\u0012,'/\u001a3CCR\u001c\u0007NR5mKN$\"Aa\u0015\u0011\u000b\u0005\u0013\u0019D!\u0016\u0011\t\u0005M!qK\u0005\u0005\u00053\n)B\u0001\u0006GS2,7\u000b^1ukN\f\u0011\u0003\\1tiB+(oZ3e\u0005\u0006$8\r[%e+\t\ty%A\u000bmCN$\b+\u001e:hK\u0012\u0014\u0015\r^2i\u0013\u0012|F%Z9\u0015\t\u00055%1\r\u0005\n\u0005K*\u0013\u0011!a\u0001\u0003\u001f\n1\u0001\u001f\u00132\u0003Ia\u0017m\u001d;QkJ<W\r\u001a\"bi\u000eD\u0017\n\u001a\u0011\u0002\u000bA,(oZ3\u0015\t\u00055%Q\u000e\u0005\b\u0005_:\u0003\u0019AA(\u0003A!\bN]3tQ>dGMQ1uG\"LE-\u0001\u0006qkJ<W-\u00114uKJ$B!!$\u0003v!9!q\u000e\u0015A\u0002\u0005=\u0013a\u00037jgR\u0014\u0015\r^2iKN,\"Aa\u001f\u0011\u000b\u0005\u0013\u0019$a\u0014\u0002#1L7\u000f\u001e\"bi\u000eDWm](o\t&\u001c8.A\bwC2LG-\u0019;f-\u0016\u00148/[8o)\u0019\u0011\u0019I!#\u0003\u000eB\u0019\u0011I!\"\n\u0007\t\u001d%IA\u0002J]RDaAa#,\u0001\u0004q\u0016\u0001\u0002;fqRDqAa$,\u0001\u0004\u0011\u0019)A\nnCb\u001cV\u000f\u001d9peR,GMV3sg&|g.A\bI\t\u001a\u001bV*\u001a;bI\u0006$\u0018\rT8h!\t9Uf\u0005\u0002.\u0001R\u0011!1S\u0001\u000fm\u0016\u0014\u0018NZ=CCR\u001c\u0007.\u00133t)!\tiI!(\u00034\nU\u0006b\u0002BP_\u0001\u0007!\u0011U\u0001\tE\u0006$8\r[%egB1!1\u0015BW\u0003\u001frAA!*\u0003*:\u0019\u0011Ma*\n\u0003\rK1Aa+C\u0003\u001d\u0001\u0018mY6bO\u0016LAAa,\u00032\n\u00191+Z9\u000b\u0007\t-&\tC\u0004\u0003@=\u0002\r!!4\t\u000f\t\rs\u00061\u0001\u0002N\u0002")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final String path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final boolean metadataCacheEnabled;
    private final Map<Object, T> batchCache;
    private final PathFilter batchFilesFilter;
    private long lastPurgedBatchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> batchIds, Option<Object> startId, Option<Object> endId) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(batchIds, startId, endId);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public boolean metadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    public Map<Object, T> batchCache() {
        return this.batchCache;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), Long.toString(batchId));
    }

    public long pathToBatchId(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable)() -> "'null' metadata cannot written to a metadata log");
        boolean res = this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            this.serialize(metadata, output);
            return BoxedUnit.UNIT;
        });
        Object object = this.metadataCacheEnabled() && res ? this.batchCache().put(BoxesRunTime.boxToLong((long)batchId), metadata) : BoxedUnit.UNIT;
        return res;
    }

    @Override
    public Option<T> get(long batchId) {
        None$ none$;
        if (this.metadataCacheEnabled() && this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            T metadata = this.batchCache().get(BoxesRunTime.boxToLong((long)batchId));
            Predef$.MODULE$.assert(metadata != null);
            return new Some(metadata);
        }
        try {
            none$ = (Option)this.applyFnToBatchByStream(batchId, this.applyFnToBatchByStream$default$2(), (Function1 & Serializable)input -> new Some(this.deserialize((InputStream)input)));
        }
        catch (FileNotFoundException fne) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> fne.getMessage());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Object> getPrevBatchFromStorage(long batchId) {
        Option option;
        Object object = new Object();
        try {
            long[] batchFiles = this.listBatchesOnDisk();
            ObjectRef prev = ObjectRef.create((Object)None$.MODULE$);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(batchFiles), (Ordering)Ordering.Long$.MODULE$)), (Function1)(JFunction1.mcVJ.sp & Serializable)file -> {
                if (file >= batchId) {
                    throw new NonLocalReturnControl(object, (Object)((Option)prev$1.elem));
                }
                prev$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file));
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public <RET> RET applyFnToBatchByStream(long batchId, boolean skipExistingCheck, Function1<InputStream, RET> fn) {
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (skipExistingCheck || this.fileManager().exists(batchMetadataFile)) {
            Object object;
            FSDataInputStream input = this.fileManager().open(batchMetadataFile);
            try {
                try {
                    object = fn.apply((Object)input);
                }
                catch (IllegalStateException ise) {
                    throw new IllegalStateException("Failed to read log file " + batchMetadataFile + ". " + ise.getMessage(), ise);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
            return (RET)object;
        }
        throw QueryExecutionErrors$.MODULE$.batchMetadataFileNotFoundError(batchMetadataFile);
    }

    public <RET> boolean applyFnToBatchByStream$default$2() {
        return false;
    }

    public void write(Path batchMetadataFile, Function1<OutputStream, BoxedUnit> fn) {
        CheckpointFileManager.CancellableFSDataOutputStream output = this.fileManager().createAtomic(batchMetadataFile, false);
        try {
            fn.apply((Object)output);
            output.close();
        }
        catch (FileAlreadyExistsException e) {
            throw QueryExecutionErrors$.MODULE$.multiStreamingQueriesUsingPathConcurrentlyError(this.path, e);
        }
        finally {
            output.cancel();
        }
    }

    public boolean addNewBatchByStream(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.metadataCacheEnabled() && this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId)) || this.fileManager().exists(batchMetadataFile)) {
            return false;
        }
        this.write(batchMetadataFile, fn);
        return true;
    }

    private T getExistingBatch(long batchId) {
        T metadata = this.batchCache().get(BoxesRunTime.boxToLong((long)batchId));
        if (metadata == null) {
            return (T)this.applyFnToBatchByStream(batchId, true, (Function1 & Serializable)input -> this.deserialize((InputStream)input));
        }
        return metadata;
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        long[] batchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> !(!endId.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)endId.get()) || !startId.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)startId.get())))), (Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)batchIds).toImmutableArraySeq(), startId, endId);
        return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(batchIds), (Function1 & Serializable)batchId -> HDFSMetadataLog.$anonfun$get$4(this, BoxesRunTime.unboxToLong((Object)batchId)), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Option<Object> getLatestBatchId() {
        return ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Ordering)Ordering.Long$.MODULE$)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        return ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Ordering)Ordering.Long$.MODULE$))).map((Function1 & Serializable)batchId -> HDFSMetadataLog.$anonfun$getLatest$1(this, BoxesRunTime.unboxToLong((Object)batchId)));
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (Ordering)Ordering.Long$.MODULE$)));
    }

    private long lastPurgedBatchId() {
        return this.lastPurgedBatchId;
    }

    private void lastPurgedBatchId_$eq(long x$1) {
        this.lastPurgedBatchId = x$1;
    }

    @Override
    public void purge(long thresholdBatchId) {
        NumericRange.Exclusive possibleTargetBatchIds = new RichLong(Predef$.MODULE$.longWrapper(this.lastPurgedBatchId() + 1L)).until((Object)BoxesRunTime.boxToLong((long)thresholdBatchId));
        if (possibleTargetBatchIds.length() <= 3) {
            possibleTargetBatchIds.foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
            });
        } else {
            ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> batchId < thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
            });
        }
        this.lastPurgedBatchId_$eq(thresholdBatchId - 1L);
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long());
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.longArrayOps(batchIds), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> batchId > thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
        });
    }

    public long[] listBatches() {
        long[] lArray;
        Map<Object, T> map = this.batchCache();
        synchronized (map) {
            lArray = (long[])CollectionConverters$.MODULE$.SetHasAsScala(this.batchCache().keySet()).asScala().toArray((ClassTag)ClassTag$.MODULE$.Long());
        }
        long[] batchIds = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.isFile()))), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Object)lArray, (ClassTag)ClassTag$.MODULE$.Long());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "BatchIds found from listing: " + Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(batchIds), (Ordering)Ordering.Long$.MODULE$)).mkString(", "));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(batchIds))) {
            return (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long());
        }
        return (long[])new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(batchIds).min((Ordering)Ordering.Long$.MODULE$)))).to(Predef$.MODULE$.wrapLongArray(batchIds).max((Ordering)Ordering.Long$.MODULE$)).toArray((ClassTag)ClassTag$.MODULE$.Long());
    }

    public long[] listBatchesOnDisk() {
        return (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
    }

    public int validateVersion(String text, int maxSupportedVersion) {
        return MetadataVersionUtil$.MODULE$.validateVersion(text, maxSupportedVersion);
    }

    public static final /* synthetic */ Tuple2 $anonfun$get$4(HDFSMetadataLog $this, long batchId) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.getExistingBatch(batchId));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getLatest$1(HDFSMetadataLog $this, long batchId) {
        $this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Getting latest batch " + batchId);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.getExistingBatch(batchId));
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.path = path;
        Logging.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz == null ? clazz2 != null : !clazz.equals(clazz2), (Function0 & Serializable)() -> "Should not create a log with type Seq, use Arrays instead - see SPARK-17372");
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.metadataCacheEnabled = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_METADATA_CACHE_ENABLED()));
        this.batchCache = Collections.synchronizedMap(new LinkedHashMap<Object, T>(null){

            public boolean removeEldestEntry(Map.Entry<Object, T> e) {
                return this.size() > 2;
            }
        });
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.lastPurgedBatchId = -1L;
    }
}

