/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.SinkFileStatus;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\f\u0019\u0001\u0015B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u001d\u0019\u0006A1A\u0005RQCa!\u0016\u0001!\u0002\u0013I\u0005b\u0002,\u0001\u0005\u0004%\tf\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002-\t\u000fq\u0003!\u0019!C);\"1a\f\u0001Q\u0001\n9Bqa\u0018\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004a\u0001\u0001\u0006I!\u0013\u0005\u0006C\u0002!\tEY\u0004\u0006ObA\t\u0001\u001b\u0004\u0006/aA\t!\u001b\u0005\u0006\u0019B!\t!\u001c\u0005\b]B\u0011\r\u0011\"\u0001^\u0011\u0019y\u0007\u0003)A\u0005]!9\u0001\u000f\u0005b\u0001\n\u0003\t\bBB=\u0011A\u0003%!\u000fC\u0004{!E\u0005I\u0011A>\u0003#\u0019KG.Z*ue\u0016\fWnU5oW2{wM\u0003\u0002\u001a5\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00037q\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0003cA\u0014)U5\t\u0001$\u0003\u0002*1\tA2i\\7qC\u000e$\u0018N\u00197f\r&dWm\u0015;sK\u0006lGj\\4\u0011\u0005\u001dZ\u0013B\u0001\u0017\u0019\u00059\u0019\u0016N\\6GS2,7\u000b^1ukN\f!#\\3uC\u0012\fG/\u0019'pOZ+'o]5p]B\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t\u0019\u0011J\u001c;\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005Y:T\"\u0001\u000f\n\u0005ab\"\u0001D*qCJ\\7+Z:tS>t\u0017\u0001\u00029bi\"\u0004\"a\u000f\"\u000f\u0005q\u0002\u0005CA\u001f1\u001b\u0005q$BA %\u0003\u0019a$o\\8u}%\u0011\u0011\tM\u0001\u0007!J,G-\u001a4\n\u0005\r#%AB*ue&twM\u0003\u0002Ba\u0005aqL]3uK:$\u0018n\u001c8NgB\u0019qfR%\n\u0005!\u0003$AB(qi&|g\u000e\u0005\u00020\u0015&\u00111\n\r\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0006\u001d>\u0003\u0016K\u0015\t\u0003O\u0001AQ!L\u0003A\u00029BQ\u0001N\u0003A\u0002UBQ!O\u0003A\u0002iBq!R\u0003\u0011\u0002\u0003\u0007a)\u0001\ngS2,7\t\\3b]V\u0004H)\u001a7bs6\u001bX#A%\u0002'\u0019LG.Z\"mK\u0006tW\u000f\u001d#fY\u0006LXj\u001d\u0011\u0002)%\u001cH)\u001a7fi&tw-\u0012=qSJ,G\rT8h+\u0005A\u0006CA\u0018Z\u0013\tQ\u0006GA\u0004C_>dW-\u00198\u0002+%\u001cH)\u001a7fi&tw-\u0012=qSJ,G\rT8hA\u00051B-\u001a4bk2$8i\\7qC\u000e$\u0018J\u001c;feZ\fG.F\u0001/\u0003]!WMZ1vYR\u001cu.\u001c9bGRLe\u000e^3sm\u0006d\u0007%A\u0006sKR,g\u000e^5p]6\u001b\u0018\u0001\u0004:fi\u0016tG/[8o\u001bN\u0004\u0013\u0001D:i_VdGMU3uC&tGc\u0001-dK\")AM\u0004a\u0001U\u0005\u0019An\\4\t\u000b\u0019t\u0001\u0019A%\u0002\u0017\r,(O]3oiRKW.Z\u0001\u0012\r&dWm\u0015;sK\u0006l7+\u001b8l\u0019><\u0007CA\u0014\u0011'\t\u0001\"\u000e\u0005\u00020W&\u0011A\u000e\r\u0002\u0007\u0003:L(+\u001a4\u0015\u0003!\fqAV#S'&{e*\u0001\u0005W\u000bJ\u001b\u0016j\u0014(!\u0003)\tE\tR0B\u0007RKuJT\u000b\u0002eB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\u0005Y\u0006twMC\u0001x\u0003\u0011Q\u0017M^1\n\u0005\r#\u0018aC!E\t~\u000b5\tV%P\u001d\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#\u0001?+\u0005\u0019k8&\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003%)hn\u00195fG.,GMC\u0002\u0002\bA\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class FileStreamSinkLog
extends CompactibleFileStreamLog<SinkFileStatus> {
    private final long fileCleanupDelayMs;
    private final boolean isDeletingExpiredLog;
    private final int defaultCompactInterval;
    private final long retentionMs;

    public static Option<Object> $lessinit$greater$default$4() {
        return FileStreamSinkLog$.MODULE$.$lessinit$greater$default$4();
    }

    public static String ADD_ACTION() {
        return FileStreamSinkLog$.MODULE$.ADD_ACTION();
    }

    public static int VERSION() {
        return FileStreamSinkLog$.MODULE$.VERSION();
    }

    @Override
    public long fileCleanupDelayMs() {
        return this.fileCleanupDelayMs;
    }

    @Override
    public boolean isDeletingExpiredLog() {
        return this.isDeletingExpiredLog;
    }

    @Override
    public int defaultCompactInterval() {
        return this.defaultCompactInterval;
    }

    public long retentionMs() {
        return this.retentionMs;
    }

    @Override
    public boolean shouldRetain(SinkFileStatus log, long currentTime) {
        if (this.retentionMs() < Long.MAX_VALUE) {
            if (currentTime - log.modificationTime() > this.retentionMs()) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> log.path() + " excluded by retention - current time: " + currentTime + " / modification time: " + log.modificationTime() + " / retention: " + this.retentionMs() + " ms.");
                return false;
            }
            return true;
        }
        return true;
    }

    public FileStreamSinkLog(int metadataLogVersion, SparkSession sparkSession, String path, Option<Object> _retentionMs) {
        super(metadataLogVersion, sparkSession, path, ClassTag$.MODULE$.apply(SinkFileStatus.class));
        long l;
        this.fileCleanupDelayMs = sparkSession.sessionState().conf().fileSinkLogCleanupDelay();
        this.isDeletingExpiredLog = sparkSession.sessionState().conf().fileSinkLogDeletion();
        this.defaultCompactInterval = sparkSession.sessionState().conf().fileSinkLogCompactInterval();
        Predef$.MODULE$.require(this.defaultCompactInterval() > 0, (Function0 & Serializable)() -> "Please set " + SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key() + " (was " + this.defaultCompactInterval() + ") to a positive value.");
        Option<Object> option = _retentionMs;
        if (option instanceof Some) {
            Some some = (Some)option;
            long retention = BoxesRunTime.unboxToLong((Object)some.value());
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Retention is set to " + retention + " ms");
            l = retention;
        } else {
            l = Long.MAX_VALUE;
        }
        this.retentionMs = l;
    }
}

