/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.AnsiTypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.PartitioningCollection;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.joins.ShuffledJoin;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegralType;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class ExtractJoinWithUnwrappedCastInJoinPredicates$ {
    public static final ExtractJoinWithUnwrappedCastInJoinPredicates$ MODULE$ = new ExtractJoinWithUnwrappedCastInJoinPredicates$();

    private boolean isIntegralType(DataType dt) {
        int n;
        DecimalType decimalType;
        Option option;
        DataType dataType = dt;
        if (dataType instanceof IntegralType) {
            return true;
        }
        return dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty() && 0 == (n = ((Tuple2)option.get())._2$mcI$sp());
    }

    private Seq<Expression> unwrapCastInJoinKeys(Seq<Expression> joinKeys) {
        return (Seq)joinKeys.map((Function1 & Serializable)x0$1 -> {
            Cast cast;
            Expression expression = x0$1;
            if (expression instanceof Cast && MODULE$.isIntegralType((cast = (Cast)expression).child().dataType())) {
                return cast.child();
            }
            return expression;
        });
    }

    private Seq<Tuple2<Expression, Expression>> coerceJoinKeyType(Seq<Expression> unwrapLeftKeys, Seq<Expression> unwrapRightKeys, boolean isAddCastToLeftSide) {
        return (Seq)((IterableOps)unwrapLeftKeys.zip(unwrapRightKeys)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression l = (Expression)tuple2._1();
                Expression r = (Expression)tuple2._2();
                DataType dataType = l.dataType();
                DataType dataType2 = r.dataType();
                if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                    if (isAddCastToLeftSide) {
                        Expression x$1 = l;
                        DataType x$2 = r.dataType();
                        Enumeration.Value x$3 = EvalMode$.MODULE$.TRY();
                        Option x$4 = Cast$.MODULE$.apply$default$3();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Cast(x$1, x$2, x$4, x$3)), (Object)r);
                    }
                    Expression x$5 = r;
                    DataType x$6 = l.dataType();
                    Enumeration.Value x$7 = EvalMode$.MODULE$.TRY();
                    Option x$8 = Cast$.MODULE$.apply$default$3();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l), (Object)new Cast(x$5, x$6, x$8, x$7));
                }
            }
            if (tuple2 != null) {
                Expression l = (Expression)tuple2._1();
                Expression r = (Expression)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l), (Object)r);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Option<Seq<Tuple2<Expression, Expression>>> unwrapCastInJoinPredicates(ShuffledJoin j) {
        Seq<Expression> rightKeys;
        Seq<Expression> leftKeys = this.unwrapCastInJoinKeys(j.leftKeys());
        boolean isCastToWiderType = ((IterableOnceOps)((IterableOps)leftKeys.zip(rightKeys = this.unwrapCastInJoinKeys(j.rightKeys()))).zipWithIndex()).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExtractJoinWithUnwrappedCastInJoinPredicates$.$anonfun$unwrapCastInJoinPredicates$1(j, x0$1)));
        if (isCastToWiderType) {
            boolean leftSatisfies = j.satisfiesOutputPartitioning(leftKeys, ((SparkPlan)j.left()).outputPartitioning());
            boolean rightSatisfies = j.satisfiesOutputPartitioning(rightKeys, ((SparkPlan)j.right()).outputPartitioning());
            if (leftSatisfies && rightSatisfies) {
                return new Some(this.coerceJoinKeyType(leftKeys, rightKeys, ((SparkPlan)j.left()).outputPartitioning().numPartitions() < ((SparkPlan)j.right()).outputPartitioning().numPartitions()));
            }
            if (leftSatisfies) {
                return new Some(this.coerceJoinKeyType(leftKeys, rightKeys, false));
            }
            if (rightSatisfies) {
                return new Some(this.coerceJoinKeyType(leftKeys, rightKeys, true));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private boolean isTryToUnwrapCastInJoinPredicates(ShuffledJoin j) {
        return (j.leftKeys().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExtractJoinWithUnwrappedCastInJoinPredicates$.$anonfun$isTryToUnwrapCastInJoinPredicates$1(x$1))) || j.rightKeys().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExtractJoinWithUnwrappedCastInJoinPredicates$.$anonfun$isTryToUnwrapCastInJoinPredicates$2(x$2)))) && !j.satisfiesOutputPartitioning(j.leftKeys(), ((SparkPlan)j.left()).outputPartitioning()) && !j.satisfiesOutputPartitioning(j.rightKeys(), ((SparkPlan)j.right()).outputPartitioning()) && ((IterableOnceOps)j.children().map((Function1 & Serializable)x$3 -> x$3.outputPartitioning())).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ExtractJoinWithUnwrappedCastInJoinPredicates$.$anonfun$isTryToUnwrapCastInJoinPredicates$4(x$4)));
    }

    public Option<Tuple2<ShuffledJoin, Seq<Tuple2<Expression, Expression>>>> unapply(SparkPlan plan) {
        ShuffledJoin shuffledJoin;
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof ShuffledJoin && this.isTryToUnwrapCastInJoinPredicates(shuffledJoin = (ShuffledJoin)((Object)sparkPlan))) {
            Option<Seq<Tuple2<Expression, Expression>>> option = this.unwrapCastInJoinPredicates(shuffledJoin);
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq joinKeys = (Seq)some.value();
                return new Some((Object)new Tuple2((Object)shuffledJoin, (Object)joinKeys));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$unwrapCastInJoinPredicates$1(ShuffledJoin j$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                Expression e1 = (Expression)tuple22._1();
                Expression e2 = (Expression)tuple22._2();
                return AnsiTypeCoercion$.MODULE$.findWiderTypeForTwo(e1.dataType(), e2.dataType()).contains((Object)((Expression)j$1.leftKeys().apply(i)).dataType());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isTryToUnwrapCastInJoinPredicates$1(Expression x$1) {
        return x$1 instanceof Cast;
    }

    public static final /* synthetic */ boolean $anonfun$isTryToUnwrapCastInJoinPredicates$2(Expression x$2) {
        return x$2 instanceof Cast;
    }

    public static final /* synthetic */ boolean $anonfun$isTryToUnwrapCastInJoinPredicates$4(Partitioning x$4) {
        Partitioning partitioning2 = x$4;
        if (partitioning2 instanceof PartitioningCollection) {
            return true;
        }
        return partitioning2 instanceof HashPartitioning;
    }

    private ExtractJoinWithUnwrappedCastInJoinPredicates$() {
    }
}

