/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.DataSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.streaming.CommitLog;
import org.apache.spark.sql.execution.streaming.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class StateSourceOptions$
implements DataSourceOptions,
Serializable {
    public static final StateSourceOptions$ MODULE$ = new StateSourceOptions$();
    private static final String PATH;
    private static final String BATCH_ID;
    private static final String OPERATOR_ID;
    private static final String STORE_NAME;
    private static final String JOIN_SIDE;
    private static Map<String, Option<String>> org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions;

    static {
        DataSourceOptions.$init$((DataSourceOptions)MODULE$);
        PATH = MODULE$.newOption("path");
        BATCH_ID = MODULE$.newOption("batchId");
        OPERATOR_ID = MODULE$.newOption("operatorId");
        STORE_NAME = MODULE$.newOption("storeName");
        JOIN_SIDE = MODULE$.newOption("joinSide");
    }

    public String newOption(String name) {
        return DataSourceOptions.newOption$((DataSourceOptions)this, (String)name);
    }

    public void newOption(String name, String alternative) {
        DataSourceOptions.newOption$((DataSourceOptions)this, (String)name, (String)alternative);
    }

    public Set<String> getAllOptions() {
        return DataSourceOptions.getAllOptions$((DataSourceOptions)this);
    }

    public boolean isValidOption(String name) {
        return DataSourceOptions.isValidOption$((DataSourceOptions)this, (String)name);
    }

    public Option<String> getAlternativeOption(String name) {
        return DataSourceOptions.getAlternativeOption$((DataSourceOptions)this, (String)name);
    }

    public Map<String, Option<String>> org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions() {
        return org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions;
    }

    public final void org$apache$spark$sql$catalyst$DataSourceOptions$_setter_$org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions_$eq(Map<String, Option<String>> x$1) {
        org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions = x$1;
    }

    public String PATH() {
        return PATH;
    }

    public String BATCH_ID() {
        return BATCH_ID;
    }

    public String OPERATOR_ID() {
        return OPERATOR_ID;
    }

    public String STORE_NAME() {
        return STORE_NAME;
    }

    public String JOIN_SIDE() {
        return JOIN_SIDE;
    }

    public StateSourceOptions apply(SparkSession sparkSession, Configuration hadoopConf, java.util.Map<String, String> properties) {
        return this.apply(sparkSession, hadoopConf, new CaseInsensitiveStringMap(properties));
    }

    public StateSourceOptions apply(SparkSession sparkSession, Configuration hadoopConf, CaseInsensitiveStringMap options) {
        Enumeration.Value joinSide;
        Enumeration.Value value;
        String checkpointLocation = (String)Option$.MODULE$.apply((Object)options.get((Object)this.PATH())).orElse((Function0 & Serializable)() -> {
            throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(MODULE$.PATH());
        }).get();
        String resolvedCpLocation = this.resolvedCheckpointLocation(hadoopConf, checkpointLocation);
        long batchId = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)options.get((Object)this.BATCH_ID())).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$2)))).orElse((Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.getLastCommittedBatch(sparkSession, resolvedCpLocation)))).get());
        if (batchId < 0L) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.BATCH_ID());
        }
        int operatorId = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)options.get((Object)this.OPERATOR_ID())).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3)))).orElse((Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)0))).get());
        if (operatorId < 0) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.OPERATOR_ID());
        }
        String storeName = (String)Option$.MODULE$.apply((Object)options.get((Object)this.STORE_NAME())).map((Function1 & Serializable)x$4 -> x$4.trim()).getOrElse((Function0 & Serializable)() -> StateStoreId$.MODULE$.DEFAULT_STORE_NAME());
        if (storeName.isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsEmpty(this.STORE_NAME());
        }
        try {
            value = (Enumeration.Value)Option$.MODULE$.apply((Object)options.get((Object)this.JOIN_SIDE())).map((Function1 & Serializable)s -> StateSourceOptions$JoinSideValues$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable)() -> StateSourceOptions$JoinSideValues$.MODULE$.none());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.JOIN_SIDE(), "Valid values are " + StateSourceOptions$JoinSideValues$.MODULE$.values().mkString(","));
        }
        Enumeration.Value value2 = joinSide = value;
        Enumeration.Value value3 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        if (value2 == null ? value3 != null : !value2.equals(value3)) {
            String string = storeName;
            String string2 = StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.JOIN_SIDE(), (List)new .colon.colon((Object)this.STORE_NAME(), (List)Nil$.MODULE$)));
            }
        }
        return new StateSourceOptions(resolvedCpLocation, batchId, operatorId, storeName, joinSide);
    }

    private String resolvedCheckpointLocation(Configuration hadoopConf, String checkpointLocation) {
        Path checkpointPath = new Path(checkpointLocation);
        FileSystem fs = checkpointPath.getFileSystem(hadoopConf);
        return checkpointPath.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toUri().toString();
    }

    private long getLastCommittedBatch(SparkSession session, String checkpointLocation) {
        Some some;
        Tuple2 tuple2;
        CommitLog commitLog = new CommitLog(session, new Path(checkpointLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_COMMITS()).toString());
        Option option = commitLog.getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            long lastId = tuple2._1$mcJ$sp();
            return lastId;
        }
        if (None$.MODULE$.equals(option)) {
            throw StateDataSourceErrors$.MODULE$.committedBatchUnavailable(checkpointLocation);
        }
        throw new MatchError(option);
    }

    public StateSourceOptions apply(String resolvedCpLocation, long batchId, int operatorId, String storeName, Enumeration.Value joinSide) {
        return new StateSourceOptions(resolvedCpLocation, batchId, operatorId, storeName, joinSide);
    }

    public Option<Tuple5<String, Object, Object, String, Enumeration.Value>> unapply(StateSourceOptions x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.resolvedCpLocation(), (Object)BoxesRunTime.boxToLong((long)x$0.batchId()), (Object)BoxesRunTime.boxToInteger((int)x$0.operatorId()), (Object)x$0.storeName(), (Object)x$0.joinSide()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StateSourceOptions$.class);
    }

    private StateSourceOptions$() {
    }
}

