/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasources.v2.state.StateMetadataPartitionReader;
import org.apache.spark.sql.execution.datasources.v2.state.StateMetadataTableEntry;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreInputPartition;
import org.apache.spark.sql.execution.datasources.v2.state.StateTable$;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\f\u0018\u0001!B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u001d9\u0007A1A\u0005\n!Da!\u001b\u0001!\u0002\u0013Q\u0006b\u00026\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007W\u0002\u0001\u000b\u0011\u0002.\t\u00111\u0004\u0001R1A\u0005\n5D\u0001\"\u001d\u0001\t\u0006\u0004%IA\u001d\u0005\f\u0003\u0007\u0001\u0001\u0019!a\u0001\n\u0013\t)\u0001C\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\n\u0005%\u0001BCA\f\u0001\u0001\u0007\t\u0011)Q\u0005s!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001\"CA\u0012\u0001\t\u0007I\u0011BA\u0013\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005\u001d\u0002bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!!\u0012\u0001\t\u0013\t9E\u0001\u000bTi\u0006$X\rU1si&$\u0018n\u001c8SK\u0006$WM\u001d\u0006\u00031e\tQa\u001d;bi\u0016T!AG\u000e\u0002\u0005Y\u0014$B\u0001\u000f\u001e\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005yy\u0012!C3yK\u000e,H/[8o\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011&M \u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t1qJ\u00196fGR\u00042AM\u001c:\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011\u0011X-\u00193\u000b\u0005Yz\u0012!C2p]:,7\r^8s\u0013\tA4GA\bQCJ$\u0018\u000e^5p]J+\u0017\rZ3s!\tQT(D\u0001<\u0015\tat$\u0001\u0005dCR\fG._:u\u0013\tq4HA\u0006J]R,'O\\1m%><\bC\u0001!D\u001b\u0005\t%B\u0001\"\"\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001#B\u0005\u001daunZ4j]\u001e\f\u0011b\u001d;pe\u0016\u001cuN\u001c4\u0011\u0005\u001d[U\"\u0001%\u000b\u0005aI%B\u0001&\u001e\u0003%\u0019HO]3b[&tw-\u0003\u0002M\u0011\nq1\u000b^1uKN#xN]3D_:4\u0017A\u00035bI>|\u0007oQ8oMB\u0011qJU\u0007\u0002!*\u0011\u0011+I\u0001\u0005kRLG.\u0003\u0002T!\nI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002W/6\tq#\u0003\u0002Y/\tA2\u000b^1uKN#xN]3J]B,H\u000fU1si&$\u0018n\u001c8\u0002\rM\u001c\u0007.Z7b!\tYf,D\u0001]\u0015\tiv$A\u0003usB,7/\u0003\u0002`9\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\rqJg.\u001b;?)\u0015\u00117\rZ3g!\t1\u0006\u0001C\u0003F\u000b\u0001\u0007a\tC\u0003N\u000b\u0001\u0007a\nC\u0003U\u000b\u0001\u0007Q\u000bC\u0003Z\u000b\u0001\u0007!,A\u0005lKf\u001c6\r[3nCV\t!,\u0001\u0006lKf\u001c6\r[3nC\u0002\n1B^1mk\u0016\u001c6\r[3nC\u0006aa/\u00197vKN\u001b\u0007.Z7bA\u0005)1\u000f^8sKV\ta\u000e\u0005\u0002H_&\u0011\u0001\u000f\u0013\u0002\u000f%\u0016\fGm\u0015;bi\u0016\u001cFo\u001c:f\u0003\u0011IG/\u001a:\u0016\u0003M\u00042\u0001\u001e@:\u001d\t)8P\u0004\u0002ws6\tqO\u0003\u0002yO\u00051AH]8pizJ\u0011A_\u0001\u0006g\u000e\fG.Y\u0005\u0003yv\fq\u0001]1dW\u0006<WMC\u0001{\u0013\ry\u0018\u0011\u0001\u0002\t\u0013R,'/\u0019;pe*\u0011A0`\u0001\bGV\u0014(/\u001a8u+\u0005I\u0014aC2veJ,g\u000e^0%KF$B!a\u0003\u0002\u0014A!\u0011QBA\b\u001b\u0005i\u0018bAA\t{\n!QK\\5u\u0011!\t)\"DA\u0001\u0002\u0004I\u0014a\u0001=%c\u0005A1-\u001e:sK:$\b%\u0001\u0003oKb$HCAA\u000f!\u0011\ti!a\b\n\u0007\u0005\u0005RPA\u0004C_>dW-\u00198\u0002\u0013)|\u0017N\\3e%><XCAA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017w\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t\t$a\u000b\u0003\u0013){\u0017N\\3e%><\u0018A\u00036pS:,GMU8xA\u0005Y\u0011\r\u001a3NKR\fG-\u0019;b)\rI\u0014\u0011\b\u0005\u0007\u0003w\u0011\u0002\u0019A\u001d\u0002\u0007I|w/A\u0002hKR$\u0012!O\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u0017\t\u0011#\u001e8jMf\u001cF/\u0019;f%><\b+Y5s)\rI\u0014\u0011\n\u0005\b\u0003\u0017*\u0002\u0019AA'\u0003\u0011\u0001\u0018-\u001b:\u0011\u0011\u00055\u0011qJA*\u0003'J1!!\u0015~\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011FA+\u0013\u0011\t9&a\u000b\u0003\u0013Us7/\u00194f%><\b")
public class StatePartitionReader
implements PartitionReader<InternalRow>,
Logging {
    private ReadStateStore store;
    private Iterator<InternalRow> iter;
    private StateStoreConf storeConf;
    private final SerializableConfiguration hadoopConf;
    private final StateStoreInputPartition partition;
    private StructType keySchema;
    private StructType valueSchema;
    private InternalRow current;
    private final JoinedRow joinedRow;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType keySchema() {
        return this.keySchema;
    }

    private StructType valueSchema() {
        return this.valueSchema;
    }

    private ReadStateStore store$lzycompute() {
        StatePartitionReader statePartitionReader = this;
        synchronized (statePartitionReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                int n;
                StateStoreId stateStoreId = new StateStoreId(this.partition.sourceOptions().stateCheckpointLocation().toString(), this.partition.sourceOptions().operatorId(), this.partition.partition(), this.partition.sourceOptions().storeName());
                StateStoreProviderId stateStoreProviderId = new StateStoreProviderId(stateStoreId, this.partition.queryId());
                StateMetadataTableEntry[] allStateStoreMetadata = (StateMetadataTableEntry[])new StateMetadataPartitionReader(this.partition.sourceOptions().stateCheckpointLocation().getParent().toString(), this.hadoopConf).stateMetadata().toArray(ClassTag$.MODULE$.apply(StateMetadataTableEntry.class));
                StateMetadataTableEntry[] stateStoreMetadata = (StateMetadataTableEntry[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allStateStoreMetadata), (Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)StatePartitionReader.$anonfun$store$1(this, entry)));
                if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata))) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Metadata for state store not found, possible cause is this checkpoint is created by older version of spark. If the query has session window aggregation, the state can't be read correctly and runtime exception will be thrown. Run the streaming query in newer spark version to generate state metadata can fix the issue.");
                    n = 0;
                } else {
                    Predef$.MODULE$.require(stateStoreMetadata.length == 1);
                    n = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata))).numColsPrefixKey();
                }
                int numColsPrefixKey = n;
                this.store = StateStore$.MODULE$.getReadOnly(stateStoreProviderId, this.keySchema(), this.valueSchema(), numColsPrefixKey, this.partition.sourceOptions().batchId() + 1L, this.storeConf, this.hadoopConf.value());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.storeConf = null;
        this.keySchema = null;
        this.valueSchema = null;
        return this.store;
    }

    private ReadStateStore store() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.store$lzycompute();
        }
        return this.store;
    }

    private Iterator<InternalRow> iter$lzycompute() {
        StatePartitionReader statePartitionReader = this;
        synchronized (statePartitionReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.iter = this.store().iterator().map((Function1 & Serializable)pair -> this.unifyStateRowPair((Tuple2<UnsafeRow, UnsafeRow>)new Tuple2((Object)pair.key(), (Object)pair.value())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.iter;
    }

    private Iterator<InternalRow> iter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.iter$lzycompute();
        }
        return this.iter;
    }

    private InternalRow current() {
        return this.current;
    }

    private void current_$eq(InternalRow x$1) {
        this.current = x$1;
    }

    public boolean next() {
        if (this.iter().hasNext()) {
            this.current_$eq((InternalRow)this.iter().next());
            return true;
        }
        this.current_$eq(null);
        return false;
    }

    private JoinedRow joinedRow() {
        return this.joinedRow;
    }

    private InternalRow addMetadata(InternalRow row) {
        GenericInternalRow metadataRow = new GenericInternalRow((Object[])((IterableOnceOps)((IterableOps)StateTable$.MODULE$.METADATA_COLUMNS().map((Function1 & Serializable)x$2 -> x$2.name())).map((Function1 & Serializable)x0$1 -> {
            String string = x0$1;
            if ("_partition_id".equals(string)) {
                return BoxesRunTime.boxToInteger((int)$this.partition.partition());
            }
            throw new MatchError((Object)string);
        })).toArray(ClassTag$.MODULE$.Any()));
        return this.joinedRow().withLeft(row).withRight((InternalRow)metadataRow);
    }

    public InternalRow get() {
        return this.addMetadata(this.current());
    }

    public void close() {
        this.current_$eq(null);
        this.store().abort();
    }

    private InternalRow unifyStateRowPair(Tuple2<UnsafeRow, UnsafeRow> pair) {
        GenericInternalRow row = new GenericInternalRow(2);
        row.update(0, pair._1());
        row.update(1, pair._2());
        return row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$store$1(StatePartitionReader $this, StateMetadataTableEntry entry) {
        if (entry.operatorId() != (long)$this.partition.sourceOptions().operatorId()) return false;
        String string = entry.stateStoreName();
        String string2 = $this.partition.sourceOptions().storeName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public StatePartitionReader(StateStoreConf storeConf, SerializableConfiguration hadoopConf, StateStoreInputPartition partition, StructType schema) {
        this.storeConf = storeConf;
        this.hadoopConf = hadoopConf;
        this.partition = partition;
        Logging.$init$((Logging)this);
        this.keySchema = (StructType)SchemaUtil$.MODULE$.getSchemaAsDataType(schema, "key");
        this.valueSchema = (StructType)SchemaUtil$.MODULE$.getSchemaAsDataType(schema, "value");
        this.joinedRow = new JoinedRow();
    }
}

