/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.DropNamespaceExec$;
import org.apache.spark.sql.execution.datasources.v2.LeafV2CommandExec;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u0010!\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t%\u0002\u0011\t\u0012)A\u0005\u0017\"A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005a\u0001\tE\t\u0015!\u0003V\u0011!\t\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00034\u0001\u0005#\u0005\u000b\u0011B2\t\u0011\u001d\u0004!Q3A\u0005\u0002\tD\u0001\u0002\u001b\u0001\u0003\u0012\u0003\u0006Ia\u0019\u0005\u0006S\u0002!\tA\u001b\u0005\u0006a\u0002!\t&\u001d\u0005\u0006s\u0002!\tE\u001f\u0005\n\u0003\u000b\u0001\u0011\u0011!C\u0001\u0003\u000fA\u0011\"!\u0005\u0001#\u0003%\t!a\u0005\t\u0013\u0005%\u0002!%A\u0005\u0002\u0005-\u0002\"CA\u0018\u0001E\u0005I\u0011AA\u0019\u0011%\t)\u0004AI\u0001\n\u0003\t\t\u0004C\u0005\u00028\u0001\t\t\u0011\"\u0011\u0002:!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00111\n\u0005\n\u0003'\u0002\u0011\u0011!C\u0001\u0003+B\u0011\"!\u0019\u0001\u0003\u0003%\t%a\u0019\t\u0013\u0005E\u0004!!A\u0005\u0002\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u0011%\ti\bAA\u0001\n\u0003\nyhB\u0005\u0002\u0004\u0002\n\t\u0011#\u0001\u0002\u0006\u001aAq\u0004IA\u0001\u0012\u0003\t9\t\u0003\u0004j3\u0011\u0005\u0011q\u0014\u0005\n\u0003CK\u0012\u0011!C#\u0003GC\u0011\"!*\u001a\u0003\u0003%\t)a*\t\u0013\u0005E\u0016$!A\u0005\u0002\u0006M\u0006\"CAc3\u0005\u0005I\u0011BAd\u0005E!%o\u001c9OC6,7\u000f]1dK\u0016CXm\u0019\u0006\u0003C\t\n!A\u001e\u001a\u000b\u0005\r\"\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT!!\n\u0014\u0002\u0013\u0015DXmY;uS>t'BA\u0014)\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003S)\nQa\u001d9be.T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011#\u0002\u00011i]j\u0004CA\u00193\u001b\u0005\u0001\u0013BA\u001a!\u000551&gQ8n[\u0006tG-\u0012=fGB\u0011\u0011'N\u0005\u0003m\u0001\u0012\u0011\u0003T3bMZ\u00134i\\7nC:$W\t_3d!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"/\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(A\u0004dCR\fGn\\4\u0016\u0003-\u0003\"\u0001\u0014)\u000e\u00035S!!\u0013(\u000b\u0005=3\u0013!C2p]:,7\r^8s\u0013\t\tVJA\u0007DCR\fGn\\4QYV<\u0017N\\\u0001\tG\u0006$\u0018\r\\8hA\u0005Ia.Y7fgB\f7-Z\u000b\u0002+B\u0019aH\u0016-\n\u0005]C%aA*fcB\u0011\u0011,\u0018\b\u00035n\u0003\"\u0001Q\u001d\n\u0005qK\u0014A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001X\u001d\u0002\u00159\fW.Z:qC\u000e,\u0007%\u0001\u0005jM\u0016C\u0018n\u001d;t+\u0005\u0019\u0007C\u0001\u001de\u0013\t)\u0017HA\u0004C_>dW-\u00198\u0002\u0013%4W\t_5tiN\u0004\u0013aB2bg\u000e\fG-Z\u0001\tG\u0006\u001c8-\u00193fA\u00051A(\u001b8jiz\"Ra\u001b7n]>\u0004\"!\r\u0001\t\u000b%K\u0001\u0019A&\t\u000bMK\u0001\u0019A+\t\u000b\u0005L\u0001\u0019A2\t\u000b\u001dL\u0001\u0019A2\u0002\u0007I,h\u000eF\u0001s!\rqdk\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m\u001a\n\u0001bY1uC2L8\u000f^\u0005\u0003qV\u00141\"\u00138uKJt\u0017\r\u001c*po\u00061q.\u001e;qkR,\u0012a\u001f\t\u0004}Yc\bcA?\u0002\u00025\taP\u0003\u0002\u0000k\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\r\t\u0019A \u0002\n\u0003R$(/\u001b2vi\u0016\fAaY8qsRI1.!\u0003\u0002\f\u00055\u0011q\u0002\u0005\b\u00132\u0001\n\u00111\u0001L\u0011\u001d\u0019F\u0002%AA\u0002UCq!\u0019\u0007\u0011\u0002\u0003\u00071\rC\u0004h\u0019A\u0005\t\u0019A2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0003\u0016\u0004\u0017\u0006]1FAA\r!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r\u0012(\u0001\u0006b]:|G/\u0019;j_:LA!a\n\u0002\u001e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0006\u0016\u0004+\u0006]\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003gQ3aYA\f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA\u0001\\1oO*\u0011\u0011QI\u0001\u0005U\u00064\u0018-C\u0002_\u0003\u007f\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0014\u0011\u0007a\ny%C\u0002\u0002Re\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0016\u0002^A\u0019\u0001(!\u0017\n\u0007\u0005m\u0013HA\u0002B]fD\u0011\"a\u0018\u0014\u0003\u0003\u0005\r!!\u0014\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0007\u0005\u0004\u0002h\u00055\u0014qK\u0007\u0003\u0003SR1!a\u001b:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\nIG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA2\u0002v!I\u0011qL\u000b\u0002\u0002\u0003\u0007\u0011qK\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002<\u0005m\u0004\"CA0-\u0005\u0005\t\u0019AA'\u0003\u0019)\u0017/^1mgR\u00191-!!\t\u0013\u0005}s#!AA\u0002\u0005]\u0013!\u0005#s_Bt\u0015-\\3ta\u0006\u001cW-\u0012=fGB\u0011\u0011'G\n\u00063\u0005%\u0015Q\u0013\t\n\u0003\u0017\u000b\tjS+dG.l!!!$\u000b\u0007\u0005=\u0015(A\u0004sk:$\u0018.\\3\n\t\u0005M\u0015Q\u0012\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003BAL\u0003;k!!!'\u000b\t\u0005m\u00151I\u0001\u0003S>L1aRAM)\t\t))\u0001\u0005u_N#(/\u001b8h)\t\tY$A\u0003baBd\u0017\u0010F\u0005l\u0003S\u000bY+!,\u00020\")\u0011\n\ba\u0001\u0017\")1\u000b\ba\u0001+\")\u0011\r\ba\u0001G\")q\r\ba\u0001G\u00069QO\\1qa2LH\u0003BA[\u0003\u0003\u0004R\u0001OA\\\u0003wK1!!/:\u0005\u0019y\u0005\u000f^5p]B9\u0001(!0L+\u000e\u001c\u0017bAA`s\t1A+\u001e9mKRB\u0001\"a1\u001e\u0003\u0003\u0005\ra[\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAe!\u0011\ti$a3\n\t\u00055\u0017q\b\u0002\u0007\u001f\nTWm\u0019;")
public class DropNamespaceExec
extends V2CommandExec
implements LeafV2CommandExec {
    private final CatalogPlugin catalog;
    private final Seq<String> namespace;
    private final boolean ifExists;
    private final boolean cascade;

    public static Option<Tuple4<CatalogPlugin, Seq<String>, Object, Object>> unapply(DropNamespaceExec x$0) {
        return DropNamespaceExec$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<CatalogPlugin, Seq<String>, Object, Object>, DropNamespaceExec> tupled() {
        return DropNamespaceExec$.MODULE$.tupled();
    }

    public static Function1<CatalogPlugin, Function1<Seq<String>, Function1<Object, Function1<Object, DropNamespaceExec>>>> curried() {
        return DropNamespaceExec$.MODULE$.curried();
    }

    public final Seq<SparkPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public CatalogPlugin catalog() {
        return this.catalog;
    }

    public Seq<String> namespace() {
        return this.namespace;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean cascade() {
        return this.cascade;
    }

    @Override
    public Seq<InternalRow> run() {
        String[] ns;
        SupportsNamespaces nsCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog()).asNamespaceCatalog();
        if (nsCatalog.namespaceExists(ns = (String[])this.namespace().toArray(ClassTag$.MODULE$.apply(String.class)))) {
            boolean bl;
            try {
                bl = nsCatalog.dropNamespace(ns, this.cascade());
            }
            catch (NonEmptyNamespaceException nonEmptyNamespaceException) {
                throw QueryCompilationErrors$.MODULE$.cannotDropNonemptyNamespaceError(this.namespace());
            }
            v2 = BoxesRunTime.boxToBoolean((boolean)bl);
        } else {
            if (!this.ifExists()) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(ns);
            }
            v2 = BoxedUnit.UNIT;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<Attribute> output() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public DropNamespaceExec copy(CatalogPlugin catalog, Seq<String> namespace, boolean ifExists, boolean cascade) {
        return new DropNamespaceExec(catalog, namespace, ifExists, cascade);
    }

    public CatalogPlugin copy$default$1() {
        return this.catalog();
    }

    public Seq<String> copy$default$2() {
        return this.namespace();
    }

    public boolean copy$default$3() {
        return this.ifExists();
    }

    public boolean copy$default$4() {
        return this.cascade();
    }

    public String productPrefix() {
        return "DropNamespaceExec";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.catalog();
            }
            case 1: {
                return this.namespace();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.ifExists());
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.cascade());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropNamespaceExec;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "catalog";
            }
            case 1: {
                return "namespace";
            }
            case 2: {
                return "ifExists";
            }
            case 3: {
                return "cascade";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropNamespaceExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropNamespaceExec dropNamespaceExec = (DropNamespaceExec)x$1;
        if (this.ifExists() != dropNamespaceExec.ifExists()) return false;
        if (this.cascade() != dropNamespaceExec.cascade()) return false;
        CatalogPlugin catalogPlugin = this.catalog();
        CatalogPlugin catalogPlugin2 = dropNamespaceExec.catalog();
        if (catalogPlugin == null) {
            if (catalogPlugin2 != null) {
                return false;
            }
        } else if (!catalogPlugin.equals(catalogPlugin2)) return false;
        Seq<String> seq = this.namespace();
        Seq<String> seq2 = dropNamespaceExec.namespace();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!dropNamespaceExec.canEqual(this)) return false;
        return true;
    }

    public DropNamespaceExec(CatalogPlugin catalog, Seq<String> namespace, boolean ifExists, boolean cascade) {
        this.catalog = catalog;
        this.namespace = namespace;
        this.ifExists = ifExists;
        this.cascade = cascade;
        LeafLike.$init$((LeafLike)this);
    }
}

