/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadState;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVectorUpdater;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVectorUpdaterFactory;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;

public final class VectorizedRleValuesReader
extends ValuesReader
implements VectorizedValuesReader {
    private ByteBufferInputStream in;
    private int bitWidth;
    private int bytesWidth;
    private BytePacker packer;
    private MODE mode;
    private int currentCount;
    private int currentValue;
    private int[] currentBuffer = new int[16];
    private int currentBufferIdx = 0;
    private final boolean fixedWidth;
    private final boolean readLength;

    public VectorizedRleValuesReader() {
        this.fixedWidth = false;
        this.readLength = false;
    }

    public VectorizedRleValuesReader(int bitWidth) {
        this.fixedWidth = true;
        this.readLength = bitWidth != 0;
        this.init(bitWidth);
    }

    public VectorizedRleValuesReader(int bitWidth, boolean readLength) {
        this.fixedWidth = true;
        this.readLength = readLength;
        this.init(bitWidth);
    }

    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.in = in;
        if (this.fixedWidth) {
            if (this.readLength) {
                int length = this.readIntLittleEndian();
                this.in = in.sliceStream((long)length);
            }
        } else if (in.available() > 0) {
            this.init(in.read());
        }
        if (this.bitWidth == 0) {
            this.mode = MODE.RLE;
            this.currentCount = valueCount;
            this.currentValue = 0;
        } else {
            this.currentCount = 0;
        }
    }

    private void init(int bitWidth) {
        Preconditions.checkArgument((bitWidth >= 0 && bitWidth <= 32 ? 1 : 0) != 0, (String)"bitWidth must be >= 0 and <= 32");
        this.bitWidth = bitWidth;
        this.bytesWidth = BytesUtils.paddedByteCountFromBits((int)bitWidth);
        this.packer = Packer.LITTLE_ENDIAN.newBytePacker(bitWidth);
    }

    @Override
    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    public void skip() {
        this.readInteger();
    }

    public int readValueDictionaryId() {
        return this.readInteger();
    }

    @Override
    public int readInteger() {
        if (this.currentCount == 0) {
            this.readNextGroup();
        }
        --this.currentCount;
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case MODE.RLE -> this.currentValue;
            case MODE.PACKED -> this.currentBuffer[this.currentBufferIdx++];
        };
    }

    public void readBatch(ParquetReadState state, WritableColumnVector values, WritableColumnVector defLevels, VectorizedValuesReader valueReader, ParquetVectorUpdater updater) {
        if (defLevels == null) {
            this.readBatchInternal(state, values, values, valueReader, updater);
        } else {
            this.readBatchInternalWithDefLevels(state, values, values, defLevels, valueReader, updater);
        }
    }

    public void readIntegers(ParquetReadState state, WritableColumnVector values, WritableColumnVector nulls, WritableColumnVector defLevels, VectorizedValuesReader valueReader) {
        if (defLevels == null) {
            this.readBatchInternal(state, values, nulls, valueReader, new ParquetVectorUpdaterFactory.IntegerUpdater());
        } else {
            this.readBatchInternalWithDefLevels(state, values, nulls, defLevels, valueReader, new ParquetVectorUpdaterFactory.IntegerUpdater());
        }
    }

    private void readBatchInternal(ParquetReadState state, WritableColumnVector values, WritableColumnVector nulls, VectorizedValuesReader valueReader, ParquetVectorUpdater updater) {
        long rowId = state.rowId;
        int leftInBatch = state.rowsToReadInBatch;
        int leftInPage = state.valuesToReadInPage;
        while (leftInBatch > 0 && leftInPage > 0 && (this.currentCount != 0 || this.readNextGroup())) {
            int n = Math.min(leftInBatch, Math.min(leftInPage, this.currentCount));
            long rangeStart = state.currentRangeStart();
            long rangeEnd = state.currentRangeEnd();
            if (rowId + (long)n < rangeStart) {
                this.skipValues(n, state, valueReader, updater);
                rowId += (long)n;
                leftInPage -= n;
                continue;
            }
            if (rowId > rangeEnd) {
                state.nextRange();
                continue;
            }
            long start = Math.max(rangeStart, rowId);
            long end = Math.min(rangeEnd, rowId + (long)n - 1L);
            int toSkip = (int)(start - rowId);
            if (toSkip > 0) {
                this.skipValues(toSkip, state, valueReader, updater);
                rowId += (long)toSkip;
                leftInPage -= toSkip;
            }
            n = (int)(end - start + 1L);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == state.maxDefinitionLevel) {
                        updater.readValues(n, state.valueOffset, values, valueReader);
                    } else {
                        nulls.putNulls(state.valueOffset, n);
                    }
                    state.valueOffset += n;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        int currentValue;
                        if ((currentValue = this.currentBuffer[this.currentBufferIdx++]) == state.maxDefinitionLevel) {
                            updater.readValue(state.valueOffset++, values, valueReader);
                            continue;
                        }
                        nulls.putNull(state.valueOffset++);
                    }
                    break;
                }
            }
            state.levelOffset += n;
            leftInBatch -= n;
            rowId += (long)n;
            leftInPage -= n;
            this.currentCount -= n;
        }
        state.rowsToReadInBatch = leftInBatch;
        state.valuesToReadInPage = leftInPage;
        state.rowId = rowId;
    }

    private void readBatchInternalWithDefLevels(ParquetReadState state, WritableColumnVector values, WritableColumnVector nulls, WritableColumnVector defLevels, VectorizedValuesReader valueReader, ParquetVectorUpdater updater) {
        long rowId = state.rowId;
        int leftInBatch = state.rowsToReadInBatch;
        int leftInPage = state.valuesToReadInPage;
        while (leftInBatch > 0 && leftInPage > 0 && (this.currentCount != 0 || this.readNextGroup())) {
            int n = Math.min(leftInBatch, Math.min(leftInPage, this.currentCount));
            long rangeStart = state.currentRangeStart();
            long rangeEnd = state.currentRangeEnd();
            if (rowId + (long)n < rangeStart) {
                this.skipValues(n, state, valueReader, updater);
                rowId += (long)n;
                leftInPage -= n;
                continue;
            }
            if (rowId > rangeEnd) {
                state.nextRange();
                continue;
            }
            long start = Math.max(rangeStart, rowId);
            long end = Math.min(rangeEnd, rowId + (long)n - 1L);
            int toSkip = (int)(start - rowId);
            if (toSkip > 0) {
                this.skipValues(toSkip, state, valueReader, updater);
                rowId += (long)toSkip;
                leftInPage -= toSkip;
            }
            n = (int)(end - start + 1L);
            this.readValuesN(n, state, defLevels, values, nulls, valueReader, updater);
            state.levelOffset += n;
            leftInBatch -= n;
            rowId += (long)n;
            leftInPage -= n;
            this.currentCount -= n;
            defLevels.addElementsAppended(n);
        }
        state.rowsToReadInBatch = leftInBatch;
        state.valuesToReadInPage = leftInPage;
        state.rowId = rowId;
    }

    public void readBatchRepeated(ParquetReadState state, WritableColumnVector repLevels, VectorizedRleValuesReader defLevelsReader, WritableColumnVector defLevels, WritableColumnVector values, VectorizedValuesReader valueReader, ParquetVectorUpdater updater) {
        this.readBatchRepeatedInternal(state, repLevels, defLevelsReader, defLevels, values, values, true, valueReader, updater);
    }

    public void readIntegersRepeated(ParquetReadState state, WritableColumnVector repLevels, VectorizedRleValuesReader defLevelsReader, WritableColumnVector defLevels, WritableColumnVector values, WritableColumnVector nulls, VectorizedValuesReader valueReader) {
        this.readBatchRepeatedInternal(state, repLevels, defLevelsReader, defLevels, values, nulls, false, valueReader, new ParquetVectorUpdaterFactory.IntegerUpdater());
    }

    public void readBatchRepeatedInternal(ParquetReadState state, WritableColumnVector repLevels, VectorizedRleValuesReader defLevelsReader, WritableColumnVector defLevels, WritableColumnVector values, WritableColumnVector nulls, boolean valuesReused, VectorizedValuesReader valueReader, ParquetVectorUpdater updater) {
        int leftInBatch = state.rowsToReadInBatch;
        int leftInPage = state.valuesToReadInPage;
        long rowId = state.rowId;
        DefLevelProcessor defLevelProcessor = new DefLevelProcessor(defLevelsReader, state, defLevels, values, nulls, valuesReused, valueReader, updater);
        while (!(leftInBatch <= 0 && state.lastListCompleted || leftInPage <= 0 || this.currentCount == 0 && !this.readNextGroup())) {
            int valuesLeftInBlock = Math.min(leftInPage, this.currentCount);
            long rangeStart = state.currentRangeStart();
            long rangeEnd = state.currentRangeEnd();
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == 0) {
                        if (leftInBatch == 0) {
                            state.lastListCompleted = true;
                            break;
                        }
                        int n = Math.min(leftInBatch, valuesLeftInBlock);
                        if (rowId + (long)n < rangeStart) {
                            defLevelProcessor.skipValues(n);
                            rowId += (long)n;
                            this.currentCount -= n;
                            leftInPage -= n;
                            break;
                        }
                        if (rowId > rangeEnd) {
                            state.nextRange();
                            break;
                        }
                        long start = Math.max(rangeStart, rowId);
                        long end = Math.min(rangeEnd, rowId + (long)n - 1L);
                        int toSkip = (int)(start - rowId);
                        if (toSkip > 0) {
                            defLevelProcessor.skipValues(toSkip);
                            rowId += (long)toSkip;
                            this.currentCount -= toSkip;
                            leftInPage -= toSkip;
                        }
                        if ((n = (int)(end - start + 1L)) > 0) {
                            repLevels.appendInts(n, 0);
                            defLevelProcessor.readValues(n);
                        }
                        rowId += (long)n;
                        this.currentCount -= n;
                        leftInBatch -= n;
                        leftInPage -= n;
                        break;
                    }
                    if (!state.shouldSkip) {
                        repLevels.appendInts(valuesLeftInBlock, this.currentValue);
                    }
                    state.numBatchedDefLevels += valuesLeftInBlock;
                    leftInPage -= valuesLeftInBlock;
                    this.currentCount -= valuesLeftInBlock;
                    break;
                }
                case PACKED: {
                    int i;
                    for (i = 0; i < valuesLeftInBlock; ++i) {
                        int currentValue = this.currentBuffer[this.currentBufferIdx + i];
                        if (currentValue == 0) {
                            if (leftInBatch == 0) {
                                state.lastListCompleted = true;
                                break;
                            }
                            if (rowId < rangeStart) {
                                defLevelProcessor.skipValues(1);
                            } else {
                                if (rowId > rangeEnd) {
                                    state.nextRange();
                                    break;
                                }
                                --leftInBatch;
                                repLevels.appendInt(0);
                                defLevelProcessor.readValues(1);
                            }
                            ++rowId;
                            continue;
                        }
                        if (!state.shouldSkip) {
                            repLevels.appendInt(currentValue);
                        }
                        ++state.numBatchedDefLevels;
                    }
                    leftInPage -= i;
                    this.currentCount -= i;
                    this.currentBufferIdx += i;
                }
            }
        }
        defLevelProcessor.finish();
        state.rowsToReadInBatch = leftInBatch;
        state.valuesToReadInPage = leftInPage;
        state.rowId = rowId;
    }

    private void readValues(int total, ParquetReadState state, WritableColumnVector defLevels, WritableColumnVector values, WritableColumnVector nulls, boolean valuesReused, VectorizedValuesReader valueReader, ParquetVectorUpdater updater) {
        int num;
        defLevels.reserveAdditional(total);
        values.reserveAdditional(total);
        if (!valuesReused) {
            nulls.reserveAdditional(total);
        }
        int initialValueOffset = state.valueOffset;
        for (int n = total; n > 0 && (this.currentCount != 0 || this.readNextGroup()); n -= num) {
            num = Math.min(n, this.currentCount);
            this.readValuesN(num, state, defLevels, values, nulls, valueReader, updater);
            state.levelOffset += num;
            this.currentCount -= num;
        }
        defLevels.addElementsAppended(total);
        int valuesRead = state.valueOffset - initialValueOffset;
        values.addElementsAppended(valuesRead);
        if (!valuesReused) {
            nulls.addElementsAppended(valuesRead);
        }
    }

    private void readValuesN(int n, ParquetReadState state, WritableColumnVector defLevels, WritableColumnVector values, WritableColumnVector nulls, VectorizedValuesReader valueReader, ParquetVectorUpdater updater) {
        switch (this.mode) {
            case RLE: {
                if (this.currentValue == state.maxDefinitionLevel) {
                    updater.readValues(n, state.valueOffset, values, valueReader);
                } else {
                    nulls.putNulls(state.valueOffset, n);
                }
                state.valueOffset += n;
                defLevels.putInts(state.levelOffset, n, this.currentValue);
                break;
            }
            case PACKED: {
                for (int i = 0; i < n; ++i) {
                    int currentValue;
                    if ((currentValue = this.currentBuffer[this.currentBufferIdx++]) == state.maxDefinitionLevel) {
                        updater.readValue(state.valueOffset++, values, valueReader);
                    } else {
                        nulls.putNull(state.valueOffset++);
                    }
                    defLevels.putInt(state.levelOffset + i, currentValue);
                }
                break;
            }
        }
    }

    private void skipValues(int n, ParquetReadState state, VectorizedValuesReader valuesReader, ParquetVectorUpdater updater) {
        while (n > 0 && (this.currentCount != 0 || this.readNextGroup())) {
            int num = Math.min(n, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue != state.maxDefinitionLevel) break;
                    updater.skipValues(num, valuesReader);
                    break;
                }
                case PACKED: {
                    int totalSkipNum = 0;
                    for (int i = 0; i < num; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] != state.maxDefinitionLevel) continue;
                        ++totalSkipNum;
                    }
                    updater.skipValues(totalSkipNum, valuesReader);
                }
            }
            this.currentCount -= num;
            n -= num;
        }
    }

    @Override
    public void readIntegers(int total, WritableColumnVector c, int rowId) {
        int left = total;
        while (left > 0 && (this.currentCount != 0 || this.readNextGroup())) {
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    c.putInts(rowId, n, this.currentValue);
                    break;
                }
                case PACKED: {
                    c.putInts(rowId, n, this.currentBuffer, this.currentBufferIdx);
                    this.currentBufferIdx += n;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    @Override
    public void readUnsignedIntegers(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readUnsignedLongs(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readIntegersWithRebase(int total, WritableColumnVector c, int rowId, boolean failIfRebase) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public byte readByte() {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public short readShort() {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBytes(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readShorts(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readLongs(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readLongsWithRebase(int total, WritableColumnVector c, int rowId, boolean failIfRebase, String timeZone) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBinary(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBooleans(int total, WritableColumnVector c, int rowId) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    c.putBooleans(rowId, n, this.currentValue != 0);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        c.putByte(rowId + i, (byte)this.currentBuffer[this.currentBufferIdx++]);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    @Override
    public void readFloats(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readDoubles(int total, WritableColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public Binary readBinary(int len) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void skipIntegers(int total) {
        this.skipValues(total);
    }

    @Override
    public void skipBooleans(int total) {
        this.skipValues(total);
    }

    @Override
    public void skipBytes(int total) {
        throw new UnsupportedOperationException("only skipIntegers is valid");
    }

    @Override
    public void skipShorts(int total) {
        throw new UnsupportedOperationException("only skipIntegers is valid");
    }

    @Override
    public void skipLongs(int total) {
        throw new UnsupportedOperationException("only skipIntegers is valid");
    }

    @Override
    public void skipFloats(int total) {
        throw new UnsupportedOperationException("only skipIntegers is valid");
    }

    @Override
    public void skipDoubles(int total) {
        throw new UnsupportedOperationException("only skipIntegers is valid");
    }

    @Override
    public void skipBinary(int total) {
        throw new UnsupportedOperationException("only skipIntegers is valid");
    }

    @Override
    public void skipFixedLenByteArray(int total, int len) {
        throw new UnsupportedOperationException("only skipIntegers is valid");
    }

    private int readUnsignedVarInt() throws IOException {
        int b;
        int value = 0;
        int shift = 0;
        do {
            b = this.in.read();
            value |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return value;
    }

    private int readIntLittleEndian() throws IOException {
        int ch4 = this.in.read();
        int ch3 = this.in.read();
        int ch2 = this.in.read();
        int ch1 = this.in.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private int readIntLittleEndianPaddedOnBitWidth() throws IOException {
        return switch (this.bytesWidth) {
            case 0 -> 0;
            case 1 -> this.in.read();
            case 2 -> {
                int ch2 = this.in.read();
                int ch1 = this.in.read();
                yield (ch1 << 8) + ch2;
            }
            case 3 -> {
                int ch3 = this.in.read();
                int ch2 = this.in.read();
                int ch1 = this.in.read();
                yield (ch1 << 16) + (ch2 << 8) + (ch3 << 0);
            }
            case 4 -> this.readIntLittleEndian();
            default -> throw new RuntimeException("Unreachable");
        };
    }

    private boolean readNextGroup() {
        if (this.in.available() <= 0) {
            this.currentCount = 0;
            return false;
        }
        try {
            int header = this.readUnsignedVarInt();
            this.mode = (header & 1) == 0 ? MODE.RLE : MODE.PACKED;
            switch (this.mode) {
                case RLE: {
                    this.currentCount = header >>> 1;
                    this.currentValue = this.readIntLittleEndianPaddedOnBitWidth();
                    break;
                }
                case PACKED: {
                    int numGroups = header >>> 1;
                    this.currentCount = numGroups * 8;
                    if (this.currentBuffer.length < this.currentCount) {
                        this.currentBuffer = new int[this.currentCount];
                    }
                    this.currentBufferIdx = 0;
                    for (int valueIndex = 0; valueIndex < this.currentCount; valueIndex += 8) {
                        ByteBuffer buffer = this.in.slice(this.bitWidth);
                        this.packer.unpack8Values(buffer, buffer.position(), this.currentBuffer, valueIndex);
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read from input stream", (Throwable)e);
        }
        return true;
    }

    private void skipValues(int n) {
        int num;
        for (int left = n; left > 0 && (this.currentCount != 0 || this.readNextGroup()); left -= num) {
            num = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    break;
                }
                case PACKED: {
                    this.currentBufferIdx += num;
                }
            }
            this.currentCount -= num;
        }
    }

    private static enum MODE {
        RLE,
        PACKED;

    }

    private static class DefLevelProcessor {
        private final VectorizedRleValuesReader reader;
        private final ParquetReadState state;
        private final WritableColumnVector defLevels;
        private final WritableColumnVector values;
        private final WritableColumnVector nulls;
        private final boolean valuesReused;
        private final VectorizedValuesReader valueReader;
        private final ParquetVectorUpdater updater;

        DefLevelProcessor(VectorizedRleValuesReader reader, ParquetReadState state, WritableColumnVector defLevels, WritableColumnVector values, WritableColumnVector nulls, boolean valuesReused, VectorizedValuesReader valueReader, ParquetVectorUpdater updater) {
            this.reader = reader;
            this.state = state;
            this.defLevels = defLevels;
            this.values = values;
            this.nulls = nulls;
            this.valuesReused = valuesReused;
            this.valueReader = valueReader;
            this.updater = updater;
        }

        void readValues(int n) {
            if (!this.state.shouldSkip) {
                this.state.numBatchedDefLevels += n;
            } else {
                this.reader.skipValues(this.state.numBatchedDefLevels, this.state, this.valueReader, this.updater);
                this.state.numBatchedDefLevels = n;
                this.state.shouldSkip = false;
            }
        }

        void skipValues(int n) {
            if (this.state.shouldSkip) {
                this.state.numBatchedDefLevels += n;
            } else {
                this.reader.readValues(this.state.numBatchedDefLevels, this.state, this.defLevels, this.values, this.nulls, this.valuesReused, this.valueReader, this.updater);
                this.state.numBatchedDefLevels = n;
                this.state.shouldSkip = true;
            }
        }

        void finish() {
            if (this.state.numBatchedDefLevels > 0) {
                if (this.state.shouldSkip) {
                    this.reader.skipValues(this.state.numBatchedDefLevels, this.state, this.valueReader, this.updater);
                } else {
                    this.reader.readValues(this.state.numBatchedDefLevels, this.state, this.defLevels, this.values, this.nulls, this.valuesReused, this.valueReader, this.updater);
                }
                this.state.numBatchedDefLevels = 0;
            }
        }
    }
}

