/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.time.ZoneId;
import org.apache.parquet.CorruptDeltaByteArrays;
import org.apache.parquet.VersionParser;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.RequiresPreviousReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.sql.execution.datasources.parquet.ParquetDictionary;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadState;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVectorUpdater;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVectorUpdaterFactory;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaBinaryPackedReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaByteArrayReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedDeltaLengthByteArrayReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedPlainValuesReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedRleValuesReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.Decimal;

public class VectorizedColumnReader {
    private final Dictionary dictionary;
    private boolean isCurrentPageDictionaryEncoded;
    private ValuesReader dataColumn;
    private VectorizedRleValuesReader defColumn;
    private VectorizedRleValuesReader repColumn;
    private final ParquetVectorUpdaterFactory updaterFactory;
    private final ParquetReadState readState;
    private long pageFirstRowIndex;
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;
    private final LogicalTypeAnnotation logicalTypeAnnotation;
    private final String datetimeRebaseMode;
    private final VersionParser.ParsedVersion writerVersion;

    public VectorizedColumnReader(ColumnDescriptor descriptor, boolean isRequired, PageReadStore pageReadStore, ZoneId convertTz, String datetimeRebaseMode, String datetimeRebaseTz, String int96RebaseMode, String int96RebaseTz, VersionParser.ParsedVersion writerVersion) throws IOException {
        this.descriptor = descriptor;
        this.pageReader = pageReadStore.getPageReader(descriptor);
        this.readState = new ParquetReadState(descriptor, isRequired, pageReadStore.getRowIndexes().orElse(null));
        this.logicalTypeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        this.updaterFactory = new ParquetVectorUpdaterFactory(this.logicalTypeAnnotation, convertTz, datetimeRebaseMode, datetimeRebaseTz, int96RebaseMode, int96RebaseTz);
        DictionaryPage dictionaryPage = this.pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
        if (this.pageReader.getTotalValueCount() == 0L) {
            throw new IOException("totalValueCount == 0");
        }
        assert ("LEGACY".equals(datetimeRebaseMode) || "EXCEPTION".equals(datetimeRebaseMode) || "CORRECTED".equals(datetimeRebaseMode));
        this.datetimeRebaseMode = datetimeRebaseMode;
        assert ("LEGACY".equals(int96RebaseMode) || "EXCEPTION".equals(int96RebaseMode) || "CORRECTED".equals(int96RebaseMode));
        this.writerVersion = writerVersion;
    }

    private boolean isLazyDecodingSupported(PrimitiveType.PrimitiveTypeName typeName) {
        return switch (typeName) {
            case PrimitiveType.PrimitiveTypeName.INT32 -> {
                if (!(this.logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) || "CORRECTED".equals(this.datetimeRebaseMode)) {
                    yield true;
                }
                yield false;
            }
            case PrimitiveType.PrimitiveTypeName.INT64 -> {
                if (this.updaterFactory.isTimestampTypeMatched(LogicalTypeAnnotation.TimeUnit.MICROS)) {
                    yield "CORRECTED".equals(this.datetimeRebaseMode);
                }
                if (!this.updaterFactory.isTimestampTypeMatched(LogicalTypeAnnotation.TimeUnit.MILLIS)) {
                    yield true;
                }
                yield false;
            }
            case PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BINARY -> true;
            default -> false;
        };
    }

    void readBatch(int total, WritableColumnVector column, WritableColumnVector repetitionLevels, WritableColumnVector definitionLevels) throws IOException {
        WritableColumnVector dictionaryIds = null;
        ParquetVectorUpdater updater = this.updaterFactory.getUpdater(this.descriptor, column.dataType());
        if (this.dictionary != null) {
            dictionaryIds = column.reserveDictionaryIds(total);
        }
        this.readState.resetForNewBatch(total);
        while (this.readState.rowsToReadInBatch > 0 || !this.readState.lastListCompleted) {
            if (this.readState.valuesToReadInPage == 0) {
                int pageValueCount = this.readPage();
                if (pageValueCount < 0) break;
                this.readState.resetForNewPage(pageValueCount, this.pageFirstRowIndex);
            }
            PrimitiveType.PrimitiveTypeName typeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
            if (this.isCurrentPageDictionaryEncoded) {
                int startOffset = this.readState.valueOffset;
                long startRowId = this.readState.rowId;
                if (this.readState.maxRepetitionLevel == 0) {
                    this.defColumn.readIntegers(this.readState, dictionaryIds, column, definitionLevels, (VectorizedValuesReader)this.dataColumn);
                } else {
                    this.repColumn.readIntegersRepeated(this.readState, repetitionLevels, this.defColumn, definitionLevels, dictionaryIds, column, (VectorizedValuesReader)this.dataColumn);
                }
                if (column.hasDictionary() || startRowId == this.pageFirstRowIndex && this.isLazyDecodingSupported(typeName)) {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation annotation;
                    PrimitiveType primitiveType = this.descriptor.getPrimitiveType();
                    LogicalTypeAnnotation typeAnnotation = primitiveType.getLogicalTypeAnnotation();
                    boolean castLongToInt = typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && (annotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation).getPrecision() <= Decimal.MAX_INT_DIGITS() && primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64;
                    boolean isUnsignedInt32 = this.updaterFactory.isUnsignedIntTypeMatched(32);
                    boolean isUnsignedInt64 = this.updaterFactory.isUnsignedIntTypeMatched(64);
                    boolean needTransform = castLongToInt || isUnsignedInt32 || isUnsignedInt64;
                    column.setDictionary(new ParquetDictionary(this.dictionary, needTransform));
                    continue;
                }
                updater.decodeDictionaryIds(this.readState.valueOffset - startOffset, startOffset, column, dictionaryIds, this.dictionary);
                continue;
            }
            if (column.hasDictionary() && this.readState.valueOffset != 0) {
                updater.decodeDictionaryIds(this.readState.valueOffset, 0, column, dictionaryIds, this.dictionary);
            }
            column.setDictionary(null);
            VectorizedValuesReader valuesReader = (VectorizedValuesReader)this.dataColumn;
            if (this.readState.maxRepetitionLevel == 0) {
                this.defColumn.readBatch(this.readState, column, definitionLevels, valuesReader, updater);
                continue;
            }
            this.repColumn.readBatchRepeated(this.readState, repetitionLevels, this.defColumn, definitionLevels, column, valuesReader, updater);
        }
    }

    private int readPage() {
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return -1;
        }
        this.pageFirstRowIndex = page.getFirstRowIndex().orElse(0L);
        return (Integer)page.accept((DataPage.Visitor)new DataPage.Visitor<Integer>(){

            public Integer visit(DataPageV1 dataPageV1) {
                try {
                    return VectorizedColumnReader.this.readPageV1(dataPageV1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public Integer visit(DataPageV2 dataPageV2) {
                try {
                    return VectorizedColumnReader.this.readPageV2(dataPageV2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void initDataReader(int pageValueCount, Encoding dataEncoding, ByteBufferInputStream in) throws IOException {
        ValuesReader previousReader = this.dataColumn;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + dataEncoding);
            }
            Encoding plainDict = Encoding.PLAIN_DICTIONARY;
            if (dataEncoding != plainDict && dataEncoding != Encoding.RLE_DICTIONARY) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = new VectorizedRleValuesReader();
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            this.dataColumn = this.getValuesReader(dataEncoding);
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(pageValueCount, in);
        }
        catch (IOException e) {
            throw new IOException("could not read page in col " + this.descriptor, e);
        }
        if (CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)this.writerVersion, (Encoding)dataEncoding) && previousReader instanceof RequiresPreviousReader) {
            ((RequiresPreviousReader)this.dataColumn).setPreviousReader(previousReader);
        }
    }

    private ValuesReader getValuesReader(Encoding encoding) {
        return switch (encoding) {
            case Encoding.PLAIN -> new VectorizedPlainValuesReader();
            case Encoding.DELTA_BYTE_ARRAY -> new VectorizedDeltaByteArrayReader();
            case Encoding.DELTA_LENGTH_BYTE_ARRAY -> new VectorizedDeltaLengthByteArrayReader();
            case Encoding.DELTA_BINARY_PACKED -> new VectorizedDeltaBinaryPackedReader();
            case Encoding.RLE -> {
                PrimitiveType.PrimitiveTypeName typeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
                if (typeName == PrimitiveType.PrimitiveTypeName.BOOLEAN) {
                    yield new VectorizedRleValuesReader(1);
                }
                throw new UnsupportedOperationException("RLE encoding is not supported for values of type: " + typeName);
            }
            default -> throw new UnsupportedOperationException("Unsupported encoding: " + encoding);
        };
    }

    private int readPageV1(DataPageV1 page) throws IOException {
        if (page.getDlEncoding() != Encoding.RLE && this.descriptor.getMaxDefinitionLevel() != 0) {
            throw new UnsupportedOperationException("Unsupported encoding: " + page.getDlEncoding());
        }
        int pageValueCount = page.getValueCount();
        int rlBitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxRepetitionLevel());
        this.repColumn = new VectorizedRleValuesReader(rlBitWidth);
        int dlBitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedRleValuesReader(dlBitWidth);
        try {
            BytesInput bytes = page.getBytes();
            ByteBufferInputStream in = bytes.toInputStream();
            this.repColumn.initFromPage(pageValueCount, in);
            this.defColumn.initFromPage(pageValueCount, in);
            this.initDataReader(pageValueCount, page.getValueEncoding(), in);
            return pageValueCount;
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private int readPageV2(DataPageV2 page) throws IOException {
        int pageValueCount = page.getValueCount();
        int rlBitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxRepetitionLevel());
        this.repColumn = new VectorizedRleValuesReader(rlBitWidth, false);
        this.repColumn.initFromPage(pageValueCount, page.getRepetitionLevels().toInputStream());
        int dlBitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedRleValuesReader(dlBitWidth, false);
        this.defColumn.initFromPage(pageValueCount, page.getDefinitionLevels().toInputStream());
        try {
            this.initDataReader(pageValueCount, page.getDataEncoding(), page.getData().toInputStream());
            return pageValueCount;
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }
}

