/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u000f\u001f\u00015BQ\u0001\u0015\u0001\u0005\u0002ECQ\u0001\u0016\u0001\u0005BUCQA\u0018\u0001\u0005BUCQa\u0018\u0001\u0005B\u0001DQ\u0001\u001a\u0001\u0005B\u0015DQA\u001c\u0001\u0005B=Dq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\t9\u000e\u0001C!\u00033<q!a9\u001f\u0011\u0003\t)O\u0002\u0004\u001e=!\u0005\u0011q\u001d\u0005\u0007!>!\t!a>\t\u0013\u0005exB1A\u0005\u0002\u0005m\b\u0002\u0003B\u0004\u001f\u0001\u0006I!!@\t\u0013\t%qB1A\u0005\u0002\u0005m\b\u0002\u0003B\u0006\u001f\u0001\u0006I!!@\t\u0013\t5qB1A\u0005\u0002\t=\u0001\u0002\u0003B\t\u001f\u0001\u0006I!!8\t\u0011\tMq\u0002\"\u0001\u001f\u0005+A\u0001Ba\u000b\u0010\t\u0003q\"Q\u0006\u0005\b\u0005syA\u0011\u0001B\u001e\u0011\u001d\u0011)e\u0004C\u0001\u0005\u000fBqAa\u0016\u0010\t\u0013\u0011I\u0006C\u0005\u0003`=\t\t\u0011\"\u0003\u0003b\t\t\u0002+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u000b\u0005}\u0001\u0013a\u00029beF,X\r\u001e\u0006\u0003C\t\n1\u0002Z1uCN|WO]2fg*\u00111\u0005J\u0001\nKb,7-\u001e;j_:T!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u00185qy\"\u0005CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g\r\u0005\u00026m5\t\u0001%\u0003\u00028A\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\"\u0013aB:pkJ\u001cWm]\u0005\u0003{i\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IJ\u0001\tS:$XM\u001d8bY&\u00111\t\u0011\u0002\b\u0019><w-\u001b8h!\t)UJ\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nL\u0001\u0007yI|w\u000e\u001e \n\u0003EJ!\u0001\u0014\u0019\u0002\u000fA\f7m[1hK&\u0011aj\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0019B\na\u0001P5oSRtD#\u0001*\u0011\u0005M\u0003Q\"\u0001\u0010\u0002\u0013MDwN\u001d;OC6,G#\u0001,\u0011\u0005][fB\u0001-Z!\t9\u0005'\u0003\u0002[a\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQ\u0006'\u0001\u0005u_N#(/\u001b8h\u0003!A\u0017m\u001d5D_\u0012,G#A1\u0011\u0005=\u0012\u0017BA21\u0005\rIe\u000e^\u0001\u0007KF,\u0018\r\\:\u0015\u0005\u0019L\u0007CA\u0018h\u0013\tA\u0007GA\u0004C_>dW-\u00198\t\u000b),\u0001\u0019A6\u0002\u000b=$\b.\u001a:\u0011\u0005=b\u0017BA71\u0005\r\te._\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\baNL\u0018qAA\t!\t)\u0014/\u0003\u0002sA\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")AO\u0002a\u0001k\u0006a1\u000f]1sWN+7o]5p]B\u0011ao^\u0007\u0002I%\u0011\u0001\u0010\n\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0006u\u001a\u0001\ra_\u0001\u0004U>\u0014\u0007c\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0004\u0003\u0003A\u0013A\u00025bI>|\u0007/C\u0002\u0002\u0006u\u00141AS8c\u0011\u001d\tIA\u0002a\u0001\u0003\u0017\tqa\u001c9uS>t7\u000fE\u0003X\u0003\u001b1f+C\u0002\u0002\u0010u\u00131!T1q\u0011\u001d\t\u0019B\u0002a\u0001\u0003+\t!\u0002Z1uCN\u001b\u0007.Z7b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eI\u0005)A/\u001f9fg&!\u0011qDA\r\u0005)\u0019FO];diRK\b/Z\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0005\u0002&\u0005-\u0012QFA\u0019!\u0015y\u0013qEA\u000b\u0013\r\tI\u0003\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bQ<\u0001\u0019A;\t\u000f\u0005=r\u00011\u0001\u0002\f\u0005Q\u0001/\u0019:b[\u0016$XM]:\t\u000f\u0005Mr\u00011\u0001\u00026\u0005)a-\u001b7fgB)Q)a\u000e\u0002<%\u0019\u0011\u0011H(\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\te`\u0001\u0003MNLA!!\u0012\u0002@\tQa)\u001b7f'R\fG/^:\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000b\u0019\fY%!\u0014\t\u000bQD\u0001\u0019A;\t\u000f\u0005=\u0003\u00021\u0001\u0002\u0016\u000511o\u00195f[\u0006\f1B^3di>\u0014H+\u001f9fgRA\u0011QKA-\u0003;\n\t\u0007E\u00030\u0003O\t9\u0006\u0005\u0003F\u0003o1\u0006bBA.\u0013\u0001\u0007\u0011QC\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\ty&\u0003a\u0001\u0003+\tq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\b\u0003GJ\u0001\u0019AA3\u0003\u001d\u0019\u0018\u000f\\\"p]\u001a\u0004B!a\u001a\u0002l5\u0011\u0011\u0011\u000e\u0006\u0003\u0003\u0012JA!!\u001c\u0002j\t91+\u0015'D_:4\u0017aC5t'Bd\u0017\u000e^1cY\u0016$rAZA:\u0003k\n9\bC\u0003u\u0015\u0001\u0007Q\u000fC\u0004\u0002\n)\u0001\r!a\u0003\t\u000f\u0005e$\u00021\u0001\u0002|\u0005!\u0001/\u0019;i!\u0011\ti$! \n\t\u0005}\u0014q\b\u0002\u0005!\u0006$\b.\u0001\u0010ck&dGMU3bI\u0016\u0014x+\u001b;i!\u0006\u0014H/\u001b;j_:4\u0016\r\\;fgR\u0001\u0012QQAR\u0003K\u000b9+!+\u0002,\u0006]\u0016\u0011\u0018\t\b_\u0005\u001d\u00151RAI\u0013\r\tI\t\r\u0002\n\rVt7\r^5p]F\u00022!NAG\u0013\r\ty\t\t\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB)Q)a%\u0002\u0018&\u0019\u0011QS(\u0003\u0011%#XM]1u_J\u0004B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;#\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\u0005\u00161\u0014\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003u\u0017\u0001\u0007Q\u000fC\u0004\u0002\u0014-\u0001\r!!\u0006\t\u000f\u0005}3\u00021\u0001\u0002\u0016!9\u00111L\u0006A\u0002\u0005U\u0001bBAW\u0017\u0001\u0007\u0011qV\u0001\bM&dG/\u001a:t!\u0015)\u0015qGAY!\rI\u00141W\u0005\u0004\u0003kS$A\u0002$jYR,'\u000fC\u0004\u0002\n-\u0001\r!a\u0003\t\u000f\u0005m6\u00021\u0001\u0002>\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1\u0000\u0003\u0011\u0019wN\u001c4\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001fM,\b\u000f]8si\u0012\u000bG/\u0019+za\u0016$2AZAg\u0011\u001d\ty\r\u0004a\u0001\u0003#\f\u0001\u0002Z1uCRK\b/\u001a\t\u0005\u0003/\t\u0019.\u0003\u0003\u0002V\u0006e!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002)5,G/\u00193bi\u0006\u001c6\r[3nC\u001aKW\r\u001c3t+\t\tY\u000eE\u0003F\u0003o\ti\u000e\u0005\u0003\u0002\u0018\u0005}\u0017\u0002BAq\u00033\u00111b\u0015;sk\u000e$h)[3mI\u0006\t\u0002+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u0011\u0005M{1#B\b/}\u0005%\b\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\u0003S>T!!a=\u0002\t)\fg/Y\u0005\u0004\u001d\u00065HCAAs\u0003%\u0011vjV0J\u001d\u0012+\u0005,\u0006\u0002\u0002~B!\u0011q B\u0003\u001b\t\u0011\tA\u0003\u0003\u0003\u0004\u0005E\u0018\u0001\u00027b]\u001eL1\u0001\u0018B\u0001\u0003)\u0011vjV0J\u001d\u0012+\u0005\fI\u0001 %>;v,\u0013(E\u000bb{F+R'Q\u001fJ\u000b%+W0D\u001f2+VJT0O\u00036+\u0015\u0001\t*P/~Ke\nR#Y?R+U\nU(S\u0003JKvlQ(M+6suLT!N\u000b\u0002\nqBU(X?&sE)\u0012-`\r&+E\nR\u000b\u0003\u0003;\f\u0001CU(X?&sE)\u0012-`\r&+E\n\u0012\u0011\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\r\u0006\u0004\u0002&\t]!\u0011\u0006\u0005\b\u000539\u0002\u0019\u0001B\u000e\u0003\u001d1wn\u001c;feN\u0004R!RA\u001c\u0005;\u0001BAa\b\u0003&5\u0011!\u0011\u0005\u0006\u0005\u0003\u0003\u0011\u0019C\u0003\u0002 Q%!!q\u0005B\u0011\u0005\u00191un\u001c;fe\")Ao\u0006a\u0001k\u0006a\"/Z1e!\u0006\u0014\u0018/^3u\r>|G/\u001a:t\u0013:\u0004\u0016M]1mY\u0016dG\u0003\u0003B\u000e\u0005_\u0011\tD!\u000e\t\u000f\u0005\r\u0007\u00041\u0001\u0002>\"9!1\u0007\rA\u0002\u0005U\u0012!\u00039beR4\u0015\u000e\\3t\u0011\u0019\u00119\u0004\u0007a\u0001M\u0006\u0011\u0012n\u001a8pe\u0016\u001cuN\u001d:vaR4\u0015\u000e\\3t\u0003YiWM]4f'\u000eDW-\\1t\u0013:\u0004\u0016M]1mY\u0016dG\u0003CA\u0013\u0005{\u0011yDa\u0011\t\u000f\u0005=\u0012\u00041\u0001\u0002\f!9!\u0011I\rA\u0002\u0005U\u0012\u0001\u00044jY\u0016\u001cHk\u001c+pk\u000eD\u0007\"\u0002;\u001a\u0001\u0004)\u0018\u0001\u0006:fC\u0012\u001c6\r[3nC\u001a\u0013x.\u001c$p_R,'\u000f\u0006\u0004\u0002\u0016\t%#Q\n\u0005\b\u0005\u0017R\u0002\u0019\u0001B\u000f\u0003\u00191wn\u001c;fe\"9!q\n\u000eA\u0002\tE\u0013!C2p]Z,'\u000f^3s!\r\u0019&1K\u0005\u0004\u0005+r\"!\b)beF,X\r\u001e+p'B\f'o[*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\u0002/\u0011,7/\u001a:jC2L'0Z*dQ\u0016l\u0017m\u0015;sS:<G\u0003BA\u0013\u00057BaA!\u0018\u001c\u0001\u00041\u0016\u0001D:dQ\u0016l\u0017m\u0015;sS:<\u0017\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B2!\u0011\tyP!\u001a\n\t\t\u001d$\u0011\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter converter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, converter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    public static StructField ROW_INDEX_FIELD() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD();
    }

    public static String ROW_INDEX_TEMPORARY_COLUMN_NAME() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
    }

    public static String ROW_INDEX() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public scala.collection.immutable.Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        return ParquetUtils$.MODULE$.prepareWrite(sqlConf, job, dataSchema, parquetOptions);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(conf, schema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply(((IterableOps)package$.MODULE$.Seq().fill(requiredSchema.fields().length, (Function0 & Serializable)() -> {
            if (!sqlConf.offHeapColumnVectorEnabled()) {
                return OnHeapColumnVector.class.getName();
            }
            return OffHeapColumnVector.class.getName();
        })).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(partitionSchema.fields().length, (Function0 & Serializable)() -> ConstantColumnVector.class.getName())));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        boolean returningBatch;
        String int96RebaseModeInRead;
        String datetimeRebaseModeInRead;
        boolean isCaseSensitive;
        int pushDownInFilterThreshold;
        boolean pushDownStringPredicate;
        boolean pushDownDecimal;
        boolean pushDownTimestamp;
        boolean pushDownDate;
        boolean enableParquetFilterPushDown;
        int capacity;
        boolean timestampConversion;
        boolean enableRecordFilter;
        boolean enableVectorizedReader;
        boolean enableOffHeapColumnVector;
        Broadcast broadcastedHadoopConf;
        block0: {
            hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
            hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
            hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
            hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
            hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
            broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
            StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
            SQLConf sqlConf = sparkSession.sessionState().conf();
            enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
            enableVectorizedReader = ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(sqlConf, resultSchema);
            enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
            timestampConversion = sqlConf.isParquetINT96TimestampConversion();
            capacity = sqlConf.parquetVectorizedReaderBatchSize();
            enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
            pushDownDate = sqlConf.parquetFilterPushDownDate();
            pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
            pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
            pushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
            pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
            isCaseSensitive = sqlConf.caseSensitiveAnalysis();
            ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
            datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
            int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
            boolean bl = returningBatch = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && ((String)options.getOrElse((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH(), (Function0 & Serializable)() -> {
                throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for ParquetFileFormat. To workaround this issue, set spark.sql.parquet.enableVectorizedReader=false.");
            })).equals("true");
            if (!returningBatch) break block0;
            Predef$.MODULE$.assert(this.supportBatch(sparkSession, resultSchema));
        }
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            ParquetRecordReader parquetRecordReader;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            ParquetMetadata fileFooter = enableVectorizedReader ? ParquetFooterReader.readFooter(sharedConf, file, false) : ParquetFooterReader.readFooter(sharedConf, file, true);
            FileMetaData footerFileMetaData = fileFooter.getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$1 -> parquetFilters.createFilter((Filter)x$1))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                RecordReaderIterator<Object> recordReaderIterator;
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                try {
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext, (Option<ParquetMetadata>)Option$.MODULE$.apply((Object)fileFooter));
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Appending " + partitionSchema + " " + file.partitionValues());
                    vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                    if (returningBatch) {
                        vectorizedReader.enableReturningBatches();
                    }
                    recordReaderIterator = iter;
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
                return recordReaderIterator;
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Falling back to parquet-mr");
            ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReader<Void, InternalRow> readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded((ParquetRecordReader<InternalRow>)reader, requiredSchema);
            RecordReaderIterator<InternalRow> iter = new RecordReaderIterator<InternalRow>(readerWithRowIndexes);
            try {
                readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((IterableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema));
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map(unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return (Seq)FileFormat.metadataSchemaFields$(this).$colon$plus((Object)ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD());
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
    }
}

