/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.BooleanColumnStatistics;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DateColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.FileFormatException;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FileSourceOptions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.AggregatePushDownUtils$;
import org.apache.spark.sql.execution.datasources.SchemaMergeUtils$;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnStatistics;
import org.apache.spark.sql.execution.datasources.orc.OrcCompressionCodec;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFooterReader;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.v2.V2ColumnUtils$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class OrcUtils$
implements Logging {
    public static final OrcUtils$ MODULE$ = new OrcUtils$();
    private static final Map<String, String> extensionsForCompressionCodecNames;
    private static final String CATALYST_TYPE_ATTRIBUTE_NAME;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        extensionsForCompressionCodecNames = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcCompressionCodec.NONE.name()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcCompressionCodec.SNAPPY.name()), (Object)".snappy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcCompressionCodec.ZLIB.name()), (Object)".zlib"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcCompressionCodec.ZSTD.name()), (Object)".zstd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcCompressionCodec.LZ4.name()), (Object)".lz4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcCompressionCodec.LZO.name()), (Object)".lzo")}));
        CATALYST_TYPE_ATTRIBUTE_NAME = "spark.sql.catalyst.type";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Map<String, String> extensionsForCompressionCodecNames() {
        return extensionsForCompressionCodecNames;
    }

    public String CATALYST_TYPE_ATTRIBUTE_NAME() {
        return CATALYST_TYPE_ATTRIBUTE_NAME;
    }

    public Seq<Path> listOrcFiles(String pathStr, Configuration conf) {
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        Seq paths = (Seq)((IterableOps)((IterableOps)((IterableOps)SparkHadoopUtil$.MODULE$.get().listLeafStatuses(fs, origPath).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()))).map((Function1 & Serializable)x$2 -> x$2.getPath())).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.$anonfun$listOrcFiles$3(x$3)))).filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.$anonfun$listOrcFiles$4(x$4)));
        return paths;
    }

    public Option<TypeDescription> readSchema(Path file, Configuration conf, boolean ignoreCorruptFiles) {
        Object object;
        FileSystem fs = file.getFileSystem(conf);
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
        try {
            TypeDescription schema = (TypeDescription)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)file, (OrcFile.ReaderOptions)readerOptions), (Function1 & Serializable)reader -> reader.getSchema());
            object = schema.getFieldNames().size() == 0 ? None$.MODULE$ : new Some((Object)schema);
        }
        catch (FileFormatException e) {
            if (ignoreCorruptFiles) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped the footer in the corrupted file: " + file, e);
                object = None$.MODULE$;
            }
            throw QueryExecutionErrors$.MODULE$.cannotReadFooterForFileError(file, (Exception)((Object)e));
        }
        return object;
    }

    public StructType toCatalystSchema(TypeDescription schema) {
        return CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(this.toStructType$1(schema));
    }

    public Option<StructType> readSchema(SparkSession sparkSession, Seq<FileStatus> files, Map<String, String> options) {
        boolean ignoreCorruptFiles = new FileSourceOptions(CaseInsensitiveMap$.MODULE$.apply(options)).ignoreCorruptFiles();
        Configuration conf = sparkSession.sessionState().newHadoopConfWithOptions(options);
        return files.iterator().map((Function1 & Serializable)file -> MODULE$.readSchema(file.getPath(), conf, ignoreCorruptFiles)).collectFirst((PartialFunction)new Serializable(files){
            private static final long serialVersionUID = 0L;
            private final Seq files$1;

            public final <A1 extends Option<TypeDescription>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    TypeDescription schema = (TypeDescription)some.value();
                    OrcUtils$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Reading schema from file " + $this.files$1 + ", got Hive schema string: " + schema);
                    return (B1)OrcUtils$.MODULE$.toCatalystSchema(schema);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<TypeDescription> x1) {
                Option<TypeDescription> option = x1;
                return option instanceof Some;
            }
            {
                this.files$1 = files$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.datasources.orc.OrcUtils$$anonfun$readSchema$5 org.apache.orc.TypeDescription )}, serializedLambda);
            }
        });
    }

    public Seq<StructType> readOrcSchemasInParallel(Seq<FileStatus> files, Configuration conf, boolean ignoreCorruptFiles) {
        return (Seq)ThreadUtils$.MODULE$.parmap(files, "readingOrcSchemas", 8, (Function1 & Serializable)currentFile -> MODULE$.readSchema(currentFile.getPath(), conf, ignoreCorruptFiles).map((Function1 & Serializable)schema -> MODULE$.toCatalystSchema((TypeDescription)schema))).flatten(Predef$.MODULE$.$conforms());
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Seq<FileStatus> files2, Map<String, String> options) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        if (orcOptions.mergeSchema()) {
            return SchemaMergeUtils$.MODULE$.mergeSchemasInParallel(sparkSession, options, files2, (Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>>)(Function3 & Serializable)(files, conf, ignoreCorruptFiles) -> OrcUtils$.MODULE$.readOrcSchemasInParallel((Seq<FileStatus>)files, conf, BoxesRunTime.unboxToBoolean((Object)ignoreCorruptFiles)));
        }
        return this.readSchema(sparkSession, files2, options);
    }

    public Option<Tuple2<int[], Object>> requestedColumnIds(boolean isCaseSensitive, StructType dataSchema, StructType requiredSchema, TypeDescription orcSchema, Configuration conf) {
        OrcUtils$.checkTimestampCompatibility$1(this.toCatalystSchema(orcSchema), dataSchema);
        Buffer orcFieldNames = CollectionConverters$.MODULE$.ListHasAsScala(orcSchema.getFieldNames()).asScala();
        boolean forcePositionalEvolution = OrcConf.FORCE_POSITIONAL_EVOLUTION.getBoolean(conf);
        if (orcFieldNames.isEmpty()) {
            return None$.MODULE$;
        }
        if (forcePositionalEvolution || orcFieldNames.forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith("_col")))) {
            Predef$.MODULE$.assert(orcFieldNames.length() <= dataSchema.length(), (Function0 & Serializable)() -> "The given data schema " + dataSchema.catalogString() + " (length:" + dataSchema.length() + ") has fewer " + (orcFieldNames.length() - dataSchema.length()) + " fields than the actual ORC physical schema " + orcSchema + " (length:" + orcFieldNames.length() + "), no idea which columns were dropped, fail to read.");
            return new Some((Object)new Tuple2(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()), (Function1 & Serializable)name -> BoxesRunTime.boxToInteger((int)OrcUtils$.$anonfun$requestedColumnIds$6(dataSchema, orcFieldNames, name)), (ClassTag)ClassTag$.MODULE$.Int()), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }
        if (isCaseSensitive) {
            return new Some((Object)new Tuple2(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)OrcUtils$.$anonfun$requestedColumnIds$7(orcFieldNames, x0$1)), (ClassTag)ClassTag$.MODULE$.Int()), (Object)BoxesRunTime.boxToBoolean((boolean)true)));
        }
        Map caseInsensitiveOrcFieldMap = orcFieldNames.groupBy((Function1 & Serializable)x$10 -> x$10.toLowerCase(Locale.ROOT));
        return new Some((Object)new Tuple2(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()))), (Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)OrcUtils$.$anonfun$requestedColumnIds$10(caseInsensitiveOrcFieldMap, x0$2)), (ClassTag)ClassTag$.MODULE$.Int()), (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public void addSparkVersionMetadata(Writer writer) {
        writer.addUserMetadata(package$.MODULE$.SPARK_VERSION_METADATA_KEY(), StandardCharsets.UTF_8.encode(org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()));
    }

    public String getOrcSchemaString(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            String[] fieldTypes = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> org.apache.spark.sql.catalyst.util.package$.MODULE$.quoteIdentifier(f.name()) + ":" + MODULE$.getOrcSchemaString(f.dataType()), ClassTag$.MODULE$.apply(String.class));
            return "struct<" + Predef$.MODULE$.wrapRefArray((Object[])fieldTypes).mkString(",") + ">";
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return "array<" + this.getOrcSchemaString(arrayType.elementType()) + ">";
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return "map<" + this.getOrcSchemaString(mapType.keyType()) + "," + this.getOrcSchemaString(mapType.valueType()) + ">";
        }
        if (dataType instanceof DayTimeIntervalType ? true : dataType instanceof TimestampNTZType) {
            return LongType$.MODULE$.catalogString();
        }
        if (dataType instanceof YearMonthIntervalType) {
            return IntegerType$.MODULE$.catalogString();
        }
        return dt.catalogString();
    }

    public TypeDescription orcTypeDescription(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            TypeDescription result = new TypeDescription(TypeDescription.Category.STRUCT);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> {
                Option option = this.getInnerTypeDecription$1(f.dataType());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TypeDescription t = (TypeDescription)some.value();
                    return result.addField(f.name(), t);
                }
                if (None$.MODULE$.equals(option)) {
                    return result.addField(f.name(), MODULE$.orcTypeDescription(f.dataType()));
                }
                throw new MatchError((Object)option);
            });
            return result;
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            TypeDescription result = new TypeDescription(TypeDescription.Category.LIST);
            Option option = this.getInnerTypeDecription$1(arrayType.elementType());
            if (option instanceof Some) {
                Some some = (Some)option;
                TypeDescription t = (TypeDescription)some.value();
                result.addChild(t);
            } else if (None$.MODULE$.equals(option)) {
                result.addChild(this.orcTypeDescription(arrayType.elementType()));
            } else {
                throw new MatchError((Object)option);
            }
            return result;
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            TypeDescription result = new TypeDescription(TypeDescription.Category.MAP);
            Option option = this.getInnerTypeDecription$1(mapType.keyType());
            if (option instanceof Some) {
                Some some = (Some)option;
                TypeDescription t = (TypeDescription)some.value();
                result.addChild(t);
            } else if (None$.MODULE$.equals(option)) {
                result.addChild(this.orcTypeDescription(mapType.keyType()));
            } else {
                throw new MatchError((Object)option);
            }
            Option option2 = this.getInnerTypeDecription$1(mapType.valueType());
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                TypeDescription t = (TypeDescription)some.value();
                result.addChild(t);
            } else if (None$.MODULE$.equals(option2)) {
                result.addChild(this.orcTypeDescription(mapType.valueType()));
            } else {
                throw new MatchError((Object)option2);
            }
            return result;
        }
        return TypeDescription.fromString((String)dataType.catalogString());
    }

    public String orcResultSchemaString(boolean canPruneCols, StructType dataSchema, StructType resultSchema, StructType partitionSchema, Configuration conf) {
        String resultSchemaString = canPruneCols ? this.getOrcSchemaString((DataType)resultSchema) : this.getOrcSchemaString((DataType)new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fields()), (Object)partitionSchema.fields(), ClassTag$.MODULE$.apply(StructField.class))));
        OrcConf.MAPRED_INPUT_SCHEMA.setString(conf, resultSchemaString);
        return resultSchemaString;
    }

    public boolean supportColumnarReads(DataType dataType, boolean nestedColumnEnabled) {
        block6: {
            while (true) {
                DataType dataType2;
                if ((dataType2 = dataType) instanceof AtomicType) {
                    return true;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    if (nestedColumnEnabled) {
                        return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.MODULE$.supportColumnarReads(f.dataType(), nestedColumnEnabled)));
                    }
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType2;
                    DataType elementType = arrayType.elementType();
                    if (nestedColumnEnabled) {
                        dataType = elementType;
                        continue;
                    }
                }
                if (!(dataType2 instanceof MapType)) break block6;
                MapType mapType = (MapType)dataType2;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                if (!nestedColumnEnabled) break block6;
                if (!this.supportColumnarReads(keyType, nestedColumnEnabled)) break;
                dataType = valueType;
            }
            return false;
        }
        return false;
    }

    public InternalRow createAggInternalRowFromFooter(Reader reader, String filePath, StructType dataSchema, StructType partitionSchema, Aggregation aggregation, StructType aggSchema, InternalRow partitionValues) {
        ObjectRef columnsStatistics = ObjectRef.create(null);
        try {
            columnsStatistics.elem = OrcFooterReader.readStatistics(reader);
        }
        catch (Exception e) {
            throw new SparkException("Cannot read columns statistics in file: " + filePath + ". Please consider disabling ORC aggregate push down by setting 'spark.sql.orc.aggregatePushdown' to false.", (Throwable)e);
        }
        StructType schemaWithoutGroupBy = AggregatePushDownUtils$.MODULE$.getSchemaWithoutGroupingExpression(aggSchema, aggregation);
        ArraySeq aggORCValues = ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.aggregateExpressions()))), (Function1 & Serializable)x0$1 -> {
            Count count;
            AggregateFunc count2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Max max;
                AggregateFunc max2 = (AggregateFunc)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (max2 instanceof Max && V2ColumnUtils$.MODULE$.extractV2Column((max = (Max)max2).column()).isDefined()) {
                    String columnName = (String)V2ColumnUtils$.MODULE$.extractV2Column(max.column()).get();
                    ColumnStatistics statistics = OrcUtils$.getColumnStatistics$1(columnName, dataSchema, columnsStatistics);
                    DataType dataType = schemaWithoutGroupBy.apply(index).dataType();
                    return OrcUtils$.getMinMaxFromColumnStatistics$1(statistics, dataType, true);
                }
            }
            if (tuple2 != null) {
                Min min;
                AggregateFunc min2 = (AggregateFunc)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (min2 instanceof Min && V2ColumnUtils$.MODULE$.extractV2Column((min = (Min)min2).column()).isDefined()) {
                    String columnName = (String)V2ColumnUtils$.MODULE$.extractV2Column(min.column()).get();
                    ColumnStatistics statistics = OrcUtils$.getColumnStatistics$1(columnName, dataSchema, columnsStatistics);
                    DataType dataType = schemaWithoutGroupBy.apply(index).dataType();
                    return OrcUtils$.getMinMaxFromColumnStatistics$1(statistics, dataType, false);
                }
            }
            if (tuple2 != null && (count2 = (AggregateFunc)tuple2._1()) instanceof Count && V2ColumnUtils$.MODULE$.extractV2Column((count = (Count)count2).column()).isDefined()) {
                String columnName = (String)V2ColumnUtils$.MODULE$.extractV2Column(count.column()).get();
                boolean isPartitionColumn = ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Function1 & Serializable)x$11 -> x$11.name(), ClassTag$.MODULE$.apply(String.class))), (Object)columnName);
                long nonNullRowsCount = isPartitionColumn ? ((OrcColumnStatistics)columnsStatistics$1.elem).getStatistics().getNumberOfValues() : OrcUtils$.getColumnStatistics$1(columnName, dataSchema, columnsStatistics).getNumberOfValues();
                return new LongWritable(nonNullRowsCount);
            }
            if (tuple2 != null && tuple2._1() instanceof CountStar) {
                return new LongWritable(((OrcColumnStatistics)columnsStatistics$1.elem).getStatistics().getNumberOfValues());
            }
            if (tuple2 != null) {
                AggregateFunc x = (AggregateFunc)tuple2._1();
                throw new IllegalArgumentException("createAggInternalRowFromFooter should not take " + x + " as the aggregate expression");
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(WritableComparable.class))).toImmutableArraySeq();
        OrcDeserializer orcValuesDeserializer = new OrcDeserializer(schemaWithoutGroupBy, (int[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), schemaWithoutGroupBy.length()).toArray((ClassTag)ClassTag$.MODULE$.Int()));
        InternalRow resultRow = orcValuesDeserializer.deserializeFromValues((Seq<WritableComparable<?>>)aggORCValues);
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.groupByExpressions()))) {
            InternalRow reOrderedPartitionValues = AggregatePushDownUtils$.MODULE$.reOrderPartitionCol(partitionSchema, aggregation, partitionValues);
            return new JoinedRow(reOrderedPartitionValues, resultRow);
        }
        return resultRow;
    }

    public static final /* synthetic */ boolean $anonfun$listOrcFiles$3(Path x$3) {
        return x$3.getName().startsWith("_");
    }

    public static final /* synthetic */ boolean $anonfun$listOrcFiles$4(Path x$4) {
        return x$4.getName().startsWith(".");
    }

    private final DataType toCatalystType$1(TypeDescription orcType) {
        TypeDescription.Category category = orcType.getCategory();
        if (TypeDescription.Category.STRUCT.equals(category)) {
            return this.toStructType$1(orcType);
        }
        if (TypeDescription.Category.LIST.equals(category)) {
            return this.toArrayType$1(orcType);
        }
        if (TypeDescription.Category.MAP.equals(category)) {
            return this.toMapType$1(orcType);
        }
        String catalystTypeAttrValue = orcType.getAttributeValue(this.CATALYST_TYPE_ATTRIBUTE_NAME());
        if (catalystTypeAttrValue != null) {
            return CatalystSqlParser$.MODULE$.parseDataType(catalystTypeAttrValue);
        }
        return CatalystSqlParser$.MODULE$.parseDataType(orcType.toString());
    }

    private final StructType toStructType$1(TypeDescription orcType) {
        Buffer fieldNames = CollectionConverters$.MODULE$.ListHasAsScala(orcType.getFieldNames()).asScala();
        Buffer fieldTypes = CollectionConverters$.MODULE$.ListHasAsScala(orcType.getChildren()).asScala();
        ArrayBuffer fields = new ArrayBuffer();
        ((IterableOnceOps)fieldNames.zip((IterableOnce)fieldTypes)).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String fieldName = (String)tuple2._1();
                TypeDescription fieldType = (TypeDescription)tuple2._2();
                DataType catalystType = this.toCatalystType$1(fieldType);
                return (ArrayBuffer)fields.$plus$eq((Object)new StructField(fieldName, catalystType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            }
            throw new MatchError((Object)tuple2);
        });
        return new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    private final ArrayType toArrayType$1(TypeDescription orcType) {
        TypeDescription elementType = (TypeDescription)orcType.getChildren().get(0);
        return ArrayType$.MODULE$.apply(this.toCatalystType$1(elementType));
    }

    private final MapType toMapType$1(TypeDescription orcType) {
        SeqOps seqOps;
        Seq seq = CollectionConverters$.MODULE$.ListHasAsScala(orcType.getChildren()).asScala().toSeq();
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
            throw new MatchError((Object)seq);
        }
        TypeDescription keyType = (TypeDescription)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        TypeDescription valueType = (TypeDescription)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Tuple2 tuple2 = new Tuple2((Object)keyType, (Object)valueType);
        TypeDescription keyType2 = (TypeDescription)tuple2._1();
        TypeDescription valueType2 = (TypeDescription)tuple2._2();
        DataType catalystKeyType = this.toCatalystType$1(keyType2);
        DataType catalystValueType = this.toCatalystType$1(valueType2);
        return MapType$.MODULE$.apply(catalystKeyType, catalystValueType);
    }

    public static final /* synthetic */ void $anonfun$requestedColumnIds$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && TimestampNTZType$.MODULE$.equals(dataType2)) {
                throw QueryExecutionErrors$.MODULE$.cannotConvertOrcTimestampToTimestampNTZError();
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (TimestampNTZType$.MODULE$.equals(dataType) && TimestampType$.MODULE$.equals(dataType3)) {
                throw QueryExecutionErrors$.MODULE$.cannotConvertOrcTimestampNTZToTimestampLTZError();
            }
        }
        if (tuple2 != null) {
            DataType t1 = (DataType)tuple2._1();
            DataType t2 = (DataType)tuple2._2();
            if (t1 instanceof StructType) {
                StructType structType = (StructType)t1;
                if (t2 instanceof StructType) {
                    StructType structType2 = (StructType)t2;
                    OrcUtils$.checkTimestampCompatibility$1(structType, structType2);
                    return;
                }
            }
        }
    }

    private static final void checkTimestampCompatibility$1(StructType orcCatalystSchema, StructType dataSchema) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])orcCatalystSchema.fields()), (Function1 & Serializable)x$6 -> x$6.dataType(), ClassTag$.MODULE$.apply(DataType.class))), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fields()), (Function1 & Serializable)x$7 -> x$7.dataType(), ClassTag$.MODULE$.apply(DataType.class))))), (Function1 & Serializable)x0$1 -> {
            OrcUtils$.$anonfun$requestedColumnIds$3(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$requestedColumnIds$6(StructType dataSchema$1, Buffer orcFieldNames$1, String name) {
        int index = dataSchema$1.fieldIndex(name);
        if (index < orcFieldNames$1.length()) {
            return index;
        }
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$requestedColumnIds$8(String name$1, String x$9) {
        return BoxesRunTime.unboxToBoolean((Object)org.apache.spark.sql.catalyst.analysis.package$.MODULE$.caseSensitiveResolution().apply((Object)x$9, (Object)name$1));
    }

    public static final /* synthetic */ int $anonfun$requestedColumnIds$7(Buffer orcFieldNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            if (orcFieldNames$1.indexWhere((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.$anonfun$requestedColumnIds$8(name, x$9))) != -1) {
                return idx;
            }
            return -1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$requestedColumnIds$11(String requiredFieldName$1, int idx$1, Buffer matchedOrcFields) {
        if (matchedOrcFields.size() > 1) {
            String matchedOrcFieldsString = matchedOrcFields.mkString("[", ", ", "]");
            throw QueryExecutionErrors$.MODULE$.foundDuplicateFieldInCaseInsensitiveModeError(requiredFieldName$1, matchedOrcFieldsString);
        }
        return idx$1;
    }

    public static final /* synthetic */ int $anonfun$requestedColumnIds$10(Map caseInsensitiveOrcFieldMap$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String requiredFieldName = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            return BoxesRunTime.unboxToInt((Object)caseInsensitiveOrcFieldMap$1.get((Object)requiredFieldName.toLowerCase(Locale.ROOT)).map((Function1 & Serializable)matchedOrcFields -> BoxesRunTime.boxToInteger((int)OrcUtils$.$anonfun$requestedColumnIds$11(requiredFieldName, idx, matchedOrcFields))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
        }
        throw new MatchError((Object)tuple2);
    }

    private final Option getInnerTypeDecription$1(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
            TypeDescription typeDesc = new TypeDescription(TypeDescription.Category.INT);
            typeDesc.setAttribute(this.CATALYST_TYPE_ATTRIBUTE_NAME(), yearMonthIntervalType.typeName());
            return new Some((Object)typeDesc);
        }
        if (dataType instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
            TypeDescription typeDesc = new TypeDescription(TypeDescription.Category.LONG);
            typeDesc.setAttribute(this.CATALYST_TYPE_ATTRIBUTE_NAME(), dayTimeIntervalType.typeName());
            return new Some((Object)typeDesc);
        }
        if (dataType instanceof TimestampNTZType) {
            TimestampNTZType timestampNTZType = (TimestampNTZType)dataType;
            TypeDescription typeDesc = new TypeDescription(TypeDescription.Category.LONG);
            typeDesc.setAttribute(this.CATALYST_TYPE_ATTRIBUTE_NAME(), timestampNTZType.typeName());
            return new Some((Object)typeDesc);
        }
        if (dataType instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)dataType;
            TypeDescription typeDesc = new TypeDescription(TypeDescription.Category.TIMESTAMP);
            typeDesc.setAttribute(this.CATALYST_TYPE_ATTRIBUTE_NAME(), timestampType.typeName());
            return new Some((Object)typeDesc);
        }
        return None$.MODULE$;
    }

    private static final ColumnStatistics getColumnStatistics$1(String columnName, StructType dataSchema$2, ObjectRef columnsStatistics$1) {
        Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])dataSchema$2.fieldNames());
        String x$1 = columnName;
        int x$2 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$1);
        int columnIndex = ArrayOps$.MODULE$.indexOf$extension(qual$1, (Object)x$1, x$2);
        return ((OrcColumnStatistics)columnsStatistics$1.elem).get(columnIndex).getStatistics();
    }

    private static final WritableComparable getMinMaxFromColumnStatistics$1(ColumnStatistics statistics, DataType dataType, boolean isMax) {
        if (statistics.getNumberOfValues() == 0L) {
            return null;
        }
        ColumnStatistics columnStatistics = statistics;
        if (columnStatistics instanceof BooleanColumnStatistics) {
            BooleanColumnStatistics booleanColumnStatistics = (BooleanColumnStatistics)columnStatistics;
            boolean value = isMax ? booleanColumnStatistics.getTrueCount() > 0L : booleanColumnStatistics.getFalseCount() <= 0L;
            return new BooleanWritable(value);
        }
        if (columnStatistics instanceof IntegerColumnStatistics) {
            IntegerColumnStatistics integerColumnStatistics = (IntegerColumnStatistics)columnStatistics;
            long value = isMax ? integerColumnStatistics.getMaximum() : integerColumnStatistics.getMinimum();
            DataType dataType2 = dataType;
            if (ByteType$.MODULE$.equals(dataType2)) {
                return new ByteWritable((byte)value);
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return new ShortWritable((short)value);
            }
            if (IntegerType$.MODULE$.equals(dataType2)) {
                return new IntWritable((int)value);
            }
            if (LongType$.MODULE$.equals(dataType2)) {
                return new LongWritable(value);
            }
            throw new IllegalArgumentException("getMinMaxFromColumnStatistics should not take type " + dataType + " for IntegerColumnStatistics");
        }
        if (columnStatistics instanceof DoubleColumnStatistics) {
            DoubleColumnStatistics doubleColumnStatistics = (DoubleColumnStatistics)columnStatistics;
            double value = isMax ? doubleColumnStatistics.getMaximum() : doubleColumnStatistics.getMinimum();
            DataType dataType3 = dataType;
            if (FloatType$.MODULE$.equals(dataType3)) {
                return new FloatWritable((float)value);
            }
            if (DoubleType$.MODULE$.equals(dataType3)) {
                return new DoubleWritable(value);
            }
            throw new IllegalArgumentException("getMinMaxFromColumnStatistics should not take type " + dataType + " for DoubleColumnStatistics");
        }
        if (columnStatistics instanceof DateColumnStatistics) {
            DateColumnStatistics dateColumnStatistics = (DateColumnStatistics)columnStatistics;
            return new DateWritable(isMax ? (int)dateColumnStatistics.getMaximumDayOfEpoch() : (int)dateColumnStatistics.getMinimumDayOfEpoch());
        }
        throw new IllegalArgumentException("getMinMaxFromColumnStatistics should not take " + statistics.getClass().getName() + ": " + statistics + " as the ORC column statistics");
    }

    private OrcUtils$() {
    }
}

