/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcInputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnVector;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnVectorUtils;
import org.apache.spark.sql.execution.datasources.orc.OrcShimUtils;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class OrcColumnarBatchReader
extends org.apache.hadoop.mapreduce.RecordReader<Void, ColumnarBatch> {
    private int capacity;
    private OrcShimUtils.VectorizedRowBatchWrap wrap;
    @VisibleForTesting
    public int[] requestedDataColIds;
    private RecordReader recordReader;
    private StructField[] requiredFields;
    @VisibleForTesting
    public ColumnarBatch columnarBatch;
    private ColumnVector[] orcVectorWrappers;

    public OrcColumnarBatchReader(int capacity) {
        this.capacity = capacity;
    }

    public Void getCurrentKey() {
        return null;
    }

    public ColumnarBatch getCurrentValue() {
        return this.columnarBatch;
    }

    public float getProgress() throws IOException {
        return this.recordReader.getProgress();
    }

    public boolean nextKeyValue() throws IOException {
        return this.nextBatch();
    }

    public void close() throws IOException {
        if (this.columnarBatch != null) {
            this.columnarBatch.close();
            this.columnarBatch = null;
        }
        if (this.recordReader != null) {
            this.recordReader.close();
            this.recordReader = null;
        }
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        Configuration conf = taskAttemptContext.getConfiguration();
        Reader reader = OrcFile.createReader((Path)fileSplit.getPath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(conf)).filesystem(fileSplit.getPath().getFileSystem(conf)));
        Reader.Options options = OrcInputFormat.buildOptions((Configuration)conf, (Reader)reader, (long)fileSplit.getStart(), (long)fileSplit.getLength());
        this.recordReader = reader.rows(options);
    }

    public void initBatch(TypeDescription orcSchema, StructField[] requiredFields, int[] requestedDataColIds, int[] requestedPartitionColIds, InternalRow partitionValues) {
        this.wrap = new OrcShimUtils.VectorizedRowBatchWrap(orcSchema.createRowBatch(this.capacity));
        assert (!this.wrap.batch().selectedInUse);
        assert (requiredFields.length == requestedDataColIds.length);
        assert (requiredFields.length == requestedPartitionColIds.length);
        for (int i = 0; i < requiredFields.length; ++i) {
            if (requestedPartitionColIds[i] == -1) continue;
            requestedDataColIds[i] = -1;
        }
        this.requiredFields = requiredFields;
        this.requestedDataColIds = requestedDataColIds;
        StructType resultSchema = new StructType(requiredFields);
        this.orcVectorWrappers = new ColumnVector[resultSchema.length()];
        StructType requiredSchema = new StructType(requiredFields);
        for (int i = 0; i < requiredFields.length; ++i) {
            DataType dt = requiredFields[i].dataType();
            if (requestedPartitionColIds[i] != -1) {
                ConstantColumnVector partitionCol = new ConstantColumnVector(this.capacity, dt);
                ColumnVectorUtils.populate(partitionCol, partitionValues, requestedPartitionColIds[i]);
                this.orcVectorWrappers[i] = partitionCol;
                continue;
            }
            int colId = requestedDataColIds[i];
            if (colId == -1) {
                OnHeapColumnVector missingCol = new OnHeapColumnVector(this.capacity, dt);
                Object defaultValue = ResolveDefaultColumns.existenceDefaultValues((StructType)requiredSchema)[i];
                if (defaultValue == null) {
                    missingCol.putNulls(0, this.capacity);
                } else if (missingCol.appendObjects(this.capacity, defaultValue).isEmpty()) {
                    throw new IllegalArgumentException("Cannot assign default column value to result column batch in vectorized Orc reader because the data type is not supported: " + defaultValue);
                }
                missingCol.setIsConstant();
                this.orcVectorWrappers[i] = missingCol;
                continue;
            }
            this.orcVectorWrappers[i] = OrcColumnVectorUtils.toOrcColumnVector(dt, this.wrap.batch().cols[colId]);
        }
        this.columnarBatch = new ColumnarBatch(this.orcVectorWrappers);
    }

    private boolean nextBatch() throws IOException {
        this.recordReader.nextBatch(this.wrap.batch());
        int batchSize = this.wrap.batch().size;
        if (batchSize == 0) {
            return false;
        }
        this.columnarBatch.setNumRows(batchSize);
        for (int i = 0; i < this.requiredFields.length; ++i) {
            if (this.requestedDataColIds[i] == -1) continue;
            ((OrcColumnVector)this.orcVectorWrappers[i]).setBatchSize(batchSize);
        }
        return true;
    }
}

