/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.execution.datasources.ExecutedWriteSummary;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteTaskResult;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriteTaskStatsTracker;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]d!B\f\u0019\u0003\u0003)\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0005\u0003!\u0011!Q\u0001\n\tC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005)\")!\u000e\u0001C\u0001W\"9\u0011\u000f\u0001b\u0001\n#\u0011\bBB<\u0001A\u0003%1\u000fC\u0004y\u0001\t\u0007I\u0011C=\t\u000f\u0005\u0015\u0001\u0001)A\u0005u\"Y\u0011q\u0001\u0001A\u0002\u0003\u0007I\u0011CA\u0005\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%\t\"a\u0005\t\u0017\u0005}\u0001\u00011A\u0001B\u0003&\u00111\u0002\u0005\n\u0003C\u0001!\u0019!C\t\u0003GA\u0001\"!\u0010\u0001A\u0003%\u0011Q\u0005\u0005\b\u0003\u007f\u0001A\u0011CA!\u0011\u001d\t\u0019\u0005\u0001C\t\u0003\u0003Ba!\r\u0001\u0007\u0002\u0005\u0015\u0003bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\u001d\u0001\t\u0003\t\t\u0005C\u0004\u0002v\u0001!\t%!\u0011\u0003)\u0019KG.\u001a$pe6\fG\u000fR1uC^\u0013\u0018\u000e^3s\u0015\tI\"$A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u000e\u001d\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001e=\u0005\u00191/\u001d7\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001M9\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004PE*,7\r\u001e\t\u0004_Q2T\"\u0001\u0019\u000b\u0005E\u0012\u0014!B<sSR,'BA\u001a\u001d\u0003%\u0019wN\u001c8fGR|'/\u0003\u00026a\tQA)\u0019;b/JLG/\u001a:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eb\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005mB$aC%oi\u0016\u0014h.\u00197S_^\f1\u0002Z3tGJL\u0007\u000f^5p]B\u0011ahP\u0007\u00021%\u0011\u0001\t\u0007\u0002\u0014/JLG/\u001a&pE\u0012+7o\u0019:jaRLwN\\\u0001\u0013i\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH\u000f\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003\u000f\u0002\na\u0001[1e_>\u0004\u0018BA%E\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002\u0013\r|W.\\5ui\u0016\u0014\bC\u0001'R\u001b\u0005i%B\u0001(P\u0003\tIwN\u0003\u0002Q=\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002S\u001b\n\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m\u00035\u0019Wo\u001d;p[6+GO]5dgB!QKX1e\u001d\t1F\f\u0005\u0002X56\t\u0001L\u0003\u0002ZI\u00051AH]8pizR\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u000ba\u0001\u0015:fI\u00164\u0017BA0a\u0005\ri\u0015\r\u001d\u0006\u0003;j\u0003\"!\u00162\n\u0005\r\u0004'AB*ue&tw\r\u0005\u0002fQ6\taM\u0003\u0002h5\u00051Q.\u001a;sS\u000eL!!\u001b4\u0003\u0013M\u000bF*T3ue&\u001c\u0017A\u0002\u001fj]&$h\bF\u0003m[:|\u0007\u000f\u0005\u0002?\u0001!)A(\u0002a\u0001{!)\u0011)\u0002a\u0001\u0005\")!*\u0002a\u0001\u0017\")1+\u0002a\u0001)\u0006\u0001R*\u0011-`\r&cUiX\"P+:#VIU\u000b\u0002gB\u0011A/^\u0007\u00025&\u0011aO\u0017\u0002\u0004\u0013:$\u0018!E'B1~3\u0015\nT#`\u0007>+f\nV#SA\u0005\tR\u000f\u001d3bi\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0003i\u0004Ba_A\u0001C6\tAP\u0003\u0002~}\u00069Q.\u001e;bE2,'BA@[\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0007a(aA*fi\u0006\u0011R\u000f\u001d3bi\u0016$\u0007+\u0019:uSRLwN\\:!\u00035\u0019WO\u001d:f]R<&/\u001b;feV\u0011\u00111\u0002\t\u0004}\u00055\u0011bAA\b1\taq*\u001e;qkR<&/\u001b;fe\u0006\t2-\u001e:sK:$xK]5uKJ|F%Z9\u0015\t\u0005U\u00111\u0004\t\u0004i\u0006]\u0011bAA\r5\n!QK\\5u\u0011%\tibCA\u0001\u0002\u0004\tY!A\u0002yIE\nabY;se\u0016tGo\u0016:ji\u0016\u0014\b%A\u0007ti\u0006$8\u000f\u0016:bG.,'o]\u000b\u0003\u0003K\u0001b!a\n\u00022\u0005]b\u0002BA\u0015\u0003[q1aVA\u0016\u0013\u0005Y\u0016bAA\u00185\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u00111aU3r\u0015\r\tyC\u0017\t\u0004}\u0005e\u0012bAA\u001e1\t)rK]5uKR\u000b7o[*uCR\u001cHK]1dW\u0016\u0014\u0018AD:uCR\u001cHK]1dW\u0016\u00148\u000fI\u0001\u0015e\u0016dW-Y:f\u0007V\u0014(/\u001a8u/JLG/\u001a:\u0015\u0005\u0005U\u0011\u0001\u0005:fY\u0016\f7/\u001a*fg>,(oY3t)\u0011\t)\"a\u0012\t\r\u0005%\u0013\u00031\u00017\u0003\u0019\u0011XmY8sI\u0006\u0001rO]5uK^KG\u000f['fiJL7m\u001d\u000b\u0007\u0003+\ty%!\u0015\t\r\u0005%#\u00031\u00017\u0011\u001d\t\u0019F\u0005a\u0001\u0003+\nQaY8v]R\u00042\u0001^A,\u0013\r\tIF\u0017\u0002\u0005\u0019>tw-A\txe&$XmV5uQ&#XM]1u_J$B!!\u0006\u0002`!9\u0011\u0011M\nA\u0002\u0005\r\u0014\u0001C5uKJ\fGo\u001c:\u0011\u000b\u0005\u001d\u0012Q\r\u001c\n\t\u0005\u001d\u0014Q\u0007\u0002\t\u0013R,'/\u0019;pe\u000611m\\7nSR$\"!!\u001c\u0011\u0007y\ny'C\u0002\u0002ra\u0011qb\u0016:ji\u0016$\u0016m]6SKN,H\u000e^\u0001\u0006C\n|'\u000f^\u0001\u0006G2|7/\u001a")
public abstract class FileFormatDataWriter
implements DataWriter<InternalRow> {
    private final TaskAttemptContext taskAttemptContext;
    private final FileCommitProtocol committer;
    private final Map<String, SQLMetric> customMetrics;
    private final int MAX_FILE_COUNTER;
    private final Set<String> updatedPartitions;
    private OutputWriter currentWriter;
    private final Seq<WriteTaskStatsTracker> statsTrackers;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    public int MAX_FILE_COUNTER() {
        return this.MAX_FILE_COUNTER;
    }

    public Set<String> updatedPartitions() {
        return this.updatedPartitions;
    }

    public OutputWriter currentWriter() {
        return this.currentWriter;
    }

    public void currentWriter_$eq(OutputWriter x$1) {
        this.currentWriter = x$1;
    }

    public Seq<WriteTaskStatsTracker> statsTrackers() {
        return this.statsTrackers;
    }

    public void releaseCurrentWriter() {
        if (this.currentWriter() != null) {
            try {
                this.currentWriter().close();
                this.statsTrackers().foreach((Function1 & Serializable)x$3 -> {
                    x$3.closeFile(this.currentWriter().path());
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                this.currentWriter_$eq(null);
            }
            return;
        }
    }

    public void releaseResources() {
        this.releaseCurrentWriter();
    }

    public abstract void write(InternalRow var1);

    public void writeWithMetrics(InternalRow record, long count) {
        if (count % (long)CustomMetrics$.MODULE$.NUM_ROWS_PER_UPDATE() == 0L) {
            CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.currentMetricsValues()).toImmutableArraySeq(), this.customMetrics);
        }
        this.write(record);
    }

    public void writeWithIterator(Iterator<InternalRow> iterator) {
        long count = 0L;
        while (iterator.hasNext()) {
            this.writeWithMetrics((InternalRow)iterator.next(), count);
            ++count;
        }
        CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.currentMetricsValues()).toImmutableArraySeq(), this.customMetrics);
    }

    public WriteTaskResult commit() {
        this.releaseResources();
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable)() -> $this.committer.commitTask($this.taskAttemptContext));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileCommitProtocol.TaskCommitMessage taskCommitMessage = (FileCommitProtocol.TaskCommitMessage)tuple2._1();
        long taskCommitTime = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)taskCommitMessage, (Object)BoxesRunTime.boxToLong((long)taskCommitTime));
        FileCommitProtocol.TaskCommitMessage taskCommitMessage2 = (FileCommitProtocol.TaskCommitMessage)tuple22._1();
        long taskCommitTime2 = tuple22._2$mcJ$sp();
        ExecutedWriteSummary summary = new ExecutedWriteSummary((scala.collection.immutable.Set<String>)this.updatedPartitions().toSet(), (Seq<WriteTaskStats>)((Seq)this.statsTrackers().map((Function1 & Serializable)x$5 -> x$5.getFinalStats(taskCommitTime2))));
        return new WriteTaskResult(taskCommitMessage2, summary);
    }

    public void abort() {
        try {
            this.releaseResources();
        }
        finally {
            this.committer.abortTask(this.taskAttemptContext);
        }
    }

    public void close() {
    }

    public FileFormatDataWriter(WriteJobDescription description, TaskAttemptContext taskAttemptContext, FileCommitProtocol committer, Map<String, SQLMetric> customMetrics) {
        this.taskAttemptContext = taskAttemptContext;
        this.committer = committer;
        this.customMetrics = customMetrics;
        this.MAX_FILE_COUNTER = 1000000;
        this.updatedPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.statsTrackers = (Seq)description.statsTrackers().map((Function1 & Serializable)x$2 -> x$2.newTaskInstance());
    }
}

