/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function4;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e4AAC\u0006\u00011!)Q\u0005\u0001C\u0001M\u0015!\u0011\u0006\u0001\u0003+\u0011\u001d)\u0006A1A\u0005\nYCaA\u0019\u0001!\u0002\u00139\u0006\"B2\u0001\t\u0013!\u0007\"B4\u0001\t\u0003A\u0007\"B8\u0001\t\u0003\u0001\b\"\u0002:\u0001\t\u0003\u0019\b\"\u0002=\u0001\t\u00032#!\u0005#bi\u0006\u001cv.\u001e:dK6\u000bg.Y4fe*\u0011A\"D\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u000f\u001f\u0005IQ\r_3dkRLwN\u001c\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!G5\t\u0011E\u0003\u0002##\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002%C\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\f\u0005E!\u0015\r^1T_V\u00148-\u001a\"vS2$WM\u001d\t\b5-j\u0013\u0007P#N\u0013\ta3DA\u0005Gk:\u001cG/[8oiA\u0011afL\u0007\u0002\u001f%\u0011\u0001g\u0004\u0002\r'B\f'o[*fgNLwN\u001c\t\u0003eer!aM\u001c\u0011\u0005QZR\"A\u001b\u000b\u0005Y:\u0012A\u0002\u001fs_>$h(\u0003\u000297\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tA4\u0004E\u0002\u001b{}J!AP\u000e\u0003\r=\u0003H/[8o!\t\u00015)D\u0001B\u0015\t\u0011u\"A\u0003usB,7/\u0003\u0002E\u0003\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0011\u0007\u0019[\u0015'D\u0001H\u0015\tA\u0015*\u0001\u0003vi&d'B\u0001&\u0010\u0003!\u0019\u0017\r^1msN$\u0018B\u0001'H\u0005I\u0019\u0015m]3J]N,gn]5uSZ,W*\u00199\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003%&\u000bQ\u0001\u001d7b]NL!\u0001V(\u0003\u00171{w-[2bYBc\u0017M\\\u0001\u0013I\u0006$\u0018mU8ve\u000e,')^5mI\u0016\u00148/F\u0001X!\u0011Af,\r1\u000e\u0003eS!AW.\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002I9*\tQ,\u0001\u0003kCZ\f\u0017BA0Z\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003C\ni\u0011\u0001A\u0001\u0014I\u0006$\u0018mU8ve\u000e,')^5mI\u0016\u00148\u000fI\u0001\n]>\u0014X.\u00197ju\u0016$\"!M3\t\u000b\u0019,\u0001\u0019A\u0019\u0002\t9\fW.Z\u0001\u0013e\u0016<\u0017n\u001d;fe\u0012\u000bG/Y*pkJ\u001cW\rF\u0002jY6\u0004\"A\u00076\n\u0005-\\\"\u0001B+oSRDQA\u001a\u0004A\u0002EBQA\u001c\u0004A\u0002\u0001\fqAY;jY\u0012,'/\u0001\tm_>\\W\u000f\u001d#bi\u0006\u001cv.\u001e:dKR\u0011\u0001-\u001d\u0005\u0006M\u001e\u0001\r!M\u0001\u0011I\u0006$\u0018mU8ve\u000e,W\t_5tiN$\"\u0001^<\u0011\u0005i)\u0018B\u0001<\u001c\u0005\u001d\u0011un\u001c7fC:DQA\u001a\u0005A\u0002E\nQa\u00197p]\u0016\u0004")
public class DataSourceManager
implements Logging {
    private final ConcurrentHashMap<String, Function4<SparkSession, String, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan>> dataSourceBuilders;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<String, Function4<SparkSession, String, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan>> dataSourceBuilders() {
        return this.dataSourceBuilders;
    }

    private String normalize(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public void registerDataSource(String name, Function4<SparkSession, String, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan> builder) {
        String normalizedName = this.normalize(name);
        Function4<SparkSession, String, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan> previousValue = this.dataSourceBuilders().put(normalizedName, builder);
        if (previousValue != null) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The data source " + name + " replaced a previously registered data source.");
            return;
        }
    }

    public Function4<SparkSession, String, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan> lookupDataSource(String name) {
        if (this.dataSourceExists(name)) {
            return this.dataSourceBuilders().get(this.normalize(name));
        }
        throw QueryCompilationErrors$.MODULE$.dataSourceDoesNotExist(name);
    }

    public boolean dataSourceExists(String name) {
        return this.dataSourceBuilders().containsKey(this.normalize(name));
    }

    public DataSourceManager clone() {
        DataSourceManager manager = new DataSourceManager();
        this.dataSourceBuilders().forEach((k, v) -> manager.registerDataSource((String)k, (Function4<SparkSession, String, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan>)v));
        return manager;
    }

    public DataSourceManager() {
        Logging.$init$((Logging)this);
        this.dataSourceBuilders = new ConcurrentHashMap();
    }
}

