/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.LoadDataCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001B\u0011#\u0001>B\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005%\"Aq\u000b\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005b\u0001\tE\t\u0015!\u0003Z\u0011!\u0011\u0007A!f\u0001\n\u0003\u0019\u0007\u0002C4\u0001\u0005#\u0005\u000b\u0011\u00023\t\u0011!\u0004!Q3A\u0005\u0002\rD\u0001\"\u001b\u0001\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\tU\u0002\u0011)\u001a!C\u0001W\"I\u0011\u0011\u0002\u0001\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\tY\u0002\u0001C!\u0003;A\u0011\"a\u000e\u0001\u0003\u0003%\t!!\u000f\t\u0013\u0005\u0015\u0003!%A\u0005\u0002\u0005\u001d\u0003\"CA/\u0001E\u0005I\u0011AA0\u0011%\t\u0019\u0007AI\u0001\n\u0003\t)\u0007C\u0005\u0002j\u0001\t\n\u0011\"\u0001\u0002f!I\u00111\u000e\u0001\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003c\u0002\u0011\u0011!C!\u0003gB\u0011\"a!\u0001\u0003\u0003%\t!!\"\t\u0013\u00055\u0005!!A\u0005\u0002\u0005=\u0005\"CAN\u0001\u0005\u0005I\u0011IAO\u0011%\tY\u000bAA\u0001\n\u0003\ti\u000bC\u0005\u00022\u0002\t\t\u0011\"\u0011\u00024\"I\u0011q\u0017\u0001\u0002\u0002\u0013\u0005\u0013\u0011X\u0004\b\u0003{\u0013\u0003\u0012AA`\r\u0019\t#\u0005#\u0001\u0002B\"9\u00111B\u000e\u0005\u0002\u0005M\u0007\u0002CAk7\u0011\u0005a%a6\t\u0013\u0005}8$!A\u0005\u0002\n\u0005\u0001\"\u0003B\u00077\u0005\u0005I\u0011\u0011B\b\u0011%\u0011ibGA\u0001\n\u0013\u0011yBA\bM_\u0006$G)\u0019;b\u0007>lW.\u00198e\u0015\t\u0019C%A\u0004d_6l\u0017M\u001c3\u000b\u0005\u00152\u0013!C3yK\u000e,H/[8o\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001G\u000f E!\t\t\u0004(D\u00013\u0015\t\u0019D'A\u0004m_\u001eL7-\u00197\u000b\u0005U2\u0014!\u00029mC:\u001c(BA\u001c'\u0003!\u0019\u0017\r^1msN$\u0018BA\u001d3\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005mbT\"\u0001\u0012\n\u0005u\u0012#a\u0005'fC\u001a\u0014VO\u001c8bE2,7i\\7nC:$\u0007CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%a\u0002)s_\u0012,8\r\u001e\t\u0003\u000b6s!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%s\u0013A\u0002\u001fs_>$h(C\u0001B\u0013\ta\u0005)A\u0004qC\u000e\\\u0017mZ3\n\u00059{%\u0001D*fe&\fG.\u001b>bE2,'B\u0001'A\u0003\u0015!\u0018M\u00197f+\u0005\u0011\u0006CA*U\u001b\u00051\u0014BA+7\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018A\u0002;bE2,\u0007%\u0001\u0003qCRDW#A-\u0011\u0005isfBA.]!\t9\u0005)\u0003\u0002^\u0001\u00061\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti\u0006)A\u0003qCRD\u0007%A\u0004jg2{7-\u00197\u0016\u0003\u0011\u0004\"aP3\n\u0005\u0019\u0004%a\u0002\"p_2,\u0017M\\\u0001\tSNdunY1mA\u0005Y\u0011n](wKJ<(/\u001b;f\u00031I7o\u0014<fe^\u0014\u0018\u000e^3!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001m!\ryTn\\\u0005\u0003]\u0002\u0013aa\u00149uS>t\u0007c\u00019\u0002\u00049\u0011\u0011O \b\u0003ert!a]>\u000f\u0005QThBA;z\u001d\t1\bP\u0004\u0002Ho&\tQ&\u0003\u0002,Y%\u0011\u0011FK\u0005\u0003O!J!a\u000e\u0014\n\u0005u4\u0014aB2bi\u0006dwnZ\u0005\u0004\u007f\u0006\u0005\u0011\u0001D\"bi\u0006dwn\u001a+za\u0016\u001c(BA?7\u0013\u0011\t)!a\u0002\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0004\u007f\u0006\u0005\u0011A\u00039beRLG/[8oA\u00051A(\u001b8jiz\"B\"a\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033\u0001\"a\u000f\u0001\t\u000bA[\u0001\u0019\u0001*\t\u000b][\u0001\u0019A-\t\u000b\t\\\u0001\u0019\u00013\t\u000b!\\\u0001\u0019\u00013\t\u000b)\\\u0001\u0019\u00017\u0002\u0007I,h\u000e\u0006\u0003\u0002 \u00055\u0002#B#\u0002\"\u0005\u0015\u0012bAA\u0012\u001f\n\u00191+Z9\u0011\t\u0005\u001d\u0012\u0011F\u0007\u0002M%\u0019\u00111\u0006\u0014\u0003\u0007I{w\u000fC\u0004\u000201\u0001\r!!\r\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005\u001d\u00121G\u0005\u0004\u0003k1#\u0001D*qCJ\\7+Z:tS>t\u0017\u0001B2paf$B\"a\u0004\u0002<\u0005u\u0012qHA!\u0003\u0007Bq\u0001U\u0007\u0011\u0002\u0003\u0007!\u000bC\u0004X\u001bA\u0005\t\u0019A-\t\u000f\tl\u0001\u0013!a\u0001I\"9\u0001.\u0004I\u0001\u0002\u0004!\u0007b\u00026\u000e!\u0003\u0005\r\u0001\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIEK\u0002S\u0003\u0017Z#!!\u0014\u0011\t\u0005=\u0013\u0011L\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/\u0002\u0015AC1o]>$\u0018\r^5p]&!\u00111LA)\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tGK\u0002Z\u0003\u0017\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002h)\u001aA-a\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA8U\ra\u00171J\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0000\u0005!!.\u0019<b\u0013\ry\u0016\u0011P\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000f\u00032aPAE\u0013\r\tY\t\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003#\u000b9\nE\u0002@\u0003'K1!!&A\u0005\r\te.\u001f\u0005\n\u00033+\u0012\u0011!a\u0001\u0003\u000f\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAP!\u0019\t\t+a*\u0002\u00126\u0011\u00111\u0015\u0006\u0004\u0003K\u0003\u0015AC2pY2,7\r^5p]&!\u0011\u0011VAR\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0011\fy\u000bC\u0005\u0002\u001a^\t\t\u00111\u0001\u0002\u0012\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)(!.\t\u0013\u0005e\u0005$!AA\u0002\u0005\u001d\u0015AB3rk\u0006d7\u000fF\u0002e\u0003wC\u0011\"!'\u001a\u0003\u0003\u0005\r!!%\u0002\u001f1{\u0017\r\u001a#bi\u0006\u001cu.\\7b]\u0012\u0004\"aO\u000e\u0014\u000bm\t\u0019-!3\u0011\u0007}\n)-C\u0002\u0002H\u0002\u0013a!\u00118z%\u00164\u0007\u0003BAf\u0003#l!!!4\u000b\t\u0005=\u0017QP\u0001\u0003S>L1ATAg)\t\ty,A\u0007nC.,\u0017+^1mS\u001aLW\r\u001a\u000b\t\u00033\fI/!?\u0002~B!\u00111\\As\u001b\t\tiN\u0003\u0003\u0002`\u0006\u0005\u0018A\u00014t\u0015\r\t\u0019OK\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005\u001d\u0018Q\u001c\u0002\u0005!\u0006$\b\u000eC\u0004\u0002lv\u0001\r!!<\u0002\u0015\u0011,g-Y;miV\u0013\u0018\u000e\u0005\u0003\u0002p\u0006UXBAAy\u0015\u0011\t\u00190! \u0002\u00079,G/\u0003\u0003\u0002x\u0006E(aA+S\u0013\"9\u00111`\u000fA\u0002\u0005e\u0017AC<pe.Lgn\u001a#je\"1q+\ba\u0001\u00033\fQ!\u00199qYf$B\"a\u0004\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017AQ\u0001\u0015\u0010A\u0002ICQa\u0016\u0010A\u0002eCQA\u0019\u0010A\u0002\u0011DQ\u0001\u001b\u0010A\u0002\u0011DQA\u001b\u0010A\u00021\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0012\te\u0001\u0003B n\u0005'\u0001\u0002b\u0010B\u000b%f#G\r\\\u0005\u0004\u0005/\u0001%A\u0002+va2,W\u0007C\u0005\u0003\u001c}\t\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\u0005\u0002\u0003BA<\u0005GIAA!\n\u0002z\t1qJ\u00196fGR\u0004")
public class LoadDataCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final String path;
    private final boolean isLocal;
    private final boolean isOverwrite;
    private final Option<Map<String, String>> partition;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple5<TableIdentifier, String, Object, Object, Option<Map<String, String>>>> unapply(LoadDataCommand x$0) {
        return LoadDataCommand$.MODULE$.unapply(x$0);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        LoadDataCommand loadDataCommand = this;
        synchronized (loadDataCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String path() {
        return this.path;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isOverwrite() {
        return this.isOverwrite;
    }

    public Option<Map<String, String>> partition() {
        return this.partition;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Path path;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable targetTable = catalog.getTableMetadata(this.table());
        String tableIdentWithDB = targetTable.identifier().quotedString();
        Option normalizedSpec = this.partition().map((Function1 & Serializable)spec -> PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, targetTable.partitionSchema(), tableIdentWithDB, sparkSession.sessionState().conf().resolver()));
        if (DDLUtils$.MODULE$.isDatasourceTable(targetTable)) {
            throw QueryCompilationErrors$.MODULE$.loadDataNotSupportedForDatasourceTablesError(tableIdentWithDB);
        }
        if (targetTable.partitionColumnNames().nonEmpty()) {
            if (this.partition().isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.loadDataWithoutPartitionSpecProvidedError(tableIdentWithDB);
            }
            if (targetTable.partitionColumnNames().size() != ((IterableOnceOps)this.partition().get()).size()) {
                throw QueryCompilationErrors$.MODULE$.loadDataPartitionSizeNotMatchNumPartitionColumnsError(tableIdentWithDB, ((IterableOnceOps)this.partition().get()).size(), targetTable.partitionColumnNames().size());
            }
        } else if (this.partition().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.loadDataTargetTableNotPartitionedButPartitionSpecWasProvidedError(tableIdentWithDB);
        }
        if (this.isLocal()) {
            FileContext localFS = FileContext.getLocalFSFileContext();
            path = LoadDataCommand$.MODULE$.makeQualified(FsConstants.LOCAL_FS_URI, localFS.getWorkingDirectory(), new Path(this.path()));
        } else {
            Path loadPath = new Path(this.path());
            String defaultFSConf = sparkSession.sessionState().newHadoopConf().get("fs.defaultFS");
            URI defaultFS = defaultFSConf == null ? new URI("") : new URI(defaultFSConf);
            Path uriPath = new Path("/user/" + System.getProperty("user.name") + "/");
            path = LoadDataCommand$.MODULE$.makeQualified(defaultFS, uriPath, loadPath);
        }
        Path loadPath = path;
        FileSystem fs = loadPath.getFileSystem(sparkSession.sessionState().newHadoopConf());
        try {
            FileStatus[] fileStatus = fs.globStatus(loadPath);
            if (fileStatus == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])fileStatus))) {
                throw QueryCompilationErrors$.MODULE$.loadDataInputPathNotExistError(this.path());
            }
        }
        catch (IllegalArgumentException e) {
            this.log().warn("Exception while validating the load path " + this.path() + " ", (Throwable)e);
            throw QueryCompilationErrors$.MODULE$.loadDataInputPathNotExistError(this.path());
        }
        if (this.partition().nonEmpty()) {
            catalog.loadPartition(targetTable.identifier(), loadPath.toString(), (Map)normalizedSpec.get(), this.isOverwrite(), true, this.isLocal());
        } else {
            catalog.loadTable(targetTable.identifier(), loadPath.toString(), this.isOverwrite(), this.isLocal());
        }
        sparkSession.catalog().refreshTable(tableIdentWithDB);
        CommandUtils$.MODULE$.updateTableStats(sparkSession, targetTable);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public LoadDataCommand copy(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        return new LoadDataCommand(table, path, isLocal, isOverwrite, partition);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.path();
    }

    public boolean copy$default$3() {
        return this.isLocal();
    }

    public boolean copy$default$4() {
        return this.isOverwrite();
    }

    public Option<Map<String, String>> copy$default$5() {
        return this.partition();
    }

    public String productPrefix() {
        return "LoadDataCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.path();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.isLocal());
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.isOverwrite());
            }
            case 4: {
                return this.partition();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LoadDataCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "table";
            }
            case 1: {
                return "path";
            }
            case 2: {
                return "isLocal";
            }
            case 3: {
                return "isOverwrite";
            }
            case 4: {
                return "partition";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LoadDataCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        LoadDataCommand loadDataCommand = (LoadDataCommand)x$1;
        if (this.isLocal() != loadDataCommand.isLocal()) return false;
        if (this.isOverwrite() != loadDataCommand.isOverwrite()) return false;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = loadDataCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.path();
        String string2 = loadDataCommand.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<Map<String, String>> option = this.partition();
        Option<Map<String, String>> option2 = loadDataCommand.partition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!loadDataCommand.canEqual(this)) return false;
        return true;
    }

    public LoadDataCommand(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        this.table = table;
        this.path = path;
        this.isLocal = isLocal;
        this.isOverwrite = isOverwrite;
        this.partition = partition;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

