/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.bucketing;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.physical.AllTuples$;
import org.apache.spark.sql.catalyst.plans.physical.ClusteredDistribution;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.aggregate.BaseAggregateExec;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.BitSet;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;

public final class DisableUnnecessaryBucketedScan$
extends Rule<SparkPlan> {
    public static final DisableUnnecessaryBucketedScan$ MODULE$ = new DisableUnnecessaryBucketedScan$();

    private SparkPlan disableBucketWithInterestingPartition(SparkPlan plan, boolean withInterestingPartition, boolean withExchange, boolean withAllowedNode) {
        SparkPlan sparkPlan = plan;
        if (this.hasInterestingPartition(sparkPlan)) {
            return (SparkPlan)sparkPlan.mapChildren((Function1 & Serializable)x$1 -> MODULE$.disableBucketWithInterestingPartition((SparkPlan)x$1, true, false, true));
        }
        if (sparkPlan instanceof Exchange) {
            Exchange exchange = (Exchange)sparkPlan;
            return (SparkPlan)exchange.mapChildren((Function1 & Serializable)x$2 -> MODULE$.disableBucketWithInterestingPartition((SparkPlan)x$2, withInterestingPartition, true, withAllowedNode));
        }
        if (sparkPlan instanceof FileSourceScanExec) {
            FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
            if (fileSourceScanExec.bucketedScan()) {
                if (!withInterestingPartition || withExchange && withAllowedNode) {
                    boolean x$12 = true;
                    HadoopFsRelation x$22 = fileSourceScanExec.copy$default$1();
                    Seq<Attribute> x$32 = fileSourceScanExec.copy$default$2();
                    StructType x$4 = fileSourceScanExec.copy$default$3();
                    Seq<Expression> x$5 = fileSourceScanExec.copy$default$4();
                    Option<BitSet> x$6 = fileSourceScanExec.copy$default$5();
                    Option<Object> x$7 = fileSourceScanExec.copy$default$6();
                    Seq<Expression> x$8 = fileSourceScanExec.copy$default$7();
                    Option<TableIdentifier> x$9 = fileSourceScanExec.copy$default$8();
                    FileSourceScanExec nonBucketedScan = fileSourceScanExec.copy(x$22, x$32, x$4, x$5, x$6, x$7, x$8, x$9, true);
                    fileSourceScanExec.logicalLink().foreach((Function1 & Serializable)logicalPlan2 -> {
                        nonBucketedScan.setLogicalLink(logicalPlan2);
                        return BoxedUnit.UNIT;
                    });
                    return nonBucketedScan;
                }
                return fileSourceScanExec;
            }
            return fileSourceScanExec;
        }
        return (SparkPlan)sparkPlan.mapChildren((Function1 & Serializable)x$3 -> MODULE$.disableBucketWithInterestingPartition((SparkPlan)x$3, withInterestingPartition, withExchange, withAllowedNode && MODULE$.isAllowedUnaryExecNode(sparkPlan)));
    }

    private boolean hasInterestingPartition(SparkPlan plan) {
        return plan.requiredChildDistribution().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DisableUnnecessaryBucketedScan$.$anonfun$hasInterestingPartition$1(x0$1)));
    }

    private boolean isAllowedUnaryExecNode(SparkPlan plan) {
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof SortExec ? true : (sparkPlan instanceof ProjectExec ? true : sparkPlan instanceof FilterExec)) {
            return true;
        }
        if (sparkPlan instanceof BaseAggregateExec) {
            BaseAggregateExec baseAggregateExec = (BaseAggregateExec)((Object)sparkPlan);
            return baseAggregateExec.requiredChildDistributionExpressions().isEmpty();
        }
        return false;
    }

    public SparkPlan apply(SparkPlan plan) {
        LazyBoolean hasBucketedScan$lzy = new LazyBoolean();
        if (!(this.conf().bucketingEnabled() && this.conf().autoBucketedScanEnabled() && DisableUnnecessaryBucketedScan$.hasBucketedScan$1(hasBucketedScan$lzy, plan))) {
            return plan;
        }
        return this.disableBucketWithInterestingPartition(plan, false, false, true);
    }

    public static final /* synthetic */ boolean $anonfun$hasInterestingPartition$1(Distribution x0$1) {
        Distribution distribution = x0$1;
        return distribution instanceof ClusteredDistribution ? true : AllTuples$.MODULE$.equals(distribution);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(SparkPlan x0$1) {
        SparkPlan sparkPlan = x0$1;
        if (sparkPlan instanceof FileSourceScanExec) {
            FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
            return fileSourceScanExec.bucketedScan();
        }
        return false;
    }

    private static final /* synthetic */ boolean hasBucketedScan$lzycompute$1(LazyBoolean hasBucketedScan$lzy$1, SparkPlan plan$1) {
        boolean bl;
        LazyBoolean lazyBoolean = hasBucketedScan$lzy$1;
        synchronized (lazyBoolean) {
            bl = hasBucketedScan$lzy$1.initialized() ? hasBucketedScan$lzy$1.value() : hasBucketedScan$lzy$1.initialize(plan$1.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DisableUnnecessaryBucketedScan$.$anonfun$apply$1(x0$1))));
        }
        return bl;
    }

    private static final boolean hasBucketedScan$1(LazyBoolean hasBucketedScan$lzy$1, SparkPlan plan$1) {
        if (hasBucketedScan$lzy$1.initialized()) {
            return hasBucketedScan$lzy$1.value();
        }
        return DisableUnnecessaryBucketedScan$.hasBucketedScan$lzycompute$1(hasBucketedScan$lzy$1, plan$1);
    }

    private DisableUnnecessaryBucketedScan$() {
    }
}

