/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.Final$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PartialMerge$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.ExpandExec;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.TakeOrderedAndProjectExec;
import org.apache.spark.sql.execution.aggregate.BaseAggregateExec;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanExecBase;
import org.apache.spark.sql.execution.joins.BaseJoinExec;
import org.apache.spark.sql.execution.window.WindowExec;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class RemoveRedundantProjects$
extends Rule<SparkPlan> {
    public static final RemoveRedundantProjects$ MODULE$ = new RemoveRedundantProjects$();

    public SparkPlan apply(SparkPlan plan) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.REMOVE_REDUNDANT_PROJECTS_ENABLED()))) {
            return plan;
        }
        return this.removeProject(plan, true);
    }

    private SparkPlan removeProject(SparkPlan plan, boolean requireOrdering) {
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof ProjectExec) {
            ProjectExec projectExec = (ProjectExec)sparkPlan;
            SparkPlan child = projectExec.child();
            if (this.isRedundant(projectExec, child, requireOrdering) && this.canRemove(projectExec, child)) {
                SparkPlan newPlan = this.removeProject(child, requireOrdering);
                newPlan.setLogicalLink((LogicalPlan)child.logicalLink().get());
                return newPlan;
            }
            return (SparkPlan)projectExec.mapChildren((Function1 & Serializable)x$1 -> MODULE$.removeProject((SparkPlan)x$1, false));
        }
        if (sparkPlan instanceof TakeOrderedAndProjectExec) {
            TakeOrderedAndProjectExec takeOrderedAndProjectExec = (TakeOrderedAndProjectExec)sparkPlan;
            return (SparkPlan)takeOrderedAndProjectExec.mapChildren((Function1 & Serializable)x$2 -> MODULE$.removeProject((SparkPlan)x$2, false));
        }
        if (sparkPlan instanceof BaseAggregateExec) {
            BaseAggregateExec baseAggregateExec = (BaseAggregateExec)((Object)sparkPlan);
            boolean keepOrdering = baseAggregateExec.aggregateExpressions().exists((Function1 & Serializable)ae -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantProjects$.$anonfun$removeProject$3(ae)));
            return (SparkPlan)baseAggregateExec.mapChildren((Function1 & Serializable)x$3 -> MODULE$.removeProject((SparkPlan)x$3, keepOrdering));
        }
        boolean required = this.canPassThrough(sparkPlan) ? requireOrdering : true;
        return (SparkPlan)sparkPlan.mapChildren((Function1 & Serializable)x$4 -> MODULE$.removeProject((SparkPlan)x$4, required));
    }

    private boolean canPassThrough(SparkPlan plan) {
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof FilterExec) {
            return true;
        }
        if (sparkPlan instanceof BaseJoinExec) {
            return true;
        }
        if (sparkPlan instanceof WindowExec) {
            return true;
        }
        return sparkPlan instanceof ExpandExec;
    }

    private boolean checkNullability(Seq<Attribute> output, Seq<Attribute> childOutput) {
        return ((IterableOnceOps)output.zip(childOutput)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantProjects$.$anonfun$checkNullability$1(x0$1)));
    }

    private boolean isRedundant(ProjectExec project, SparkPlan child, boolean requireOrdering) {
        DataSourceV2ScanExecBase dataSourceV2ScanExecBase;
        FilterExec filterExec;
        SparkPlan d;
        DataSourceV2ScanExecBase dataSourceV2ScanExecBase2;
        SparkPlan sparkPlan = child;
        if (sparkPlan instanceof DataSourceV2ScanExecBase && !(dataSourceV2ScanExecBase2 = (DataSourceV2ScanExecBase)((Object)sparkPlan)).supportsColumnar()) {
            return false;
        }
        if (sparkPlan instanceof FilterExec && (d = (filterExec = (FilterExec)sparkPlan).child()) instanceof DataSourceV2ScanExecBase && !(dataSourceV2ScanExecBase = (DataSourceV2ScanExecBase)((Object)d)).supportsColumnar()) {
            return false;
        }
        if (requireOrdering) {
            return BoxesRunTime.equals((Object)project.output().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$1(x$5))), (Object)child.output().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$2(x$6)))) && this.checkNullability(project.output(), (Seq<Attribute>)child.output());
        }
        Seq orderedProjectOutput = (Seq)project.output().sortBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$3(x$7)), (Ordering)Ordering.Long$.MODULE$);
        Seq orderedChildOutput = (Seq)child.output().sortBy((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$4(x$8)), (Ordering)Ordering.Long$.MODULE$);
        return BoxesRunTime.equals((Object)orderedProjectOutput.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$5(x$9))), (Object)orderedChildOutput.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$6(x$10)))) && this.checkNullability((Seq<Attribute>)orderedProjectOutput, (Seq<Attribute>)orderedChildOutput);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canRemove(ProjectExec project, SparkPlan child) {
        if (project.logicalLink().isEmpty()) return true;
        Option<LogicalPlan> option = child.logicalLink();
        if (!project.logicalLink().exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)option.contains(elem)))) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$removeProject$3(AggregateExpression ae) {
        return ae.mode().equals(Final$.MODULE$) || ae.mode().equals(PartialMerge$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$checkNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Attribute attr1 = (Attribute)tuple2._1();
            Attribute attr2 = (Attribute)tuple2._2();
            return attr1.nullable() || !attr2.nullable();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$isRedundant$1(Attribute x$5) {
        return x$5.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$2(Attribute x$6) {
        return x$6.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$3(Attribute x$7) {
        return x$7.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$4(Attribute x$8) {
        return x$8.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$5(Attribute x$9) {
        return x$9.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$6(Attribute x$10) {
        return x$10.exprId().id();
    }

    private RemoveRedundantProjects$() {
    }
}

