/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001\u0002\u0011\"\u00011BQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001A\u0002\u0013%A\tC\u0004Q\u0001\u0001\u0007I\u0011B)\t\r]\u0003\u0001\u0015)\u0003F\u0011\u001d\u0001\u0007A1A\u0005\n\u0005Daa\u001e\u0001!\u0002\u0013\u0011\u0007\"\u0002=\u0001\t\u0003I\b\"\u0002>\u0001\t\u0003Y\b\"\u0002?\u0001\t\u0003i\b\"CA&\u0001E\u0005I\u0011AA'\u0011%\t\u0019\u0007AI\u0001\n\u0003\t)\u0007\u0003\u0004}\u0001\u0011\u0005\u0011\u0011\u000e\u0005\u0007y\u0002!\t!!$\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011q\u0013\u0001\u0005\u0002\u0005-\u0006\"CA]\u0001E\u0005I\u0011AA^\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003Dq!!4\u0001\t\u0013\ty\rC\u0004\u0002\u0018\u0002!\t!a9\t\u0011\u0005U\b\u0001\"\u0001$\u0003oDqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u001a\u0001!IAa\u0007\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(!9!Q\u0005\u0001\u0005\u0002\t]\u0002b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005\u0003\u0002A\u0011\u0001B\"\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0017BqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0004\u0003v\u0001!IAa\u001e\t\u000f\t5\u0005\u0001\"\u0001\u0003\u0010\"9!\u0011\u0014\u0001\u0005\n\tm%\u0001D\"bG\",W*\u00198bO\u0016\u0014(B\u0001\u0012$\u0003%)\u00070Z2vi&|gN\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001[MJ\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u00025o5\tQG\u0003\u00027K\u0005A\u0011N\u001c;fe:\fG.\u0003\u00029k\t9Aj\\4hS:<\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\"\u0003!\tG-\u00199uSZ,\u0017B\u0001 <\u0005]\tE-\u00199uSZ,7\u000b]1sWBc\u0017M\u001c%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002\u0003B\u0011!\tA\u0007\u0002C\u0005Q1-Y2iK\u0012$\u0015\r^1\u0016\u0003\u0015\u00032AR&N\u001b\u00059%B\u0001%J\u0003%IW.\\;uC\ndWM\u0003\u0002K_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051;%AC%oI\u0016DX\rZ*fcB\u0011!IT\u0005\u0003\u001f\u0006\u0012!bQ1dQ\u0016$G)\u0019;b\u00039\u0019\u0017m\u00195fI\u0012\u000bG/Y0%KF$\"AU+\u0011\u00059\u001a\u0016B\u0001+0\u0005\u0011)f.\u001b;\t\u000fY\u001b\u0011\u0011!a\u0001\u000b\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\r\f7\r[3e\t\u0006$\u0018\r\t\u0015\u0003\te\u0003\"A\f.\n\u0005m{#!\u0003;sC:\u001c\u0018.\u001a8uQ\t!Q\f\u0005\u0002/=&\u0011ql\f\u0002\tm>d\u0017\r^5mK\u0006\u0019bm\u001c:dK\u0012K7/\u00192mK\u000e{gNZ5hgV\t!\rE\u0002dW:t!\u0001Z5\u000f\u0005\u0015DW\"\u00014\u000b\u0005\u001d\\\u0013A\u0002\u001fs_>$h(C\u00011\u0013\tQw&A\u0004qC\u000e\\\u0017mZ3\n\u00051l'aA*fc*\u0011!n\f\t\u0004_J$X\"\u00019\u000b\u0005E,\u0014AB2p]\u001aLw-\u0003\u0002ta\nY1i\u001c8gS\u001e,e\u000e\u001e:z!\tqS/\u0003\u0002w_\t9!i\\8mK\u0006t\u0017\u0001\u00064pe\u000e,G)[:bE2,7i\u001c8gS\u001e\u001c\b%\u0001\u0006dY\u0016\f'oQ1dQ\u0016$\u0012AU\u0001\bSN,U\u000e\u001d;z+\u0005!\u0018AC2bG\",\u0017+^3ssR1!K`A\u0011\u0003wAaa`\u0005A\u0002\u0005\u0005\u0011!B9vKJL\b\u0007BA\u0002\u0003\u001f\u0001b!!\u0002\u0002\b\u0005-Q\"A\u0012\n\u0007\u0005%1EA\u0004ECR\f7/\u001a;\u0011\t\u00055\u0011q\u0002\u0007\u0001\t-\t\tB`A\u0001\u0002\u0003\u0015\t!a\u0005\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0016\u0005m\u0001c\u0001\u0018\u0002\u0018%\u0019\u0011\u0011D\u0018\u0003\u000f9{G\u000f[5oOB\u0019a&!\b\n\u0007\u0005}qFA\u0002B]fD\u0011\"a\t\n!\u0003\u0005\r!!\n\u0002\u0013Q\f'\r\\3OC6,\u0007#\u0002\u0018\u0002(\u0005-\u0012bAA\u0015_\t1q\n\u001d;j_:\u0004B!!\f\u000269!\u0011qFA\u0019!\t)w&C\u0002\u00024=\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001c\u0003s\u0011aa\u0015;sS:<'bAA\u001a_!I\u0011QH\u0005\u0011\u0002\u0003\u0007\u0011qH\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI\u0013\u0002\u000fM$xN]1hK&!\u0011\u0011JA\"\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0003Q\u0019\u0017m\u00195f#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\n\u0016\u0005\u0003K\t\tf\u000b\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!C;oG\",7m[3e\u0015\r\tifL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA1\u0003/\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Q\u0019\u0017m\u00195f#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\r\u0016\u0005\u0003\u007f\t\t\u0006F\u0004S\u0003W\n\u0019(a#\t\r\u0019b\u0001\u0019AA7!\u0011\t)!a\u001c\n\u0007\u0005E4E\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0002v1\u0001\r!a\u001e\u0002\u0017Ad\u0017M\u001c+p\u0007\u0006\u001c\u0007.\u001a\t\u0005\u0003s\n9)\u0004\u0002\u0002|)!\u0011QPA@\u0003\u001dawnZ5dC2TA!!!\u0002\u0004\u0006)\u0001\u000f\\1og*\u0019\u0011QQ\u0012\u0002\u0011\r\fG/\u00197zgRLA!!#\u0002|\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u001d\t\u0019\u0003\u0004a\u0001\u0003K!\u0012BUAH\u0003#\u000b\u0019*!&\t\r\u0019j\u0001\u0019AA7\u0011\u001d\t)(\u0004a\u0001\u0003oBq!a\t\u000e\u0001\u0004\t)\u0003C\u0004\u0002>5\u0001\r!a\u0010\u0002\u0019Ut7-Y2iKF+XM]=\u0015\u000bI\u000bY*a*\t\r}t\u0001\u0019AAOa\u0011\ty*a)\u0011\r\u0005\u0015\u0011qAAQ!\u0011\ti!a)\u0005\u0019\u0005\u0015\u00161TA\u0001\u0002\u0003\u0015\t!a\u0005\u0003\u0007}##\u0007\u0003\u0004\u0002*:\u0001\r\u0001^\u0001\bG\u0006\u001c8-\u00193f)%\u0011\u0016QVAX\u0003g\u000b)\f\u0003\u0004'\u001f\u0001\u0007\u0011Q\u000e\u0005\b\u0003c{\u0001\u0019AA<\u0003\u0011\u0001H.\u00198\t\r\u0005%v\u00021\u0001u\u0011!\t9l\u0004I\u0001\u0002\u0004!\u0018\u0001\u00032m_\u000e\\\u0017N\\4\u0002-Ut7-Y2iKF+XM]=%I\u00164\u0017-\u001e7uIQ*\"!!0+\u0007Q\f\t&\u0001\nv]\u000e\f7\r[3UC\ndWm\u0014:WS\u0016<Hc\u0002*\u0002D\u0006\u0015\u00171\u001a\u0005\u0007ME\u0001\r!!\u001c\t\u000f\u0005\u001d\u0017\u00031\u0001\u0002J\u0006!a.Y7f!\u0011\u00197.a\u000b\t\r\u0005%\u0016\u00031\u0001u\u0003QI7/T1uG\",G\rV1cY\u0016|%OV5foR9A/!5\u0002T\u0006U\u0007bBAY%\u0001\u0007\u0011q\u000f\u0005\b\u0003\u000f\u0014\u0002\u0019AAe\u0011\u001d\t9N\u0005a\u0001\u00033\fAaY8oMB!\u00111\\Ap\u001b\t\tiN\u0003\u00027G%!\u0011\u0011]Ao\u0005\u001d\u0019\u0016\u000bT\"p]\u001a$\u0012BUAs\u0003O\f\t0a=\t\r\u0019\u001a\u0002\u0019AA7\u0011\u001d\tIo\u0005a\u0001\u0003W\fQ\"[:NCR\u001c\u0007.\u001a3QY\u0006t\u0007C\u0002\u0018\u0002n\u0006]D/C\u0002\u0002p>\u0012\u0011BR;oGRLwN\\\u0019\t\r\u0005%6\u00031\u0001u\u0011\u0019\t9l\u0005a\u0001i\u00069\u0012M\\1msj,7i\u001c7v[:\u001c\u0015m\u00195f#V,'/\u001f\u000b\b%\u0006e\u0018Q`A\u0000\u0011\u001d\tY\u0010\u0006a\u0001\u0003[\nAb\u001d9be.\u001cVm]:j_:DQa\u0011\u000bA\u00025CqA!\u0001\u0015\u0001\u0004\u0011\u0019!\u0001\u0004d_2,XN\u001c\t\u0005G.\u0014)\u0001\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\u0011\u0011Y!a!\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0005\u001f\u0011IAA\u0005BiR\u0014\u0018NY;uK\u0006i!/Z2bG\",')\u001f)mC:$RA\u0015B\u000b\u0005/AaAJ\u000bA\u0002\u00055\u0004bBAY+\u0001\u0007\u0011qO\u0001\u0013e\u0016\u001c\u0017m\u00195f\u0005f\u001cuN\u001c3ji&|g\u000eF\u0003S\u0005;\u0011y\u0002\u0003\u0004'-\u0001\u0007\u0011Q\u000e\u0005\b\u0005C1\u0002\u0019\u0001B\u0012\u0003%\u0019wN\u001c3ji&|g\u000eE\u0003/\u0003[lE/\u0001\tm_>\\W\u000f]\"bG\",G\rR1uCR!!\u0011\u0006B\u0016!\u0011q\u0013qE'\t\r}<\u0002\u0019\u0001B\u0017a\u0011\u0011yCa\r\u0011\r\u0005\u0015\u0011q\u0001B\u0019!\u0011\tiAa\r\u0005\u0019\tU\"1FA\u0001\u0002\u0003\u0015\t!a\u0005\u0003\u0007}#3\u0007\u0006\u0003\u0003*\te\u0002bBAY1\u0001\u0007\u0011qO\u0001\u000ekN,7)Y2iK\u0012$\u0015\r^1\u0015\t\u0005]$q\b\u0005\b\u0003cK\u0002\u0019AA<\u00035\u0011XmY1dQ\u0016\u0014\u0015\u0010U1uQR)!K!\u0012\u0003H!1aE\u0007a\u0001\u0003[BqA!\u0013\u001b\u0001\u0004\tY#\u0001\u0007sKN|WO]2f!\u0006$\b\u000eF\u0004S\u0005\u001b\u0012yE!\u0019\t\r\u0019Z\u0002\u0019AA7\u0011\u001d\u0011Ie\u0007a\u0001\u0005#\u0002BAa\u0015\u0003^5\u0011!Q\u000b\u0006\u0005\u0005/\u0012I&\u0001\u0002gg*\u0019!1L\u0014\u0002\r!\fGm\\8q\u0013\u0011\u0011yF!\u0016\u0003\tA\u000bG\u000f\u001b\u0005\b\u0005/Z\u0002\u0019\u0001B2!\u0011\u0011\u0019F!\u001a\n\t\t\u001d$Q\u000b\u0002\u000b\r&dWmU=ti\u0016l\u0017\u0001\u00057p_.,\b/\u00118e%\u00164'/Z:i)\u001d!(Q\u000eB8\u0005cBq!!-\u001d\u0001\u0004\t9\bC\u0004\u0003Xq\u0001\rAa\u0019\t\u000f\tMD\u00041\u0001\u0003R\u0005i\u0011/^1mS\u001aLW\r\u001a)bi\"\f1D]3ge\u0016\u001c\bNR5mK&sG-\u001a=JM:+7-Z:tCJLHc\u0002;\u0003z\t%%1\u0012\u0005\b\u0005wj\u0002\u0019\u0001B?\u0003%1\u0017\u000e\\3J]\u0012,\u0007\u0010\u0005\u0003\u0003\u0000\t\u0015UB\u0001BA\u0015\r\u0011\u0019)I\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0003\u0003\b\n\u0005%!\u0003$jY\u0016Le\u000eZ3y\u0011\u001d\u00119&\ba\u0001\u0005GBqAa\u001d\u001e\u0001\u0004\u0011\t&\u0001\u0005jgN+(\rR5s)\u0015!(\u0011\u0013BK\u0011\u001d\u0011\u0019J\ba\u0001\u0005#\n1#];bY&4\u0017.\u001a3QCRD\u0007+\u0019:f]RDqAa&\u001f\u0001\u0004\u0011\t&\u0001\nrk\u0006d\u0017NZ5fIB\u000bG\u000f[\"iS2$\u0017aH4fi>\u00138\t\\8oKN+7o]5p]^KG\u000f[\"p]\u001aLwm](gMR!\u0011Q\u000eBO\u0011\u001d\u0011yj\ba\u0001\u0003[\nqa]3tg&|g\u000e")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private final Seq<ConfigEntry<Object>> forceDisableConfigs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    private Seq<ConfigEntry<Object>> forceDisableConfigs() {
        return this.forceDisableConfigs;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.cacheQuery(query.sparkSession(), query.queryExecution().normalized(), tableName, storageLevel);
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName) {
        this.cacheQuery(spark, planToCache, tableName, StorageLevel$.MODULE$.MEMORY_AND_DISK());
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        StorageLevel storageLevel2 = storageLevel;
        StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null)) {
            return;
        }
        if (this.lookupCachedData(planToCache).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Asked to cache already cached data.");
            return;
        }
        SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
        InMemoryRelation inMemoryRelation = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(planToCache, sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
        });
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (this.lookupCachedData(planToCache).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Data has already been cached.");
            } else {
                CachedData cachedData = new CachedData(planToCache, inMemoryRelation);
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData)));
            }
        }
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query.sparkSession(), query.queryExecution().normalized(), cascade, this.uncacheQuery$default$4());
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.uncacheQuery(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.sameResult((QueryPlan)plan)), cascade, blocking);
    }

    public void uncacheTableOrView(SparkSession spark, Seq<String> name, boolean cascade) {
        this.uncacheQuery(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$3, (Seq<String>)name, spark.sessionState().conf())), cascade, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMatchedTableOrView(LogicalPlan plan, Seq<String> name, SQLConf conf) {
        boolean bl = false;
        SubqueryAlias subqueryAlias = null;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof SubqueryAlias) {
            LogicalRelation logicalRelation;
            Option<CatalogTable> option;
            bl = true;
            subqueryAlias = (SubqueryAlias)logicalPlan2;
            AliasIdentifier ident = subqueryAlias.identifier();
            LogicalPlan logicalPlan3 = subqueryAlias.child();
            if (logicalPlan3 instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan3).catalogTable()) instanceof Some) {
                Some some = (Some)option;
                CatalogTable catalogTable = (CatalogTable)some.value();
                TableIdentifier v1Ident = catalogTable.identifier();
                if (!CacheManager.isSameName$1((Seq)ident.qualifier().$colon$plus((Object)ident.name()), name, conf)) return false;
                if (!CacheManager.isSameName$1((Seq)((SeqOps)Option$.MODULE$.option2Iterable(v1Ident.catalog()).toSeq().$plus$plus((IterableOnce)v1Ident.database())).$colon$plus((Object)v1Ident.table()), name, conf)) return false;
                return true;
            }
        }
        if (bl) {
            AliasIdentifier ident = subqueryAlias.identifier();
            LogicalPlan logicalPlan4 = subqueryAlias.child();
            if (logicalPlan4 instanceof DataSourceV2Relation) {
                DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan4;
                Option option = dataSourceV2Relation.catalog();
                Option option2 = dataSourceV2Relation.identifier();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CatalogPlugin catalog = (CatalogPlugin)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Identifier v2Ident = (Identifier)some2.value();
                        if (!CacheManager.isSameName$1((Seq)ident.qualifier().$colon$plus((Object)ident.name()), name, conf)) return false;
                        String string = catalog.name();
                        if (!CacheManager.isSameName$1((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])v2Ident.namespace()), (Object)string, ClassTag$.MODULE$.apply(String.class))), (Object)v2Ident.name(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq(), name, conf)) return false;
                        return true;
                    }
                }
            }
        }
        if (bl) {
            AliasIdentifier ident = subqueryAlias.identifier();
            LogicalPlan logicalPlan5 = subqueryAlias.child();
            if (logicalPlan5 instanceof View) {
                View view = (View)logicalPlan5;
                CatalogTable catalogTable = view.desc();
                TableIdentifier v1Ident = catalogTable.identifier();
                if (!CacheManager.isSameName$1((Seq)ident.qualifier().$colon$plus((Object)ident.name()), name, conf)) return false;
                if (!CacheManager.isSameName$1((Seq)((SeqOps)Option$.MODULE$.option2Iterable(v1Ident.catalog()).toSeq().$plus$plus((IterableOnce)v1Ident.database())).$colon$plus((Object)v1Ident.table()), name, conf)) return false;
                return true;
            }
        }
        if (!bl) return false;
        AliasIdentifier ident = subqueryAlias.identifier();
        LogicalPlan logicalPlan6 = subqueryAlias.child();
        if (!(logicalPlan6 instanceof HiveTableRelation)) return false;
        HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan6;
        CatalogTable catalogTable = hiveTableRelation.tableMeta();
        TableIdentifier v1Ident = catalogTable.identifier();
        if (!CacheManager.isSameName$1((Seq)ident.qualifier().$colon$plus((Object)ident.name()), name, conf)) return false;
        if (!CacheManager.isSameName$1((Seq)((SeqOps)Option$.MODULE$.option2Iterable(v1Ident.catalog()).toSeq().$plus$plus((IterableOnce)v1Ident.database())).$colon$plus((Object)v1Ident.table()), name, conf)) return false;
        return true;
    }

    public void uncacheQuery(SparkSession spark, Function1<LogicalPlan, Object> isMatchedPlan, boolean cascade, boolean blocking) {
        Function1 & Serializable shouldRemove = cascade ? (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists(isMatchedPlan)) : isMatchedPlan;
        IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$3(shouldRemove, cd)));
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$5(cd, x$5)))))));
        }
        plansToUncache.foreach((Function1 & Serializable)x$6 -> {
            CacheManager.$anonfun$uncacheQuery$6(blocking, x$6);
            return BoxedUnit.UNIT;
        });
        if (!cascade) {
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$7(isMatchedPlan, cd)));
            return;
        }
    }

    public boolean uncacheQuery$default$4() {
        return false;
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        long rowCount2 = tuple22._1$mcJ$sp();
        Map newColStats2 = (Map)tuple22._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(plan, x$8)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$10)))))));
        }
        needToRecache.foreach((Function1 & Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.lookupCachedData(query.queryExecution().normalized());
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return this.cachedData().find((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = (LogicalPlan)plan.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof IgnoreCachedData) {
                    IgnoreCachedData ignoreCachedData = (IgnoreCachedData)A1;
                    return (B1)ignoreCachedData;
                }
                return (B1)this.$outer.lookupCachedData(A1).map((Function1 & Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)cachedPlan, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 != null) {
                            HintInfo hint = (HintInfo)tuple2._1();
                            LogicalPlan p = (LogicalPlan)tuple2._2();
                            return new ResolvedHint(p, hint);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }).getOrElse((Function0 & Serializable)() -> A1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof IgnoreCachedData) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), newPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    return (B1)subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof SubqueryExpression;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$12)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                return this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            }
            return false;
        }
        if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            return this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        }
        return false;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            needToRefresh = ((IterableOnceOps)fileIndex.rootPaths().map((Function1 & Serializable)x$14 -> x$14.makeQualified(fs.getUri(), fs.getWorkingDirectory()))).exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)this.isSubDir(qualifiedPath, x$15)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public boolean isSubDir(Path qualifiedPathParent, Path qualifiedPathChild) {
        return package$.MODULE$.Iterator().iterate((Object)qualifiedPathChild, (Function1 & Serializable)x$16 -> x$16.getParent()).takeWhile((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$isSubDir$2(x$17))).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.equals((Object)qualifiedPathParent)));
    }

    private SparkSession getOrCloneSessionWithConfigsOff(SparkSession session) {
        if (BoxesRunTime.unboxToBoolean(session.conf().get(SQLConf$.MODULE$.CAN_CHANGE_CACHED_PLAN_OUTPUT_PARTITIONING()))) {
            ConfigEntry configEntry = SQLConf$.MODULE$.ADAPTIVE_EXECUTION_APPLY_FINAL_STAGE_SHUFFLE_OPTIMIZATIONS();
            ConfigEntry configEntry2 = SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED();
            return SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, (Seq<ConfigEntry<Object>>)Nil$.MODULE$.$colon$colon((Object)configEntry2).$colon$colon((Object)configEntry));
        }
        return SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, this.forceDisableConfigs());
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    private static final boolean isSameName$1(Seq nameInCache, Seq name$2, SQLConf conf$1) {
        return nameInCache.length() == name$2.length() && ((IterableOnceOps)nameInCache.zip((IterableOnce)name$2)).forall(conf$1.resolver().tupled());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$3(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$5(CachedData cd$1, CachedData x$5) {
        return x$5 == cd$1;
    }

    public static final /* synthetic */ void $anonfun$uncacheQuery$6(boolean blocking$1, CachedData x$6) {
        x$6.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$7(Function1 isMatchedPlan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().exists(isMatchedPlan$1) && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan plan$2, CachedData x$8) {
        return x$8.plan().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.sameResult((QueryPlan)plan$2)));
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$2, CachedData x$10) {
        return x$10 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$2, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithConfigsOff = $this.getOrCloneSessionWithConfigsOff(spark$2);
        InMemoryRelation x$1 = newCache = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(cd.plan(), sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
        });
        LogicalPlan x$2 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$2, x$1);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.lookupCachedData(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData)));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$12) {
        return x$12.plan().exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$13, fs$1, qualifiedPath$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isSubDir$2(Path x$17) {
        return x$17 != null;
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.forceDisableConfigs = new .colon.colon((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED(), (List)new .colon.colon((Object)SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED(), (List)Nil$.MODULE$));
    }
}

