/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.artifact;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.JobArtifactSet$;
import org.apache.spark.JobArtifactState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEnvFileServer;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.artifact.ArtifactManager$;
import org.apache.spark.sql.artifact.util.ArtifactUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.CacheId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.StubClassLoader$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\u0014(\u0001IB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006\u0013\u0002!\tB\u0013\u0005\n+\u0002A)\u0019!C\u0001OYC!B\u0019\u0001\u0011\u0002\u0003\r\t\u0015!\u0003d\u0011!1\u0007A1A\u0005\u0012\u001dR\u0005BB4\u0001A\u0003%1\n\u0003\u0005i\u0001\t\u0007I\u0011C\u0014W\u0011\u0019I\u0007\u0001)A\u0005/\"Q!\u000e\u0001I\u0001\u0002\u0007\u0005\u000b\u0011B2\t\u0011-\u0004!\u0019!C\tO)Ca\u0001\u001c\u0001!\u0002\u0013Y\u0005\u0002C7\u0001\u0005\u0004%\tb\n,\t\r9\u0004\u0001\u0015!\u0003X\u0011!y\u0007A1A\u0005\u0012\u001d\u0002\bBB;\u0001A\u0003%\u0011\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0005\u0002\u0016!A\u0011q\u0005\u0001!\u0002\u0013\t9\u0002C\u0005\u0002*\u0001\u0011\r\u0011\"\u0005\u0002,!A\u0011q\u0006\u0001!\u0002\u0013\ti\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011\u0011\f\u0001\u0005\u0012\u0005m\u0003\"CA;\u0001E\u0005I\u0011CA<\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!a)\u0001\t\u0003\t)\u000b\u0003\u0005\u00024\u0002!\t!KA[\u0011\u001d\t9\f\u0001C\u0001\u0003s;q!a0(\u0011\u0003\t\tM\u0002\u0004'O!\u0005\u00111\u0019\u0005\u0007\t~!\t!!2\t\u0013\u0005\u001dwD1A\u0005\u0002\u0005%\u0007\u0002CAh?\u0001\u0006I!a3\t\u0013\u0005EwD1A\u0005\u0002\u0005%\u0007\u0002CAj?\u0001\u0006I!a3\t\u0015\u0005Uw\u0004#b\u0001\n\u00039#JA\bBeRLg-Y2u\u001b\u0006t\u0017mZ3s\u0015\tA\u0013&\u0001\u0005beRLg-Y2u\u0015\tQ3&A\u0002tc2T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\r\u00011'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ijT\"A\u001e\u000b\u0005qZ\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005yZ$a\u0002'pO\u001eLgnZ\u0001\bg\u0016\u001c8/[8o!\t\t%)D\u0001*\u0013\t\u0019\u0015F\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003\r\"\u0003\"a\u0012\u0001\u000e\u0003\u001dBQa\u0010\u0002A\u0002\u0001\u000b\u0001#\u0019:uS\u001a\f7\r\u001e*p_R\u0004\u0016\r\u001e5\u0016\u0003-\u0003\"\u0001T*\u000e\u00035S!AT(\u0002\t\u0019LG.\u001a\u0006\u0003!F\u000b1A\\5p\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V'\u0003\tA\u000bG\u000f[\u0001\u0010CJ$\u0018NZ1diJ{w\u000e^+S\u0013V\tq\u000b\u0005\u0002Y?:\u0011\u0011,\u0018\t\u00035Vj\u0011a\u0017\u0006\u00039F\na\u0001\u0010:p_Rt\u0014B\u000106\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y+\u0014a\u0001=%cA!A\u0007Z&X\u0013\t)WG\u0001\u0004UkBdWMM\u0001\rCJ$\u0018NZ1diB\u000bG\u000f[\u0001\u000eCJ$\u0018NZ1diB\u000bG\u000f\u001b\u0011\u0002\u0017\u0005\u0014H/\u001b4bGR,&+S\u0001\rCJ$\u0018NZ1diV\u0013\u0016\nI\u0001\u0004q\u0012\u0012\u0014\u0001C2mCN\u001cH)\u001b:\u0002\u0013\rd\u0017m]:ESJ\u0004\u0013\u0001C2mCN\u001cXKU%\u0002\u0013\rd\u0017m]:V%&\u0003\u0013!B:uCR,W#A9\u0011\u0005I\u001cX\"A\u0016\n\u0005Q\\#\u0001\u0005&pE\u0006\u0013H/\u001b4bGR\u001cF/\u0019;f\u0003\u0019\u0019H/\u0019;fA\u0005iq/\u001b;i%\u0016\u001cx.\u001e:dKN,\"\u0001_>\u0015\u0007e\fI\u0001\u0005\u0002{w2\u0001A!\u0002?\u0012\u0005\u0004i(!\u0001+\u0012\u0007y\f\u0019\u0001\u0005\u00025\u007f&\u0019\u0011\u0011A\u001b\u0003\u000f9{G\u000f[5oOB\u0019A'!\u0002\n\u0007\u0005\u001dQGA\u0002B]fD\u0001\"a\u0003\u0012\t\u0003\u0007\u0011QB\u0001\u0002MB!A'a\u0004z\u0013\r\t\t\"\u000e\u0002\ty\tLh.Y7f}\u0005A!.\u0019:t\u0019&\u001cH/\u0006\u0002\u0002\u0018A)\u0011\u0011DA\u0012\u00176\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\tR\u0003\u0011)H/\u001b7\n\t\u0005\u0015\u00121\u0004\u0002\u0015\u0007>\u0004\u0018p\u00148Xe&$X-\u0011:sCfd\u0015n\u001d;\u0002\u0013)\f'o\u001d'jgR\u0004\u0013!\u00059zi\"|g.\u00138dYV$W\rT5tiV\u0011\u0011Q\u0006\t\u0006\u00033\t\u0019cV\u0001\u0013af$\bn\u001c8J]\u000edW\u000fZ3MSN$\b%\u0001\u0007hKR\fE\rZ3e\u0015\u0006\u00148/\u0006\u0002\u00026A1\u0011qGA!\u0003\u000frA!!\u000f\u0002>9\u0019!,a\u000f\n\u0003YJ1!a\u00106\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0011\u0002F\t\u00191+Z9\u000b\u0007\u0005}R\u0007\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti%U\u0001\u0004]\u0016$\u0018\u0002BA)\u0003\u0017\u00121!\u0016*M\u0003E9W\r\u001e)zi\"|g.\u00138dYV$Wm]\u000b\u0003\u0003/\u0002R!a\u000e\u0002B]\u000b\u0001\"\\8wK\u001aKG.\u001a\u000b\t\u0003;\n\u0019'a\u001a\u0002lA\u0019A'a\u0018\n\u0007\u0005\u0005TG\u0001\u0003V]&$\bBBA31\u0001\u00071*\u0001\u0004t_V\u00148-\u001a\u0005\u0007\u0003SB\u0002\u0019A&\u0002\rQ\f'oZ3u\u0011%\ti\u0007\u0007I\u0001\u0002\u0004\ty'\u0001\bbY2|wo\u0014<fe^\u0014\u0018\u000e^3\u0011\u0007Q\n\t(C\u0002\u0002tU\u0012qAQ8pY\u0016\fg.\u0001\nn_Z,g)\u001b7fI\u0011,g-Y;mi\u0012\u001aTCAA=U\u0011\ty'a\u001f,\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\"6\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\u000b\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\"\u00193e\u0003J$\u0018NZ1diRA\u0011QLAI\u0003+\u000bI\n\u0003\u0004\u0002\u0014j\u0001\raS\u0001\u0013e\u0016lw\u000e^3SK2\fG/\u001b<f!\u0006$\b\u000e\u0003\u0004\u0002\u0018j\u0001\raS\u0001\u0017g\u0016\u0014h/\u001a:M_\u000e\fGn\u0015;bO&tw\rU1uQ\"9\u00111\u0014\u000eA\u0002\u0005u\u0015\u0001\u00034sC\u001elWM\u001c;\u0011\tQ\nyjV\u0005\u0004\u0003C+$AB(qi&|g.A\u0006dY\u0006\u001c8\u000f\\8bI\u0016\u0014XCAAT!\u0011\tI+a,\u000e\u0005\u0005-&bAAW#\u0006!A.\u00198h\u0013\u0011\t\t,a+\u0003\u0017\rc\u0017m]:M_\u0006$WM]\u0001\u0011G2,\u0017M\\+q%\u0016\u001cx.\u001e:dKN$\"!!\u0018\u0002%U\u0004Hn\\1e\u0003J$\u0018NZ1diR{gi\u001d\u000b\u0007\u0003;\nY,!0\t\r\u0005MU\u00041\u0001L\u0011\u0019\t9*\ba\u0001\u0017\u0006y\u0011I\u001d;jM\u0006\u001cG/T1oC\u001e,'\u000f\u0005\u0002H?M\u0019qdM\u001d\u0015\u0005\u0005\u0005\u0017!\u00054pe^\f'\u000f\u001a+p\rN\u0003&/\u001a4jqV\u0011\u00111\u001a\t\u0005\u0003S\u000bi-C\u0002a\u0003W\u000b!CZ8so\u0006\u0014H\rV8G'B\u0013XMZ5yA\u0005I\u0012I\u0015+J\r\u0006\u001bEk\u0018#J%\u0016\u001bEk\u0014*Z?B\u0013VIR%Y\u0003i\t%\u000bV%G\u0003\u000e#v\fR%S\u000b\u000e#vJU-`!J+e)\u0013-!\u0003U\t'\u000f^5gC\u000e$(k\\8u\t&\u0014Xm\u0019;pef\u0004")
public class ArtifactManager
implements Logging {
    private String artifactRootURI;
    private final SparkSession session;
    private final /* synthetic */ Tuple2 x$1;
    private final java.nio.file.Path artifactPath;
    private final String artifactURI;
    private final /* synthetic */ Tuple2 x$2;
    private final java.nio.file.Path classDir;
    private final String classURI;
    private final JobArtifactState state;
    private final CopyOnWriteArrayList<java.nio.file.Path> jarsList;
    private final CopyOnWriteArrayList<String> pythonIncludeList;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String ARTIFACT_DIRECTORY_PREFIX() {
        return ArtifactManager$.MODULE$.ARTIFACT_DIRECTORY_PREFIX();
    }

    public static String forwardToFSPrefix() {
        return ArtifactManager$.MODULE$.forwardToFSPrefix();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public java.nio.file.Path artifactRootPath() {
        return ArtifactManager$.MODULE$.artifactRootDirectory();
    }

    private String artifactRootURI$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if (!this.bitmap$0) {
                this.artifactRootURI = SparkEnv$.MODULE$.get().rpcEnv().fileServer().addDirectoryIfAbsent(ArtifactManager$.MODULE$.ARTIFACT_DIRECTORY_PREFIX(), this.artifactRootPath().toFile());
                this.bitmap$0 = true;
            }
        }
        return this.artifactRootURI;
    }

    public String artifactRootURI() {
        if (!this.bitmap$0) {
            return this.artifactRootURI$lzycompute();
        }
        return this.artifactRootURI;
    }

    public java.nio.file.Path artifactPath() {
        return this.artifactPath;
    }

    public String artifactURI() {
        return this.artifactURI;
    }

    public java.nio.file.Path classDir() {
        return this.classDir;
    }

    public String classURI() {
        return this.classURI;
    }

    public JobArtifactState state() {
        return this.state;
    }

    public <T> T withResources(Function0<T> f) {
        return (T)Utils$.MODULE$.withContextClassLoader(this.classloader(), (Function0 & Serializable)() -> JobArtifactSet$.MODULE$.withActiveJobArtifactState(this.state(), f));
    }

    public CopyOnWriteArrayList<java.nio.file.Path> jarsList() {
        return this.jarsList;
    }

    public CopyOnWriteArrayList<String> pythonIncludeList() {
        return this.pythonIncludeList;
    }

    public Seq<URL> getAddedJars() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jarsList()).asScala().map((Function1 & Serializable)x$3 -> x$3.toUri().toURL())).toSeq();
    }

    public Seq<String> getPythonIncludes() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.pythonIncludeList()).asScala().toSeq();
    }

    public void moveFile(java.nio.file.Path source, java.nio.file.Path target, boolean allowOverwrite) {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        if (allowOverwrite) {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        Files.move(source, target, new CopyOption[0]);
    }

    public boolean moveFile$default$3() {
        return false;
    }

    public void addArtifact(java.nio.file.Path remoteRelativePath, java.nio.file.Path serverLocalStagingPath, Option<String> fragment) {
        Object object = new Object();
        try {
            JobArtifactSet$.MODULE$.withActiveJobArtifactState(this.state(), (Function0 & Serializable)() -> {
                Predef$.MODULE$.require(!remoteRelativePath.isAbsolute());
                if (remoteRelativePath.startsWith("cache" + File.separator)) {
                    File tmpFile = serverLocalStagingPath.toFile();
                    JFunction0.mcZ.sp & Serializable x$12 = (JFunction0.mcZ.sp & Serializable)() -> {
                        BlockManager blockManager = $this.session.sparkContext().env().blockManager();
                        CacheId blockId = new CacheId($this.session.sessionUUID(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)remoteRelativePath).toString()), "cache" + File.separator));
                        BlockManager.TempFileBasedBlockStoreUpdater updater = new BlockManager.TempFileBasedBlockStoreUpdater(blockManager, (BlockId)blockId, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), tmpFile, tmpFile.length(), false, blockManager.TempFileBasedBlockStoreUpdater().apply$default$7());
                        return updater.save();
                    };
                    JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> tmpFile.delete();
                    JFunction0.mcV.sp & Serializable x$3 = () -> ArtifactManager.$anonfun$addArtifact$4((Function0)x$12);
                    return Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$12, (Function0)x$2, (Function0)x$3);
                }
                if (remoteRelativePath.startsWith("classes" + File.separator)) {
                    java.nio.file.Path target = ArtifactUtils$.MODULE$.concatenatePaths(this.classDir(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)remoteRelativePath).toString()), "classes" + File.separator));
                    this.moveFile(serverLocalStagingPath, target, true);
                    return BoxedUnit.UNIT;
                }
                java.nio.file.Path target = ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), remoteRelativePath);
                if (Files.exists(target, new LinkOption[0])) {
                    if (FileUtils.contentEquals((File)target.toFile(), (File)serverLocalStagingPath.toFile())) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    throw new RuntimeException("Duplicate Artifact: " + remoteRelativePath + ". Artifacts cannot be overwritten.");
                }
                this.moveFile(serverLocalStagingPath, target, this.moveFile$default$3());
                String uri = this.artifactURI() + "/" + Utils$.MODULE$.encodeRelativeUnixPathToURIRawPath(FilenameUtils.separatorsToUnix((String)((Object)remoteRelativePath).toString()));
                if (remoteRelativePath.startsWith("jars" + File.separator)) {
                    $this.session.sparkContext().addJar(uri);
                    return BoxesRunTime.boxToBoolean((boolean)this.jarsList().add(target));
                }
                if (remoteRelativePath.startsWith("pyfiles" + File.separator)) {
                    $this.session.sparkContext().addFile(uri);
                    String stringRemotePath = ((Object)remoteRelativePath).toString();
                    if (stringRemotePath.endsWith(".zip") || stringRemotePath.endsWith(".egg") || stringRemotePath.endsWith(".jar")) {
                        return BoxesRunTime.boxToBoolean((boolean)this.pythonIncludeList().add(((Object)target.getFileName()).toString()));
                    }
                    return BoxedUnit.UNIT;
                }
                if (remoteRelativePath.startsWith("archives" + File.separator)) {
                    UriBuilder uriBuilder = UriBuilder.fromUri((URI)new URI(uri));
                    Object canonicalUri = fragment.map((Function1 & Serializable)x$1 -> uriBuilder.fragment(x$1)).getOrElse((Function0 & Serializable)() -> new URI(uri));
                    $this.session.sparkContext().addArchive(canonicalUri.toString());
                    return BoxedUnit.UNIT;
                }
                if (remoteRelativePath.startsWith("files" + File.separator)) {
                    $this.session.sparkContext().addFile(uri);
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public ClassLoader classloader() {
        Seq urls = (Seq)this.getAddedJars().$colon$plus((Object)this.classDir().toUri().toURL());
        Seq prefixes = (Seq)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.CONNECT_SCALA_UDF_STUB_PREFIXES());
        boolean userClasspathFirst = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST()));
        Object loader = prefixes.nonEmpty() ? (userClasspathFirst ? new ChildFirstURLClassLoader((URL[])urls.toArray(ClassTag$.MODULE$.apply(URL.class)), (ClassLoader)StubClassLoader$.MODULE$.apply(Utils$.MODULE$.getContextOrSparkClassLoader(), prefixes)) : new ChildFirstURLClassLoader((URL[])urls.toArray(ClassTag$.MODULE$.apply(URL.class)), (ClassLoader)StubClassLoader$.MODULE$.apply(null, prefixes), Utils$.MODULE$.getContextOrSparkClassLoader())) : (userClasspathFirst ? new ChildFirstURLClassLoader((URL[])urls.toArray(ClassTag$.MODULE$.apply(URL.class)), Utils$.MODULE$.getContextOrSparkClassLoader()) : new URLClassLoader((URL[])urls.toArray(ClassTag$.MODULE$.apply(URL.class)), Utils$.MODULE$.getContextOrSparkClassLoader()));
        this.logDebug((Function0<String>)((Function0 & Serializable)() -> ArtifactManager.$anonfun$classloader$1((URLClassLoader)loader, urls)));
        return loader;
    }

    public void cleanUpResources() {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Cleaning up resources for session with sessionUUID " + $this.session.sessionUUID());
        RpcEnvFileServer fileserver = SparkEnv$.MODULE$.get().rpcEnv().fileServer();
        SparkContext sparkContext = this.session.sparkContext();
        sparkContext.addedFiles().remove((Object)this.state().uuid()).foreach((Function1 & Serializable)x$4 -> {
            ArtifactManager.$anonfun$cleanUpResources$2(fileserver, x$4);
            return BoxedUnit.UNIT;
        });
        sparkContext.addedArchives().remove((Object)this.state().uuid()).foreach((Function1 & Serializable)x$5 -> {
            ArtifactManager.$anonfun$cleanUpResources$4(fileserver, x$5);
            return BoxedUnit.UNIT;
        });
        sparkContext.addedJars().remove((Object)this.state().uuid()).foreach((Function1 & Serializable)x$6 -> {
            ArtifactManager.$anonfun$cleanUpResources$6(fileserver, x$6);
            return BoxedUnit.UNIT;
        });
        BlockManager blockManager = sparkContext.env().blockManager();
        blockManager.removeCache(this.session.sessionUUID());
        FileUtils.deleteDirectory((File)this.artifactPath().toFile());
    }

    public void uploadArtifactToFs(java.nio.file.Path remoteRelativePath, java.nio.file.Path serverLocalStagingPath) {
        boolean allowDestLocalConf;
        Configuration hadoopConf = this.session.sparkContext().hadoopConfiguration();
        Predef$.MODULE$.assert(remoteRelativePath.startsWith(ArtifactManager$.MODULE$.forwardToFSPrefix() + File.separator));
        Path destFSPath = new Path(((Object)Paths.get("/", new String[0]).resolve(remoteRelativePath.subpath(1, remoteRelativePath.getNameCount()))).toString());
        java.nio.file.Path localPath = serverLocalStagingPath;
        FileSystem fs = destFSPath.getFileSystem(hadoopConf);
        if (fs instanceof LocalFileSystem && !(allowDestLocalConf = BoxesRunTime.unboxToBoolean((Object)this.session.conf().get(SQLConf$.MODULE$.ARTIFACT_COPY_FROM_LOCAL_TO_FS_ALLOW_DEST_LOCAL()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.session.conf().get("spark.connect.copyFromLocalToFs.allowDestLocal").contains("true"))))) {
            throw new UnsupportedOperationException("Uploading artifact file to local file system destination path is not supported.");
        }
        fs.copyFromLocalFile(false, true, new Path(((Object)localPath).toString()), destFSPath);
    }

    public static final /* synthetic */ void $anonfun$addArtifact$4(Function0 x$1$1) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(x$1$1);
    }

    public static final /* synthetic */ String $anonfun$classloader$1(URLClassLoader loader$1, Seq urls$1) {
        return "Using class loader: " + loader$1 + ", containing urls: " + urls$1;
    }

    public static final /* synthetic */ void $anonfun$cleanUpResources$2(RpcEnvFileServer fileserver$1, Map x$4) {
        x$4.keys().foreach((Function1 & Serializable)key -> {
            fileserver$1.removeFile(key);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$cleanUpResources$4(RpcEnvFileServer fileserver$1, Map x$5) {
        x$5.keys().foreach((Function1 & Serializable)key -> {
            fileserver$1.removeFile(key);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$cleanUpResources$6(RpcEnvFileServer fileserver$1, Map x$6) {
        x$6.keys().foreach((Function1 & Serializable)key -> {
            fileserver$1.removeJar(key);
            return BoxedUnit.UNIT;
        });
    }

    public ArtifactManager(SparkSession session) {
        this.session = session;
        Logging.$init$((Logging)this);
        Tuple2 tuple2 = new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactRootPath(), session.sessionUUID()), (Object)(this.artifactRootURI() + "/" + session.sessionUUID()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        java.nio.file.Path artifactPath = (java.nio.file.Path)tuple2._1();
        String artifactURI = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)artifactPath, (Object)artifactURI);
        this.artifactPath = (java.nio.file.Path)this.x$1._1();
        this.artifactURI = (String)this.x$1._2();
        Tuple2 tuple22 = new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), "classes"), (Object)(this.artifactURI() + "/classes/"));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        java.nio.file.Path classDir = (java.nio.file.Path)tuple22._1();
        String classURI = (String)tuple22._2();
        this.x$2 = new Tuple2((Object)classDir, (Object)classURI);
        this.classDir = (java.nio.file.Path)this.x$2._1();
        this.classURI = (String)this.x$2._2();
        this.state = new JobArtifactState(session.sessionUUID(), Option$.MODULE$.apply((Object)this.classURI()));
        this.jarsList = new CopyOnWriteArrayList();
        this.pythonIncludeList = new CopyOnWriteArrayList();
    }
}

