/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.ObservationListener;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.CollectMetrics;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\r\u001b\u0001\rB\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\to\u0001\u0011\t\u0011)A\u0005Y!)\u0001\b\u0001C\u0001s!)\u0001\b\u0001C\u0001{!9a\b\u0001b\u0001\n\u0013y\u0004BB\"\u0001A\u0003%\u0001\tC\u0004E\u0001\u0001\u0007I\u0011B#\t\u000fI\u0003\u0001\u0019!C\u0005'\"1\u0011\f\u0001Q!\n\u0019CqA\u0018\u0001A\u0002\u0013%q\fC\u0004h\u0001\u0001\u0007I\u0011\u00025\t\r)\u0004\u0001\u0015)\u0003a\u0011\u0019a\u0007\u0001\"\u0001\u001d[\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA.\u0001\u0011\u0005\u0011Q\f\u0005\t\u0003s\u0002A\u0011\u0001\u000e\u0002|!A\u00111\u0013\u0001\u0005\u0002i\t)\nC\u0004\u0002\u001e\u0002!I!a(\t\u0011\u0005\u0005\u0006\u0001\"\u0001\u001d\u0003G;q!!.\u001b\u0011\u0003\t9L\u0002\u0004\u001a5!\u0005\u0011\u0011\u0018\u0005\u0007qU!\t!a/\t\r\u0005uV\u0003\"\u0001>\u0011\u001d\ti,\u0006C\u0001\u0003\u007f\u00131b\u00142tKJ4\u0018\r^5p]*\u00111\u0004H\u0001\u0004gFd'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0002\t9\fW.Z\u000b\u0002YA\u0011Q\u0006\u000e\b\u0003]I\u0002\"a\f\u0014\u000e\u0003AR!!\r\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0019d%\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a'\u0003\u0015q\u0017-\\3!\u0003\u0019a\u0014N\\5u}Q\u0011!\b\u0010\t\u0003w\u0001i\u0011A\u0007\u0005\u0006U\r\u0001\r\u0001\f\u000b\u0002u\u0005AA.[:uK:,'/F\u0001A!\tY\u0014)\u0003\u0002C5\t\u0019rJY:feZ\fG/[8o\u0019&\u001cH/\u001a8fe\u0006IA.[:uK:,'\u000fI\u0001\fI\u0006$\u0018M\u001a:b[\u0016LE-F\u0001G!\r)s)S\u0005\u0003\u0011\u001a\u0012aa\u00149uS>t\u0007\u0003B\u0013K\u0019>K!a\u0013\u0014\u0003\rQ+\b\u000f\\33!\tYT*\u0003\u0002O5\ta1\u000b]1sWN+7o]5p]B\u0011Q\u0005U\u0005\u0003#\u001a\u0012A\u0001T8oO\u0006yA-\u0019;bMJ\fW.Z%e?\u0012*\u0017\u000f\u0006\u0002U/B\u0011Q%V\u0005\u0003-\u001a\u0012A!\u00168ji\"9\u0001\fCA\u0001\u0002\u00041\u0015a\u0001=%c\u0005aA-\u0019;bMJ\fW.Z%eA!\u0012\u0011b\u0017\t\u0003KqK!!\u0018\u0014\u0003\u0011Y|G.\u0019;jY\u0016\fq!\\3ue&\u001c7/F\u0001a!\r)s)\u0019\t\u0005[\tdC-\u0003\u0002dm\t\u0019Q*\u00199\u0011\u0005\u0015*\u0017B\u00014'\u0005\r\te._\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0002US\"9\u0001lCA\u0001\u0002\u0004\u0001\u0017\u0001C7fiJL7m\u001d\u0011)\u00051Y\u0016AA8o+\tqG\u000fF\u0003pur\f\u0019\u0001E\u0002<aJL!!\u001d\u000e\u0003\u000f\u0011\u000bG/Y:fiB\u00111\u000f\u001e\u0007\u0001\t\u0015)XB1\u0001w\u0005\u0005!\u0016CA<e!\t)\u00030\u0003\u0002zM\t9aj\u001c;iS:<\u0007\"B>\u000e\u0001\u0004y\u0017A\u00013t\u0011\u0015iX\u00021\u0001\u007f\u0003\u0011)\u0007\u0010\u001d:\u0011\u0005mz\u0018bAA\u00015\t11i\u001c7v[:Dq!!\u0002\u000e\u0001\u0004\t9!A\u0003fqB\u00148\u000f\u0005\u0003&\u0003\u0013q\u0018bAA\u0006M\tQAH]3qK\u0006$X\r\u001a \u0002\u0007\u001d,G/\u0006\u0002\u0002\u0012A\"\u00111CA\f!\u0015i#\rLA\u000b!\r\u0019\u0018q\u0003\u0003\u000b\u00033q\u0011\u0011!A\u0001\u0006\u00031(aA0%c!*a\"!\b\u00026A)Q%a\b\u0002$%\u0019\u0011\u0011\u0005\u0014\u0003\rQD'o\\<t!\u0011\t)#a\f\u000f\t\u0005\u001d\u00121\u0006\b\u0004_\u0005%\u0012\"A\u0014\n\u0007\u00055b%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\u0015\u0013:$XM\u001d:vaR,G-\u0012=dKB$\u0018n\u001c8\u000b\u0007\u00055b%\r\u0004\u001fY\u0005]\u0012\u0011L\u0019\nG\u0005e\u0012QHA(\u0003\u007f)2aKA\u001e\t\u0019)(E1\u0001\u0002F%!\u0011qHA!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u00111\t\u0014\u0002\rQD'o\\<t#\r9\u0018q\t\t\u0005\u0003\u0013\nYED\u0002&\u0003WIA!!\u0014\u00024\tIA\u000b\u001b:po\u0006\u0014G.Z\u0019\nG\u0005E\u00131KA+\u0003\u0007r1!JA*\u0013\r\t\u0019EJ\u0019\u0006E\u00152\u0013q\u000b\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005\r\u0012!C4fi\u0006\u001b(*\u0019<b+\t\ty\u0006\u0005\u0004\u0002b\u0005-D\u0006J\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005!Q\u000f^5m\u0015\t\tI'\u0001\u0003kCZ\f\u0017bA2\u0002d!*q\"!\b\u0002pE2a\u0004LA9\u0003o\n\u0014bIA\u001d\u0003{\t\u0019(a\u00102\u0013\r\n\t&a\u0015\u0002v\u0005\r\u0013'\u0002\u0012&M\u0005]\u0013g\u0001\u0014\u0002$\u0005Qq-\u001a;Pe\u0016k\u0007\u000f^=\u0016\u0005\u0005u\u0004\u0007BA@\u0003\u0007\u0003R!\f2-\u0003\u0003\u00032a]AB\t)\t)\tEA\u0001\u0002\u0003\u0015\tA\u001e\u0002\u0004?\u0012\u0012\u0004&\u0002\t\u0002\u001e\u0005%\u0015G\u0002\u0010-\u0003\u0017\u000b\t*M\u0005$\u0003s\ti$!$\u0002@EJ1%!\u0015\u0002T\u0005=\u00151I\u0019\u0006E\u00152\u0013qK\u0019\u0004M\u0005\r\u0012\u0001\u0003:fO&\u001cH/\u001a:\u0015\u000bQ\u000b9*a'\t\r\u0005e\u0015\u00031\u0001M\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o\u0011\u0015!\u0015\u00031\u0001P\u0003))hN]3hSN$XM\u001d\u000b\u0002)\u0006AqN\u001c$j]&\u001c\b\u000eF\u0002U\u0003KCq!a*\u0014\u0001\u0004\tI+\u0001\u0002rKB!\u00111VAY\u001b\t\tiKC\u0002\u00020j\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005M\u0016Q\u0016\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0003-y%m]3sm\u0006$\u0018n\u001c8\u0011\u0005m*2CA\u000b%)\t\t9,A\u0003baBd\u0017\u0010F\u0002;\u0003\u0003DQA\u000b\rA\u00021\u0002")
public class Observation {
    private final String name;
    private final ObservationListener listener;
    private volatile Option<Tuple2<SparkSession, Object>> dataframeId;
    private volatile Option<scala.collection.immutable.Map<String, Object>> metrics;

    public static Observation apply(String name) {
        return Observation$.MODULE$.apply(name);
    }

    public static Observation apply() {
        return Observation$.MODULE$.apply();
    }

    public String name() {
        return this.name;
    }

    private ObservationListener listener() {
        return this.listener;
    }

    private Option<Tuple2<SparkSession, Object>> dataframeId() {
        return this.dataframeId;
    }

    private void dataframeId_$eq(Option<Tuple2<SparkSession, Object>> x$1) {
        this.dataframeId = x$1;
    }

    private Option<scala.collection.immutable.Map<String, Object>> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Option<scala.collection.immutable.Map<String, Object>> x$1) {
        this.metrics = x$1;
    }

    public <T> Dataset<T> on(Dataset<T> ds, Column expr, Seq<Column> exprs) {
        if (ds.isStreaming()) {
            throw new IllegalArgumentException("Observation does not support streaming Datasets.This is because there will be multiple observed metrics as microbatches are constructed. Please register a StreamingQueryListener and get the metric for each microbatch in QueryProgressEvent.progress, or use query.lastProgress or query.recentProgress.");
        }
        this.register(ds.sparkSession(), ds.id());
        return ds.observe(this.name(), expr, exprs);
    }

    public scala.collection.immutable.Map<String, Object> get() throws InterruptedException {
        Observation observation = this;
        synchronized (observation) {
            while (this.metrics().isEmpty()) {
                this.wait();
            }
        }
        return (scala.collection.immutable.Map)this.metrics().get();
    }

    public java.util.Map<String, Object> getAsJava() throws InterruptedException {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)this.get().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return new Tuple2((Object)key, value);
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public synchronized scala.collection.immutable.Map<String, Object> getOrEmpty() throws InterruptedException {
        block0: {
            if (!this.metrics().isEmpty()) break block0;
            this.wait(100L);
        }
        return (scala.collection.immutable.Map)this.metrics().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    public void register(SparkSession sparkSession, long dataframeId) {
        Observation observation = this;
        synchronized (observation) {
            if (this.dataframeId().isDefined()) {
                throw new IllegalArgumentException("An Observation can be used with a Dataset only once");
            }
            this.dataframeId_$eq((Option<Tuple2<SparkSession, Object>>)new Some((Object)new Tuple2((Object)sparkSession, (Object)BoxesRunTime.boxToLong((long)dataframeId))));
        }
        sparkSession.listenerManager().register(this.listener());
    }

    private void unregister() {
        this.dataframeId().foreach((Function1 & Serializable)x$1 -> {
            Observation.$anonfun$unregister$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void onFinish(QueryExecution qe) {
        if (this.metrics().isEmpty() && qe.logical().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Observation.$anonfun$onFinish$1(this, x0$1)))) {
            Option row = qe.observedMetrics().get((Object)this.name());
            this.metrics_$eq((Option<scala.collection.immutable.Map<String, Object>>)row.map((Function1 & Serializable)r -> r.getValuesMap((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)r.schema().fieldNames()).toImmutableArraySeq())));
            if (this.metrics().isDefined()) {
                this.notifyAll();
                this.unregister();
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$unregister$1(Observation $this, Tuple2 x$1) {
        ((SparkSession)x$1._1()).listenerManager().unregister($this.listener());
    }

    public static final /* synthetic */ boolean $anonfun$onFinish$1(Observation $this, LogicalPlan x0$1) {
        LogicalPlan logicalPlan2 = x0$1;
        if (logicalPlan2 instanceof CollectMetrics) {
            CollectMetrics collectMetrics = (CollectMetrics)logicalPlan2;
            String name = collectMetrics.name();
            long dataframeId = collectMetrics.dataframeId();
            String string = name;
            String string2 = $this.name();
            return !(string != null ? !string.equals(string2) : string2 != null) && dataframeId == ((Tuple2)$this.dataframeId().get())._2$mcJ$sp();
        }
        return false;
    }

    public Observation(String name) {
        this.name = name;
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.listener = new ObservationListener(this);
        this.dataframeId = None$.MODULE$;
        this.metrics = None$.MODULE$;
    }

    public Observation() {
        this(UUID.randomUUID().toString());
    }
}

