/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import org.apache.spark.Partition;
import org.apache.spark.SparkClassNotFoundException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.catalyst.xml.XmlOptions$;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.xml.TextInputXmlDataSource$;
import org.apache.spark.sql.execution.datasources.xml.XmlUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001\u0002\u001a4\u0001qB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0007\u001d\u0002!\taM(\t\u000bI\u0003A\u0011A*\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u0005\u0004A\u0011\u00016\t\u000b5\u0004A\u0011\u00018\t\u000b5\u0004A\u0011A:\t\u000b5\u0004A\u0011A=\t\u000b5\u0004A\u0011A@\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u00111\u0002\u0001\u0005\u0002\u0005u\u0001bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003_\u0001A\u0011AA!\u0011\u001d\ty\u0003\u0001C\u0001\u0003\u000fBq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011Q\u0010\u0001\u0005\u0002\u0005M\u0005bBA?\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u001d\t)\r\u0001C\u0001\u0003\u0017Dq!!2\u0001\t\u0003\t\t\u000eC\u0004\u0002F\u0002!\t!!?\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0003\f!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\f\u0001\u0011\u0005!Q\u0004\u0005\b\u0005/\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqA!\u000b\u0001\t\u0003\u0011y\u0003C\u0004\u0003*\u0001!\tA!\u000e\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!1\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\b\u0005\u000f\u0002A\u0011\u0001B'\u0011\u001d\t9\t\u0001C\u0001\u0005'BqA!\u0017\u0001\t\u0003\u0011Y\u0006C\u0004\u0003Z\u0001!\tAa\u0018\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003h!9!Q\r\u0001\u0005\u0002\t-\u0004b\u0002B9\u0001\u0011%!1\u000f\u0005\t+\u0002\u0001\r\u0011\"\u0003\u0003\u0000!I!\u0011\u0011\u0001A\u0002\u0013%!1\u0011\u0005\b\u0005\u0013\u0003\u0001\u0015)\u0003W\u0011%\u0011Y\t\u0001a\u0001\n\u0013\u0011i\tC\u0005\u0003\u0016\u0002\u0001\r\u0011\"\u0003\u0003\u0018\"A!1\u0014\u0001!B\u0013\u0011y\tC\u0005\u0003\u001e\u0002\u0001\r\u0011\"\u0003\u0003 \"I!q\u0016\u0001A\u0002\u0013%!\u0011\u0017\u0005\t\u0005k\u0003\u0001\u0015)\u0003\u0003\"\nyA)\u0019;b\rJ\fW.\u001a*fC\u0012,'O\u0003\u00025k\u0005\u00191/\u001d7\u000b\u0005Y:\u0014!B:qCJ\\'B\u0001\u001d:\u0003\u0019\t\u0007/Y2iK*\t!(A\u0002pe\u001e\u001c\u0001aE\u0002\u0001{\r\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0007C\u0001#H\u001b\u0005)%B\u0001$6\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001%F\u0005\u001daunZ4j]\u001e\fAb\u001d9be.\u001cVm]:j_:\u0004\"a\u0013'\u000e\u0003MJ!!T\u001a\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\t\u0001\u0016\u000b\u0005\u0002L\u0001!)\u0011J\u0001a\u0001\u0015\u00061am\u001c:nCR$\"\u0001\u0015+\t\u000bU\u001b\u0001\u0019\u0001,\u0002\rM|WO]2f!\t9fL\u0004\u0002Y9B\u0011\u0011lP\u0007\u00025*\u00111lO\u0001\u0007yI|w\u000e\u001e \n\u0005u{\u0014A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X \u0002\rM\u001c\u0007.Z7b)\t\u00016\rC\u0003b\t\u0001\u0007A\r\u0005\u0002fQ6\taM\u0003\u0002hg\u0005)A/\u001f9fg&\u0011\u0011N\u001a\u0002\u000b'R\u0014Xo\u0019;UsB,GC\u0001)l\u0011\u0015aW\u00011\u0001W\u00031\u00198\r[3nCN#(/\u001b8h\u0003\u0019y\u0007\u000f^5p]R\u0019\u0001k\\9\t\u000bA4\u0001\u0019\u0001,\u0002\u0007-,\u0017\u0010C\u0003s\r\u0001\u0007a+A\u0003wC2,X\rF\u0002QiVDQ\u0001]\u0004A\u0002YCQA]\u0004A\u0002Y\u0004\"AP<\n\u0005a|$a\u0002\"p_2,\u0017M\u001c\u000b\u0004!j\\\b\"\u00029\t\u0001\u00041\u0006\"\u0002:\t\u0001\u0004a\bC\u0001 ~\u0013\tqxH\u0001\u0003M_:<G#\u0002)\u0002\u0002\u0005\r\u0001\"\u00029\n\u0001\u00041\u0006B\u0002:\n\u0001\u0004\t)\u0001E\u0002?\u0003\u000fI1!!\u0003@\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHc\u0001)\u0002\u0010!9\u00111\u0002\u0006A\u0002\u0005E\u0001CBA\n\u000331f+\u0004\u0002\u0002\u0016)\u0019\u0011qC \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001c\u0005U!aA'baR\u0019\u0001+a\b\t\u000f\u0005-1\u00021\u0001\u0002\"A1\u00111EA\u0017-Zk!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0005kRLGN\u0003\u0002\u0002,\u0005!!.\u0019<b\u0013\u0011\tY\"!\n\u0002\t1|\u0017\r\u001a\u000b\u0003\u0003g\u0001B!!\u000e\u0002<9\u00191*a\u000e\n\u0007\u0005e2'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0012q\b\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!\u000f4)\u0011\t\u0019$a\u0011\t\r\u0005\u0015S\u00021\u0001W\u0003\u0011\u0001\u0018\r\u001e5\u0015\t\u0005M\u0012\u0011\n\u0005\b\u0003\u0017r\u0001\u0019AA'\u0003\u0015\u0001\u0018\r\u001e5t!\u0011q\u0014q\n,\n\u0007\u0005EsH\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3ADA+!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0013\u0011\f\u0002\bm\u0006\u0014\u0018M]4t\u0003eaw.\u00193Vg\u0016\u0014H)\u001a4j]\u0016$G)\u0019;b'>,(oY3\u0015\t\u0005M\u0012Q\r\u0005\b\u0003\u0017z\u0001\u0019AA4!\u0015\tI'!\u001dW\u001d\u0011\tY'a\u001c\u000f\u0007e\u000bi'C\u0001A\u0013\r\tIdP\u0005\u0005\u0003g\n)HA\u0002TKFT1!!\u000f@\u00031aw.\u00193WcM{WO]2f)\u0011\t\u0019$a\u001f\t\u000f\u0005-\u0003\u00031\u0001\u0002N\u0005!!\u000e\u001a2d)!\t\u0019$!!\u0002\u0006\u0006%\u0005BBAB#\u0001\u0007a+A\u0002ve2Da!a\"\u0012\u0001\u00041\u0016!\u0002;bE2,\u0007bBAF#\u0001\u0007\u0011QR\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003BA\u0012\u0003\u001fKA!!%\u0002&\tQ\u0001K]8qKJ$\u0018.Z:\u0015!\u0005M\u0012QSAL\u00033\u000bi*!)\u0002&\u0006=\u0006BBAB%\u0001\u0007a\u000b\u0003\u0004\u0002\bJ\u0001\rA\u0016\u0005\u0007\u00037\u0013\u0002\u0019\u0001,\u0002\u0015\r|G.^7o\u001d\u0006lW\r\u0003\u0004\u0002 J\u0001\r\u0001`\u0001\u000bY><XM\u001d\"pk:$\u0007BBAR%\u0001\u0007A0\u0001\u0006vaB,'OQ8v]\u0012Dq!a*\u0013\u0001\u0004\tI+A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004}\u0005-\u0016bAAW\u007f\t\u0019\u0011J\u001c;\t\u000f\u0005E&\u00031\u0001\u0002\u000e\u0006!2m\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKN$\"\"a\r\u00026\u0006]\u0016\u0011XAb\u0011\u0019\t\u0019i\u0005a\u0001-\"1\u0011qQ\nA\u0002YCq!a/\u0014\u0001\u0004\ti,\u0001\u0006qe\u0016$\u0017nY1uKN\u0004BAPA`-&\u0019\u0011\u0011Y \u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005E6\u00031\u0001\u0002\u000e\u0006!!n]8o)\u0011\t\u0019$!3\t\r\u0005\u0015C\u00031\u0001W)\u0011\t\u0019$!4\t\u000f\u0005-S\u00031\u0001\u0002N!\u001aQ#!\u0016\u0015\t\u0005M\u00121\u001b\u0005\b\u0003+4\u0002\u0019AAl\u0003\u001dQ7o\u001c8S\t\u0012\u0003R!!7\u0002bZk!!a7\u000b\t\u0005-\u0012Q\u001c\u0006\u0004\u0003?,\u0014aA1qS&!\u00111]An\u0005\u001dQ\u0015M^1S\t\u0012C3BFAt\u0003[\fy/a=\u0002vB\u0019a(!;\n\u0007\u0005-xH\u0001\u0006eKB\u0014XmY1uK\u0012\fq!\\3tg\u0006<W-\t\u0002\u0002r\u0006\u0011Sk]3!UN|g\u000e\u000b#bi\u0006\u001cX\r^.TiJLgnZ/*A%t7\u000f^3bI:\nQa]5oG\u0016\f#!a>\u0002\u000bIr#G\f\u0019\u0015\t\u0005M\u00121 \u0005\b\u0003+<\u0002\u0019AA\u007f!\u0015\tyP!\u0002W\u001b\t\u0011\tAC\u0002\u0003\u0004U\n1A\u001d3e\u0013\u0011\u00119A!\u0001\u0003\u0007I#E\tK\u0006\u0018\u0003O\fi/a<\u0002t\u0006UH\u0003BA\u001a\u0005\u001bAqAa\u0004\u0019\u0001\u0004\u0011\t\"A\u0006kg>tG)\u0019;bg\u0016$\b\u0003B&\u0003\u0014YK1A!\u00064\u0005\u001d!\u0015\r^1tKR\f1aY:w)\u0011\t\u0019Da\u0007\t\r\u0005\u0015\u0013\u00041\u0001W)\u0011\t\u0019Da\b\t\u000f\t\u0005\"\u00041\u0001\u0003\u0012\u0005Q1m\u001d<ECR\f7/\u001a;\u0015\t\u0005M\"Q\u0005\u0005\b\u0003\u0017Z\u0002\u0019AA'Q\rY\u0012QK\u0001\u0004q6dG\u0003BA\u001a\u0005[Aa!!\u0012\u001d\u0001\u00041F\u0003BA\u001a\u0005cAq!a\u0013\u001e\u0001\u0004\ti\u0005K\u0002\u001e\u0003+\"B!a\r\u00038!9!\u0011\b\u0010A\u0002\tE\u0011A\u0003=nY\u0012\u000bG/Y:fi\u00069\u0001/\u0019:rk\u0016$H\u0003BA\u001a\u0005\u007fAa!!\u0012 \u0001\u00041F\u0003BA\u001a\u0005\u0007Bq!a\u0013!\u0001\u0004\ti\u0005K\u0002!\u0003+\n1a\u001c:d)\u0011\t\u0019Da\u0013\t\r\u0005\u0015\u0013\u00051\u0001W)\u0011\t\u0019Da\u0014\t\u000f\u0005-#\u00051\u0001\u0002N!\u001a!%!\u0016\u0015\t\u0005M\"Q\u000b\u0005\u0007\u0005/\u001a\u0003\u0019\u0001,\u0002\u0013Q\f'\r\\3OC6,\u0017\u0001\u0002;fqR$B!a\r\u0003^!1\u0011Q\t\u0013A\u0002Y#B!a\r\u0003b!9\u00111J\u0013A\u0002\u00055\u0003fA\u0013\u0002V\u0005AA/\u001a=u\r&dW\r\u0006\u0003\u0003\u0012\t%\u0004BBA#M\u0001\u0007a\u000b\u0006\u0003\u0003\u0012\t5\u0004bBA&O\u0001\u0007\u0011Q\n\u0015\u0004O\u0005U\u0013aF1tg\u0016\u0014HOT8Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b)\u0011\u0011)Ha\u001f\u0011\u0007y\u00129(C\u0002\u0003z}\u0012A!\u00168ji\"1!Q\u0010\u0015A\u0002Y\u000b\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0016\u0003Y\u000b!b]8ve\u000e,w\fJ3r)\u0011\u0011)H!\"\t\u0011\t\u001d%&!AA\u0002Y\u000b1\u0001\u001f\u00132\u0003\u001d\u0019x.\u001e:dK\u0002\n1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006,\"Aa$\u0011\ty\u0012\t\nZ\u0005\u0004\u0005'{$AB(qi&|g.A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017m\u0018\u0013fcR!!Q\u000fBM\u0011%\u00119)LA\u0001\u0002\u0004\u0011y)\u0001\u000bvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\rI\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0005C\u0003RAa)\u0003,Zk!A!*\u000b\t\u0005\u001d\"q\u0015\u0006\u0004\u0005S\u001b\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\t\t5&Q\u0015\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007/\u0001\tfqR\u0014\u0018m\u00149uS>t7o\u0018\u0013fcR!!Q\u000fBZ\u0011%\u00119\tMA\u0001\u0002\u0004\u0011\t+A\u0007fqR\u0014\u0018m\u00149uS>t7\u000f\t\u0015\u0004\u0001\te\u0006\u0003\u0002B^\u0005\u007fk!A!0\u000b\u0007\u0005mS'\u0003\u0003\u0003B\nu&AB*uC\ndW\r")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> xml(String ... paths) {
        return this.xml((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        block0: {
            if (schema == null) break block0;
            StructType replaced = (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)schema);
            this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)replaced));
        }
        return this;
    }

    public DataFrameReader schema(String schemaString) {
        return this.schema(StructType$.MODULE$.fromDDL(schemaString));
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public Dataset<Row> load(String path) {
        if (this.sparkSession.sessionState().conf().legacyPathOptionBehavior()) {
            return this.option("path", path).load((Seq<String>)((Seq)package$.MODULE$.Seq().empty()));
        }
        return this.load((Seq<String>)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> load(Seq<String> paths) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("read");
        }
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        if (!legacyPathOptionBehavior && (this.extraOptions().contains("path") || this.extraOptions().contains("paths")) && paths.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.pathOptionNotSetCorrectlyWhenReadingError();
        }
        boolean isUserDefinedDataSource = this.sparkSession.sessionState().dataSourceManager().dataSourceExists(this.source());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> DataSource$.MODULE$.lookupDataSourceV2(this.source(), $this.sparkSession.sessionState().conf()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Option providerOpt = (Option)success.value();
            if (isUserDefinedDataSource) {
                throw QueryCompilationErrors$.MODULE$.foundMultipleDataSources(this.source());
            }
            return (Dataset)providerOpt.flatMap((Function1 & Serializable)provider -> DataSourceV2Utils$.MODULE$.loadV2Source($this.sparkSession, (TableProvider)provider, this.userSpecifiedSchema(), this.extraOptions(), this.source(), paths)).getOrElse((Function0 & Serializable)() -> this.loadV1Source(paths));
        }
        if (try_ instanceof Failure) {
            boolean isNotFoundError;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Throwable throwable = exception;
            if (throwable instanceof NoClassDefFoundError ? true : throwable instanceof SparkClassNotFoundException) {
                v1 = true;
            } else if (throwable instanceof SparkThrowable) {
                Throwable throwable2 = throwable;
                String string3 = ((SparkThrowable)throwable2).getErrorClass();
                String string4 = "DATA_SOURCE_NOT_FOUND";
                v1 = !(string3 != null ? !string3.equals(string4) : string4 != null);
            } else if (throwable instanceof ServiceConfigurationError) {
                ServiceConfigurationError serviceConfigurationError = (ServiceConfigurationError)throwable;
                v1 = serviceConfigurationError.getCause() instanceof NoClassDefFoundError;
            } else {
                v1 = isNotFoundError = false;
            }
            if (isNotFoundError && isUserDefinedDataSource) {
                return this.loadUserDefinedDataSource(paths);
            }
            throw exception;
        }
        throw new MatchError((Object)try_);
    }

    private Dataset<Row> loadUserDefinedDataSource(Seq<String> paths) {
        Function4<SparkSession, String, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan> builder = this.sparkSession.sessionState().dataSourceManager().lookupDataSource(this.source());
        CaseInsensitiveMap<String> optionsWithPath = DataSourceV2Utils$.MODULE$.getOptionsWithPaths(this.extraOptions(), paths);
        LogicalPlan plan = (LogicalPlan)builder.apply((Object)this.sparkSession, (Object)this.source(), this.userSpecifiedSchema(), optionsWithPath);
        return Dataset$.MODULE$.ofRows(this.sparkSession, plan);
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        Tuple2 tuple2;
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        Tuple2 tuple22 = tuple2 = !legacyPathOptionBehavior && paths.length() == 1 ? new Tuple2((Object)Nil$.MODULE$, (Object)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head()))) : new Tuple2(paths, this.extraOptions());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq finalPaths = (Seq)tuple2._1();
        CaseInsensitiveMap finalOptions = (CaseInsensitiveMap)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)finalPaths, (Object)finalOptions);
        Seq finalPaths2 = (Seq)tuple23._1();
        CaseInsensitiveMap finalOptions2 = (CaseInsensitiveMap)tuple23._2();
        SparkSession x$1 = this.sparkSession;
        Seq x$2 = finalPaths2;
        Option<StructType> x$3 = this.userSpecifiedSchema();
        String x$4 = this.source();
        scala.collection.immutable.Map x$5 = finalOptions2.originalMap();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$4, (Seq<String>)x$2, x$3, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5, x$8);
        boolean x$9 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$9));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(properties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((IterableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table), (List)Nil$.MODULE$))));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)Long.toString(lowerBound)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)Long.toString(upperBound)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)Integer.toString(numPartitions))}))));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        CaseInsensitiveMap params = this.extraOptions().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(connectionProperties).asScala());
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])predicates))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String part = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return new JDBCPartition(part, i);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Partition.class));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> json(Seq<String> paths) {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
        StructType schema2 = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse((Function0 & Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema2, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema2.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$5(parsedOptions, x$2))));
        Function2 & Serializable createParser = (Function2 & Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions, true, JacksonParser$.MODULE$.$lessinit$greater$default$4());
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema2, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema2, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        None$ maybeFirstLine = this.userSpecifiedSchema().isEmpty() || parsedOptions.headerFlag() ? ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))) : None$.MODULE$;
        StructType schema = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse(() -> DataFrameReader.$anonfun$csv$2(this, csvDataset, (Option)maybeFirstLine, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$3(parsedOptions, x$3))));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1 & Serializable)firstLine -> {
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(actualSchema, parsedOptions, "CSV source: " + csvDataset, CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4());
            headerChecker.checkHeaderColumnNames(firstLine);
            return filteredLines.rdd().mapPartitions((Function1 & Serializable)x$4 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$4, (String)firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        }).getOrElse((Function0 & Serializable)() -> filteredLines.rdd());
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> xml(String path) {
        return this.xml((Seq<String>)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> xml(Seq<String> paths) {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
        return this.format("xml").load(paths);
    }

    public Dataset<Row> xml(Dataset<String> xmlDataset) {
        XmlOptions parsedOptions = new XmlOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord(), XmlOptions$.MODULE$.$lessinit$greater$default$4());
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
        StructType schema2 = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse((Function0 & Serializable)() -> TextInputXmlDataSource$.MODULE$.inferFromDataset(xmlDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema2, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema2.filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$xml$5(parsedOptions, x$5))));
        RDD parsed = xmlDataset.rdd().mapPartitions((Function1 & Serializable)iter -> {
            StaxXmlParser rawParser = new StaxXmlParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema2, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, xmlDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema2, xmlDataset.isStreaming());
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        Seq multipartIdentifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(multipartIdentifier, new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.extraOptions().toMap()).asJava()), UnresolvedRelation$.MODULE$.apply$default$3()));
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Nil$.MODULE$).as(this.sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.userSpecifiedSchemaUnsupportedError(operation);
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$json$5(JSONOptions parsedOptions$1, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StructType $anonfun$csv$2(DataFrameReader $this, Dataset csvDataset$1, Option maybeFirstLine$1, CSVOptions parsedOptions$2) {
        return TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset$1, (Option<String>)maybeFirstLine$1, parsedOptions$2);
    }

    public static final /* synthetic */ boolean $anonfun$csv$3(CSVOptions parsedOptions$2, StructField x$3) {
        String string = x$3.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$xml$5(XmlOptions parsedOptions$3, StructField x$5) {
        String string = x$5.name();
        String string2 = parsedOptions$3.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
    }
}

